/* rygel-media-export-item.c generated by valac 0.18.0.2-2c22, the Vala compiler
 * generated from rygel-media-export-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <gst/pbutils/codec-utils.h>
#include <gst/pbutils/descriptions.h>
#include <gst/pbutils/encoding-profile.h>
#include <gst/pbutils/encoding-target.h>
#include <gst/pbutils/gstdiscoverer.h>
#include <gst/pbutils/gstpluginsbaseversion.h>
#include <gst/pbutils/install-plugins.h>
#include <gst/pbutils/missing-plugins.h>
#include <gst/pbutils/pbutils-enumtypes.h>
#include <gst/pbutils/pbutils.h>
#include <gst/gst.h>


#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM (rygel_media_export_photo_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItem))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))

typedef struct _RygelMediaExportPhotoItem RygelMediaExportPhotoItem;
typedef struct _RygelMediaExportPhotoItemClass RygelMediaExportPhotoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};



RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaExportVideoItem* rygel_media_export_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportVideoItem* rygel_media_export_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
RygelMediaExportPhotoItem* rygel_media_export_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPhotoItem* rygel_media_export_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_photo_item_get_type (void) G_GNUC_CONST;
RygelMediaExportMusicItem* rygel_media_export_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportMusicItem* rygel_media_export_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, GFileInfo* file_info);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelMediaExportPhotoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelMediaExportVideoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMediaExportMusicItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info);
void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info);
void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GFileInfo* file_info);
static GDate* _g_date_dup (GDate* self);


RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info) {
	RygelMediaItem* result = NULL;
	GFileInfo* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* title;
	RygelMediaItem* item = NULL;
	GFileInfo* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* mime;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	RygelMediaItem* _tmp28_;
	const gchar* _tmp29_;
	RygelMediaItem* _tmp30_;
	GFileInfo* _tmp31_;
	gint64 _tmp32_ = 0LL;
	RygelMediaItem* _tmp33_;
	GFileInfo* _tmp34_;
	guint64 _tmp35_ = 0ULL;
	RygelMediaItem* _tmp36_;
	GFile* _tmp37_;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_display_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	title = _tmp2_;
	_tmp3_ = info;
	_tmp4_ = g_file_info_get_content_type (_tmp3_);
	_tmp5_ = g_content_type_get_mime_type (_tmp4_);
	mime = _tmp5_;
	_tmp6_ = mime;
	_tmp7_ = g_str_has_prefix (_tmp6_, "video/");
	if (_tmp7_) {
		GFile* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		RygelMediaContainer* _tmp11_;
		const gchar* _tmp12_;
		RygelMediaExportVideoItem* _tmp13_;
		_tmp8_ = file;
		_tmp9_ = rygel_media_export_media_cache_get_id (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = parent;
		_tmp12_ = title;
		_tmp13_ = rygel_media_export_video_item_new (_tmp10_, _tmp11_, _tmp12_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp13_;
		_g_free0 (_tmp10_);
	} else {
		const gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = mime;
		_tmp15_ = g_str_has_prefix (_tmp14_, "image/");
		if (_tmp15_) {
			GFile* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			RygelMediaContainer* _tmp19_;
			const gchar* _tmp20_;
			RygelMediaExportPhotoItem* _tmp21_;
			_tmp16_ = file;
			_tmp17_ = rygel_media_export_media_cache_get_id (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = parent;
			_tmp20_ = title;
			_tmp21_ = rygel_media_export_photo_item_new (_tmp18_, _tmp19_, _tmp20_, RYGEL_PHOTO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp21_;
			_g_free0 (_tmp18_);
		} else {
			GFile* _tmp22_;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			RygelMediaContainer* _tmp25_;
			const gchar* _tmp26_;
			RygelMediaExportMusicItem* _tmp27_;
			_tmp22_ = file;
			_tmp23_ = rygel_media_export_media_cache_get_id (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = parent;
			_tmp26_ = title;
			_tmp27_ = rygel_media_export_music_item_new (_tmp24_, _tmp25_, _tmp26_, RYGEL_MUSIC_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp27_;
			_g_free0 (_tmp24_);
		}
	}
	_tmp28_ = item;
	_tmp29_ = mime;
	rygel_media_item_set_mime_type (_tmp28_, _tmp29_);
	_tmp30_ = item;
	_tmp31_ = info;
	_tmp32_ = g_file_info_get_size (_tmp31_);
	rygel_media_item_set_size (_tmp30_, (gint64) _tmp32_);
	_tmp33_ = item;
	_tmp34_ = info;
	_tmp35_ = g_file_info_get_attribute_uint64 (_tmp34_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp33_, _tmp35_);
	_tmp36_ = item;
	_tmp37_ = file;
	_tmp38_ = g_file_get_uri (_tmp37_);
	_tmp39_ = _tmp38_;
	rygel_media_item_add_uri (_tmp36_, _tmp39_);
	_g_free0 (_tmp39_);
	result = item;
	_g_free0 (mime);
	_g_free0 (title);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaItem* item = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* id;
	GList* audio_streams = NULL;
	GList* video_streams = NULL;
	GUPnPDLNAInformation* _tmp2_;
	GstDiscovererInfo* _tmp3_;
	GstDiscovererInfo* _tmp4_;
	GList* _tmp5_ = NULL;
	GUPnPDLNAInformation* _tmp6_;
	GstDiscovererInfo* _tmp7_;
	GstDiscovererInfo* _tmp8_;
	GList* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GList* _tmp11_;
	gboolean _tmp13_;
	gboolean _tmp17_ = FALSE;
	GList* _tmp18_;
	gboolean _tmp22_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = file;
	_tmp1_ = rygel_media_export_media_cache_get_id (_tmp0_);
	id = _tmp1_;
	_tmp2_ = dlna_info;
	_tmp3_ = gupnp_dlna_information_get_info (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gst_discoverer_info_get_audio_streams (_tmp4_);
	__g_list_free__g_object_unref0_0 (audio_streams);
	audio_streams = (GList*) _tmp5_;
	_tmp6_ = dlna_info;
	_tmp7_ = gupnp_dlna_information_get_info (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gst_discoverer_info_get_video_streams (_tmp8_);
	__g_list_free__g_object_unref0_0 (video_streams);
	video_streams = (GList*) _tmp9_;
	_tmp11_ = audio_streams;
	if (_tmp11_ == NULL) {
		GList* _tmp12_;
		_tmp12_ = video_streams;
		_tmp10_ = _tmp12_ == NULL;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp13_ = _tmp10_;
	if (_tmp13_) {
		GFile* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		_tmp14_ = file;
		_tmp15_ = g_file_get_uri (_tmp14_);
		_tmp16_ = _tmp15_;
		g_debug ("%s had neither audio nor video/picture " "streams. Ignoring.", _tmp16_);
		_g_free0 (_tmp16_);
		result = NULL;
		__g_list_free__g_object_unref0_0 (video_streams);
		__g_list_free__g_object_unref0_0 (audio_streams);
		_g_free0 (id);
		_g_object_unref0 (item);
		return result;
	}
	_tmp18_ = audio_streams;
	if (_tmp18_ == NULL) {
		GList* _tmp19_;
		gconstpointer _tmp20_;
		gboolean _tmp21_ = FALSE;
		_tmp19_ = video_streams;
		_tmp20_ = _tmp19_->data;
		_tmp21_ = gst_discoverer_video_info_is_image ((GstDiscovererVideoInfo*) _tmp20_);
		_tmp17_ = _tmp21_;
	} else {
		_tmp17_ = FALSE;
	}
	_tmp22_ = _tmp17_;
	if (_tmp22_) {
		const gchar* _tmp23_;
		RygelMediaContainer* _tmp24_;
		RygelMediaExportPhotoItem* _tmp25_;
		RygelMediaItem* _tmp26_;
		GFile* _tmp27_;
		GUPnPDLNAInformation* _tmp28_;
		GList* _tmp29_;
		gconstpointer _tmp30_;
		GFileInfo* _tmp31_;
		RygelMediaItem* _tmp32_ = NULL;
		_tmp23_ = id;
		_tmp24_ = parent;
		_tmp25_ = rygel_media_export_photo_item_new (_tmp23_, _tmp24_, "", RYGEL_PHOTO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp25_;
		_tmp26_ = item;
		_tmp27_ = file;
		_tmp28_ = dlna_info;
		_tmp29_ = video_streams;
		_tmp30_ = _tmp29_->data;
		_tmp31_ = file_info;
		_tmp32_ = rygel_media_export_item_factory_fill_photo_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM) ? ((RygelMediaExportPhotoItem*) _tmp26_) : NULL, _tmp27_, _tmp28_, (GstDiscovererVideoInfo*) _tmp30_, _tmp31_);
		result = _tmp32_;
		__g_list_free__g_object_unref0_0 (video_streams);
		__g_list_free__g_object_unref0_0 (audio_streams);
		_g_free0 (id);
		_g_object_unref0 (item);
		return result;
	} else {
		GList* _tmp33_;
		_tmp33_ = video_streams;
		if (_tmp33_ != NULL) {
			const gchar* _tmp34_;
			RygelMediaContainer* _tmp35_;
			RygelMediaExportVideoItem* _tmp36_;
			GstDiscovererAudioInfo* _tmp37_;
			GstDiscovererAudioInfo* audio_info;
			GList* _tmp38_;
			RygelMediaItem* _tmp42_;
			GFile* _tmp43_;
			GUPnPDLNAInformation* _tmp44_;
			GList* _tmp45_;
			gconstpointer _tmp46_;
			GstDiscovererAudioInfo* _tmp47_;
			GFileInfo* _tmp48_;
			RygelMediaItem* _tmp49_ = NULL;
			_tmp34_ = id;
			_tmp35_ = parent;
			_tmp36_ = rygel_media_export_video_item_new (_tmp34_, _tmp35_, "", RYGEL_VIDEO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp36_;
			_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (NULL, gst_discoverer_audio_info_get_type ()) ? ((GstDiscovererAudioInfo*) NULL) : NULL);
			audio_info = _tmp37_;
			_tmp38_ = audio_streams;
			if (_tmp38_ != NULL) {
				GList* _tmp39_;
				gconstpointer _tmp40_;
				GstDiscovererAudioInfo* _tmp41_;
				_tmp39_ = audio_streams;
				_tmp40_ = _tmp39_->data;
				_tmp41_ = _g_object_ref0 ((GstDiscovererAudioInfo*) _tmp40_);
				_g_object_unref0 (audio_info);
				audio_info = _tmp41_;
			}
			_tmp42_ = item;
			_tmp43_ = file;
			_tmp44_ = dlna_info;
			_tmp45_ = video_streams;
			_tmp46_ = _tmp45_->data;
			_tmp47_ = audio_info;
			_tmp48_ = file_info;
			_tmp49_ = rygel_media_export_item_factory_fill_video_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM) ? ((RygelMediaExportVideoItem*) _tmp42_) : NULL, _tmp43_, _tmp44_, (GstDiscovererVideoInfo*) _tmp46_, _tmp47_, _tmp48_);
			result = _tmp49_;
			_g_object_unref0 (audio_info);
			__g_list_free__g_object_unref0_0 (video_streams);
			__g_list_free__g_object_unref0_0 (audio_streams);
			_g_free0 (id);
			_g_object_unref0 (item);
			return result;
		} else {
			GList* _tmp50_;
			_tmp50_ = audio_streams;
			if (_tmp50_ != NULL) {
				const gchar* _tmp51_;
				RygelMediaContainer* _tmp52_;
				RygelMediaExportMusicItem* _tmp53_;
				RygelMediaItem* _tmp54_;
				GFile* _tmp55_;
				GUPnPDLNAInformation* _tmp56_;
				GList* _tmp57_;
				gconstpointer _tmp58_;
				GFileInfo* _tmp59_;
				RygelMediaItem* _tmp60_ = NULL;
				_tmp51_ = id;
				_tmp52_ = parent;
				_tmp53_ = rygel_media_export_music_item_new (_tmp51_, _tmp52_, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaItem*) _tmp53_;
				_tmp54_ = item;
				_tmp55_ = file;
				_tmp56_ = dlna_info;
				_tmp57_ = audio_streams;
				_tmp58_ = _tmp57_->data;
				_tmp59_ = file_info;
				_tmp60_ = rygel_media_export_item_factory_fill_music_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp54_) : NULL, _tmp55_, _tmp56_, (GstDiscovererAudioInfo*) _tmp58_, _tmp59_);
				result = _tmp60_;
				__g_list_free__g_object_unref0_0 (video_streams);
				__g_list_free__g_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			} else {
				result = NULL;
				__g_list_free__g_object_unref0_0 (video_streams);
				__g_list_free__g_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			}
		}
	}
	__g_list_free__g_object_unref0_0 (video_streams);
	__g_list_free__g_object_unref0_0 (audio_streams);
	_g_free0 (id);
	_g_object_unref0 (item);
}


void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info) {
	GUPnPDLNAInformation* _tmp0_;
	GstDiscovererInfo* _tmp1_;
	GstDiscovererInfo* _tmp2_;
	GstClockTime _tmp3_ = 0ULL;
	GstDiscovererAudioInfo* _tmp10_;
	g_return_if_fail (item != NULL);
	g_return_if_fail (dlna_info != NULL);
	_tmp0_ = dlna_info;
	_tmp1_ = gupnp_dlna_information_get_info (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gst_discoverer_info_get_duration (_tmp2_);
	if (_tmp3_ > ((GstClockTime) 0)) {
		RygelAudioItem* _tmp4_;
		GUPnPDLNAInformation* _tmp5_;
		GstDiscovererInfo* _tmp6_;
		GstDiscovererInfo* _tmp7_;
		GstClockTime _tmp8_ = 0ULL;
		_tmp4_ = item;
		_tmp5_ = dlna_info;
		_tmp6_ = gupnp_dlna_information_get_info (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gst_discoverer_info_get_duration (_tmp7_);
		rygel_audio_item_set_duration (_tmp4_, (glong) (_tmp8_ / GST_SECOND));
	} else {
		RygelAudioItem* _tmp9_;
		_tmp9_ = item;
		rygel_audio_item_set_duration (_tmp9_, (glong) (-1));
	}
	_tmp10_ = audio_info;
	if (_tmp10_ != NULL) {
		GstDiscovererAudioInfo* _tmp11_;
		GstTagList* _tmp12_ = NULL;
		RygelAudioItem* _tmp18_;
		GstDiscovererAudioInfo* _tmp19_;
		guint _tmp20_ = 0U;
		RygelAudioItem* _tmp21_;
		GstDiscovererAudioInfo* _tmp22_;
		guint _tmp23_ = 0U;
		_tmp11_ = audio_info;
		_tmp12_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp11_);
		if (_tmp12_ != NULL) {
			guint tmp = 0U;
			GstDiscovererAudioInfo* _tmp13_;
			GstTagList* _tmp14_ = NULL;
			guint _tmp15_ = 0U;
			RygelAudioItem* _tmp16_;
			guint _tmp17_;
			_tmp13_ = audio_info;
			_tmp14_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp13_);
			gst_tag_list_get_uint (_tmp14_, GST_TAG_BITRATE, &_tmp15_);
			tmp = _tmp15_;
			_tmp16_ = item;
			_tmp17_ = tmp;
			rygel_audio_item_set_bitrate (_tmp16_, ((gint) _tmp17_) / 8);
		}
		_tmp18_ = item;
		_tmp19_ = audio_info;
		_tmp20_ = gst_discoverer_audio_info_get_channels (_tmp19_);
		rygel_audio_item_set_channels (_tmp18_, (gint) _tmp20_);
		_tmp21_ = item;
		_tmp22_ = audio_info;
		_tmp23_ = gst_discoverer_audio_info_get_sample_rate (_tmp22_);
		rygel_audio_item_set_sample_freq (_tmp21_, (gint) _tmp23_);
	}
}


RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelMediaExportVideoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportVideoItem* _tmp0_;
	GUPnPDLNAInformation* _tmp1_;
	GstDiscovererAudioInfo* _tmp2_;
	RygelMediaExportVideoItem* _tmp3_;
	GFile* _tmp4_;
	GUPnPDLNAInformation* _tmp5_;
	GFileInfo* _tmp6_;
	RygelMediaExportVideoItem* _tmp7_;
	GstDiscovererVideoInfo* _tmp8_;
	guint _tmp9_ = 0U;
	RygelMediaExportVideoItem* _tmp10_;
	GstDiscovererVideoInfo* _tmp11_;
	guint _tmp12_ = 0U;
	GstDiscovererVideoInfo* _tmp13_;
	guint _tmp14_ = 0U;
	gint color_depth;
	gint _tmp15_ = 0;
	gint _tmp16_;
	RygelMediaExportVideoItem* _tmp18_;
	gint _tmp19_;
	RygelMediaExportVideoItem* _tmp20_;
	RygelMediaItem* _tmp21_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = dlna_info;
	_tmp2_ = audio_info;
	rygel_media_export_item_factory_fill_audio_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = file;
	_tmp5_ = dlna_info;
	_tmp6_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	_tmp7_ = item;
	_tmp8_ = video_info;
	_tmp9_ = gst_discoverer_video_info_get_width (_tmp8_);
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp7_, (gint) _tmp9_);
	_tmp10_ = item;
	_tmp11_ = video_info;
	_tmp12_ = gst_discoverer_video_info_get_height (_tmp11_);
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp10_, (gint) _tmp12_);
	_tmp13_ = video_info;
	_tmp14_ = gst_discoverer_video_info_get_depth (_tmp13_);
	color_depth = (gint) _tmp14_;
	_tmp16_ = color_depth;
	if (_tmp16_ == 0) {
		_tmp15_ = -1;
	} else {
		gint _tmp17_;
		_tmp17_ = color_depth;
		_tmp15_ = _tmp17_;
	}
	_tmp18_ = item;
	_tmp19_ = _tmp15_;
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp18_, _tmp19_);
	_tmp20_ = item;
	_tmp21_ = _g_object_ref0 ((RygelMediaItem*) _tmp20_);
	result = _tmp21_;
	return result;
}


RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelMediaExportPhotoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportPhotoItem* _tmp0_;
	GFile* _tmp1_;
	GUPnPDLNAInformation* _tmp2_;
	GFileInfo* _tmp3_;
	RygelMediaExportPhotoItem* _tmp4_;
	GstDiscovererVideoInfo* _tmp5_;
	guint _tmp6_ = 0U;
	RygelMediaExportPhotoItem* _tmp7_;
	GstDiscovererVideoInfo* _tmp8_;
	guint _tmp9_ = 0U;
	GstDiscovererVideoInfo* _tmp10_;
	guint _tmp11_ = 0U;
	gint color_depth;
	gint _tmp12_ = 0;
	gint _tmp13_;
	RygelMediaExportPhotoItem* _tmp15_;
	gint _tmp16_;
	RygelMediaExportPhotoItem* _tmp17_;
	RygelMediaItem* _tmp18_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = file;
	_tmp2_ = dlna_info;
	_tmp3_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	_tmp4_ = item;
	_tmp5_ = video_info;
	_tmp6_ = gst_discoverer_video_info_get_width (_tmp5_);
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp4_, (gint) _tmp6_);
	_tmp7_ = item;
	_tmp8_ = video_info;
	_tmp9_ = gst_discoverer_video_info_get_height (_tmp8_);
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp7_, (gint) _tmp9_);
	_tmp10_ = video_info;
	_tmp11_ = gst_discoverer_video_info_get_depth (_tmp10_);
	color_depth = (gint) _tmp11_;
	_tmp13_ = color_depth;
	if (_tmp13_ == 0) {
		_tmp12_ = -1;
	} else {
		gint _tmp14_;
		_tmp14_ = color_depth;
		_tmp12_ = _tmp14_;
	}
	_tmp15_ = item;
	_tmp16_ = _tmp12_;
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp15_, _tmp16_);
	_tmp17_ = item;
	_tmp18_ = _g_object_ref0 ((RygelMediaItem*) _tmp17_);
	result = _tmp18_;
	return result;
}


RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMediaExportMusicItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportMusicItem* _tmp0_;
	GUPnPDLNAInformation* _tmp1_;
	GstDiscovererAudioInfo* _tmp2_;
	RygelMediaExportMusicItem* _tmp3_;
	GFile* _tmp4_;
	GUPnPDLNAInformation* _tmp5_;
	GFileInfo* _tmp6_;
	GstDiscovererAudioInfo* _tmp7_;
	gchar* artist = NULL;
	GUPnPDLNAInformation* _tmp10_;
	GstDiscovererInfo* _tmp11_;
	GstDiscovererInfo* _tmp12_;
	GstTagList* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	RygelMediaExportMusicItem* _tmp15_;
	const gchar* _tmp16_;
	gchar* album = NULL;
	GUPnPDLNAInformation* _tmp17_;
	GstDiscovererInfo* _tmp18_;
	GstDiscovererInfo* _tmp19_;
	GstTagList* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	RygelMediaExportMusicItem* _tmp22_;
	const gchar* _tmp23_;
	gchar* genre = NULL;
	GUPnPDLNAInformation* _tmp24_;
	GstDiscovererInfo* _tmp25_;
	GstDiscovererInfo* _tmp26_;
	GstTagList* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	RygelMediaExportMusicItem* _tmp29_;
	const gchar* _tmp30_;
	guint tmp = 0U;
	GUPnPDLNAInformation* _tmp31_;
	GstDiscovererInfo* _tmp32_;
	GstDiscovererInfo* _tmp33_;
	GstTagList* _tmp34_ = NULL;
	guint _tmp35_ = 0U;
	RygelMediaExportMusicItem* _tmp36_;
	guint _tmp37_;
	GUPnPDLNAInformation* _tmp38_;
	GstDiscovererInfo* _tmp39_;
	GstDiscovererInfo* _tmp40_;
	GstTagList* _tmp41_ = NULL;
	guint _tmp42_ = 0U;
	RygelMediaExportMusicItem* _tmp43_;
	guint _tmp44_;
	GstDiscovererAudioInfo* _tmp45_;
	GstTagList* _tmp46_ = NULL;
	RygelMediaExportMusicItem* _tmp49_;
	RygelMediaItem* _tmp50_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = dlna_info;
	_tmp2_ = audio_info;
	rygel_media_export_item_factory_fill_audio_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = file;
	_tmp5_ = dlna_info;
	_tmp6_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	_tmp7_ = audio_info;
	if (_tmp7_ == NULL) {
		RygelMediaExportMusicItem* _tmp8_;
		RygelMediaItem* _tmp9_;
		_tmp8_ = item;
		_tmp9_ = _g_object_ref0 ((RygelMediaItem*) _tmp8_);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = dlna_info;
	_tmp11_ = gupnp_dlna_information_get_info (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = gst_discoverer_info_get_tags (_tmp12_);
	gst_tag_list_get_string (_tmp13_, GST_TAG_ARTIST, &_tmp14_);
	_g_free0 (artist);
	artist = _tmp14_;
	_tmp15_ = item;
	_tmp16_ = artist;
	rygel_music_item_set_artist ((RygelMusicItem*) _tmp15_, _tmp16_);
	_tmp17_ = dlna_info;
	_tmp18_ = gupnp_dlna_information_get_info (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = gst_discoverer_info_get_tags (_tmp19_);
	gst_tag_list_get_string (_tmp20_, GST_TAG_ALBUM, &_tmp21_);
	_g_free0 (album);
	album = _tmp21_;
	_tmp22_ = item;
	_tmp23_ = album;
	rygel_music_item_set_album ((RygelMusicItem*) _tmp22_, _tmp23_);
	_tmp24_ = dlna_info;
	_tmp25_ = gupnp_dlna_information_get_info (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = gst_discoverer_info_get_tags (_tmp26_);
	gst_tag_list_get_string (_tmp27_, GST_TAG_GENRE, &_tmp28_);
	_g_free0 (genre);
	genre = _tmp28_;
	_tmp29_ = item;
	_tmp30_ = genre;
	rygel_music_item_set_genre ((RygelMusicItem*) _tmp29_, _tmp30_);
	_tmp31_ = dlna_info;
	_tmp32_ = gupnp_dlna_information_get_info (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = gst_discoverer_info_get_tags (_tmp33_);
	gst_tag_list_get_uint (_tmp34_, GST_TAG_ALBUM_VOLUME_NUMBER, &_tmp35_);
	tmp = _tmp35_;
	_tmp36_ = item;
	_tmp37_ = tmp;
	_tmp36_->disc = (gint) _tmp37_;
	_tmp38_ = dlna_info;
	_tmp39_ = gupnp_dlna_information_get_info (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = gst_discoverer_info_get_tags (_tmp40_);
	gst_tag_list_get_uint (_tmp41_, GST_TAG_TRACK_NUMBER, &_tmp42_);
	tmp = _tmp42_;
	_tmp43_ = item;
	_tmp44_ = tmp;
	rygel_music_item_set_track_number ((RygelMusicItem*) _tmp43_, (gint) _tmp44_);
	_tmp45_ = audio_info;
	_tmp46_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp45_);
	if (_tmp46_ == NULL) {
		RygelMediaExportMusicItem* _tmp47_;
		RygelMediaItem* _tmp48_;
		_tmp47_ = item;
		_tmp48_ = _g_object_ref0 ((RygelMediaItem*) _tmp47_);
		result = _tmp48_;
		_g_free0 (genre);
		_g_free0 (album);
		_g_free0 (artist);
		return result;
	}
	_tmp49_ = item;
	_tmp50_ = _g_object_ref0 ((RygelMediaItem*) _tmp49_);
	result = _tmp50_;
	_g_free0 (genre);
	_g_free0 (album);
	_g_free0 (artist);
	return result;
}


static GDate* _g_date_dup (GDate* self) {
	GDate* dup;
	dup = g_new0 (GDate, 1);
	memcpy (dup, self, sizeof (GDate));
	return dup;
}


static gpointer __g_date_dup0 (gpointer self) {
	return self ? _g_date_dup (self) : NULL;
}


void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GFileInfo* file_info) {
	gchar* title;
	gboolean _tmp0_ = FALSE;
	GUPnPDLNAInformation* _tmp1_;
	GstDiscovererInfo* _tmp2_;
	GstDiscovererInfo* _tmp3_;
	GstTagList* _tmp4_ = NULL;
	gboolean _tmp11_;
	RygelMediaItem* _tmp15_;
	const gchar* _tmp16_;
	GUPnPDLNAInformation* _tmp17_;
	GstDiscovererInfo* _tmp18_;
	GstDiscovererInfo* _tmp19_;
	GstTagList* _tmp20_ = NULL;
	GFileInfo* _tmp38_;
	guint64 _tmp39_ = 0ULL;
	guint64 mtime;
	RygelMediaItem* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	RygelMediaItem* _tmp48_;
	GFileInfo* _tmp49_;
	gint64 _tmp50_ = 0LL;
	RygelMediaItem* _tmp51_;
	guint64 _tmp52_;
	GUPnPDLNAInformation* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	RygelMediaItem* _tmp69_;
	GFile* _tmp70_;
	gchar* _tmp71_ = NULL;
	gchar* _tmp72_;
	g_return_if_fail (item != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (dlna_info != NULL);
	g_return_if_fail (file_info != NULL);
	title = NULL;
	_tmp1_ = dlna_info;
	_tmp2_ = gupnp_dlna_information_get_info (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gst_discoverer_info_get_tags (_tmp3_);
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GUPnPDLNAInformation* _tmp5_;
		GstDiscovererInfo* _tmp6_;
		GstDiscovererInfo* _tmp7_;
		GstTagList* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp5_ = dlna_info;
		_tmp6_ = gupnp_dlna_information_get_info (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gst_discoverer_info_get_tags (_tmp7_);
		_tmp10_ = gst_tag_list_get_string (_tmp8_, GST_TAG_TITLE, &_tmp9_);
		_g_free0 (title);
		title = _tmp9_;
		_tmp0_ = !_tmp10_;
	}
	_tmp11_ = _tmp0_;
	if (_tmp11_) {
		GFileInfo* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		_tmp12_ = file_info;
		_tmp13_ = g_file_info_get_display_name (_tmp12_);
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (title);
		title = _tmp14_;
	}
	_tmp15_ = item;
	_tmp16_ = title;
	rygel_media_object_set_title ((RygelMediaObject*) _tmp15_, _tmp16_);
	_tmp17_ = dlna_info;
	_tmp18_ = gupnp_dlna_information_get_info (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = gst_discoverer_info_get_tags (_tmp19_);
	if (_tmp20_ != NULL) {
		GDate* date = NULL;
		gboolean _tmp21_ = FALSE;
		GUPnPDLNAInformation* _tmp22_;
		GstDiscovererInfo* _tmp23_;
		GstDiscovererInfo* _tmp24_;
		GstTagList* _tmp25_ = NULL;
		GDate _tmp26_ = {0};
		gboolean _tmp27_ = FALSE;
		GDate _tmp28_;
		GDate* _tmp29_;
		gboolean _tmp32_;
		_tmp22_ = dlna_info;
		_tmp23_ = gupnp_dlna_information_get_info (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = gst_discoverer_info_get_tags (_tmp24_);
		_tmp27_ = gst_tag_list_get_date (_tmp25_, GST_TAG_DATE, &_tmp26_);
		_g_free0 (date);
		_tmp28_ = _tmp26_;
		_tmp29_ = __g_date_dup0 (&_tmp28_);
		date = _tmp29_;
		if (_tmp27_) {
			GDate* _tmp30_;
			gboolean _tmp31_ = FALSE;
			_tmp30_ = date;
			_tmp31_ = g_date_valid (_tmp30_);
			_tmp21_ = _tmp31_;
		} else {
			_tmp21_ = FALSE;
		}
		_tmp32_ = _tmp21_;
		if (_tmp32_) {
			gchar* _tmp33_ = NULL;
			gchar* datestr;
			gint datestr_length1;
			gint _datestr_size_;
			GDate* _tmp34_;
			gchar* _tmp35_;
			gint _tmp35__length1;
			RygelMediaItem* _tmp36_;
			gchar* _tmp37_;
			gint _tmp37__length1;
			_tmp33_ = g_new0 (gchar, 30);
			datestr = _tmp33_;
			datestr_length1 = 30;
			_datestr_size_ = datestr_length1;
			_tmp34_ = date;
			_tmp35_ = datestr;
			_tmp35__length1 = datestr_length1;
			g_date_strftime (_tmp35_, _tmp35__length1, "%F", _tmp34_);
			_tmp36_ = item;
			_tmp37_ = datestr;
			_tmp37__length1 = datestr_length1;
			rygel_media_item_set_date (_tmp36_, (const gchar*) _tmp37_);
			datestr = (g_free (datestr), NULL);
		}
		_g_free0 (date);
	}
	_tmp38_ = file_info;
	_tmp39_ = g_file_info_get_attribute_uint64 (_tmp38_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	mtime = _tmp39_;
	_tmp40_ = item;
	_tmp41_ = rygel_media_item_get_date (_tmp40_);
	_tmp42_ = _tmp41_;
	if (_tmp42_ == NULL) {
		guint64 _tmp43_;
		GTimeVal _tmp44_ = {0};
		GTimeVal tv;
		RygelMediaItem* _tmp45_;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_;
		_tmp43_ = mtime;
		_tmp44_.tv_sec = (glong) _tmp43_;
		_tmp44_.tv_usec = (glong) 0;
		tv = _tmp44_;
		_tmp45_ = item;
		_tmp46_ = g_time_val_to_iso8601 (&tv);
		_tmp47_ = _tmp46_;
		rygel_media_item_set_date (_tmp45_, _tmp47_);
		_g_free0 (_tmp47_);
	}
	_tmp48_ = item;
	_tmp49_ = file_info;
	_tmp50_ = g_file_info_get_size (_tmp49_);
	rygel_media_item_set_size (_tmp48_, (gint64) _tmp50_);
	_tmp51_ = item;
	_tmp52_ = mtime;
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp51_, (guint64) ((gint64) _tmp52_));
	_tmp53_ = dlna_info;
	_tmp54_ = gupnp_dlna_information_get_name (_tmp53_);
	_tmp55_ = _tmp54_;
	if (_tmp55_ != NULL) {
		RygelMediaItem* _tmp56_;
		GUPnPDLNAInformation* _tmp57_;
		const gchar* _tmp58_;
		const gchar* _tmp59_;
		RygelMediaItem* _tmp60_;
		GUPnPDLNAInformation* _tmp61_;
		const gchar* _tmp62_;
		const gchar* _tmp63_;
		_tmp56_ = item;
		_tmp57_ = dlna_info;
		_tmp58_ = gupnp_dlna_information_get_name (_tmp57_);
		_tmp59_ = _tmp58_;
		rygel_media_item_set_dlna_profile (_tmp56_, _tmp59_);
		_tmp60_ = item;
		_tmp61_ = dlna_info;
		_tmp62_ = gupnp_dlna_information_get_mime (_tmp61_);
		_tmp63_ = _tmp62_;
		rygel_media_item_set_mime_type (_tmp60_, _tmp63_);
	} else {
		RygelMediaItem* _tmp64_;
		GFileInfo* _tmp65_;
		const gchar* _tmp66_ = NULL;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_;
		_tmp64_ = item;
		_tmp65_ = file_info;
		_tmp66_ = g_file_info_get_content_type (_tmp65_);
		_tmp67_ = g_content_type_get_mime_type (_tmp66_);
		_tmp68_ = _tmp67_;
		rygel_media_item_set_mime_type (_tmp64_, _tmp68_);
		_g_free0 (_tmp68_);
	}
	_tmp69_ = item;
	_tmp70_ = file;
	_tmp71_ = g_file_get_uri (_tmp70_);
	_tmp72_ = _tmp71_;
	rygel_media_item_add_uri (_tmp69_, _tmp72_);
	_g_free0 (_tmp72_);
	_g_free0 (title);
}



