/* rygel-http-item-uri.c generated by valac 0.18.0.2-2c22, the Vala compiler
 * generated from rygel-http-item-uri.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Jens Georg <mail@jensge.org>
 *          Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                                <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_VISUAL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemClass))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_IS_VISUAL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemClass))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemClass RygelVisualItemClass;
typedef struct _RygelVisualItemPrivate RygelVisualItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
#define _rygel_thumbnail_unref0(var) ((var == NULL) ? NULL : (var = (rygel_thumbnail_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

struct _RygelHTTPItemURIPrivate {
	gchar* _item_id;
	gint _thumbnail_index;
	gint _subtitle_index;
	gchar* _transcode_target;
	RygelHTTPServer* _http_server;
	gchar* real_extension;
};

struct _RygelMediaItem {
	GObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* id;
	GeeArrayList* uris;
	gchar* mime_type;
};

struct _RygelMediaItemClass {
	GObjectClass parent_class;
};

struct _RygelVisualItem {
	RygelMediaItem parent_instance;
	RygelVisualItemPrivate * priv;
	GeeArrayList* thumbnails;
};

struct _RygelVisualItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelThumbnail {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelThumbnailPrivate * priv;
	gchar* file_extension;
};

struct _RygelThumbnailClass {
	GTypeClass parent_class;
	void (*finalize) (RygelThumbnail *self);
};

struct _RygelMusicItem {
	RygelMediaItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVideoItem {
	RygelVisualItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelVisualItemClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
	gchar* caption_type;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};


static gpointer rygel_http_item_uri_parent_class = NULL;
extern GeeHashMap* rygel_http_item_uri_mime_to_ext;
GeeHashMap* rygel_http_item_uri_mime_to_ext = NULL;

GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_ITEM_URI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIPrivate))
enum  {
	RYGEL_HTTP_ITEM_URI_DUMMY_PROPERTY,
	RYGEL_HTTP_ITEM_URI_ITEM_ID,
	RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX,
	RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX,
	RYGEL_HTTP_ITEM_URI_TRANSCODE_TARGET,
	RYGEL_HTTP_ITEM_URI_HTTP_SERVER,
	RYGEL_HTTP_ITEM_URI_EXTENSION
};
GType rygel_media_item_get_type (void) G_GNUC_CONST;
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
void rygel_http_item_uri_set_item_id (RygelHTTPItemURI* self, const gchar* value);
void rygel_http_item_uri_set_thumbnail_index (RygelHTTPItemURI* self, gint value);
void rygel_http_item_uri_set_subtitle_index (RygelHTTPItemURI* self, gint value);
void rygel_http_item_uri_set_transcode_target (RygelHTTPItemURI* self, const gchar* value);
void rygel_http_item_uri_set_http_server (RygelHTTPItemURI* self, RygelHTTPServer* value);
void rygel_http_item_uri_set_extension (RygelHTTPItemURI* self, const gchar* value);
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
RygelHTTPServer* rygel_http_item_uri_get_http_server (RygelHTTPItemURI* self);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error);
const gchar* rygel_transcoder_get_extension (RygelTranscoder* self);
gchar* rygel_http_item_uri_get_extension (RygelHTTPItemURI* self);
static gchar* rygel_http_item_uri_ext_from_mime_type (RygelHTTPItemURI* self, const gchar* mime_type);
GQuark rygel_http_request_error_quark (void);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
const gchar* rygel_http_item_uri_get_item_id (RygelHTTPItemURI* self);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
const gchar* rygel_http_item_uri_get_transcode_target (RygelHTTPItemURI* self);
gint rygel_http_item_uri_get_thumbnail_index (RygelHTTPItemURI* self);
gint rygel_http_item_uri_get_subtitle_index (RygelHTTPItemURI* self);
static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path);
static void rygel_http_item_uri_finalize (GObject* obj);
static void _vala_rygel_http_item_uri_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_item_uri_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 64 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return self ? g_object_ref (self) : NULL;
#line 307 "rygel-http-item-uri.c"
}


static gpointer _rygel_thumbnail_ref0 (gpointer self) {
#line 70 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return self ? rygel_thumbnail_ref (self) : NULL;
#line 314 "rygel-http-item-uri.c"
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
#line 894 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 894 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 895 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 895 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 895 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 895 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 897 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 897 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 341 "rygel-http-item-uri.c"
		gchar* _tmp4_;
#line 898 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 898 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 898 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 349 "rygel-http-item-uri.c"
	} else {
#line 900 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = -1;
#line 900 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 355 "rygel-http-item-uri.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1144 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1144 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 379 "rygel-http-item-uri.c"
		glong _tmp4_;
#line 1145 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1145 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1145 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 387 "rygel-http-item-uri.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 399 "rygel-http-item-uri.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1154 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 424 "rygel-http-item-uri.c"
		glong _tmp2_;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 430 "rygel-http-item-uri.c"
	} else {
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 434 "rygel-http-item-uri.c"
	}
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 440 "rygel-http-item-uri.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 452 "rygel-http-item-uri.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1160 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1160 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1160 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 462 "rygel-http-item-uri.c"
	}
#line 1163 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1163 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 468 "rygel-http-item-uri.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1164 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1164 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1164 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1165 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1165 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 482 "rygel-http-item-uri.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1167 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1167 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1167 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 492 "rygel-http-item-uri.c"
	}
#line 1169 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1169 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 498 "rygel-http-item-uri.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1170 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1170 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1170 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 507 "rygel-http-item-uri.c"
	}
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	return result;
#line 527 "rygel-http-item-uri.c"
}


RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	RygelHTTPItemURI * self = NULL;
	RygelMediaItem* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* _tmp4_;
	RygelHTTPServer* _tmp5_;
	gint _tmp6_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gboolean _tmp51_;
	GError * _inner_error_ = NULL;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = item;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp1_ = _tmp0_->id;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_item_id (self, _tmp1_);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp2_ = thumbnail_index;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_thumbnail_index (self, _tmp2_);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3_ = subtitle_index;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_subtitle_index (self, _tmp3_);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp4_ = transcode_target;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_transcode_target (self, _tmp4_);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp5_ = http_server;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_http_server (self, _tmp5_);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_extension (self, "");
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp6_ = thumbnail_index;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp6_ > (-1)) {
#line 579 "rygel-http-item-uri.c"
		RygelMediaItem* _tmp7_;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp7_ = item;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_VISUAL_ITEM)) {
#line 585 "rygel-http-item-uri.c"
			RygelMediaItem* _tmp8_;
			GeeArrayList* _tmp9_;
			GeeArrayList* _tmp10_;
			GeeArrayList* thumbnails;
			GeeArrayList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp8_ = item;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp9_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp8_) : NULL)->thumbnails;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp10_ = _g_object_ref0 (_tmp9_);
#line 64 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			thumbnails = _tmp10_;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp11_ = thumbnails;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp13_ = _tmp12_;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp14_ = thumbnail_index;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			if (_tmp13_ > _tmp14_) {
#line 612 "rygel-http-item-uri.c"
				GeeArrayList* _tmp15_;
				gint _tmp16_;
				gpointer _tmp17_ = NULL;
				RygelThumbnail* _tmp18_;
				const gchar* _tmp19_;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp15_ = thumbnails;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp16_ = thumbnail_index;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp18_ = (RygelThumbnail*) _tmp17_;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp19_ = _tmp18_->file_extension;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				rygel_http_item_uri_set_extension (self, _tmp19_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_rygel_thumbnail_unref0 (_tmp18_);
#line 632 "rygel-http-item-uri.c"
			}
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_object_unref0 (thumbnails);
#line 636 "rygel-http-item-uri.c"
		} else {
			RygelMediaItem* _tmp20_;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp20_ = item;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, RYGEL_TYPE_MUSIC_ITEM)) {
#line 643 "rygel-http-item-uri.c"
				RygelMediaItem* _tmp21_;
				RygelThumbnail* _tmp22_;
				RygelThumbnail* _tmp23_;
				RygelThumbnail* album_art;
				RygelThumbnail* _tmp24_;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp21_ = item;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp22_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp21_) : NULL)->album_art;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp23_ = _rygel_thumbnail_ref0 (_tmp22_);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				album_art = _tmp23_;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp24_ = album_art;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (_tmp24_ != NULL) {
#line 661 "rygel-http-item-uri.c"
					RygelThumbnail* _tmp25_;
					const gchar* _tmp26_;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp25_ = album_art;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp26_ = _tmp25_->file_extension;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					rygel_http_item_uri_set_extension (self, _tmp26_);
#line 670 "rygel-http-item-uri.c"
				}
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_rygel_thumbnail_unref0 (album_art);
#line 674 "rygel-http-item-uri.c"
			}
		}
	} else {
		gint _tmp27_;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp27_ = subtitle_index;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		if (_tmp27_ > (-1)) {
#line 683 "rygel-http-item-uri.c"
			RygelMediaItem* _tmp28_;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp28_ = item;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, RYGEL_TYPE_VIDEO_ITEM)) {
#line 689 "rygel-http-item-uri.c"
				RygelMediaItem* _tmp29_;
				GeeArrayList* _tmp30_;
				GeeArrayList* _tmp31_;
				GeeArrayList* subtitles;
				GeeArrayList* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
#line 78 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp29_ = item;
#line 78 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp30_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp29_) : NULL)->subtitles;
#line 78 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp31_ = _g_object_ref0 (_tmp30_);
#line 78 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				subtitles = _tmp31_;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp32_ = subtitles;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp33_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp32_);
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp34_ = _tmp33_;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp35_ = subtitle_index;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (_tmp34_ > _tmp35_) {
#line 716 "rygel-http-item-uri.c"
					GeeArrayList* _tmp36_;
					gint _tmp37_;
					gpointer _tmp38_ = NULL;
					RygelSubtitle* _tmp39_;
					const gchar* _tmp40_;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp36_ = subtitles;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp37_ = subtitle_index;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, _tmp37_);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp39_ = (RygelSubtitle*) _tmp38_;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp40_ = _tmp39_->caption_type;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					rygel_http_item_uri_set_extension (self, _tmp40_);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_object_unref0 (_tmp39_);
#line 736 "rygel-http-item-uri.c"
				}
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_g_object_unref0 (subtitles);
#line 740 "rygel-http-item-uri.c"
			}
		} else {
			const gchar* _tmp41_;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp41_ = transcode_target;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			if (_tmp41_ != NULL) {
#line 748 "rygel-http-item-uri.c"
				{
					RygelHTTPServer* _tmp42_;
					const gchar* _tmp43_;
					RygelTranscoder* _tmp44_ = NULL;
					RygelTranscoder* tc;
					RygelTranscoder* _tmp45_;
					const gchar* _tmp46_;
					const gchar* _tmp47_;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp42_ = self->priv->_http_server;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp43_ = transcode_target;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp44_ = rygel_http_server_get_transcoder (_tmp42_, _tmp43_, &_inner_error_);
#line 86 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					tc = _tmp44_;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					if (_inner_error_ != NULL) {
#line 767 "rygel-http-item-uri.c"
						goto __catch3_g_error;
					}
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp45_ = tc;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp46_ = rygel_transcoder_get_extension (_tmp45_);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp47_ = _tmp46_;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					rygel_http_item_uri_set_extension (self, _tmp47_);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_object_unref0 (tc);
#line 780 "rygel-http-item-uri.c"
				}
				goto __finally3;
				__catch3_g_error:
				{
					GError* _error_ = NULL;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_error_ = _inner_error_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_inner_error_ = NULL;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_error_free0 (_error_);
#line 792 "rygel-http-item-uri.c"
				}
				__finally3:
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (_inner_error_ != NULL) {
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					g_clear_error (&_inner_error_);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					return NULL;
#line 803 "rygel-http-item-uri.c"
				}
			}
		}
	}
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp48_ = rygel_http_item_uri_get_extension (self);
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp49_ = _tmp48_;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp50_ = _tmp49_;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp51_ = g_strcmp0 (_tmp50_, "") == 0;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (_tmp50_);
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp51_) {
#line 820 "rygel-http-item-uri.c"
		gchar* _tmp52_;
		gchar* uri_extension;
		const gchar* _tmp73_;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp52_ = g_strdup ("");
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		uri_extension = _tmp52_;
#line 828 "rygel-http-item-uri.c"
		{
			RygelMediaItem* _tmp53_;
			GeeArrayList* _tmp54_;
			GeeArrayList* _tmp55_;
			GeeArrayList* _uri_string_list;
			GeeArrayList* _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			gint _uri_string_size;
			gint _uri_string_index;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp53_ = item;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp54_ = _tmp53_->uris;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp55_ = _g_object_ref0 (_tmp54_);
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_uri_string_list = _tmp55_;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp56_ = _uri_string_list;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp57_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp56_);
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp58_ = _tmp57_;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_uri_string_size = _tmp58_;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_uri_string_index = -1;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			while (TRUE) {
#line 859 "rygel-http-item-uri.c"
				gint _tmp59_;
				gint _tmp60_;
				gint _tmp61_;
				GeeArrayList* _tmp62_;
				gint _tmp63_;
				gpointer _tmp64_ = NULL;
				gchar* uri_string;
				const gchar* _tmp65_;
				gchar* _tmp66_ = NULL;
				gchar* basename;
				const gchar* _tmp67_;
				gint _tmp68_ = 0;
				gint dot_index;
				gint _tmp69_;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp59_ = _uri_string_index;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_uri_string_index = _tmp59_ + 1;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp60_ = _uri_string_index;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp61_ = _uri_string_size;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (!(_tmp60_ < _tmp61_)) {
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					break;
#line 886 "rygel-http-item-uri.c"
				}
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp62_ = _uri_string_list;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp63_ = _uri_string_index;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp64_ = gee_abstract_list_get ((GeeAbstractList*) _tmp62_, _tmp63_);
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				uri_string = (gchar*) _tmp64_;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp65_ = uri_string;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp66_ = g_path_get_basename (_tmp65_);
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				basename = _tmp66_;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp67_ = basename;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp68_ = string_last_index_of (_tmp67_, ".", 0);
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				dot_index = _tmp68_;
#line 99 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp69_ = dot_index;
#line 99 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (_tmp69_ > (-1)) {
#line 912 "rygel-http-item-uri.c"
					const gchar* _tmp70_;
					gint _tmp71_;
					gchar* _tmp72_ = NULL;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp70_ = basename;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp71_ = dot_index;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp72_ = string_substring (_tmp70_, (glong) (_tmp71_ + 1), (glong) (-1));
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_free0 (uri_extension);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					uri_extension = _tmp72_;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_free0 (basename);
#line 102 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_free0 (uri_string);
#line 102 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					break;
#line 932 "rygel-http-item-uri.c"
				}
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_g_free0 (basename);
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_g_free0 (uri_string);
#line 938 "rygel-http-item-uri.c"
			}
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_object_unref0 (_uri_string_list);
#line 942 "rygel-http-item-uri.c"
		}
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp73_ = uri_extension;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		if (g_strcmp0 (_tmp73_, "") == 0) {
#line 948 "rygel-http-item-uri.c"
			RygelMediaItem* _tmp74_;
			const gchar* _tmp75_;
			gchar* _tmp76_ = NULL;
			gchar* _tmp77_;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp74_ = item;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp75_ = _tmp74_->mime_type;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp76_ = rygel_http_item_uri_ext_from_mime_type (self, _tmp75_);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp77_ = _tmp76_;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			rygel_http_item_uri_set_extension (self, _tmp77_);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (_tmp77_);
#line 965 "rygel-http-item-uri.c"
		} else {
			const gchar* _tmp78_;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp78_ = uri_extension;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			rygel_http_item_uri_set_extension (self, _tmp78_);
#line 972 "rygel-http-item-uri.c"
		}
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_free0 (uri_extension);
#line 976 "rygel-http-item-uri.c"
	}
#line 50 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return self;
#line 980 "rygel-http-item-uri.c"
}


RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
#line 50 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return rygel_http_item_uri_construct (RYGEL_TYPE_HTTP_ITEM_URI, item, http_server, thumbnail_index, subtitle_index, transcode_target);
#line 987 "rygel-http-item-uri.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1228 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1228 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1228 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1000 "rygel-http-item-uri.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1030 "rygel-http-item-uri.c"
				goto __catch4_g_regex_error;
			}
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			return NULL;
#line 1039 "rygel-http-item-uri.c"
		}
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1055 "rygel-http-item-uri.c"
				goto __catch4_g_regex_error;
			}
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			return NULL;
#line 1066 "rygel-http-item-uri.c"
		}
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 1074 "rygel-http-item-uri.c"
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1233 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1088 "rygel-http-item-uri.c"
	}
	__finally4:
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return NULL;
#line 1099 "rygel-http-item-uri.c"
	}
}


RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error) {
	RygelHTTPItemURI * self = NULL;
	RygelHTTPServer* _tmp0_;
	const gchar* _tmp1_;
	RygelHTTPServer* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* request_uri;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_ = NULL;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gboolean _tmp12_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** _tmp17_;
	gint _tmp17__length1;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* last_part;
	const gchar* _tmp20_;
	gint _tmp21_ = 0;
	gint dot_index;
	gint _tmp22_;
	const gchar* _tmp70_;
	GError * _inner_error_ = NULL;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_thumbnail_index (self, -1);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_subtitle_index (self, -1);
#line 120 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_transcode_target (self, NULL);
#line 121 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = http_server;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_http_server (self, _tmp0_);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_extension (self, "");
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp1_ = uri;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp2_ = http_server;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3_ = rygel_http_server_get_path_root (_tmp2_);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp4_ = _tmp3_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp5_ = string_replace (_tmp1_, _tmp4_, "");
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	request_uri = _tmp5_;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp6_ = request_uri;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "/", 0);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	parts = _tmp8_;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	parts_length1 = _vala_array_length (_tmp7_);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_parts_size_ = parts_length1;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp10_ = parts;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp10__length1 = parts_length1;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp10__length1 < 2) {
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp9_ = TRUE;
#line 1184 "rygel-http-item-uri.c"
	} else {
		gchar** _tmp11_;
		gint _tmp11__length1;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp11_ = parts;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp11__length1 = parts_length1;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp9_ = (_tmp11__length1 % 2) == 0;
#line 1194 "rygel-http-item-uri.c"
	}
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp12_ = _tmp9_;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp12_) {
#line 1200 "rygel-http-item-uri.c"
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		GError* _tmp15_;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp13_ = _ ("Invalid URI '%s'");
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp14_ = request_uri;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp15_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _tmp13_, _tmp14_);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_inner_error_ = _tmp15_;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_propagate_error (error, _inner_error_);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_object_unref0 (self);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			return NULL;
#line 1224 "rygel-http-item-uri.c"
		} else {
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_clear_error (&_inner_error_);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			return NULL;
#line 1236 "rygel-http-item-uri.c"
		}
	}
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp16_ = parts;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp16__length1 = parts_length1;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp17_ = parts;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp17__length1 = parts_length1;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp18_ = _tmp16_[_tmp17__length1 - 1];
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp19_ = g_strdup (_tmp18_);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	last_part = _tmp19_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp20_ = last_part;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp21_ = string_last_index_of (_tmp20_, ".", 0);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	dot_index = _tmp21_;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp22_ = dot_index;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp22_ > (-1)) {
#line 1263 "rygel-http-item-uri.c"
		const gchar* _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		gchar** _tmp27_;
		gint _tmp27__length1;
		gchar** _tmp28_;
		gint _tmp28__length1;
		const gchar* _tmp29_;
		gint _tmp30_;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp23_ = last_part;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp24_ = dot_index;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp25_ = string_substring (_tmp23_, (glong) (_tmp24_ + 1), (glong) (-1));
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp26_ = _tmp25_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_extension (self, _tmp26_);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_free0 (_tmp26_);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp27_ = parts;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp27__length1 = parts_length1;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp28_ = parts;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp28__length1 = parts_length1;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp29_ = last_part;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp30_ = dot_index;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp31_ = string_substring (_tmp29_, (glong) 0, (glong) _tmp30_);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_free0 (_tmp27_[_tmp28__length1 - 1]);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp27_[_tmp28__length1 - 1] = _tmp31_;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp32_ = _tmp27_[_tmp28__length1 - 1];
#line 1308 "rygel-http-item-uri.c"
	}
	{
		gint i;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		i = 1;
#line 1314 "rygel-http-item-uri.c"
		{
			gboolean _tmp33_;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp33_ = TRUE;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			while (TRUE) {
#line 1321 "rygel-http-item-uri.c"
				gboolean _tmp34_;
				gint _tmp36_;
				gchar** _tmp37_;
				gint _tmp37__length1;
				gchar** _tmp38_;
				gint _tmp38__length1;
				gint _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				GQuark _tmp43_ = 0U;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				static GQuark _tmp42_label0 = 0;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				static GQuark _tmp42_label1 = 0;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				static GQuark _tmp42_label2 = 0;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				static GQuark _tmp42_label3 = 0;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp34_ = _tmp33_;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (!_tmp34_) {
#line 1344 "rygel-http-item-uri.c"
					gint _tmp35_;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp35_ = i;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					i = _tmp35_ + 2;
#line 1350 "rygel-http-item-uri.c"
				}
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp33_ = FALSE;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp36_ = i;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp37_ = parts;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp37__length1 = parts_length1;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (!(_tmp36_ < (_tmp37__length1 - 1))) {
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					break;
#line 1364 "rygel-http-item-uri.c"
				}
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp38_ = parts;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp38__length1 = parts_length1;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp39_ = i;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp40_ = _tmp38_[_tmp39_];
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp41_ = _tmp40_;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp43_ = (NULL == _tmp41_) ? 0 : g_quark_from_string (_tmp41_);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (_tmp43_ == ((0 != _tmp42_label0) ? _tmp42_label0 : (_tmp42_label0 = g_quark_from_static_string ("i")))) {
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					switch (0) {
#line 1382 "rygel-http-item-uri.c"
						default:
						{
							gchar** _tmp44_;
							gint _tmp44__length1;
							gint _tmp45_;
							const gchar* _tmp46_;
							gchar* _tmp47_ = NULL;
							gchar* _tmp48_;
							size_t _tmp49_;
							guchar* _tmp50_ = NULL;
							guchar* _tmp51_;
							gint _tmp51__length1;
							guchar* data;
							gint data_length1;
							gint _data_size_;
							GString* _tmp52_;
							GString* builder;
							GString* _tmp53_;
							guchar* _tmp54_;
							gint _tmp54__length1;
							GString* _tmp55_;
							const gchar* _tmp56_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp44_ = parts;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp44__length1 = parts_length1;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp45_ = i;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp46_ = _tmp44_[_tmp45_ + 1];
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp47_ = soup_uri_decode (_tmp46_);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp48_ = _tmp47_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp50_ = g_base64_decode (_tmp48_, &_tmp49_);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp51_ = _tmp50_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp51__length1 = _tmp49_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_g_free0 (_tmp48_);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							data = _tmp51_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							data_length1 = _tmp51__length1;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_data_size_ = data_length1;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp52_ = g_string_new ("");
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							builder = _tmp52_;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp53_ = builder;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp54_ = data;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp54__length1 = data_length1;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							g_string_append (_tmp53_, (const gchar*) _tmp54_);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp55_ = builder;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp56_ = _tmp55_->str;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							rygel_http_item_uri_set_item_id (self, _tmp56_);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_g_string_free0 (builder);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							data = (g_free (data), NULL);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							break;
#line 1455 "rygel-http-item-uri.c"
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label1) ? _tmp42_label1 : (_tmp42_label1 = g_quark_from_static_string ("tr")))) {
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					switch (0) {
#line 1461 "rygel-http-item-uri.c"
						default:
						{
							gchar** _tmp57_;
							gint _tmp57__length1;
							gint _tmp58_;
							const gchar* _tmp59_;
							gchar* _tmp60_ = NULL;
							gchar* _tmp61_;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp57_ = parts;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp57__length1 = parts_length1;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp58_ = i;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp59_ = _tmp57_[_tmp58_ + 1];
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp60_ = soup_uri_decode (_tmp59_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp61_ = _tmp60_;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							rygel_http_item_uri_set_transcode_target (self, _tmp61_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_g_free0 (_tmp61_);
#line 152 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							break;
#line 1488 "rygel-http-item-uri.c"
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label2) ? _tmp42_label2 : (_tmp42_label2 = g_quark_from_static_string ("th")))) {
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					switch (0) {
#line 1494 "rygel-http-item-uri.c"
						default:
						{
							gchar** _tmp62_;
							gint _tmp62__length1;
							gint _tmp63_;
							const gchar* _tmp64_;
							gint _tmp65_ = 0;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp62_ = parts;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp62__length1 = parts_length1;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp63_ = i;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp64_ = _tmp62_[_tmp63_ + 1];
#line 154 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp65_ = atoi (_tmp64_);
#line 154 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							rygel_http_item_uri_set_thumbnail_index (self, _tmp65_);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							break;
#line 1516 "rygel-http-item-uri.c"
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label3) ? _tmp42_label3 : (_tmp42_label3 = g_quark_from_static_string ("sub")))) {
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					switch (0) {
#line 1522 "rygel-http-item-uri.c"
						default:
						{
							gchar** _tmp66_;
							gint _tmp66__length1;
							gint _tmp67_;
							const gchar* _tmp68_;
							gint _tmp69_ = 0;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp66_ = parts;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp66__length1 = parts_length1;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp67_ = i;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp68_ = _tmp66_[_tmp67_ + 1];
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp69_ = atoi (_tmp68_);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							rygel_http_item_uri_set_subtitle_index (self, _tmp69_);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							break;
#line 1544 "rygel-http-item-uri.c"
						}
					}
				} else {
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					switch (0) {
#line 1550 "rygel-http-item-uri.c"
						default:
						{
#line 162 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							break;
#line 1555 "rygel-http-item-uri.c"
						}
					}
				}
			}
		}
	}
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp70_ = self->priv->_item_id;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp70_ == NULL) {
#line 1566 "rygel-http-item-uri.c"
		const gchar* _tmp71_ = NULL;
		GError* _tmp72_;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp71_ = _ ("Not Found");
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp72_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp71_);
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_inner_error_ = _tmp72_;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_propagate_error (error, _inner_error_);
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (last_part);
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_object_unref0 (self);
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			return NULL;
#line 1589 "rygel-http-item-uri.c"
		} else {
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (last_part);
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_clear_error (&_inner_error_);
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			return NULL;
#line 1603 "rygel-http-item-uri.c"
		}
	}
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (last_part);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (request_uri);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return self;
#line 1614 "rygel-http-item-uri.c"
}


RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error) {
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return rygel_http_item_uri_construct_from_string (RYGEL_TYPE_HTTP_ITEM_URI, uri, http_server, error);
#line 1621 "rygel-http-item-uri.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
#line 1253 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1255 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1255 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1256 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1256 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1256 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1256 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1256 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 1676 "rygel-http-item-uri.c"
	}
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	return result;
#line 1682 "rygel-http-item-uri.c"
}


gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* data;
	gint data_length1;
	gint _data_size_;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* escaped;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* path;
	const gchar* _tmp10_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_ = NULL;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->_item_id;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	data = _tmp2_;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	data_length1 = _tmp1_;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_data_size_ = data_length1;
#line 176 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3_ = data;
#line 176 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3__length1 = data_length1;
#line 176 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp4_ = g_base64_encode ((guchar*) _tmp3_, (_tmp3__length1 * sizeof (gchar)) / sizeof (guchar));
#line 176 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp5_ = _tmp4_;
#line 176 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp6_ = g_uri_escape_string (_tmp5_, "", TRUE);
#line 176 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp7_ = _tmp6_;
#line 176 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (_tmp5_);
#line 176 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	escaped = _tmp7_;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp8_ = escaped;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp9_ = g_strconcat ("/i/", _tmp8_, NULL);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	path = _tmp9_;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp10_ = self->priv->_transcode_target;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp10_ != NULL) {
#line 1750 "rygel-http-item-uri.c"
		const gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp11_ = self->priv->_transcode_target;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp12_ = g_uri_escape_string (_tmp11_, "", TRUE);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_free0 (escaped);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		escaped = _tmp12_;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp13_ = path;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp14_ = escaped;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp15_ = g_strconcat ("/tr/", _tmp14_, NULL);
#line 183 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp16_ = _tmp15_;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
#line 183 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_free0 (path);
#line 183 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		path = _tmp17_;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_free0 (_tmp16_);
#line 1782 "rygel-http-item-uri.c"
	} else {
		gint _tmp18_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp18_ = self->priv->_thumbnail_index;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		if (_tmp18_ >= 0) {
#line 1789 "rygel-http-item-uri.c"
			const gchar* _tmp19_;
			gint _tmp20_;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp19_ = path;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp20_ = self->priv->_thumbnail_index;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp21_ = g_strdup_printf ("%i", _tmp20_);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp22_ = _tmp21_;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp23_ = g_strconcat ("/th/", _tmp22_, NULL);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp24_ = _tmp23_;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp25_ = g_strconcat (_tmp19_, _tmp24_, NULL);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (path);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			path = _tmp25_;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (_tmp24_);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (_tmp22_);
#line 1819 "rygel-http-item-uri.c"
		} else {
			gint _tmp26_;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp26_ = self->priv->_subtitle_index;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			if (_tmp26_ >= 0) {
#line 1826 "rygel-http-item-uri.c"
				const gchar* _tmp27_;
				gint _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp27_ = path;
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp28_ = self->priv->_subtitle_index;
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp29_ = g_strdup_printf ("%i", _tmp28_);
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp30_ = _tmp29_;
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp31_ = g_strconcat ("/sub/", _tmp30_, NULL);
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp32_ = _tmp31_;
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp33_ = g_strconcat (_tmp27_, _tmp32_, NULL);
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_g_free0 (path);
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				path = _tmp33_;
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_g_free0 (_tmp32_);
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_g_free0 (_tmp30_);
#line 1856 "rygel-http-item-uri.c"
			}
		}
	}
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp34_ = path;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp35_ = rygel_http_item_uri_get_extension (self);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp36_ = _tmp35_;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp37_ = _tmp36_;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp38_ = g_strconcat (_tmp34_, _tmp37_, NULL);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (path);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	path = _tmp38_;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (_tmp37_);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp39_ = path;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp40_ = rygel_http_item_uri_create_uri_for_path (self, _tmp39_);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	result = _tmp40_;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (path);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (escaped);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	data = (g_free (data), NULL);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return result;
#line 1890 "rygel-http-item-uri.c"
}


static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path) {
	gchar* result = NULL;
	RygelHTTPServer* _tmp0_;
	GUPnPContext* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelHTTPServer* _tmp4_;
	GUPnPContext* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	RygelHTTPServer* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->_http_server;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp1_ = _tmp0_->context;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp2_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp1_);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3_ = _tmp2_;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp4_ = self->priv->_http_server;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp5_ = _tmp4_->context;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp6_ = gupnp_context_get_port (_tmp5_);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp7_ = _tmp6_;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp8_ = self->priv->_http_server;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp9_ = rygel_http_server_get_path_root (_tmp8_);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp10_ = _tmp9_;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp11_ = path;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp12_ = g_strdup_printf ("http://%s:%u%s%s", _tmp3_, _tmp7_, _tmp10_, _tmp11_);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	result = _tmp12_;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return result;
#line 1943 "rygel-http-item-uri.c"
}


static gchar* rygel_http_item_uri_ext_from_mime_type (RygelHTTPItemURI* self, const gchar* mime_type) {
	gchar* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp28_;
	const gchar* _tmp29_;
	gboolean _tmp30_ = FALSE;
	gchar* _tmp34_;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 200 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = rygel_http_item_uri_mime_to_ext;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp0_ == NULL) {
#line 1962 "rygel-http-item-uri.c"
		GeeHashMap* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_ = NULL;
		gchar** videos;
		gint videos_length1;
		gint _videos_size_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		GeeHashMap* _tmp13_;
		GeeHashMap* _tmp14_;
		GeeHashMap* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar** _tmp18_ = NULL;
		gchar** images;
		gint images_length1;
		gint _images_size_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		GeeHashMap* _tmp26_;
		GeeHashMap* _tmp27_;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_object_unref0 (rygel_http_item_uri_mime_to_ext);
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		rygel_http_item_uri_mime_to_ext = _tmp1_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp2_ = g_strdup ("mpeg");
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp3_ = g_strdup ("webm");
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp4_ = g_strdup ("ogg");
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp5_ = g_new0 (gchar*, 3 + 1);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp5_[0] = _tmp2_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp5_[1] = _tmp3_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp5_[2] = _tmp4_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		videos = _tmp5_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		videos_length1 = 3;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_videos_size_ = videos_length1;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp6_ = videos;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp6__length1 = videos_length1;
#line 2016 "rygel-http-item-uri.c"
		{
			gchar** video_collection = NULL;
			gint video_collection_length1 = 0;
			gint _video_collection_size_ = 0;
			gint video_it = 0;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			video_collection = _tmp6_;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			video_collection_length1 = _tmp6__length1;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			for (video_it = 0; video_it < _tmp6__length1; video_it = video_it + 1) {
#line 2028 "rygel-http-item-uri.c"
				gchar* _tmp7_;
				gchar* video = NULL;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp7_ = g_strdup (video_collection[video_it]);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				video = _tmp7_;
#line 2035 "rygel-http-item-uri.c"
				{
					GeeHashMap* _tmp8_;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					const gchar* _tmp12_;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp8_ = rygel_http_item_uri_mime_to_ext;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp9_ = video;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp10_ = g_strconcat ("video/", _tmp9_, NULL);
#line 207 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp11_ = _tmp10_;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp12_ = video;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp11_, _tmp12_);
#line 207 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_free0 (_tmp11_);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_free0 (video);
#line 2058 "rygel-http-item-uri.c"
				}
			}
		}
#line 209 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp13_ = rygel_http_item_uri_mime_to_ext;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, "video/x-matroska", "mkv");
#line 212 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp14_ = rygel_http_item_uri_mime_to_ext;
#line 212 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, "audio/x-wav", "wav");
#line 213 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp15_ = rygel_http_item_uri_mime_to_ext;
#line 213 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "audio/x-matroska", "mka");
#line 216 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp16_ = g_strdup ("jpeg");
#line 216 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp17_ = g_strdup ("png");
#line 216 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp18_ = g_new0 (gchar*, 2 + 1);
#line 216 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp18_[0] = _tmp16_;
#line 216 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp18_[1] = _tmp17_;
#line 216 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		images = _tmp18_;
#line 216 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		images_length1 = 2;
#line 216 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_images_size_ = images_length1;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp19_ = images;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp19__length1 = images_length1;
#line 2094 "rygel-http-item-uri.c"
		{
			gchar** image_collection = NULL;
			gint image_collection_length1 = 0;
			gint _image_collection_size_ = 0;
			gint image_it = 0;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			image_collection = _tmp19_;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			image_collection_length1 = _tmp19__length1;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			for (image_it = 0; image_it < _tmp19__length1; image_it = image_it + 1) {
#line 2106 "rygel-http-item-uri.c"
				gchar* _tmp20_;
				gchar* image = NULL;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp20_ = g_strdup (image_collection[image_it]);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				image = _tmp20_;
#line 2113 "rygel-http-item-uri.c"
				{
					GeeHashMap* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					const gchar* _tmp25_;
#line 219 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp21_ = rygel_http_item_uri_mime_to_ext;
#line 219 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp22_ = image;
#line 219 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp23_ = g_strconcat ("image/", _tmp22_, NULL);
#line 219 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp24_ = _tmp23_;
#line 219 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp25_ = image;
#line 219 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, _tmp24_, _tmp25_);
#line 219 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_free0 (_tmp24_);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_free0 (image);
#line 2136 "rygel-http-item-uri.c"
				}
			}
		}
#line 223 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp26_ = rygel_http_item_uri_mime_to_ext;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, "text/srt", "srt");
#line 226 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp27_ = rygel_http_item_uri_mime_to_ext;
#line 226 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, "application/ogg", "ogg");
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		images = (_vala_array_free (images, images_length1, (GDestroyNotify) g_free), NULL);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		videos = (_vala_array_free (videos, videos_length1, (GDestroyNotify) g_free), NULL);
#line 2152 "rygel-http-item-uri.c"
	}
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp28_ = rygel_http_item_uri_mime_to_ext;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp29_ = mime_type;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp30_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp28_, _tmp29_);
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp30_) {
#line 2162 "rygel-http-item-uri.c"
		GeeHashMap* _tmp31_;
		const gchar* _tmp32_;
		gpointer _tmp33_ = NULL;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp31_ = rygel_http_item_uri_mime_to_ext;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp32_ = mime_type;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp33_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp31_, _tmp32_);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		result = (gchar*) _tmp33_;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		return result;
#line 2176 "rygel-http-item-uri.c"
	}
#line 233 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp34_ = g_strdup ("");
#line 233 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	result = _tmp34_;
#line 233 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return result;
#line 2184 "rygel-http-item-uri.c"
}


const gchar* rygel_http_item_uri_get_item_id (RygelHTTPItemURI* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->_item_id;
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	result = _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return result;
#line 2199 "rygel-http-item-uri.c"
}


void rygel_http_item_uri_set_item_id (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_if_fail (self != NULL);
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = value;
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->priv->_item_id);
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->priv->_item_id = _tmp1_;
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_object_notify ((GObject *) self, "item-id");
#line 2218 "rygel-http-item-uri.c"
}


gint rygel_http_item_uri_get_thumbnail_index (RygelHTTPItemURI* self) {
	gint result;
	gint _tmp0_;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->_thumbnail_index;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	result = _tmp0_;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return result;
#line 2233 "rygel-http-item-uri.c"
}


void rygel_http_item_uri_set_thumbnail_index (RygelHTTPItemURI* self, gint value) {
	gint _tmp0_;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_if_fail (self != NULL);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = value;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->priv->_thumbnail_index = _tmp0_;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_object_notify ((GObject *) self, "thumbnail-index");
#line 2247 "rygel-http-item-uri.c"
}


gint rygel_http_item_uri_get_subtitle_index (RygelHTTPItemURI* self) {
	gint result;
	gint _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->_subtitle_index;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	result = _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return result;
#line 2262 "rygel-http-item-uri.c"
}


void rygel_http_item_uri_set_subtitle_index (RygelHTTPItemURI* self, gint value) {
	gint _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_if_fail (self != NULL);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = value;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->priv->_subtitle_index = _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_object_notify ((GObject *) self, "subtitle-index");
#line 2276 "rygel-http-item-uri.c"
}


const gchar* rygel_http_item_uri_get_transcode_target (RygelHTTPItemURI* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->_transcode_target;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	result = _tmp0_;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return result;
#line 2291 "rygel-http-item-uri.c"
}


void rygel_http_item_uri_set_transcode_target (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_if_fail (self != NULL);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = value;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->priv->_transcode_target);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->priv->_transcode_target = _tmp1_;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_object_notify ((GObject *) self, "transcode-target");
#line 2310 "rygel-http-item-uri.c"
}


RygelHTTPServer* rygel_http_item_uri_get_http_server (RygelHTTPItemURI* self) {
	RygelHTTPServer* result;
	RygelHTTPServer* _tmp0_;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->_http_server;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	result = _tmp0_;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return result;
#line 2325 "rygel-http-item-uri.c"
}


void rygel_http_item_uri_set_http_server (RygelHTTPItemURI* self, RygelHTTPServer* value) {
	RygelHTTPServer* _tmp0_;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_if_fail (self != NULL);
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = value;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->priv->_http_server = _tmp0_;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_object_notify ((GObject *) self, "http-server");
#line 2339 "rygel-http-item-uri.c"
}


gchar* rygel_http_item_uri_get_extension (RygelHTTPItemURI* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp3_;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->real_extension;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (g_strcmp0 (_tmp0_, "") != 0) {
#line 2353 "rygel-http-item-uri.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp1_ = self->priv->real_extension;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp2_ = g_strconcat (".", _tmp1_, NULL);
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		result = _tmp2_;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		return result;
#line 2364 "rygel-http-item-uri.c"
	}
#line 41 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3_ = g_strdup ("");
#line 41 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	result = _tmp3_;
#line 41 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return result;
#line 2372 "rygel-http-item-uri.c"
}


void rygel_http_item_uri_set_extension (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 43 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = value;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->priv->real_extension);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->priv->real_extension = _tmp1_;
#line 43 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_object_notify ((GObject *) self, "extension");
#line 2391 "rygel-http-item-uri.c"
}


static void rygel_http_item_uri_class_init (RygelHTTPItemURIClass * klass) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPItemURIPrivate));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_item_uri_get_property;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_item_uri_set_property;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_finalize;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_ITEM_ID, g_param_spec_string ("item-id", "item-id", "item-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX, g_param_spec_int ("thumbnail-index", "thumbnail-index", "thumbnail-index", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX, g_param_spec_int ("subtitle-index", "subtitle-index", "subtitle-index", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_TRANSCODE_TARGET, g_param_spec_string ("transcode-target", "transcode-target", "transcode-target", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_HTTP_SERVER, g_param_spec_object ("http-server", "http-server", "http-server", RYGEL_TYPE_HTTP_SERVER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2418 "rygel-http-item-uri.c"
}


static void rygel_http_item_uri_instance_init (RygelHTTPItemURI * self) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->priv = RYGEL_HTTP_ITEM_URI_GET_PRIVATE (self);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->priv->_thumbnail_index = -1;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->priv->_subtitle_index = -1;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->priv->_transcode_target = NULL;
#line 2431 "rygel-http-item-uri.c"
}


static void rygel_http_item_uri_finalize (GObject* obj) {
	RygelHTTPItemURI * self;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->priv->_item_id);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->priv->_transcode_target);
#line 35 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->priv->real_extension);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	G_OBJECT_CLASS (rygel_http_item_uri_parent_class)->finalize (obj);
#line 2447 "rygel-http-item-uri.c"
}


GType rygel_http_item_uri_get_type (void) {
	static volatile gsize rygel_http_item_uri_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURI), 0, (GInstanceInitFunc) rygel_http_item_uri_instance_init, NULL };
		GType rygel_http_item_uri_type_id;
		rygel_http_item_uri_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURI", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_type_id__volatile, rygel_http_item_uri_type_id);
	}
	return rygel_http_item_uri_type_id__volatile;
}


static void _vala_rygel_http_item_uri_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	switch (property_id) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_ITEM_ID:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		g_value_set_string (value, rygel_http_item_uri_get_item_id (self));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		g_value_set_int (value, rygel_http_item_uri_get_thumbnail_index (self));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		g_value_set_int (value, rygel_http_item_uri_get_subtitle_index (self));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_TRANSCODE_TARGET:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		g_value_set_string (value, rygel_http_item_uri_get_transcode_target (self));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_HTTP_SERVER:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		g_value_set_object (value, rygel_http_item_uri_get_http_server (self));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_EXTENSION:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		g_value_take_string (value, rygel_http_item_uri_get_extension (self));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 2504 "rygel-http-item-uri.c"
		default:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 2510 "rygel-http-item-uri.c"
	}
}


static void _vala_rygel_http_item_uri_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	switch (property_id) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_ITEM_ID:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_item_id (self, g_value_get_string (value));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_thumbnail_index (self, g_value_get_int (value));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_subtitle_index (self, g_value_get_int (value));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_TRANSCODE_TARGET:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_transcode_target (self, g_value_get_string (value));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_HTTP_SERVER:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_http_server (self, g_value_get_object (value));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_EXTENSION:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_extension (self, g_value_get_string (value));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 2556 "rygel-http-item-uri.c"
		default:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 2562 "rygel-http-item-uri.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



