/* cheese-window.c generated by valac 0.18.0.57-8d977, the Vala compiler
 * generated from cheese-window.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <cheese-fileutil.h>
#include <clutter/clutter.h>
#include <clutter-gtk/clutter-gtk.h>
#include <thumbview/eog-thumb-nav.h>
#include <thumbview/cheese-thumb-view.h>
#include <gee.h>
#include <cheese-camera.h>
#include <cheese-flash.h>
#include <cheese-effect.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdkx.h>
#include <cheese-config.h>
#include <glib/gstdio.h>
#include <cheese-camera-device.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <stdio.h>


#define TYPE_PK_PROXY (pk_proxy_get_type ())
#define PK_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PK_PROXY, PkProxy))
#define IS_PK_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PK_PROXY))
#define PK_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PK_PROXY, PkProxyIface))

typedef struct _PkProxy PkProxy;
typedef struct _PkProxyIface PkProxyIface;

#define TYPE_PK_PROXY_PROXY (pk_proxy_proxy_get_type ())
typedef GDBusProxy PkProxyProxy;
typedef GDBusProxyClass PkProxyProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define CHEESE_TYPE_MAIN_WINDOW (cheese_main_window_get_type ())
#define CHEESE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow))
#define CHEESE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))
#define CHEESE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))

typedef struct _CheeseMainWindow CheeseMainWindow;
typedef struct _CheeseMainWindowClass CheeseMainWindowClass;
typedef struct _CheeseMainWindowPrivate CheeseMainWindowPrivate;

#define CHEESE_TYPE_EFFECTS_MANAGER (cheese_effects_manager_get_type ())
#define CHEESE_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManager))
#define CHEESE_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))
#define CHEESE_IS_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_IS_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_EFFECTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))

typedef struct _CheeseEffectsManager CheeseEffectsManager;
typedef struct _CheeseEffectsManagerClass CheeseEffectsManagerClass;

#define CHEESE_TYPE_SHAREABLE_MEDIA (cheese_shareable_media_get_type ())
#define CHEESE_SHAREABLE_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_SHAREABLE_MEDIA, CheeseShareableMedia))
#define CHEESE_SHAREABLE_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_SHAREABLE_MEDIA, CheeseShareableMediaClass))
#define CHEESE_IS_SHAREABLE_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_SHAREABLE_MEDIA))
#define CHEESE_IS_SHAREABLE_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_SHAREABLE_MEDIA))
#define CHEESE_SHAREABLE_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_SHAREABLE_MEDIA, CheeseShareableMediaClass))

typedef struct _CheeseShareableMedia CheeseShareableMedia;
typedef struct _CheeseShareableMediaClass CheeseShareableMediaClass;

#define CHEESE_TYPE_COUNTDOWN (cheese_countdown_get_type ())
#define CHEESE_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdown))
#define CHEESE_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))
#define CHEESE_IS_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_IS_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_COUNTDOWN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))

typedef struct _CheeseCountdown CheeseCountdown;
typedef struct _CheeseCountdownClass CheeseCountdownClass;

#define CHEESE_MAIN_WINDOW_TYPE_DELETE_RESPONSE (cheese_main_window_delete_response_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _CheeseMainWindowInstallPackagesData CheeseMainWindowInstallPackagesData;
typedef struct _CheeseCountdownPrivate CheeseCountdownPrivate;
typedef struct _CheeseEffectsManagerPrivate CheeseEffectsManagerPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))

struct _PkProxyIface {
	GTypeInterface parent_iface;
	void (*install_catalogs) (PkProxy* self, guint xid, gchar** catalog_files, int catalog_files_length1, const gchar* interaction, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*install_catalogs_finish) (PkProxy* self, GAsyncResult* _res_, GError** error);
};

struct _CheeseMainWindow {
	GtkApplicationWindow parent_instance;
	CheeseMainWindowPrivate * priv;
};

struct _CheeseMainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _CheeseMainWindowPrivate {
	CheeseMediaMode current_mode;
	GtkBuilder* gtk_builder;
	ClutterScript* clutter_builder;
	GSettings* settings;
	GtkWidget* thumbnails;
	GtkClutterEmbed* viewport_widget;
	GtkGrid* main_vbox;
	EogThumbNav* thumb_nav;
	CheeseThumbView* thumb_view;
	GtkAlignment* thumbnails_right;
	GtkAlignment* thumbnails_bottom;
	GtkBox* leave_fullscreen_button_container;
	GtkToggleButton* photo_toggle_button;
	GtkToggleButton* video_toggle_button;
	GtkToggleButton* burst_toggle_button;
	GtkButton* take_action_button;
	GtkLabel* take_action_button_label;
	GtkImage* take_action_button_image;
	GtkToggleButton* effects_toggle_button;
	GtkButton* leave_fullscreen_button;
	GtkBox* buttons_area;
	GtkMenu* thumbnail_popup;
	ClutterStage* viewport;
	ClutterBox* viewport_layout;
	ClutterTexture* video_preview;
	ClutterBinLayout* viewport_layout_manager;
	ClutterText* countdown_layer;
	ClutterRectangle* background_layer;
	ClutterText* error_layer;
	ClutterText* timeout_layer;
	ClutterBox* current_effects_grid;
	gint current_effects_page;
	GeeArrayList* effects_grids;
	GtkToggleAction* wide_mode_action;
	GtkAction* countdown_action;
	GtkAction* effects_page_prev_action;
	GtkAction* effects_page_next_action;
	GtkAction* share_action;
	gboolean is_fullscreen;
	gboolean is_wide_mode;
	gboolean is_recording;
	gboolean is_bursting;
	gboolean is_effects_selector_active;
	gboolean is_camera_actions_sensitive;
	gboolean action_cancelled;
	gboolean is_command_line_startup;
	GtkButton** buttons;
	gint buttons_length1;
	gint _buttons_size_;
	CheeseCamera* camera;
	CheeseFileUtil* fileutil;
	CheeseFlash* flash;
	CheeseEffectsManager* effects_manager;
	CheeseEffect* selected_effect;
	CheeseShareableMedia* shareable_media;
	GSource* fullscreen_timeout;
	CheeseCountdown* current_countdown;
	gint burst_count;
	guint burst_callback_id;
	GeeHashMap* action_sensitivities;
};

typedef enum  {
	CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP = 1,
	CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL = 2
} CheeseMainWindowDeleteResponse;

struct _CheeseMainWindowInstallPackagesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	CheeseMainWindow* self;
	GdkWindow* _tmp0_;
	GdkCursor* _tmp1_;
	GdkCursor* _tmp2_;
	PkProxy* _tmp3_;
	PkProxy* pk_proxy;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** catalogs;
	gint catalogs_length1;
	gint _catalogs_size_;
	PkProxy* _tmp6_;
	GdkWindow* _tmp7_;
	Window _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GError* _error_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError * _inner_error_;
};

typedef void (*CheeseCountdownCountdownCallback) (void* user_data);
struct _CheeseCountdown {
	GObject parent_instance;
	CheeseCountdownPrivate * priv;
	gboolean running;
};

struct _CheeseCountdownClass {
	GObjectClass parent_class;
};

struct _CheeseEffectsManager {
	GObject parent_instance;
	CheeseEffectsManagerPrivate * priv;
	GeeArrayList* effects;
};

struct _CheeseEffectsManagerClass {
	GObjectClass parent_class;
};


static gpointer cheese_main_window_parent_class = NULL;

GType pk_proxy_proxy_get_type (void) G_GNUC_CONST;
guint pk_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType pk_proxy_get_type (void) G_GNUC_CONST;
void pk_proxy_install_catalogs (PkProxy* self, guint xid, gchar** catalog_files, int catalog_files_length1, const gchar* interaction, GAsyncReadyCallback _callback_, gpointer _user_data_);
void pk_proxy_install_catalogs_finish (PkProxy* self, GAsyncResult* _res_, GError** error);
static void pk_proxy_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void pk_proxy_proxy_install_catalogs_async (PkProxy* self, guint xid, gchar** catalog_files, int catalog_files_length1, const gchar* interaction, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void pk_proxy_proxy_install_catalogs_finish (PkProxy* self, GAsyncResult* _res_, GError** error);
static void pk_proxy_proxy_pk_proxy_interface_init (PkProxyIface* iface);
static void _dbus_pk_proxy_install_catalogs (PkProxy* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_pk_proxy_install_catalogs_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void pk_proxy_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* pk_proxy_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean pk_proxy_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _pk_proxy_unregister_object (gpointer user_data);
#define FULLSCREEN_TIMEOUT_INTERVAL (5 * 1000)
#define EFFECTS_PER_PAGE 9
#define SENDTO_EXEC "nautilus-sendto"
GType cheese_main_window_get_type (void) G_GNUC_CONST;
GType cheese_effects_manager_get_type (void) G_GNUC_CONST;
GType cheese_shareable_media_get_type (void) G_GNUC_CONST;
GType cheese_countdown_get_type (void) G_GNUC_CONST;
#define CHEESE_MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowPrivate))
enum  {
	CHEESE_MAIN_WINDOW_DUMMY_PROPERTY
};
static GType cheese_main_window_delete_response_get_type (void) G_GNUC_UNUSED;
CheeseMainWindow* cheese_main_window_new (GtkApplication* application);
CheeseMainWindow* cheese_main_window_construct (GType object_type, GtkApplication* application);
gboolean cheese_main_window_on_thumbnail_mouse_button_press (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event);
void cheese_main_window_on_file_open (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_delete (GtkAction* action, CheeseMainWindow* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void cheese_main_window_on_file_move_to_trash (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_move_to_trash_all (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_trash_enumerated_files (CheeseMainWindow* self, const gchar* directory, GFileEnumerator* enumerator);
void cheese_main_window_on_share_files (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_install_packages (CheeseMainWindow* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void cheese_main_window_install_packages_finish (CheeseMainWindow* self, GAsyncResult* _res_);
static void ___lambda5_ (CheeseMainWindow* self, GObject* obj, GAsyncResult* res);
static void ____lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void cheese_shareable_media_share_files (CheeseShareableMedia* self, GList* files);
static void cheese_main_window_install_packages_data_free (gpointer _data);
static gboolean cheese_main_window_install_packages_co (CheeseMainWindowInstallPackagesData* _data_);
static void cheese_main_window_install_packages_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* cheese_main_window_get_data_file_dir (CheeseMainWindow* self, const gchar* filename);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
void cheese_main_window_on_file_save_as (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_layout_wide_mode (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode);
void cheese_main_window_set_fullscreen (gboolean fullscreen, CheeseMainWindow* self);
static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen_mode);
static void cheese_main_window_enable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_disable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_set_resolution (CheeseMainWindow* self, CheeseMediaMode mode);
static void cheese_main_window_set_mode (CheeseMainWindow* self, CheeseMediaMode mode);
static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self);
static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self);
static gboolean __lambda6_ (CheeseMainWindow* self);
static gboolean ___lambda6__gsource_func (gpointer self);
static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e);
static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags);
void cheese_main_window_on_countdown_toggle (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self);
void cheese_main_window_take_photo (CheeseMainWindow* self);
CheeseCountdown* cheese_countdown_new (ClutterText* countdown_actor);
CheeseCountdown* cheese_countdown_construct (GType object_type, ClutterText* countdown_actor);
void cheese_countdown_start (CheeseCountdown* self, CheeseCountdownCountdownCallback completed_callback, void* completed_callback_target);
static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self);
static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self);
void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self, gboolean is_start);
static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self, GdkEventKey* event);
void cheese_countdown_stop (CheeseCountdown* self);
void cheese_main_window_toggle_video_recording (CheeseMainWindow* self, gboolean is_start);
static gboolean cheese_main_window_update_timeout_layer (CheeseMainWindow* self);
static gboolean _cheese_main_window_update_timeout_layer_gsource_func (gpointer self);
static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self);
void cheese_main_window_shoot (CheeseMainWindow* self);
void cheese_main_window_set_effects (gboolean effects, CheeseMainWindow* self);
static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active);
gboolean cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, ClutterActor* source, ClutterButtonEvent* event);
void cheese_main_window_on_prev_effects_page (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number);
void cheese_main_window_on_next_effects_page (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self);
static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self);
CheeseEffectsManager* cheese_effects_manager_new (void);
CheeseEffectsManager* cheese_effects_manager_construct (GType object_type);
void cheese_effects_manager_load_effects (CheeseEffectsManager* self);
static gboolean _cheese_main_window_on_selected_effect_change_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
void cheese_main_window_toggle_camera_actions_sensitivities (CheeseMainWindow* self, gboolean active);
void cheese_main_window_camera_state_change_playing (CheeseMainWindow* self);
CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self, const gchar* name);
void cheese_main_window_set_startup_wide_mode (CheeseMainWindow* self);
void cheese_main_window_set_startup_fullscreen_mode (CheeseMainWindow* self);
void cheese_main_window_setup_ui (CheeseMainWindow* self);
CheeseShareableMedia* cheese_shareable_media_new (CheeseMainWindow* main_window);
CheeseShareableMedia* cheese_shareable_media_construct (GType object_type, CheeseMainWindow* main_window);
static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self);
static gboolean _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
ClutterTexture* cheese_main_window_get_video_preview (CheeseMainWindow* self);
void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self);
void cheese_main_window_set_current_mode (CheeseMainWindow* self, CheeseMediaMode mode);
void cheese_main_window_set_camera (CheeseMainWindow* self, CheeseCamera* camera);
static void cheese_main_window_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _pk_proxy_dbus_arg_info_install_catalogs_xid = {-1, "xid", "u"};
static const GDBusArgInfo _pk_proxy_dbus_arg_info_install_catalogs_catalog_files = {-1, "catalog_files", "as"};
static const GDBusArgInfo _pk_proxy_dbus_arg_info_install_catalogs_interaction = {-1, "interaction", "s"};
static const GDBusArgInfo * const _pk_proxy_dbus_arg_info_install_catalogs_in[] = {&_pk_proxy_dbus_arg_info_install_catalogs_xid, &_pk_proxy_dbus_arg_info_install_catalogs_catalog_files, &_pk_proxy_dbus_arg_info_install_catalogs_interaction, NULL};
static const GDBusArgInfo * const _pk_proxy_dbus_arg_info_install_catalogs_out[] = {NULL};
static const GDBusMethodInfo _pk_proxy_dbus_method_info_install_catalogs = {-1, "InstallCatalogs", (GDBusArgInfo **) (&_pk_proxy_dbus_arg_info_install_catalogs_in), (GDBusArgInfo **) (&_pk_proxy_dbus_arg_info_install_catalogs_out)};
static const GDBusMethodInfo * const _pk_proxy_dbus_method_info[] = {&_pk_proxy_dbus_method_info_install_catalogs, NULL};
static const GDBusSignalInfo * const _pk_proxy_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _pk_proxy_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _pk_proxy_dbus_interface_info = {-1, "org.freedesktop.PackageKit.Modify", (GDBusMethodInfo **) (&_pk_proxy_dbus_method_info), (GDBusSignalInfo **) (&_pk_proxy_dbus_signal_info), (GDBusPropertyInfo **) (&_pk_proxy_dbus_property_info)};
static const GDBusInterfaceVTable _pk_proxy_dbus_interface_vtable = {pk_proxy_dbus_interface_method_call, pk_proxy_dbus_interface_get_property, pk_proxy_dbus_interface_set_property};

void pk_proxy_install_catalogs (PkProxy* self, guint xid, gchar** catalog_files, int catalog_files_length1, const gchar* interaction, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PK_PROXY_GET_INTERFACE (self)->install_catalogs (self, xid, catalog_files, catalog_files_length1, interaction, _callback_, _user_data_);
}


void pk_proxy_install_catalogs_finish (PkProxy* self, GAsyncResult* _res_, GError** error) {
	PK_PROXY_GET_INTERFACE (self)->install_catalogs_finish (self, _res_, error);
}


static void pk_proxy_base_init (PkProxyIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType pk_proxy_get_type (void) {
	static volatile gsize pk_proxy_type_id__volatile = 0;
	if (g_once_init_enter (&pk_proxy_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PkProxyIface), (GBaseInitFunc) pk_proxy_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType pk_proxy_type_id;
		pk_proxy_type_id = g_type_register_static (G_TYPE_INTERFACE, "PkProxy", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (pk_proxy_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (pk_proxy_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) pk_proxy_proxy_get_type);
		g_type_set_qdata (pk_proxy_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.PackageKit.Modify");
		g_type_set_qdata (pk_proxy_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) pk_proxy_register_object);
		g_once_init_leave (&pk_proxy_type_id__volatile, pk_proxy_type_id);
	}
	return pk_proxy_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (PkProxyProxy, pk_proxy_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_PK_PROXY, pk_proxy_proxy_pk_proxy_interface_init) )
static void pk_proxy_proxy_class_init (PkProxyProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = pk_proxy_proxy_g_signal;
}


static void pk_proxy_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void pk_proxy_proxy_init (PkProxyProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void pk_proxy_proxy_install_catalogs_async (PkProxy* self, guint xid, gchar** catalog_files, int catalog_files_length1, const gchar* interaction, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp0_;
	GVariantBuilder _tmp1_;
	int _tmp2_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.PackageKit.Modify", "InstallCatalogs");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (xid));
	_tmp0_ = catalog_files;
	g_variant_builder_init (&_tmp1_, G_VARIANT_TYPE ("as"));
	for (_tmp2_ = 0; _tmp2_ < catalog_files_length1; _tmp2_++) {
		g_variant_builder_add_value (&_tmp1_, g_variant_new_string (*_tmp0_));
		_tmp0_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp1_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (interaction));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void pk_proxy_proxy_install_catalogs_finish (PkProxy* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void pk_proxy_proxy_pk_proxy_interface_init (PkProxyIface* iface) {
	iface->install_catalogs = pk_proxy_proxy_install_catalogs_async;
	iface->install_catalogs_finish = pk_proxy_proxy_install_catalogs_finish;
}


static void _dbus_pk_proxy_install_catalogs (PkProxy* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	guint xid = 0U;
	GVariant* _tmp3_;
	gchar** catalog_files = NULL;
	int catalog_files_length1 = 0;
	GVariant* _tmp4_;
	gchar** _tmp5_;
	int _tmp5__length;
	int _tmp5__size;
	int _tmp5__length1;
	GVariantIter _tmp6_;
	GVariant* _tmp7_;
	gchar* interaction = NULL;
	GVariant* _tmp8_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	xid = g_variant_get_uint32 (_tmp3_);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp5_ = g_new (gchar*, 5);
	_tmp5__length = 0;
	_tmp5__size = 4;
	_tmp5__length1 = 0;
	g_variant_iter_init (&_tmp6_, _tmp4_);
	for (; (_tmp7_ = g_variant_iter_next_value (&_tmp6_)) != NULL; _tmp5__length1++) {
		if (_tmp5__size == _tmp5__length) {
			_tmp5__size = 2 * _tmp5__size;
			_tmp5_ = g_renew (gchar*, _tmp5_, _tmp5__size + 1);
		}
		_tmp5_[_tmp5__length++] = g_variant_dup_string (_tmp7_, NULL);
		g_variant_unref (_tmp7_);
	}
	catalog_files_length1 = _tmp5__length1;
	_tmp5_[_tmp5__length] = NULL;
	catalog_files = _tmp5_;
	g_variant_unref (_tmp4_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	interaction = g_variant_dup_string (_tmp8_, NULL);
	g_variant_unref (_tmp8_);
	pk_proxy_install_catalogs (self, xid, catalog_files, catalog_files_length1, interaction, (GAsyncReadyCallback) _dbus_pk_proxy_install_catalogs_ready, invocation);
	catalog_files = (_vala_array_free (catalog_files, catalog_files_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (interaction);
}


static void _dbus_pk_proxy_install_catalogs_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	pk_proxy_install_catalogs_finish ((PkProxy*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void pk_proxy_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "InstallCatalogs") == 0) {
		_dbus_pk_proxy_install_catalogs (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* pk_proxy_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean pk_proxy_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint pk_proxy_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_pk_proxy_dbus_interface_info), &_pk_proxy_dbus_interface_vtable, data, _pk_proxy_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _pk_proxy_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


/**
   * Responses from the delete files confirmation dialog.
   *
   * @param SKIP skip a single file
   * @param SKIP_ALL skill all following files
   */
static GType cheese_main_window_delete_response_get_type (void) {
	static volatile gsize cheese_main_window_delete_response_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_window_delete_response_type_id__volatile)) {
		static const GEnumValue values[] = {{CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP, "CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP", "skip"}, {CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL, "CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL", "skip-all"}, {0, NULL, NULL}};
		GType cheese_main_window_delete_response_type_id;
		cheese_main_window_delete_response_type_id = g_enum_register_static ("CheeseMainWindowDeleteResponse", values);
		g_once_init_leave (&cheese_main_window_delete_response_type_id__volatile, cheese_main_window_delete_response_type_id);
	}
	return cheese_main_window_delete_response_type_id__volatile;
}


CheeseMainWindow* cheese_main_window_construct (GType object_type, GtkApplication* application) {
	CheeseMainWindow * self = NULL;
	GtkApplication* _tmp0_;
	g_return_val_if_fail (application != NULL, NULL);
	_tmp0_ = application;
	self = (CheeseMainWindow*) g_object_new (object_type, "application", _tmp0_, NULL);
	return self;
}


CheeseMainWindow* cheese_main_window_new (GtkApplication* application) {
	return cheese_main_window_construct (CHEESE_TYPE_MAIN_WINDOW, application);
}


/**
   * Popup a context menu when right-clicking on a thumbnail.
   *
   * @param iconview the thumbnail view that emitted the signal
   * @param event the event
   * @return false, to allow further processing of the event
   */
static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


gboolean cheese_main_window_on_thumbnail_mouse_button_press (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	CheeseThumbView* _tmp0_;
	GdkEventButton _tmp1_;
	gdouble _tmp2_;
	GdkEventButton _tmp3_;
	gdouble _tmp4_;
	GtkTreePath* _tmp5_ = NULL;
	GtkTreePath* _tmp6_;
	GtkTreePath* _tmp7_;
	CheeseThumbView* _tmp8_;
	GtkTreePath* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GdkEventButton _tmp16_;
	GdkEventType _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iconview != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.x;
	_tmp3_ = *event;
	_tmp4_ = _tmp3_.y;
	_tmp5_ = gtk_icon_view_get_path_at_pos ((GtkIconView*) _tmp0_, (gint) _tmp2_, (gint) _tmp4_);
	_tmp6_ = _gtk_tree_path_copy0 (_tmp5_);
	_gtk_tree_path_free0 (path);
	path = _tmp6_;
	_tmp7_ = path;
	if (_tmp7_ == NULL) {
		result = FALSE;
		_gtk_tree_path_free0 (path);
		return result;
	}
	_tmp8_ = self->priv->thumb_view;
	_tmp9_ = path;
	_tmp10_ = gtk_icon_view_path_is_selected ((GtkIconView*) _tmp8_, _tmp9_);
	if (!_tmp10_) {
		CheeseThumbView* _tmp11_;
		CheeseThumbView* _tmp12_;
		GtkTreePath* _tmp13_;
		CheeseThumbView* _tmp14_;
		GtkTreePath* _tmp15_;
		_tmp11_ = self->priv->thumb_view;
		g_signal_emit_by_name ((GtkIconView*) _tmp11_, "unselect-all");
		_tmp12_ = self->priv->thumb_view;
		_tmp13_ = path;
		gtk_icon_view_select_path ((GtkIconView*) _tmp12_, _tmp13_);
		_tmp14_ = self->priv->thumb_view;
		_tmp15_ = path;
		gtk_icon_view_set_cursor ((GtkIconView*) _tmp14_, _tmp15_, NULL, FALSE);
	}
	_tmp16_ = *event;
	_tmp17_ = _tmp16_.type;
	if (_tmp17_ == GDK_BUTTON_PRESS) {
		GdkEventButton _tmp18_;
		guint _tmp19_;
		_tmp18_ = *event;
		_tmp19_ = _tmp18_.button;
		if (_tmp19_ == ((guint) 3)) {
			GtkMenu* _tmp20_;
			CheeseThumbView* _tmp21_;
			GdkEventButton _tmp22_;
			guint _tmp23_;
			GdkEventButton _tmp24_;
			guint32 _tmp25_;
			_tmp20_ = self->priv->thumbnail_popup;
			_tmp21_ = self->priv->thumb_view;
			_tmp22_ = *event;
			_tmp23_ = _tmp22_.button;
			_tmp24_ = *event;
			_tmp25_ = _tmp24_.time;
			gtk_menu_popup (_tmp20_, NULL, (GtkWidget*) _tmp21_, NULL, NULL, _tmp23_, _tmp25_);
		}
	} else {
		GdkEventButton _tmp26_;
		GdkEventType _tmp27_;
		_tmp26_ = *event;
		_tmp27_ = _tmp26_.type;
		if (_tmp27_ == GDK_2BUTTON_PRESS) {
			cheese_main_window_on_file_open (NULL, self);
		}
	}
	result = FALSE;
	_gtk_tree_path_free0 (path);
	return result;
}


/**
   * Open an image associated with a thumbnail in the default application.
   *
   * @param action the action that emitted the signal, or null
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void cheese_main_window_on_file_open (GtkAction* action, CheeseMainWindow* self) {
	gchar* filename = NULL;
	gchar* uri = NULL;
	GdkScreen* screen = NULL;
	CheeseThumbView* _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		return;
	}
	{
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		GdkScreen* _tmp6_ = NULL;
		GdkScreen* _tmp7_;
		GdkScreen* _tmp8_;
		const gchar* _tmp9_;
		guint32 _tmp10_ = 0U;
		_tmp3_ = filename;
		_tmp4_ = g_filename_to_uri (_tmp3_, NULL, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_g_free0 (uri);
		uri = _tmp5_;
		_tmp6_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (screen);
		screen = _tmp7_;
		_tmp8_ = screen;
		_tmp9_ = uri;
		_tmp10_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp8_, _tmp9_, _tmp10_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		GtkMessageDialog* _tmp13_;
		GtkMessageDialog* error_dialog;
		GtkMessageDialog* _tmp14_;
		GtkMessageDialog* _tmp15_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = _ ("Could not open %s");
		_tmp12_ = filename;
		_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp11_, _tmp12_);
		g_object_ref_sink (_tmp13_);
		error_dialog = _tmp13_;
		_tmp14_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp14_);
		_tmp15_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp15_);
		_g_object_unref0 (error_dialog);
		_g_error_free0 (err);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (screen);
	_g_free0 (uri);
	_g_free0 (filename);
}


/**
   * Delete the requested image or images in the thumbview from storage.
   *
   * A confirmation dialog is shown to the user before deleting any files.
   *
   * @param action the action that emitted the signal
   */
static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void cheese_main_window_on_file_delete (GtkAction* action, CheeseMainWindow* self) {
	gint response = 0;
	gint error_response = 0;
	gboolean skip_all_errors;
	CheeseThumbView* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* files;
	GList* _tmp2_;
	guint _tmp3_ = 0U;
	guint files_length;
	guint _tmp4_;
	const gchar* _tmp5_ = NULL;
	guint _tmp6_;
	GtkMessageDialog* _tmp7_;
	GtkMessageDialog* confirmation_dialog;
	GtkMessageDialog* _tmp8_;
	GtkMessageDialog* _tmp9_;
	GtkMessageDialog* _tmp10_;
	guint _tmp11_;
	const gchar* _tmp12_ = NULL;
	GtkMessageDialog* _tmp13_;
	gint _tmp14_ = 0;
	gint _tmp15_;
	GtkMessageDialog* _tmp36_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	skip_all_errors = FALSE;
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	_tmp2_ = files;
	_tmp3_ = g_list_length (_tmp2_);
	files_length = _tmp3_;
	_tmp4_ = files_length;
	_tmp5_ = ngettext ("Are you sure you want to permanently delete the file?", "Are you sure you want to permanently delete %d files?", (gulong) _tmp4_);
	_tmp6_ = files_length;
	_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, _tmp5_, _tmp6_);
	g_object_ref_sink (_tmp7_);
	confirmation_dialog = _tmp7_;
	_tmp8_ = confirmation_dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp8_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp9_ = confirmation_dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp9_, GTK_STOCK_DELETE, (gint) GTK_RESPONSE_ACCEPT);
	_tmp10_ = confirmation_dialog;
	_tmp11_ = files_length;
	_tmp12_ = ngettext ("If you delete an item, it will be permanently lost", "If you delete the items, they will be permanently lost", (gulong) _tmp11_);
	gtk_message_dialog_format_secondary_text (_tmp10_, "%s", _tmp12_);
	_tmp13_ = confirmation_dialog;
	_tmp14_ = gtk_dialog_run ((GtkDialog*) _tmp13_);
	response = _tmp14_;
	_tmp15_ = response;
	if (_tmp15_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		GList* _tmp16_;
		_tmp16_ = files;
		{
			GList* file_collection = NULL;
			GList* file_it = NULL;
			file_collection = _tmp16_;
			for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
				GFile* _tmp17_;
				GFile* file = NULL;
				_tmp17_ = _g_object_ref0 ((GFile*) file_it->data);
				file = _tmp17_;
				{
					GFile* _tmp18_;
					_tmp18_ = file;
					if (_tmp18_ == NULL) {
						_g_object_unref0 (file);
						_g_object_unref0 (confirmation_dialog);
						__g_list_free__g_object_unref0_0 (files);
						return;
					}
					{
						GFile* _tmp19_;
						_tmp19_ = file;
						g_file_delete (_tmp19_, NULL, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch3_g_error;
						}
					}
					goto __finally3;
					__catch3_g_error:
					{
						GError* err = NULL;
						GError* _tmp20_;
						const gchar* _tmp21_;
						gboolean _tmp22_;
						err = _inner_error_;
						_inner_error_ = NULL;
						_tmp20_ = err;
						_tmp21_ = _tmp20_->message;
						g_warning ("cheese-window.vala:244: Unable to delete file: %s", _tmp21_);
						_tmp22_ = skip_all_errors;
						if (!_tmp22_) {
							GFile* _tmp23_;
							gchar* _tmp24_ = NULL;
							gchar* _tmp25_;
							GtkMessageDialog* _tmp26_;
							GtkMessageDialog* _tmp27_;
							GtkMessageDialog* error_dialog;
							GtkMessageDialog* _tmp28_;
							GtkMessageDialog* _tmp29_;
							GtkMessageDialog* _tmp30_;
							GtkMessageDialog* _tmp31_;
							gint _tmp32_ = 0;
							gint _tmp33_;
							GtkMessageDialog* _tmp35_;
							_tmp23_ = file;
							_tmp24_ = g_file_get_path (_tmp23_);
							_tmp25_ = _tmp24_;
							_tmp26_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "Could not delete %s", _tmp25_);
							g_object_ref_sink (_tmp26_);
							_tmp27_ = _tmp26_;
							_g_free0 (_tmp25_);
							error_dialog = _tmp27_;
							_tmp28_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp28_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
							_tmp29_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp29_, "Skip", (gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP);
							_tmp30_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp30_, "Skip all", (gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL);
							_tmp31_ = error_dialog;
							_tmp32_ = gtk_dialog_run ((GtkDialog*) _tmp31_);
							error_response = _tmp32_;
							_tmp33_ = error_response;
							if (_tmp33_ == ((gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL)) {
								skip_all_errors = TRUE;
							} else {
								gint _tmp34_;
								_tmp34_ = error_response;
								if (_tmp34_ == ((gint) GTK_RESPONSE_CANCEL)) {
									_g_object_unref0 (error_dialog);
									_g_error_free0 (err);
									_g_object_unref0 (file);
									break;
								}
							}
							_tmp35_ = error_dialog;
							gtk_widget_destroy ((GtkWidget*) _tmp35_);
							_g_object_unref0 (error_dialog);
						}
						_g_error_free0 (err);
					}
					__finally3:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (file);
						_g_object_unref0 (confirmation_dialog);
						__g_list_free__g_object_unref0_0 (files);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (file);
				}
			}
		}
	}
	_tmp36_ = confirmation_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp36_);
	_g_object_unref0 (confirmation_dialog);
	__g_list_free__g_object_unref0_0 (files);
}


/**
   * Move the requested image in the thumbview to the trash.
   *
   * A confirmation dialog is shown to the user before moving the file.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_file_move_to_trash (GtkAction* action, CheeseMainWindow* self) {
	GFile* file = NULL;
	CheeseThumbView* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* files;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				GList* _tmp6_;
				guint _tmp7_ = 0U;
				GList* _tmp8_;
				gint _tmp9_;
				GList* _tmp10_ = NULL;
				gconstpointer _tmp11_;
				GFile* _tmp12_;
				GFile* _tmp13_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = files;
				_tmp7_ = g_list_length (_tmp6_);
				if (!(((guint) _tmp5_) < _tmp7_)) {
					break;
				}
				_tmp8_ = files;
				_tmp9_ = i;
				_tmp10_ = g_list_nth (_tmp8_, (guint) _tmp9_);
				_tmp11_ = _tmp10_->data;
				_tmp12_ = _g_object_ref0 ((GFile*) _tmp11_);
				_g_object_unref0 (file);
				file = _tmp12_;
				_tmp13_ = file;
				if (_tmp13_ == NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					return;
				}
				{
					GFile* _tmp14_;
					_tmp14_ = file;
					g_file_trash (_tmp14_, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch4_g_error;
					}
				}
				goto __finally4;
				__catch4_g_error:
				{
					GError* err = NULL;
					const gchar* _tmp15_ = NULL;
					GFile* _tmp16_;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_;
					GtkMessageDialog* _tmp19_;
					GtkMessageDialog* _tmp20_;
					GtkMessageDialog* error_dialog;
					GtkMessageDialog* _tmp21_;
					GtkMessageDialog* _tmp22_;
					err = _inner_error_;
					_inner_error_ = NULL;
					_tmp15_ = _ ("Could not move %s to trash");
					_tmp16_ = file;
					_tmp17_ = g_file_get_path (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp15_, _tmp18_);
					g_object_ref_sink (_tmp19_);
					_tmp20_ = _tmp19_;
					_g_free0 (_tmp18_);
					error_dialog = _tmp20_;
					_tmp21_ = error_dialog;
					gtk_dialog_run ((GtkDialog*) _tmp21_);
					_tmp22_ = error_dialog;
					gtk_widget_destroy ((GtkWidget*) _tmp22_);
					_g_object_unref0 (error_dialog);
					_g_error_free0 (err);
				}
				__finally4:
				if (_inner_error_ != NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	__g_list_free__g_object_unref0_0 (files);
	_g_object_unref0 (file);
}


/**
   * Move all images in the thumbview to the trash.
   *
   * No confirmation dialog is shown to the user before moving the files!
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_file_move_to_trash_all (GtkAction* action, CheeseMainWindow* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		CheeseFileUtil* _tmp0_;
		const gchar* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GFile* directory;
		GFile* _tmp3_;
		GFileEnumerator* _tmp4_ = NULL;
		GFileEnumerator* enumerator;
		GFile* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		GFileEnumerator* _tmp8_;
		CheeseFileUtil* _tmp9_;
		const gchar* _tmp10_ = NULL;
		GFile* _tmp11_ = NULL;
		GFile* _tmp12_;
		GFileEnumerator* _tmp13_ = NULL;
		GFileEnumerator* _tmp14_;
		GFile* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		GFileEnumerator* _tmp18_;
		_tmp0_ = self->priv->fileutil;
		_tmp1_ = cheese_fileutil_get_photo_path (_tmp0_);
		_tmp2_ = g_file_new_for_path (_tmp1_);
		directory = _tmp2_;
		_tmp3_ = directory;
		_tmp4_ = g_file_enumerate_children (_tmp3_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		enumerator = _tmp4_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (directory);
			goto __catch5_g_error;
		}
		_tmp5_ = directory;
		_tmp6_ = g_file_get_path (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = enumerator;
		cheese_main_window_trash_enumerated_files (self, _tmp7_, _tmp8_);
		_g_free0 (_tmp7_);
		_tmp9_ = self->priv->fileutil;
		_tmp10_ = cheese_fileutil_get_video_path (_tmp9_);
		_tmp11_ = g_file_new_for_path (_tmp10_);
		_g_object_unref0 (directory);
		directory = _tmp11_;
		_tmp12_ = directory;
		_tmp13_ = g_file_enumerate_children (_tmp12_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (enumerator);
			_g_object_unref0 (directory);
			goto __catch5_g_error;
		}
		_g_object_unref0 (enumerator);
		enumerator = _tmp14_;
		_tmp15_ = directory;
		_tmp16_ = g_file_get_path (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = enumerator;
		cheese_main_window_trash_enumerated_files (self, _tmp17_, _tmp18_);
		_g_free0 (_tmp17_);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (directory);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = _error_;
		_tmp20_ = _tmp19_->message;
		g_warning ("cheese-window.vala:335: Error while building file trash list: %s", _tmp20_);
		_g_error_free0 (_error_);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
   * Send the enumerated files to the trash.
   *
   * @param directory the directory containing the enumerated files
   * @param enumerator the enumeration of files to send to the trash
   */
static void cheese_main_window_trash_enumerated_files (CheeseMainWindow* self, const gchar* directory, GFileEnumerator* enumerator) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (enumerator != NULL);
	{
		GFileInfo* file_info = NULL;
		while (TRUE) {
			GFileEnumerator* _tmp0_;
			GFileInfo* _tmp1_ = NULL;
			GFileInfo* _tmp2_;
			GFileInfo* _tmp3_;
			const gchar* _tmp4_;
			GFileInfo* _tmp5_;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			GFile* _tmp9_ = NULL;
			GFile* _tmp10_;
			GFile* file_to_trash;
			GFile* _tmp11_;
			_tmp0_ = enumerator;
			_tmp1_ = g_file_enumerator_next_file (_tmp0_, NULL, &_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file_info);
				goto __catch6_g_error;
			}
			_g_object_unref0 (file_info);
			file_info = _tmp2_;
			_tmp3_ = file_info;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = directory;
			_tmp5_ = file_info;
			_tmp6_ = g_file_info_get_name (_tmp5_);
			_tmp7_ = g_build_filename (_tmp4_, _tmp6_, NULL);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_file_new_for_path (_tmp8_);
			_tmp10_ = _tmp9_;
			_g_free0 (_tmp8_);
			file_to_trash = _tmp10_;
			_tmp11_ = file_to_trash;
			g_file_trash (_tmp11_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file_to_trash);
				_g_object_unref0 (file_info);
				goto __catch6_g_error;
			}
			_g_object_unref0 (file_to_trash);
		}
		_g_object_unref0 (file_info);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		g_warning ("cheese-window.vala:356: Error while trashing files: %s", _tmp13_);
		_g_error_free0 (_error_);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
   * Share the selected file(s) in the thumbview.
   *
   * A dialog is shown to the user, where the technology for sharing the
   * image or video can be selected.
   *
   * @param action the action that emitted the signal
   */
static void ___lambda5_ (CheeseMainWindow* self, GObject* obj, GAsyncResult* res) {
	GAsyncResult* _tmp0_;
	GdkWindow* _tmp1_ = NULL;
	GdkCursor* _tmp2_;
	GdkCursor* _tmp3_;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	cheese_main_window_install_packages_finish (self, _tmp0_);
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp2_ = gdk_cursor_new (GDK_LEFT_PTR);
	_tmp3_ = _tmp2_;
	gdk_window_set_cursor (_tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
}


static void ____lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda5_ (self, source_object, res);
	g_object_unref (self);
}


void cheese_main_window_on_share_files (GtkAction* action, CheeseMainWindow* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean nautilus_sendto_installed;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_find_program_in_path (SENDTO_EXEC);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	nautilus_sendto_installed = _tmp2_;
	_tmp3_ = nautilus_sendto_installed;
	if (!_tmp3_) {
		cheese_main_window_install_packages (self, ____lambda5__gasync_ready_callback, g_object_ref (self));
	} else {
		CheeseShareableMedia* _tmp4_;
		CheeseThumbView* _tmp5_;
		GList* _tmp6_ = NULL;
		GList* _tmp7_;
		_tmp4_ = self->priv->shareable_media;
		_tmp5_ = self->priv->thumb_view;
		_tmp6_ = cheese_thumb_view_get_selected_images_list (_tmp5_);
		_tmp7_ = _tmp6_;
		cheese_shareable_media_share_files (_tmp4_, _tmp7_);
		__g_list_free__g_object_unref0_0 (_tmp7_);
	}
}


static void cheese_main_window_install_packages_data_free (gpointer _data) {
	CheeseMainWindowInstallPackagesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (CheeseMainWindowInstallPackagesData, _data_);
}


static void cheese_main_window_install_packages (CheeseMainWindow* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	CheeseMainWindowInstallPackagesData* _data_;
	CheeseMainWindow* _tmp0_;
	_data_ = g_slice_new0 (CheeseMainWindowInstallPackagesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, cheese_main_window_install_packages);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, cheese_main_window_install_packages_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	cheese_main_window_install_packages_co (_data_);
}


static void cheese_main_window_install_packages_finish (CheeseMainWindow* self, GAsyncResult* _res_) {
	CheeseMainWindowInstallPackagesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Install nautilus-sendto runtime dependency.
   *
   */
static void cheese_main_window_install_packages_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	CheeseMainWindowInstallPackagesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	cheese_main_window_install_packages_co (_data_);
}


static gboolean cheese_main_window_install_packages_co (CheeseMainWindowInstallPackagesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = gtk_widget_get_window ((GtkWidget*) _data_->self);
	_data_->_tmp1_ = gdk_cursor_new (GDK_WATCH);
	_data_->_tmp2_ = _data_->_tmp1_;
	gdk_window_set_cursor (_data_->_tmp0_, _data_->_tmp2_);
	_g_object_unref0 (_data_->_tmp2_);
	{
		static const char CATALOG[] = "cheese.catalog";
		_data_->_state_ = 1;
		g_async_initable_new_async (TYPE_PK_PROXY_PROXY, 0, NULL, cheese_main_window_install_packages_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.PackageKit", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/PackageKit", "g-interface-name", "org.freedesktop.PackageKit.Modify", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->pk_proxy = (PkProxy*) _data_->_tmp3_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch7_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = cheese_main_window_get_data_file_dir (_data_->self, CATALOG);
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_new0 (gchar*, 1 + 1);
		_data_->_tmp5_[0] = _data_->_tmp4_;
		_data_->catalogs = _data_->_tmp5_;
		_data_->catalogs_length1 = 1;
		_data_->_catalogs_size_ = _data_->catalogs_length1;
		_data_->_tmp6_ = _data_->pk_proxy;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = gtk_widget_get_window ((GtkWidget*) _data_->self);
		_data_->_tmp8_ = 0;
		_data_->_tmp8_ = gdk_x11_window_get_xid (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->catalogs;
		_data_->_tmp9__length1 = _data_->catalogs_length1;
		_data_->_state_ = 2;
		pk_proxy_install_catalogs (_data_->_tmp6_, (guint) _data_->_tmp8_, _data_->_tmp9_, _data_->_tmp9__length1, "", cheese_main_window_install_packages_ready, _data_);
		return FALSE;
		_state_2:
		pk_proxy_install_catalogs_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			_data_->catalogs = (_vala_array_free (_data_->catalogs, _data_->catalogs_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->pk_proxy);
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch7_g_io_error;
			}
			_data_->catalogs = (_vala_array_free (_data_->catalogs, _data_->catalogs_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->pk_proxy);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->catalogs = (_vala_array_free (_data_->catalogs, _data_->catalogs_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->pk_proxy);
	}
	goto __finally7;
	__catch7_g_io_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp10_ = _data_->_error_;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_critical ("cheese-window.vala:401: D-Bus error: %s\n", _data_->_tmp11_);
		_g_error_free0 (_data_->_error_);
	}
	__finally7:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Search system directories for the given filename, starting
   * with the in-installation-time custom prefix first.
   *
   * @param filename the file whose path will be searched.
   * @return the system path for the given filename.
   */
static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* cheese_main_window_get_data_file_dir (CheeseMainWindow* self, const gchar* filename) {
	gchar* result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** system_data_dirs;
	gint system_data_dirs_length1;
	gint _system_data_dirs_size_;
	gchar** _tmp3_ = NULL;
	gchar** data_dirs;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp1_ = _tmp0_ = g_get_system_data_dirs ();
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _vala_array_length (_tmp0_)) : ((gpointer) _tmp1_);
	_tmp2__length1 = _vala_array_length (_tmp0_);
	system_data_dirs = _tmp2_;
	system_data_dirs_length1 = _tmp2__length1;
	_system_data_dirs_size_ = system_data_dirs_length1;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	data_dirs = _tmp3_;
	data_dirs_length1 = 0;
	_data_dirs_size_ = data_dirs_length1;
	_tmp4_ = data_dirs;
	_tmp4__length1 = data_dirs_length1;
	_tmp5_ = g_strdup (DATADIR);
	_vala_array_add1 (&data_dirs, &data_dirs_length1, &_data_dirs_size_, _tmp5_);
	_tmp6_ = system_data_dirs;
	_tmp6__length1 = system_data_dirs_length1;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp6_;
		dir_collection_length1 = _tmp6__length1;
		for (dir_it = 0; dir_it < _tmp6__length1; dir_it = dir_it + 1) {
			gchar* _tmp7_;
			gchar* dir = NULL;
			_tmp7_ = g_strdup (dir_collection[dir_it]);
			dir = _tmp7_;
			{
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp8_ = data_dirs;
				_tmp8__length1 = data_dirs_length1;
				_tmp9_ = dir;
				_tmp10_ = g_strdup (_tmp9_);
				_vala_array_add2 (&data_dirs, &data_dirs_length1, &_data_dirs_size_, _tmp10_);
				_g_free0 (dir);
			}
		}
	}
	_tmp11_ = data_dirs;
	_tmp11__length1 = data_dirs_length1;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp11_;
		dir_collection_length1 = _tmp11__length1;
		for (dir_it = 0; dir_it < _tmp11__length1; dir_it = dir_it + 1) {
			gchar* _tmp12_;
			gchar* dir = NULL;
			_tmp12_ = g_strdup (dir_collection[dir_it]);
			dir = _tmp12_;
			{
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* absolute_path;
				const gchar* _tmp16_;
				gboolean _tmp17_ = FALSE;
				_tmp13_ = dir;
				_tmp14_ = filename;
				_tmp15_ = g_build_filename (_tmp13_, PACKAGE_TARNAME, _tmp14_, NULL);
				absolute_path = _tmp15_;
				_tmp16_ = absolute_path;
				_tmp17_ = g_file_test (_tmp16_, G_FILE_TEST_EXISTS);
				if (_tmp17_) {
					result = absolute_path;
					_g_free0 (dir);
					data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
					system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_free0 (absolute_path);
				_g_free0 (dir);
			}
		}
	}
	_tmp18_ = filename;
	g_error ("cheese-window.vala:428: Data file ‘%s’ could not be found in system da" \
"ta directories.", _tmp18_);
	data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
	system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
}


/**
   * Save the selected file in the thumbview to an alternate storage location.
   *
   * A file chooser dialog is shown to the user, asking where the file should
   * be saved and the filename.
   *
   * @param action the action that emitted the signal.
   */
void cheese_main_window_on_file_save_as (GtkAction* action, CheeseMainWindow* self) {
	gchar* filename = NULL;
	gchar* basename = NULL;
	GtkFileChooserDialog* save_as_dialog = NULL;
	gint response = 0;
	CheeseThumbView* _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	GtkFileChooserDialog* _tmp4_;
	GtkFileChooserDialog* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	GtkFileChooserDialog* _tmp8_;
	const gchar* _tmp9_;
	GtkFileChooserDialog* _tmp10_;
	const gchar* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_;
	gint _tmp13_ = 0;
	GtkFileChooserDialog* _tmp14_;
	gint _tmp15_;
	GtkFileChooserDialog* _tmp29_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (save_as_dialog);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	_tmp3_ = _ ("Save File");
	_tmp4_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp3_, (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (save_as_dialog);
	save_as_dialog = _tmp4_;
	_tmp5_ = save_as_dialog;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp5_, TRUE);
	_tmp6_ = filename;
	_tmp7_ = g_filename_display_basename (_tmp6_);
	_g_free0 (basename);
	basename = _tmp7_;
	_tmp8_ = save_as_dialog;
	_tmp9_ = basename;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp8_, _tmp9_);
	_tmp10_ = save_as_dialog;
	_tmp11_ = g_get_home_dir ();
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp10_, _tmp11_);
	_tmp12_ = save_as_dialog;
	_tmp13_ = gtk_dialog_run ((GtkDialog*) _tmp12_);
	response = _tmp13_;
	_tmp14_ = save_as_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp14_);
	_tmp15_ = response;
	if (_tmp15_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* target_filename = NULL;
		GtkFileChooserDialog* _tmp16_;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_;
		GFile* _tmp19_ = NULL;
		GFile* src;
		const gchar* _tmp20_;
		GFile* _tmp21_ = NULL;
		GFile* dest;
		_tmp16_ = save_as_dialog;
		_tmp17_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp16_);
		_g_free0 (target_filename);
		target_filename = _tmp17_;
		_tmp18_ = filename;
		_tmp19_ = g_file_new_for_path (_tmp18_);
		src = _tmp19_;
		_tmp20_ = target_filename;
		_tmp21_ = g_file_new_for_path (_tmp20_);
		dest = _tmp21_;
		{
			GFile* _tmp22_;
			GFile* _tmp23_;
			_tmp22_ = src;
			_tmp23_ = dest;
			g_file_copy (_tmp22_, _tmp23_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch8_g_error;
			}
		}
		goto __finally8;
		__catch8_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp24_ = NULL;
			const gchar* _tmp25_;
			GtkMessageDialog* _tmp26_;
			GtkMessageDialog* error_dialog;
			GtkMessageDialog* _tmp27_;
			GtkMessageDialog* _tmp28_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = _ ("Could not save %s");
			_tmp25_ = target_filename;
			_tmp26_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp24_, _tmp25_);
			g_object_ref_sink (_tmp26_);
			error_dialog = _tmp26_;
			_tmp27_ = error_dialog;
			gtk_dialog_run ((GtkDialog*) _tmp27_);
			_tmp28_ = error_dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp28_);
			_g_object_unref0 (error_dialog);
			_g_error_free0 (err);
		}
		__finally8:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dest);
			_g_object_unref0 (src);
			_g_free0 (target_filename);
			_g_object_unref0 (save_as_dialog);
			_g_free0 (basename);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (dest);
		_g_object_unref0 (src);
		_g_free0 (target_filename);
	}
	_tmp29_ = save_as_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp29_);
	_g_object_unref0 (save_as_dialog);
	_g_free0 (basename);
	_g_free0 (filename);
}


/**
   * Toggle wide mode and save the preference to GSettings.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_layout_wide_mode (GtkToggleAction* action, CheeseMainWindow* self) {
	gboolean _tmp0_;
	GtkToggleAction* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->is_command_line_startup;
	if (!_tmp0_) {
		GSettings* _tmp1_;
		GtkToggleAction* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = self->priv->settings;
		_tmp2_ = action;
		_tmp3_ = gtk_toggle_action_get_active (_tmp2_);
		_tmp4_ = _tmp3_;
		g_settings_set_boolean (_tmp1_, "wide-mode", _tmp4_);
	}
	_tmp5_ = action;
	_tmp6_ = gtk_toggle_action_get_active (_tmp5_);
	_tmp7_ = _tmp6_;
	cheese_main_window_set_wide_mode (self, _tmp7_);
}


/**
     * Toggle fullscreen mode and save the preference to GSettings.
     *
     * @param fullscreen whether the window should be fullscreean
     */
void cheese_main_window_set_fullscreen (gboolean fullscreen, CheeseMainWindow* self) {
	gboolean _tmp0_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_command_line_startup;
	if (!_tmp0_) {
		GSettings* _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = self->priv->settings;
		_tmp2_ = fullscreen;
		g_settings_set_boolean (_tmp1_, "fullscreen", _tmp2_);
	}
	_tmp3_ = fullscreen;
	cheese_main_window_set_fullscreen_mode (self, _tmp3_);
}


/**
     * Make the media capture mode actions sensitive.
     */
static void cheese_main_window_enable_mode_change (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
}


/**
     * Make the media capture mode actions insensitive.
     */
static void cheese_main_window_disable_mode_change (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
}


/**
   * Set the capture resolution, based on the current capture mode.
   *
   * @param mode the current capture mode (photo, video or burst)
   */
static void cheese_main_window_set_resolution (CheeseMainWindow* self, CheeseMediaMode mode) {
	CheeseCamera* _tmp0_;
	CheeseCamera* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* formats;
	GList* _tmp3_;
	CheeseVideoFormat* format = NULL;
	gint width;
	gint height;
	CheeseMediaMode _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->camera;
	_tmp2_ = cheese_camera_get_video_formats (_tmp1_);
	formats = _tmp2_;
	_tmp3_ = formats;
	if (_tmp3_ == NULL) {
		return;
	}
	width = 0;
	height = 0;
	_tmp4_ = mode;
	switch (_tmp4_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		case CHEESE_MEDIA_MODE_BURST:
		{
			GSettings* _tmp5_;
			gint _tmp6_ = 0;
			GSettings* _tmp7_;
			gint _tmp8_ = 0;
			_tmp5_ = self->priv->settings;
			_tmp6_ = g_settings_get_int (_tmp5_, "photo-x-resolution");
			width = _tmp6_;
			_tmp7_ = self->priv->settings;
			_tmp8_ = g_settings_get_int (_tmp7_, "photo-y-resolution");
			height = _tmp8_;
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GSettings* _tmp9_;
			gint _tmp10_ = 0;
			GSettings* _tmp11_;
			gint _tmp12_ = 0;
			_tmp9_ = self->priv->settings;
			_tmp10_ = g_settings_get_int (_tmp9_, "video-x-resolution");
			width = _tmp10_;
			_tmp11_ = self->priv->settings;
			_tmp12_ = g_settings_get_int (_tmp11_, "video-y-resolution");
			height = _tmp12_;
			break;
		}
		default:
		break;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				GList* _tmp17_;
				guint _tmp18_ = 0U;
				GList* _tmp19_;
				gint _tmp20_;
				GList* _tmp21_ = NULL;
				gconstpointer _tmp22_;
				gboolean _tmp23_ = FALSE;
				gint _tmp24_;
				CheeseVideoFormat* _tmp25_;
				gint _tmp26_;
				gboolean _tmp30_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = i;
				_tmp17_ = formats;
				_tmp18_ = g_list_length (_tmp17_);
				if (!(((guint) _tmp16_) < _tmp18_)) {
					break;
				}
				_tmp19_ = formats;
				_tmp20_ = i;
				_tmp21_ = g_list_nth (_tmp19_, (guint) _tmp20_);
				_tmp22_ = _tmp21_->data;
				format = (CheeseVideoFormat*) _tmp22_;
				_tmp24_ = width;
				_tmp25_ = format;
				_tmp26_ = _tmp25_->width;
				if (_tmp24_ == _tmp26_) {
					gint _tmp27_;
					CheeseVideoFormat* _tmp28_;
					gint _tmp29_;
					_tmp27_ = height;
					_tmp28_ = format;
					_tmp29_ = _tmp28_->height;
					_tmp23_ = _tmp27_ == _tmp29_;
				} else {
					_tmp23_ = FALSE;
				}
				_tmp30_ = _tmp23_;
				if (_tmp30_) {
					CheeseCamera* _tmp31_;
					CheeseVideoFormat* _tmp32_;
					_tmp31_ = self->priv->camera;
					_tmp32_ = format;
					cheese_camera_set_video_format (_tmp31_, _tmp32_);
					break;
				}
			}
		}
	}
}


/**
   * Set the current media capture mode, and update the UI sensitivities.
   *
   * @param mode the new capture mode to set
   */
static void cheese_main_window_set_mode (CheeseMainWindow* self, CheeseMediaMode mode) {
	g_return_if_fail (self != NULL);
}


/**
   * Clear the fullscreen activity timeout.
   */
static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self) {
	GSource* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fullscreen_timeout;
	if (_tmp0_ != NULL) {
		GSource* _tmp1_;
		_tmp1_ = self->priv->fullscreen_timeout;
		g_source_destroy (_tmp1_);
		_g_source_unref0 (self->priv->fullscreen_timeout);
		self->priv->fullscreen_timeout = NULL;
	}
}


/**
   * Set the fullscreen timeout, for hiding the UI if there is no mouse
   * movement.
   */
static gboolean __lambda6_ (CheeseMainWindow* self) {
	gboolean result = FALSE;
	GtkBox* _tmp0_;
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	cheese_main_window_clear_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ (self);
	return result;
}


static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self) {
	GSource* _tmp0_;
	GSource* _tmp1_;
	GSource* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_timeout_source_new ((guint) FULLSCREEN_TIMEOUT_INTERVAL);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	self->priv->fullscreen_timeout = _tmp0_;
	_tmp1_ = self->priv->fullscreen_timeout;
	g_source_attach (_tmp1_, NULL);
	_tmp2_ = self->priv->fullscreen_timeout;
	g_source_set_callback (_tmp2_, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
}


/**
   * Show the UI in fullscreen if there is any mouse activity.
   *
   * Start a new timeout at the end of every mouse pointer movement. All
   * timeouts will be cancelled, except one created during the last movement
   * event. Show() is called even if the button is not hidden.
   *
   * @param viewport the widget to check for mouse activity on
   * @param e the (unused) event
   */
static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e) {
	gboolean result = FALSE;
	GtkBox* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (viewport != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	cheese_main_window_clear_fullscreen_timeout (self);
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	cheese_main_window_set_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


/**
   * Enable or disable fullscreen mode to the requested state.
   *
   * @param fullscreen_mode whether to enable or disable fullscreen mode
   */
static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_fullscreen_motion_notify_callback (self, _sender, event);
	return result;
}


static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen_mode) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = fullscreen_mode;
	self->priv->is_fullscreen = _tmp0_;
	_tmp1_ = fullscreen_mode;
	if (_tmp1_) {
		gboolean _tmp2_;
		GtkBox* _tmp5_;
		GtkBox* _tmp6_;
		GtkButton** _tmp7_;
		gint _tmp7__length1;
		GtkClutterEmbed* _tmp12_;
		_tmp2_ = self->priv->is_wide_mode;
		if (_tmp2_) {
			GtkAlignment* _tmp3_;
			_tmp3_ = self->priv->thumbnails_right;
			gtk_widget_hide ((GtkWidget*) _tmp3_);
		} else {
			GtkAlignment* _tmp4_;
			_tmp4_ = self->priv->thumbnails_bottom;
			gtk_widget_hide ((GtkWidget*) _tmp4_);
		}
		_tmp5_ = self->priv->leave_fullscreen_button_container;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp5_, FALSE);
		_tmp6_ = self->priv->leave_fullscreen_button_container;
		gtk_widget_show_all ((GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->buttons;
		_tmp7__length1 = self->priv->buttons_length1;
		{
			GtkButton** b_collection = NULL;
			gint b_collection_length1 = 0;
			gint _b_collection_size_ = 0;
			gint b_it = 0;
			b_collection = _tmp7_;
			b_collection_length1 = _tmp7__length1;
			for (b_it = 0; b_it < _tmp7__length1; b_it = b_it + 1) {
				GtkButton* _tmp8_;
				GtkButton* b = NULL;
				_tmp8_ = _g_object_ref0 (b_collection[b_it]);
				b = _tmp8_;
				{
					GtkButton* _tmp9_;
					const gchar* _tmp10_ = NULL;
					_tmp9_ = b;
					_tmp10_ = gtk_buildable_get_name ((GtkBuildable*) _tmp9_);
					if (g_strcmp0 (_tmp10_, "take_action_button") != 0) {
						GtkButton* _tmp11_;
						_tmp11_ = b;
						gtk_button_set_relief (_tmp11_, GTK_RELIEF_NONE);
					}
					_g_object_unref0 (b);
				}
			}
		}
		gtk_window_fullscreen ((GtkWindow*) self);
		_tmp12_ = self->priv->viewport_widget;
		g_signal_connect_object ((GtkWidget*) _tmp12_, "motion-notify-event", (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self, 0);
		cheese_main_window_set_fullscreen_timeout (self);
	} else {
		gboolean _tmp13_;
		GtkBox* _tmp16_;
		GtkButton** _tmp17_;
		gint _tmp17__length1;
		GtkBox* _tmp22_;
		GtkClutterEmbed* _tmp23_;
		guint _tmp24_ = 0U;
		_tmp13_ = self->priv->is_wide_mode;
		if (_tmp13_) {
			GtkAlignment* _tmp14_;
			_tmp14_ = self->priv->thumbnails_right;
			gtk_widget_show_all ((GtkWidget*) _tmp14_);
		} else {
			GtkAlignment* _tmp15_;
			_tmp15_ = self->priv->thumbnails_bottom;
			gtk_widget_show_all ((GtkWidget*) _tmp15_);
		}
		_tmp16_ = self->priv->leave_fullscreen_button_container;
		gtk_widget_hide ((GtkWidget*) _tmp16_);
		_tmp17_ = self->priv->buttons;
		_tmp17__length1 = self->priv->buttons_length1;
		{
			GtkButton** b_collection = NULL;
			gint b_collection_length1 = 0;
			gint _b_collection_size_ = 0;
			gint b_it = 0;
			b_collection = _tmp17_;
			b_collection_length1 = _tmp17__length1;
			for (b_it = 0; b_it < _tmp17__length1; b_it = b_it + 1) {
				GtkButton* _tmp18_;
				GtkButton* b = NULL;
				_tmp18_ = _g_object_ref0 (b_collection[b_it]);
				b = _tmp18_;
				{
					GtkButton* _tmp19_;
					const gchar* _tmp20_ = NULL;
					_tmp19_ = b;
					_tmp20_ = gtk_buildable_get_name ((GtkBuildable*) _tmp19_);
					if (g_strcmp0 (_tmp20_, "take_action_button") != 0) {
						GtkButton* _tmp21_;
						_tmp21_ = b;
						gtk_button_set_relief (_tmp21_, GTK_RELIEF_NORMAL);
					}
					_g_object_unref0 (b);
				}
			}
		}
		cheese_main_window_clear_fullscreen_timeout (self);
		_tmp22_ = self->priv->buttons_area;
		gtk_widget_show ((GtkWidget*) _tmp22_);
		_tmp23_ = self->priv->viewport_widget;
		g_signal_parse_name ("motion-notify-event", GTK_TYPE_WIDGET, &_tmp24_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp23_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp24_, 0, NULL, (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self);
		gtk_window_unfullscreen ((GtkWindow*) self);
	}
}


/**
   * Enable or disable wide mode to the requested state.
   *
   * @param wide_mode whether to enable or disable wide mode
   */
static void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode) {
	gboolean _tmp0_;
	GtkAllocation alloc = {0};
	GtkClutterEmbed* _tmp1_;
	GtkAllocation _tmp2_ = {0};
	GtkClutterEmbed* _tmp3_;
	GtkAllocation _tmp4_;
	gint _tmp5_;
	GtkAllocation _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_;
	GtkRequisition req = {0};
	GtkRequisition _tmp31_ = {0};
	GtkRequisition _tmp32_ = {0};
	GtkRequisition _tmp33_;
	gint _tmp34_;
	GtkRequisition _tmp35_;
	gint _tmp36_;
	GtkClutterEmbed* _tmp37_;
	g_return_if_fail (self != NULL);
	_tmp0_ = wide_mode;
	self->priv->is_wide_mode = _tmp0_;
	_tmp1_ = self->priv->viewport_widget;
	gtk_widget_get_allocation ((GtkWidget*) _tmp1_, &_tmp2_);
	alloc = _tmp2_;
	_tmp3_ = self->priv->viewport_widget;
	_tmp4_ = alloc;
	_tmp5_ = _tmp4_.width;
	_tmp6_ = alloc;
	_tmp7_ = _tmp6_.height;
	gtk_widget_set_size_request ((GtkWidget*) _tmp3_, _tmp5_, _tmp7_);
	_tmp8_ = self->priv->is_wide_mode;
	if (_tmp8_) {
		CheeseThumbView* _tmp9_;
		EogThumbNav* _tmp10_;
		GtkAlignment* _tmp11_;
		GtkWidget* _tmp12_ = NULL;
		GtkAlignment* _tmp15_;
		EogThumbNav* _tmp16_;
		GtkAlignment* _tmp17_;
		GtkAlignment* _tmp18_;
		GtkAlignment* _tmp19_;
		_tmp9_ = self->priv->thumb_view;
		cheese_thumb_view_set_vertical (_tmp9_, TRUE);
		_tmp10_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp10_, TRUE);
		_tmp11_ = self->priv->thumbnails_bottom;
		_tmp12_ = gtk_bin_get_child ((GtkBin*) _tmp11_);
		if (_tmp12_ != NULL) {
			GtkAlignment* _tmp13_;
			EogThumbNav* _tmp14_;
			_tmp13_ = self->priv->thumbnails_bottom;
			_tmp14_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
		}
		_tmp15_ = self->priv->thumbnails_right;
		_tmp16_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
		_tmp17_ = self->priv->thumbnails_right;
		gtk_widget_show_all ((GtkWidget*) _tmp17_);
		_tmp18_ = self->priv->thumbnails_right;
		gtk_container_resize_children ((GtkContainer*) _tmp18_);
		_tmp19_ = self->priv->thumbnails_bottom;
		gtk_widget_hide ((GtkWidget*) _tmp19_);
	} else {
		CheeseThumbView* _tmp20_;
		EogThumbNav* _tmp21_;
		GtkAlignment* _tmp22_;
		GtkWidget* _tmp23_ = NULL;
		GtkAlignment* _tmp26_;
		EogThumbNav* _tmp27_;
		GtkAlignment* _tmp28_;
		GtkAlignment* _tmp29_;
		GtkAlignment* _tmp30_;
		_tmp20_ = self->priv->thumb_view;
		cheese_thumb_view_set_vertical (_tmp20_, FALSE);
		_tmp21_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp21_, FALSE);
		_tmp22_ = self->priv->thumbnails_right;
		_tmp23_ = gtk_bin_get_child ((GtkBin*) _tmp22_);
		if (_tmp23_ != NULL) {
			GtkAlignment* _tmp24_;
			EogThumbNav* _tmp25_;
			_tmp24_ = self->priv->thumbnails_right;
			_tmp25_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
		}
		_tmp26_ = self->priv->thumbnails_bottom;
		_tmp27_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
		_tmp28_ = self->priv->thumbnails_bottom;
		gtk_widget_show_all ((GtkWidget*) _tmp28_);
		_tmp29_ = self->priv->thumbnails_bottom;
		gtk_container_resize_children ((GtkContainer*) _tmp29_);
		_tmp30_ = self->priv->thumbnails_right;
		gtk_widget_hide ((GtkWidget*) _tmp30_);
	}
	gtk_widget_get_preferred_size ((GtkWidget*) self, &_tmp31_, &_tmp32_);
	req = _tmp31_;
	req = _tmp32_;
	_tmp33_ = req;
	_tmp34_ = _tmp33_.width;
	_tmp35_ = req;
	_tmp36_ = _tmp35_.height;
	gtk_window_resize ((GtkWindow*) self, _tmp34_, _tmp36_);
	_tmp37_ = self->priv->viewport_widget;
	gtk_widget_set_size_request ((GtkWidget*) _tmp37_, -1, -1);
}


/**
   * Make sure that the layout manager manages the entire stage.
   *
   * @param actor unused
   * @param box unused
   * @param flags unused
   */
void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags) {
	ClutterBox* _tmp0_;
	ClutterStage* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	ClutterStage* _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	ClutterRectangle* _tmp7_;
	ClutterStage* _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	ClutterStage* _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	ClutterText* _tmp14_;
	ClutterTexture* _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	ClutterStage* _tmp18_;
	gfloat _tmp19_;
	gfloat _tmp20_;
	ClutterStage* _tmp21_;
	gfloat _tmp22_;
	gfloat _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	g_return_if_fail (box != NULL);
	_tmp0_ = self->priv->viewport_layout;
	_tmp1_ = self->priv->viewport;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->viewport;
	_tmp5_ = clutter_actor_get_height ((ClutterActor*) _tmp4_);
	_tmp6_ = _tmp5_;
	clutter_actor_set_size ((ClutterActor*) _tmp0_, _tmp3_, _tmp6_);
	_tmp7_ = self->priv->background_layer;
	_tmp8_ = self->priv->viewport;
	_tmp9_ = clutter_actor_get_width ((ClutterActor*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->viewport;
	_tmp12_ = clutter_actor_get_height ((ClutterActor*) _tmp11_);
	_tmp13_ = _tmp12_;
	clutter_actor_set_size ((ClutterActor*) _tmp7_, _tmp10_, _tmp13_);
	_tmp14_ = self->priv->timeout_layer;
	_tmp15_ = self->priv->video_preview;
	_tmp16_ = clutter_actor_get_width ((ClutterActor*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->viewport;
	_tmp19_ = clutter_actor_get_width ((ClutterActor*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->viewport;
	_tmp22_ = clutter_actor_get_height ((ClutterActor*) _tmp21_);
	_tmp23_ = _tmp22_;
	clutter_actor_set_position ((ClutterActor*) _tmp14_, (_tmp17_ / 3) + (_tmp20_ / 2), _tmp23_ - 20);
}


/**
   * Toggle whether the countdown is active.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_countdown_toggle (GtkToggleAction* action, CheeseMainWindow* self) {
	GSettings* _tmp0_;
	GtkToggleAction* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = action;
	_tmp2_ = gtk_toggle_action_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_boolean (_tmp0_, "countdown", _tmp3_);
}


/**
   * The method to call when the countdown is finished.
   */
static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self) {
	gboolean _tmp0_;
	CheeseMediaMode _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->action_cancelled;
	if (_tmp0_ == FALSE) {
		CheeseFileUtil* _tmp1_;
		CheeseMediaMode _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* file_name;
		GSettings* _tmp5_;
		gboolean _tmp6_ = FALSE;
		GtkGrid* _tmp8_;
		const gchar* _tmp9_ = NULL;
		CheeseCamera* _tmp10_;
		const gchar* _tmp11_;
		_tmp1_ = self->priv->fileutil;
		_tmp2_ = self->priv->current_mode;
		_tmp3_ = cheese_fileutil_get_new_media_filename (_tmp1_, _tmp2_);
		_tmp4_ = g_strdup (_tmp3_);
		file_name = _tmp4_;
		_tmp5_ = self->priv->settings;
		_tmp6_ = g_settings_get_boolean (_tmp5_, "flash");
		if (_tmp6_) {
			CheeseFlash* _tmp7_;
			_tmp7_ = self->priv->flash;
			cheese_flash_fire (_tmp7_);
		}
		_tmp8_ = self->priv->main_vbox;
		_tmp9_ = _ ("Shutter sound");
		ca_gtk_play_for_widget ((GtkWidget*) _tmp8_, (guint32) 0, CA_PROP_EVENT_ID, "camera-shutter", CA_PROP_MEDIA_ROLE, "event", CA_PROP_EVENT_DESCRIPTION, _tmp9_, NULL, NULL);
		_tmp10_ = self->priv->camera;
		_tmp11_ = file_name;
		cheese_camera_take_photo (_tmp10_, _tmp11_);
		_g_free0 (file_name);
	}
	_tmp12_ = self->priv->current_mode;
	if (_tmp12_ == CHEESE_MEDIA_MODE_PHOTO) {
		cheese_main_window_enable_mode_change (self);
	}
}


/**
   * Start to take a photo, starting a countdown if it is enabled.
   */
static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self) {
	cheese_main_window_finish_countdown_callback (self);
}


void cheese_main_window_take_photo (CheeseMainWindow* self) {
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "countdown");
	if (_tmp1_) {
		CheeseMediaMode _tmp2_;
		ClutterText* _tmp3_;
		CheeseCountdown* _tmp4_;
		CheeseCountdown* _tmp5_;
		_tmp2_ = self->priv->current_mode;
		if (_tmp2_ == CHEESE_MEDIA_MODE_PHOTO) {
			cheese_main_window_disable_mode_change (self);
		}
		_tmp3_ = self->priv->countdown_layer;
		_tmp4_ = cheese_countdown_new (_tmp3_);
		_g_object_unref0 (self->priv->current_countdown);
		self->priv->current_countdown = _tmp4_;
		_tmp5_ = self->priv->current_countdown;
		cheese_countdown_start (_tmp5_, _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback, self);
	} else {
		cheese_main_window_finish_countdown_callback (self);
	}
}


/**
   * Take a photo during burst mode, and increment the burst count.
   *
   * @return true if there are more photos to be taken in the current burst,
   * false otherwise
   */
static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->is_bursting;
	if (_tmp1_) {
		gint _tmp2_;
		GSettings* _tmp3_;
		gint _tmp4_ = 0;
		_tmp2_ = self->priv->burst_count;
		_tmp3_ = self->priv->settings;
		_tmp4_ = g_settings_get_int (_tmp3_, "burst-repeat");
		_tmp0_ = _tmp2_ < _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		gint _tmp6_;
		cheese_main_window_take_photo (self);
		_tmp6_ = self->priv->burst_count;
		self->priv->burst_count = _tmp6_ + 1;
		result = TRUE;
		return result;
	} else {
		cheese_main_window_toggle_photo_bursting (self, FALSE);
		result = FALSE;
		return result;
	}
}


/**
   * Cancel the current activity if the escape key is pressed.
   *
   * @param event the key event, to check which key was pressed
   * @return false, to allow further processing of the event
   */
static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gchar* key = NULL;
	GdkEventKey _tmp0_;
	guint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GCompareFunc _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.keyval;
	_tmp2_ = gdk_keyval_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (key);
	key = _tmp3_;
	_tmp4_ = g_strcmp0;
	_tmp5_ = key;
	_tmp6_ = _tmp4_ (_tmp5_, "Escape");
	if (_tmp6_ == 0) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		CheeseCountdown* _tmp10_;
		gboolean _tmp13_;
		gboolean _tmp15_;
		gboolean _tmp17_;
		_tmp10_ = self->priv->current_countdown;
		if (_tmp10_ != NULL) {
			CheeseCountdown* _tmp11_;
			gboolean _tmp12_;
			_tmp11_ = self->priv->current_countdown;
			_tmp12_ = _tmp11_->running;
			_tmp9_ = _tmp12_;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp13_ = _tmp9_;
		if (_tmp13_) {
			_tmp8_ = TRUE;
		} else {
			gboolean _tmp14_;
			_tmp14_ = self->priv->is_bursting;
			_tmp8_ = _tmp14_;
		}
		_tmp15_ = _tmp8_;
		if (_tmp15_) {
			_tmp7_ = TRUE;
		} else {
			gboolean _tmp16_;
			_tmp16_ = self->priv->is_recording;
			_tmp7_ = _tmp16_;
		}
		_tmp17_ = _tmp7_;
		if (_tmp17_) {
			CheeseMediaMode _tmp18_;
			self->priv->action_cancelled = TRUE;
			_tmp18_ = self->priv->current_mode;
			switch (_tmp18_) {
				case CHEESE_MEDIA_MODE_PHOTO:
				{
					CheeseCountdown* _tmp19_;
					_tmp19_ = self->priv->current_countdown;
					cheese_countdown_stop (_tmp19_);
					cheese_main_window_finish_countdown_callback (self);
					break;
				}
				case CHEESE_MEDIA_MODE_BURST:
				{
					cheese_main_window_toggle_photo_bursting (self, FALSE);
					break;
				}
				case CHEESE_MEDIA_MODE_VIDEO:
				{
					cheese_main_window_toggle_video_recording (self, FALSE);
					break;
				}
				default:
				break;
			}
			self->priv->action_cancelled = FALSE;
		} else {
			gboolean _tmp20_;
			_tmp20_ = self->priv->is_effects_selector_active;
			if (_tmp20_) {
			}
		}
	}
	result = FALSE;
	_g_free0 (key);
	return result;
}


/**
   * Toggle whether video recording is active.
   *
   * @param is_start whether to start video recording
   */
static gboolean _cheese_main_window_update_timeout_layer_gsource_func (gpointer self) {
	gboolean result;
	result = cheese_main_window_update_timeout_layer (self);
	return result;
}


void cheese_main_window_toggle_video_recording (CheeseMainWindow* self, gboolean is_start) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_start;
	if (_tmp0_) {
		CheeseCamera* _tmp1_;
		CheeseFileUtil* _tmp2_;
		CheeseMediaMode _tmp3_;
		const gchar* _tmp4_ = NULL;
		GtkLabel* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GtkButton* _tmp11_;
		const gchar* _tmp12_ = NULL;
		GtkImage* _tmp13_;
		_tmp1_ = self->priv->camera;
		_tmp2_ = self->priv->fileutil;
		_tmp3_ = self->priv->current_mode;
		_tmp4_ = cheese_fileutil_get_new_media_filename (_tmp2_, _tmp3_);
		cheese_camera_start_video_recording (_tmp1_, _tmp4_);
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _cheese_main_window_update_timeout_layer_gsource_func, g_object_ref (self), g_object_unref);
		_tmp5_ = self->priv->take_action_button_label;
		_tmp6_ = _ ("Stop _Recording");
		_tmp7_ = g_strconcat ("<b>", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp8_, "</b>", NULL);
		_tmp10_ = _tmp9_;
		gtk_label_set_label (_tmp5_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_tmp11_ = self->priv->take_action_button;
		_tmp12_ = _ ("Stop recording");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp11_, _tmp12_);
		_tmp13_ = self->priv->take_action_button_image;
		gtk_image_set_from_stock (_tmp13_, GTK_STOCK_MEDIA_STOP, GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = TRUE;
		cheese_main_window_disable_mode_change (self);
	} else {
		CheeseCamera* _tmp14_;
		ClutterText* _tmp15_;
		GtkLabel* _tmp16_;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GtkButton* _tmp22_;
		const gchar* _tmp23_ = NULL;
		GtkImage* _tmp24_;
		_tmp14_ = self->priv->camera;
		cheese_camera_stop_video_recording (_tmp14_);
		_tmp15_ = self->priv->timeout_layer;
		clutter_text_set_text (_tmp15_, "00:00:00");
		_tmp16_ = self->priv->take_action_button_label;
		_tmp17_ = _ ("_Record a Video");
		_tmp18_ = g_strconcat ("<b>", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp19_, "</b>", NULL);
		_tmp21_ = _tmp20_;
		gtk_label_set_label (_tmp16_, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_tmp22_ = self->priv->take_action_button;
		_tmp23_ = _ ("Record a video");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp22_, _tmp23_);
		_tmp24_ = self->priv->take_action_button_image;
		gtk_image_set_from_stock (_tmp24_, GTK_STOCK_MEDIA_RECORD, GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = FALSE;
		cheese_main_window_enable_mode_change (self);
	}
}


/**
   * Update the timeout layer displayed timer.
   *
   * @return false, if the source, Timeout.add_seconds (used
   * in the toogle_video_recording method), should be removed.
   */
static gboolean cheese_main_window_update_timeout_layer (CheeseMainWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->is_recording;
	if (_tmp0_) {
		ClutterText* _tmp1_;
		CheeseCamera* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp1_ = self->priv->timeout_layer;
		_tmp2_ = self->priv->camera;
		_tmp3_ = cheese_camera_get_recorded_time (_tmp2_);
		_tmp4_ = _tmp3_;
		clutter_text_set_text (_tmp1_, _tmp4_);
		_g_free0 (_tmp4_);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


/**
   * Toggle whether photo bursting is active.
   *
   * @param is_start whether to start capturing a photo burst
   */
static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self) {
	gboolean result;
	result = cheese_main_window_burst_take_photo (self);
	return result;
}


void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self, gboolean is_start) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_start;
	if (_tmp0_) {
		GtkLabel* _tmp1_;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GtkButton* _tmp7_;
		const gchar* _tmp8_ = NULL;
		GSettings* _tmp9_;
		gint _tmp10_ = 0;
		gint burst_delay;
		GSettings* _tmp11_;
		gint _tmp12_ = 0;
		gint countdown_duration;
		gboolean _tmp13_ = FALSE;
		gint _tmp14_;
		gint _tmp15_;
		gboolean _tmp18_;
		self->priv->is_bursting = TRUE;
		cheese_main_window_disable_mode_change (self);
		_tmp1_ = self->priv->take_action_button_label;
		_tmp2_ = _ ("Stop _Taking Pictures");
		_tmp3_ = g_strconcat ("<b>", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp4_, "</b>", NULL);
		_tmp6_ = _tmp5_;
		gtk_label_set_label (_tmp1_, _tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_tmp7_ = self->priv->take_action_button;
		_tmp8_ = _ ("Stop taking pictures");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp7_, _tmp8_);
		cheese_main_window_burst_take_photo (self);
		_tmp9_ = self->priv->settings;
		_tmp10_ = g_settings_get_int (_tmp9_, "burst-delay");
		burst_delay = _tmp10_;
		_tmp11_ = self->priv->settings;
		_tmp12_ = g_settings_get_int (_tmp11_, "countdown-duration");
		countdown_duration = 500 + (_tmp12_ * 1000);
		_tmp14_ = burst_delay;
		_tmp15_ = countdown_duration;
		if ((_tmp14_ - _tmp15_) < 1000) {
			GSettings* _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp16_ = self->priv->settings;
			_tmp17_ = g_settings_get_boolean (_tmp16_, "countdown");
			_tmp13_ = _tmp17_;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp18_ = _tmp13_;
		if (_tmp18_) {
			gint _tmp19_;
			guint _tmp20_ = 0U;
			_tmp19_ = countdown_duration;
			_tmp20_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp19_, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->burst_callback_id = _tmp20_;
		} else {
			gint _tmp21_;
			guint _tmp22_ = 0U;
			_tmp21_ = burst_delay;
			_tmp22_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp21_, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->burst_callback_id = _tmp22_;
		}
	} else {
		gboolean _tmp23_ = FALSE;
		CheeseCountdown* _tmp24_;
		gboolean _tmp27_;
		GtkLabel* _tmp29_;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		GtkButton* _tmp35_;
		const gchar* _tmp36_ = NULL;
		CheeseFileUtil* _tmp37_;
		guint _tmp38_;
		_tmp24_ = self->priv->current_countdown;
		if (_tmp24_ != NULL) {
			CheeseCountdown* _tmp25_;
			gboolean _tmp26_;
			_tmp25_ = self->priv->current_countdown;
			_tmp26_ = _tmp25_->running;
			_tmp23_ = _tmp26_;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp27_ = _tmp23_;
		if (_tmp27_) {
			CheeseCountdown* _tmp28_;
			_tmp28_ = self->priv->current_countdown;
			cheese_countdown_stop (_tmp28_);
		}
		self->priv->is_bursting = FALSE;
		cheese_main_window_enable_mode_change (self);
		_tmp29_ = self->priv->take_action_button_label;
		_tmp30_ = _ ("Take Multiple Photos");
		_tmp31_ = g_strconcat ("<b>", _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat (_tmp32_, "</b>", NULL);
		_tmp34_ = _tmp33_;
		gtk_label_set_label (_tmp29_, _tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
		_tmp35_ = self->priv->take_action_button;
		_tmp36_ = _ ("Take multiple photos");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp35_, _tmp36_);
		self->priv->burst_count = 0;
		_tmp37_ = self->priv->fileutil;
		cheese_fileutil_reset_burst (_tmp37_);
		_tmp38_ = self->priv->burst_callback_id;
		g_source_remove (_tmp38_);
	}
}


/**
     * Take a photo or burst of photos, or record a video, based on the current
     * capture mode.
     */
void cheese_main_window_shoot (CheeseMainWindow* self) {
	CheeseMediaMode _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_mode;
	switch (_tmp0_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			cheese_main_window_take_photo (self);
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			gboolean _tmp1_;
			_tmp1_ = self->priv->is_recording;
			cheese_main_window_toggle_video_recording (self, !_tmp1_);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			gboolean _tmp2_;
			_tmp2_ = self->priv->is_bursting;
			cheese_main_window_toggle_photo_bursting (self, !_tmp2_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


/**
     * Toggle the display of the effect selector.
     *
     * @param effects whether effects should be enabled
     */
void cheese_main_window_set_effects (gboolean effects, CheeseMainWindow* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = effects;
	cheese_main_window_toggle_effects_selector (self, _tmp0_);
}


/**
   * Change the selected effect, as a new one was selected.
   *
   * @param source unused
   * @param event unused
   * @return false, to allow further event processing
   */
gboolean cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, ClutterActor* source, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	ClutterActor* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	CheeseEffect* _tmp2_;
	CheeseCamera* _tmp3_;
	CheeseEffect* _tmp4_;
	GSettings* _tmp5_;
	CheeseEffect* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	cheese_main_window_toggle_effects_selector (self, FALSE);
	_tmp0_ = source;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "effect");
	_tmp2_ = _g_object_ref0 ((CheeseEffect*) _tmp1_);
	_g_object_unref0 (self->priv->selected_effect);
	self->priv->selected_effect = _tmp2_;
	_tmp3_ = self->priv->camera;
	_tmp4_ = self->priv->selected_effect;
	cheese_camera_set_effect (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->settings;
	_tmp6_ = self->priv->selected_effect;
	_tmp7_ = cheese_effect_get_name (_tmp6_);
	_tmp8_ = _tmp7_;
	g_settings_set_string (_tmp5_, "selected-effect", _tmp8_);
	result = FALSE;
	return result;
}


/**
   * Navigate back one page of effects.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_prev_effects_page (GtkAction* action, CheeseMainWindow* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->current_effects_page;
	if (_tmp0_ != 0) {
		gint _tmp1_;
		_tmp1_ = self->priv->current_effects_page;
		cheese_main_window_activate_effects_page (self, _tmp1_ - 1);
	}
}


/**
   * Navigate forward one page of effects.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_next_effects_page (GtkAction* action, CheeseMainWindow* self) {
	gint _tmp0_;
	CheeseEffectsManager* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->current_effects_page;
	_tmp1_ = self->priv->effects_manager;
	_tmp2_ = _tmp1_->effects;
	_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp0_ != (_tmp4_ / EFFECTS_PER_PAGE)) {
		gint _tmp5_;
		_tmp5_ = self->priv->current_effects_page;
		cheese_main_window_activate_effects_page (self, _tmp5_ + 1);
	}
}


/**
   * Switch to the supplied page of effects.
   *
   * @param number the effects page to switch to
   */
static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number) {
	gboolean _tmp0_;
	gint _tmp1_;
	ClutterBox* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* _tmp4_;
	ClutterBox* _tmp5_;
	gint _tmp6_ = 0;
	gboolean _tmp7_;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gpointer _tmp12_ = NULL;
	ClutterBox* _tmp13_;
	ClutterBox* _tmp14_;
	ClutterBox* _tmp15_;
	ClutterBox* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_effects_selector_active;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = number;
	self->priv->current_effects_page = _tmp1_;
	_tmp2_ = self->priv->viewport_layout;
	_tmp3_ = clutter_container_get_children ((ClutterContainer*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->current_effects_grid;
	_tmp6_ = g_list_index (_tmp4_, (ClutterActor*) _tmp5_);
	_tmp7_ = _tmp6_ != (-1);
	_g_list_free0 (_tmp4_);
	if (_tmp7_) {
		ClutterBox* _tmp8_;
		ClutterBox* _tmp9_;
		_tmp8_ = self->priv->viewport_layout;
		_tmp9_ = self->priv->current_effects_grid;
		clutter_container_remove ((ClutterContainer*) _tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, clutter_actor_get_type (), ClutterActor), NULL);
	}
	_tmp10_ = self->priv->effects_grids;
	_tmp11_ = number;
	_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
	_g_object_unref0 (self->priv->current_effects_grid);
	self->priv->current_effects_grid = (ClutterBox*) _tmp12_;
	_tmp13_ = self->priv->current_effects_grid;
	g_object_set ((GObject*) _tmp13_, "opacity", 0, NULL);
	_tmp14_ = self->priv->viewport_layout;
	_tmp15_ = self->priv->current_effects_grid;
	clutter_container_add ((ClutterContainer*) _tmp14_, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, clutter_actor_get_type (), ClutterActor), NULL);
	_tmp16_ = self->priv->current_effects_grid;
	clutter_actor_animate ((ClutterActor*) _tmp16_, (gulong) CLUTTER_LINEAR, (guint) 1000, "opacity", 255, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_;
				gint _tmp20_;
				CheeseEffectsManager* _tmp21_;
				GeeArrayList* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gint page_of_effect;
				CheeseEffectsManager* _tmp26_;
				GeeArrayList* _tmp27_;
				gint _tmp28_;
				gpointer _tmp29_ = NULL;
				CheeseEffect* effect;
				gint _tmp30_;
				gint _tmp31_;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp20_ = i;
				_tmp21_ = self->priv->effects_manager;
				_tmp22_ = _tmp21_->effects;
				_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp22_);
				_tmp24_ = _tmp23_;
				if (!(_tmp20_ < _tmp24_)) {
					break;
				}
				_tmp25_ = i;
				page_of_effect = _tmp25_ / EFFECTS_PER_PAGE;
				_tmp26_ = self->priv->effects_manager;
				_tmp27_ = _tmp26_->effects;
				_tmp28_ = i;
				_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _tmp28_);
				effect = (CheeseEffect*) _tmp29_;
				_tmp30_ = page_of_effect;
				_tmp31_ = number;
				if (_tmp30_ == _tmp31_) {
					CheeseEffect* _tmp32_;
					gboolean _tmp33_ = FALSE;
					CheeseEffect* _tmp40_;
					_tmp32_ = effect;
					_tmp33_ = cheese_effect_is_preview_connected (_tmp32_);
					if (!_tmp33_) {
						CheeseEffect* _tmp34_;
						gconstpointer _tmp35_ = NULL;
						ClutterTexture* _tmp36_;
						ClutterTexture* texture;
						CheeseCamera* _tmp37_;
						CheeseEffect* _tmp38_;
						ClutterTexture* _tmp39_;
						_tmp34_ = effect;
						_tmp35_ = g_object_get_data ((GObject*) _tmp34_, "texture");
						_tmp36_ = _g_object_ref0 ((ClutterTexture*) _tmp35_);
						texture = _tmp36_;
						_tmp37_ = self->priv->camera;
						_tmp38_ = effect;
						_tmp39_ = texture;
						cheese_camera_connect_effect_texture (_tmp37_, _tmp38_, _tmp39_);
						_g_object_unref0 (texture);
					}
					_tmp40_ = effect;
					cheese_effect_enable_preview (_tmp40_);
				} else {
					CheeseEffect* _tmp41_;
					gboolean _tmp42_ = FALSE;
					_tmp41_ = effect;
					_tmp42_ = cheese_effect_is_preview_connected (_tmp41_);
					if (_tmp42_) {
						CheeseEffect* _tmp43_;
						_tmp43_ = effect;
						cheese_effect_disable_preview (_tmp43_);
					}
				}
				_g_object_unref0 (effect);
			}
		}
	}
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}


/**
   * Control the sensitivity of the effects page navigation buttons.
   */
static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GtkAction* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	GtkAction* _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->is_effects_selector_active;
	if (_tmp1_) {
		gint _tmp2_;
		_tmp2_ = self->priv->current_effects_page;
		_tmp0_ = _tmp2_ != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = self->priv->effects_page_prev_action;
	_tmp4_ = _tmp0_;
	gtk_action_set_sensitive (_tmp3_, _tmp4_);
	_tmp6_ = self->priv->is_effects_selector_active;
	if (_tmp6_) {
		gint _tmp7_;
		CheeseEffectsManager* _tmp8_;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp7_ = self->priv->current_effects_page;
		_tmp8_ = self->priv->effects_manager;
		_tmp9_ = _tmp8_->effects;
		_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = _tmp7_ != (_tmp11_ / EFFECTS_PER_PAGE);
	} else {
		_tmp5_ = FALSE;
	}
	_tmp12_ = self->priv->effects_page_next_action;
	_tmp13_ = _tmp5_;
	gtk_action_set_sensitive (_tmp12_, _tmp13_);
}


/**
   * Toggle the visibility of the effects selector.
   *
   * @param active whether the selector should be active
   */
static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	CheeseCamera* _tmp17_;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = active;
	self->priv->is_effects_selector_active = _tmp0_;
	_tmp1_ = active;
	if (_tmp1_) {
		ClutterTexture* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = self->priv->video_preview;
		clutter_actor_hide ((ClutterActor*) _tmp2_);
		_tmp3_ = self->priv->effects_grids;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == 0) {
			ClutterText* _tmp6_;
			const gchar* _tmp7_ = NULL;
			ClutterText* _tmp8_;
			_tmp6_ = self->priv->error_layer;
			_tmp7_ = _ ("No effects found");
			clutter_text_set_text (_tmp6_, _tmp7_);
			_tmp8_ = self->priv->error_layer;
			clutter_actor_show ((ClutterActor*) _tmp8_);
		} else {
			ClutterBox* _tmp9_;
			gint _tmp10_;
			_tmp9_ = self->priv->current_effects_grid;
			clutter_actor_show ((ClutterActor*) _tmp9_);
			_tmp10_ = self->priv->current_effects_page;
			cheese_main_window_activate_effects_page (self, _tmp10_);
		}
	} else {
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		ClutterTexture* _tmp16_;
		_tmp11_ = self->priv->effects_grids;
		_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ == 0) {
			ClutterText* _tmp14_;
			_tmp14_ = self->priv->error_layer;
			clutter_actor_hide ((ClutterActor*) _tmp14_);
		} else {
			ClutterBox* _tmp15_;
			_tmp15_ = self->priv->current_effects_grid;
			clutter_actor_hide ((ClutterActor*) _tmp15_);
		}
		_tmp16_ = self->priv->video_preview;
		clutter_actor_show ((ClutterActor*) _tmp16_);
	}
	_tmp17_ = self->priv->camera;
	_tmp18_ = active;
	cheese_camera_toggle_effects_pipeline (_tmp17_, _tmp18_);
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}


/**
   * Create the effects selector.
   */
static gboolean _cheese_main_window_on_selected_effect_change_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_selected_effect_change (self, _sender, event);
	return result;
}


static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self) {
	ClutterBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_effects_grid;
	if (_tmp0_ == NULL) {
		CheeseEffectsManager* _tmp1_;
		CheeseEffectsManager* _tmp2_;
		GeeArrayList* _tmp3_;
		CheeseEffectsManager* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GeeArrayList* _tmp83_;
		gpointer _tmp84_ = NULL;
		_tmp1_ = cheese_effects_manager_new ();
		_g_object_unref0 (self->priv->effects_manager);
		self->priv->effects_manager = _tmp1_;
		_tmp2_ = self->priv->effects_manager;
		cheese_effects_manager_load_effects (_tmp2_);
		_tmp3_ = gee_array_list_new (clutter_box_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		_g_object_unref0 (self->priv->effects_grids);
		self->priv->effects_grids = _tmp3_;
		_tmp4_ = self->priv->effects_manager;
		_tmp5_ = _tmp4_->effects;
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == 0) {
			g_warning ("cheese-window.vala:1191: gnome-video-effects is not installed.");
			return;
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					gboolean _tmp9_;
					gint _tmp11_;
					CheeseEffectsManager* _tmp12_;
					GeeArrayList* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					ClutterTableLayout* _tmp16_;
					ClutterTableLayout* table_layout;
					ClutterTableLayout* _tmp17_;
					ClutterBox* _tmp18_;
					ClutterBox* grid;
					GeeArrayList* _tmp19_;
					ClutterBox* _tmp20_;
					ClutterTableLayout* _tmp21_;
					ClutterTableLayout* _tmp22_;
					_tmp9_ = _tmp8_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp11_ = i;
					_tmp12_ = self->priv->effects_manager;
					_tmp13_ = _tmp12_->effects;
					_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
					_tmp15_ = _tmp14_;
					if (!(_tmp11_ <= (_tmp15_ / EFFECTS_PER_PAGE))) {
						break;
					}
					_tmp16_ = (ClutterTableLayout*) clutter_table_layout_new ();
					g_object_ref_sink (_tmp16_);
					table_layout = _tmp16_;
					_tmp17_ = table_layout;
					_tmp18_ = (ClutterBox*) clutter_box_new ((ClutterLayoutManager*) _tmp17_);
					g_object_ref_sink (_tmp18_);
					grid = _tmp18_;
					_tmp19_ = self->priv->effects_grids;
					_tmp20_ = grid;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
					_tmp21_ = table_layout;
					clutter_table_layout_set_column_spacing (_tmp21_, (guint) 10);
					_tmp22_ = table_layout;
					clutter_table_layout_set_row_spacing (_tmp22_, (guint) 10);
					_g_object_unref0 (grid);
					_g_object_unref0 (table_layout);
				}
			}
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp23_;
				_tmp23_ = TRUE;
				while (TRUE) {
					gboolean _tmp24_;
					gint _tmp26_;
					CheeseEffectsManager* _tmp27_;
					GeeArrayList* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					CheeseEffectsManager* _tmp31_;
					GeeArrayList* _tmp32_;
					gint _tmp33_;
					gpointer _tmp34_ = NULL;
					CheeseEffect* effect;
					ClutterTexture* _tmp35_;
					ClutterTexture* texture;
					ClutterBinLayout* _tmp36_;
					ClutterBinLayout* layout;
					ClutterBinLayout* _tmp37_;
					ClutterBox* _tmp38_;
					ClutterBox* box;
					ClutterText* _tmp39_;
					ClutterText* text;
					ClutterRectangle* _tmp40_;
					ClutterRectangle* rect;
					ClutterRectangle* _tmp41_;
					ClutterRectangle* _tmp42_;
					ClutterColor _tmp43_ = {0};
					ClutterTexture* _tmp44_;
					ClutterBox* _tmp45_;
					ClutterTexture* _tmp46_;
					ClutterBox* _tmp47_;
					ClutterBox* _tmp48_;
					CheeseEffect* _tmp49_;
					CheeseEffect* _tmp50_;
					CheeseEffect* _tmp51_;
					ClutterTexture* _tmp52_;
					ClutterTexture* _tmp53_;
					ClutterBox* _tmp54_;
					ClutterText* _tmp55_;
					CheeseEffect* _tmp56_;
					const gchar* _tmp57_;
					const gchar* _tmp58_;
					ClutterText* _tmp59_;
					ClutterColor _tmp60_ = {0};
					ClutterRectangle* _tmp61_;
					ClutterText* _tmp62_;
					gfloat _tmp63_;
					gfloat _tmp64_;
					ClutterBox* _tmp65_;
					ClutterRectangle* _tmp66_;
					ClutterBox* _tmp67_;
					ClutterText* _tmp68_;
					GeeArrayList* _tmp69_;
					gint _tmp70_;
					gpointer _tmp71_ = NULL;
					ClutterBox* _tmp72_;
					ClutterLayoutManager* _tmp73_;
					ClutterLayoutManager* _tmp74_;
					ClutterTableLayout* _tmp75_;
					ClutterTableLayout* _tmp76_;
					ClutterTableLayout* table_layout;
					ClutterTableLayout* _tmp77_;
					ClutterBox* _tmp78_;
					gint _tmp79_;
					gint _tmp80_;
					ClutterTableLayout* _tmp81_;
					ClutterBox* _tmp82_;
					_tmp24_ = _tmp23_;
					if (!_tmp24_) {
						gint _tmp25_;
						_tmp25_ = i;
						i = _tmp25_ + 1;
					}
					_tmp23_ = FALSE;
					_tmp26_ = i;
					_tmp27_ = self->priv->effects_manager;
					_tmp28_ = _tmp27_->effects;
					_tmp29_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp28_);
					_tmp30_ = _tmp29_;
					if (!(_tmp26_ < _tmp30_)) {
						break;
					}
					_tmp31_ = self->priv->effects_manager;
					_tmp32_ = _tmp31_->effects;
					_tmp33_ = i;
					_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _tmp33_);
					effect = (CheeseEffect*) _tmp34_;
					_tmp35_ = (ClutterTexture*) clutter_texture_new ();
					g_object_ref_sink (_tmp35_);
					texture = _tmp35_;
					_tmp36_ = (ClutterBinLayout*) clutter_bin_layout_new (CLUTTER_BIN_ALIGNMENT_CENTER, CLUTTER_BIN_ALIGNMENT_CENTER);
					g_object_ref_sink (_tmp36_);
					layout = _tmp36_;
					_tmp37_ = layout;
					_tmp38_ = (ClutterBox*) clutter_box_new ((ClutterLayoutManager*) _tmp37_);
					g_object_ref_sink (_tmp38_);
					box = _tmp38_;
					_tmp39_ = (ClutterText*) clutter_text_new ();
					g_object_ref_sink (_tmp39_);
					text = _tmp39_;
					_tmp40_ = (ClutterRectangle*) clutter_rectangle_new ();
					g_object_ref_sink (_tmp40_);
					rect = _tmp40_;
					_tmp41_ = rect;
					clutter_actor_set_opacity ((ClutterActor*) _tmp41_, (guint) 128);
					_tmp42_ = rect;
					clutter_color_from_string (&_tmp43_, "black");
					clutter_rectangle_set_color (_tmp42_, &_tmp43_);
					_tmp44_ = texture;
					clutter_texture_set_keep_aspect_ratio (_tmp44_, TRUE);
					_tmp45_ = box;
					_tmp46_ = texture;
					clutter_box_pack (_tmp45_, G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, clutter_actor_get_type (), ClutterActor), NULL, NULL, NULL);
					_tmp47_ = box;
					clutter_actor_set_reactive ((ClutterActor*) _tmp47_, TRUE);
					_tmp48_ = box;
					_tmp49_ = effect;
					_tmp50_ = _g_object_ref0 (_tmp49_);
					g_object_set_data_full ((GObject*) _tmp48_, "effect", _tmp50_, g_object_unref);
					_tmp51_ = effect;
					_tmp52_ = texture;
					_tmp53_ = _g_object_ref0 (_tmp52_);
					g_object_set_data_full ((GObject*) _tmp51_, "texture", _tmp53_, g_object_unref);
					_tmp54_ = box;
					g_signal_connect_object ((ClutterActor*) _tmp54_, "button-release-event", (GCallback) _cheese_main_window_on_selected_effect_change_clutter_actor_button_release_event, self, 0);
					_tmp55_ = text;
					_tmp56_ = effect;
					_tmp57_ = cheese_effect_get_name (_tmp56_);
					_tmp58_ = _tmp57_;
					clutter_text_set_text (_tmp55_, _tmp58_);
					_tmp59_ = text;
					clutter_color_from_string (&_tmp60_, "white");
					clutter_text_set_color (_tmp59_, &_tmp60_);
					_tmp61_ = rect;
					_tmp62_ = text;
					_tmp63_ = clutter_actor_get_height ((ClutterActor*) _tmp62_);
					_tmp64_ = _tmp63_;
					clutter_actor_set_height ((ClutterActor*) _tmp61_, _tmp64_ + 5);
					_tmp65_ = box;
					_tmp66_ = rect;
					clutter_box_pack (_tmp65_, G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, clutter_actor_get_type (), ClutterActor), "x-align", CLUTTER_BIN_ALIGNMENT_FILL, "y-align", CLUTTER_BIN_ALIGNMENT_END, NULL, NULL);
					_tmp67_ = box;
					_tmp68_ = text;
					clutter_box_pack (_tmp67_, G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, clutter_actor_get_type (), ClutterActor), "x-align", CLUTTER_BIN_ALIGNMENT_CENTER, "y-align", CLUTTER_BIN_ALIGNMENT_END, NULL, NULL);
					_tmp69_ = self->priv->effects_grids;
					_tmp70_ = i;
					_tmp71_ = gee_abstract_list_get ((GeeAbstractList*) _tmp69_, _tmp70_ / EFFECTS_PER_PAGE);
					_tmp72_ = (ClutterBox*) _tmp71_;
					_tmp73_ = clutter_box_get_layout_manager (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, clutter_table_layout_get_type (), ClutterTableLayout));
					_tmp76_ = _tmp75_;
					_g_object_unref0 (_tmp72_);
					table_layout = _tmp76_;
					_tmp77_ = table_layout;
					_tmp78_ = box;
					_tmp79_ = i;
					_tmp80_ = i;
					clutter_table_layout_pack (_tmp77_, G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, clutter_actor_get_type (), ClutterActor), (_tmp79_ % EFFECTS_PER_PAGE) % 3, (_tmp80_ % EFFECTS_PER_PAGE) / 3);
					_tmp81_ = table_layout;
					_tmp82_ = box;
					clutter_table_layout_set_expand (_tmp81_, (ClutterActor*) _tmp82_, FALSE, FALSE);
					_g_object_unref0 (table_layout);
					_g_object_unref0 (rect);
					_g_object_unref0 (text);
					_g_object_unref0 (box);
					_g_object_unref0 (layout);
					_g_object_unref0 (texture);
					_g_object_unref0 (effect);
				}
			}
		}
		cheese_main_window_setup_effects_page_switch_sensitivity (self);
		_tmp83_ = self->priv->effects_grids;
		_tmp84_ = gee_abstract_list_get ((GeeAbstractList*) _tmp83_, 0);
		_g_object_unref0 (self->priv->current_effects_grid);
		self->priv->current_effects_grid = (ClutterBox*) _tmp84_;
	}
}


/**
   * Toggle the sensitvity of the camera actions.
   *
   * @param active whether the camera actions should be sensitive
   */
void cheese_main_window_toggle_camera_actions_sensitivities (CheeseMainWindow* self, gboolean active) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = active;
	self->priv->is_camera_actions_sensitive = _tmp0_;
	_tmp1_ = active;
	if (_tmp1_) {
		{
			GeeHashMap* _tmp2_;
			GeeSet* _tmp3_;
			GeeSet* _tmp4_;
			GeeSet* _tmp5_;
			GeeIterator* _tmp6_ = NULL;
			GeeIterator* _tmp7_;
			GeeIterator* _key_it;
			_tmp2_ = self->priv->action_sensitivities;
			_tmp3_ = gee_abstract_map_get_keys ((GeeMap*) _tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
			_tmp7_ = _tmp6_;
			_g_object_unref0 (_tmp5_);
			_key_it = _tmp7_;
			while (TRUE) {
				GeeIterator* _tmp8_;
				gboolean _tmp9_ = FALSE;
				GeeIterator* _tmp10_;
				gpointer _tmp11_ = NULL;
				gchar* key;
				GtkBuilder* _tmp12_;
				const gchar* _tmp13_;
				GObject* _tmp14_ = NULL;
				GtkAction* _tmp15_;
				GtkAction* action;
				GtkAction* _tmp16_;
				GeeHashMap* _tmp17_;
				const gchar* _tmp18_;
				gpointer _tmp19_ = NULL;
				_tmp8_ = _key_it;
				_tmp9_ = gee_iterator_next (_tmp8_);
				if (!_tmp9_) {
					break;
				}
				_tmp10_ = _key_it;
				_tmp11_ = gee_iterator_get (_tmp10_);
				key = (gchar*) _tmp11_;
				_tmp12_ = self->priv->gtk_builder;
				_tmp13_ = key;
				_tmp14_ = gtk_builder_get_object (_tmp12_, _tmp13_);
				_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, GTK_TYPE_ACTION) ? ((GtkAction*) _tmp14_) : NULL);
				action = _tmp15_;
				_tmp16_ = action;
				_tmp17_ = self->priv->action_sensitivities;
				_tmp18_ = key;
				_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, _tmp18_);
				gtk_action_set_sensitive (_tmp16_, (gboolean) ((gintptr) _tmp19_));
				_g_object_unref0 (action);
				_g_free0 (key);
			}
			_g_object_unref0 (_key_it);
		}
	} else {
		GHashFunc _tmp20_;
		GeeHashMap* _tmp21_;
		GtkBuilder* _tmp22_;
		GSList* _tmp23_ = NULL;
		GSList* objects;
		GSList* _tmp24_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar** _tmp44_ = NULL;
		gchar** active_actions;
		gint active_actions_length1;
		gint _active_actions_size_;
		gboolean flag = FALSE;
		GSList* _tmp45_;
		_tmp20_ = g_str_hash;
		_tmp21_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_BOOLEAN, NULL, NULL, _tmp20_, NULL, NULL);
		_g_object_unref0 (self->priv->action_sensitivities);
		self->priv->action_sensitivities = _tmp21_;
		_tmp22_ = self->priv->gtk_builder;
		_tmp23_ = gtk_builder_get_objects (_tmp22_);
		objects = _tmp23_;
		_tmp24_ = objects;
		{
			GSList* obj_collection = NULL;
			GSList* obj_it = NULL;
			obj_collection = _tmp24_;
			for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
				GObject* _tmp25_;
				GObject* obj = NULL;
				_tmp25_ = _g_object_ref0 ((GObject*) obj_it->data);
				obj = _tmp25_;
				{
					GObject* _tmp26_;
					_tmp26_ = obj;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, GTK_TYPE_ACTION)) {
						GObject* _tmp27_;
						GtkAction* _tmp28_;
						GtkAction* action;
						GeeHashMap* _tmp29_;
						GtkAction* _tmp30_;
						const gchar* _tmp31_;
						const gchar* _tmp32_;
						GtkAction* _tmp33_;
						gboolean _tmp34_;
						gboolean _tmp35_;
						_tmp27_ = obj;
						_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GTK_TYPE_ACTION, GtkAction));
						action = _tmp28_;
						_tmp29_ = self->priv->action_sensitivities;
						_tmp30_ = action;
						_tmp31_ = gtk_action_get_name (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = action;
						_tmp34_ = gtk_action_get_sensitive (_tmp33_);
						_tmp35_ = _tmp34_;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, _tmp32_, (gpointer) ((gintptr) _tmp35_));
						_g_object_unref0 (action);
					}
					_g_object_unref0 (obj);
				}
			}
		}
		_tmp36_ = g_strdup ("quit");
		_tmp37_ = g_strdup ("help_contents");
		_tmp38_ = g_strdup ("about");
		_tmp39_ = g_strdup ("open");
		_tmp40_ = g_strdup ("save_as");
		_tmp41_ = g_strdup ("move_to_trash");
		_tmp42_ = g_strdup ("delete");
		_tmp43_ = g_strdup ("move_all_to_trash");
		_tmp44_ = g_new0 (gchar*, 8 + 1);
		_tmp44_[0] = _tmp36_;
		_tmp44_[1] = _tmp37_;
		_tmp44_[2] = _tmp38_;
		_tmp44_[3] = _tmp39_;
		_tmp44_[4] = _tmp40_;
		_tmp44_[5] = _tmp41_;
		_tmp44_[6] = _tmp42_;
		_tmp44_[7] = _tmp43_;
		active_actions = _tmp44_;
		active_actions_length1 = 8;
		_active_actions_size_ = active_actions_length1;
		_tmp45_ = objects;
		{
			GSList* obj_collection = NULL;
			GSList* obj_it = NULL;
			obj_collection = _tmp45_;
			for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
				GObject* _tmp46_;
				GObject* obj = NULL;
				_tmp46_ = _g_object_ref0 ((GObject*) obj_it->data);
				obj = _tmp46_;
				{
					GObject* _tmp47_;
					flag = FALSE;
					_tmp47_ = obj;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, GTK_TYPE_ACTION)) {
						GObject* _tmp48_;
						GtkAction* _tmp49_;
						GtkAction* action;
						gchar** _tmp50_;
						gint _tmp50__length1;
						gboolean _tmp56_;
						_tmp48_ = obj;
						_tmp49_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, GTK_TYPE_ACTION, GtkAction));
						action = _tmp49_;
						_tmp50_ = active_actions;
						_tmp50__length1 = active_actions_length1;
						{
							gchar** s_collection = NULL;
							gint s_collection_length1 = 0;
							gint _s_collection_size_ = 0;
							gint s_it = 0;
							s_collection = _tmp50_;
							s_collection_length1 = _tmp50__length1;
							for (s_it = 0; s_it < _tmp50__length1; s_it = s_it + 1) {
								gchar* _tmp51_;
								gchar* s = NULL;
								_tmp51_ = g_strdup (s_collection[s_it]);
								s = _tmp51_;
								{
									GtkAction* _tmp52_;
									const gchar* _tmp53_;
									const gchar* _tmp54_;
									const gchar* _tmp55_;
									_tmp52_ = action;
									_tmp53_ = gtk_action_get_name (_tmp52_);
									_tmp54_ = _tmp53_;
									_tmp55_ = s;
									if (g_strcmp0 (_tmp54_, _tmp55_) == 0) {
										flag = TRUE;
									}
									_g_free0 (s);
								}
							}
						}
						_tmp56_ = flag;
						if (!_tmp56_) {
							GObject* _tmp57_;
							_tmp57_ = obj;
							gtk_action_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, GTK_TYPE_ACTION, GtkAction), FALSE);
						}
						_g_object_unref0 (action);
					}
					_g_object_unref0 (obj);
				}
			}
		}
		active_actions = (_vala_array_free (active_actions, active_actions_length1, (GDestroyNotify) g_free), NULL);
		_g_slist_free0 (objects);
	}
}


/**
     * Update the UI when the camera starts playing.
     */
void cheese_main_window_camera_state_change_playing (CheeseMainWindow* self) {
	gboolean _tmp0_;
	CheeseEffectsManager* _tmp1_;
	GSettings* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	CheeseEffect* _tmp5_ = NULL;
	CheeseEffect* _tmp6_;
	CheeseEffect* effect;
	CheeseEffect* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_camera_actions_sensitive;
	if (!_tmp0_) {
		cheese_main_window_toggle_camera_actions_sensitivities (self, TRUE);
	}
	_tmp1_ = self->priv->effects_manager;
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_string (_tmp2_, "selected-effect");
	_tmp4_ = _tmp3_;
	_tmp5_ = cheese_effects_manager_get_effect (_tmp1_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	effect = _tmp6_;
	_tmp7_ = effect;
	if (_tmp7_ != NULL) {
		CheeseCamera* _tmp8_;
		CheeseEffect* _tmp9_;
		_tmp8_ = self->priv->camera;
		_tmp9_ = effect;
		cheese_camera_set_effect (_tmp8_, _tmp9_);
	}
	_g_object_unref0 (effect);
}


/**
   * Set wide mode active when started from the command line (and do not change
   * the GSetting).
   */
void cheese_main_window_set_startup_wide_mode (CheeseMainWindow* self) {
	gboolean _tmp0_;
	GtkToggleAction* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_wide_mode;
	if (_tmp0_) {
		return;
	}
	self->priv->is_command_line_startup = TRUE;
	_tmp1_ = self->priv->wide_mode_action;
	gtk_toggle_action_set_active (_tmp1_, TRUE);
	self->priv->is_command_line_startup = FALSE;
}


/**
   * Set fullscreen mode active when started from the command line (and do not
   * change the GSetting).
   */
void cheese_main_window_set_startup_fullscreen_mode (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	self->priv->is_command_line_startup = TRUE;
	cheese_main_window_set_fullscreen (TRUE, self);
	self->priv->is_command_line_startup = FALSE;
}


/**
   * Load the UI from the GtkBuilder description.
   */
static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self) {
	cheese_main_window_on_stage_resize (self, _sender, box, flags);
}


static gboolean _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_thumbnail_mouse_button_press (self, _sender, event);
	return result;
}


static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_key_release (self, event);
	return result;
}


void cheese_main_window_setup_ui (CheeseMainWindow* self) {
	GtkBuilder* _tmp0_;
	ClutterScript* _tmp1_;
	CheeseFileUtil* _tmp2_;
	CheeseFlash* _tmp3_;
	GSettings* _tmp4_;
	GtkBuilder* _tmp16_;
	GObject* _tmp17_ = NULL;
	GtkGrid* _tmp18_;
	GtkBuilder* _tmp19_;
	GObject* _tmp20_ = NULL;
	GtkWidget* _tmp21_;
	GtkBuilder* _tmp22_;
	GObject* _tmp23_ = NULL;
	GtkClutterEmbed* _tmp24_;
	GtkClutterEmbed* _tmp25_;
	ClutterActor* _tmp26_ = NULL;
	ClutterStage* _tmp27_;
	GtkBuilder* _tmp28_;
	GObject* _tmp29_ = NULL;
	GtkAlignment* _tmp30_;
	GtkBuilder* _tmp31_;
	GObject* _tmp32_ = NULL;
	GtkAlignment* _tmp33_;
	GtkBuilder* _tmp34_;
	GObject* _tmp35_ = NULL;
	GtkBox* _tmp36_;
	GtkBuilder* _tmp37_;
	GObject* _tmp38_ = NULL;
	GtkToggleButton* _tmp39_;
	GtkBuilder* _tmp40_;
	GObject* _tmp41_ = NULL;
	GtkToggleButton* _tmp42_;
	GtkBuilder* _tmp43_;
	GObject* _tmp44_ = NULL;
	GtkToggleButton* _tmp45_;
	GtkBuilder* _tmp46_;
	GObject* _tmp47_ = NULL;
	GtkButton* _tmp48_;
	GtkBuilder* _tmp49_;
	GObject* _tmp50_ = NULL;
	GtkLabel* _tmp51_;
	GtkBuilder* _tmp52_;
	GObject* _tmp53_ = NULL;
	GtkImage* _tmp54_;
	GtkBuilder* _tmp55_;
	GObject* _tmp56_ = NULL;
	GtkToggleButton* _tmp57_;
	GtkBuilder* _tmp58_;
	GObject* _tmp59_ = NULL;
	GtkButton* _tmp60_;
	GtkBuilder* _tmp61_;
	GObject* _tmp62_ = NULL;
	GtkBox* _tmp63_;
	GtkBuilder* _tmp64_;
	GObject* _tmp65_ = NULL;
	GtkMenu* _tmp66_;
	GtkBuilder* _tmp67_;
	GObject* _tmp68_ = NULL;
	GtkAction* _tmp69_;
	GtkBuilder* _tmp70_;
	GObject* _tmp71_ = NULL;
	GtkToggleAction* _tmp72_;
	GtkBuilder* _tmp73_;
	GObject* _tmp74_ = NULL;
	GtkAction* _tmp75_;
	GtkBuilder* _tmp76_;
	GObject* _tmp77_ = NULL;
	GtkAction* _tmp78_;
	GtkBuilder* _tmp79_;
	GObject* _tmp80_ = NULL;
	GtkAction* _tmp81_;
	CheeseShareableMedia* _tmp82_;
	GtkToggleButton* _tmp83_;
	GtkButton* _tmp84_;
	GtkToggleButton* _tmp85_;
	GtkButton* _tmp86_;
	GtkToggleButton* _tmp87_;
	GtkButton* _tmp88_;
	GtkButton* _tmp89_;
	GtkButton* _tmp90_;
	GtkToggleButton* _tmp91_;
	GtkButton* _tmp92_;
	GtkButton* _tmp93_;
	GtkButton* _tmp94_;
	GtkButton** _tmp95_ = NULL;
	ClutterScript* _tmp96_;
	GObject* _tmp97_ = NULL;
	ClutterTexture* _tmp98_;
	ClutterScript* _tmp99_;
	GObject* _tmp100_ = NULL;
	ClutterBox* _tmp101_;
	ClutterScript* _tmp102_;
	GObject* _tmp103_ = NULL;
	ClutterBinLayout* _tmp104_;
	ClutterScript* _tmp105_;
	GObject* _tmp106_ = NULL;
	ClutterText* _tmp107_;
	ClutterScript* _tmp108_;
	GObject* _tmp109_ = NULL;
	ClutterRectangle* _tmp110_;
	ClutterScript* _tmp111_;
	GObject* _tmp112_ = NULL;
	ClutterText* _tmp113_;
	ClutterScript* _tmp114_;
	GObject* _tmp115_ = NULL;
	ClutterText* _tmp116_;
	ClutterTexture* _tmp117_;
	ClutterTexture* _tmp118_;
	ClutterStage* _tmp119_;
	ClutterRectangle* _tmp120_;
	ClutterBox* _tmp121_;
	ClutterBinLayout* _tmp122_;
	ClutterStage* _tmp123_;
	ClutterBox* _tmp124_;
	ClutterStage* _tmp125_;
	ClutterText* _tmp126_;
	ClutterStage* _tmp127_;
	CheeseThumbView* _tmp128_;
	CheeseThumbView* _tmp129_;
	EogThumbNav* _tmp130_;
	GtkCssProvider* css = NULL;
	GtkStyleContext* context = NULL;
	CheeseThumbView* _tmp137_;
	GtkStyleContext* _tmp138_ = NULL;
	GtkStyleContext* _tmp139_;
	GdkScreen* _tmp140_ = NULL;
	GtkStyleContext* _tmp141_;
	GdkScreen* _tmp142_;
	GdkScreen* _tmp143_;
	CheeseThumbView* _tmp144_;
	GtkGrid* _tmp145_;
	GtkGrid* _tmp146_;
	GtkClutterEmbed* _tmp147_;
	GtkToggleAction* _tmp148_;
	GSettings* _tmp149_;
	gboolean _tmp150_ = FALSE;
	GSettings* _tmp151_;
	gboolean _tmp152_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->gtk_builder);
	self->priv->gtk_builder = _tmp0_;
	_tmp1_ = clutter_script_new ();
	_g_object_unref0 (self->priv->clutter_builder);
	self->priv->clutter_builder = _tmp1_;
	_tmp2_ = cheese_fileutil_new ();
	_g_object_unref0 (self->priv->fileutil);
	self->priv->fileutil = _tmp2_;
	_tmp3_ = cheese_flash_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->flash);
	self->priv->flash = _tmp3_;
	_tmp4_ = g_settings_new ("org.gnome.Cheese");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	{
		GtkBuilder* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		GtkBuilder* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		GtkBuilder* _tmp11_;
		ClutterScript* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		_tmp5_ = self->priv->gtk_builder;
		_tmp6_ = g_build_filename (PACKAGE_DATADIR, "cheese-actions.ui", NULL);
		_tmp7_ = _tmp6_;
		gtk_builder_add_from_file (_tmp5_, _tmp7_, &_inner_error_);
		_g_free0 (_tmp7_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		_tmp8_ = self->priv->gtk_builder;
		_tmp9_ = g_build_filename (PACKAGE_DATADIR, "cheese-main-window.ui", NULL);
		_tmp10_ = _tmp9_;
		gtk_builder_add_from_file (_tmp8_, _tmp10_, &_inner_error_);
		_g_free0 (_tmp10_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		_tmp11_ = self->priv->gtk_builder;
		gtk_builder_connect_signals (_tmp11_, self);
		_tmp12_ = self->priv->clutter_builder;
		_tmp13_ = g_build_filename (PACKAGE_DATADIR, "cheese-viewport.json", NULL);
		_tmp14_ = _tmp13_;
		clutter_script_load_from_file (_tmp12_, _tmp14_, &_inner_error_);
		_g_free0 (_tmp14_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp15_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = err->message;
		g_error ("cheese-window.vala:1375: Error: %s", _tmp15_);
		_g_error_free0 (err);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp16_ = self->priv->gtk_builder;
	_tmp17_ = gtk_builder_get_object (_tmp16_, "mainbox_normal");
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp17_) : NULL);
	_g_object_unref0 (self->priv->main_vbox);
	self->priv->main_vbox = _tmp18_;
	_tmp19_ = self->priv->gtk_builder;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "thumbnails");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp20_) : NULL);
	_g_object_unref0 (self->priv->thumbnails);
	self->priv->thumbnails = _tmp21_;
	_tmp22_ = self->priv->gtk_builder;
	_tmp23_ = gtk_builder_get_object (_tmp22_, "viewport");
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, gtk_clutter_embed_get_type ()) ? ((GtkClutterEmbed*) _tmp23_) : NULL);
	_g_object_unref0 (self->priv->viewport_widget);
	self->priv->viewport_widget = _tmp24_;
	_tmp25_ = self->priv->viewport_widget;
	_tmp26_ = gtk_clutter_embed_get_stage (_tmp25_);
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, clutter_stage_get_type ()) ? ((ClutterStage*) _tmp26_) : NULL);
	_g_object_unref0 (self->priv->viewport);
	self->priv->viewport = _tmp27_;
	_tmp28_ = self->priv->gtk_builder;
	_tmp29_ = gtk_builder_get_object (_tmp28_, "thumbnails_right");
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, GTK_TYPE_ALIGNMENT) ? ((GtkAlignment*) _tmp29_) : NULL);
	_g_object_unref0 (self->priv->thumbnails_right);
	self->priv->thumbnails_right = _tmp30_;
	_tmp31_ = self->priv->gtk_builder;
	_tmp32_ = gtk_builder_get_object (_tmp31_, "thumbnails_bottom");
	_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, GTK_TYPE_ALIGNMENT) ? ((GtkAlignment*) _tmp32_) : NULL);
	_g_object_unref0 (self->priv->thumbnails_bottom);
	self->priv->thumbnails_bottom = _tmp33_;
	_tmp34_ = self->priv->gtk_builder;
	_tmp35_ = gtk_builder_get_object (_tmp34_, "leave_fullscreen_button_bin");
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, GTK_TYPE_BOX) ? ((GtkBox*) _tmp35_) : NULL);
	_g_object_unref0 (self->priv->leave_fullscreen_button_container);
	self->priv->leave_fullscreen_button_container = _tmp36_;
	_tmp37_ = self->priv->gtk_builder;
	_tmp38_ = gtk_builder_get_object (_tmp37_, "photo_toggle_button");
	_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp38_) : NULL);
	_g_object_unref0 (self->priv->photo_toggle_button);
	self->priv->photo_toggle_button = _tmp39_;
	_tmp40_ = self->priv->gtk_builder;
	_tmp41_ = gtk_builder_get_object (_tmp40_, "video_toggle_button");
	_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp41_) : NULL);
	_g_object_unref0 (self->priv->video_toggle_button);
	self->priv->video_toggle_button = _tmp42_;
	_tmp43_ = self->priv->gtk_builder;
	_tmp44_ = gtk_builder_get_object (_tmp43_, "burst_toggle_button");
	_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp44_) : NULL);
	_g_object_unref0 (self->priv->burst_toggle_button);
	self->priv->burst_toggle_button = _tmp45_;
	_tmp46_ = self->priv->gtk_builder;
	_tmp47_ = gtk_builder_get_object (_tmp46_, "take_action_button");
	_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp47_) : NULL);
	_g_object_unref0 (self->priv->take_action_button);
	self->priv->take_action_button = _tmp48_;
	_tmp49_ = self->priv->gtk_builder;
	_tmp50_ = gtk_builder_get_object (_tmp49_, "take_action_button_internal_label");
	_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp50_) : NULL);
	_g_object_unref0 (self->priv->take_action_button_label);
	self->priv->take_action_button_label = _tmp51_;
	_tmp52_ = self->priv->gtk_builder;
	_tmp53_ = gtk_builder_get_object (_tmp52_, "take_action_button_internal_image");
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, GTK_TYPE_IMAGE) ? ((GtkImage*) _tmp53_) : NULL);
	_g_object_unref0 (self->priv->take_action_button_image);
	self->priv->take_action_button_image = _tmp54_;
	_tmp55_ = self->priv->gtk_builder;
	_tmp56_ = gtk_builder_get_object (_tmp55_, "effects_toggle_button");
	_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp56_) : NULL);
	_g_object_unref0 (self->priv->effects_toggle_button);
	self->priv->effects_toggle_button = _tmp57_;
	_tmp58_ = self->priv->gtk_builder;
	_tmp59_ = gtk_builder_get_object (_tmp58_, "leave_fullscreen_button");
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp59_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp59_) : NULL);
	_g_object_unref0 (self->priv->leave_fullscreen_button);
	self->priv->leave_fullscreen_button = _tmp60_;
	_tmp61_ = self->priv->gtk_builder;
	_tmp62_ = gtk_builder_get_object (_tmp61_, "buttons_area");
	_tmp63_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, GTK_TYPE_BOX) ? ((GtkBox*) _tmp62_) : NULL);
	_g_object_unref0 (self->priv->buttons_area);
	self->priv->buttons_area = _tmp63_;
	_tmp64_ = self->priv->gtk_builder;
	_tmp65_ = gtk_builder_get_object (_tmp64_, "thumbnail_popup");
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp65_, GTK_TYPE_MENU) ? ((GtkMenu*) _tmp65_) : NULL);
	_g_object_unref0 (self->priv->thumbnail_popup);
	self->priv->thumbnail_popup = _tmp66_;
	_tmp67_ = self->priv->gtk_builder;
	_tmp68_ = gtk_builder_get_object (_tmp67_, "countdown");
	_tmp69_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, GTK_TYPE_ACTION) ? ((GtkAction*) _tmp68_) : NULL);
	_g_object_unref0 (self->priv->countdown_action);
	self->priv->countdown_action = _tmp69_;
	_tmp70_ = self->priv->gtk_builder;
	_tmp71_ = gtk_builder_get_object (_tmp70_, "wide_mode");
	_tmp72_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, GTK_TYPE_TOGGLE_ACTION) ? ((GtkToggleAction*) _tmp71_) : NULL);
	_g_object_unref0 (self->priv->wide_mode_action);
	self->priv->wide_mode_action = _tmp72_;
	_tmp73_ = self->priv->gtk_builder;
	_tmp74_ = gtk_builder_get_object (_tmp73_, "effects_page_next");
	_tmp75_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, GTK_TYPE_ACTION) ? ((GtkAction*) _tmp74_) : NULL);
	_g_object_unref0 (self->priv->effects_page_next_action);
	self->priv->effects_page_next_action = _tmp75_;
	_tmp76_ = self->priv->gtk_builder;
	_tmp77_ = gtk_builder_get_object (_tmp76_, "effects_page_prev");
	_tmp78_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, GTK_TYPE_ACTION) ? ((GtkAction*) _tmp77_) : NULL);
	_g_object_unref0 (self->priv->effects_page_prev_action);
	self->priv->effects_page_prev_action = _tmp78_;
	_tmp79_ = self->priv->gtk_builder;
	_tmp80_ = gtk_builder_get_object (_tmp79_, "share");
	_tmp81_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, GTK_TYPE_ACTION) ? ((GtkAction*) _tmp80_) : NULL);
	_g_object_unref0 (self->priv->share_action);
	self->priv->share_action = _tmp81_;
	_tmp82_ = cheese_shareable_media_new (self);
	_g_object_unref0 (self->priv->shareable_media);
	self->priv->shareable_media = _tmp82_;
	_tmp83_ = self->priv->photo_toggle_button;
	_tmp84_ = _g_object_ref0 ((GtkButton*) _tmp83_);
	_tmp85_ = self->priv->video_toggle_button;
	_tmp86_ = _g_object_ref0 ((GtkButton*) _tmp85_);
	_tmp87_ = self->priv->burst_toggle_button;
	_tmp88_ = _g_object_ref0 ((GtkButton*) _tmp87_);
	_tmp89_ = self->priv->take_action_button;
	_tmp90_ = _g_object_ref0 (_tmp89_);
	_tmp91_ = self->priv->effects_toggle_button;
	_tmp92_ = _g_object_ref0 ((GtkButton*) _tmp91_);
	_tmp93_ = self->priv->leave_fullscreen_button;
	_tmp94_ = _g_object_ref0 (_tmp93_);
	_tmp95_ = g_new0 (GtkButton*, 6 + 1);
	_tmp95_[0] = _tmp84_;
	_tmp95_[1] = _tmp86_;
	_tmp95_[2] = _tmp88_;
	_tmp95_[3] = _tmp90_;
	_tmp95_[4] = _tmp92_;
	_tmp95_[5] = _tmp94_;
	self->priv->buttons = (_vala_array_free (self->priv->buttons, self->priv->buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->buttons = _tmp95_;
	self->priv->buttons_length1 = 6;
	self->priv->_buttons_size_ = self->priv->buttons_length1;
	_tmp96_ = self->priv->clutter_builder;
	_tmp97_ = clutter_script_get_object (_tmp96_, "video_preview");
	_tmp98_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp97_, clutter_texture_get_type ()) ? ((ClutterTexture*) _tmp97_) : NULL);
	_g_object_unref0 (self->priv->video_preview);
	self->priv->video_preview = _tmp98_;
	_tmp99_ = self->priv->clutter_builder;
	_tmp100_ = clutter_script_get_object (_tmp99_, "viewport_layout");
	_tmp101_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp100_, clutter_box_get_type ()) ? ((ClutterBox*) _tmp100_) : NULL);
	_g_object_unref0 (self->priv->viewport_layout);
	self->priv->viewport_layout = _tmp101_;
	_tmp102_ = self->priv->clutter_builder;
	_tmp103_ = clutter_script_get_object (_tmp102_, "viewport_layout_manager");
	_tmp104_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp103_, clutter_bin_layout_get_type ()) ? ((ClutterBinLayout*) _tmp103_) : NULL);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	self->priv->viewport_layout_manager = _tmp104_;
	_tmp105_ = self->priv->clutter_builder;
	_tmp106_ = clutter_script_get_object (_tmp105_, "countdown_layer");
	_tmp107_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, clutter_text_get_type ()) ? ((ClutterText*) _tmp106_) : NULL);
	_g_object_unref0 (self->priv->countdown_layer);
	self->priv->countdown_layer = _tmp107_;
	_tmp108_ = self->priv->clutter_builder;
	_tmp109_ = clutter_script_get_object (_tmp108_, "background");
	_tmp110_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp109_, clutter_rectangle_get_type ()) ? ((ClutterRectangle*) _tmp109_) : NULL);
	_g_object_unref0 (self->priv->background_layer);
	self->priv->background_layer = _tmp110_;
	_tmp111_ = self->priv->clutter_builder;
	_tmp112_ = clutter_script_get_object (_tmp111_, "error_layer");
	_tmp113_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp112_, clutter_text_get_type ()) ? ((ClutterText*) _tmp112_) : NULL);
	_g_object_unref0 (self->priv->error_layer);
	self->priv->error_layer = _tmp113_;
	_tmp114_ = self->priv->clutter_builder;
	_tmp115_ = clutter_script_get_object (_tmp114_, "timeout_layer");
	_tmp116_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp115_, clutter_text_get_type ()) ? ((ClutterText*) _tmp115_) : NULL);
	_g_object_unref0 (self->priv->timeout_layer);
	self->priv->timeout_layer = _tmp116_;
	_tmp117_ = self->priv->video_preview;
	clutter_texture_set_keep_aspect_ratio (_tmp117_, TRUE);
	_tmp118_ = self->priv->video_preview;
	clutter_actor_set_request_mode ((ClutterActor*) _tmp118_, CLUTTER_REQUEST_HEIGHT_FOR_WIDTH);
	_tmp119_ = self->priv->viewport;
	_tmp120_ = self->priv->background_layer;
	clutter_container_add_actor ((ClutterContainer*) _tmp119_, (ClutterActor*) _tmp120_);
	_tmp121_ = self->priv->viewport_layout;
	_tmp122_ = self->priv->viewport_layout_manager;
	clutter_box_set_layout_manager (_tmp121_, (ClutterLayoutManager*) _tmp122_);
	_tmp123_ = self->priv->viewport;
	_tmp124_ = self->priv->viewport_layout;
	clutter_container_add_actor ((ClutterContainer*) _tmp123_, (ClutterActor*) _tmp124_);
	_tmp125_ = self->priv->viewport;
	_tmp126_ = self->priv->timeout_layer;
	clutter_container_add_actor ((ClutterContainer*) _tmp125_, (ClutterActor*) _tmp126_);
	_tmp127_ = self->priv->viewport;
	g_signal_connect_object ((ClutterActor*) _tmp127_, "allocation-changed", (GCallback) _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed, self, 0);
	_tmp128_ = cheese_thumb_view_new ();
	g_object_ref_sink (_tmp128_);
	_g_object_unref0 (self->priv->thumb_view);
	self->priv->thumb_view = _tmp128_;
	_tmp129_ = self->priv->thumb_view;
	_tmp130_ = eog_thumb_nav_new ((GtkWidget*) _tmp129_, FALSE);
	g_object_ref_sink (_tmp130_);
	_g_object_unref0 (self->priv->thumb_nav);
	self->priv->thumb_nav = _tmp130_;
	{
		GtkCssProvider* _tmp131_;
		gchar* _tmp132_ = NULL;
		gchar* _tmp133_;
		_tmp131_ = gtk_css_provider_new ();
		_g_object_unref0 (css);
		css = _tmp131_;
		_tmp132_ = g_build_filename (PACKAGE_DATADIR, "cheese.css", NULL);
		_tmp133_ = _tmp132_;
		gtk_css_provider_load_from_path (css, _tmp133_, &_inner_error_);
		_g_free0 (_tmp133_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		FILE* _tmp134_;
		GError* _tmp135_;
		const gchar* _tmp136_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp134_ = stdout;
		_tmp135_ = e;
		_tmp136_ = _tmp135_->message;
		fprintf (_tmp134_, "Error: %s\n", _tmp136_);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (css);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp137_ = self->priv->thumb_view;
	_tmp138_ = gtk_widget_get_style_context ((GtkWidget*) _tmp137_);
	_tmp139_ = _g_object_ref0 (_tmp138_);
	_g_object_unref0 (context);
	context = _tmp139_;
	_tmp140_ = gdk_screen_get_default ();
	gtk_window_set_screen ((GtkWindow*) self, _tmp140_);
	_tmp141_ = context;
	_tmp142_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp143_ = _tmp142_;
	gtk_style_context_add_provider_for_screen (_tmp143_, (GtkStyleProvider*) css, (guint) GTK_STYLE_PROVIDER_PRIORITY_USER);
	_tmp144_ = self->priv->thumb_view;
	g_signal_connect_object ((GtkWidget*) _tmp144_, "button-press-event", (GCallback) _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event, self, 0);
	_tmp145_ = self->priv->main_vbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp145_);
	_tmp146_ = self->priv->main_vbox;
	gtk_widget_show_all ((GtkWidget*) _tmp146_);
	_tmp147_ = self->priv->viewport_widget;
	gtk_widget_realize ((GtkWidget*) _tmp147_);
	_tmp148_ = self->priv->wide_mode_action;
	_tmp149_ = self->priv->settings;
	_tmp150_ = g_settings_get_boolean (_tmp149_, "wide-mode");
	gtk_toggle_action_set_active (_tmp148_, _tmp150_);
	_tmp151_ = self->priv->settings;
	_tmp152_ = g_settings_get_boolean (_tmp151_, "wide-mode");
	if (!_tmp152_) {
		GtkToggleAction* _tmp153_;
		_tmp153_ = self->priv->wide_mode_action;
		gtk_toggle_action_toggled (_tmp153_);
	}
	cheese_main_window_set_mode (self, CHEESE_MEDIA_MODE_PHOTO);
	cheese_main_window_setup_effects_selector (self);
	cheese_main_window_toggle_camera_actions_sensitivities (self, FALSE);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _cheese_main_window_on_key_release_gtk_widget_key_release_event, self, 0);
	_g_object_unref0 (context);
	_g_object_unref0 (css);
}


ClutterTexture* cheese_main_window_get_video_preview (CheeseMainWindow* self) {
	ClutterTexture* result = NULL;
	ClutterTexture* _tmp0_;
	ClutterTexture* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->video_preview;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
   * Setup the thumbview thumbnail monitors.
   */
void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self) {
	CheeseThumbView* _tmp0_;
	CheeseFileUtil* _tmp1_;
	const gchar* _tmp2_ = NULL;
	CheeseThumbView* _tmp3_;
	CheeseFileUtil* _tmp4_;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = self->priv->fileutil;
	_tmp2_ = cheese_fileutil_get_video_path (_tmp1_);
	cheese_thumb_view_start_monitoring_video_path (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->thumb_view;
	_tmp4_ = self->priv->fileutil;
	_tmp5_ = cheese_fileutil_get_photo_path (_tmp4_);
	cheese_thumb_view_start_monitoring_photo_path (_tmp3_, _tmp5_);
}


/**
     * Set the current media mode (photo, video or burst).
     *
     * @param mode the media mode to set
     */
void cheese_main_window_set_current_mode (CheeseMainWindow* self, CheeseMediaMode mode) {
	CheeseMediaMode _tmp0_;
	CheeseMediaMode _tmp1_;
	ClutterText* _tmp2_;
	CheeseMediaMode _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = mode;
	self->priv->current_mode = _tmp0_;
	_tmp1_ = self->priv->current_mode;
	cheese_main_window_set_resolution (self, _tmp1_);
	_tmp2_ = self->priv->timeout_layer;
	clutter_actor_hide ((ClutterActor*) _tmp2_);
	_tmp3_ = self->priv->current_mode;
	switch (_tmp3_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			GtkLabel* _tmp4_;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			GtkButton* _tmp10_;
			const gchar* _tmp11_ = NULL;
			_tmp4_ = self->priv->take_action_button_label;
			_tmp5_ = _ ("_Take a Photo");
			_tmp6_ = g_strconcat ("<b>", _tmp5_, NULL);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strconcat (_tmp7_, "</b>", NULL);
			_tmp9_ = _tmp8_;
			gtk_label_set_label (_tmp4_, _tmp9_);
			_g_free0 (_tmp9_);
			_g_free0 (_tmp7_);
			_tmp10_ = self->priv->take_action_button;
			_tmp11_ = _ ("Take a photo");
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _tmp11_);
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GtkLabel* _tmp12_;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			GtkButton* _tmp18_;
			const gchar* _tmp19_ = NULL;
			ClutterText* _tmp20_;
			ClutterText* _tmp21_;
			_tmp12_ = self->priv->take_action_button_label;
			_tmp13_ = _ ("_Record a Video");
			_tmp14_ = g_strconcat ("<b>", _tmp13_, NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (_tmp15_, "</b>", NULL);
			_tmp17_ = _tmp16_;
			gtk_label_set_label (_tmp12_, _tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp15_);
			_tmp18_ = self->priv->take_action_button;
			_tmp19_ = _ ("Record a video");
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp18_, _tmp19_);
			_tmp20_ = self->priv->timeout_layer;
			clutter_text_set_text (_tmp20_, "00:00:00");
			_tmp21_ = self->priv->timeout_layer;
			clutter_actor_show ((ClutterActor*) _tmp21_);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			GtkLabel* _tmp22_;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			GtkButton* _tmp28_;
			const gchar* _tmp29_ = NULL;
			_tmp22_ = self->priv->take_action_button_label;
			_tmp23_ = _ ("Take _Multiple Photos");
			_tmp24_ = g_strconcat ("<b>", _tmp23_, NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strconcat (_tmp25_, "</b>", NULL);
			_tmp27_ = _tmp26_;
			gtk_label_set_label (_tmp22_, _tmp27_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
			_tmp28_ = self->priv->take_action_button;
			_tmp29_ = _ ("Take multiple photos");
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp28_, _tmp29_);
			break;
		}
		default:
		break;
	}
}


/**
     * Set the camera.
     *
     * @param camera the camera to set
     */
void cheese_main_window_set_camera (CheeseMainWindow* self, CheeseCamera* camera) {
	CheeseCamera* _tmp0_;
	CheeseCamera* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (camera != NULL);
	_tmp0_ = camera;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp1_;
}


static void cheese_main_window_class_init (CheeseMainWindowClass * klass) {
	cheese_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheeseMainWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_main_window_finalize;
}


static void cheese_main_window_instance_init (CheeseMainWindow * self) {
	self->priv = CHEESE_MAIN_WINDOW_GET_PRIVATE (self);
	self->priv->current_effects_page = 0;
}


static void cheese_main_window_finalize (GObject* obj) {
	CheeseMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow);
	_g_object_unref0 (self->priv->gtk_builder);
	_g_object_unref0 (self->priv->clutter_builder);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->thumbnails);
	_g_object_unref0 (self->priv->viewport_widget);
	_g_object_unref0 (self->priv->main_vbox);
	_g_object_unref0 (self->priv->thumb_nav);
	_g_object_unref0 (self->priv->thumb_view);
	_g_object_unref0 (self->priv->thumbnails_right);
	_g_object_unref0 (self->priv->thumbnails_bottom);
	_g_object_unref0 (self->priv->leave_fullscreen_button_container);
	_g_object_unref0 (self->priv->photo_toggle_button);
	_g_object_unref0 (self->priv->video_toggle_button);
	_g_object_unref0 (self->priv->burst_toggle_button);
	_g_object_unref0 (self->priv->take_action_button);
	_g_object_unref0 (self->priv->take_action_button_label);
	_g_object_unref0 (self->priv->take_action_button_image);
	_g_object_unref0 (self->priv->effects_toggle_button);
	_g_object_unref0 (self->priv->leave_fullscreen_button);
	_g_object_unref0 (self->priv->buttons_area);
	_g_object_unref0 (self->priv->thumbnail_popup);
	_g_object_unref0 (self->priv->viewport);
	_g_object_unref0 (self->priv->viewport_layout);
	_g_object_unref0 (self->priv->video_preview);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	_g_object_unref0 (self->priv->countdown_layer);
	_g_object_unref0 (self->priv->background_layer);
	_g_object_unref0 (self->priv->error_layer);
	_g_object_unref0 (self->priv->timeout_layer);
	_g_object_unref0 (self->priv->current_effects_grid);
	_g_object_unref0 (self->priv->effects_grids);
	_g_object_unref0 (self->priv->wide_mode_action);
	_g_object_unref0 (self->priv->countdown_action);
	_g_object_unref0 (self->priv->effects_page_prev_action);
	_g_object_unref0 (self->priv->effects_page_next_action);
	_g_object_unref0 (self->priv->share_action);
	self->priv->buttons = (_vala_array_free (self->priv->buttons, self->priv->buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->fileutil);
	_g_object_unref0 (self->priv->flash);
	_g_object_unref0 (self->priv->effects_manager);
	_g_object_unref0 (self->priv->selected_effect);
	_g_object_unref0 (self->priv->shareable_media);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	_g_object_unref0 (self->priv->current_countdown);
	_g_object_unref0 (self->priv->action_sensitivities);
	G_OBJECT_CLASS (cheese_main_window_parent_class)->finalize (obj);
}


GType cheese_main_window_get_type (void) {
	static volatile gsize cheese_main_window_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseMainWindow), 0, (GInstanceInitFunc) cheese_main_window_instance_init, NULL };
		GType cheese_main_window_type_id;
		cheese_main_window_type_id = g_type_register_static (GTK_TYPE_APPLICATION_WINDOW, "CheeseMainWindow", &g_define_type_info, 0);
		g_once_init_leave (&cheese_main_window_type_id__volatile, cheese_main_window_type_id);
	}
	return cheese_main_window_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



