/* chess-game.c generated by valac 0.18.1, the Vala compiler
 * generated from chess-game.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_COLOR (color_get_type ())

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PIECE_TYPE (piece_type_get_type ())

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;
typedef struct _ChessPiecePrivate ChessPiecePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecChessPiece ParamSpecChessPiece;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
typedef struct _ChessMovePrivate ChessMovePrivate;
#define _chess_piece_unref0(var) ((var == NULL) ? NULL : (var = (chess_piece_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _chess_move_unref0(var) ((var == NULL) ? NULL : (var = (chess_move_unref (var), NULL)))
typedef struct _ParamSpecChessMove ParamSpecChessMove;

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;
typedef struct _ChessStatePrivate ChessStatePrivate;
#define _chess_state_unref0(var) ((var == NULL) ? NULL : (var = (chess_state_unref (var), NULL)))

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_RESULT (chess_result_get_type ())
typedef struct _ParamSpecChessState ParamSpecChessState;

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
typedef struct _ChessGamePrivate ChessGamePrivate;

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
#define __g_list_free__chess_state_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__chess_state_unref0_ (var), NULL)))
typedef struct _ParamSpecChessGame ParamSpecChessGame;

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};

struct _ParamSpecChessPiece {
	GParamSpec parent_instance;
};

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessMove {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GTypeClass parent_class;
	void (*finalize) (ChessMove *self);
};

struct _ParamSpecChessMove {
	GParamSpec parent_instance;
};

struct _ChessState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GTypeClass parent_class;
	void (*finalize) (ChessState *self);
};

struct _ChessStatePrivate {
	gint64 piece_masks[2];
};

typedef enum  {
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH
} ChessRule;

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW
} ChessResult;

struct _ParamSpecChessState {
	GParamSpec parent_instance;
};

struct _ChessGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessGamePrivate * priv;
	gboolean is_started;
	ChessResult result;
	ChessRule rule;
	GList* move_stack;
};

struct _ChessGameClass {
	GTypeClass parent_class;
	void (*finalize) (ChessGame *self);
};

struct _ChessGamePrivate {
	gint hold_count;
	ChessClock* _clock;
};

struct _ParamSpecChessGame {
	GParamSpec parent_instance;
};


static gpointer chess_player_parent_class = NULL;
static gpointer chess_piece_parent_class = NULL;
static gpointer chess_move_parent_class = NULL;
static gpointer chess_state_parent_class = NULL;
static gpointer chess_game_parent_class = NULL;

GType color_get_type (void) G_GNUC_CONST;
GType chess_player_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_PLAYER_DUMMY_PROPERTY
};
ChessPlayer* chess_player_new (Color color);
ChessPlayer* chess_player_construct (GType object_type, Color color);
gboolean chess_player_move (ChessPlayer* self, const gchar* move, gboolean apply);
gboolean chess_player_move_with_coords (ChessPlayer* self, gint r0, gint f0, gint r1, gint f1, gboolean apply);
void chess_player_undo (ChessPlayer* self);
gboolean chess_player_resign (ChessPlayer* self);
gboolean chess_player_claim_draw (ChessPlayer* self);
static void g_cclosure_user_marshal_BOOLEAN__STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void chess_player_finalize (GObject* obj);
GType piece_type_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_PIECE_DUMMY_PROPERTY
};
ChessPiece* chess_piece_new (ChessPlayer* player, PieceType type);
ChessPiece* chess_piece_construct (GType object_type, ChessPlayer* player, PieceType type);
Color chess_piece_get_color (ChessPiece* self);
gunichar chess_piece_get_symbol (ChessPiece* self);
static void chess_piece_finalize (ChessPiece* obj);
GType check_state_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_MOVE_DUMMY_PROPERTY
};
gchar* chess_move_get_lan (ChessMove* self);
gchar* chess_move_get_san (ChessMove* self);
static gchar* chess_move_make_san (ChessMove* self, gchar** piece_names, int piece_names_length1);
gchar* chess_move_get_fan (ChessMove* self);
gchar* chess_move_get_engine (ChessMove* self);
ChessMove* chess_move_copy (ChessMove* self);
ChessMove* chess_move_new (void);
ChessMove* chess_move_construct (GType object_type);
static void chess_move_finalize (ChessMove* obj);
gpointer chess_state_ref (gpointer instance);
void chess_state_unref (gpointer instance);
GParamSpec* param_spec_chess_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_state (GValue* value, gpointer v_object);
void value_take_chess_state (GValue* value, gpointer v_object);
gpointer value_get_chess_state (const GValue* value);
GType chess_state_get_type (void) G_GNUC_CONST;
#define CHESS_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_STATE, ChessStatePrivate))
enum  {
	CHESS_STATE_DUMMY_PROPERTY
};
static ChessState* chess_state_new_empty (void);
static ChessState* chess_state_construct_empty (GType object_type);
ChessState* chess_state_new (const gchar* fen);
ChessState* chess_state_construct (GType object_type, const gchar* fen);
static gboolean chess_state_decode_piece_type (ChessState* self, gunichar c, PieceType* type);
gint chess_state_get_index (ChessState* self, gint rank, gint file);
static CheckState chess_state_get_check_state (ChessState* self, ChessPlayer* player);
ChessState* chess_state_copy (ChessState* self);
gboolean chess_state_equals (ChessState* self, ChessState* state);
gchar* chess_state_get_fen (ChessState* self);
gint chess_state_get_file (ChessState* self, gint index);
gint chess_state_get_rank (ChessState* self, gint index);
gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply);
static gboolean chess_state_decode_move (ChessState* self, ChessPlayer* player, const gchar* move, gint* r0, gint* f0, gint* r1, gint* f1, PieceType* promotion_type);
gboolean chess_state_move_with_coords (ChessState* self, ChessPlayer* player, gint r0, gint f0, gint r1, gint f1, PieceType promotion_type, gboolean apply, gboolean test_check);
ChessPlayer* chess_state_get_opponent (ChessState* self);
static gboolean chess_state_is_in_check (ChessState* self, ChessPlayer* player);
GType chess_rule_get_type (void) G_GNUC_CONST;
GType chess_result_get_type (void) G_GNUC_CONST;
ChessResult chess_state_get_result (ChessState* self, ChessRule* rule);
static gboolean chess_state_can_move (ChessState* self, ChessPlayer* player);
gboolean chess_state_have_sufficient_material (ChessState* self);
static gboolean chess_state_is_in_checkmate (ChessState* self, ChessPlayer* player);
static void chess_state_finalize (ChessState* obj);
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
GType chess_clock_get_type (void) G_GNUC_CONST;
#define CHESS_GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_GAME, ChessGamePrivate))
enum  {
	CHESS_GAME_DUMMY_PROPERTY
};
static void _chess_state_unref0_ (gpointer var);
static void _g_list_free__chess_state_unref0_ (GList* self);
#define CHESS_GAME_STANDARD_SETUP "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1"
ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1);
ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1);
static gboolean chess_game_do_move (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply);
ChessPlayer* chess_game_get_current_player (ChessGame* self);
ChessPlayer* chess_game_get_white (ChessGame* self);
static gboolean chess_game_move_cb (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply);
static gboolean _chess_game_move_cb_chess_player_do_move (ChessPlayer* _sender, const gchar* move, gboolean apply, gpointer self);
static void chess_game_undo_cb (ChessGame* self, ChessPlayer* player);
static void _chess_game_undo_cb_chess_player_do_undo (ChessPlayer* _sender, gpointer self);
static gboolean chess_game_resign_cb (ChessGame* self, ChessPlayer* player);
static gboolean _chess_game_resign_cb_chess_player_do_resign (ChessPlayer* _sender, gpointer self);
static gboolean chess_game_claim_draw_cb (ChessGame* self, ChessPlayer* player);
static gboolean _chess_game_claim_draw_cb_chess_player_do_claim_draw (ChessPlayer* _sender, gpointer self);
ChessPlayer* chess_game_get_black (ChessGame* self);
ChessState* chess_game_get_current_state (ChessGame* self);
static void chess_game_complete_move (ChessGame* self);
void chess_game_add_hold (ChessGame* self);
void chess_game_remove_hold (ChessGame* self);
static void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule);
void chess_clock_set_active_color (ChessClock* self, Color value);
ChessPlayer* chess_game_get_opponent (ChessGame* self);
static gboolean chess_game_is_three_fold_repeat (ChessGame* self);
void chess_game_start (ChessGame* self);
static void chess_game_clock_expired_cb (ChessGame* self, ChessClock* clock);
static void _chess_game_clock_expired_cb_chess_clock_expired (ChessClock* _sender, gpointer self);
void chess_clock_start (ChessClock* self);
void chess_game_abandon (ChessGame* self);
ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number);
ChessClock* chess_game_get_clock (ChessGame* self);
void chess_game_set_clock (ChessGame* self, ChessClock* value);
guint chess_game_get_n_moves (ChessGame* self);
static void g_cclosure_user_marshal_VOID__CHESS_MOVE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void chess_game_finalize (ChessGame* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

extern const gint64 BIT_BOARD_set_location_masks[64];
extern const gint64 BIT_BOARD_move_masks[768];
extern const gint64 BIT_BOARD_over_masks[4096];
extern const gint64 BIT_BOARD_clear_location_masks[64];

GType color_get_type (void) {
	static volatile gsize color_type_id__volatile = 0;
	if (g_once_init_enter (&color_type_id__volatile)) {
		static const GEnumValue values[] = {{COLOR_WHITE, "COLOR_WHITE", "white"}, {COLOR_BLACK, "COLOR_BLACK", "black"}, {0, NULL, NULL}};
		GType color_type_id;
		color_type_id = g_enum_register_static ("Color", values);
		g_once_init_leave (&color_type_id__volatile, color_type_id);
	}
	return color_type_id__volatile;
}


ChessPlayer* chess_player_construct (GType object_type, Color color) {
	ChessPlayer * self = NULL;
	Color _tmp0_;
	self = (ChessPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = color;
	self->color = _tmp0_;
	return self;
}


ChessPlayer* chess_player_new (Color color) {
	return chess_player_construct (TYPE_CHESS_PLAYER, color);
}


gboolean chess_player_move (ChessPlayer* self, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (move != NULL, FALSE);
	_tmp0_ = move;
	_tmp1_ = apply;
	g_signal_emit_by_name (self, "do-move", _tmp0_, _tmp1_, &_tmp2_);
	result = _tmp2_;
	return result;
}


gboolean chess_player_move_with_coords (ChessPlayer* self, gint r0, gint f0, gint r1, gint f1, gboolean apply) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* move;
	gboolean _tmp5_;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = f0;
	_tmp1_ = r0;
	_tmp2_ = f1;
	_tmp3_ = r1;
	_tmp4_ = g_strdup_printf ("%c%d%c%d", 'a' + _tmp0_, _tmp1_ + 1, 'a' + _tmp2_, _tmp3_ + 1);
	move = _tmp4_;
	_tmp5_ = apply;
	g_signal_emit_by_name (self, "do-move", move, _tmp5_, &_tmp6_);
	result = _tmp6_;
	_g_free0 (move);
	return result;
}


void chess_player_undo (ChessPlayer* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "do-undo");
}


gboolean chess_player_resign (ChessPlayer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit_by_name (self, "do-resign", &_tmp0_);
	result = _tmp0_;
	return result;
}


gboolean chess_player_claim_draw (ChessPlayer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit_by_name (self, "do-claim-draw", &_tmp0_);
	result = _tmp0_;
	return result;
}


static void g_cclosure_user_marshal_BOOLEAN__STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING_BOOLEAN) (gpointer data1, const char* arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_string (param_values + 1), g_value_get_boolean (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}


static void chess_player_class_init (ChessPlayerClass * klass) {
	chess_player_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = chess_player_finalize;
	g_signal_new ("start_turn", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("do_move", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING_BOOLEAN, G_TYPE_BOOLEAN, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	g_signal_new ("do_undo", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("do_resign", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
	g_signal_new ("do_claim_draw", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
}


static void chess_player_instance_init (ChessPlayer * self) {
}


static void chess_player_finalize (GObject* obj) {
	ChessPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_PLAYER, ChessPlayer);
	G_OBJECT_CLASS (chess_player_parent_class)->finalize (obj);
}


GType chess_player_get_type (void) {
	static volatile gsize chess_player_type_id__volatile = 0;
	if (g_once_init_enter (&chess_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessPlayer), 0, (GInstanceInitFunc) chess_player_instance_init, NULL };
		GType chess_player_type_id;
		chess_player_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessPlayer", &g_define_type_info, 0);
		g_once_init_leave (&chess_player_type_id__volatile, chess_player_type_id);
	}
	return chess_player_type_id__volatile;
}


GType piece_type_get_type (void) {
	static volatile gsize piece_type_type_id__volatile = 0;
	if (g_once_init_enter (&piece_type_type_id__volatile)) {
		static const GEnumValue values[] = {{PIECE_TYPE_PAWN, "PIECE_TYPE_PAWN", "pawn"}, {PIECE_TYPE_ROOK, "PIECE_TYPE_ROOK", "rook"}, {PIECE_TYPE_KNIGHT, "PIECE_TYPE_KNIGHT", "knight"}, {PIECE_TYPE_BISHOP, "PIECE_TYPE_BISHOP", "bishop"}, {PIECE_TYPE_QUEEN, "PIECE_TYPE_QUEEN", "queen"}, {PIECE_TYPE_KING, "PIECE_TYPE_KING", "king"}, {0, NULL, NULL}};
		GType piece_type_type_id;
		piece_type_type_id = g_enum_register_static ("PieceType", values);
		g_once_init_leave (&piece_type_type_id__volatile, piece_type_type_id);
	}
	return piece_type_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ChessPiece* chess_piece_construct (GType object_type, ChessPlayer* player, PieceType type) {
	ChessPiece* self = NULL;
	ChessPlayer* _tmp0_;
	ChessPlayer* _tmp1_;
	PieceType _tmp2_;
	g_return_val_if_fail (player != NULL, NULL);
	self = (ChessPiece*) g_type_create_instance (object_type);
	_tmp0_ = player;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->player);
	self->player = _tmp1_;
	_tmp2_ = type;
	self->type = _tmp2_;
	return self;
}


ChessPiece* chess_piece_new (ChessPlayer* player, PieceType type) {
	return chess_piece_construct (TYPE_CHESS_PIECE, player, type);
}


Color chess_piece_get_color (ChessPiece* self) {
	Color result;
	ChessPlayer* _tmp0_;
	Color _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->player;
	_tmp1_ = _tmp0_->color;
	result = _tmp1_;
	return result;
}


gunichar chess_piece_get_symbol (ChessPiece* self) {
	gunichar result;
	gunichar c;
	PieceType _tmp0_;
	ChessPlayer* _tmp1_;
	Color _tmp2_;
	gunichar _tmp5_;
	g_return_val_if_fail (self != NULL, 0U);
	c = (gunichar) ' ';
	_tmp0_ = self->type;
	switch (_tmp0_) {
		case PIECE_TYPE_PAWN:
		{
			c = (gunichar) 'p';
			break;
		}
		case PIECE_TYPE_ROOK:
		{
			c = (gunichar) 'r';
			break;
		}
		case PIECE_TYPE_KNIGHT:
		{
			c = (gunichar) 'k';
			break;
		}
		case PIECE_TYPE_BISHOP:
		{
			c = (gunichar) 'b';
			break;
		}
		case PIECE_TYPE_QUEEN:
		{
			c = (gunichar) 'q';
			break;
		}
		case PIECE_TYPE_KING:
		{
			c = (gunichar) 'k';
			break;
		}
		default:
		break;
	}
	_tmp1_ = self->player;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		gunichar _tmp3_;
		gunichar _tmp4_ = 0U;
		_tmp3_ = c;
		_tmp4_ = g_unichar_toupper (_tmp3_);
		c = _tmp4_;
	}
	_tmp5_ = c;
	result = _tmp5_;
	return result;
}


static void value_chess_piece_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_chess_piece_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		chess_piece_unref (value->data[0].v_pointer);
	}
}


static void value_chess_piece_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = chess_piece_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_chess_piece_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_chess_piece_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ChessPiece* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = chess_piece_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_chess_piece_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessPiece** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = chess_piece_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessPiece* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_PIECE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_chess_piece (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_PIECE), NULL);
	return value->data[0].v_pointer;
}


void value_set_chess_piece (GValue* value, gpointer v_object) {
	ChessPiece* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_PIECE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_PIECE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		chess_piece_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_piece_unref (old);
	}
}


void value_take_chess_piece (GValue* value, gpointer v_object) {
	ChessPiece* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_PIECE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_PIECE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_piece_unref (old);
	}
}


static void chess_piece_class_init (ChessPieceClass * klass) {
	chess_piece_parent_class = g_type_class_peek_parent (klass);
	CHESS_PIECE_CLASS (klass)->finalize = chess_piece_finalize;
	g_signal_new ("moved", TYPE_CHESS_PIECE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("promoted", TYPE_CHESS_PIECE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("died", TYPE_CHESS_PIECE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_piece_instance_init (ChessPiece * self) {
	self->ref_count = 1;
}


static void chess_piece_finalize (ChessPiece* obj) {
	ChessPiece * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_PIECE, ChessPiece);
	_g_object_unref0 (self->player);
}


GType chess_piece_get_type (void) {
	static volatile gsize chess_piece_type_id__volatile = 0;
	if (g_once_init_enter (&chess_piece_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_piece_init, value_chess_piece_free_value, value_chess_piece_copy_value, value_chess_piece_peek_pointer, "p", value_chess_piece_collect_value, "p", value_chess_piece_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessPieceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_piece_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessPiece), 0, (GInstanceInitFunc) chess_piece_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_piece_type_id;
		chess_piece_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessPiece", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_piece_type_id__volatile, chess_piece_type_id);
	}
	return chess_piece_type_id__volatile;
}


gpointer chess_piece_ref (gpointer instance) {
	ChessPiece* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void chess_piece_unref (gpointer instance) {
	ChessPiece* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CHESS_PIECE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType check_state_get_type (void) {
	static volatile gsize check_state_type_id__volatile = 0;
	if (g_once_init_enter (&check_state_type_id__volatile)) {
		static const GEnumValue values[] = {{CHECK_STATE_NONE, "CHECK_STATE_NONE", "none"}, {CHECK_STATE_CHECK, "CHECK_STATE_CHECK", "check"}, {CHECK_STATE_CHECKMATE, "CHECK_STATE_CHECKMATE", "checkmate"}, {0, NULL, NULL}};
		GType check_state_type_id;
		check_state_type_id = g_enum_register_static ("CheckState", values);
		g_once_init_leave (&check_state_type_id__volatile, check_state_type_id);
	}
	return check_state_type_id__volatile;
}


gchar* chess_move_get_lan (ChessMove* self) {
	gchar* result = NULL;
	ChessPiece* _tmp0_;
	GString* _tmp5_;
	GString* builder;
	ChessPiece* _tmp6_;
	static const gchar promotion_symbols[] = {' ', 'R', 'N', 'B', 'Q', 'K'};
	ChessPiece* _tmp17_;
	CheckState _tmp22_;
	GString* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->moved_rook;
	if (_tmp0_ != NULL) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = self->f1;
		_tmp2_ = self->f0;
		if (_tmp1_ > _tmp2_) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("O-O");
			result = _tmp3_;
			return result;
		} else {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("O-O-O");
			result = _tmp4_;
			return result;
		}
	}
	_tmp5_ = g_string_new ("");
	builder = _tmp5_;
	_tmp6_ = self->victim;
	if (_tmp6_ != NULL) {
		GString* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp7_ = builder;
		_tmp8_ = self->f0;
		_tmp9_ = self->r0;
		_tmp10_ = self->f1;
		_tmp11_ = self->r1;
		g_string_append_printf (_tmp7_, "%c%dx%c%d", 'a' + _tmp8_, _tmp9_ + 1, 'a' + _tmp10_, _tmp11_ + 1);
	} else {
		GString* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp12_ = builder;
		_tmp13_ = self->f0;
		_tmp14_ = self->r0;
		_tmp15_ = self->f1;
		_tmp16_ = self->r1;
		g_string_append_printf (_tmp12_, "%c%d-%c%d", 'a' + _tmp13_, _tmp14_ + 1, 'a' + _tmp15_, _tmp16_ + 1);
	}
	_tmp17_ = self->promotion_piece;
	if (_tmp17_ != NULL) {
		GString* _tmp18_;
		ChessPiece* _tmp19_;
		PieceType _tmp20_;
		gchar _tmp21_;
		_tmp18_ = builder;
		_tmp19_ = self->promotion_piece;
		_tmp20_ = _tmp19_->type;
		_tmp21_ = promotion_symbols[_tmp20_];
		g_string_append_printf (_tmp18_, "=%c", (gint) _tmp21_);
	}
	_tmp22_ = self->check_state;
	switch (_tmp22_) {
		case CHECK_STATE_CHECK:
		{
			GString* _tmp23_;
			_tmp23_ = builder;
			g_string_append_c (_tmp23_, '+');
			break;
		}
		case CHECK_STATE_CHECKMATE:
		{
			GString* _tmp24_;
			_tmp24_ = builder;
			g_string_append_c (_tmp24_, '#');
			break;
		}
		default:
		break;
	}
	_tmp25_ = builder;
	_tmp26_ = _tmp25_->str;
	_tmp27_ = g_strdup (_tmp26_);
	result = _tmp27_;
	_g_string_free0 (builder);
	return result;
}


gchar* chess_move_get_san (ChessMove* self) {
	gchar* result = NULL;
	static const gchar* piece_names[] = {"", "R", "N", "B", "Q", "K"};
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_move_make_san (self, (gchar**) piece_names, (G_N_ELEMENTS (piece_names) * sizeof (const gchar*)) / sizeof (gchar*));
	result = _tmp0_;
	return result;
}


gchar* chess_move_get_fan (ChessMove* self) {
	gchar* result = NULL;
	static const gchar* white_piece_names[] = {"", "♞", "♝", "♜", "♛", "♚"};
	static const gchar* black_piece_names[] = {"", "♘", "♗", "♖", "♕", "♔"};
	ChessPiece* _tmp0_;
	Color _tmp1_;
	Color _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->piece;
	_tmp1_ = chess_piece_get_color (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == COLOR_WHITE) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = chess_move_make_san (self, (gchar**) white_piece_names, (G_N_ELEMENTS (white_piece_names) * sizeof (const gchar*)) / sizeof (gchar*));
		result = _tmp3_;
		return result;
	} else {
		gchar* _tmp4_ = NULL;
		_tmp4_ = chess_move_make_san (self, (gchar**) black_piece_names, (G_N_ELEMENTS (black_piece_names) * sizeof (const gchar*)) / sizeof (gchar*));
		result = _tmp4_;
		return result;
	}
}


static gchar* chess_move_make_san (ChessMove* self, gchar** piece_names, int piece_names_length1) {
	gchar* result = NULL;
	ChessPiece* _tmp0_;
	GString* _tmp5_;
	GString* builder;
	GString* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	ChessPiece* _tmp8_;
	PieceType _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp14_;
	ChessPiece* _tmp17_;
	GString* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	ChessPiece* _tmp22_;
	CheckState _tmp28_;
	GString* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->moved_rook;
	if (_tmp0_ != NULL) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = self->f1;
		_tmp2_ = self->f0;
		if (_tmp1_ > _tmp2_) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("O-O");
			result = _tmp3_;
			return result;
		} else {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("O-O-O");
			result = _tmp4_;
			return result;
		}
	}
	_tmp5_ = g_string_new ("");
	builder = _tmp5_;
	_tmp6_ = builder;
	_tmp7_ = piece_names;
	_tmp7__length1 = piece_names_length1;
	_tmp8_ = self->piece;
	_tmp9_ = _tmp8_->type;
	_tmp10_ = _tmp7_[_tmp9_];
	g_string_append (_tmp6_, _tmp10_);
	_tmp11_ = self->ambiguous_file;
	if (_tmp11_) {
		GString* _tmp12_;
		gint _tmp13_;
		_tmp12_ = builder;
		_tmp13_ = self->f0;
		g_string_append_printf (_tmp12_, "%c", 'a' + _tmp13_);
	}
	_tmp14_ = self->ambiguous_rank;
	if (_tmp14_) {
		GString* _tmp15_;
		gint _tmp16_;
		_tmp15_ = builder;
		_tmp16_ = self->r0;
		g_string_append_printf (_tmp15_, "%d", _tmp16_ + 1);
	}
	_tmp17_ = self->victim;
	if (_tmp17_ != NULL) {
		GString* _tmp18_;
		_tmp18_ = builder;
		g_string_append (_tmp18_, "x");
	}
	_tmp19_ = builder;
	_tmp20_ = self->f1;
	_tmp21_ = self->r1;
	g_string_append_printf (_tmp19_, "%c%d", 'a' + _tmp20_, _tmp21_ + 1);
	_tmp22_ = self->promotion_piece;
	if (_tmp22_ != NULL) {
		GString* _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		ChessPiece* _tmp25_;
		PieceType _tmp26_;
		const gchar* _tmp27_;
		_tmp23_ = builder;
		_tmp24_ = piece_names;
		_tmp24__length1 = piece_names_length1;
		_tmp25_ = self->promotion_piece;
		_tmp26_ = _tmp25_->type;
		_tmp27_ = _tmp24_[_tmp26_];
		g_string_append_printf (_tmp23_, "=%s", _tmp27_);
	}
	_tmp28_ = self->check_state;
	switch (_tmp28_) {
		case CHECK_STATE_CHECK:
		{
			GString* _tmp29_;
			_tmp29_ = builder;
			g_string_append_c (_tmp29_, '+');
			break;
		}
		case CHECK_STATE_CHECKMATE:
		{
			GString* _tmp30_;
			_tmp30_ = builder;
			g_string_append_c (_tmp30_, '#');
			break;
		}
		default:
		break;
	}
	_tmp31_ = builder;
	_tmp32_ = _tmp31_->str;
	_tmp33_ = g_strdup (_tmp32_);
	result = _tmp33_;
	_g_string_free0 (builder);
	return result;
}


gchar* chess_move_get_engine (ChessMove* self) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* builder;
	static const gchar promotion_symbols[] = {' ', 'r', 'n', 'b', 'q', ' '};
	ChessPiece* _tmp1_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->promotion_piece;
	if (_tmp1_ != NULL) {
		GString* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		ChessPiece* _tmp7_;
		PieceType _tmp8_;
		gchar _tmp9_;
		_tmp2_ = builder;
		_tmp3_ = self->f0;
		_tmp4_ = self->r0;
		_tmp5_ = self->f1;
		_tmp6_ = self->r1;
		_tmp7_ = self->promotion_piece;
		_tmp8_ = _tmp7_->type;
		_tmp9_ = promotion_symbols[_tmp8_];
		g_string_append_printf (_tmp2_, "%c%d%c%d%c", 'a' + _tmp3_, _tmp4_ + 1, 'a' + _tmp5_, _tmp6_ + 1, (gint) _tmp9_);
	} else {
		GString* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp10_ = builder;
		_tmp11_ = self->f0;
		_tmp12_ = self->r0;
		_tmp13_ = self->f1;
		_tmp14_ = self->r1;
		g_string_append_printf (_tmp10_, "%c%d%c%d", 'a' + _tmp11_, _tmp12_ + 1, 'a' + _tmp13_, _tmp14_ + 1);
	}
	_tmp15_ = builder;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (builder);
	return result;
}


static gpointer _chess_piece_ref0 (gpointer self) {
	return self ? chess_piece_ref (self) : NULL;
}


ChessMove* chess_move_copy (ChessMove* self) {
	ChessMove* result = NULL;
	ChessMove* _tmp0_;
	ChessMove* move;
	gint _tmp1_;
	ChessPiece* _tmp2_;
	ChessPiece* _tmp3_;
	ChessPiece* _tmp4_;
	ChessPiece* _tmp5_;
	ChessPiece* _tmp6_;
	ChessPiece* _tmp7_;
	ChessPiece* _tmp8_;
	ChessPiece* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	CheckState _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_move_new ();
	move = _tmp0_;
	_tmp1_ = self->number;
	move->number = _tmp1_;
	_tmp2_ = self->piece;
	_tmp3_ = _chess_piece_ref0 (_tmp2_);
	_chess_piece_unref0 (move->piece);
	move->piece = _tmp3_;
	_tmp4_ = self->promotion_piece;
	_tmp5_ = _chess_piece_ref0 (_tmp4_);
	_chess_piece_unref0 (move->promotion_piece);
	move->promotion_piece = _tmp5_;
	_tmp6_ = self->moved_rook;
	_tmp7_ = _chess_piece_ref0 (_tmp6_);
	_chess_piece_unref0 (move->moved_rook);
	move->moved_rook = _tmp7_;
	_tmp8_ = self->victim;
	_tmp9_ = _chess_piece_ref0 (_tmp8_);
	_chess_piece_unref0 (move->victim);
	move->victim = _tmp9_;
	_tmp10_ = self->r0;
	move->r0 = _tmp10_;
	_tmp11_ = self->f0;
	move->f0 = _tmp11_;
	_tmp12_ = self->r1;
	move->r1 = _tmp12_;
	_tmp13_ = self->f1;
	move->f1 = _tmp13_;
	_tmp14_ = self->ambiguous_rank;
	move->ambiguous_rank = _tmp14_;
	_tmp15_ = self->ambiguous_file;
	move->ambiguous_file = _tmp15_;
	_tmp16_ = self->check_state;
	move->check_state = _tmp16_;
	result = move;
	return result;
}


ChessMove* chess_move_construct (GType object_type) {
	ChessMove* self = NULL;
	self = (ChessMove*) g_type_create_instance (object_type);
	return self;
}


ChessMove* chess_move_new (void) {
	return chess_move_construct (TYPE_CHESS_MOVE);
}


static void value_chess_move_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_chess_move_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		chess_move_unref (value->data[0].v_pointer);
	}
}


static void value_chess_move_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = chess_move_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_chess_move_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_chess_move_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ChessMove* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = chess_move_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_chess_move_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessMove** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = chess_move_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessMove* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_MOVE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_chess_move (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MOVE), NULL);
	return value->data[0].v_pointer;
}


void value_set_chess_move (GValue* value, gpointer v_object) {
	ChessMove* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MOVE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_MOVE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		chess_move_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_move_unref (old);
	}
}


void value_take_chess_move (GValue* value, gpointer v_object) {
	ChessMove* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MOVE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_MOVE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_move_unref (old);
	}
}


static void chess_move_class_init (ChessMoveClass * klass) {
	chess_move_parent_class = g_type_class_peek_parent (klass);
	CHESS_MOVE_CLASS (klass)->finalize = chess_move_finalize;
}


static void chess_move_instance_init (ChessMove * self) {
	self->ref_count = 1;
}


static void chess_move_finalize (ChessMove* obj) {
	ChessMove * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_MOVE, ChessMove);
	_chess_piece_unref0 (self->piece);
	_chess_piece_unref0 (self->promotion_piece);
	_chess_piece_unref0 (self->moved_rook);
	_chess_piece_unref0 (self->victim);
}


GType chess_move_get_type (void) {
	static volatile gsize chess_move_type_id__volatile = 0;
	if (g_once_init_enter (&chess_move_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_move_init, value_chess_move_free_value, value_chess_move_copy_value, value_chess_move_peek_pointer, "p", value_chess_move_collect_value, "p", value_chess_move_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessMoveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_move_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessMove), 0, (GInstanceInitFunc) chess_move_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_move_type_id;
		chess_move_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessMove", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_move_type_id__volatile, chess_move_type_id);
	}
	return chess_move_type_id__volatile;
}


gpointer chess_move_ref (gpointer instance) {
	ChessMove* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void chess_move_unref (gpointer instance) {
	ChessMove* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CHESS_MOVE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static ChessState* chess_state_construct_empty (GType object_type) {
	ChessState* self = NULL;
	self = (ChessState*) g_type_create_instance (object_type);
	return self;
}


static ChessState* chess_state_new_empty (void) {
	return chess_state_construct_empty (TYPE_CHESS_STATE);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


ChessState* chess_state_construct (GType object_type, const gchar* fen) {
	ChessState* self = NULL;
	ChessPlayer* _tmp0_;
	ChessPlayer* _tmp1_;
	ChessPlayer* _tmp2_;
	ChessPlayer* _tmp3_;
	const gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_ = NULL;
	gchar** fields;
	gint fields_length1;
	gint _fields_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_ = NULL;
	gchar** ranks;
	gint ranks_length1;
	gint _ranks_size_;
	gchar** _tmp69_;
	gint _tmp69__length1;
	const gchar* _tmp70_;
	gchar** _tmp77_;
	gint _tmp77__length1;
	const gchar* _tmp78_;
	gchar** _tmp99_;
	gint _tmp99__length1;
	const gchar* _tmp100_;
	gchar** _tmp108_;
	gint _tmp108__length1;
	const gchar* _tmp109_;
	gint _tmp110_ = 0;
	gchar** _tmp111_;
	gint _tmp111__length1;
	const gchar* _tmp112_;
	gint _tmp113_ = 0;
	ChessPlayer* _tmp114_;
	Color _tmp115_;
	ChessPlayer* _tmp117_;
	CheckState _tmp118_ = 0;
	g_return_val_if_fail (fen != NULL, NULL);
	self = (ChessState*) g_type_create_instance (object_type);
	_tmp0_ = chess_player_new (COLOR_WHITE);
	_g_object_unref0 (self->players[COLOR_WHITE]);
	self->players[COLOR_WHITE] = _tmp0_;
	_tmp1_ = self->players[COLOR_WHITE];
	_tmp2_ = chess_player_new (COLOR_BLACK);
	_g_object_unref0 (self->players[COLOR_BLACK]);
	self->players[COLOR_BLACK] = _tmp2_;
	_tmp3_ = self->players[COLOR_BLACK];
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				gint _tmp8_;
				ChessPiece* _tmp9_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				if (!(_tmp7_ < 64)) {
					break;
				}
				_tmp8_ = i;
				_chess_piece_unref0 (self->board[_tmp8_]);
				self->board[_tmp8_] = NULL;
				_tmp9_ = self->board[_tmp8_];
			}
		}
	}
	_tmp10_ = fen;
	_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, " ", 0);
	fields = _tmp12_;
	fields_length1 = _vala_array_length (_tmp11_);
	_fields_size_ = fields_length1;
	_tmp13_ = fields;
	_tmp13__length1 = fields_length1;
	_tmp14_ = _tmp13_[0];
	_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "/", 0);
	ranks = _tmp16_;
	ranks_length1 = _vala_array_length (_tmp15_);
	_ranks_size_ = ranks_length1;
	{
		gint rank;
		rank = 0;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_;
				gint _tmp20_;
				gchar** _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* rank_string;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = rank;
					rank = _tmp19_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp20_ = rank;
				if (!(_tmp20_ < 8)) {
					break;
				}
				_tmp21_ = ranks;
				_tmp21__length1 = ranks_length1;
				_tmp22_ = rank;
				_tmp23_ = _tmp21_[7 - _tmp22_];
				_tmp24_ = g_strdup (_tmp23_);
				rank_string = _tmp24_;
				{
					gint file;
					gint offset;
					file = 0;
					offset = 0;
					{
						gboolean _tmp25_;
						_tmp25_ = TRUE;
						while (TRUE) {
							gboolean _tmp26_;
							gboolean _tmp28_ = FALSE;
							gint _tmp29_;
							gboolean _tmp34_;
							const gchar* _tmp35_;
							gint _tmp36_;
							gchar _tmp37_ = '\0';
							gchar c;
							gboolean _tmp38_ = FALSE;
							gchar _tmp39_;
							gboolean _tmp41_;
							PieceType type = 0;
							Color _tmp44_ = 0;
							gchar _tmp45_;
							gboolean _tmp46_ = FALSE;
							Color _tmp47_;
							Color color;
							gchar _tmp48_;
							gchar _tmp49_ = '\0';
							PieceType _tmp50_ = 0;
							gboolean _tmp51_ = FALSE;
							gint _tmp52_;
							gint _tmp53_;
							gint _tmp54_ = 0;
							gint index;
							Color _tmp55_;
							ChessPlayer* _tmp56_;
							PieceType _tmp57_;
							ChessPiece* _tmp58_;
							ChessPiece* piece;
							gint _tmp59_;
							ChessPiece* _tmp60_;
							ChessPiece* _tmp61_;
							ChessPiece* _tmp62_;
							gint _tmp63_;
							gint64 _tmp64_;
							gint64 mask;
							Color _tmp65_;
							gint64 _tmp66_;
							gint64 _tmp67_;
							gint _tmp68_;
							_tmp26_ = _tmp25_;
							if (!_tmp26_) {
								gint _tmp27_;
								_tmp27_ = offset;
								offset = _tmp27_ + 1;
							}
							_tmp25_ = FALSE;
							_tmp29_ = file;
							if (_tmp29_ < 8) {
								gint _tmp30_;
								const gchar* _tmp31_;
								gint _tmp32_;
								gint _tmp33_;
								_tmp30_ = offset;
								_tmp31_ = rank_string;
								_tmp32_ = strlen (_tmp31_);
								_tmp33_ = _tmp32_;
								_tmp28_ = _tmp30_ < _tmp33_;
							} else {
								_tmp28_ = FALSE;
							}
							_tmp34_ = _tmp28_;
							if (!_tmp34_) {
								break;
							}
							_tmp35_ = rank_string;
							_tmp36_ = offset;
							_tmp37_ = string_get (_tmp35_, (glong) _tmp36_);
							c = _tmp37_;
							_tmp39_ = c;
							if (_tmp39_ >= '1') {
								gchar _tmp40_;
								_tmp40_ = c;
								_tmp38_ = _tmp40_ <= '8';
							} else {
								_tmp38_ = FALSE;
							}
							_tmp41_ = _tmp38_;
							if (_tmp41_) {
								gint _tmp42_;
								gchar _tmp43_;
								_tmp42_ = file;
								_tmp43_ = c;
								file = _tmp42_ + (_tmp43_ - '0');
								continue;
							}
							_tmp45_ = c;
							_tmp46_ = g_ascii_isupper (_tmp45_);
							if (_tmp46_) {
								_tmp44_ = COLOR_WHITE;
							} else {
								_tmp44_ = COLOR_BLACK;
							}
							_tmp47_ = _tmp44_;
							color = _tmp47_;
							_tmp48_ = c;
							_tmp49_ = g_ascii_toupper (_tmp48_);
							_tmp51_ = chess_state_decode_piece_type (self, (gunichar) _tmp49_, &_tmp50_);
							type = _tmp50_;
							if (!_tmp51_) {
							}
							_tmp52_ = rank;
							_tmp53_ = file;
							_tmp54_ = chess_state_get_index (self, _tmp52_, _tmp53_);
							index = _tmp54_;
							_tmp55_ = color;
							_tmp56_ = self->players[_tmp55_];
							_tmp57_ = type;
							_tmp58_ = chess_piece_new (_tmp56_, _tmp57_);
							piece = _tmp58_;
							_tmp59_ = index;
							_tmp60_ = piece;
							_tmp61_ = _chess_piece_ref0 (_tmp60_);
							_chess_piece_unref0 (self->board[_tmp59_]);
							self->board[_tmp59_] = _tmp61_;
							_tmp62_ = self->board[_tmp59_];
							_tmp63_ = index;
							_tmp64_ = BIT_BOARD_set_location_masks[_tmp63_];
							mask = _tmp64_;
							_tmp65_ = color;
							_tmp66_ = mask;
							self->priv->piece_masks[_tmp65_] |= _tmp66_;
							_tmp67_ = self->priv->piece_masks[_tmp65_];
							_tmp68_ = file;
							file = _tmp68_ + 1;
							_chess_piece_unref0 (piece);
						}
					}
				}
				_g_free0 (rank_string);
			}
		}
	}
	_tmp69_ = fields;
	_tmp69__length1 = fields_length1;
	_tmp70_ = _tmp69_[1];
	if (g_strcmp0 (_tmp70_, "w") == 0) {
		ChessPlayer* _tmp71_;
		ChessPlayer* _tmp72_;
		_tmp71_ = self->players[COLOR_WHITE];
		_tmp72_ = _g_object_ref0 (_tmp71_);
		_g_object_unref0 (self->current_player);
		self->current_player = _tmp72_;
	} else {
		gchar** _tmp73_;
		gint _tmp73__length1;
		const gchar* _tmp74_;
		_tmp73_ = fields;
		_tmp73__length1 = fields_length1;
		_tmp74_ = _tmp73_[1];
		if (g_strcmp0 (_tmp74_, "b") == 0) {
			ChessPlayer* _tmp75_;
			ChessPlayer* _tmp76_;
			_tmp75_ = self->players[COLOR_BLACK];
			_tmp76_ = _g_object_ref0 (_tmp75_);
			_g_object_unref0 (self->current_player);
			self->current_player = _tmp76_;
		}
	}
	_tmp77_ = fields;
	_tmp77__length1 = fields_length1;
	_tmp78_ = _tmp77_[2];
	if (g_strcmp0 (_tmp78_, "-") != 0) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp79_;
				_tmp79_ = TRUE;
				while (TRUE) {
					gboolean _tmp80_;
					gint _tmp82_;
					gchar** _tmp83_;
					gint _tmp83__length1;
					const gchar* _tmp84_;
					gint _tmp85_;
					gint _tmp86_;
					gchar** _tmp87_;
					gint _tmp87__length1;
					const gchar* _tmp88_;
					gint _tmp89_;
					gchar _tmp90_ = '\0';
					gchar c;
					gchar _tmp91_;
					_tmp80_ = _tmp79_;
					if (!_tmp80_) {
						gint _tmp81_;
						_tmp81_ = i;
						i = _tmp81_ + 1;
					}
					_tmp79_ = FALSE;
					_tmp82_ = i;
					_tmp83_ = fields;
					_tmp83__length1 = fields_length1;
					_tmp84_ = _tmp83_[2];
					_tmp85_ = strlen (_tmp84_);
					_tmp86_ = _tmp85_;
					if (!(_tmp82_ < _tmp86_)) {
						break;
					}
					_tmp87_ = fields;
					_tmp87__length1 = fields_length1;
					_tmp88_ = _tmp87_[2];
					_tmp89_ = i;
					_tmp90_ = string_get (_tmp88_, (glong) _tmp89_);
					c = _tmp90_;
					_tmp91_ = c;
					if (_tmp91_ == 'K') {
						gboolean _tmp92_;
						self->can_castle_kingside[COLOR_WHITE] = TRUE;
						_tmp92_ = self->can_castle_kingside[COLOR_WHITE];
					} else {
						gchar _tmp93_;
						_tmp93_ = c;
						if (_tmp93_ == 'Q') {
							gboolean _tmp94_;
							self->can_castle_queenside[COLOR_WHITE] = TRUE;
							_tmp94_ = self->can_castle_queenside[COLOR_WHITE];
						} else {
							gchar _tmp95_;
							_tmp95_ = c;
							if (_tmp95_ == 'k') {
								gboolean _tmp96_;
								self->can_castle_kingside[COLOR_BLACK] = TRUE;
								_tmp96_ = self->can_castle_kingside[COLOR_BLACK];
							} else {
								gchar _tmp97_;
								_tmp97_ = c;
								if (_tmp97_ == 'q') {
									gboolean _tmp98_;
									self->can_castle_queenside[COLOR_BLACK] = TRUE;
									_tmp98_ = self->can_castle_queenside[COLOR_BLACK];
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp99_ = fields;
	_tmp99__length1 = fields_length1;
	_tmp100_ = _tmp99_[3];
	if (g_strcmp0 (_tmp100_, "-") != 0) {
		gchar** _tmp101_;
		gint _tmp101__length1;
		const gchar* _tmp102_;
		gchar _tmp103_ = '\0';
		gchar** _tmp104_;
		gint _tmp104__length1;
		const gchar* _tmp105_;
		gchar _tmp106_ = '\0';
		gint _tmp107_ = 0;
		_tmp101_ = fields;
		_tmp101__length1 = fields_length1;
		_tmp102_ = _tmp101_[3];
		_tmp103_ = string_get (_tmp102_, (glong) 1);
		_tmp104_ = fields;
		_tmp104__length1 = fields_length1;
		_tmp105_ = _tmp104_[3];
		_tmp106_ = string_get (_tmp105_, (glong) 0);
		_tmp107_ = chess_state_get_index (self, (gint) (_tmp103_ - '1'), (gint) (_tmp106_ - 'a'));
		self->en_passant_index = _tmp107_;
	}
	_tmp108_ = fields;
	_tmp108__length1 = fields_length1;
	_tmp109_ = _tmp108_[4];
	_tmp110_ = atoi (_tmp109_);
	self->halfmove_clock = _tmp110_;
	_tmp111_ = fields;
	_tmp111__length1 = fields_length1;
	_tmp112_ = _tmp111_[5];
	_tmp113_ = atoi (_tmp112_);
	self->number = (_tmp113_ - 1) * 2;
	_tmp114_ = self->current_player;
	_tmp115_ = _tmp114_->color;
	if (_tmp115_ == COLOR_BLACK) {
		gint _tmp116_;
		_tmp116_ = self->number;
		self->number = _tmp116_ + 1;
	}
	_tmp117_ = self->current_player;
	_tmp118_ = chess_state_get_check_state (self, _tmp117_);
	self->check_state = _tmp118_;
	ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


ChessState* chess_state_new (const gchar* fen) {
	return chess_state_construct (TYPE_CHESS_STATE, fen);
}


ChessState* chess_state_copy (ChessState* self) {
	ChessState* result = NULL;
	ChessState* _tmp0_;
	ChessState* state;
	ChessState* _tmp1_;
	gint _tmp2_;
	ChessState* _tmp3_;
	ChessPlayer* _tmp4_;
	ChessPlayer* _tmp5_;
	ChessPlayer* _tmp6_;
	ChessState* _tmp7_;
	ChessPlayer* _tmp8_;
	ChessPlayer* _tmp9_;
	ChessPlayer* _tmp10_;
	ChessState* _tmp11_;
	ChessPlayer* _tmp12_;
	ChessPlayer* _tmp13_;
	ChessState* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	ChessState* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	ChessState* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	ChessState* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	ChessState* _tmp26_;
	gint _tmp27_;
	ChessState* _tmp28_;
	CheckState _tmp29_;
	ChessMove* _tmp30_;
	ChessState* _tmp44_;
	gint64 _tmp45_;
	gint64 _tmp46_;
	ChessState* _tmp47_;
	gint64 _tmp48_;
	gint64 _tmp49_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_state_new_empty ();
	state = _tmp0_;
	_tmp1_ = state;
	_tmp2_ = self->number;
	_tmp1_->number = _tmp2_;
	_tmp3_ = state;
	_tmp4_ = self->players[COLOR_WHITE];
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_tmp3_->players[COLOR_WHITE]);
	_tmp3_->players[COLOR_WHITE] = _tmp5_;
	_tmp6_ = _tmp3_->players[COLOR_WHITE];
	_tmp7_ = state;
	_tmp8_ = self->players[COLOR_BLACK];
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (_tmp7_->players[COLOR_BLACK]);
	_tmp7_->players[COLOR_BLACK] = _tmp9_;
	_tmp10_ = _tmp7_->players[COLOR_BLACK];
	_tmp11_ = state;
	_tmp12_ = self->current_player;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (_tmp11_->current_player);
	_tmp11_->current_player = _tmp13_;
	_tmp14_ = state;
	_tmp15_ = self->can_castle_kingside[COLOR_WHITE];
	_tmp14_->can_castle_kingside[COLOR_WHITE] = _tmp15_;
	_tmp16_ = _tmp14_->can_castle_kingside[COLOR_WHITE];
	_tmp17_ = state;
	_tmp18_ = self->can_castle_queenside[COLOR_WHITE];
	_tmp17_->can_castle_queenside[COLOR_WHITE] = _tmp18_;
	_tmp19_ = _tmp17_->can_castle_queenside[COLOR_WHITE];
	_tmp20_ = state;
	_tmp21_ = self->can_castle_kingside[COLOR_BLACK];
	_tmp20_->can_castle_kingside[COLOR_BLACK] = _tmp21_;
	_tmp22_ = _tmp20_->can_castle_kingside[COLOR_BLACK];
	_tmp23_ = state;
	_tmp24_ = self->can_castle_queenside[COLOR_BLACK];
	_tmp23_->can_castle_queenside[COLOR_BLACK] = _tmp24_;
	_tmp25_ = _tmp23_->can_castle_queenside[COLOR_BLACK];
	_tmp26_ = state;
	_tmp27_ = self->en_passant_index;
	_tmp26_->en_passant_index = _tmp27_;
	_tmp28_ = state;
	_tmp29_ = self->check_state;
	_tmp28_->check_state = _tmp29_;
	_tmp30_ = self->last_move;
	if (_tmp30_ != NULL) {
		ChessState* _tmp31_;
		ChessMove* _tmp32_;
		ChessMove* _tmp33_ = NULL;
		_tmp31_ = state;
		_tmp32_ = self->last_move;
		_tmp33_ = chess_move_copy (_tmp32_);
		_chess_move_unref0 (_tmp31_->last_move);
		_tmp31_->last_move = _tmp33_;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp34_;
			_tmp34_ = TRUE;
			while (TRUE) {
				gboolean _tmp35_;
				gint _tmp37_;
				ChessState* _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				ChessPiece* _tmp41_;
				ChessPiece* _tmp42_;
				ChessPiece* _tmp43_;
				_tmp35_ = _tmp34_;
				if (!_tmp35_) {
					gint _tmp36_;
					_tmp36_ = i;
					i = _tmp36_ + 1;
				}
				_tmp34_ = FALSE;
				_tmp37_ = i;
				if (!(_tmp37_ < 64)) {
					break;
				}
				_tmp38_ = state;
				_tmp39_ = i;
				_tmp40_ = i;
				_tmp41_ = self->board[_tmp40_];
				_tmp42_ = _chess_piece_ref0 (_tmp41_);
				_chess_piece_unref0 (_tmp38_->board[_tmp39_]);
				_tmp38_->board[_tmp39_] = _tmp42_;
				_tmp43_ = _tmp38_->board[_tmp39_];
			}
		}
	}
	_tmp44_ = state;
	_tmp45_ = self->priv->piece_masks[COLOR_WHITE];
	_tmp44_->priv->piece_masks[COLOR_WHITE] = _tmp45_;
	_tmp46_ = _tmp44_->priv->piece_masks[COLOR_WHITE];
	_tmp47_ = state;
	_tmp48_ = self->priv->piece_masks[COLOR_BLACK];
	_tmp47_->priv->piece_masks[COLOR_BLACK] = _tmp48_;
	_tmp49_ = _tmp47_->priv->piece_masks[COLOR_BLACK];
	result = state;
	return result;
}


gboolean chess_state_equals (ChessState* self, ChessState* state) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gint64 _tmp12_;
	ChessState* _tmp13_;
	gint64 _tmp14_;
	gboolean _tmp18_;
	gboolean _tmp22_;
	gboolean _tmp26_;
	gboolean _tmp30_;
	gboolean _tmp34_;
	gboolean _tmp38_;
	gboolean _tmp42_;
	gboolean _tmp50_;
	gboolean _tmp56_;
	gboolean _tmp62_;
	gboolean _tmp68_;
	gboolean _tmp74_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	_tmp12_ = self->priv->piece_masks[COLOR_WHITE];
	_tmp13_ = state;
	_tmp14_ = _tmp13_->priv->piece_masks[COLOR_WHITE];
	if (_tmp12_ != _tmp14_) {
		_tmp11_ = TRUE;
	} else {
		gint64 _tmp15_;
		ChessState* _tmp16_;
		gint64 _tmp17_;
		_tmp15_ = self->priv->piece_masks[COLOR_BLACK];
		_tmp16_ = state;
		_tmp17_ = _tmp16_->priv->piece_masks[COLOR_BLACK];
		_tmp11_ = _tmp15_ != _tmp17_;
	}
	_tmp18_ = _tmp11_;
	if (_tmp18_) {
		_tmp10_ = TRUE;
	} else {
		gboolean _tmp19_;
		ChessState* _tmp20_;
		gboolean _tmp21_;
		_tmp19_ = self->can_castle_kingside[COLOR_WHITE];
		_tmp20_ = state;
		_tmp21_ = _tmp20_->can_castle_kingside[COLOR_WHITE];
		_tmp10_ = _tmp19_ != _tmp21_;
	}
	_tmp22_ = _tmp10_;
	if (_tmp22_) {
		_tmp9_ = TRUE;
	} else {
		gboolean _tmp23_;
		ChessState* _tmp24_;
		gboolean _tmp25_;
		_tmp23_ = self->can_castle_queenside[COLOR_WHITE];
		_tmp24_ = state;
		_tmp25_ = _tmp24_->can_castle_queenside[COLOR_WHITE];
		_tmp9_ = _tmp23_ != _tmp25_;
	}
	_tmp26_ = _tmp9_;
	if (_tmp26_) {
		_tmp8_ = TRUE;
	} else {
		gboolean _tmp27_;
		ChessState* _tmp28_;
		gboolean _tmp29_;
		_tmp27_ = self->can_castle_kingside[COLOR_BLACK];
		_tmp28_ = state;
		_tmp29_ = _tmp28_->can_castle_kingside[COLOR_BLACK];
		_tmp8_ = _tmp27_ != _tmp29_;
	}
	_tmp30_ = _tmp8_;
	if (_tmp30_) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp31_;
		ChessState* _tmp32_;
		gboolean _tmp33_;
		_tmp31_ = self->can_castle_queenside[COLOR_BLACK];
		_tmp32_ = state;
		_tmp33_ = _tmp32_->can_castle_queenside[COLOR_BLACK];
		_tmp7_ = _tmp31_ != _tmp33_;
	}
	_tmp34_ = _tmp7_;
	if (_tmp34_) {
		_tmp6_ = TRUE;
	} else {
		gint _tmp35_;
		ChessState* _tmp36_;
		gint _tmp37_;
		_tmp35_ = self->en_passant_index;
		_tmp36_ = state;
		_tmp37_ = _tmp36_->en_passant_index;
		_tmp6_ = _tmp35_ != _tmp37_;
	}
	_tmp38_ = _tmp6_;
	if (_tmp38_) {
		_tmp5_ = TRUE;
	} else {
		ChessMove* _tmp39_;
		ChessState* _tmp40_;
		ChessMove* _tmp41_;
		_tmp39_ = self->last_move;
		_tmp40_ = state;
		_tmp41_ = _tmp40_->last_move;
		_tmp5_ = (_tmp39_ != NULL) != (_tmp41_ != NULL);
	}
	_tmp42_ = _tmp5_;
	if (_tmp42_) {
		_tmp4_ = TRUE;
	} else {
		ChessMove* _tmp43_;
		ChessPiece* _tmp44_;
		PieceType _tmp45_;
		ChessState* _tmp46_;
		ChessMove* _tmp47_;
		ChessPiece* _tmp48_;
		PieceType _tmp49_;
		_tmp43_ = self->last_move;
		_tmp44_ = _tmp43_->piece;
		_tmp45_ = _tmp44_->type;
		_tmp46_ = state;
		_tmp47_ = _tmp46_->last_move;
		_tmp48_ = _tmp47_->piece;
		_tmp49_ = _tmp48_->type;
		_tmp4_ = _tmp45_ != _tmp49_;
	}
	_tmp50_ = _tmp4_;
	if (_tmp50_) {
		_tmp3_ = TRUE;
	} else {
		ChessMove* _tmp51_;
		gint _tmp52_;
		ChessState* _tmp53_;
		ChessMove* _tmp54_;
		gint _tmp55_;
		_tmp51_ = self->last_move;
		_tmp52_ = _tmp51_->r0;
		_tmp53_ = state;
		_tmp54_ = _tmp53_->last_move;
		_tmp55_ = _tmp54_->r0;
		_tmp3_ = _tmp52_ != _tmp55_;
	}
	_tmp56_ = _tmp3_;
	if (_tmp56_) {
		_tmp2_ = TRUE;
	} else {
		ChessMove* _tmp57_;
		gint _tmp58_;
		ChessState* _tmp59_;
		ChessMove* _tmp60_;
		gint _tmp61_;
		_tmp57_ = self->last_move;
		_tmp58_ = _tmp57_->f0;
		_tmp59_ = state;
		_tmp60_ = _tmp59_->last_move;
		_tmp61_ = _tmp60_->f0;
		_tmp2_ = _tmp58_ != _tmp61_;
	}
	_tmp62_ = _tmp2_;
	if (_tmp62_) {
		_tmp1_ = TRUE;
	} else {
		ChessMove* _tmp63_;
		gint _tmp64_;
		ChessState* _tmp65_;
		ChessMove* _tmp66_;
		gint _tmp67_;
		_tmp63_ = self->last_move;
		_tmp64_ = _tmp63_->r1;
		_tmp65_ = state;
		_tmp66_ = _tmp65_->last_move;
		_tmp67_ = _tmp66_->r1;
		_tmp1_ = _tmp64_ != _tmp67_;
	}
	_tmp68_ = _tmp1_;
	if (_tmp68_) {
		_tmp0_ = TRUE;
	} else {
		ChessMove* _tmp69_;
		gint _tmp70_;
		ChessState* _tmp71_;
		ChessMove* _tmp72_;
		gint _tmp73_;
		_tmp69_ = self->last_move;
		_tmp70_ = _tmp69_->f1;
		_tmp71_ = state;
		_tmp72_ = _tmp71_->last_move;
		_tmp73_ = _tmp72_->f1;
		_tmp0_ = _tmp70_ != _tmp73_;
	}
	_tmp74_ = _tmp0_;
	if (_tmp74_) {
		result = FALSE;
		return result;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp75_;
			_tmp75_ = TRUE;
			while (TRUE) {
				gboolean _tmp76_;
				gint _tmp78_;
				gboolean _tmp79_ = FALSE;
				gint _tmp80_;
				ChessPiece* _tmp81_;
				gboolean _tmp89_;
				_tmp76_ = _tmp75_;
				if (!_tmp76_) {
					gint _tmp77_;
					_tmp77_ = i;
					i = _tmp77_ + 1;
				}
				_tmp75_ = FALSE;
				_tmp78_ = i;
				if (!(_tmp78_ < 64)) {
					break;
				}
				_tmp80_ = i;
				_tmp81_ = self->board[_tmp80_];
				if (_tmp81_ != NULL) {
					gint _tmp82_;
					ChessPiece* _tmp83_;
					PieceType _tmp84_;
					ChessState* _tmp85_;
					gint _tmp86_;
					ChessPiece* _tmp87_;
					PieceType _tmp88_;
					_tmp82_ = i;
					_tmp83_ = self->board[_tmp82_];
					_tmp84_ = _tmp83_->type;
					_tmp85_ = state;
					_tmp86_ = i;
					_tmp87_ = _tmp85_->board[_tmp86_];
					_tmp88_ = _tmp87_->type;
					_tmp79_ = _tmp84_ != _tmp88_;
				} else {
					_tmp79_ = FALSE;
				}
				_tmp89_ = _tmp79_;
				if (_tmp89_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


gchar* chess_state_get_fen (ChessState* self) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* value;
	GString* _tmp28_;
	ChessPlayer* _tmp29_;
	Color _tmp30_;
	GString* _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp36_;
	gboolean _tmp38_;
	gboolean _tmp40_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	GString* _tmp47_;
	gint _tmp48_;
	GString* _tmp55_;
	GString* _tmp56_;
	gint _tmp57_;
	GString* _tmp58_;
	ChessPlayer* _tmp59_;
	Color _tmp60_;
	GString* _tmp65_;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	value = _tmp0_;
	{
		gint rank;
		rank = 7;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint skip_count;
				gint _tmp23_;
				gint _tmp26_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = rank;
					rank = _tmp3_ - 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = rank;
				if (!(_tmp4_ >= 0)) {
					break;
				}
				skip_count = 0;
				{
					gint file;
					file = 0;
					{
						gboolean _tmp5_;
						_tmp5_ = TRUE;
						while (TRUE) {
							gboolean _tmp6_;
							gint _tmp8_;
							gint _tmp9_;
							gint _tmp10_;
							gint _tmp11_ = 0;
							ChessPiece* _tmp12_;
							ChessPiece* _tmp13_;
							ChessPiece* p;
							ChessPiece* _tmp14_;
							_tmp6_ = _tmp5_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = file;
								file = _tmp7_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp8_ = file;
							if (!(_tmp8_ < 8)) {
								break;
							}
							_tmp9_ = rank;
							_tmp10_ = file;
							_tmp11_ = chess_state_get_index (self, _tmp9_, _tmp10_);
							_tmp12_ = self->board[_tmp11_];
							_tmp13_ = _chess_piece_ref0 (_tmp12_);
							p = _tmp13_;
							_tmp14_ = p;
							if (_tmp14_ == NULL) {
								gint _tmp15_;
								_tmp15_ = skip_count;
								skip_count = _tmp15_ + 1;
							} else {
								gint _tmp16_;
								GString* _tmp19_;
								ChessPiece* _tmp20_;
								gunichar _tmp21_;
								gunichar _tmp22_;
								_tmp16_ = skip_count;
								if (_tmp16_ > 0) {
									GString* _tmp17_;
									gint _tmp18_;
									_tmp17_ = value;
									_tmp18_ = skip_count;
									g_string_append_printf (_tmp17_, "%d", _tmp18_);
									skip_count = 0;
								}
								_tmp19_ = value;
								_tmp20_ = p;
								_tmp21_ = chess_piece_get_symbol (_tmp20_);
								_tmp22_ = _tmp21_;
								g_string_append_printf (_tmp19_, "%c", (gint) _tmp22_);
							}
							_chess_piece_unref0 (p);
						}
					}
				}
				_tmp23_ = skip_count;
				if (_tmp23_ > 0) {
					GString* _tmp24_;
					gint _tmp25_;
					_tmp24_ = value;
					_tmp25_ = skip_count;
					g_string_append_printf (_tmp24_, "%d", _tmp25_);
				}
				_tmp26_ = rank;
				if (_tmp26_ != 0) {
					GString* _tmp27_;
					_tmp27_ = value;
					g_string_append_c (_tmp27_, '/');
				}
			}
		}
	}
	_tmp28_ = value;
	g_string_append_c (_tmp28_, ' ');
	_tmp29_ = self->current_player;
	_tmp30_ = _tmp29_->color;
	if (_tmp30_ == COLOR_WHITE) {
		GString* _tmp31_;
		_tmp31_ = value;
		g_string_append_c (_tmp31_, 'w');
	} else {
		GString* _tmp32_;
		_tmp32_ = value;
		g_string_append_c (_tmp32_, 'b');
	}
	_tmp33_ = value;
	g_string_append_c (_tmp33_, ' ');
	_tmp34_ = self->can_castle_kingside[COLOR_WHITE];
	if (_tmp34_) {
		GString* _tmp35_;
		_tmp35_ = value;
		g_string_append_c (_tmp35_, 'K');
	}
	_tmp36_ = self->can_castle_queenside[COLOR_WHITE];
	if (_tmp36_) {
		GString* _tmp37_;
		_tmp37_ = value;
		g_string_append_c (_tmp37_, 'Q');
	}
	_tmp38_ = self->can_castle_kingside[COLOR_BLACK];
	if (_tmp38_) {
		GString* _tmp39_;
		_tmp39_ = value;
		g_string_append_c (_tmp39_, 'k');
	}
	_tmp40_ = self->can_castle_queenside[COLOR_BLACK];
	if (_tmp40_) {
		GString* _tmp41_;
		_tmp41_ = value;
		g_string_append_c (_tmp41_, 'q');
	}
	_tmp42_ = self->can_castle_kingside[COLOR_WHITE];
	_tmp43_ = self->can_castle_queenside[COLOR_WHITE];
	_tmp44_ = self->can_castle_kingside[COLOR_BLACK];
	_tmp45_ = self->can_castle_queenside[COLOR_BLACK];
	if (!(((_tmp42_ | _tmp43_) | _tmp44_) | _tmp45_)) {
		GString* _tmp46_;
		_tmp46_ = value;
		g_string_append_c (_tmp46_, '-');
	}
	_tmp47_ = value;
	g_string_append_c (_tmp47_, ' ');
	_tmp48_ = self->en_passant_index;
	if (_tmp48_ >= 0) {
		GString* _tmp49_;
		gint _tmp50_;
		gint _tmp51_ = 0;
		gint _tmp52_;
		gint _tmp53_ = 0;
		_tmp49_ = value;
		_tmp50_ = self->en_passant_index;
		_tmp51_ = chess_state_get_file (self, _tmp50_);
		_tmp52_ = self->en_passant_index;
		_tmp53_ = chess_state_get_rank (self, _tmp52_);
		g_string_append_printf (_tmp49_, "%c%d", 'a' + _tmp51_, _tmp53_ + 1);
	} else {
		GString* _tmp54_;
		_tmp54_ = value;
		g_string_append_c (_tmp54_, '-');
	}
	_tmp55_ = value;
	g_string_append_c (_tmp55_, ' ');
	_tmp56_ = value;
	_tmp57_ = self->halfmove_clock;
	g_string_append_printf (_tmp56_, "%d", _tmp57_);
	_tmp58_ = value;
	g_string_append_c (_tmp58_, ' ');
	_tmp59_ = self->current_player;
	_tmp60_ = _tmp59_->color;
	if (_tmp60_ == COLOR_WHITE) {
		GString* _tmp61_;
		gint _tmp62_;
		_tmp61_ = value;
		_tmp62_ = self->number;
		g_string_append_printf (_tmp61_, "%d", _tmp62_ / 2);
	} else {
		GString* _tmp63_;
		gint _tmp64_;
		_tmp63_ = value;
		_tmp64_ = self->number;
		g_string_append_printf (_tmp63_, "%d", (_tmp64_ / 2) + 1);
	}
	_tmp65_ = value;
	_tmp66_ = _tmp65_->str;
	_tmp67_ = g_strdup (_tmp66_);
	result = _tmp67_;
	_g_string_free0 (value);
	return result;
}


gint chess_state_get_index (ChessState* self, gint rank, gint file) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = rank;
	_tmp1_ = file;
	result = (_tmp0_ * 8) + _tmp1_;
	return result;
}


gint chess_state_get_rank (ChessState* self, gint index) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = index;
	result = _tmp0_ / 8;
	return result;
}


gint chess_state_get_file (ChessState* self, gint index) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = index;
	result = _tmp0_ % 8;
	return result;
}


gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	gint r0 = 0;
	gint f0 = 0;
	gint r1 = 0;
	gint f1 = 0;
	PieceType promotion_type = 0;
	ChessPlayer* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	PieceType _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	ChessPlayer* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	PieceType _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (move != NULL, FALSE);
	_tmp0_ = self->current_player;
	_tmp1_ = move;
	_tmp7_ = chess_state_decode_move (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	r0 = _tmp2_;
	f0 = _tmp3_;
	r1 = _tmp4_;
	f1 = _tmp5_;
	promotion_type = _tmp6_;
	if (!_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = self->current_player;
	_tmp9_ = r0;
	_tmp10_ = f0;
	_tmp11_ = r1;
	_tmp12_ = f1;
	_tmp13_ = promotion_type;
	_tmp14_ = apply;
	_tmp15_ = chess_state_move_with_coords (self, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_, TRUE);
	if (!_tmp15_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


gboolean chess_state_move_with_coords (ChessState* self, ChessPlayer* player, gint r0, gint f0, gint r1, gint f1, PieceType promotion_type, gboolean apply, gboolean test_check) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
	gint start;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_ = 0;
	gint end;
	ChessPlayer* _tmp6_;
	Color _tmp7_;
	Color color;
	Color _tmp8_ = 0;
	Color _tmp9_;
	Color _tmp10_;
	Color opponent_color;
	gint _tmp11_;
	ChessPiece* _tmp12_;
	ChessPiece* _tmp13_;
	ChessPiece* piece;
	gboolean _tmp14_ = FALSE;
	ChessPiece* _tmp15_;
	gboolean _tmp19_;
	gint _tmp20_;
	gint64 _tmp21_;
	gint64 end_mask;
	Color _tmp22_;
	ChessPiece* _tmp23_;
	PieceType _tmp24_;
	gint _tmp25_;
	gint64 _tmp26_;
	gint64 move_mask;
	gint64 _tmp27_;
	gint64 _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint64 _tmp31_;
	gint64 over_mask;
	gint64 _tmp32_;
	gint64 _tmp33_;
	gint64 _tmp34_;
	gint _tmp35_;
	ChessPiece* _tmp36_;
	ChessPiece* _tmp37_;
	ChessPiece* victim;
	gint _tmp38_;
	gint victim_index;
	gboolean _tmp39_ = FALSE;
	ChessPiece* _tmp40_;
	gboolean _tmp44_;
	gint rook_start;
	gint rook_end;
	gboolean is_promotion;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	ChessPiece* _tmp45_;
	PieceType _tmp46_;
	gboolean _tmp128_ = FALSE;
	gboolean _tmp129_;
	gboolean _tmp131_;
	gboolean _tmp132_;
	gint64 _tmp168_;
	gint64 old_white_mask;
	gint64 _tmp169_;
	gint64 old_black_mask;
	gboolean _tmp170_;
	gboolean old_white_can_castle_kingside;
	gboolean _tmp171_;
	gboolean old_white_can_castle_queenside;
	gboolean _tmp172_;
	gboolean old_black_can_castle_kingside;
	gboolean _tmp173_;
	gboolean old_black_can_castle_queenside;
	gint _tmp174_;
	gint old_en_passant_index;
	gint _tmp175_;
	gint old_halfmove_clock;
	gint _tmp176_;
	ChessPiece* _tmp177_;
	gint _tmp178_;
	gint64 _tmp179_;
	gint64 _tmp180_;
	gint _tmp181_;
	gint64 _tmp182_;
	gint64 _tmp183_;
	ChessPiece* _tmp184_;
	gboolean _tmp193_;
	Color _tmp203_;
	gint64 _tmp204_;
	gint64 _tmp205_;
	Color _tmp206_;
	gint _tmp207_;
	gint64 _tmp208_;
	gint64 _tmp209_;
	gint _tmp210_;
	ChessPiece* _tmp228_;
	PieceType _tmp229_;
	gboolean _tmp263_ = FALSE;
	ChessPiece* _tmp264_;
	PieceType _tmp265_;
	gboolean _tmp267_;
	gboolean _tmp272_ = FALSE;
	ChessPiece* _tmp273_;
	PieceType _tmp274_;
	gboolean _tmp276_;
	gboolean _result_;
	gboolean _tmp278_ = FALSE;
	gboolean _tmp279_;
	gboolean _tmp282_;
	gboolean _tmp283_ = FALSE;
	gboolean _tmp284_;
	gboolean _tmp286_;
	ChessPlayer* _tmp322_ = NULL;
	Color _tmp323_;
	ChessPlayer* _tmp326_;
	ChessPlayer* _tmp327_;
	ChessPlayer* _tmp328_;
	CheckState _tmp329_ = 0;
	ChessMove* _tmp330_;
	ChessMove* _tmp331_;
	gint _tmp332_;
	ChessMove* _tmp333_;
	ChessPiece* _tmp334_;
	ChessPiece* _tmp335_;
	gboolean _tmp336_;
	ChessMove* _tmp341_;
	ChessPiece* _tmp342_;
	ChessPiece* _tmp343_;
	gint _tmp344_;
	ChessMove* _tmp349_;
	gint _tmp350_;
	ChessMove* _tmp351_;
	gint _tmp352_;
	ChessMove* _tmp353_;
	gint _tmp354_;
	ChessMove* _tmp355_;
	gint _tmp356_;
	ChessMove* _tmp357_;
	gboolean _tmp358_;
	ChessMove* _tmp359_;
	gboolean _tmp360_;
	ChessMove* _tmp361_;
	CheckState _tmp362_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp0_ = r0;
	_tmp1_ = f0;
	_tmp2_ = chess_state_get_index (self, _tmp0_, _tmp1_);
	start = _tmp2_;
	_tmp3_ = r1;
	_tmp4_ = f1;
	_tmp5_ = chess_state_get_index (self, _tmp3_, _tmp4_);
	end = _tmp5_;
	_tmp6_ = player;
	_tmp7_ = _tmp6_->color;
	color = _tmp7_;
	_tmp9_ = color;
	if (_tmp9_ == COLOR_WHITE) {
		_tmp8_ = COLOR_BLACK;
	} else {
		_tmp8_ = COLOR_WHITE;
	}
	_tmp10_ = _tmp8_;
	opponent_color = _tmp10_;
	_tmp11_ = start;
	_tmp12_ = self->board[_tmp11_];
	_tmp13_ = _chess_piece_ref0 (_tmp12_);
	piece = _tmp13_;
	_tmp15_ = piece;
	if (_tmp15_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		ChessPiece* _tmp16_;
		ChessPlayer* _tmp17_;
		ChessPlayer* _tmp18_;
		_tmp16_ = piece;
		_tmp17_ = _tmp16_->player;
		_tmp18_ = player;
		_tmp14_ = _tmp17_ != _tmp18_;
	}
	_tmp19_ = _tmp14_;
	if (_tmp19_) {
		result = FALSE;
		_chess_piece_unref0 (piece);
		return result;
	}
	_tmp20_ = end;
	_tmp21_ = BIT_BOARD_set_location_masks[_tmp20_];
	end_mask = _tmp21_;
	_tmp22_ = color;
	_tmp23_ = piece;
	_tmp24_ = _tmp23_->type;
	_tmp25_ = start;
	_tmp26_ = BIT_BOARD_move_masks[(((_tmp22_ * 64) * 6) + (_tmp24_ * 64)) + _tmp25_];
	move_mask = _tmp26_;
	_tmp27_ = end_mask;
	_tmp28_ = move_mask;
	if ((_tmp27_ & _tmp28_) == ((gint64) 0)) {
		result = FALSE;
		_chess_piece_unref0 (piece);
		return result;
	}
	_tmp29_ = start;
	_tmp30_ = end;
	_tmp31_ = BIT_BOARD_over_masks[(_tmp29_ * 64) + _tmp30_];
	over_mask = _tmp31_;
	_tmp32_ = over_mask;
	_tmp33_ = self->priv->piece_masks[COLOR_WHITE];
	_tmp34_ = self->priv->piece_masks[COLOR_BLACK];
	if ((_tmp32_ & (_tmp33_ | _tmp34_)) != ((gint64) 0)) {
		result = FALSE;
		_chess_piece_unref0 (piece);
		return result;
	}
	_tmp35_ = end;
	_tmp36_ = self->board[_tmp35_];
	_tmp37_ = _chess_piece_ref0 (_tmp36_);
	victim = _tmp37_;
	_tmp38_ = end;
	victim_index = _tmp38_;
	_tmp40_ = victim;
	if (_tmp40_ != NULL) {
		ChessPiece* _tmp41_;
		ChessPlayer* _tmp42_;
		ChessPlayer* _tmp43_;
		_tmp41_ = victim;
		_tmp42_ = _tmp41_->player;
		_tmp43_ = player;
		_tmp39_ = _tmp42_ == _tmp43_;
	} else {
		_tmp39_ = FALSE;
	}
	_tmp44_ = _tmp39_;
	if (_tmp44_) {
		result = FALSE;
		_chess_piece_unref0 (victim);
		_chess_piece_unref0 (piece);
		return result;
	}
	rook_start = -1;
	rook_end = -1;
	is_promotion = FALSE;
	ambiguous_rank = FALSE;
	ambiguous_file = FALSE;
	_tmp45_ = piece;
	_tmp46_ = _tmp45_->type;
	switch (_tmp46_) {
		case PIECE_TYPE_PAWN:
		{
			gboolean _tmp47_ = FALSE;
			ChessPiece* _tmp48_;
			gboolean _tmp51_;
			gint _tmp60_;
			gint _tmp61_;
			gboolean _tmp64_ = FALSE;
			gint _tmp65_;
			gboolean _tmp67_;
			ChessPiece* _tmp68_;
			_tmp48_ = victim;
			if (_tmp48_ == NULL) {
				gint _tmp49_;
				gint _tmp50_;
				_tmp49_ = end;
				_tmp50_ = self->en_passant_index;
				_tmp47_ = _tmp49_ == _tmp50_;
			} else {
				_tmp47_ = FALSE;
			}
			_tmp51_ = _tmp47_;
			if (_tmp51_) {
				gint _tmp52_ = 0;
				gint _tmp53_;
				gint _tmp54_;
				gint _tmp55_;
				gint _tmp56_ = 0;
				gint _tmp57_;
				ChessPiece* _tmp58_;
				ChessPiece* _tmp59_;
				_tmp53_ = r1;
				if (_tmp53_ == 2) {
					_tmp52_ = 3;
				} else {
					_tmp52_ = 4;
				}
				_tmp54_ = _tmp52_;
				_tmp55_ = f1;
				_tmp56_ = chess_state_get_index (self, _tmp54_, _tmp55_);
				victim_index = _tmp56_;
				_tmp57_ = victim_index;
				_tmp58_ = self->board[_tmp57_];
				_tmp59_ = _chess_piece_ref0 (_tmp58_);
				_chess_piece_unref0 (victim);
				victim = _tmp59_;
			}
			_tmp60_ = f0;
			_tmp61_ = f1;
			if (_tmp60_ != _tmp61_) {
				ChessPiece* _tmp62_;
				_tmp62_ = victim;
				if (_tmp62_ == NULL) {
					result = FALSE;
					_chess_piece_unref0 (victim);
					_chess_piece_unref0 (piece);
					return result;
				}
			} else {
				ChessPiece* _tmp63_;
				_tmp63_ = victim;
				if (_tmp63_ != NULL) {
					result = FALSE;
					_chess_piece_unref0 (victim);
					_chess_piece_unref0 (piece);
					return result;
				}
			}
			_tmp65_ = r1;
			if (_tmp65_ == 0) {
				_tmp64_ = TRUE;
			} else {
				gint _tmp66_;
				_tmp66_ = r1;
				_tmp64_ = _tmp66_ == 7;
			}
			_tmp67_ = _tmp64_;
			is_promotion = _tmp67_;
			_tmp68_ = victim;
			if (_tmp68_ != NULL) {
				ambiguous_file = TRUE;
			}
			break;
		}
		case PIECE_TYPE_KING:
		{
			gint _tmp69_;
			gint _tmp70_;
			gint _tmp71_ = 0;
			_tmp69_ = f0;
			_tmp70_ = f1;
			_tmp71_ = abs (_tmp69_ - _tmp70_);
			if (_tmp71_ > 1) {
				gint _tmp72_ = 0;
				gint _tmp73_;
				gint _tmp74_;
				gint _tmp75_;
				gint _tmp76_;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				gint _tmp79_;
				gint _tmp80_;
				gint _tmp83_;
				gint _tmp84_;
				gint _tmp85_ = 0;
				gint _tmp86_;
				gint _tmp87_;
				gint _tmp92_;
				ChessPiece* _tmp93_;
				ChessPiece* _tmp94_;
				ChessPiece* rook;
				gboolean _tmp95_ = FALSE;
				gboolean _tmp96_ = FALSE;
				ChessPiece* _tmp97_;
				gboolean _tmp100_;
				gboolean _tmp105_;
				gint _tmp106_;
				gint _tmp107_;
				gint64 _tmp108_;
				gint64 rook_over_mask;
				gint64 _tmp109_;
				gint64 _tmp110_;
				gint64 _tmp111_;
				CheckState _tmp112_;
				_tmp73_ = f1;
				_tmp74_ = f0;
				if (_tmp73_ > _tmp74_) {
					_tmp72_ = 7;
				} else {
					_tmp72_ = 0;
				}
				_tmp75_ = r0;
				_tmp76_ = _tmp72_;
				_tmp77_ = chess_state_get_index (self, _tmp75_, _tmp76_);
				rook_start = _tmp77_;
				_tmp79_ = f1;
				_tmp80_ = f0;
				if (_tmp79_ > _tmp80_) {
					gint _tmp81_;
					_tmp81_ = f1;
					_tmp78_ = _tmp81_ - 1;
				} else {
					gint _tmp82_;
					_tmp82_ = f1;
					_tmp78_ = _tmp82_ + 1;
				}
				_tmp83_ = r0;
				_tmp84_ = _tmp78_;
				_tmp85_ = chess_state_get_index (self, _tmp83_, _tmp84_);
				rook_end = _tmp85_;
				_tmp86_ = f1;
				_tmp87_ = f0;
				if (_tmp86_ > _tmp87_) {
					Color _tmp88_;
					gboolean _tmp89_;
					_tmp88_ = color;
					_tmp89_ = self->can_castle_kingside[_tmp88_];
					if (!_tmp89_) {
						result = FALSE;
						_chess_piece_unref0 (victim);
						_chess_piece_unref0 (piece);
						return result;
					}
				} else {
					Color _tmp90_;
					gboolean _tmp91_;
					_tmp90_ = color;
					_tmp91_ = self->can_castle_queenside[_tmp90_];
					if (!_tmp91_) {
						result = FALSE;
						_chess_piece_unref0 (victim);
						_chess_piece_unref0 (piece);
						return result;
					}
				}
				_tmp92_ = rook_start;
				_tmp93_ = self->board[_tmp92_];
				_tmp94_ = _chess_piece_ref0 (_tmp93_);
				rook = _tmp94_;
				_tmp97_ = rook;
				if (_tmp97_ == NULL) {
					_tmp96_ = TRUE;
				} else {
					ChessPiece* _tmp98_;
					PieceType _tmp99_;
					_tmp98_ = rook;
					_tmp99_ = _tmp98_->type;
					_tmp96_ = _tmp99_ != PIECE_TYPE_ROOK;
				}
				_tmp100_ = _tmp96_;
				if (_tmp100_) {
					_tmp95_ = TRUE;
				} else {
					ChessPiece* _tmp101_;
					Color _tmp102_;
					Color _tmp103_;
					Color _tmp104_;
					_tmp101_ = rook;
					_tmp102_ = chess_piece_get_color (_tmp101_);
					_tmp103_ = _tmp102_;
					_tmp104_ = color;
					_tmp95_ = _tmp103_ != _tmp104_;
				}
				_tmp105_ = _tmp95_;
				if (_tmp105_) {
					result = FALSE;
					_chess_piece_unref0 (rook);
					_chess_piece_unref0 (victim);
					_chess_piece_unref0 (piece);
					return result;
				}
				_tmp106_ = rook_start;
				_tmp107_ = rook_end;
				_tmp108_ = BIT_BOARD_over_masks[(_tmp106_ * 64) + _tmp107_];
				rook_over_mask = _tmp108_;
				_tmp109_ = rook_over_mask;
				_tmp110_ = self->priv->piece_masks[COLOR_WHITE];
				_tmp111_ = self->priv->piece_masks[COLOR_BLACK];
				if ((_tmp109_ & (_tmp110_ | _tmp111_)) != ((gint64) 0)) {
					result = FALSE;
					_chess_piece_unref0 (rook);
					_chess_piece_unref0 (victim);
					_chess_piece_unref0 (piece);
					return result;
				}
				_tmp112_ = self->check_state;
				if (_tmp112_ == CHECK_STATE_CHECK) {
					result = FALSE;
					_chess_piece_unref0 (rook);
					_chess_piece_unref0 (victim);
					_chess_piece_unref0 (piece);
					return result;
				}
				{
					gint i;
					i = 0;
					{
						gboolean _tmp113_;
						_tmp113_ = TRUE;
						while (TRUE) {
							gboolean _tmp114_;
							gint _tmp116_;
							ChessPlayer* _tmp117_;
							ChessPlayer* _tmp118_;
							gint _tmp119_;
							gint _tmp120_ = 0;
							gint _tmp121_;
							gint _tmp122_ = 0;
							gint _tmp123_;
							gint _tmp124_ = 0;
							gint _tmp125_;
							gint _tmp126_ = 0;
							gboolean _tmp127_ = FALSE;
							_tmp114_ = _tmp113_;
							if (!_tmp114_) {
								gint _tmp115_;
								_tmp115_ = i;
								i = _tmp115_ + 1;
							}
							_tmp113_ = FALSE;
							_tmp116_ = i;
							if (!(_tmp116_ < 64)) {
								break;
							}
							_tmp117_ = chess_state_get_opponent (self);
							_tmp118_ = _tmp117_;
							_tmp119_ = i;
							_tmp120_ = chess_state_get_rank (self, _tmp119_);
							_tmp121_ = i;
							_tmp122_ = chess_state_get_file (self, _tmp121_);
							_tmp123_ = rook_end;
							_tmp124_ = chess_state_get_rank (self, _tmp123_);
							_tmp125_ = rook_end;
							_tmp126_ = chess_state_get_file (self, _tmp125_);
							_tmp127_ = chess_state_move_with_coords (self, _tmp118_, _tmp120_, _tmp122_, _tmp124_, _tmp126_, PIECE_TYPE_QUEEN, FALSE, FALSE);
							if (_tmp127_) {
								result = FALSE;
								_chess_piece_unref0 (rook);
								_chess_piece_unref0 (victim);
								_chess_piece_unref0 (piece);
								return result;
							}
						}
					}
				}
				_chess_piece_unref0 (rook);
			}
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp129_ = apply;
	if (!_tmp129_) {
		gboolean _tmp130_;
		_tmp130_ = test_check;
		_tmp128_ = !_tmp130_;
	} else {
		_tmp128_ = FALSE;
	}
	_tmp131_ = _tmp128_;
	if (_tmp131_) {
		result = TRUE;
		_chess_piece_unref0 (victim);
		_chess_piece_unref0 (piece);
		return result;
	}
	_tmp132_ = apply;
	if (_tmp132_) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp133_;
				_tmp133_ = TRUE;
				while (TRUE) {
					gboolean _tmp134_;
					gint _tmp136_;
					gint _tmp137_;
					gint _tmp138_;
					gint _tmp139_;
					ChessPiece* _tmp140_;
					ChessPiece* _tmp141_;
					ChessPiece* p;
					gboolean _tmp142_ = FALSE;
					gboolean _tmp143_ = FALSE;
					ChessPiece* _tmp144_;
					gboolean _tmp148_;
					gboolean _tmp153_;
					gint _tmp154_;
					gint _tmp155_ = 0;
					gint r;
					gint _tmp156_;
					gint _tmp157_ = 0;
					gint f;
					ChessPlayer* _tmp158_;
					gint _tmp159_;
					gint _tmp160_;
					gint _tmp161_;
					gint _tmp162_;
					gboolean _tmp163_ = FALSE;
					_tmp134_ = _tmp133_;
					if (!_tmp134_) {
						gint _tmp135_;
						_tmp135_ = i;
						i = _tmp135_ + 1;
					}
					_tmp133_ = FALSE;
					_tmp136_ = i;
					if (!(_tmp136_ < 64)) {
						break;
					}
					_tmp137_ = i;
					_tmp138_ = start;
					if (_tmp137_ == _tmp138_) {
						continue;
					}
					_tmp139_ = i;
					_tmp140_ = self->board[_tmp139_];
					_tmp141_ = _chess_piece_ref0 (_tmp140_);
					p = _tmp141_;
					_tmp144_ = p;
					if (_tmp144_ == NULL) {
						_tmp143_ = TRUE;
					} else {
						ChessPiece* _tmp145_;
						ChessPlayer* _tmp146_;
						ChessPlayer* _tmp147_;
						_tmp145_ = p;
						_tmp146_ = _tmp145_->player;
						_tmp147_ = player;
						_tmp143_ = _tmp146_ != _tmp147_;
					}
					_tmp148_ = _tmp143_;
					if (_tmp148_) {
						_tmp142_ = TRUE;
					} else {
						ChessPiece* _tmp149_;
						PieceType _tmp150_;
						ChessPiece* _tmp151_;
						PieceType _tmp152_;
						_tmp149_ = p;
						_tmp150_ = _tmp149_->type;
						_tmp151_ = piece;
						_tmp152_ = _tmp151_->type;
						_tmp142_ = _tmp150_ != _tmp152_;
					}
					_tmp153_ = _tmp142_;
					if (_tmp153_) {
						_chess_piece_unref0 (p);
						continue;
					}
					_tmp154_ = i;
					_tmp155_ = chess_state_get_rank (self, _tmp154_);
					r = _tmp155_;
					_tmp156_ = i;
					_tmp157_ = chess_state_get_file (self, _tmp156_);
					f = _tmp157_;
					_tmp158_ = player;
					_tmp159_ = r;
					_tmp160_ = f;
					_tmp161_ = r1;
					_tmp162_ = f1;
					_tmp163_ = chess_state_move_with_coords (self, _tmp158_, _tmp159_, _tmp160_, _tmp161_, _tmp162_, PIECE_TYPE_QUEEN, FALSE, TRUE);
					if (_tmp163_) {
						gint _tmp164_;
						gint _tmp165_;
						gint _tmp166_;
						gint _tmp167_;
						_tmp164_ = r;
						_tmp165_ = r0;
						if (_tmp164_ != _tmp165_) {
							ambiguous_rank = TRUE;
						}
						_tmp166_ = f;
						_tmp167_ = f0;
						if (_tmp166_ != _tmp167_) {
							ambiguous_file = TRUE;
						}
					}
					_chess_piece_unref0 (p);
				}
			}
		}
	}
	_tmp168_ = self->priv->piece_masks[COLOR_WHITE];
	old_white_mask = _tmp168_;
	_tmp169_ = self->priv->piece_masks[COLOR_BLACK];
	old_black_mask = _tmp169_;
	_tmp170_ = self->can_castle_kingside[COLOR_WHITE];
	old_white_can_castle_kingside = _tmp170_;
	_tmp171_ = self->can_castle_queenside[COLOR_WHITE];
	old_white_can_castle_queenside = _tmp171_;
	_tmp172_ = self->can_castle_kingside[COLOR_BLACK];
	old_black_can_castle_kingside = _tmp172_;
	_tmp173_ = self->can_castle_queenside[COLOR_BLACK];
	old_black_can_castle_queenside = _tmp173_;
	_tmp174_ = self->en_passant_index;
	old_en_passant_index = _tmp174_;
	_tmp175_ = self->halfmove_clock;
	old_halfmove_clock = _tmp175_;
	_tmp176_ = start;
	_chess_piece_unref0 (self->board[_tmp176_]);
	self->board[_tmp176_] = NULL;
	_tmp177_ = self->board[_tmp176_];
	_tmp178_ = start;
	_tmp179_ = BIT_BOARD_clear_location_masks[_tmp178_];
	self->priv->piece_masks[COLOR_WHITE] &= _tmp179_;
	_tmp180_ = self->priv->piece_masks[COLOR_WHITE];
	_tmp181_ = start;
	_tmp182_ = BIT_BOARD_clear_location_masks[_tmp181_];
	self->priv->piece_masks[COLOR_BLACK] &= _tmp182_;
	_tmp183_ = self->priv->piece_masks[COLOR_BLACK];
	_tmp184_ = victim;
	if (_tmp184_ != NULL) {
		gint _tmp185_;
		ChessPiece* _tmp186_;
		gint _tmp187_;
		gint64 _tmp188_;
		gint64 _tmp189_;
		gint _tmp190_;
		gint64 _tmp191_;
		gint64 _tmp192_;
		_tmp185_ = victim_index;
		_chess_piece_unref0 (self->board[_tmp185_]);
		self->board[_tmp185_] = NULL;
		_tmp186_ = self->board[_tmp185_];
		_tmp187_ = victim_index;
		_tmp188_ = BIT_BOARD_clear_location_masks[_tmp187_];
		self->priv->piece_masks[COLOR_WHITE] &= _tmp188_;
		_tmp189_ = self->priv->piece_masks[COLOR_WHITE];
		_tmp190_ = victim_index;
		_tmp191_ = BIT_BOARD_clear_location_masks[_tmp190_];
		self->priv->piece_masks[COLOR_BLACK] &= _tmp191_;
		_tmp192_ = self->priv->piece_masks[COLOR_BLACK];
	}
	_tmp193_ = is_promotion;
	if (_tmp193_) {
		gint _tmp194_;
		ChessPlayer* _tmp195_;
		PieceType _tmp196_;
		ChessPiece* _tmp197_;
		ChessPiece* _tmp198_;
		_tmp194_ = end;
		_tmp195_ = player;
		_tmp196_ = promotion_type;
		_tmp197_ = chess_piece_new (_tmp195_, _tmp196_);
		_chess_piece_unref0 (self->board[_tmp194_]);
		self->board[_tmp194_] = _tmp197_;
		_tmp198_ = self->board[_tmp194_];
	} else {
		gint _tmp199_;
		ChessPiece* _tmp200_;
		ChessPiece* _tmp201_;
		ChessPiece* _tmp202_;
		_tmp199_ = end;
		_tmp200_ = piece;
		_tmp201_ = _chess_piece_ref0 (_tmp200_);
		_chess_piece_unref0 (self->board[_tmp199_]);
		self->board[_tmp199_] = _tmp201_;
		_tmp202_ = self->board[_tmp199_];
	}
	_tmp203_ = color;
	_tmp204_ = end_mask;
	self->priv->piece_masks[_tmp203_] |= _tmp204_;
	_tmp205_ = self->priv->piece_masks[_tmp203_];
	_tmp206_ = opponent_color;
	_tmp207_ = end;
	_tmp208_ = BIT_BOARD_clear_location_masks[_tmp207_];
	self->priv->piece_masks[_tmp206_] &= _tmp208_;
	_tmp209_ = self->priv->piece_masks[_tmp206_];
	_tmp210_ = rook_start;
	if (_tmp210_ >= 0) {
		gint _tmp211_;
		ChessPiece* _tmp212_;
		ChessPiece* _tmp213_;
		ChessPiece* rook;
		gint _tmp214_;
		ChessPiece* _tmp215_;
		Color _tmp216_;
		gint _tmp217_;
		gint64 _tmp218_;
		gint64 _tmp219_;
		gint _tmp220_;
		ChessPiece* _tmp221_;
		ChessPiece* _tmp222_;
		ChessPiece* _tmp223_;
		Color _tmp224_;
		gint _tmp225_;
		gint64 _tmp226_;
		gint64 _tmp227_;
		_tmp211_ = rook_start;
		_tmp212_ = self->board[_tmp211_];
		_tmp213_ = _chess_piece_ref0 (_tmp212_);
		rook = _tmp213_;
		_tmp214_ = rook_start;
		_chess_piece_unref0 (self->board[_tmp214_]);
		self->board[_tmp214_] = NULL;
		_tmp215_ = self->board[_tmp214_];
		_tmp216_ = color;
		_tmp217_ = rook_start;
		_tmp218_ = BIT_BOARD_clear_location_masks[_tmp217_];
		self->priv->piece_masks[_tmp216_] &= _tmp218_;
		_tmp219_ = self->priv->piece_masks[_tmp216_];
		_tmp220_ = rook_end;
		_tmp221_ = rook;
		_tmp222_ = _chess_piece_ref0 (_tmp221_);
		_chess_piece_unref0 (self->board[_tmp220_]);
		self->board[_tmp220_] = _tmp222_;
		_tmp223_ = self->board[_tmp220_];
		_tmp224_ = color;
		_tmp225_ = rook_end;
		_tmp226_ = BIT_BOARD_set_location_masks[_tmp225_];
		self->priv->piece_masks[_tmp224_] |= _tmp226_;
		_tmp227_ = self->priv->piece_masks[_tmp224_];
		_chess_piece_unref0 (rook);
	}
	_tmp228_ = piece;
	_tmp229_ = _tmp228_->type;
	if (_tmp229_ == PIECE_TYPE_KING) {
		Color _tmp230_;
		gboolean _tmp231_;
		Color _tmp232_;
		gboolean _tmp233_;
		_tmp230_ = color;
		self->can_castle_kingside[_tmp230_] = FALSE;
		_tmp231_ = self->can_castle_kingside[_tmp230_];
		_tmp232_ = color;
		self->can_castle_queenside[_tmp232_] = FALSE;
		_tmp233_ = self->can_castle_queenside[_tmp232_];
	} else {
		ChessPiece* _tmp234_;
		PieceType _tmp235_;
		_tmp234_ = piece;
		_tmp235_ = _tmp234_->type;
		if (_tmp235_ == PIECE_TYPE_ROOK) {
			gint _tmp236_ = 0;
			Color _tmp237_;
			gint _tmp238_;
			gint base_rank;
			gint _tmp239_;
			gint _tmp240_;
			_tmp237_ = color;
			if (_tmp237_ == COLOR_WHITE) {
				_tmp236_ = 0;
			} else {
				_tmp236_ = 7;
			}
			_tmp238_ = _tmp236_;
			base_rank = _tmp238_;
			_tmp239_ = r0;
			_tmp240_ = base_rank;
			if (_tmp239_ == _tmp240_) {
				gint _tmp241_;
				_tmp241_ = f0;
				if (_tmp241_ == 0) {
					Color _tmp242_;
					gboolean _tmp243_;
					_tmp242_ = color;
					self->can_castle_queenside[_tmp242_] = FALSE;
					_tmp243_ = self->can_castle_queenside[_tmp242_];
				} else {
					gint _tmp244_;
					_tmp244_ = f0;
					if (_tmp244_ == 7) {
						Color _tmp245_;
						gboolean _tmp246_;
						_tmp245_ = color;
						self->can_castle_kingside[_tmp245_] = FALSE;
						_tmp246_ = self->can_castle_kingside[_tmp245_];
					}
				}
			}
		} else {
			gboolean _tmp247_ = FALSE;
			ChessPiece* _tmp248_;
			gboolean _tmp251_;
			_tmp248_ = victim;
			if (_tmp248_ != NULL) {
				ChessPiece* _tmp249_;
				PieceType _tmp250_;
				_tmp249_ = victim;
				_tmp250_ = _tmp249_->type;
				_tmp247_ = _tmp250_ == PIECE_TYPE_ROOK;
			} else {
				_tmp247_ = FALSE;
			}
			_tmp251_ = _tmp247_;
			if (_tmp251_) {
				gint _tmp252_ = 0;
				Color _tmp253_;
				gint _tmp254_;
				gint base_rank;
				gint _tmp255_;
				gint _tmp256_;
				_tmp253_ = opponent_color;
				if (_tmp253_ == COLOR_WHITE) {
					_tmp252_ = 0;
				} else {
					_tmp252_ = 7;
				}
				_tmp254_ = _tmp252_;
				base_rank = _tmp254_;
				_tmp255_ = r1;
				_tmp256_ = base_rank;
				if (_tmp255_ == _tmp256_) {
					gint _tmp257_;
					_tmp257_ = f1;
					if (_tmp257_ == 0) {
						Color _tmp258_;
						gboolean _tmp259_;
						_tmp258_ = opponent_color;
						self->can_castle_queenside[_tmp258_] = FALSE;
						_tmp259_ = self->can_castle_queenside[_tmp258_];
					} else {
						gint _tmp260_;
						_tmp260_ = f1;
						if (_tmp260_ == 7) {
							Color _tmp261_;
							gboolean _tmp262_;
							_tmp261_ = opponent_color;
							self->can_castle_kingside[_tmp261_] = FALSE;
							_tmp262_ = self->can_castle_kingside[_tmp261_];
						}
					}
				}
			}
		}
	}
	_tmp264_ = piece;
	_tmp265_ = _tmp264_->type;
	if (_tmp265_ == PIECE_TYPE_PAWN) {
		gint64 _tmp266_;
		_tmp266_ = over_mask;
		_tmp263_ = _tmp266_ != ((gint64) 0);
	} else {
		_tmp263_ = FALSE;
	}
	_tmp267_ = _tmp263_;
	if (_tmp267_) {
		gint _tmp268_;
		gint _tmp269_;
		gint _tmp270_;
		gint _tmp271_ = 0;
		_tmp268_ = r0;
		_tmp269_ = r1;
		_tmp270_ = f0;
		_tmp271_ = chess_state_get_index (self, (_tmp268_ + _tmp269_) / 2, _tmp270_);
		self->en_passant_index = _tmp271_;
	} else {
		self->en_passant_index = -1;
	}
	_tmp273_ = piece;
	_tmp274_ = _tmp273_->type;
	if (_tmp274_ == PIECE_TYPE_PAWN) {
		_tmp272_ = TRUE;
	} else {
		ChessPiece* _tmp275_;
		_tmp275_ = victim;
		_tmp272_ = _tmp275_ != NULL;
	}
	_tmp276_ = _tmp272_;
	if (_tmp276_) {
		self->halfmove_clock = 0;
	} else {
		gint _tmp277_;
		_tmp277_ = self->halfmove_clock;
		self->halfmove_clock = _tmp277_ + 1;
	}
	_result_ = TRUE;
	_tmp279_ = test_check;
	if (_tmp279_) {
		ChessPlayer* _tmp280_;
		gboolean _tmp281_ = FALSE;
		_tmp280_ = player;
		_tmp281_ = chess_state_is_in_check (self, _tmp280_);
		_tmp278_ = _tmp281_;
	} else {
		_tmp278_ = FALSE;
	}
	_tmp282_ = _tmp278_;
	if (_tmp282_) {
		_result_ = FALSE;
	}
	_tmp284_ = apply;
	if (!_tmp284_) {
		_tmp283_ = TRUE;
	} else {
		gboolean _tmp285_;
		_tmp285_ = _result_;
		_tmp283_ = !_tmp285_;
	}
	_tmp286_ = _tmp283_;
	if (_tmp286_) {
		gint _tmp287_;
		ChessPiece* _tmp288_;
		ChessPiece* _tmp289_;
		ChessPiece* _tmp290_;
		gint _tmp291_;
		ChessPiece* _tmp292_;
		ChessPiece* _tmp293_;
		gint _tmp298_;
		gint64 _tmp308_;
		gint64 _tmp309_;
		gint64 _tmp310_;
		gint64 _tmp311_;
		gboolean _tmp312_;
		gboolean _tmp313_;
		gboolean _tmp314_;
		gboolean _tmp315_;
		gboolean _tmp316_;
		gboolean _tmp317_;
		gboolean _tmp318_;
		gboolean _tmp319_;
		gint _tmp320_;
		gint _tmp321_;
		_tmp287_ = start;
		_tmp288_ = piece;
		_tmp289_ = _chess_piece_ref0 (_tmp288_);
		_chess_piece_unref0 (self->board[_tmp287_]);
		self->board[_tmp287_] = _tmp289_;
		_tmp290_ = self->board[_tmp287_];
		_tmp291_ = end;
		_chess_piece_unref0 (self->board[_tmp291_]);
		self->board[_tmp291_] = NULL;
		_tmp292_ = self->board[_tmp291_];
		_tmp293_ = victim;
		if (_tmp293_ != NULL) {
			gint _tmp294_;
			ChessPiece* _tmp295_;
			ChessPiece* _tmp296_;
			ChessPiece* _tmp297_;
			_tmp294_ = victim_index;
			_tmp295_ = victim;
			_tmp296_ = _chess_piece_ref0 (_tmp295_);
			_chess_piece_unref0 (self->board[_tmp294_]);
			self->board[_tmp294_] = _tmp296_;
			_tmp297_ = self->board[_tmp294_];
		}
		_tmp298_ = rook_start;
		if (_tmp298_ >= 0) {
			gint _tmp299_;
			ChessPiece* _tmp300_;
			ChessPiece* _tmp301_;
			ChessPiece* rook;
			gint _tmp302_;
			ChessPiece* _tmp303_;
			ChessPiece* _tmp304_;
			ChessPiece* _tmp305_;
			gint _tmp306_;
			ChessPiece* _tmp307_;
			_tmp299_ = rook_end;
			_tmp300_ = self->board[_tmp299_];
			_tmp301_ = _chess_piece_ref0 (_tmp300_);
			rook = _tmp301_;
			_tmp302_ = rook_start;
			_tmp303_ = rook;
			_tmp304_ = _chess_piece_ref0 (_tmp303_);
			_chess_piece_unref0 (self->board[_tmp302_]);
			self->board[_tmp302_] = _tmp304_;
			_tmp305_ = self->board[_tmp302_];
			_tmp306_ = rook_end;
			_chess_piece_unref0 (self->board[_tmp306_]);
			self->board[_tmp306_] = NULL;
			_tmp307_ = self->board[_tmp306_];
			_chess_piece_unref0 (rook);
		}
		_tmp308_ = old_white_mask;
		self->priv->piece_masks[COLOR_WHITE] = _tmp308_;
		_tmp309_ = self->priv->piece_masks[COLOR_WHITE];
		_tmp310_ = old_black_mask;
		self->priv->piece_masks[COLOR_BLACK] = _tmp310_;
		_tmp311_ = self->priv->piece_masks[COLOR_BLACK];
		_tmp312_ = old_white_can_castle_kingside;
		self->can_castle_kingside[COLOR_WHITE] = _tmp312_;
		_tmp313_ = self->can_castle_kingside[COLOR_WHITE];
		_tmp314_ = old_white_can_castle_queenside;
		self->can_castle_queenside[COLOR_WHITE] = _tmp314_;
		_tmp315_ = self->can_castle_queenside[COLOR_WHITE];
		_tmp316_ = old_black_can_castle_kingside;
		self->can_castle_kingside[COLOR_BLACK] = _tmp316_;
		_tmp317_ = self->can_castle_kingside[COLOR_BLACK];
		_tmp318_ = old_black_can_castle_queenside;
		self->can_castle_queenside[COLOR_BLACK] = _tmp318_;
		_tmp319_ = self->can_castle_queenside[COLOR_BLACK];
		_tmp320_ = old_en_passant_index;
		self->en_passant_index = _tmp320_;
		_tmp321_ = old_halfmove_clock;
		self->halfmove_clock = _tmp321_;
		result = _result_;
		_chess_piece_unref0 (victim);
		_chess_piece_unref0 (piece);
		return result;
	}
	_tmp323_ = color;
	if (_tmp323_ == COLOR_WHITE) {
		ChessPlayer* _tmp324_;
		_tmp324_ = self->players[COLOR_BLACK];
		_tmp322_ = _tmp324_;
	} else {
		ChessPlayer* _tmp325_;
		_tmp325_ = self->players[COLOR_WHITE];
		_tmp322_ = _tmp325_;
	}
	_tmp326_ = _tmp322_;
	_tmp327_ = _g_object_ref0 (_tmp326_);
	_g_object_unref0 (self->current_player);
	self->current_player = _tmp327_;
	_tmp328_ = self->current_player;
	_tmp329_ = chess_state_get_check_state (self, _tmp328_);
	self->check_state = _tmp329_;
	_tmp330_ = chess_move_new ();
	_chess_move_unref0 (self->last_move);
	self->last_move = _tmp330_;
	_tmp331_ = self->last_move;
	_tmp332_ = self->number;
	_tmp331_->number = _tmp332_;
	_tmp333_ = self->last_move;
	_tmp334_ = piece;
	_tmp335_ = _chess_piece_ref0 (_tmp334_);
	_chess_piece_unref0 (_tmp333_->piece);
	_tmp333_->piece = _tmp335_;
	_tmp336_ = is_promotion;
	if (_tmp336_) {
		ChessMove* _tmp337_;
		gint _tmp338_;
		ChessPiece* _tmp339_;
		ChessPiece* _tmp340_;
		_tmp337_ = self->last_move;
		_tmp338_ = end;
		_tmp339_ = self->board[_tmp338_];
		_tmp340_ = _chess_piece_ref0 (_tmp339_);
		_chess_piece_unref0 (_tmp337_->promotion_piece);
		_tmp337_->promotion_piece = _tmp340_;
	}
	_tmp341_ = self->last_move;
	_tmp342_ = victim;
	_tmp343_ = _chess_piece_ref0 (_tmp342_);
	_chess_piece_unref0 (_tmp341_->victim);
	_tmp341_->victim = _tmp343_;
	_tmp344_ = rook_end;
	if (_tmp344_ >= 0) {
		ChessMove* _tmp345_;
		gint _tmp346_;
		ChessPiece* _tmp347_;
		ChessPiece* _tmp348_;
		_tmp345_ = self->last_move;
		_tmp346_ = rook_end;
		_tmp347_ = self->board[_tmp346_];
		_tmp348_ = _chess_piece_ref0 (_tmp347_);
		_chess_piece_unref0 (_tmp345_->moved_rook);
		_tmp345_->moved_rook = _tmp348_;
	}
	_tmp349_ = self->last_move;
	_tmp350_ = r0;
	_tmp349_->r0 = _tmp350_;
	_tmp351_ = self->last_move;
	_tmp352_ = f0;
	_tmp351_->f0 = _tmp352_;
	_tmp353_ = self->last_move;
	_tmp354_ = r1;
	_tmp353_->r1 = _tmp354_;
	_tmp355_ = self->last_move;
	_tmp356_ = f1;
	_tmp355_->f1 = _tmp356_;
	_tmp357_ = self->last_move;
	_tmp358_ = ambiguous_rank;
	_tmp357_->ambiguous_rank = _tmp358_;
	_tmp359_ = self->last_move;
	_tmp360_ = ambiguous_file;
	_tmp359_->ambiguous_file = _tmp360_;
	_tmp361_ = self->last_move;
	_tmp362_ = self->check_state;
	_tmp361_->check_state = _tmp362_;
	result = TRUE;
	_chess_piece_unref0 (victim);
	_chess_piece_unref0 (piece);
	return result;
}


ChessResult chess_state_get_result (ChessState* self, ChessRule* rule) {
	ChessRule _vala_rule = 0;
	ChessResult result = 0;
	CheckState _tmp0_;
	ChessPlayer* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	ChessMove* _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp12_;
	g_return_val_if_fail (self != NULL, 0);
	_vala_rule = CHESS_RULE_CHECKMATE;
	_tmp0_ = self->check_state;
	if (_tmp0_ == CHECK_STATE_CHECKMATE) {
		ChessPlayer* _tmp1_;
		Color _tmp2_;
		_tmp1_ = self->current_player;
		_tmp2_ = _tmp1_->color;
		if (_tmp2_ == COLOR_WHITE) {
			_vala_rule = CHESS_RULE_CHECKMATE;
			result = CHESS_RESULT_BLACK_WON;
			if (rule) {
				*rule = _vala_rule;
			}
			return result;
		} else {
			_vala_rule = CHESS_RULE_CHECKMATE;
			result = CHESS_RESULT_WHITE_WON;
			if (rule) {
				*rule = _vala_rule;
			}
			return result;
		}
	}
	_tmp3_ = self->current_player;
	_tmp4_ = chess_state_can_move (self, _tmp3_);
	if (!_tmp4_) {
		_vala_rule = CHESS_RULE_STALEMATE;
		result = CHESS_RESULT_DRAW;
		if (rule) {
			*rule = _vala_rule;
		}
		return result;
	}
	_tmp7_ = self->last_move;
	if (_tmp7_ != NULL) {
		ChessMove* _tmp8_;
		ChessPiece* _tmp9_;
		_tmp8_ = self->last_move;
		_tmp9_ = _tmp8_->victim;
		_tmp6_ = _tmp9_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp10_ = _tmp6_;
	if (_tmp10_) {
		gboolean _tmp11_ = FALSE;
		_tmp11_ = chess_state_have_sufficient_material (self);
		_tmp5_ = !_tmp11_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp12_ = _tmp5_;
	if (_tmp12_) {
		_vala_rule = CHESS_RULE_INSUFFICIENT_MATERIAL;
		result = CHESS_RESULT_DRAW;
		if (rule) {
			*rule = _vala_rule;
		}
		return result;
	}
	result = CHESS_RESULT_IN_PROGRESS;
	if (rule) {
		*rule = _vala_rule;
	}
	return result;
}


static CheckState chess_state_get_check_state (ChessState* self, ChessPlayer* player) {
	CheckState result = 0;
	ChessPlayer* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (player != NULL, 0);
	_tmp0_ = player;
	_tmp1_ = chess_state_is_in_check (self, _tmp0_);
	if (_tmp1_) {
		ChessPlayer* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = player;
		_tmp3_ = chess_state_is_in_checkmate (self, _tmp2_);
		if (_tmp3_) {
			result = CHECK_STATE_CHECKMATE;
			return result;
		} else {
			result = CHECK_STATE_CHECK;
			return result;
		}
	}
	result = CHECK_STATE_NONE;
	return result;
}


static gboolean chess_state_is_in_check (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_;
	Color _tmp2_;
	ChessPlayer* _tmp5_;
	ChessPlayer* _tmp6_;
	ChessPlayer* opponent;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp1_ = player;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		ChessPlayer* _tmp3_;
		_tmp3_ = self->players[COLOR_BLACK];
		_tmp0_ = _tmp3_;
	} else {
		ChessPlayer* _tmp4_;
		_tmp4_ = self->players[COLOR_WHITE];
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	opponent = _tmp6_;
	{
		gint king_index;
		king_index = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				gint _tmp11_;
				ChessPiece* _tmp12_;
				ChessPiece* _tmp13_;
				ChessPiece* p;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_ = FALSE;
				ChessPiece* _tmp16_;
				gboolean _tmp20_;
				gboolean _tmp23_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = king_index;
					king_index = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = king_index;
				if (!(_tmp10_ < 64)) {
					break;
				}
				_tmp11_ = king_index;
				_tmp12_ = self->board[_tmp11_];
				_tmp13_ = _chess_piece_ref0 (_tmp12_);
				p = _tmp13_;
				_tmp16_ = p;
				if (_tmp16_ != NULL) {
					ChessPiece* _tmp17_;
					ChessPlayer* _tmp18_;
					ChessPlayer* _tmp19_;
					_tmp17_ = p;
					_tmp18_ = _tmp17_->player;
					_tmp19_ = player;
					_tmp15_ = _tmp18_ == _tmp19_;
				} else {
					_tmp15_ = FALSE;
				}
				_tmp20_ = _tmp15_;
				if (_tmp20_) {
					ChessPiece* _tmp21_;
					PieceType _tmp22_;
					_tmp21_ = p;
					_tmp22_ = _tmp21_->type;
					_tmp14_ = _tmp22_ == PIECE_TYPE_KING;
				} else {
					_tmp14_ = FALSE;
				}
				_tmp23_ = _tmp14_;
				if (_tmp23_) {
					{
						gint start;
						start = 0;
						{
							gboolean _tmp24_;
							_tmp24_ = TRUE;
							while (TRUE) {
								gboolean _tmp25_;
								gint _tmp27_;
								ChessPlayer* _tmp28_;
								gint _tmp29_;
								gint _tmp30_ = 0;
								gint _tmp31_;
								gint _tmp32_ = 0;
								gint _tmp33_;
								gint _tmp34_ = 0;
								gint _tmp35_;
								gint _tmp36_ = 0;
								gboolean _tmp37_ = FALSE;
								_tmp25_ = _tmp24_;
								if (!_tmp25_) {
									gint _tmp26_;
									_tmp26_ = start;
									start = _tmp26_ + 1;
								}
								_tmp24_ = FALSE;
								_tmp27_ = start;
								if (!(_tmp27_ < 64)) {
									break;
								}
								_tmp28_ = opponent;
								_tmp29_ = start;
								_tmp30_ = chess_state_get_rank (self, _tmp29_);
								_tmp31_ = start;
								_tmp32_ = chess_state_get_file (self, _tmp31_);
								_tmp33_ = king_index;
								_tmp34_ = chess_state_get_rank (self, _tmp33_);
								_tmp35_ = king_index;
								_tmp36_ = chess_state_get_file (self, _tmp35_);
								_tmp37_ = chess_state_move_with_coords (self, _tmp28_, _tmp30_, _tmp32_, _tmp34_, _tmp36_, PIECE_TYPE_QUEEN, FALSE, FALSE);
								if (_tmp37_) {
									result = TRUE;
									_chess_piece_unref0 (p);
									_g_object_unref0 (opponent);
									return result;
								}
							}
						}
					}
				}
				_chess_piece_unref0 (p);
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (opponent);
	return result;
}


static gboolean chess_state_is_in_checkmate (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	{
		gint piece_index;
		piece_index = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				ChessPiece* _tmp5_;
				ChessPiece* _tmp6_;
				ChessPiece* p;
				gboolean _tmp7_ = FALSE;
				ChessPiece* _tmp8_;
				gboolean _tmp12_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = piece_index;
					piece_index = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = piece_index;
				if (!(_tmp3_ < 64)) {
					break;
				}
				_tmp4_ = piece_index;
				_tmp5_ = self->board[_tmp4_];
				_tmp6_ = _chess_piece_ref0 (_tmp5_);
				p = _tmp6_;
				_tmp8_ = p;
				if (_tmp8_ != NULL) {
					ChessPiece* _tmp9_;
					ChessPlayer* _tmp10_;
					ChessPlayer* _tmp11_;
					_tmp9_ = p;
					_tmp10_ = _tmp9_->player;
					_tmp11_ = player;
					_tmp7_ = _tmp10_ == _tmp11_;
				} else {
					_tmp7_ = FALSE;
				}
				_tmp12_ = _tmp7_;
				if (_tmp12_) {
					{
						gint end;
						end = 0;
						{
							gboolean _tmp13_;
							_tmp13_ = TRUE;
							while (TRUE) {
								gboolean _tmp14_;
								gint _tmp16_;
								ChessPlayer* _tmp17_;
								gint _tmp18_;
								gint _tmp19_ = 0;
								gint _tmp20_;
								gint _tmp21_ = 0;
								gint _tmp22_;
								gint _tmp23_ = 0;
								gint _tmp24_;
								gint _tmp25_ = 0;
								gboolean _tmp26_ = FALSE;
								_tmp14_ = _tmp13_;
								if (!_tmp14_) {
									gint _tmp15_;
									_tmp15_ = end;
									end = _tmp15_ + 1;
								}
								_tmp13_ = FALSE;
								_tmp16_ = end;
								if (!(_tmp16_ < 64)) {
									break;
								}
								_tmp17_ = player;
								_tmp18_ = piece_index;
								_tmp19_ = chess_state_get_rank (self, _tmp18_);
								_tmp20_ = piece_index;
								_tmp21_ = chess_state_get_file (self, _tmp20_);
								_tmp22_ = end;
								_tmp23_ = chess_state_get_rank (self, _tmp22_);
								_tmp24_ = end;
								_tmp25_ = chess_state_get_file (self, _tmp24_);
								_tmp26_ = chess_state_move_with_coords (self, _tmp17_, _tmp19_, _tmp21_, _tmp23_, _tmp25_, PIECE_TYPE_QUEEN, FALSE, TRUE);
								if (_tmp26_) {
									result = FALSE;
									_chess_piece_unref0 (p);
									return result;
								}
							}
						}
					}
				}
				_chess_piece_unref0 (p);
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean chess_state_can_move (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean have_pieces;
	gboolean _tmp27_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	have_pieces = FALSE;
	{
		gint start;
		start = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				ChessPiece* _tmp5_;
				ChessPiece* _tmp6_;
				ChessPiece* p;
				gboolean _tmp7_ = FALSE;
				ChessPiece* _tmp8_;
				gboolean _tmp12_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = start;
					start = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = start;
				if (!(_tmp3_ < 64)) {
					break;
				}
				_tmp4_ = start;
				_tmp5_ = self->board[_tmp4_];
				_tmp6_ = _chess_piece_ref0 (_tmp5_);
				p = _tmp6_;
				_tmp8_ = p;
				if (_tmp8_ != NULL) {
					ChessPiece* _tmp9_;
					ChessPlayer* _tmp10_;
					ChessPlayer* _tmp11_;
					_tmp9_ = p;
					_tmp10_ = _tmp9_->player;
					_tmp11_ = player;
					_tmp7_ = _tmp10_ == _tmp11_;
				} else {
					_tmp7_ = FALSE;
				}
				_tmp12_ = _tmp7_;
				if (_tmp12_) {
					have_pieces = TRUE;
					{
						gint end;
						end = 0;
						{
							gboolean _tmp13_;
							_tmp13_ = TRUE;
							while (TRUE) {
								gboolean _tmp14_;
								gint _tmp16_;
								ChessPlayer* _tmp17_;
								gint _tmp18_;
								gint _tmp19_ = 0;
								gint _tmp20_;
								gint _tmp21_ = 0;
								gint _tmp22_;
								gint _tmp23_ = 0;
								gint _tmp24_;
								gint _tmp25_ = 0;
								gboolean _tmp26_ = FALSE;
								_tmp14_ = _tmp13_;
								if (!_tmp14_) {
									gint _tmp15_;
									_tmp15_ = end;
									end = _tmp15_ + 1;
								}
								_tmp13_ = FALSE;
								_tmp16_ = end;
								if (!(_tmp16_ < 64)) {
									break;
								}
								_tmp17_ = player;
								_tmp18_ = start;
								_tmp19_ = chess_state_get_rank (self, _tmp18_);
								_tmp20_ = start;
								_tmp21_ = chess_state_get_file (self, _tmp20_);
								_tmp22_ = end;
								_tmp23_ = chess_state_get_rank (self, _tmp22_);
								_tmp24_ = end;
								_tmp25_ = chess_state_get_file (self, _tmp24_);
								_tmp26_ = chess_state_move_with_coords (self, _tmp17_, _tmp19_, _tmp21_, _tmp23_, _tmp25_, PIECE_TYPE_QUEEN, FALSE, TRUE);
								if (_tmp26_) {
									result = TRUE;
									_chess_piece_unref0 (p);
									return result;
								}
							}
						}
					}
				}
				_chess_piece_unref0 (p);
			}
		}
	}
	_tmp27_ = have_pieces;
	if (_tmp27_) {
		result = FALSE;
		return result;
	} else {
		result = TRUE;
		return result;
	}
}


gboolean chess_state_have_sufficient_material (ChessState* self) {
	gboolean result = FALSE;
	gint white_knight_count;
	gint white_bishop_count;
	gboolean white_bishop_on_white_square;
	gboolean white_bishop_on_black_square;
	gint black_knight_count;
	gint black_bishop_count;
	gboolean black_bishop_on_white_square;
	gboolean black_bishop_on_black_square;
	g_return_val_if_fail (self != NULL, FALSE);
	white_knight_count = 0;
	white_bishop_count = 0;
	white_bishop_on_white_square = FALSE;
	white_bishop_on_black_square = FALSE;
	black_knight_count = 0;
	black_bishop_count = 0;
	black_bishop_on_white_square = FALSE;
	black_bishop_on_black_square = FALSE;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				ChessPiece* _tmp5_;
				ChessPiece* _tmp6_;
				ChessPiece* p;
				ChessPiece* _tmp7_;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				ChessPiece* _tmp10_;
				PieceType _tmp11_;
				gboolean _tmp14_;
				gboolean _tmp17_;
				ChessPiece* _tmp18_;
				PieceType _tmp19_;
				ChessPiece* _tmp25_;
				PieceType _tmp26_;
				gboolean _tmp36_ = FALSE;
				gint _tmp37_;
				gboolean _tmp39_;
				gboolean _tmp40_ = FALSE;
				gint _tmp41_;
				gboolean _tmp43_;
				gboolean _tmp44_ = FALSE;
				gint _tmp45_;
				gboolean _tmp47_;
				gboolean _tmp48_ = FALSE;
				gboolean _tmp49_;
				gboolean _tmp51_;
				gboolean _tmp52_ = FALSE;
				gboolean _tmp53_;
				gboolean _tmp55_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				if (!(_tmp3_ < 64)) {
					break;
				}
				_tmp4_ = i;
				_tmp5_ = self->board[_tmp4_];
				_tmp6_ = _chess_piece_ref0 (_tmp5_);
				p = _tmp6_;
				_tmp7_ = p;
				if (_tmp7_ == NULL) {
					_chess_piece_unref0 (p);
					continue;
				}
				_tmp10_ = p;
				_tmp11_ = _tmp10_->type;
				if (_tmp11_ == PIECE_TYPE_PAWN) {
					_tmp9_ = TRUE;
				} else {
					ChessPiece* _tmp12_;
					PieceType _tmp13_;
					_tmp12_ = p;
					_tmp13_ = _tmp12_->type;
					_tmp9_ = _tmp13_ == PIECE_TYPE_ROOK;
				}
				_tmp14_ = _tmp9_;
				if (_tmp14_) {
					_tmp8_ = TRUE;
				} else {
					ChessPiece* _tmp15_;
					PieceType _tmp16_;
					_tmp15_ = p;
					_tmp16_ = _tmp15_->type;
					_tmp8_ = _tmp16_ == PIECE_TYPE_QUEEN;
				}
				_tmp17_ = _tmp8_;
				if (_tmp17_) {
					result = TRUE;
					_chess_piece_unref0 (p);
					return result;
				}
				_tmp18_ = p;
				_tmp19_ = _tmp18_->type;
				if (_tmp19_ == PIECE_TYPE_KNIGHT) {
					ChessPiece* _tmp20_;
					Color _tmp21_;
					Color _tmp22_;
					_tmp20_ = p;
					_tmp21_ = chess_piece_get_color (_tmp20_);
					_tmp22_ = _tmp21_;
					if (_tmp22_ == COLOR_WHITE) {
						gint _tmp23_;
						_tmp23_ = white_knight_count;
						white_knight_count = _tmp23_ + 1;
					} else {
						gint _tmp24_;
						_tmp24_ = black_knight_count;
						black_knight_count = _tmp24_ + 1;
					}
				}
				_tmp25_ = p;
				_tmp26_ = _tmp25_->type;
				if (_tmp26_ == PIECE_TYPE_BISHOP) {
					Color color;
					gint _tmp27_;
					gint _tmp28_;
					ChessPiece* _tmp29_;
					Color _tmp30_;
					Color _tmp31_;
					color = COLOR_BLACK;
					_tmp27_ = i;
					_tmp28_ = i;
					if (((_tmp27_ + (_tmp28_ / 8)) % 2) != 0) {
						color = COLOR_WHITE;
					}
					_tmp29_ = p;
					_tmp30_ = chess_piece_get_color (_tmp29_);
					_tmp31_ = _tmp30_;
					if (_tmp31_ == COLOR_WHITE) {
						Color _tmp32_;
						gint _tmp33_;
						_tmp32_ = color;
						if (_tmp32_ == COLOR_WHITE) {
							white_bishop_on_white_square = TRUE;
						} else {
							white_bishop_on_black_square = TRUE;
						}
						_tmp33_ = white_bishop_count;
						white_bishop_count = _tmp33_ + 1;
					} else {
						Color _tmp34_;
						gint _tmp35_;
						_tmp34_ = color;
						if (_tmp34_ == COLOR_WHITE) {
							black_bishop_on_white_square = TRUE;
						} else {
							black_bishop_on_black_square = TRUE;
						}
						_tmp35_ = black_bishop_count;
						black_bishop_count = _tmp35_ + 1;
					}
				}
				_tmp37_ = white_knight_count;
				if (_tmp37_ > 2) {
					_tmp36_ = TRUE;
				} else {
					gint _tmp38_;
					_tmp38_ = black_knight_count;
					_tmp36_ = _tmp38_ > 2;
				}
				_tmp39_ = _tmp36_;
				if (_tmp39_) {
					result = TRUE;
					_chess_piece_unref0 (p);
					return result;
				}
				_tmp41_ = white_bishop_count;
				if (_tmp41_ > 0) {
					gint _tmp42_;
					_tmp42_ = white_knight_count;
					_tmp40_ = _tmp42_ > 0;
				} else {
					_tmp40_ = FALSE;
				}
				_tmp43_ = _tmp40_;
				if (_tmp43_) {
					result = TRUE;
					_chess_piece_unref0 (p);
					return result;
				}
				_tmp45_ = black_bishop_count;
				if (_tmp45_ > 0) {
					gint _tmp46_;
					_tmp46_ = black_knight_count;
					_tmp44_ = _tmp46_ > 0;
				} else {
					_tmp44_ = FALSE;
				}
				_tmp47_ = _tmp44_;
				if (_tmp47_) {
					result = TRUE;
					_chess_piece_unref0 (p);
					return result;
				}
				_tmp49_ = white_bishop_on_white_square;
				if (_tmp49_) {
					gboolean _tmp50_;
					_tmp50_ = white_bishop_on_black_square;
					_tmp48_ = _tmp50_;
				} else {
					_tmp48_ = FALSE;
				}
				_tmp51_ = _tmp48_;
				if (_tmp51_) {
					result = TRUE;
					_chess_piece_unref0 (p);
					return result;
				}
				_tmp53_ = black_bishop_on_white_square;
				if (_tmp53_) {
					gboolean _tmp54_;
					_tmp54_ = black_bishop_on_black_square;
					_tmp52_ = _tmp54_;
				} else {
					_tmp52_ = FALSE;
				}
				_tmp55_ = _tmp52_;
				if (_tmp55_) {
					result = TRUE;
					_chess_piece_unref0 (p);
					return result;
				}
				_chess_piece_unref0 (p);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean chess_state_decode_piece_type (ChessState* self, gunichar c, PieceType* type) {
	PieceType _vala_type = 0;
	gboolean result = FALSE;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_type = PIECE_TYPE_PAWN;
	_tmp0_ = c;
	switch (_tmp0_) {
		case 'P':
		{
			_vala_type = PIECE_TYPE_PAWN;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		case 'R':
		{
			_vala_type = PIECE_TYPE_ROOK;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		case 'N':
		{
			_vala_type = PIECE_TYPE_KNIGHT;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		case 'B':
		{
			_vala_type = PIECE_TYPE_BISHOP;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		case 'Q':
		{
			_vala_type = PIECE_TYPE_QUEEN;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		case 'K':
		{
			_vala_type = PIECE_TYPE_KING;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		default:
		{
			result = FALSE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
	}
	if (type) {
		*type = _vala_type;
	}
}


static gboolean chess_state_decode_move (ChessState* self, ChessPlayer* player, const gchar* move, gint* r0, gint* f0, gint* r1, gint* f1, PieceType* promotion_type) {
	gint _vala_r0 = 0;
	gint _vala_f0 = 0;
	gint _vala_r1 = 0;
	gint _vala_f1 = 0;
	PieceType _vala_promotion_type = 0;
	gboolean result = FALSE;
	gint i;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp163_;
	gint _tmp164_;
	gchar _tmp165_ = '\0';
	const gchar* _tmp171_;
	gint _tmp172_;
	gchar _tmp173_ = '\0';
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	g_return_val_if_fail (move != NULL, FALSE);
	i = 0;
	_vala_promotion_type = PIECE_TYPE_QUEEN;
	_tmp0_ = move;
	_tmp1_ = g_str_has_prefix (_tmp0_, "O-O-O");
	if (_tmp1_) {
		ChessPlayer* _tmp2_;
		Color _tmp3_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp2_ = player;
		_tmp3_ = _tmp2_->color;
		if (_tmp3_ == COLOR_WHITE) {
			gint _tmp4_;
			_vala_r1 = 0;
			_tmp4_ = _vala_r1;
			_vala_r0 = _tmp4_;
		} else {
			gint _tmp5_;
			_vala_r1 = 7;
			_tmp5_ = _vala_r1;
			_vala_r0 = _tmp5_;
		}
		_vala_f0 = 4;
		_vala_f1 = 2;
		_tmp6_ = i;
		_tmp7_ = strlen ("O-O-O");
		_tmp8_ = _tmp7_;
		i = _tmp6_ + ((gint) _tmp8_);
	} else {
		const gchar* _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = move;
		_tmp10_ = g_str_has_prefix (_tmp9_, "O-O");
		if (_tmp10_) {
			ChessPlayer* _tmp11_;
			Color _tmp12_;
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			_tmp11_ = player;
			_tmp12_ = _tmp11_->color;
			if (_tmp12_ == COLOR_WHITE) {
				gint _tmp13_;
				_vala_r1 = 0;
				_tmp13_ = _vala_r1;
				_vala_r0 = _tmp13_;
			} else {
				gint _tmp14_;
				_vala_r1 = 7;
				_tmp14_ = _vala_r1;
				_vala_r0 = _tmp14_;
			}
			_vala_f0 = 4;
			_vala_f1 = 6;
			_tmp15_ = i;
			_tmp16_ = strlen ("O-O");
			_tmp17_ = _tmp16_;
			i = _tmp15_ + ((gint) _tmp17_);
		} else {
			PieceType type;
			const gchar* _tmp18_;
			gint _tmp19_;
			gchar _tmp20_ = '\0';
			PieceType _tmp21_ = 0;
			gboolean _tmp22_ = FALSE;
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gboolean _tmp27_ = FALSE;
			const gchar* _tmp28_;
			gint _tmp29_;
			gchar _tmp30_ = '\0';
			gboolean _tmp34_;
			gboolean _tmp39_ = FALSE;
			const gchar* _tmp40_;
			gint _tmp41_;
			gchar _tmp42_ = '\0';
			gboolean _tmp46_;
			gboolean _tmp51_ = FALSE;
			const gchar* _tmp52_;
			gint _tmp53_;
			gchar _tmp54_ = '\0';
			gboolean _tmp58_;
			gboolean _tmp60_ = FALSE;
			const gchar* _tmp61_;
			gint _tmp62_;
			gchar _tmp63_ = '\0';
			gboolean _tmp67_;
			gboolean _tmp73_ = FALSE;
			const gchar* _tmp74_;
			gint _tmp75_;
			gchar _tmp76_ = '\0';
			gboolean _tmp80_;
			const gchar* _tmp86_;
			gint _tmp87_;
			gchar _tmp88_ = '\0';
			gboolean _tmp106_ = FALSE;
			gint _tmp107_;
			gboolean _tmp109_;
			gboolean _tmp111_ = FALSE;
			gint _tmp112_;
			gboolean _tmp114_;
			type = PIECE_TYPE_PAWN;
			_tmp18_ = move;
			_tmp19_ = i;
			_tmp20_ = string_get (_tmp18_, (glong) _tmp19_);
			_tmp22_ = chess_state_decode_piece_type (self, (gunichar) _tmp20_, &_tmp21_);
			type = _tmp21_;
			if (_tmp22_) {
				gint _tmp23_;
				_tmp23_ = i;
				i = _tmp23_ + 1;
			}
			_vala_f1 = -1;
			_tmp24_ = _vala_f1;
			_vala_r1 = _tmp24_;
			_tmp25_ = _vala_r1;
			_vala_f0 = _tmp25_;
			_tmp26_ = _vala_f0;
			_vala_r0 = _tmp26_;
			_tmp28_ = move;
			_tmp29_ = i;
			_tmp30_ = string_get (_tmp28_, (glong) _tmp29_);
			if (_tmp30_ >= 'a') {
				const gchar* _tmp31_;
				gint _tmp32_;
				gchar _tmp33_ = '\0';
				_tmp31_ = move;
				_tmp32_ = i;
				_tmp33_ = string_get (_tmp31_, (glong) _tmp32_);
				_tmp27_ = _tmp33_ <= 'h';
			} else {
				_tmp27_ = FALSE;
			}
			_tmp34_ = _tmp27_;
			if (_tmp34_) {
				const gchar* _tmp35_;
				gint _tmp36_;
				gchar _tmp37_ = '\0';
				gint _tmp38_;
				_tmp35_ = move;
				_tmp36_ = i;
				_tmp37_ = string_get (_tmp35_, (glong) _tmp36_);
				_vala_f1 = (gint) (_tmp37_ - 'a');
				_tmp38_ = i;
				i = _tmp38_ + 1;
			}
			_tmp40_ = move;
			_tmp41_ = i;
			_tmp42_ = string_get (_tmp40_, (glong) _tmp41_);
			if (_tmp42_ >= '1') {
				const gchar* _tmp43_;
				gint _tmp44_;
				gchar _tmp45_ = '\0';
				_tmp43_ = move;
				_tmp44_ = i;
				_tmp45_ = string_get (_tmp43_, (glong) _tmp44_);
				_tmp39_ = _tmp45_ <= '8';
			} else {
				_tmp39_ = FALSE;
			}
			_tmp46_ = _tmp39_;
			if (_tmp46_) {
				const gchar* _tmp47_;
				gint _tmp48_;
				gchar _tmp49_ = '\0';
				gint _tmp50_;
				_tmp47_ = move;
				_tmp48_ = i;
				_tmp49_ = string_get (_tmp47_, (glong) _tmp48_);
				_vala_r1 = (gint) (_tmp49_ - '1');
				_tmp50_ = i;
				i = _tmp50_ + 1;
			}
			_tmp52_ = move;
			_tmp53_ = i;
			_tmp54_ = string_get (_tmp52_, (glong) _tmp53_);
			if (_tmp54_ == 'x') {
				_tmp51_ = TRUE;
			} else {
				const gchar* _tmp55_;
				gint _tmp56_;
				gchar _tmp57_ = '\0';
				_tmp55_ = move;
				_tmp56_ = i;
				_tmp57_ = string_get (_tmp55_, (glong) _tmp56_);
				_tmp51_ = _tmp57_ == '-';
			}
			_tmp58_ = _tmp51_;
			if (_tmp58_) {
				gint _tmp59_;
				_tmp59_ = i;
				i = _tmp59_ + 1;
			}
			_tmp61_ = move;
			_tmp62_ = i;
			_tmp63_ = string_get (_tmp61_, (glong) _tmp62_);
			if (_tmp63_ >= 'a') {
				const gchar* _tmp64_;
				gint _tmp65_;
				gchar _tmp66_ = '\0';
				_tmp64_ = move;
				_tmp65_ = i;
				_tmp66_ = string_get (_tmp64_, (glong) _tmp65_);
				_tmp60_ = _tmp66_ <= 'h';
			} else {
				_tmp60_ = FALSE;
			}
			_tmp67_ = _tmp60_;
			if (_tmp67_) {
				gint _tmp68_;
				const gchar* _tmp69_;
				gint _tmp70_;
				gchar _tmp71_ = '\0';
				gint _tmp72_;
				_tmp68_ = _vala_f1;
				_vala_f0 = _tmp68_;
				_tmp69_ = move;
				_tmp70_ = i;
				_tmp71_ = string_get (_tmp69_, (glong) _tmp70_);
				_vala_f1 = (gint) (_tmp71_ - 'a');
				_tmp72_ = i;
				i = _tmp72_ + 1;
			}
			_tmp74_ = move;
			_tmp75_ = i;
			_tmp76_ = string_get (_tmp74_, (glong) _tmp75_);
			if (_tmp76_ >= '1') {
				const gchar* _tmp77_;
				gint _tmp78_;
				gchar _tmp79_ = '\0';
				_tmp77_ = move;
				_tmp78_ = i;
				_tmp79_ = string_get (_tmp77_, (glong) _tmp78_);
				_tmp73_ = _tmp79_ <= '8';
			} else {
				_tmp73_ = FALSE;
			}
			_tmp80_ = _tmp73_;
			if (_tmp80_) {
				gint _tmp81_;
				const gchar* _tmp82_;
				gint _tmp83_;
				gchar _tmp84_ = '\0';
				gint _tmp85_;
				_tmp81_ = _vala_r1;
				_vala_r0 = _tmp81_;
				_tmp82_ = move;
				_tmp83_ = i;
				_tmp84_ = string_get (_tmp82_, (glong) _tmp83_);
				_vala_r1 = (gint) (_tmp84_ - '1');
				_tmp85_ = i;
				i = _tmp85_ + 1;
			}
			_tmp86_ = move;
			_tmp87_ = i;
			_tmp88_ = string_get (_tmp86_, (glong) _tmp87_);
			if (_tmp88_ == '=') {
				gint _tmp89_;
				const gchar* _tmp90_;
				gint _tmp91_;
				gchar _tmp92_ = '\0';
				PieceType _tmp93_ = 0;
				gboolean _tmp94_ = FALSE;
				_tmp89_ = i;
				i = _tmp89_ + 1;
				_tmp90_ = move;
				_tmp91_ = i;
				_tmp92_ = string_get (_tmp90_, (glong) _tmp91_);
				_tmp94_ = chess_state_decode_piece_type (self, (gunichar) _tmp92_, &_tmp93_);
				_vala_promotion_type = _tmp93_;
				if (_tmp94_) {
					gint _tmp95_;
					_tmp95_ = i;
					i = _tmp95_ + 1;
				}
			} else {
				const gchar* _tmp96_;
				gint _tmp97_;
				gchar _tmp98_ = '\0';
				_tmp96_ = move;
				_tmp97_ = i;
				_tmp98_ = string_get (_tmp96_, (glong) _tmp97_);
				if (_tmp98_ != '\0') {
					const gchar* _tmp99_;
					gint _tmp100_;
					gchar _tmp101_ = '\0';
					_tmp99_ = move;
					_tmp100_ = i;
					_tmp101_ = string_get (_tmp99_, (glong) _tmp100_);
					switch (_tmp101_) {
						case 'q':
						{
							gint _tmp102_;
							_vala_promotion_type = PIECE_TYPE_QUEEN;
							_tmp102_ = i;
							i = _tmp102_ + 1;
							break;
						}
						case 'n':
						{
							gint _tmp103_;
							_vala_promotion_type = PIECE_TYPE_KNIGHT;
							_tmp103_ = i;
							i = _tmp103_ + 1;
							break;
						}
						case 'r':
						{
							gint _tmp104_;
							_vala_promotion_type = PIECE_TYPE_ROOK;
							_tmp104_ = i;
							i = _tmp104_ + 1;
							break;
						}
						case 'b':
						{
							gint _tmp105_;
							_vala_promotion_type = PIECE_TYPE_BISHOP;
							_tmp105_ = i;
							i = _tmp105_ + 1;
							break;
						}
						default:
						break;
					}
				}
			}
			_tmp107_ = _vala_r1;
			if (_tmp107_ < 0) {
				_tmp106_ = TRUE;
			} else {
				gint _tmp108_;
				_tmp108_ = _vala_f1;
				_tmp106_ = _tmp108_ < 0;
			}
			_tmp109_ = _tmp106_;
			if (_tmp109_) {
				const gchar* _tmp110_;
				_tmp110_ = move;
				g_debug ("chess-game.vala:1092: Move %s missing destination", _tmp110_);
				result = FALSE;
				if (r0) {
					*r0 = _vala_r0;
				}
				if (f0) {
					*f0 = _vala_f0;
				}
				if (r1) {
					*r1 = _vala_r1;
				}
				if (f1) {
					*f1 = _vala_f1;
				}
				if (promotion_type) {
					*promotion_type = _vala_promotion_type;
				}
				return result;
			}
			_tmp112_ = _vala_r0;
			if (_tmp112_ < 0) {
				_tmp111_ = TRUE;
			} else {
				gint _tmp113_;
				_tmp113_ = _vala_f0;
				_tmp111_ = _tmp113_ < 0;
			}
			_tmp114_ = _tmp111_;
			if (_tmp114_) {
				gint match_rank;
				gint match_file;
				gint _tmp159_;
				gint _tmp161_;
				gint _tmp162_;
				match_rank = -1;
				match_file = -1;
				{
					gint file;
					file = 0;
					{
						gboolean _tmp115_;
						_tmp115_ = TRUE;
						while (TRUE) {
							gboolean _tmp116_;
							gint _tmp118_;
							gboolean _tmp119_ = FALSE;
							gint _tmp120_;
							gboolean _tmp123_;
							_tmp116_ = _tmp115_;
							if (!_tmp116_) {
								gint _tmp117_;
								_tmp117_ = file;
								file = _tmp117_ + 1;
							}
							_tmp115_ = FALSE;
							_tmp118_ = file;
							if (!(_tmp118_ < 8)) {
								break;
							}
							_tmp120_ = _vala_f0;
							if (_tmp120_ >= 0) {
								gint _tmp121_;
								gint _tmp122_;
								_tmp121_ = file;
								_tmp122_ = _vala_f0;
								_tmp119_ = _tmp121_ != _tmp122_;
							} else {
								_tmp119_ = FALSE;
							}
							_tmp123_ = _tmp119_;
							if (_tmp123_) {
								continue;
							}
							{
								gint rank;
								rank = 0;
								{
									gboolean _tmp124_;
									_tmp124_ = TRUE;
									while (TRUE) {
										gboolean _tmp125_;
										gint _tmp127_;
										gboolean _tmp128_ = FALSE;
										gint _tmp129_;
										gboolean _tmp132_;
										gint _tmp133_;
										gint _tmp134_;
										gint _tmp135_ = 0;
										ChessPiece* _tmp136_;
										ChessPiece* _tmp137_;
										ChessPiece* piece;
										gboolean _tmp138_ = FALSE;
										gboolean _tmp139_ = FALSE;
										ChessPiece* _tmp140_;
										gboolean _tmp144_;
										gboolean _tmp148_;
										ChessPlayer* _tmp149_;
										gint _tmp150_;
										gint _tmp151_;
										gint _tmp152_;
										gint _tmp153_;
										gboolean _tmp154_ = FALSE;
										gint _tmp155_;
										gint _tmp157_;
										gint _tmp158_;
										_tmp125_ = _tmp124_;
										if (!_tmp125_) {
											gint _tmp126_;
											_tmp126_ = rank;
											rank = _tmp126_ + 1;
										}
										_tmp124_ = FALSE;
										_tmp127_ = rank;
										if (!(_tmp127_ < 8)) {
											break;
										}
										_tmp129_ = _vala_r0;
										if (_tmp129_ >= 0) {
											gint _tmp130_;
											gint _tmp131_;
											_tmp130_ = rank;
											_tmp131_ = _vala_r0;
											_tmp128_ = _tmp130_ != _tmp131_;
										} else {
											_tmp128_ = FALSE;
										}
										_tmp132_ = _tmp128_;
										if (_tmp132_) {
											continue;
										}
										_tmp133_ = rank;
										_tmp134_ = file;
										_tmp135_ = chess_state_get_index (self, _tmp133_, _tmp134_);
										_tmp136_ = self->board[_tmp135_];
										_tmp137_ = _chess_piece_ref0 (_tmp136_);
										piece = _tmp137_;
										_tmp140_ = piece;
										if (_tmp140_ == NULL) {
											_tmp139_ = TRUE;
										} else {
											ChessPiece* _tmp141_;
											PieceType _tmp142_;
											PieceType _tmp143_;
											_tmp141_ = piece;
											_tmp142_ = _tmp141_->type;
											_tmp143_ = type;
											_tmp139_ = _tmp142_ != _tmp143_;
										}
										_tmp144_ = _tmp139_;
										if (_tmp144_) {
											_tmp138_ = TRUE;
										} else {
											ChessPiece* _tmp145_;
											ChessPlayer* _tmp146_;
											ChessPlayer* _tmp147_;
											_tmp145_ = piece;
											_tmp146_ = _tmp145_->player;
											_tmp147_ = player;
											_tmp138_ = _tmp146_ != _tmp147_;
										}
										_tmp148_ = _tmp138_;
										if (_tmp148_) {
											_chess_piece_unref0 (piece);
											continue;
										}
										_tmp149_ = player;
										_tmp150_ = rank;
										_tmp151_ = file;
										_tmp152_ = _vala_r1;
										_tmp153_ = _vala_f1;
										_tmp154_ = chess_state_move_with_coords (self, _tmp149_, _tmp150_, _tmp151_, _tmp152_, _tmp153_, PIECE_TYPE_QUEEN, FALSE, TRUE);
										if (!_tmp154_) {
											_chess_piece_unref0 (piece);
											continue;
										}
										_tmp155_ = match_rank;
										if (_tmp155_ >= 0) {
											const gchar* _tmp156_;
											_tmp156_ = move;
											g_debug ("chess-game.vala:1123: Move %s is ambiguous", _tmp156_);
											result = FALSE;
											_chess_piece_unref0 (piece);
											if (r0) {
												*r0 = _vala_r0;
											}
											if (f0) {
												*f0 = _vala_f0;
											}
											if (r1) {
												*r1 = _vala_r1;
											}
											if (f1) {
												*f1 = _vala_f1;
											}
											if (promotion_type) {
												*promotion_type = _vala_promotion_type;
											}
											return result;
										}
										_tmp157_ = rank;
										match_rank = _tmp157_;
										_tmp158_ = file;
										match_file = _tmp158_;
										_chess_piece_unref0 (piece);
									}
								}
							}
						}
					}
				}
				_tmp159_ = match_rank;
				if (_tmp159_ < 0) {
					const gchar* _tmp160_;
					_tmp160_ = move;
					g_debug ("chess-game.vala:1134: Move %s has no matches", _tmp160_);
					result = FALSE;
					if (r0) {
						*r0 = _vala_r0;
					}
					if (f0) {
						*f0 = _vala_f0;
					}
					if (r1) {
						*r1 = _vala_r1;
					}
					if (f1) {
						*f1 = _vala_f1;
					}
					if (promotion_type) {
						*promotion_type = _vala_promotion_type;
					}
					return result;
				}
				_tmp161_ = match_rank;
				_vala_r0 = _tmp161_;
				_tmp162_ = match_file;
				_vala_f0 = _tmp162_;
			}
		}
	}
	_tmp163_ = move;
	_tmp164_ = i;
	_tmp165_ = string_get (_tmp163_, (glong) _tmp164_);
	if (_tmp165_ == '+') {
		gint _tmp166_;
		_tmp166_ = i;
		i = _tmp166_ + 1;
	} else {
		const gchar* _tmp167_;
		gint _tmp168_;
		gchar _tmp169_ = '\0';
		_tmp167_ = move;
		_tmp168_ = i;
		_tmp169_ = string_get (_tmp167_, (glong) _tmp168_);
		if (_tmp169_ == '#') {
			gint _tmp170_;
			_tmp170_ = i;
			i = _tmp170_ + 1;
		}
	}
	_tmp171_ = move;
	_tmp172_ = i;
	_tmp173_ = string_get (_tmp171_, (glong) _tmp172_);
	if (_tmp173_ != '\0') {
		const gchar* _tmp174_;
		_tmp174_ = move;
		g_debug ("chess-game.vala:1150: Move %s has unexpected characters", _tmp174_);
		result = FALSE;
		if (r0) {
			*r0 = _vala_r0;
		}
		if (f0) {
			*f0 = _vala_f0;
		}
		if (r1) {
			*r1 = _vala_r1;
		}
		if (f1) {
			*f1 = _vala_f1;
		}
		if (promotion_type) {
			*promotion_type = _vala_promotion_type;
		}
		return result;
	}
	result = TRUE;
	if (r0) {
		*r0 = _vala_r0;
	}
	if (f0) {
		*f0 = _vala_f0;
	}
	if (r1) {
		*r1 = _vala_r1;
	}
	if (f1) {
		*f1 = _vala_f1;
	}
	if (promotion_type) {
		*promotion_type = _vala_promotion_type;
	}
	return result;
}


ChessPlayer* chess_state_get_opponent (ChessState* self) {
	ChessPlayer* result;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_;
	Color _tmp2_;
	ChessPlayer* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->current_player;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		ChessPlayer* _tmp3_;
		_tmp3_ = self->players[COLOR_BLACK];
		_tmp0_ = _tmp3_;
	} else {
		ChessPlayer* _tmp4_;
		_tmp4_ = self->players[COLOR_WHITE];
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	result = _tmp5_;
	return result;
}


static void value_chess_state_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_chess_state_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		chess_state_unref (value->data[0].v_pointer);
	}
}


static void value_chess_state_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = chess_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_chess_state_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_chess_state_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ChessState* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = chess_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_chess_state_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessState** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = chess_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_chess_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_chess_state (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_STATE), NULL);
	return value->data[0].v_pointer;
}


void value_set_chess_state (GValue* value, gpointer v_object) {
	ChessState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		chess_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_state_unref (old);
	}
}


void value_take_chess_state (GValue* value, gpointer v_object) {
	ChessState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_state_unref (old);
	}
}


static void chess_state_class_init (ChessStateClass * klass) {
	chess_state_parent_class = g_type_class_peek_parent (klass);
	CHESS_STATE_CLASS (klass)->finalize = chess_state_finalize;
	g_type_class_add_private (klass, sizeof (ChessStatePrivate));
}


static void chess_state_instance_init (ChessState * self) {
	self->priv = CHESS_STATE_GET_PRIVATE (self);
	self->number = 0;
	self->en_passant_index = -1;
	self->last_move = NULL;
	self->ref_count = 1;
}


static void chess_state_finalize (ChessState* obj) {
	ChessState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_STATE, ChessState);
	_vala_array_destroy (self->players, 2, (GDestroyNotify) g_object_unref);
	_g_object_unref0 (self->current_player);
	_vala_array_destroy (self->board, 64, (GDestroyNotify) chess_piece_unref);
	_chess_move_unref0 (self->last_move);
}


GType chess_state_get_type (void) {
	static volatile gsize chess_state_type_id__volatile = 0;
	if (g_once_init_enter (&chess_state_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_state_init, value_chess_state_free_value, value_chess_state_copy_value, value_chess_state_peek_pointer, "p", value_chess_state_collect_value, "p", value_chess_state_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessState), 0, (GInstanceInitFunc) chess_state_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_state_type_id;
		chess_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessState", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_state_type_id__volatile, chess_state_type_id);
	}
	return chess_state_type_id__volatile;
}


gpointer chess_state_ref (gpointer instance) {
	ChessState* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void chess_state_unref (gpointer instance) {
	ChessState* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CHESS_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType chess_result_get_type (void) {
	static volatile gsize chess_result_type_id__volatile = 0;
	if (g_once_init_enter (&chess_result_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_RESULT_IN_PROGRESS, "CHESS_RESULT_IN_PROGRESS", "in-progress"}, {CHESS_RESULT_WHITE_WON, "CHESS_RESULT_WHITE_WON", "white-won"}, {CHESS_RESULT_BLACK_WON, "CHESS_RESULT_BLACK_WON", "black-won"}, {CHESS_RESULT_DRAW, "CHESS_RESULT_DRAW", "draw"}, {0, NULL, NULL}};
		GType chess_result_type_id;
		chess_result_type_id = g_enum_register_static ("ChessResult", values);
		g_once_init_leave (&chess_result_type_id__volatile, chess_result_type_id);
	}
	return chess_result_type_id__volatile;
}


GType chess_rule_get_type (void) {
	static volatile gsize chess_rule_type_id__volatile = 0;
	if (g_once_init_enter (&chess_rule_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_RULE_CHECKMATE, "CHESS_RULE_CHECKMATE", "checkmate"}, {CHESS_RULE_STALEMATE, "CHESS_RULE_STALEMATE", "stalemate"}, {CHESS_RULE_FIFTY_MOVES, "CHESS_RULE_FIFTY_MOVES", "fifty-moves"}, {CHESS_RULE_TIMEOUT, "CHESS_RULE_TIMEOUT", "timeout"}, {CHESS_RULE_THREE_FOLD_REPETITION, "CHESS_RULE_THREE_FOLD_REPETITION", "three-fold-repetition"}, {CHESS_RULE_INSUFFICIENT_MATERIAL, "CHESS_RULE_INSUFFICIENT_MATERIAL", "insufficient-material"}, {CHESS_RULE_RESIGN, "CHESS_RULE_RESIGN", "resign"}, {CHESS_RULE_ABANDONMENT, "CHESS_RULE_ABANDONMENT", "abandonment"}, {CHESS_RULE_DEATH, "CHESS_RULE_DEATH", "death"}, {0, NULL, NULL}};
		GType chess_rule_type_id;
		chess_rule_type_id = g_enum_register_static ("ChessRule", values);
		g_once_init_leave (&chess_rule_type_id__volatile, chess_rule_type_id);
	}
	return chess_rule_type_id__volatile;
}


static void _chess_state_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (chess_state_unref (var), NULL));
}


static void _g_list_free__chess_state_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _chess_state_unref0_, NULL);
	g_list_free (self);
}


static gboolean _chess_game_move_cb_chess_player_do_move (ChessPlayer* _sender, const gchar* move, gboolean apply, gpointer self) {
	gboolean result;
	result = chess_game_move_cb (self, _sender, move, apply);
	return result;
}


static void _chess_game_undo_cb_chess_player_do_undo (ChessPlayer* _sender, gpointer self) {
	chess_game_undo_cb (self, _sender);
}


static gboolean _chess_game_resign_cb_chess_player_do_resign (ChessPlayer* _sender, gpointer self) {
	gboolean result;
	result = chess_game_resign_cb (self, _sender);
	return result;
}


static gboolean _chess_game_claim_draw_cb_chess_player_do_claim_draw (ChessPlayer* _sender, gpointer self) {
	gboolean result;
	result = chess_game_claim_draw_cb (self, _sender);
	return result;
}


ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1) {
	ChessGame* self = NULL;
	const gchar* _tmp0_;
	ChessState* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	ChessPlayer* _tmp17_;
	ChessPlayer* _tmp18_;
	ChessPlayer* _tmp19_;
	ChessPlayer* _tmp20_;
	ChessPlayer* _tmp21_;
	ChessPlayer* _tmp22_;
	ChessPlayer* _tmp23_;
	ChessPlayer* _tmp24_;
	ChessPlayer* _tmp25_;
	ChessPlayer* _tmp26_;
	ChessPlayer* _tmp27_;
	ChessPlayer* _tmp28_;
	ChessPlayer* _tmp29_;
	ChessPlayer* _tmp30_;
	ChessPlayer* _tmp31_;
	ChessPlayer* _tmp32_;
	g_return_val_if_fail (fen != NULL, NULL);
	self = (ChessGame*) g_type_create_instance (object_type);
	self->is_started = FALSE;
	_tmp0_ = fen;
	_tmp1_ = chess_state_new (_tmp0_);
	self->move_stack = g_list_prepend (self->move_stack, _tmp1_);
	self->result = CHESS_RESULT_IN_PROGRESS;
	_tmp2_ = moves;
	_tmp2__length1 = moves_length1;
	if (_tmp2_ != NULL) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp3_;
				_tmp3_ = TRUE;
				while (TRUE) {
					gboolean _tmp4_;
					gint _tmp6_;
					gchar** _tmp7_;
					gint _tmp7__length1;
					ChessPlayer* _tmp8_;
					ChessPlayer* _tmp9_;
					gchar** _tmp10_;
					gint _tmp10__length1;
					gint _tmp11_;
					const gchar* _tmp12_;
					gboolean _tmp13_ = FALSE;
					_tmp4_ = _tmp3_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp6_ = i;
					_tmp7_ = moves;
					_tmp7__length1 = moves_length1;
					if (!(_tmp6_ < _tmp7__length1)) {
						break;
					}
					_tmp8_ = chess_game_get_current_player (self);
					_tmp9_ = _tmp8_;
					_tmp10_ = moves;
					_tmp10__length1 = moves_length1;
					_tmp11_ = i;
					_tmp12_ = _tmp10_[_tmp11_];
					_tmp13_ = chess_game_do_move (self, _tmp9_, _tmp12_, TRUE);
					if (!_tmp13_) {
						gchar** _tmp14_;
						gint _tmp14__length1;
						gint _tmp15_;
						const gchar* _tmp16_;
						_tmp14_ = moves;
						_tmp14__length1 = moves_length1;
						_tmp15_ = i;
						_tmp16_ = _tmp14_[_tmp15_];
						g_warning ("chess-game.vala:1240: Invalid move %s", _tmp16_);
					}
				}
			}
		}
	}
	_tmp17_ = chess_game_get_white (self);
	_tmp18_ = _tmp17_;
	g_signal_connect (_tmp18_, "do-move", (GCallback) _chess_game_move_cb_chess_player_do_move, self);
	_tmp19_ = chess_game_get_white (self);
	_tmp20_ = _tmp19_;
	g_signal_connect (_tmp20_, "do-undo", (GCallback) _chess_game_undo_cb_chess_player_do_undo, self);
	_tmp21_ = chess_game_get_white (self);
	_tmp22_ = _tmp21_;
	g_signal_connect (_tmp22_, "do-resign", (GCallback) _chess_game_resign_cb_chess_player_do_resign, self);
	_tmp23_ = chess_game_get_white (self);
	_tmp24_ = _tmp23_;
	g_signal_connect (_tmp24_, "do-claim-draw", (GCallback) _chess_game_claim_draw_cb_chess_player_do_claim_draw, self);
	_tmp25_ = chess_game_get_black (self);
	_tmp26_ = _tmp25_;
	g_signal_connect (_tmp26_, "do-move", (GCallback) _chess_game_move_cb_chess_player_do_move, self);
	_tmp27_ = chess_game_get_black (self);
	_tmp28_ = _tmp27_;
	g_signal_connect (_tmp28_, "do-undo", (GCallback) _chess_game_undo_cb_chess_player_do_undo, self);
	_tmp29_ = chess_game_get_black (self);
	_tmp30_ = _tmp29_;
	g_signal_connect (_tmp30_, "do-resign", (GCallback) _chess_game_resign_cb_chess_player_do_resign, self);
	_tmp31_ = chess_game_get_black (self);
	_tmp32_ = _tmp31_;
	g_signal_connect (_tmp32_, "do-claim-draw", (GCallback) _chess_game_claim_draw_cb_chess_player_do_claim_draw, self);
	return self;
}


ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1) {
	return chess_game_construct (TYPE_CHESS_GAME, fen, moves, moves_length1);
}


static gboolean chess_game_move_cb (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	ChessPlayer* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	g_return_val_if_fail (move != NULL, FALSE);
	_tmp0_ = self->is_started;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = player;
	_tmp2_ = move;
	_tmp3_ = apply;
	_tmp4_ = chess_game_do_move (self, _tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


static gpointer _chess_state_ref0 (gpointer self) {
	return self ? chess_state_ref (self) : NULL;
}


static gboolean chess_game_do_move (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_;
	ChessPlayer* _tmp1_;
	ChessPlayer* _tmp2_;
	ChessState* _tmp3_;
	ChessState* _tmp4_;
	ChessState* _tmp5_ = NULL;
	ChessState* state;
	ChessState* _tmp6_;
	gint _tmp7_;
	ChessState* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	ChessState* _tmp13_;
	ChessState* _tmp14_;
	ChessState* _tmp15_;
	ChessMove* _tmp16_;
	ChessPiece* _tmp17_;
	ChessState* _tmp21_;
	ChessMove* _tmp22_;
	ChessPiece* _tmp23_;
	ChessState* _tmp24_;
	ChessMove* _tmp25_;
	ChessPiece* _tmp26_;
	ChessState* _tmp30_;
	ChessMove* _tmp31_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp0_ = player;
	_tmp1_ = chess_game_get_current_player (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ != _tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = chess_game_get_current_state (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = chess_state_copy (_tmp4_);
	state = _tmp5_;
	_tmp6_ = state;
	_tmp7_ = _tmp6_->number;
	_tmp6_->number = _tmp7_ + 1;
	_tmp8_ = state;
	_tmp9_ = move;
	_tmp10_ = apply;
	_tmp11_ = chess_state_move (_tmp8_, _tmp9_, _tmp10_);
	if (!_tmp11_) {
		result = FALSE;
		_chess_state_unref0 (state);
		return result;
	}
	_tmp12_ = apply;
	if (!_tmp12_) {
		result = TRUE;
		_chess_state_unref0 (state);
		return result;
	}
	_tmp13_ = state;
	_tmp14_ = _chess_state_ref0 (_tmp13_);
	self->move_stack = g_list_prepend (self->move_stack, _tmp14_);
	_tmp15_ = state;
	_tmp16_ = _tmp15_->last_move;
	_tmp17_ = _tmp16_->victim;
	if (_tmp17_ != NULL) {
		ChessState* _tmp18_;
		ChessMove* _tmp19_;
		ChessPiece* _tmp20_;
		_tmp18_ = state;
		_tmp19_ = _tmp18_->last_move;
		_tmp20_ = _tmp19_->victim;
		g_signal_emit_by_name (_tmp20_, "died");
	}
	_tmp21_ = state;
	_tmp22_ = _tmp21_->last_move;
	_tmp23_ = _tmp22_->piece;
	g_signal_emit_by_name (_tmp23_, "moved");
	_tmp24_ = state;
	_tmp25_ = _tmp24_->last_move;
	_tmp26_ = _tmp25_->moved_rook;
	if (_tmp26_ != NULL) {
		ChessState* _tmp27_;
		ChessMove* _tmp28_;
		ChessPiece* _tmp29_;
		_tmp27_ = state;
		_tmp28_ = _tmp27_->last_move;
		_tmp29_ = _tmp28_->moved_rook;
		g_signal_emit_by_name (_tmp29_, "moved");
	}
	_tmp30_ = state;
	_tmp31_ = _tmp30_->last_move;
	g_signal_emit_by_name (self, "moved", _tmp31_);
	chess_game_complete_move (self);
	result = TRUE;
	_chess_state_unref0 (state);
	return result;
}


void chess_game_add_hold (ChessGame* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hold_count;
	self->priv->hold_count = _tmp0_ + 1;
}


void chess_game_remove_hold (ChessGame* self) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hold_count;
	g_return_if_fail (_tmp0_ > 0);
	_tmp1_ = self->priv->hold_count;
	self->priv->hold_count = _tmp1_ - 1;
	_tmp2_ = self->priv->hold_count;
	if (_tmp2_ == 0) {
		chess_game_complete_move (self);
	}
}


static void chess_game_complete_move (ChessGame* self) {
	gint _tmp0_;
	ChessRule rule = 0;
	ChessState* _tmp1_;
	ChessState* _tmp2_;
	ChessRule _tmp3_ = 0;
	ChessResult _tmp4_ = 0;
	ChessResult _result_;
	ChessResult _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hold_count;
	if (_tmp0_ > 0) {
		return;
	}
	_tmp1_ = chess_game_get_current_state (self);
	_tmp2_ = _tmp1_;
	_tmp4_ = chess_state_get_result (_tmp2_, &_tmp3_);
	rule = _tmp3_;
	_result_ = _tmp4_;
	_tmp5_ = _result_;
	if (_tmp5_ != CHESS_RESULT_IN_PROGRESS) {
		ChessResult _tmp6_;
		ChessRule _tmp7_;
		_tmp6_ = _result_;
		_tmp7_ = rule;
		chess_game_stop (self, _tmp6_, _tmp7_);
	} else {
		ChessClock* _tmp8_;
		ChessPlayer* _tmp13_;
		ChessPlayer* _tmp14_;
		ChessPlayer* _tmp15_;
		ChessPlayer* _tmp16_;
		_tmp8_ = self->priv->_clock;
		if (_tmp8_ != NULL) {
			ChessClock* _tmp9_;
			ChessPlayer* _tmp10_;
			ChessPlayer* _tmp11_;
			Color _tmp12_;
			_tmp9_ = self->priv->_clock;
			_tmp10_ = chess_game_get_current_player (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = _tmp11_->color;
			chess_clock_set_active_color (_tmp9_, _tmp12_);
		}
		_tmp13_ = chess_game_get_current_player (self);
		_tmp14_ = _tmp13_;
		g_signal_emit_by_name (_tmp14_, "start-turn");
		_tmp15_ = chess_game_get_current_player (self);
		_tmp16_ = _tmp15_;
		g_signal_emit_by_name (self, "turn-started", _tmp16_);
	}
}


static void chess_game_undo_cb (ChessGame* self, ChessPlayer* player) {
	ChessPlayer* _tmp0_;
	ChessPlayer* _tmp1_;
	ChessPlayer* _tmp2_;
	GList* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	_tmp0_ = player;
	_tmp1_ = chess_game_get_current_player (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ == _tmp2_) {
		ChessPlayer* _tmp3_;
		ChessPlayer* _tmp4_;
		_tmp3_ = chess_game_get_opponent (self);
		_tmp4_ = _tmp3_;
		chess_game_undo_cb (self, _tmp4_);
	}
	_tmp5_ = self->move_stack;
	_tmp6_ = _tmp5_->next;
	if (_tmp6_ == NULL) {
		return;
	}
	_tmp7_ = self->move_stack;
	self->move_stack = g_list_remove_link (self->move_stack, _tmp7_);
	g_signal_emit_by_name (self, "undo");
}


static gboolean chess_game_resign_cb (ChessGame* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	ChessPlayer* _tmp1_;
	Color _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp0_ = self->is_started;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = player;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		chess_game_stop (self, CHESS_RESULT_BLACK_WON, CHESS_RULE_RESIGN);
	} else {
		chess_game_stop (self, CHESS_RESULT_WHITE_WON, CHESS_RULE_RESIGN);
	}
	result = TRUE;
	return result;
}


static gboolean chess_game_claim_draw_cb (ChessGame* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	ChessState* _tmp1_;
	ChessState* _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp0_ = self->is_started;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = chess_game_get_current_state (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->halfmove_clock;
	if (_tmp3_ >= 100) {
		chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_FIFTY_MOVES);
	} else {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = chess_game_is_three_fold_repeat (self);
		if (_tmp4_) {
			chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_THREE_FOLD_REPETITION);
		} else {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static void _chess_game_clock_expired_cb_chess_clock_expired (ChessClock* _sender, gpointer self) {
	chess_game_clock_expired_cb (self, _sender);
}


void chess_game_start (ChessGame* self) {
	ChessResult _tmp0_;
	gboolean _tmp1_;
	ChessClock* _tmp2_;
	ChessPlayer* _tmp9_;
	ChessPlayer* _tmp10_;
	ChessPlayer* _tmp11_;
	ChessPlayer* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->result;
	if (_tmp0_ != CHESS_RESULT_IN_PROGRESS) {
		return;
	}
	_tmp1_ = self->is_started;
	if (_tmp1_) {
		return;
	}
	self->is_started = TRUE;
	_tmp2_ = self->priv->_clock;
	if (_tmp2_ != NULL) {
		ChessClock* _tmp3_;
		ChessClock* _tmp4_;
		ChessPlayer* _tmp5_;
		ChessPlayer* _tmp6_;
		Color _tmp7_;
		ChessClock* _tmp8_;
		_tmp3_ = self->priv->_clock;
		g_signal_connect (_tmp3_, "expired", (GCallback) _chess_game_clock_expired_cb_chess_clock_expired, self);
		_tmp4_ = self->priv->_clock;
		_tmp5_ = chess_game_get_current_player (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_->color;
		chess_clock_set_active_color (_tmp4_, _tmp7_);
		_tmp8_ = self->priv->_clock;
		chess_clock_start (_tmp8_);
	}
	g_signal_emit_by_name (self, "started");
	_tmp9_ = chess_game_get_current_player (self);
	_tmp10_ = _tmp9_;
	g_signal_emit_by_name (_tmp10_, "start-turn");
	_tmp11_ = chess_game_get_current_player (self);
	_tmp12_ = _tmp11_;
	g_signal_emit_by_name (self, "turn-started", _tmp12_);
}


static void chess_game_clock_expired_cb (ChessGame* self, ChessClock* clock) {
	ChessPlayer* _tmp0_;
	ChessPlayer* _tmp1_;
	Color _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clock != NULL);
	_tmp0_ = chess_game_get_current_player (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		chess_game_stop (self, CHESS_RESULT_BLACK_WON, CHESS_RULE_TIMEOUT);
	} else {
		chess_game_stop (self, CHESS_RESULT_WHITE_WON, CHESS_RULE_TIMEOUT);
	}
}


void chess_game_abandon (ChessGame* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->is_started;
	if (!_tmp0_) {
		return;
	}
	chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_ABANDONMENT);
}


ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number) {
	ChessPiece* result = NULL;
	gint _tmp0_;
	GList* _tmp4_;
	GList* _tmp5_;
	guint _tmp6_ = 0U;
	gint _tmp7_;
	gconstpointer _tmp8_ = NULL;
	ChessState* _tmp9_;
	ChessState* state;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_ = 0;
	ChessPiece* _tmp13_;
	ChessPiece* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = move_number;
	if (_tmp0_ < 0) {
		gint _tmp1_;
		GList* _tmp2_;
		guint _tmp3_ = 0U;
		_tmp1_ = move_number;
		_tmp2_ = self->move_stack;
		_tmp3_ = g_list_length (_tmp2_);
		move_number = _tmp1_ + ((gint) _tmp3_);
	}
	_tmp4_ = self->move_stack;
	_tmp5_ = self->move_stack;
	_tmp6_ = g_list_length (_tmp5_);
	_tmp7_ = move_number;
	_tmp8_ = g_list_nth_data (_tmp4_, (_tmp6_ - _tmp7_) - 1);
	_tmp9_ = _chess_state_ref0 ((ChessState*) _tmp8_);
	state = _tmp9_;
	_tmp10_ = rank;
	_tmp11_ = file;
	_tmp12_ = chess_state_get_index (state, _tmp10_, _tmp11_);
	_tmp13_ = state->board[_tmp12_];
	_tmp14_ = _chess_piece_ref0 (_tmp13_);
	result = _tmp14_;
	_chess_state_unref0 (state);
	return result;
}


static void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule) {
	ChessResult _tmp0_;
	ChessRule _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _result_;
	self->result = _tmp0_;
	_tmp1_ = rule;
	self->rule = _tmp1_;
	self->is_started = FALSE;
	g_signal_emit_by_name (self, "ended");
}


static gboolean chess_game_is_three_fold_repeat (ChessGame* self) {
	gboolean result = FALSE;
	gint count;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	count = 1;
	_tmp0_ = self->move_stack;
	_tmp1_ = _tmp0_->next;
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
		state_collection = _tmp1_;
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
			ChessState* _tmp2_;
			ChessState* state = NULL;
			_tmp2_ = _chess_state_ref0 ((ChessState*) state_it->data);
			state = _tmp2_;
			{
				ChessState* _tmp3_;
				ChessState* _tmp4_;
				ChessState* _tmp5_;
				gboolean _tmp6_ = FALSE;
				_tmp3_ = chess_game_get_current_state (self);
				_tmp4_ = _tmp3_;
				_tmp5_ = state;
				_tmp6_ = chess_state_equals (_tmp4_, _tmp5_);
				if (_tmp6_) {
					gint _tmp7_;
					gint _tmp8_;
					_tmp7_ = count;
					count = _tmp7_ + 1;
					_tmp8_ = count;
					if (_tmp8_ >= 3) {
						result = TRUE;
						_chess_state_unref0 (state);
						return result;
					}
				}
				_chess_state_unref0 (state);
			}
		}
	}
	result = FALSE;
	return result;
}


ChessState* chess_game_get_current_state (ChessGame* self) {
	ChessState* result;
	GList* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->move_stack;
	_tmp1_ = _tmp0_->data;
	result = (ChessState*) _tmp1_;
	return result;
}


ChessPlayer* chess_game_get_white (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	ChessPlayer* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->players[COLOR_WHITE];
	result = _tmp2_;
	return result;
}


ChessPlayer* chess_game_get_black (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	ChessPlayer* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->players[COLOR_BLACK];
	result = _tmp2_;
	return result;
}


ChessPlayer* chess_game_get_current_player (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	ChessPlayer* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->current_player;
	result = _tmp2_;
	return result;
}


ChessPlayer* chess_game_get_opponent (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	ChessPlayer* _tmp2_;
	ChessPlayer* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_state_get_opponent (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}


ChessClock* chess_game_get_clock (ChessGame* self) {
	ChessClock* result;
	ChessClock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_clock;
	result = _tmp0_;
	return result;
}


void chess_game_set_clock (ChessGame* self, ChessClock* value) {
	gboolean _tmp0_;
	ChessClock* _tmp1_;
	ChessClock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->is_started;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = value;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_clock);
	self->priv->_clock = _tmp2_;
}


guint chess_game_get_n_moves (ChessGame* self) {
	guint result;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->move_stack;
	_tmp1_ = g_list_length (_tmp0_);
	result = _tmp1_ - 1;
	return result;
}


static void g_cclosure_user_marshal_VOID__CHESS_MOVE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__CHESS_MOVE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__CHESS_MOVE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__CHESS_MOVE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_chess_move (param_values + 1), data2);
}


static void value_chess_game_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_chess_game_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		chess_game_unref (value->data[0].v_pointer);
	}
}


static void value_chess_game_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = chess_game_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_chess_game_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_chess_game_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ChessGame* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = chess_game_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_chess_game_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessGame** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = chess_game_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessGame* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_GAME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_chess_game (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_GAME), NULL);
	return value->data[0].v_pointer;
}


void value_set_chess_game (GValue* value, gpointer v_object) {
	ChessGame* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_GAME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_GAME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		chess_game_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_game_unref (old);
	}
}


void value_take_chess_game (GValue* value, gpointer v_object) {
	ChessGame* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_GAME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_GAME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_game_unref (old);
	}
}


static void chess_game_class_init (ChessGameClass * klass) {
	chess_game_parent_class = g_type_class_peek_parent (klass);
	CHESS_GAME_CLASS (klass)->finalize = chess_game_finalize;
	g_type_class_add_private (klass, sizeof (ChessGamePrivate));
	g_signal_new ("started", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("turn_started", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_CHESS_PLAYER);
	g_signal_new ("moved", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__CHESS_MOVE, G_TYPE_NONE, 1, TYPE_CHESS_MOVE);
	g_signal_new ("undo", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("ended", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_game_instance_init (ChessGame * self) {
	self->priv = CHESS_GAME_GET_PRIVATE (self);
	self->priv->hold_count = 0;
	self->ref_count = 1;
}


static void chess_game_finalize (ChessGame* obj) {
	ChessGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_GAME, ChessGame);
	__g_list_free__chess_state_unref0_0 (self->move_stack);
	_g_object_unref0 (self->priv->_clock);
}


GType chess_game_get_type (void) {
	static volatile gsize chess_game_type_id__volatile = 0;
	if (g_once_init_enter (&chess_game_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_game_init, value_chess_game_free_value, value_chess_game_copy_value, value_chess_game_peek_pointer, "p", value_chess_game_collect_value, "p", value_chess_game_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessGame), 0, (GInstanceInitFunc) chess_game_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_game_type_id;
		chess_game_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessGame", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_game_type_id__volatile, chess_game_type_id);
	}
	return chess_game_type_id__volatile;
}


gpointer chess_game_ref (gpointer instance) {
	ChessGame* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void chess_game_unref (gpointer instance) {
	ChessGame* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CHESS_GAME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



