/* rygel-playbin-player.c generated by valac 0.18.1, the Vala compiler
 * generated from rygel-playbin-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010,2011,2012 Nokia Corporation.
 * Copyright (C) 2012 Openismus GmbH
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-renderer.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>


#define RYGEL_PLAYBIN_TYPE_PLAYER (rygel_playbin_player_get_type ())
#define RYGEL_PLAYBIN_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer))
#define RYGEL_PLAYBIN_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))
#define RYGEL_PLAYBIN_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))

typedef struct _RygelPlaybinPlayer RygelPlaybinPlayer;
typedef struct _RygelPlaybinPlayerClass RygelPlaybinPlayerClass;
typedef struct _RygelPlaybinPlayerPrivate RygelPlaybinPlayerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GstStructure_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstStructure_free (var), NULL)))
#define _gst_mini_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_mini_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelPlaybinPlayer {
	GObject parent_instance;
	RygelPlaybinPlayerPrivate * priv;
};

struct _RygelPlaybinPlayerClass {
	GObjectClass parent_class;
};

struct _RygelPlaybinPlayerPrivate {
	gboolean is_live;
	gboolean foreign;
	gboolean buffering;
	GstElement* _playbin;
	gchar* _playback_state;
	gchar** _allowed_playback_speeds;
	gint _allowed_playback_speeds_length1;
	gint __allowed_playback_speeds_size_;
	gchar* _playback_speed;
	gchar* transfer_mode;
	gboolean uri_update_hint;
	gchar* _uri;
	gchar* _mime_type;
	gchar* _metadata;
	gchar* _content_features;
	GUPnPProtocolInfo* protocol_info;
};


static gpointer rygel_playbin_player_parent_class = NULL;
static RygelPlaybinPlayer* rygel_playbin_player_player;
static RygelPlaybinPlayer* rygel_playbin_player_player = NULL;
static RygelMediaPlayerIface* rygel_playbin_player_rygel_media_player_parent_iface = NULL;

GType rygel_playbin_player_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAYBIN_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerPrivate))
enum  {
	RYGEL_PLAYBIN_PLAYER_DUMMY_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_PLAYBIN,
	RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE,
	RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS,
	RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED,
	RYGEL_PLAYBIN_PLAYER_URI,
	RYGEL_PLAYBIN_PLAYER_MIME_TYPE,
	RYGEL_PLAYBIN_PLAYER_METADATA,
	RYGEL_PLAYBIN_PLAYER_CAN_SEEK,
	RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES,
	RYGEL_PLAYBIN_PLAYER_VOLUME,
	RYGEL_PLAYBIN_PLAYER_DURATION,
	RYGEL_PLAYBIN_PLAYER_POSITION
};
#define RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_STREAMING "Streaming"
#define RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE "Interactive"
#define RYGEL_PLAYBIN_PLAYER_PROTOCOL_INFO_TEMPLATE "http-get:%s:*:%s"
static RygelPlaybinPlayer* rygel_playbin_player_new (void);
static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type);
static void rygel_playbin_player_set_playbin (RygelPlaybinPlayer* self, GstElement* value);
static void rygel_playbin_player_setup_playbin (RygelPlaybinPlayer* self);
RygelPlaybinPlayer* rygel_playbin_player_new_wrap (GstElement* playbin);
RygelPlaybinPlayer* rygel_playbin_player_construct_wrap (GType object_type, GstElement* playbin);
RygelPlaybinPlayer* rygel_playbin_player_get_default (void);
static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, gint64 time);
GstElement* rygel_playbin_player_get_playbin (RygelPlaybinPlayer* self);
static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gboolean rygel_playbin_player_is_rendering_image (RygelPlaybinPlayer* self);
static inline GstCaps* _dynamic_get_caps0 (GstElement* obj);
static GstStructure* _vala_GstStructure_copy (GstStructure* self);
static void _vala_GstStructure_free (GstStructure* self);
static void rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message);
static inline gchar* _dynamic_get_current_uri1 (GstElement* obj);
static inline gchar* _dynamic_get_uri2 (GstElement* obj);
static gchar* rygel_playbin_player_generate_basic_didl (RygelPlaybinPlayer* self);
static void rygel_playbin_player_on_source_setup (RygelPlaybinPlayer* self, GstElement* pipeline, GstElement* source);
static inline void _dynamic_set_extra_headers3 (GstElement* obj, GstStructure* value);
static void rygel_playbin_player_on_uri_notify (RygelPlaybinPlayer* self, GParamSpec* pspec);
static inline void _dynamic_set_auto_flush_bus4 (GstElement* obj, gboolean value);
static void _rygel_playbin_player_on_source_setup_dynamic_source_setup0_ (GstElement* _sender, GstElement* source, gpointer self);
void _dynamic_source_setup1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data);
static void _rygel_playbin_player_on_uri_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _rygel_playbin_player_bus_handler_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static gchar** _vala_array_dup3 (gchar** self, int length);
static inline void _dynamic_set_uri5 (GstElement* obj, const gchar* value);
static inline gdouble _dynamic_get_volume6 (GstElement* obj);
static inline void _dynamic_set_volume7 (GstElement* obj, gdouble value);
static void rygel_playbin_player_finalize (GObject* obj);
static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* RYGEL_PLAYBIN_PLAYER_protocols[2] = {"http-get", "rtsp"};
static const gchar* RYGEL_PLAYBIN_PLAYER_mime_types[41] = {"audio/mpeg", "application/ogg", "audio/x-vorbis", "audio/x-vorbis+ogg", "audio/ogg", "audio/x-ms-wma", "audio/x-ms-asf", "audio/x-flac", "audio/x-flac+ogg", "audio/flac", "audio/mp4", "audio/3gpp", "audio/vnd.dlna.adts", "audio/x-mod", "audio/x-wav", "audio/x-ac3", "audio/x-m4a", "audio/L16;rate=44100;channels=2", "audio/L16;rate=44100;channels=1", "audio/L16;channels=2;rate=44100", "audio/L16;channels=1;rate=44100", "audio/L16;rate=44100", "image/jpeg", "image/png", "video/x-theora", "video/x-theora+ogg", "video/x-oggm", "video/ogg", "video/x-dirac", "video/x-wmv", "video/x-wma", "video/x-msvideo", "video/x-3ivx", "video/x-3ivx", "video/x-matroska", "video/x-mkv", "video/mpeg", "video/mp4", "video/x-ms-asf", "video/x-xvid", "video/x-ms-wmv"};

static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type) {
	RygelPlaybinPlayer * self = NULL;
	GstElement* _tmp0_ = NULL;
	self = (RygelPlaybinPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = gst_element_factory_make ("playbin", NULL);
	rygel_playbin_player_set_playbin (self, _tmp0_);
	self->priv->foreign = FALSE;
	rygel_playbin_player_setup_playbin (self);
	return self;
}


static RygelPlaybinPlayer* rygel_playbin_player_new (void) {
	return rygel_playbin_player_construct (RYGEL_PLAYBIN_TYPE_PLAYER);
}


RygelPlaybinPlayer* rygel_playbin_player_construct_wrap (GType object_type, GstElement* playbin) {
	RygelPlaybinPlayer * self = NULL;
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	GType _tmp2_ = 0UL;
	const gchar* _tmp3_ = NULL;
	GstElement* _tmp4_;
	g_return_val_if_fail (playbin != NULL, NULL);
	self = (RygelPlaybinPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = playbin;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = playbin;
	_tmp2_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp1_);
	_tmp3_ = g_type_name (_tmp2_);
	g_return_if_fail (g_strcmp0 (_tmp3_, "GstPlayBin") == 0);
	_tmp4_ = playbin;
	rygel_playbin_player_set_playbin (self, _tmp4_);
	self->priv->foreign = TRUE;
	rygel_playbin_player_setup_playbin (self);
	return self;
}


RygelPlaybinPlayer* rygel_playbin_player_new_wrap (GstElement* playbin) {
	return rygel_playbin_player_construct_wrap (RYGEL_PLAYBIN_TYPE_PLAYER, playbin);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelPlaybinPlayer* rygel_playbin_player_get_default (void) {
	RygelPlaybinPlayer* result = NULL;
	RygelPlaybinPlayer* _tmp0_;
	RygelPlaybinPlayer* _tmp2_;
	RygelPlaybinPlayer* _tmp3_;
	_tmp0_ = rygel_playbin_player_player;
	if (_tmp0_ == NULL) {
		RygelPlaybinPlayer* _tmp1_;
		_tmp1_ = rygel_playbin_player_new ();
		_g_object_unref0 (rygel_playbin_player_player);
		rygel_playbin_player_player = _tmp1_;
	}
	_tmp2_ = rygel_playbin_player_player;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, gint64 time) {
	RygelPlaybinPlayer * self;
	gboolean result = FALSE;
	GstElement* _tmp0_;
	gint64 _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playbin;
	_tmp1_ = time;
	_tmp2_ = gst_element_seek (_tmp0_, 1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, GST_SEEK_TYPE_SET, _tmp1_ * GST_USECOND, GST_SEEK_TYPE_NONE, (gint64) (-1));
	result = _tmp2_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = (RYGEL_PLAYBIN_PLAYER_protocols != NULL) ? _vala_array_dup1 (RYGEL_PLAYBIN_PLAYER_protocols, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols)) : ((gpointer) RYGEL_PLAYBIN_PLAYER_protocols);
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = (RYGEL_PLAYBIN_PLAYER_mime_types != NULL) ? _vala_array_dup2 (RYGEL_PLAYBIN_PLAYER_mime_types, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types)) : ((gpointer) RYGEL_PLAYBIN_PLAYER_mime_types);
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static inline GstCaps* _dynamic_get_caps0 (GstElement* obj) {
	GstCaps* result;
	g_object_get (obj, "caps", &result, NULL);
	return result;
}


static GstStructure* _vala_GstStructure_copy (GstStructure* self) {
	return g_boxed_copy (gst_structure_get_type (), self);
}


static gpointer __vala_GstStructure_copy0 (gpointer self) {
	return self ? _vala_GstStructure_copy (self) : NULL;
}


static void _vala_GstStructure_free (GstStructure* self) {
	g_boxed_free (gst_structure_get_type (), self);
}


static gboolean rygel_playbin_player_is_rendering_image (RygelPlaybinPlayer* self) {
	gboolean result = FALSE;
	GstElement* typefind = NULL;
	GstElement* _tmp0_;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_;
	GstCaps* _tmp3_;
	GstCaps* _tmp4_;
	GstCaps* caps;
	GstCaps* _tmp5_;
	GstStructure* _tmp6_ = NULL;
	GstStructure* _tmp7_;
	GstStructure* structure;
	gboolean _tmp8_ = FALSE;
	GstStructure* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_playbin;
	_tmp1_ = gst_bin_get_by_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gst_bin_get_type ()) ? ((GstBin*) _tmp0_) : NULL, "typefind");
	_g_object_unref0 (typefind);
	typefind = _tmp1_;
	_tmp2_ = typefind;
	_tmp3_ = _dynamic_get_caps0 (_tmp2_);
	_tmp4_ = _tmp3_;
	caps = _tmp4_;
	_tmp5_ = caps;
	_tmp6_ = gst_caps_get_structure (_tmp5_, (guint) 0);
	_tmp7_ = __vala_GstStructure_copy0 (_tmp6_);
	structure = _tmp7_;
	_tmp9_ = structure;
	_tmp10_ = gst_structure_get_name (_tmp9_);
	if (g_strcmp0 (_tmp10_, "image/jpeg") == 0) {
		_tmp8_ = TRUE;
	} else {
		GstStructure* _tmp11_;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = structure;
		_tmp12_ = gst_structure_get_name (_tmp11_);
		_tmp8_ = g_strcmp0 (_tmp12_, "image/png") == 0;
	}
	_tmp13_ = _tmp8_;
	result = _tmp13_;
	__vala_GstStructure_free0 (structure);
	_gst_mini_object_unref0 (caps);
	_g_object_unref0 (typefind);
	return result;
}


static inline gchar* _dynamic_get_current_uri1 (GstElement* obj) {
	gchar* result;
	g_object_get (obj, "current-uri", &result, NULL);
	return result;
}


static inline gchar* _dynamic_get_uri2 (GstElement* obj) {
	gchar* result;
	g_object_get (obj, "uri", &result, NULL);
	return result;
}


static void rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message) {
	GstMessage* _tmp0_;
	GstMessageType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bus != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	switch (_tmp1_) {
		case GST_MESSAGE_DURATION_CHANGED:
		{
			GstElement* _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp2_ = self->priv->_playbin;
			_tmp3_ = gst_element_query_duration (_tmp2_, GST_FORMAT_TIME, NULL);
			if (_tmp3_) {
				g_object_notify ((GObject*) self, "duration");
			}
			break;
		}
		case GST_MESSAGE_STATE_CHANGED:
		{
			GstMessage* _tmp4_;
			GstObject* _tmp5_;
			GstElement* _tmp6_;
			_tmp4_ = message;
			_tmp5_ = _tmp4_->src;
			_tmp6_ = self->priv->_playbin;
			if (_tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gst_object_get_type (), GstObject)) {
				GstState old_state = 0;
				GstState new_state = 0;
				GstState pending = 0;
				GstMessage* _tmp7_;
				GstState _tmp8_ = 0;
				GstState _tmp9_ = 0;
				GstState _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
				GstState _tmp12_;
				gboolean _tmp14_;
				gboolean _tmp29_ = FALSE;
				GstState _tmp30_;
				gboolean _tmp32_;
				gboolean _tmp34_ = FALSE;
				GstState _tmp35_;
				gboolean _tmp37_;
				_tmp7_ = message;
				gst_message_parse_state_changed (_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
				old_state = _tmp8_;
				new_state = _tmp9_;
				pending = _tmp10_;
				_tmp12_ = old_state;
				if (_tmp12_ == GST_STATE_READY) {
					GstState _tmp13_;
					_tmp13_ = new_state;
					_tmp11_ = _tmp13_ == GST_STATE_PAUSED;
				} else {
					_tmp11_ = FALSE;
				}
				_tmp14_ = _tmp11_;
				if (_tmp14_) {
					gboolean _tmp15_;
					_tmp15_ = self->priv->uri_update_hint;
					if (_tmp15_) {
						GstElement* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp18_;
						gchar* uri;
						gboolean _tmp19_ = FALSE;
						const gchar* _tmp20_;
						const gchar* _tmp21_;
						gboolean _tmp23_;
						self->priv->uri_update_hint = FALSE;
						_tmp16_ = self->priv->_playbin;
						_tmp17_ = _dynamic_get_current_uri1 (_tmp16_);
						_tmp18_ = _tmp17_;
						uri = _tmp18_;
						_tmp20_ = self->priv->_uri;
						_tmp21_ = uri;
						if (g_strcmp0 (_tmp20_, _tmp21_) != 0) {
							const gchar* _tmp22_;
							_tmp22_ = uri;
							_tmp19_ = g_strcmp0 (_tmp22_, "") != 0;
						} else {
							_tmp19_ = FALSE;
						}
						_tmp23_ = _tmp19_;
						if (_tmp23_) {
							GstElement* _tmp24_;
							gchar* _tmp25_;
							gchar* _tmp26_;
							gchar* _tmp27_ = NULL;
							gchar* _tmp28_;
							_tmp24_ = self->priv->_playbin;
							_tmp25_ = _dynamic_get_uri2 (_tmp24_);
							_tmp26_ = _tmp25_;
							_g_free0 (self->priv->_uri);
							self->priv->_uri = _tmp26_;
							g_object_notify ((GObject*) self, "uri");
							_tmp27_ = rygel_playbin_player_generate_basic_didl (self);
							_tmp28_ = _tmp27_;
							rygel_media_player_set_metadata ((RygelMediaPlayer*) self, _tmp28_);
							_g_free0 (_tmp28_);
						}
						_g_free0 (uri);
					}
				}
				_tmp30_ = pending;
				if (_tmp30_ == GST_STATE_VOID_PENDING) {
					gboolean _tmp31_;
					_tmp31_ = self->priv->buffering;
					_tmp29_ = !_tmp31_;
				} else {
					_tmp29_ = FALSE;
				}
				_tmp32_ = _tmp29_;
				if (_tmp32_) {
					GstState _tmp33_;
					_tmp33_ = new_state;
					switch (_tmp33_) {
						case GST_STATE_PAUSED:
						{
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PAUSED_PLAYBACK");
							break;
						}
						case GST_STATE_NULL:
						{
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
							break;
						}
						case GST_STATE_PLAYING:
						{
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PLAYING");
							break;
						}
						default:
						{
							break;
						}
					}
				}
				_tmp35_ = old_state;
				if (_tmp35_ == GST_STATE_PAUSED) {
					GstState _tmp36_;
					_tmp36_ = new_state;
					_tmp34_ = _tmp36_ == GST_STATE_PLAYING;
				} else {
					_tmp34_ = FALSE;
				}
				_tmp37_ = _tmp34_;
				if (_tmp37_) {
					self->priv->buffering = FALSE;
					rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PLAYING");
				}
			}
			break;
		}
		case GST_MESSAGE_BUFFERING:
		{
			gboolean _tmp38_ = FALSE;
			gboolean _tmp39_;
			gboolean _tmp41_;
			_tmp39_ = self->priv->is_live;
			if (_tmp39_) {
				_tmp38_ = TRUE;
			} else {
				gboolean _tmp40_;
				_tmp40_ = self->priv->foreign;
				_tmp38_ = _tmp40_;
			}
			_tmp41_ = _tmp38_;
			if (!_tmp41_) {
				gint percent = 0;
				GstMessage* _tmp42_;
				gint _tmp43_ = 0;
				gint _tmp44_;
				_tmp42_ = message;
				gst_message_parse_buffering (_tmp42_, &_tmp43_);
				percent = _tmp43_;
				_tmp44_ = percent;
				if (_tmp44_ < 100) {
					GstElement* _tmp45_;
					self->priv->buffering = TRUE;
					_tmp45_ = self->priv->_playbin;
					gst_element_set_state (_tmp45_, GST_STATE_PAUSED);
				} else {
					GstElement* _tmp46_;
					_tmp46_ = self->priv->_playbin;
					gst_element_set_state (_tmp46_, GST_STATE_PLAYING);
				}
			}
			break;
		}
		case GST_MESSAGE_CLOCK_LOST:
		{
			gboolean _tmp47_;
			_tmp47_ = self->priv->foreign;
			if (!_tmp47_) {
				GstElement* _tmp48_;
				GstElement* _tmp49_;
				_tmp48_ = self->priv->_playbin;
				gst_element_set_state (_tmp48_, GST_STATE_PAUSED);
				_tmp49_ = self->priv->_playbin;
				gst_element_set_state (_tmp49_, GST_STATE_PLAYING);
			}
			break;
		}
		case GST_MESSAGE_EOS:
		{
			gboolean _tmp50_ = FALSE;
			_tmp50_ = rygel_playbin_player_is_rendering_image (self);
			if (!_tmp50_) {
				g_debug ("rygel-playbin-player.vala:424: EOS");
				rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "EOS");
			} else {
				g_debug ("rygel-playbin-player.vala:427: Content is image, ignoring EOS");
			}
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			GError* _error_ = NULL;
			gchar* error_message = NULL;
			GstMessage* _tmp51_;
			GError* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
			GstElement* _tmp54_;
			gchar* _tmp55_ = NULL;
			gchar* _tmp56_;
			gchar* _tmp57_;
			const gchar* _tmp58_;
			_tmp51_ = message;
			gst_message_parse_error (_tmp51_, &_tmp52_, &_tmp53_);
			_g_error_free0 (_error_);
			_error_ = _tmp52_;
			_g_free0 (error_message);
			error_message = _tmp53_;
			_tmp54_ = self->priv->_playbin;
			g_object_get ((GstObject*) _tmp54_, "name", &_tmp55_, NULL);
			_tmp56_ = _tmp55_;
			_tmp57_ = _tmp56_;
			_tmp58_ = error_message;
			g_warning ("rygel-playbin-player.vala:437: Error from GStreamer element %s: %s", _tmp57_, _tmp58_);
			_g_free0 (_tmp57_);
			g_warning ("rygel-playbin-player.vala:440: Going to STOPPED state");
			rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
			_g_free0 (error_message);
			_g_error_free0 (_error_);
			break;
		}
		default:
		break;
	}
}


static inline void _dynamic_set_extra_headers3 (GstElement* obj, GstStructure* value) {
	g_object_set (obj, "extra-headers", value, NULL);
}


static void rygel_playbin_player_on_source_setup (RygelPlaybinPlayer* self, GstElement* pipeline, GstElement* source) {
	gboolean _tmp0_ = FALSE;
	GstElement* _tmp1_;
	GType _tmp2_ = 0UL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pipeline != NULL);
	g_return_if_fail (source != NULL);
	_tmp1_ = source;
	_tmp2_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp1_);
	_tmp3_ = g_type_name (_tmp2_);
	if (g_strcmp0 (_tmp3_, "GstSoupHTTPSrc") == 0) {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->transfer_mode;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		const gchar* _tmp6_;
		GstStructure* _tmp7_;
		GstStructure* structure;
		GstStructure* _tmp8_;
		const gchar* _tmp9_;
		GValue _tmp10_ = {0};
		GstElement* _tmp11_;
		GstStructure* _tmp12_;
		_tmp6_ = self->priv->transfer_mode;
		g_debug ("rygel-playbin-player.vala:451: Setting transfer mode to %s", _tmp6_);
		_tmp7_ = gst_structure_new_empty ("HTTPHeaders");
		structure = _tmp7_;
		_tmp8_ = structure;
		_tmp9_ = self->priv->transfer_mode;
		g_value_init (&_tmp10_, G_TYPE_STRING);
		g_value_set_string (&_tmp10_, _tmp9_);
		gst_structure_set_value (_tmp8_, "transferMode.dlna.org", &_tmp10_);
		G_IS_VALUE (&_tmp10_) ? (g_value_unset (&_tmp10_), NULL) : NULL;
		_tmp11_ = source;
		_tmp12_ = structure;
		_dynamic_set_extra_headers3 (_tmp11_, _tmp12_);
		__vala_GstStructure_free0 (structure);
	}
}


static void rygel_playbin_player_on_uri_notify (RygelPlaybinPlayer* self, GParamSpec* pspec) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	self->priv->uri_update_hint = TRUE;
}


/**
     * Generate basic DIDLLite information.
     *
     * This is used when the URI gets changed externally. DLNA requires that a
     * minimum DIDLLite is always present if the URI is not empty.
     */
static gchar* rygel_playbin_player_generate_basic_didl (RygelPlaybinPlayer* self) {
	gchar* result = NULL;
	GUPnPDIDLLiteWriter* _tmp0_;
	GUPnPDIDLLiteWriter* writer;
	GUPnPDIDLLiteItem* _tmp1_ = NULL;
	GUPnPDIDLLiteItem* item;
	GUPnPDIDLLiteResource* _tmp2_ = NULL;
	GUPnPDIDLLiteResource* resource;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* _tmp7_ = NULL;
	GFile* _tmp8_;
	GFile* file;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gupnp_didl_lite_writer_new (NULL);
	writer = _tmp0_;
	_tmp1_ = gupnp_didl_lite_writer_add_item (writer);
	item = _tmp1_;
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) item, "1");
	gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) item, "-1");
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) item, "object.item");
	_tmp2_ = gupnp_didl_lite_object_add_resource ((GUPnPDIDLLiteObject*) item);
	resource = _tmp2_;
	_tmp3_ = self->priv->_uri;
	gupnp_didl_lite_resource_set_uri (resource, _tmp3_);
	_tmp4_ = rygel_media_player_get_uri ((RygelMediaPlayer*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = g_file_new_for_uri (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	file = _tmp8_;
	_tmp9_ = g_file_get_basename (file);
	_tmp10_ = _tmp9_;
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) item, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = gupnp_didl_lite_writer_get_string (writer);
	result = _tmp11_;
	_g_object_unref0 (file);
	_g_object_unref0 (resource);
	_g_object_unref0 (item);
	_g_object_unref0 (writer);
	return result;
}


static inline void _dynamic_set_auto_flush_bus4 (GstElement* obj, gboolean value) {
	g_object_set (obj, "auto-flush-bus", value, NULL);
}


static void _rygel_playbin_player_on_source_setup_dynamic_source_setup0_ (GstElement* _sender, GstElement* source, gpointer self) {
	rygel_playbin_player_on_source_setup (self, _sender, source);
}


void _dynamic_source_setup1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data) {
	g_signal_connect_object (obj, signal_name, handler, data, 0);
}


static void _rygel_playbin_player_on_uri_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_playbin_player_on_uri_notify (self, pspec);
}


static void _rygel_playbin_player_bus_handler_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
	rygel_playbin_player_bus_handler (self, _sender, message);
}


static void rygel_playbin_player_setup_playbin (RygelPlaybinPlayer* self) {
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	GstElement* _tmp2_;
	GstElement* _tmp3_;
	GstElement* _tmp4_;
	GstBus* _tmp5_ = NULL;
	GstBus* bus;
	g_return_if_fail (self != NULL);
	self->priv->is_live = FALSE;
	_tmp0_ = self->priv->_playbin;
	_dynamic_set_auto_flush_bus4 (_tmp0_, FALSE);
	_tmp1_ = self->priv->_playbin;
	_vala_assert (_tmp1_ != NULL, "this.playbin != null");
	_tmp2_ = self->priv->_playbin;
	_dynamic_source_setup1_connect (_tmp2_, "source_setup", (GCallback) _rygel_playbin_player_on_source_setup_dynamic_source_setup0_, self);
	_tmp3_ = self->priv->_playbin;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::uri", (GCallback) _rygel_playbin_player_on_uri_notify_g_object_notify, self, 0);
	_tmp4_ = self->priv->_playbin;
	_tmp5_ = gst_element_get_bus (_tmp4_);
	bus = _tmp5_;
	gst_bus_add_signal_watch_full (bus, G_PRIORITY_DEFAULT);
	g_signal_connect_object (bus, "message", (GCallback) _rygel_playbin_player_bus_handler_gst_bus_message, self, 0);
	_g_object_unref0 (bus);
}


GstElement* rygel_playbin_player_get_playbin (RygelPlaybinPlayer* self) {
	GstElement* result;
	GstElement* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_playbin;
	result = _tmp0_;
	return result;
}


static void rygel_playbin_player_set_playbin (RygelPlaybinPlayer* self, GstElement* value) {
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_playbin);
	self->priv->_playbin = _tmp1_;
	g_object_notify ((GObject *) self, "playbin");
}


static gchar* rygel_playbin_player_real_get_playback_state (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playback_state;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_playbin_player_real_set_playback_state (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	GstState state = 0;
	GstState pending = 0;
	GstElement* _tmp0_;
	GstState _tmp1_ = 0;
	GstState _tmp2_ = 0;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playbin;
	gst_element_get_state (_tmp0_, &_tmp1_, &_tmp2_, (GstClockTime) GST_MSECOND);
	state = _tmp1_;
	pending = _tmp2_;
	_tmp3_ = value;
	g_debug ("rygel-playbin-player.vala:102: Changing playback state to %s.", _tmp3_);
	_tmp4_ = value;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("STOPPED")))) {
		switch (0) {
			default:
			{
				gboolean _tmp8_ = FALSE;
				GstState _tmp9_;
				gboolean _tmp11_;
				_tmp9_ = state;
				if (_tmp9_ != GST_STATE_NULL) {
					_tmp8_ = TRUE;
				} else {
					GstState _tmp10_;
					_tmp10_ = pending;
					_tmp8_ = _tmp10_ != GST_STATE_VOID_PENDING;
				}
				_tmp11_ = _tmp8_;
				if (_tmp11_) {
					gchar* _tmp12_;
					GstElement* _tmp13_;
					_tmp12_ = g_strdup ("TRANSITIONING");
					_g_free0 (self->priv->_playback_state);
					self->priv->_playback_state = _tmp12_;
					_tmp13_ = self->priv->_playbin;
					gst_element_set_state (_tmp13_, GST_STATE_NULL);
				} else {
					const gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp14_ = value;
					_tmp15_ = g_strdup (_tmp14_);
					_g_free0 (self->priv->_playback_state);
					self->priv->_playback_state = _tmp15_;
				}
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
		switch (0) {
			default:
			{
				gboolean _tmp16_ = FALSE;
				GstState _tmp17_;
				gboolean _tmp19_;
				_tmp17_ = state;
				if (_tmp17_ != GST_STATE_PAUSED) {
					_tmp16_ = TRUE;
				} else {
					GstState _tmp18_;
					_tmp18_ = pending;
					_tmp16_ = _tmp18_ != GST_STATE_VOID_PENDING;
				}
				_tmp19_ = _tmp16_;
				if (_tmp19_) {
					gchar* _tmp20_;
					GstElement* _tmp21_;
					_tmp20_ = g_strdup ("TRANSITIONING");
					_g_free0 (self->priv->_playback_state);
					self->priv->_playback_state = _tmp20_;
					_tmp21_ = self->priv->_playbin;
					gst_element_set_state (_tmp21_, GST_STATE_PAUSED);
				} else {
					const gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp22_ = value;
					_tmp23_ = g_strdup (_tmp22_);
					_g_free0 (self->priv->_playback_state);
					self->priv->_playback_state = _tmp23_;
				}
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("PLAYING")))) {
		switch (0) {
			default:
			{
				gboolean _tmp24_ = FALSE;
				GstState _tmp25_;
				gboolean _tmp27_;
				_tmp25_ = state;
				if (_tmp25_ != GST_STATE_PLAYING) {
					_tmp24_ = TRUE;
				} else {
					GstState _tmp26_;
					_tmp26_ = pending;
					_tmp24_ = _tmp26_ != GST_STATE_VOID_PENDING;
				}
				_tmp27_ = _tmp24_;
				if (_tmp27_) {
					gchar* _tmp28_;
					GstElement* _tmp29_;
					GstStateChangeReturn _tmp30_ = 0;
					_tmp28_ = g_strdup ("TRANSITIONING");
					_g_free0 (self->priv->_playback_state);
					self->priv->_playback_state = _tmp28_;
					_tmp29_ = self->priv->_playbin;
					_tmp30_ = gst_element_set_state (_tmp29_, GST_STATE_PLAYING);
					self->priv->is_live = _tmp30_ == GST_STATE_CHANGE_NO_PREROLL;
				} else {
					const gchar* _tmp31_;
					gchar* _tmp32_;
					_tmp31_ = value;
					_tmp32_ = g_strdup (_tmp31_);
					_g_free0 (self->priv->_playback_state);
					self->priv->_playback_state = _tmp32_;
				}
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("EOS")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp33_;
				gchar* _tmp34_;
				_tmp33_ = value;
				_tmp34_ = g_strdup (_tmp33_);
				_g_free0 (self->priv->_playback_state);
				self->priv->_playback_state = _tmp34_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	g_object_notify ((GObject *) self, "playback-state");
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_playbin_player_real_get_allowed_playback_speeds (RygelMediaPlayer* base, int* result_length1) {
	gchar** result;
	RygelPlaybinPlayer* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_allowed_playback_speeds;
	_tmp0__length1 = self->priv->_allowed_playback_speeds_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


static gchar* rygel_playbin_player_real_get_playback_speed (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playback_speed;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_playbin_player_real_set_playback_speed (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_playback_speed);
	self->priv->_playback_speed = _tmp1_;
	g_object_notify ((GObject *) self, "playback-speed");
}


static gchar* rygel_playbin_player_real_get_uri (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_uri;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static inline void _dynamic_set_uri5 (GstElement* obj, const gchar* value) {
	g_object_set (obj, "uri", value, NULL);
}


static void rygel_playbin_player_real_set_uri (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GstElement* _tmp2_;
	GstElement* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp16_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp1_;
	_tmp2_ = self->priv->_playbin;
	gst_element_set_state (_tmp2_, GST_STATE_READY);
	_tmp3_ = self->priv->_playbin;
	_tmp4_ = value;
	_dynamic_set_uri5 (_tmp3_, _tmp4_);
	_tmp5_ = value;
	if (g_strcmp0 (_tmp5_, "") != 0) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GQuark _tmp9_ = 0U;
		static GQuark _tmp8_label0 = 0;
		static GQuark _tmp8_label1 = 0;
		static GQuark _tmp8_label2 = 0;
		static GQuark _tmp8_label3 = 0;
		static GQuark _tmp8_label4 = 0;
		_tmp6_ = self->priv->_playback_state;
		_tmp7_ = _tmp6_;
		_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
		if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("NO_MEDIA_PRESENT")))) {
			switch (0) {
				default:
				{
					gchar* _tmp10_;
					_tmp10_ = g_strdup ("STOPPED");
					_g_free0 (self->priv->_playback_state);
					self->priv->_playback_state = _tmp10_;
					g_object_notify ((GObject*) self, "playback-state");
					break;
				}
			}
		} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("STOPPED")))) {
			switch (0) {
				default:
				{
					break;
				}
			}
		} else if (_tmp9_ == ((0 != _tmp8_label2) ? _tmp8_label2 : (_tmp8_label2 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
			switch (0) {
				default:
				{
					GstElement* _tmp11_;
					GstStateChangeReturn _tmp12_ = 0;
					_tmp11_ = self->priv->_playbin;
					_tmp12_ = gst_element_set_state (_tmp11_, GST_STATE_PAUSED);
					self->priv->is_live = _tmp12_ == GST_STATE_CHANGE_NO_PREROLL;
					break;
				}
			}
		} else if ((_tmp9_ == ((0 != _tmp8_label3) ? _tmp8_label3 : (_tmp8_label3 = g_quark_from_static_string ("EOS")))) || (_tmp9_ == ((0 != _tmp8_label4) ? _tmp8_label4 : (_tmp8_label4 = g_quark_from_static_string ("PLAYING"))))) {
			switch (0) {
				default:
				{
					GstElement* _tmp13_;
					GstStateChangeReturn _tmp14_ = 0;
					_tmp13_ = self->priv->_playbin;
					_tmp14_ = gst_element_set_state (_tmp13_, GST_STATE_PLAYING);
					self->priv->is_live = _tmp14_ == GST_STATE_CHANGE_NO_PREROLL;
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					break;
				}
			}
		}
	} else {
		gchar* _tmp15_;
		_tmp15_ = g_strdup ("NO_MEDIA_PRESENT");
		_g_free0 (self->priv->_playback_state);
		self->priv->_playback_state = _tmp15_;
		g_object_notify ((GObject*) self, "playback-state");
	}
	_tmp16_ = value;
	g_debug ("rygel-playbin-player.vala:201: URI set to %s.", _tmp16_);
	g_object_notify ((GObject *) self, "uri");
}


static gchar* rygel_playbin_player_real_get_mime_type (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_mime_type;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_playbin_player_real_set_mime_type (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mime_type);
	self->priv->_mime_type = _tmp1_;
	g_object_notify ((GObject *) self, "mime-type");
}


static gchar* rygel_playbin_player_real_get_metadata (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_metadata;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_playbin_player_real_set_metadata (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_metadata);
	self->priv->_metadata = _tmp1_;
	g_object_notify ((GObject *) self, "metadata");
}


static gboolean rygel_playbin_player_real_get_can_seek (RygelMediaPlayer* base) {
	gboolean result;
	RygelPlaybinPlayer* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp6_;
	self = (RygelPlaybinPlayer*) base;
	_tmp1_ = self->priv->transfer_mode;
	if (g_strcmp0 (_tmp1_, RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE) != 0) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp2_ = rygel_media_player_get_mime_type ((RygelMediaPlayer*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = g_str_has_prefix (_tmp4_, "image/");
		_tmp0_ = !_tmp5_;
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	result = _tmp6_;
	return result;
}


static gchar* rygel_playbin_player_real_get_content_features (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_content_features;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_playbin_player_real_set_content_features (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* pi_string;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	GError * _inner_error_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = rygel_media_player_get_mime_type ((RygelMediaPlayer*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = value;
	_tmp4_ = g_strdup_printf (RYGEL_PLAYBIN_PLAYER_PROTOCOL_INFO_TEMPLATE, _tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	pi_string = _tmp5_;
	{
		GUPnPProtocolInfo* _tmp6_;
		GUPnPProtocolInfo* _tmp7_;
		GUPnPProtocolInfo* _tmp8_;
		GUPnPDLNAFlags _tmp9_;
		GUPnPDLNAFlags _tmp10_;
		GUPnPDLNAFlags flags;
		GUPnPDLNAFlags _tmp11_;
		_tmp6_ = gupnp_protocol_info_new_from_string (pi_string, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_g_object_unref0 (self->priv->protocol_info);
		self->priv->protocol_info = _tmp7_;
		_tmp8_ = self->priv->protocol_info;
		_tmp9_ = gupnp_protocol_info_get_dlna_flags (_tmp8_);
		_tmp10_ = _tmp9_;
		flags = _tmp10_;
		_tmp11_ = flags;
		if ((_tmp11_ & GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE) == GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE) {
			gchar* _tmp12_;
			_tmp12_ = g_strdup (RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE);
			_g_free0 (self->priv->transfer_mode);
			self->priv->transfer_mode = _tmp12_;
		} else {
			GUPnPDLNAFlags _tmp13_;
			_tmp13_ = flags;
			if ((_tmp13_ & GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) == GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) {
				gchar* _tmp14_;
				_tmp14_ = g_strdup (RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_STREAMING);
				_g_free0 (self->priv->transfer_mode);
				self->priv->transfer_mode = _tmp14_;
			} else {
				_g_free0 (self->priv->transfer_mode);
				self->priv->transfer_mode = NULL;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_object_unref0 (self->priv->protocol_info);
		self->priv->protocol_info = NULL;
		_g_free0 (self->priv->transfer_mode);
		self->priv->transfer_mode = NULL;
		_g_error_free0 (_error_);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_free0 (pi_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = value;
	_tmp16_ = g_strdup (_tmp15_);
	_g_free0 (self->priv->_content_features);
	self->priv->_content_features = _tmp16_;
	_g_free0 (pi_string);
	g_object_notify ((GObject *) self, "content-features");
}


static inline gdouble _dynamic_get_volume6 (GstElement* obj) {
	gdouble result;
	g_object_get (obj, "volume", &result, NULL);
	return result;
}


static gdouble rygel_playbin_player_real_get_volume (RygelMediaPlayer* base) {
	gdouble result;
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playbin;
	_tmp1_ = _dynamic_get_volume6 (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static inline void _dynamic_set_volume7 (GstElement* obj, gdouble value) {
	g_object_set (obj, "volume", value, NULL);
}


static void rygel_playbin_player_real_set_volume (RygelMediaPlayer* base, gdouble value) {
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playbin;
	_tmp1_ = value;
	_dynamic_set_volume7 (_tmp0_, _tmp1_);
	_tmp2_ = value;
	g_debug ("rygel-playbin-player.vala:269: volume set to %f.", _tmp2_);
	g_object_notify ((GObject *) self, "volume");
}


static gint64 rygel_playbin_player_real_get_duration (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 dur = 0LL;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playbin;
	_tmp2_ = gst_element_query_duration (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
	dur = _tmp1_;
	if (_tmp2_) {
		gint64 _tmp3_;
		_tmp3_ = dur;
		result = _tmp3_ / GST_USECOND;
		return result;
	} else {
		result = (gint64) 0;
		return result;
	}
}


static gint64 rygel_playbin_player_real_get_position (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 pos = 0LL;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playbin;
	_tmp2_ = gst_element_query_position (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
	pos = _tmp1_;
	if (_tmp2_) {
		gint64 _tmp3_;
		_tmp3_ = pos;
		result = _tmp3_ / GST_USECOND;
		return result;
	} else {
		result = (gint64) 0;
		return result;
	}
}


static void rygel_playbin_player_class_init (RygelPlaybinPlayerClass * klass) {
	rygel_playbin_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelPlaybinPlayerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_playbin_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_playbin_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_playbin_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBIN, g_param_spec_object ("playbin", "playbin", "playbin", gst_element_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS, g_param_spec_boxed ("allowed-playback-speeds", "allowed-playback-speeds", "allowed-playback-speeds", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED, g_param_spec_string ("playback-speed", "playback-speed", "playback-speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_CAN_SEEK, g_param_spec_boolean ("can-seek", "can-seek", "can-seek", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES, g_param_spec_string ("content-features", "content-features", "content-features", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_VOLUME, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_DURATION, g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_POSITION, g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_playbin_player_rygel_media_player_interface_init (RygelMediaPlayerIface * iface) {
	rygel_playbin_player_rygel_media_player_parent_iface = g_type_interface_peek_parent (iface);
	iface->seek = (gboolean (*)(RygelMediaPlayer*, gint64)) rygel_playbin_player_real_seek;
	iface->get_protocols = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_playbin_player_real_get_protocols;
	iface->get_mime_types = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_playbin_player_real_get_mime_types;
	iface->get_playback_state = rygel_playbin_player_real_get_playback_state;
	iface->set_playback_state = rygel_playbin_player_real_set_playback_state;
	iface->get_allowed_playback_speeds = rygel_playbin_player_real_get_allowed_playback_speeds;
	iface->get_playback_speed = rygel_playbin_player_real_get_playback_speed;
	iface->set_playback_speed = rygel_playbin_player_real_set_playback_speed;
	iface->get_uri = rygel_playbin_player_real_get_uri;
	iface->set_uri = rygel_playbin_player_real_set_uri;
	iface->get_mime_type = rygel_playbin_player_real_get_mime_type;
	iface->set_mime_type = rygel_playbin_player_real_set_mime_type;
	iface->get_metadata = rygel_playbin_player_real_get_metadata;
	iface->set_metadata = rygel_playbin_player_real_set_metadata;
	iface->get_can_seek = rygel_playbin_player_real_get_can_seek;
	iface->get_content_features = rygel_playbin_player_real_get_content_features;
	iface->set_content_features = rygel_playbin_player_real_set_content_features;
	iface->get_volume = rygel_playbin_player_real_get_volume;
	iface->set_volume = rygel_playbin_player_real_set_volume;
	iface->get_duration = rygel_playbin_player_real_get_duration;
	iface->get_position = rygel_playbin_player_real_get_position;
}


static void rygel_playbin_player_instance_init (RygelPlaybinPlayer * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	self->priv = RYGEL_PLAYBIN_PLAYER_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("NO_MEDIA_PRESENT");
	self->priv->_playback_state = _tmp0_;
	_tmp1_ = g_strdup ("1");
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	self->priv->_allowed_playback_speeds = _tmp2_;
	self->priv->_allowed_playback_speeds_length1 = 1;
	self->priv->__allowed_playback_speeds_size_ = self->priv->_allowed_playback_speeds_length1;
	_tmp3_ = g_strdup ("1");
	self->priv->_playback_speed = _tmp3_;
	self->priv->transfer_mode = NULL;
	self->priv->uri_update_hint = FALSE;
	self->priv->_uri = NULL;
	_tmp4_ = g_strdup ("");
	self->priv->_mime_type = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->priv->_metadata = _tmp5_;
	_tmp6_ = g_strdup ("");
	self->priv->_content_features = _tmp6_;
}


static void rygel_playbin_player_finalize (GObject* obj) {
	RygelPlaybinPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer);
	_g_object_unref0 (self->priv->_playbin);
	_g_free0 (self->priv->_playback_state);
	self->priv->_allowed_playback_speeds = (_vala_array_free (self->priv->_allowed_playback_speeds, self->priv->_allowed_playback_speeds_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_playback_speed);
	_g_free0 (self->priv->transfer_mode);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_metadata);
	_g_free0 (self->priv->_content_features);
	_g_object_unref0 (self->priv->protocol_info);
	G_OBJECT_CLASS (rygel_playbin_player_parent_class)->finalize (obj);
}


/**
 * Implementation of RygelMediaPlayer for GStreamer.
 *
 * This class is useful only when implementing Rygel plugins.
 */
GType rygel_playbin_player_get_type (void) {
	static volatile gsize rygel_playbin_player_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_playbin_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaybinPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playbin_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaybinPlayer), 0, (GInstanceInitFunc) rygel_playbin_player_instance_init, NULL };
		static const GInterfaceInfo rygel_media_player_info = { (GInterfaceInitFunc) rygel_playbin_player_rygel_media_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_playbin_player_type_id;
		rygel_playbin_player_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaybinPlayer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_playbin_player_type_id, RYGEL_TYPE_MEDIA_PLAYER, &rygel_media_player_info);
		g_once_init_leave (&rygel_playbin_player_type_id__volatile, rygel_playbin_player_type_id);
	}
	return rygel_playbin_player_type_id__volatile;
}


static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer);
	switch (property_id) {
		case RYGEL_PLAYBIN_PLAYER_PLAYBIN:
		g_value_set_object (value, rygel_playbin_player_get_playbin (self));
		break;
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
		g_value_take_string (value, rygel_media_player_get_playback_state ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS:
		{
			int length;
			g_value_take_boxed (value, rygel_media_player_get_allowed_playback_speeds ((RygelMediaPlayer*) self, &length));
		}
		break;
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED:
		g_value_take_string (value, rygel_media_player_get_playback_speed ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_URI:
		g_value_take_string (value, rygel_media_player_get_uri ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_MIME_TYPE:
		g_value_take_string (value, rygel_media_player_get_mime_type ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_METADATA:
		g_value_take_string (value, rygel_media_player_get_metadata ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_CAN_SEEK:
		g_value_set_boolean (value, rygel_media_player_get_can_seek ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES:
		g_value_take_string (value, rygel_media_player_get_content_features ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
		g_value_set_double (value, rygel_media_player_get_volume ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_DURATION:
		g_value_set_int64 (value, rygel_media_player_get_duration ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_POSITION:
		g_value_set_int64 (value, rygel_media_player_get_position ((RygelMediaPlayer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer);
	switch (property_id) {
		case RYGEL_PLAYBIN_PLAYER_PLAYBIN:
		rygel_playbin_player_set_playbin (self, g_value_get_object (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
		rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED:
		rygel_media_player_set_playback_speed ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_URI:
		rygel_media_player_set_uri ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_MIME_TYPE:
		rygel_media_player_set_mime_type ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_METADATA:
		rygel_media_player_set_metadata ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES:
		rygel_media_player_set_content_features ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
		rygel_media_player_set_volume ((RygelMediaPlayer*) self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



