/* minefield-view.c generated by valac 0.19.0, the Vala compiler
 * generated from minefield-view.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <librsvg/rsvg.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <glib/gi18n-lib.h>


#define TYPE_POSITION (position_get_type ())
#define POSITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POSITION, Position))
#define POSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POSITION, PositionClass))
#define IS_POSITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POSITION))
#define IS_POSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POSITION))
#define POSITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POSITION, PositionClass))

typedef struct _Position Position;
typedef struct _PositionClass PositionClass;
typedef struct _PositionPrivate PositionPrivate;

#define TYPE_MINEFIELD_VIEW (minefield_view_get_type ())
#define MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD_VIEW, MinefieldView))
#define MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD_VIEW, MinefieldViewClass))
#define IS_MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD_VIEW))
#define IS_MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD_VIEW))
#define MINEFIELD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD_VIEW, MinefieldViewClass))

typedef struct _MinefieldView MinefieldView;
typedef struct _MinefieldViewClass MinefieldViewClass;
typedef struct _MinefieldViewPrivate MinefieldViewPrivate;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _minefield_unref0(var) ((var == NULL) ? NULL : (var = (minefield_unref (var), NULL)))
typedef struct _MinefieldPrivate MinefieldPrivate;

#define TYPE_FLAG_TYPE (flag_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define __vala_PangoAttrList_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoAttrList_free (var), NULL)))

#define TYPE_NEIGHBOUR (neighbour_get_type ())
typedef struct _Neighbour Neighbour;

struct _Position {
	GObject parent_instance;
	PositionPrivate * priv;
};

struct _PositionClass {
	GObjectClass parent_class;
};

struct _PositionPrivate {
	gboolean _is_set;
	gint _x;
	gint _y;
};

struct _MinefieldView {
	GtkDrawingArea parent_instance;
	MinefieldViewPrivate * priv;
};

struct _MinefieldViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _MinefieldViewPrivate {
	gboolean use_question_marks;
	gboolean use_overmine_warning;
	gboolean use_autoflag;
	Position* keyboard_cursor;
	Position* selected;
	gboolean use_number_border;
	guint render_size;
	cairo_pattern_t* flag_pattern;
	cairo_pattern_t* mine_pattern;
	cairo_pattern_t* question_pattern;
	cairo_pattern_t* bang_pattern;
	cairo_pattern_t* warning_pattern;
	cairo_pattern_t** number_patterns;
	gint number_patterns_length1;
	gint _number_patterns_size_;
	Minefield* _minefield;
};

struct _Minefield {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	gboolean exploded;
};

struct _MinefieldClass {
	GTypeClass parent_class;
	void (*finalize) (Minefield *self);
};

typedef enum  {
	FLAG_TYPE_NONE,
	FLAG_TYPE_FLAG,
	FLAG_TYPE_MAYBE
} FlagType;

struct _Neighbour {
	gint x;
	gint y;
};


static gpointer position_parent_class = NULL;
static gpointer minefield_view_parent_class = NULL;

GType position_get_type (void) G_GNUC_CONST;
#define POSITION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_POSITION, PositionPrivate))
enum  {
	POSITION_DUMMY_PROPERTY,
	POSITION_IS_SET,
	POSITION_IS_VALID,
	POSITION_X,
	POSITION_Y
};
Position* position_new (void);
Position* position_construct (GType object_type);
gboolean position_get_is_set (Position* self);
void position_set_is_set (Position* self, gboolean value);
gboolean position_get_is_valid (Position* self);
gint position_get_x (Position* self);
gint position_get_y (Position* self);
void position_set_x (Position* self, gint value);
void position_set_y (Position* self, gint value);
void position_set_position (Position* self, gint* value, int value_length1);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_INT__INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void position_finalize (GObject* obj);
static void _vala_position_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_position_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType minefield_view_get_type (void) G_GNUC_CONST;
gpointer minefield_ref (gpointer instance);
void minefield_unref (gpointer instance);
GParamSpec* param_spec_minefield (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_minefield (GValue* value, gpointer v_object);
void value_take_minefield (GValue* value, gpointer v_object);
gpointer value_get_minefield (const GValue* value);
GType minefield_get_type (void) G_GNUC_CONST;
#define MINEFIELD_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MINEFIELD_VIEW, MinefieldViewPrivate))
enum  {
	MINEFIELD_VIEW_DUMMY_PROPERTY,
	MINEFIELD_VIEW_MINEFIELD
};
MinefieldView* minefield_view_new (void);
MinefieldView* minefield_view_construct (GType object_type);
void minefield_view_set_use_question_marks (MinefieldView* self, gboolean use_question_marks);
void minefield_view_set_use_overmine_warning (MinefieldView* self, gboolean use_overmine_warning);
void minefield_view_set_use_autoflag (MinefieldView* self, gboolean use_autoflag);
void minefield_view_set_use_number_border (MinefieldView* self, gboolean use_number_border);
static void minefield_view_explode_cb (MinefieldView* self, Minefield* minefield);
gboolean minefield_has_mine (Minefield* self, guint x, guint y);
GType flag_type_get_type (void) G_GNUC_CONST;
FlagType minefield_get_flag (Minefield* self, guint x, guint y);
static void minefield_view_redraw_sector_cb (MinefieldView* self, guint x, guint y);
static cairo_pattern_t* minefield_view_render_svg_pattern (MinefieldView* self, cairo_t* cr, const gchar* filename);
static guint minefield_view_get_mine_size (MinefieldView* self);
static cairo_pattern_t* minefield_view_render_number_pattern (MinefieldView* self, guint n);
static PangoAttrList* _vala_PangoAttrList_copy (PangoAttrList* self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void _vala_PangoAttrList_free (PangoAttrList* self);
static void minefield_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
Minefield* minefield_view_get_minefield (MinefieldView* self);
static guint minefield_view_get_minimum_size (MinefieldView* self);
static void minefield_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static guint minefield_view_get_x_offset (MinefieldView* self);
static guint minefield_view_get_y_offset (MinefieldView* self);
static void minefield_view_draw_square (MinefieldView* self, cairo_t* cr, guint x, guint y);
gboolean minefield_is_cleared (Minefield* self, guint x, guint y);
GType neighbour_get_type (void) G_GNUC_CONST;
Neighbour* neighbour_dup (const Neighbour* self);
void neighbour_free (Neighbour* self);
gboolean minefield_is_location (Minefield* self, gint x, gint y);
gboolean minefield_get_paused (Minefield* self);
gboolean minefield_has_flag_warning (Minefield* self, guint x, guint y);
guint minefield_get_n_adjacent_mines (Minefield* self, guint x, guint y);
static gboolean minefield_view_real_draw (GtkWidget* base, cairo_t* cr);
static void minefield_view_toggle_mark (MinefieldView* self, guint x, guint y);
guint minefield_get_n_flags (Minefield* self);
void minefield_set_flag (Minefield* self, guint x, guint y, FlagType flag);
static void minefield_view_redraw_adjacent (MinefieldView* self, guint x, guint y);
static void minefield_view_multi_release (MinefieldView* self, guint x, guint y);
void minefield_clear_mine (Minefield* self, guint x, guint y);
static gboolean minefield_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gboolean minefield_get_is_complete (Minefield* self);
static gboolean minefield_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
static gboolean minefield_view_real_button_release_event (GtkWidget* base, GdkEventButton* event);
static gboolean minefield_view_real_key_press_event (GtkWidget* base, GdkEventKey* event);
static gboolean minefield_view_real_key_release_event (GtkWidget* base, GdkEventKey* event);
void minefield_view_set_minefield (MinefieldView* self, Minefield* value);
static void _minefield_view_redraw_sector_cb_position_redraw (Position* _sender, guint x, guint y, gpointer self);
static void _minefield_view_minefield___lambda2_ (MinefieldView* self, guint x, guint y);
static void __minefield_view_minefield___lambda2__position_redraw (Position* _sender, guint x, guint y, gpointer self);
static gint _minefield_view_minefield___lambda3_ (MinefieldView* self, gint x);
static gint __minefield_view_minefield___lambda3__position_set_x (Position* _sender, gint x, gpointer self);
static gint _minefield_view_minefield___lambda4_ (MinefieldView* self, gint y);
static gint __minefield_view_minefield___lambda4__position_set_y (Position* _sender, gint y, gpointer self);
static gboolean _minefield_is_location_position_validate (Position* _sender, gint x, gint y, gpointer self);
static gint _minefield_view_minefield___lambda5_ (MinefieldView* self, gint x);
static gint __minefield_view_minefield___lambda5__position_set_x (Position* _sender, gint x, gpointer self);
static gint _minefield_view_minefield___lambda6_ (MinefieldView* self, gint y);
static gint __minefield_view_minefield___lambda6__position_set_y (Position* _sender, gint y, gpointer self);
static gboolean _minefield_view_minefield___lambda7_ (MinefieldView* self, gint x, gint y);
static gboolean __minefield_view_minefield___lambda7__position_validate (Position* _sender, gint x, gint y, gpointer self);
static void _minefield_view_redraw_sector_cb_minefield_redraw_sector (Minefield* _sender, guint x, guint y, gpointer self);
static void _minefield_view_explode_cb_minefield_explode (Minefield* _sender, gpointer self);
static void _minefield_view_minefield___lambda8_ (MinefieldView* self);
static void __minefield_view_minefield___lambda8__minefield_paused_changed (Minefield* _sender, gpointer self);
static void minefield_view_finalize (GObject* obj);
static void _vala_minefield_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_minefield_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

extern const Neighbour neighbour_map[8];

Position* position_construct (GType object_type) {
	Position * self = NULL;
	self = (Position*) g_object_new (object_type, NULL);
	return self;
}


Position* position_new (void) {
	return position_construct (TYPE_POSITION);
}


gboolean position_get_is_set (Position* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_set;
	result = _tmp0_;
	return result;
}


void position_set_is_set (Position* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp5_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_is_set;
	_tmp2_ = value;
	if (_tmp1_ != _tmp2_) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = position_get_is_valid (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp6_ = position_get_x (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = position_get_y (self);
		_tmp9_ = _tmp8_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp7_, (guint) _tmp9_);
	}
	_tmp10_ = value;
	self->priv->_is_set = _tmp10_;
	g_object_notify ((GObject *) self, "is-set");
}


gboolean position_get_is_valid (Position* self) {
	gboolean result;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = position_get_x (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = position_get_y (self);
	_tmp3_ = _tmp2_;
	g_signal_emit_by_name (self, "validate", _tmp1_, _tmp3_, &_tmp4_);
	result = _tmp4_;
	return result;
}


gint position_get_x (Position* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_x;
	result = _tmp0_;
	return result;
}


void position_set_x (Position* self, gint value) {
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp7_;
	gint _tmp12_;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_x;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp3_ = position_get_is_set (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = position_get_is_valid (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp8_ = position_get_x (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = position_get_y (self);
		_tmp11_ = _tmp10_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp9_, (guint) _tmp11_);
	}
	_tmp12_ = value;
	g_signal_emit_by_name (self, "set-x", _tmp12_, &_tmp13_);
	self->priv->_x = _tmp13_;
	_tmp15_ = position_get_is_set (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp17_ = position_get_is_valid (self);
		_tmp18_ = _tmp17_;
		_tmp14_ = _tmp18_;
	} else {
		_tmp14_ = FALSE;
	}
	_tmp19_ = _tmp14_;
	if (_tmp19_) {
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp20_ = position_get_x (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = position_get_y (self);
		_tmp23_ = _tmp22_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp21_, (guint) _tmp23_);
	}
	g_object_notify ((GObject *) self, "x");
}


gint position_get_y (Position* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_y;
	result = _tmp0_;
	return result;
}


void position_set_y (Position* self, gint value) {
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp7_;
	gint _tmp12_;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_y;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp3_ = position_get_is_set (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = position_get_is_valid (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp8_ = position_get_x (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = position_get_y (self);
		_tmp11_ = _tmp10_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp9_, (guint) _tmp11_);
	}
	_tmp12_ = value;
	g_signal_emit_by_name (self, "set-y", _tmp12_, &_tmp13_);
	self->priv->_y = _tmp13_;
	_tmp15_ = position_get_is_set (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp17_ = position_get_is_valid (self);
		_tmp18_ = _tmp17_;
		_tmp14_ = _tmp18_;
	} else {
		_tmp14_ = FALSE;
	}
	_tmp19_ = _tmp14_;
	if (_tmp19_) {
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp20_ = position_get_x (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = position_get_y (self);
		_tmp23_ = _tmp22_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp21_, (guint) _tmp23_);
	}
	g_object_notify ((GObject *) self, "y");
}


void position_set_position (Position* self, gint* value, int value_length1) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gboolean _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp13_;
	gint* _tmp18_;
	gint _tmp18__length1;
	gint _tmp19_;
	gint _tmp20_ = 0;
	gint* _tmp21_;
	gint _tmp21__length1;
	gint _tmp22_;
	gint _tmp23_ = 0;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_x;
	_tmp2_ = value;
	_tmp2__length1 = value_length1;
	_tmp3_ = _tmp2_[0];
	if (_tmp1_ == _tmp3_) {
		gint _tmp4_;
		gint* _tmp5_;
		gint _tmp5__length1;
		gint _tmp6_;
		_tmp4_ = self->priv->_y;
		_tmp5_ = value;
		_tmp5__length1 = value_length1;
		_tmp6_ = _tmp5_[1];
		_tmp0_ = _tmp4_ == _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		return;
	}
	_tmp9_ = position_get_is_set (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp11_ = position_get_is_valid (self);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp13_ = _tmp8_;
	if (_tmp13_) {
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp14_ = position_get_x (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = position_get_y (self);
		_tmp17_ = _tmp16_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp15_, (guint) _tmp17_);
	}
	_tmp18_ = value;
	_tmp18__length1 = value_length1;
	_tmp19_ = _tmp18_[0];
	g_signal_emit_by_name (self, "set-x", _tmp19_, &_tmp20_);
	self->priv->_x = _tmp20_;
	_tmp21_ = value;
	_tmp21__length1 = value_length1;
	_tmp22_ = _tmp21_[1];
	g_signal_emit_by_name (self, "set-y", _tmp22_, &_tmp23_);
	self->priv->_y = _tmp23_;
	_tmp25_ = position_get_is_set (self);
	_tmp26_ = _tmp25_;
	if (_tmp26_) {
		gboolean _tmp27_;
		gboolean _tmp28_;
		_tmp27_ = position_get_is_valid (self);
		_tmp28_ = _tmp27_;
		_tmp24_ = _tmp28_;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp29_ = _tmp24_;
	if (_tmp29_) {
		gint _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		_tmp30_ = position_get_x (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = position_get_y (self);
		_tmp33_ = _tmp32_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp31_, (guint) _tmp33_);
	}
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_BOOLEAN__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__INT_INT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_INT__INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gint (*GMarshalFunc_INT__INT) (gpointer data1, gint arg_1, gpointer data2);
	register GMarshalFunc_INT__INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gint v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_INT__INT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_int (param_values + 1), data2);
	g_value_set_int (return_value, v_return);
}


static void position_class_init (PositionClass * klass) {
	position_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PositionPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_position_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_position_set_property;
	G_OBJECT_CLASS (klass)->finalize = position_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_IS_SET, g_param_spec_boolean ("is-set", "is-set", "is-set", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_IS_VALID, g_param_spec_boolean ("is-valid", "is-valid", "is-valid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_X, g_param_spec_int ("x", "x", "x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_Y, g_param_spec_int ("y", "y", "y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("redraw", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("validate", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__INT_INT, G_TYPE_BOOLEAN, 2, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("set_x", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_INT__INT, G_TYPE_INT, 1, G_TYPE_INT);
	g_signal_new ("set_y", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_INT__INT, G_TYPE_INT, 1, G_TYPE_INT);
}


static void position_instance_init (Position * self) {
	self->priv = POSITION_GET_PRIVATE (self);
	self->priv->_is_set = FALSE;
	self->priv->_x = 0;
	self->priv->_y = 0;
}


static void position_finalize (GObject* obj) {
	Position * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_POSITION, Position);
	G_OBJECT_CLASS (position_parent_class)->finalize (obj);
}


GType position_get_type (void) {
	static volatile gsize position_type_id__volatile = 0;
	if (g_once_init_enter (&position_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PositionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) position_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Position), 0, (GInstanceInitFunc) position_instance_init, NULL };
		GType position_type_id;
		position_type_id = g_type_register_static (G_TYPE_OBJECT, "Position", &g_define_type_info, 0);
		g_once_init_leave (&position_type_id__volatile, position_type_id);
	}
	return position_type_id__volatile;
}


static void _vala_position_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Position * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POSITION, Position);
	switch (property_id) {
		case POSITION_IS_SET:
		g_value_set_boolean (value, position_get_is_set (self));
		break;
		case POSITION_IS_VALID:
		g_value_set_boolean (value, position_get_is_valid (self));
		break;
		case POSITION_X:
		g_value_set_int (value, position_get_x (self));
		break;
		case POSITION_Y:
		g_value_set_int (value, position_get_y (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_position_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Position * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POSITION, Position);
	switch (property_id) {
		case POSITION_IS_SET:
		position_set_is_set (self, g_value_get_boolean (value));
		break;
		case POSITION_X:
		position_set_x (self, g_value_get_int (value));
		break;
		case POSITION_Y:
		position_set_y (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


MinefieldView* minefield_view_construct (GType object_type) {
	MinefieldView * self = NULL;
	Position* _tmp0_;
	Position* _tmp1_;
	cairo_pattern_t** _tmp2_ = NULL;
	self = (MinefieldView*) g_object_new (object_type, NULL);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_KEY_PRESS_MASK) | GDK_KEY_RELEASE_MASK));
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
	_tmp0_ = position_new ();
	_g_object_unref0 (self->priv->selected);
	self->priv->selected = _tmp0_;
	_tmp1_ = position_new ();
	_g_object_unref0 (self->priv->keyboard_cursor);
	self->priv->keyboard_cursor = _tmp1_;
	_tmp2_ = g_new0 (cairo_pattern_t*, 8 + 1);
	self->priv->number_patterns = (_vala_array_free (self->priv->number_patterns, self->priv->number_patterns_length1, (GDestroyNotify) cairo_pattern_destroy), NULL);
	self->priv->number_patterns = _tmp2_;
	self->priv->number_patterns_length1 = 8;
	self->priv->_number_patterns_size_ = self->priv->number_patterns_length1;
	return self;
}


MinefieldView* minefield_view_new (void) {
	return minefield_view_construct (TYPE_MINEFIELD_VIEW);
}


void minefield_view_set_use_question_marks (MinefieldView* self, gboolean use_question_marks) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_question_marks;
	self->priv->use_question_marks = _tmp0_;
}


void minefield_view_set_use_overmine_warning (MinefieldView* self, gboolean use_overmine_warning) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_overmine_warning;
	self->priv->use_overmine_warning = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void minefield_view_set_use_autoflag (MinefieldView* self, gboolean use_autoflag) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_autoflag;
	self->priv->use_autoflag = _tmp0_;
}


void minefield_view_set_use_number_border (MinefieldView* self, gboolean use_number_border) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->use_number_border;
	_tmp1_ = use_number_border;
	if (_tmp0_ != _tmp1_) {
		self->priv->render_size = (guint) 0;
	}
	_tmp2_ = use_number_border;
	self->priv->use_number_border = _tmp2_;
}


static void minefield_view_explode_cb (MinefieldView* self, Minefield* minefield) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	{
		gint x;
		x = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				Minefield* _tmp4_;
				guint _tmp5_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				_tmp4_ = minefield;
				_tmp5_ = _tmp4_->width;
				if (!(((guint) _tmp3_) < _tmp5_)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp6_;
						_tmp6_ = TRUE;
						while (TRUE) {
							gboolean _tmp7_;
							gint _tmp9_;
							Minefield* _tmp10_;
							guint _tmp11_;
							gboolean _tmp12_ = FALSE;
							Minefield* _tmp13_;
							gint _tmp14_;
							gint _tmp15_;
							gboolean _tmp16_ = FALSE;
							gboolean _tmp27_;
							_tmp7_ = _tmp6_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = y;
								y = _tmp8_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp9_ = y;
							_tmp10_ = minefield;
							_tmp11_ = _tmp10_->height;
							if (!(((guint) _tmp9_) < _tmp11_)) {
								break;
							}
							_tmp13_ = minefield;
							_tmp14_ = x;
							_tmp15_ = y;
							_tmp16_ = minefield_has_mine (_tmp13_, (guint) _tmp14_, (guint) _tmp15_);
							if (_tmp16_) {
								_tmp12_ = TRUE;
							} else {
								gboolean _tmp17_ = FALSE;
								Minefield* _tmp18_;
								gint _tmp19_;
								gint _tmp20_;
								gboolean _tmp21_ = FALSE;
								gboolean _tmp26_;
								_tmp18_ = minefield;
								_tmp19_ = x;
								_tmp20_ = y;
								_tmp21_ = minefield_has_mine (_tmp18_, (guint) _tmp19_, (guint) _tmp20_);
								if (!_tmp21_) {
									Minefield* _tmp22_;
									gint _tmp23_;
									gint _tmp24_;
									FlagType _tmp25_ = 0;
									_tmp22_ = minefield;
									_tmp23_ = x;
									_tmp24_ = y;
									_tmp25_ = minefield_get_flag (_tmp22_, (guint) _tmp23_, (guint) _tmp24_);
									_tmp17_ = _tmp25_ == FLAG_TYPE_FLAG;
								} else {
									_tmp17_ = FALSE;
								}
								_tmp26_ = _tmp17_;
								_tmp12_ = _tmp26_;
							}
							_tmp27_ = _tmp12_;
							if (_tmp27_) {
								gint _tmp28_;
								gint _tmp29_;
								_tmp28_ = x;
								_tmp29_ = y;
								minefield_view_redraw_sector_cb (self, (guint) _tmp28_, (guint) _tmp29_);
							}
						}
					}
				}
			}
		}
	}
}


static cairo_pattern_t* minefield_view_render_svg_pattern (MinefieldView* self, cairo_t* cr, const gchar* filename) {
	cairo_pattern_t* result = NULL;
	cairo_t* _tmp0_;
	cairo_surface_t* _tmp1_ = NULL;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	cairo_surface_t* _tmp6_;
	cairo_surface_t* surface;
	cairo_t* _tmp7_;
	cairo_t* c;
	GdkPixbuf* pixbuf = NULL;
	guint _tmp8_;
	guint _tmp9_;
	gint size;
	GdkPixbuf* _tmp14_;
	cairo_pattern_t* _tmp15_;
	cairo_pattern_t* pattern;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cr != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = cr;
	_tmp1_ = cairo_get_target (_tmp0_);
	_tmp2_ = minefield_view_get_mine_size (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = minefield_view_get_mine_size (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = cairo_surface_create_similar (_tmp1_, CAIRO_CONTENT_COLOR_ALPHA, (gint) _tmp3_, (gint) _tmp5_);
	surface = _tmp6_;
	_tmp7_ = cairo_create (surface);
	c = _tmp7_;
	_tmp8_ = minefield_view_get_mine_size (self);
	_tmp9_ = _tmp8_;
	size = ((gint) _tmp9_) - 2;
	{
		const gchar* _tmp10_;
		GdkPixbuf* _tmp11_ = NULL;
		GdkPixbuf* _tmp12_;
		_tmp10_ = filename;
		_tmp11_ = rsvg_pixbuf_from_file_at_size (_tmp10_, size, size, &_inner_error_);
		_tmp12_ = _tmp11_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp12_;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GdkPixbuf* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, size, size);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp13_;
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pixbuf);
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (surface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp14_ = pixbuf;
	gdk_cairo_set_source_pixbuf (c, _tmp14_, (gdouble) 1, (gdouble) 1);
	cairo_paint (c);
	_tmp15_ = cairo_pattern_create_for_surface (surface);
	pattern = _tmp15_;
	cairo_pattern_set_extend (pattern, CAIRO_EXTEND_REPEAT);
	result = pattern;
	_g_object_unref0 (pixbuf);
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (surface);
	return result;
}


static PangoAttrList* _vala_PangoAttrList_copy (PangoAttrList* self) {
	return g_boxed_copy (pango_attr_list_get_type (), self);
}


static gpointer __vala_PangoAttrList_copy0 (gpointer self) {
	return self ? _vala_PangoAttrList_copy (self) : NULL;
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


static void _vala_PangoAttrList_free (PangoAttrList* self) {
	g_boxed_free (pango_attr_list_get_type (), self);
}


static cairo_pattern_t* minefield_view_render_number_pattern (MinefieldView* self, guint n) {
	cairo_pattern_t* result = NULL;
	guint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	PangoLayout* _tmp3_ = NULL;
	PangoLayout* _tmp4_;
	PangoLayout* layout;
	PangoLayout* _tmp5_;
	PangoAttrList* _tmp6_;
	PangoAttrList* attributes;
	PangoAttribute* color_attribute = NULL;
	gdouble color_outline[3] = {0};
	guint _tmp7_;
	PangoAttribute* _tmp24_;
	PangoAttribute* _tmp25_;
	guint _tmp26_;
	PangoAttrList* _tmp27_;
	PangoAttribute* _tmp28_;
	PangoFontDescription* _tmp29_;
	PangoFontDescription* font_desc;
	PangoFontDescription* _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	gdouble font_size;
	PangoFontDescription* _tmp33_;
	gdouble _tmp34_;
	PangoFontDescription* _tmp35_;
	PangoFontDescription* _tmp36_;
	PangoAttrFontDesc* _tmp37_;
	PangoAttrFontDesc* font_attribute;
	PangoAttrFontDesc* _tmp38_;
	PangoAttrFontDesc* _tmp39_;
	guint _tmp40_;
	PangoAttrList* _tmp41_;
	PangoAttrFontDesc* _tmp42_;
	PangoLayout* _tmp43_;
	PangoAttrList* _tmp44_;
	PangoAttrList* _tmp45_;
	guint _tmp46_;
	guint _tmp47_;
	guint _tmp48_;
	guint _tmp49_;
	cairo_surface_t* _tmp50_;
	cairo_surface_t* surface;
	cairo_surface_t* _tmp51_;
	cairo_t* _tmp52_;
	cairo_t* c;
	PangoRectangle extent = {0};
	PangoLayout* _tmp53_;
	PangoRectangle _tmp54_ = {0};
	guint _tmp55_;
	guint _tmp56_;
	PangoRectangle _tmp57_;
	gint _tmp58_;
	gint dx;
	guint _tmp59_;
	guint _tmp60_;
	PangoRectangle _tmp61_;
	gint _tmp62_;
	gint dy;
	cairo_t* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	cairo_t* _tmp66_;
	PangoLayout* _tmp67_;
	gboolean _tmp68_;
	cairo_surface_t* _tmp79_;
	cairo_pattern_t* _tmp80_;
	cairo_pattern_t* pattern;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = n;
	_tmp1_ = g_strdup_printf ("%u", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	layout = _tmp4_;
	_tmp5_ = layout;
	pango_layout_set_alignment (_tmp5_, PANGO_ALIGN_CENTER);
	_tmp6_ = pango_attr_list_new ();
	attributes = _tmp6_;
	_tmp7_ = n;
	switch (_tmp7_) {
		case 1:
		{
			PangoAttribute* _tmp8_ = NULL;
			gdouble _tmp9_[3] = {0};
			_tmp8_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0x0000, (guint16) 0xffff);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp8_;
			_tmp9_[0] = 0.0;
			_tmp9_[1] = 0.0;
			_tmp9_[2] = 0.5;
			memcpy (color_outline, _tmp9_, 3 * sizeof (gdouble));
			break;
		}
		case 2:
		{
			PangoAttribute* _tmp10_ = NULL;
			gdouble _tmp11_[3] = {0};
			_tmp10_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0xa0a0, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp10_;
			_tmp11_[0] = 0.0;
			_tmp11_[1] = 0.5 * 0.62745098039;
			_tmp11_[2] = 0.0;
			memcpy (color_outline, _tmp11_, 3 * sizeof (gdouble));
			break;
		}
		case 3:
		{
			PangoAttribute* _tmp12_ = NULL;
			gdouble _tmp13_[3] = {0};
			_tmp12_ = pango_attr_foreground_new ((guint16) 0xffff, (guint16) 0x0000, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp12_;
			_tmp13_[0] = 0.5;
			_tmp13_[1] = 0.0;
			_tmp13_[2] = 0.0;
			memcpy (color_outline, _tmp13_, 3 * sizeof (gdouble));
			break;
		}
		case 4:
		{
			PangoAttribute* _tmp14_ = NULL;
			gdouble _tmp15_[3] = {0};
			_tmp14_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0x0000, (guint16) 0x7fff);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp14_;
			_tmp15_[0] = 0.0;
			_tmp15_[1] = 0.0;
			_tmp15_[2] = 0.5 * 0.49999237048;
			memcpy (color_outline, _tmp15_, 3 * sizeof (gdouble));
			break;
		}
		case 5:
		{
			PangoAttribute* _tmp16_ = NULL;
			gdouble _tmp17_[3] = {0};
			_tmp16_ = pango_attr_foreground_new ((guint16) 0xa0a0, (guint16) 0x0000, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp16_;
			_tmp17_[0] = 0.5 * 0.62745098039;
			_tmp17_[1] = 0.0;
			_tmp17_[2] = 0.0;
			memcpy (color_outline, _tmp17_, 3 * sizeof (gdouble));
			break;
		}
		case 6:
		{
			PangoAttribute* _tmp18_ = NULL;
			gdouble _tmp19_[3] = {0};
			_tmp18_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0xffff, (guint16) 0xffff);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp18_;
			_tmp19_[0] = 0.0;
			_tmp19_[1] = 0.5;
			_tmp19_[2] = 0.5;
			memcpy (color_outline, _tmp19_, 3 * sizeof (gdouble));
			break;
		}
		case 7:
		{
			PangoAttribute* _tmp20_ = NULL;
			gdouble _tmp21_[3] = {0};
			_tmp20_ = pango_attr_foreground_new ((guint16) 0xa0a0, (guint16) 0x0000, (guint16) 0xa0a0);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp20_;
			_tmp21_[0] = 0.5 * 0.62745098039;
			_tmp21_[1] = 0.0;
			_tmp21_[2] = 0.5 * 0.62745098039;
			memcpy (color_outline, _tmp21_, 3 * sizeof (gdouble));
			break;
		}
		default:
		case 8:
		{
			PangoAttribute* _tmp22_ = NULL;
			gdouble _tmp23_[3] = {0};
			_tmp22_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0x0000, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp22_;
			_tmp23_[0] = 0.0;
			_tmp23_[1] = 0.0;
			_tmp23_[2] = 0.0;
			memcpy (color_outline, _tmp23_, 3 * sizeof (gdouble));
			break;
		}
	}
	_tmp24_ = color_attribute;
	_tmp24_->start_index = (guint) 0;
	_tmp25_ = color_attribute;
	_tmp26_ = G_MAXUINT;
	_tmp25_->end_index = _tmp26_;
	_tmp27_ = attributes;
	_tmp28_ = color_attribute;
	color_attribute = NULL;
	pango_attr_list_insert (_tmp27_, _tmp28_);
	_tmp29_ = pango_font_description_new ();
	font_desc = _tmp29_;
	_tmp30_ = font_desc;
	pango_font_description_set_family (_tmp30_, "Sans");
	_tmp31_ = minefield_view_get_mine_size (self);
	_tmp32_ = _tmp31_;
	font_size = ((_tmp32_ - 2) * PANGO_SCALE) * 0.85;
	_tmp33_ = font_desc;
	_tmp34_ = font_size;
	pango_font_description_set_absolute_size (_tmp33_, _tmp34_);
	_tmp35_ = font_desc;
	pango_font_description_set_weight (_tmp35_, PANGO_WEIGHT_BOLD);
	_tmp36_ = font_desc;
	_tmp37_ = (PangoAttrFontDesc*) pango_attr_font_desc_new (_tmp36_);
	font_attribute = _tmp37_;
	_tmp38_ = font_attribute;
	((PangoAttribute*) _tmp38_)->start_index = (guint) 0;
	_tmp39_ = font_attribute;
	_tmp40_ = G_MAXUINT;
	((PangoAttribute*) _tmp39_)->end_index = _tmp40_;
	_tmp41_ = attributes;
	_tmp42_ = font_attribute;
	font_attribute = NULL;
	pango_attr_list_insert (_tmp41_, (PangoAttribute*) _tmp42_);
	_tmp43_ = layout;
	_tmp44_ = attributes;
	_tmp45_ = __vala_PangoAttrList_copy0 (_tmp44_);
	pango_layout_set_attributes (_tmp43_, _tmp45_);
	_tmp46_ = minefield_view_get_mine_size (self);
	_tmp47_ = _tmp46_;
	_tmp48_ = minefield_view_get_mine_size (self);
	_tmp49_ = _tmp48_;
	_tmp50_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, (gint) _tmp47_, (gint) _tmp49_);
	surface = _tmp50_;
	_tmp51_ = surface;
	_tmp52_ = cairo_create (_tmp51_);
	c = _tmp52_;
	_tmp53_ = layout;
	pango_layout_get_extents (_tmp53_, NULL, &_tmp54_);
	extent = _tmp54_;
	_tmp55_ = minefield_view_get_mine_size (self);
	_tmp56_ = _tmp55_;
	_tmp57_ = extent;
	_tmp58_ = _tmp57_.width;
	dx = (((((gint) _tmp56_) - 2) - (_tmp58_ / PANGO_SCALE)) / 2) + 1;
	_tmp59_ = minefield_view_get_mine_size (self);
	_tmp60_ = _tmp59_;
	_tmp61_ = extent;
	_tmp62_ = _tmp61_.height;
	dy = (((((gint) _tmp60_) - 2) - (_tmp62_ / PANGO_SCALE)) / 2) + 1;
	_tmp63_ = c;
	_tmp64_ = dx;
	_tmp65_ = dy;
	cairo_move_to (_tmp63_, (gdouble) _tmp64_, (gdouble) _tmp65_);
	_tmp66_ = c;
	_tmp67_ = layout;
	pango_cairo_show_layout (_tmp66_, _tmp67_);
	_tmp68_ = self->priv->use_number_border;
	if (_tmp68_) {
		cairo_t* _tmp69_;
		cairo_t* _tmp70_;
		cairo_t* _tmp71_;
		gdouble _tmp72_;
		gdouble _tmp73_;
		gdouble _tmp74_;
		cairo_t* _tmp75_;
		PangoLayout* _tmp76_;
		cairo_t* _tmp77_;
		cairo_t* _tmp78_;
		_tmp69_ = c;
		cairo_save (_tmp69_);
		_tmp70_ = c;
		cairo_set_line_width (_tmp70_, 1.0);
		_tmp71_ = c;
		_tmp72_ = color_outline[0];
		_tmp73_ = color_outline[1];
		_tmp74_ = color_outline[2];
		cairo_set_source_rgb (_tmp71_, _tmp72_, _tmp73_, _tmp74_);
		_tmp75_ = c;
		_tmp76_ = layout;
		pango_cairo_layout_path (_tmp75_, _tmp76_);
		_tmp77_ = c;
		cairo_stroke_preserve (_tmp77_);
		_tmp78_ = c;
		cairo_restore (_tmp78_);
	}
	_tmp79_ = surface;
	_tmp80_ = cairo_pattern_create_for_surface (_tmp79_);
	pattern = _tmp80_;
	cairo_pattern_set_extend (pattern, CAIRO_EXTEND_REPEAT);
	result = pattern;
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (surface);
	_pango_attribute_destroy0 (font_attribute);
	__vala_PangoFontDescription_free0 (font_desc);
	_pango_attribute_destroy0 (color_attribute);
	__vala_PangoAttrList_free0 (attributes);
	_g_object_unref0 (layout);
	return result;
}


static void minefield_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	MinefieldView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	Minefield* _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	self = (MinefieldView*) base;
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->width;
	_tmp3_ = minefield_view_get_minimum_size (self);
	_tmp4_ = _tmp3_;
	_vala_natural = (gint) (_tmp2_ * _tmp4_);
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void minefield_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	MinefieldView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	Minefield* _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	self = (MinefieldView*) base;
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->height;
	_tmp3_ = minefield_view_get_minimum_size (self);
	_tmp4_ = _tmp3_;
	_vala_natural = (gint) (_tmp2_ * _tmp4_);
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void minefield_view_redraw_sector_cb (MinefieldView* self, guint x, guint y) {
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = minefield_view_get_x_offset (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = minefield_view_get_mine_size (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = minefield_view_get_y_offset (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = y;
	_tmp8_ = minefield_view_get_mine_size (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = minefield_view_get_mine_size (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = minefield_view_get_mine_size (self);
	_tmp13_ = _tmp12_;
	gtk_widget_queue_draw_area ((GtkWidget*) self, (gint) (_tmp1_ + (_tmp2_ * _tmp4_)), (gint) (_tmp6_ + (_tmp7_ * _tmp9_)), (gint) _tmp11_, (gint) _tmp13_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void minefield_view_draw_square (MinefieldView* self, cairo_t* cr, guint x, guint y) {
	gboolean is_down;
	gboolean _tmp0_ = FALSE;
	Position* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp7_;
	Minefield* _tmp65_;
	Minefield* _tmp66_;
	guint _tmp67_;
	guint _tmp68_;
	gboolean _tmp69_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	is_down = FALSE;
	_tmp1_ = self->priv->selected;
	_tmp2_ = position_get_is_valid (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		Position* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->selected;
		_tmp5_ = position_get_is_set (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		guint _tmp10_;
		Position* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gboolean _tmp18_;
		gboolean _tmp24_;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_;
		gboolean _tmp36_;
		_tmp10_ = x;
		_tmp11_ = self->priv->selected;
		_tmp12_ = position_get_x (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp10_ == ((guint) _tmp13_)) {
			guint _tmp14_;
			Position* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			_tmp14_ = y;
			_tmp15_ = self->priv->selected;
			_tmp16_ = position_get_y (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp9_ = _tmp14_ == ((guint) _tmp17_);
		} else {
			_tmp9_ = FALSE;
		}
		_tmp18_ = _tmp9_;
		if (_tmp18_) {
			Minefield* _tmp19_;
			Minefield* _tmp20_;
			guint _tmp21_;
			guint _tmp22_;
			FlagType _tmp23_ = 0;
			_tmp19_ = minefield_view_get_minefield (self);
			_tmp20_ = _tmp19_;
			_tmp21_ = x;
			_tmp22_ = y;
			_tmp23_ = minefield_get_flag (_tmp20_, _tmp21_, _tmp22_);
			_tmp8_ = _tmp23_ != FLAG_TYPE_FLAG;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp24_ = _tmp8_;
		is_down = _tmp24_;
		_tmp26_ = is_down;
		if (!_tmp26_) {
			Minefield* _tmp27_;
			Minefield* _tmp28_;
			Position* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			Position* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gboolean _tmp35_ = FALSE;
			_tmp27_ = minefield_view_get_minefield (self);
			_tmp28_ = _tmp27_;
			_tmp29_ = self->priv->selected;
			_tmp30_ = position_get_x (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = self->priv->selected;
			_tmp33_ = position_get_y (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = minefield_is_cleared (_tmp28_, (guint) _tmp31_, (guint) _tmp34_);
			_tmp25_ = _tmp35_;
		} else {
			_tmp25_ = FALSE;
		}
		_tmp36_ = _tmp25_;
		if (_tmp36_) {
			{
				Neighbour* neighbour_collection = NULL;
				gint neighbour_collection_length1 = 0;
				gint _neighbour_collection_size_ = 0;
				gint neighbour_it = 0;
				neighbour_collection = neighbour_map;
				neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
				for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
					Neighbour neighbour = {0};
					neighbour = neighbour_collection[neighbour_it];
					{
						Position* _tmp37_;
						gint _tmp38_;
						gint _tmp39_;
						Neighbour _tmp40_;
						gint _tmp41_;
						gint nx;
						Position* _tmp42_;
						gint _tmp43_;
						gint _tmp44_;
						Neighbour _tmp45_;
						gint _tmp46_;
						gint ny;
						Minefield* _tmp47_;
						Minefield* _tmp48_;
						gint _tmp49_;
						gint _tmp50_;
						gboolean _tmp51_ = FALSE;
						gboolean _tmp52_ = FALSE;
						gboolean _tmp53_ = FALSE;
						guint _tmp54_;
						gint _tmp55_;
						gboolean _tmp58_;
						gboolean _tmp64_;
						_tmp37_ = self->priv->selected;
						_tmp38_ = position_get_x (_tmp37_);
						_tmp39_ = _tmp38_;
						_tmp40_ = neighbour;
						_tmp41_ = _tmp40_.x;
						nx = ((gint) _tmp39_) + _tmp41_;
						_tmp42_ = self->priv->selected;
						_tmp43_ = position_get_y (_tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = neighbour;
						_tmp46_ = _tmp45_.y;
						ny = ((gint) _tmp44_) + _tmp46_;
						_tmp47_ = minefield_view_get_minefield (self);
						_tmp48_ = _tmp47_;
						_tmp49_ = nx;
						_tmp50_ = ny;
						_tmp51_ = minefield_is_location (_tmp48_, _tmp49_, _tmp50_);
						if (!_tmp51_) {
							continue;
						}
						_tmp54_ = x;
						_tmp55_ = nx;
						if (_tmp54_ == ((guint) _tmp55_)) {
							guint _tmp56_;
							gint _tmp57_;
							_tmp56_ = y;
							_tmp57_ = ny;
							_tmp53_ = _tmp56_ == ((guint) _tmp57_);
						} else {
							_tmp53_ = FALSE;
						}
						_tmp58_ = _tmp53_;
						if (_tmp58_) {
							Minefield* _tmp59_;
							Minefield* _tmp60_;
							gint _tmp61_;
							gint _tmp62_;
							FlagType _tmp63_ = 0;
							_tmp59_ = minefield_view_get_minefield (self);
							_tmp60_ = _tmp59_;
							_tmp61_ = nx;
							_tmp62_ = ny;
							_tmp63_ = minefield_get_flag (_tmp60_, (guint) _tmp61_, (guint) _tmp62_);
							_tmp52_ = _tmp63_ != FLAG_TYPE_FLAG;
						} else {
							_tmp52_ = FALSE;
						}
						_tmp64_ = _tmp52_;
						if (_tmp64_) {
							is_down = TRUE;
						}
					}
				}
			}
		}
	}
	_tmp65_ = minefield_view_get_minefield (self);
	_tmp66_ = _tmp65_;
	_tmp67_ = x;
	_tmp68_ = y;
	_tmp69_ = minefield_is_cleared (_tmp66_, _tmp67_, _tmp68_);
	if (_tmp69_) {
		Minefield* _tmp70_;
		Minefield* _tmp71_;
		gboolean _tmp72_;
		gboolean _tmp73_;
		Minefield* _tmp74_;
		Minefield* _tmp75_;
		guint _tmp76_;
		guint _tmp77_;
		gboolean _tmp78_ = FALSE;
		_tmp70_ = minefield_view_get_minefield (self);
		_tmp71_ = _tmp70_;
		_tmp72_ = minefield_get_paused (_tmp71_);
		_tmp73_ = _tmp72_;
		if (_tmp73_) {
			return;
		}
		_tmp74_ = minefield_view_get_minefield (self);
		_tmp75_ = _tmp74_;
		_tmp76_ = x;
		_tmp77_ = y;
		_tmp78_ = minefield_has_mine (_tmp75_, _tmp76_, _tmp77_);
		if (_tmp78_) {
			cairo_pattern_t* _tmp79_;
			cairo_t* _tmp84_;
			cairo_pattern_t* _tmp85_;
			cairo_t* _tmp86_;
			guint _tmp87_;
			guint _tmp88_;
			guint _tmp89_;
			guint _tmp90_;
			cairo_t* _tmp91_;
			_tmp79_ = self->priv->bang_pattern;
			if (_tmp79_ == NULL) {
				cairo_t* _tmp80_;
				gchar* _tmp81_ = NULL;
				gchar* _tmp82_;
				cairo_pattern_t* _tmp83_ = NULL;
				_tmp80_ = cr;
				_tmp81_ = g_build_filename (DATA_DIRECTORY, "bang.svg", NULL);
				_tmp82_ = _tmp81_;
				_tmp83_ = minefield_view_render_svg_pattern (self, _tmp80_, _tmp82_);
				_cairo_pattern_destroy0 (self->priv->bang_pattern);
				self->priv->bang_pattern = _tmp83_;
				_g_free0 (_tmp82_);
			}
			_tmp84_ = cr;
			_tmp85_ = self->priv->bang_pattern;
			cairo_set_source (_tmp84_, _tmp85_);
			_tmp86_ = cr;
			_tmp87_ = minefield_view_get_mine_size (self);
			_tmp88_ = _tmp87_;
			_tmp89_ = minefield_view_get_mine_size (self);
			_tmp90_ = _tmp89_;
			cairo_rectangle (_tmp86_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp88_, (gdouble) _tmp90_);
			_tmp91_ = cr;
			cairo_fill (_tmp91_);
		} else {
			gboolean _tmp92_ = FALSE;
			gboolean _tmp93_;
			gboolean _tmp99_;
			Minefield* _tmp113_;
			Minefield* _tmp114_;
			guint _tmp115_;
			guint _tmp116_;
			guint _tmp117_ = 0U;
			guint n;
			guint _tmp118_;
			_tmp93_ = self->priv->use_overmine_warning;
			if (_tmp93_) {
				Minefield* _tmp94_;
				Minefield* _tmp95_;
				guint _tmp96_;
				guint _tmp97_;
				gboolean _tmp98_ = FALSE;
				_tmp94_ = minefield_view_get_minefield (self);
				_tmp95_ = _tmp94_;
				_tmp96_ = x;
				_tmp97_ = y;
				_tmp98_ = minefield_has_flag_warning (_tmp95_, _tmp96_, _tmp97_);
				_tmp92_ = _tmp98_;
			} else {
				_tmp92_ = FALSE;
			}
			_tmp99_ = _tmp92_;
			if (_tmp99_) {
				cairo_pattern_t* _tmp100_;
				cairo_t* _tmp105_;
				cairo_pattern_t* _tmp106_;
				cairo_t* _tmp107_;
				guint _tmp108_;
				guint _tmp109_;
				guint _tmp110_;
				guint _tmp111_;
				cairo_t* _tmp112_;
				_tmp100_ = self->priv->warning_pattern;
				if (_tmp100_ == NULL) {
					cairo_t* _tmp101_;
					gchar* _tmp102_ = NULL;
					gchar* _tmp103_;
					cairo_pattern_t* _tmp104_ = NULL;
					_tmp101_ = cr;
					_tmp102_ = g_build_filename (DATA_DIRECTORY, "warning.svg", NULL);
					_tmp103_ = _tmp102_;
					_tmp104_ = minefield_view_render_svg_pattern (self, _tmp101_, _tmp103_);
					_cairo_pattern_destroy0 (self->priv->warning_pattern);
					self->priv->warning_pattern = _tmp104_;
					_g_free0 (_tmp103_);
				}
				_tmp105_ = cr;
				_tmp106_ = self->priv->warning_pattern;
				cairo_set_source (_tmp105_, _tmp106_);
				_tmp107_ = cr;
				_tmp108_ = minefield_view_get_mine_size (self);
				_tmp109_ = _tmp108_;
				_tmp110_ = minefield_view_get_mine_size (self);
				_tmp111_ = _tmp110_;
				cairo_rectangle (_tmp107_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp109_, (gdouble) _tmp111_);
				_tmp112_ = cr;
				cairo_fill (_tmp112_);
			}
			_tmp113_ = minefield_view_get_minefield (self);
			_tmp114_ = _tmp113_;
			_tmp115_ = x;
			_tmp116_ = y;
			_tmp117_ = minefield_get_n_adjacent_mines (_tmp114_, _tmp115_, _tmp116_);
			n = _tmp117_;
			_tmp118_ = n;
			if (_tmp118_ != ((guint) 0)) {
				cairo_pattern_t** _tmp119_;
				gint _tmp119__length1;
				guint _tmp120_;
				cairo_pattern_t* _tmp121_;
				cairo_t* _tmp127_;
				cairo_pattern_t** _tmp128_;
				gint _tmp128__length1;
				guint _tmp129_;
				cairo_pattern_t* _tmp130_;
				cairo_t* _tmp131_;
				guint _tmp132_;
				guint _tmp133_;
				guint _tmp134_;
				guint _tmp135_;
				cairo_t* _tmp136_;
				_tmp119_ = self->priv->number_patterns;
				_tmp119__length1 = self->priv->number_patterns_length1;
				_tmp120_ = n;
				_tmp121_ = _tmp119_[_tmp120_ - 1];
				if (_tmp121_ == NULL) {
					cairo_pattern_t** _tmp122_;
					gint _tmp122__length1;
					guint _tmp123_;
					guint _tmp124_;
					cairo_pattern_t* _tmp125_ = NULL;
					cairo_pattern_t* _tmp126_;
					_tmp122_ = self->priv->number_patterns;
					_tmp122__length1 = self->priv->number_patterns_length1;
					_tmp123_ = n;
					_tmp124_ = n;
					_tmp125_ = minefield_view_render_number_pattern (self, _tmp124_);
					_cairo_pattern_destroy0 (_tmp122_[_tmp123_ - 1]);
					_tmp122_[_tmp123_ - 1] = _tmp125_;
					_tmp126_ = _tmp122_[_tmp123_ - 1];
				}
				_tmp127_ = cr;
				_tmp128_ = self->priv->number_patterns;
				_tmp128__length1 = self->priv->number_patterns_length1;
				_tmp129_ = n;
				_tmp130_ = _tmp128_[_tmp129_ - 1];
				cairo_set_source (_tmp127_, _tmp130_);
				_tmp131_ = cr;
				_tmp132_ = minefield_view_get_mine_size (self);
				_tmp133_ = _tmp132_;
				_tmp134_ = minefield_view_get_mine_size (self);
				_tmp135_ = _tmp134_;
				cairo_rectangle (_tmp131_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp133_, (gdouble) _tmp135_);
				_tmp136_ = cr;
				cairo_fill (_tmp136_);
			}
		}
	} else {
		GtkStyleContext* _tmp137_ = NULL;
		GtkStyleContext* _tmp138_;
		GtkStyleContext* style_context;
		GtkStyleContext* _tmp139_;
		GtkStyleContext* _tmp140_;
		GtkStateFlags _tmp141_ = 0;
		gboolean _tmp142_;
		GtkStyleContext* _tmp143_;
		GtkStateFlags _tmp144_;
		GtkStyleContext* _tmp145_;
		cairo_t* _tmp146_;
		guint _tmp147_;
		guint _tmp148_;
		guint _tmp149_;
		guint _tmp150_;
		GtkStyleContext* _tmp151_;
		cairo_t* _tmp152_;
		guint _tmp153_;
		guint _tmp154_;
		guint _tmp155_;
		guint _tmp156_;
		GtkStyleContext* _tmp157_;
		Minefield* _tmp158_;
		Minefield* _tmp159_;
		gboolean _tmp160_;
		gboolean _tmp161_;
		Minefield* _tmp162_;
		Minefield* _tmp163_;
		guint _tmp164_;
		guint _tmp165_;
		FlagType _tmp166_ = 0;
		_tmp137_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp138_ = _g_object_ref0 (_tmp137_);
		style_context = _tmp138_;
		_tmp139_ = style_context;
		gtk_style_context_save (_tmp139_);
		_tmp140_ = style_context;
		gtk_style_context_add_class (_tmp140_, GTK_STYLE_CLASS_BUTTON);
		_tmp142_ = is_down;
		if (_tmp142_) {
			_tmp141_ = GTK_STATE_FLAG_ACTIVE;
		} else {
			_tmp141_ = GTK_STATE_FLAG_NORMAL;
		}
		_tmp143_ = style_context;
		_tmp144_ = _tmp141_;
		gtk_style_context_set_state (_tmp143_, _tmp144_);
		_tmp145_ = style_context;
		_tmp146_ = cr;
		_tmp147_ = minefield_view_get_mine_size (self);
		_tmp148_ = _tmp147_;
		_tmp149_ = minefield_view_get_mine_size (self);
		_tmp150_ = _tmp149_;
		gtk_render_frame (_tmp145_, _tmp146_, (gdouble) 0, (gdouble) 0, (gdouble) ((gint) _tmp148_), (gdouble) ((gint) _tmp150_));
		_tmp151_ = style_context;
		_tmp152_ = cr;
		_tmp153_ = minefield_view_get_mine_size (self);
		_tmp154_ = _tmp153_;
		_tmp155_ = minefield_view_get_mine_size (self);
		_tmp156_ = _tmp155_;
		gtk_render_background (_tmp151_, _tmp152_, (gdouble) 0, (gdouble) 0, (gdouble) ((gint) _tmp154_), (gdouble) ((gint) _tmp156_));
		_tmp157_ = style_context;
		gtk_style_context_restore (_tmp157_);
		_tmp158_ = minefield_view_get_minefield (self);
		_tmp159_ = _tmp158_;
		_tmp160_ = minefield_get_paused (_tmp159_);
		_tmp161_ = _tmp160_;
		if (_tmp161_) {
			_g_object_unref0 (style_context);
			return;
		}
		_tmp162_ = minefield_view_get_minefield (self);
		_tmp163_ = _tmp162_;
		_tmp164_ = x;
		_tmp165_ = y;
		_tmp166_ = minefield_get_flag (_tmp163_, _tmp164_, _tmp165_);
		if (_tmp166_ == FLAG_TYPE_FLAG) {
			cairo_pattern_t* _tmp167_;
			cairo_t* _tmp172_;
			cairo_pattern_t* _tmp173_;
			cairo_t* _tmp174_;
			guint _tmp175_;
			guint _tmp176_;
			guint _tmp177_;
			guint _tmp178_;
			cairo_t* _tmp179_;
			gboolean _tmp180_ = FALSE;
			Minefield* _tmp181_;
			Minefield* _tmp182_;
			gboolean _tmp183_;
			gboolean _tmp189_;
			_tmp167_ = self->priv->flag_pattern;
			if (_tmp167_ == NULL) {
				cairo_t* _tmp168_;
				gchar* _tmp169_ = NULL;
				gchar* _tmp170_;
				cairo_pattern_t* _tmp171_ = NULL;
				_tmp168_ = cr;
				_tmp169_ = g_build_filename (DATA_DIRECTORY, "flag.svg", NULL);
				_tmp170_ = _tmp169_;
				_tmp171_ = minefield_view_render_svg_pattern (self, _tmp168_, _tmp170_);
				_cairo_pattern_destroy0 (self->priv->flag_pattern);
				self->priv->flag_pattern = _tmp171_;
				_g_free0 (_tmp170_);
			}
			_tmp172_ = cr;
			_tmp173_ = self->priv->flag_pattern;
			cairo_set_source (_tmp172_, _tmp173_);
			_tmp174_ = cr;
			_tmp175_ = minefield_view_get_mine_size (self);
			_tmp176_ = _tmp175_;
			_tmp177_ = minefield_view_get_mine_size (self);
			_tmp178_ = _tmp177_;
			cairo_rectangle (_tmp174_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp176_, (gdouble) _tmp178_);
			_tmp179_ = cr;
			cairo_fill (_tmp179_);
			_tmp181_ = minefield_view_get_minefield (self);
			_tmp182_ = _tmp181_;
			_tmp183_ = _tmp182_->exploded;
			if (_tmp183_) {
				Minefield* _tmp184_;
				Minefield* _tmp185_;
				guint _tmp186_;
				guint _tmp187_;
				gboolean _tmp188_ = FALSE;
				_tmp184_ = minefield_view_get_minefield (self);
				_tmp185_ = _tmp184_;
				_tmp186_ = x;
				_tmp187_ = y;
				_tmp188_ = minefield_has_mine (_tmp185_, _tmp186_, _tmp187_);
				_tmp180_ = !_tmp188_;
			} else {
				_tmp180_ = FALSE;
			}
			_tmp189_ = _tmp180_;
			if (_tmp189_) {
				guint _tmp190_;
				guint _tmp191_;
				gdouble x1;
				guint _tmp192_;
				guint _tmp193_;
				gdouble y1;
				guint _tmp194_;
				guint _tmp195_;
				gdouble x2;
				guint _tmp196_;
				guint _tmp197_;
				gdouble y2;
				cairo_t* _tmp198_;
				gdouble _tmp199_;
				gdouble _tmp200_;
				cairo_t* _tmp201_;
				gdouble _tmp202_;
				gdouble _tmp203_;
				cairo_t* _tmp204_;
				gdouble _tmp205_;
				gdouble _tmp206_;
				cairo_t* _tmp207_;
				gdouble _tmp208_;
				gdouble _tmp209_;
				cairo_t* _tmp210_;
				cairo_t* _tmp211_;
				cairo_t* _tmp212_;
				guint _tmp213_;
				guint _tmp214_;
				gdouble _tmp215_ = 0.0;
				cairo_t* _tmp216_;
				cairo_t* _tmp217_;
				cairo_t* _tmp218_;
				cairo_t* _tmp219_;
				_tmp190_ = minefield_view_get_mine_size (self);
				_tmp191_ = _tmp190_;
				x1 = 0.1 * _tmp191_;
				_tmp192_ = minefield_view_get_mine_size (self);
				_tmp193_ = _tmp192_;
				y1 = 0.1 * _tmp193_;
				_tmp194_ = minefield_view_get_mine_size (self);
				_tmp195_ = _tmp194_;
				x2 = 0.9 * _tmp195_;
				_tmp196_ = minefield_view_get_mine_size (self);
				_tmp197_ = _tmp196_;
				y2 = 0.9 * _tmp197_;
				_tmp198_ = cr;
				_tmp199_ = x1;
				_tmp200_ = y1;
				cairo_move_to (_tmp198_, _tmp199_, _tmp200_);
				_tmp201_ = cr;
				_tmp202_ = x2;
				_tmp203_ = y2;
				cairo_line_to (_tmp201_, _tmp202_, _tmp203_);
				_tmp204_ = cr;
				_tmp205_ = x1;
				_tmp206_ = y2;
				cairo_move_to (_tmp204_, _tmp205_, _tmp206_);
				_tmp207_ = cr;
				_tmp208_ = x2;
				_tmp209_ = y1;
				cairo_line_to (_tmp207_, _tmp208_, _tmp209_);
				_tmp210_ = cr;
				cairo_save (_tmp210_);
				_tmp211_ = cr;
				cairo_set_source_rgba (_tmp211_, 0.0, 0.0, 0.0, 1.0);
				_tmp212_ = cr;
				_tmp213_ = minefield_view_get_mine_size (self);
				_tmp214_ = _tmp213_;
				_tmp215_ = MAX ((gdouble) 1, 0.1 * _tmp214_);
				cairo_set_line_width (_tmp212_, _tmp215_);
				_tmp216_ = cr;
				cairo_set_line_join (_tmp216_, CAIRO_LINE_JOIN_ROUND);
				_tmp217_ = cr;
				cairo_set_line_cap (_tmp217_, CAIRO_LINE_CAP_ROUND);
				_tmp218_ = cr;
				cairo_stroke (_tmp218_);
				_tmp219_ = cr;
				cairo_restore (_tmp219_);
			}
		} else {
			gboolean _tmp220_ = FALSE;
			Minefield* _tmp221_;
			Minefield* _tmp222_;
			gboolean _tmp223_;
			gboolean _tmp229_;
			_tmp221_ = minefield_view_get_minefield (self);
			_tmp222_ = _tmp221_;
			_tmp223_ = _tmp222_->exploded;
			if (_tmp223_) {
				Minefield* _tmp224_;
				Minefield* _tmp225_;
				guint _tmp226_;
				guint _tmp227_;
				gboolean _tmp228_ = FALSE;
				_tmp224_ = minefield_view_get_minefield (self);
				_tmp225_ = _tmp224_;
				_tmp226_ = x;
				_tmp227_ = y;
				_tmp228_ = minefield_has_mine (_tmp225_, _tmp226_, _tmp227_);
				_tmp220_ = _tmp228_;
			} else {
				_tmp220_ = FALSE;
			}
			_tmp229_ = _tmp220_;
			if (_tmp229_) {
				cairo_pattern_t* _tmp230_;
				cairo_t* _tmp235_;
				cairo_pattern_t* _tmp236_;
				cairo_t* _tmp237_;
				guint _tmp238_;
				guint _tmp239_;
				guint _tmp240_;
				guint _tmp241_;
				cairo_t* _tmp242_;
				_tmp230_ = self->priv->mine_pattern;
				if (_tmp230_ == NULL) {
					cairo_t* _tmp231_;
					gchar* _tmp232_ = NULL;
					gchar* _tmp233_;
					cairo_pattern_t* _tmp234_ = NULL;
					_tmp231_ = cr;
					_tmp232_ = g_build_filename (DATA_DIRECTORY, "mine.svg", NULL);
					_tmp233_ = _tmp232_;
					_tmp234_ = minefield_view_render_svg_pattern (self, _tmp231_, _tmp233_);
					_cairo_pattern_destroy0 (self->priv->mine_pattern);
					self->priv->mine_pattern = _tmp234_;
					_g_free0 (_tmp233_);
				}
				_tmp235_ = cr;
				_tmp236_ = self->priv->mine_pattern;
				cairo_set_source (_tmp235_, _tmp236_);
				_tmp237_ = cr;
				_tmp238_ = minefield_view_get_mine_size (self);
				_tmp239_ = _tmp238_;
				_tmp240_ = minefield_view_get_mine_size (self);
				_tmp241_ = _tmp240_;
				cairo_rectangle (_tmp237_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp239_, (gdouble) _tmp241_);
				_tmp242_ = cr;
				cairo_fill (_tmp242_);
			} else {
				Minefield* _tmp243_;
				Minefield* _tmp244_;
				guint _tmp245_;
				guint _tmp246_;
				FlagType _tmp247_ = 0;
				_tmp243_ = minefield_view_get_minefield (self);
				_tmp244_ = _tmp243_;
				_tmp245_ = x;
				_tmp246_ = y;
				_tmp247_ = minefield_get_flag (_tmp244_, _tmp245_, _tmp246_);
				if (_tmp247_ == FLAG_TYPE_MAYBE) {
					cairo_pattern_t* _tmp248_;
					cairo_t* _tmp253_;
					cairo_pattern_t* _tmp254_;
					cairo_t* _tmp255_;
					guint _tmp256_;
					guint _tmp257_;
					guint _tmp258_;
					guint _tmp259_;
					cairo_t* _tmp260_;
					_tmp248_ = self->priv->question_pattern;
					if (_tmp248_ == NULL) {
						cairo_t* _tmp249_;
						gchar* _tmp250_ = NULL;
						gchar* _tmp251_;
						cairo_pattern_t* _tmp252_ = NULL;
						_tmp249_ = cr;
						_tmp250_ = g_build_filename (DATA_DIRECTORY, "flag-question.svg", NULL);
						_tmp251_ = _tmp250_;
						_tmp252_ = minefield_view_render_svg_pattern (self, _tmp249_, _tmp251_);
						_cairo_pattern_destroy0 (self->priv->question_pattern);
						self->priv->question_pattern = _tmp252_;
						_g_free0 (_tmp251_);
					}
					_tmp253_ = cr;
					_tmp254_ = self->priv->question_pattern;
					cairo_set_source (_tmp253_, _tmp254_);
					_tmp255_ = cr;
					_tmp256_ = minefield_view_get_mine_size (self);
					_tmp257_ = _tmp256_;
					_tmp258_ = minefield_view_get_mine_size (self);
					_tmp259_ = _tmp258_;
					cairo_rectangle (_tmp255_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp257_, (gdouble) _tmp259_);
					_tmp260_ = cr;
					cairo_fill (_tmp260_);
				}
			}
		}
		_g_object_unref0 (style_context);
	}
}


static gboolean minefield_view_real_draw (GtkWidget* base, cairo_t* cr) {
	MinefieldView * self;
	gboolean result = FALSE;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	Minefield* _tmp13_;
	Minefield* _tmp14_;
	guint _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	Minefield* _tmp18_;
	Minefield* _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	gdouble _tmp23_[2] = {0};
	gdouble dimensions[2];
	guint _tmp24_;
	guint _tmp25_;
	gdouble _tmp26_;
	guint _tmp27_;
	guint _tmp28_;
	gdouble _tmp29_;
	gdouble _tmp30_[2] = {0};
	gdouble centre[2];
	gdouble _tmp31_;
	gdouble _tmp32_;
	gdouble _tmp33_ = 0.0;
	gdouble radius;
	gdouble _tmp34_;
	gdouble _tmp35_;
	gdouble _tmp36_;
	gdouble _tmp37_;
	gdouble _tmp38_;
	cairo_pattern_t* _tmp39_;
	cairo_pattern_t* pattern;
	cairo_pattern_t* _tmp40_;
	cairo_pattern_t* _tmp41_;
	cairo_t* _tmp42_;
	guint _tmp43_;
	guint _tmp44_;
	guint _tmp45_;
	guint _tmp46_;
	gdouble _tmp47_;
	gdouble _tmp48_;
	cairo_t* _tmp49_;
	cairo_t* _tmp50_;
	cairo_pattern_t* _tmp51_;
	cairo_t* _tmp52_;
	cairo_t* _tmp53_;
	cairo_t* _tmp54_;
	cairo_t* _tmp55_;
	cairo_t* _tmp56_;
	cairo_t* _tmp57_;
	cairo_t* _tmp58_;
	cairo_t* _tmp59_;
	gdouble* _tmp60_ = NULL;
	gdouble* dots;
	gint dots_length1;
	gint _dots_size_;
	cairo_t* _tmp61_;
	gdouble* _tmp62_;
	gint _tmp62__length1;
	cairo_t* _tmp113_;
	Position* _tmp144_;
	gboolean _tmp145_;
	gboolean _tmp146_;
	Minefield* _tmp190_;
	Minefield* _tmp191_;
	gboolean _tmp192_;
	gboolean _tmp193_;
	self = (MinefieldView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = self->priv->render_size;
	_tmp1_ = minefield_view_get_mine_size (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ != _tmp2_) {
		guint _tmp3_;
		guint _tmp4_;
		_tmp3_ = minefield_view_get_mine_size (self);
		_tmp4_ = _tmp3_;
		self->priv->render_size = _tmp4_;
		_cairo_pattern_destroy0 (self->priv->flag_pattern);
		self->priv->flag_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->mine_pattern);
		self->priv->mine_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->question_pattern);
		self->priv->question_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->bang_pattern);
		self->priv->bang_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->warning_pattern);
		self->priv->warning_pattern = NULL;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp5_;
				_tmp5_ = TRUE;
				while (TRUE) {
					gboolean _tmp6_;
					gint _tmp8_;
					cairo_pattern_t** _tmp9_;
					gint _tmp9__length1;
					cairo_pattern_t** _tmp10_;
					gint _tmp10__length1;
					gint _tmp11_;
					cairo_pattern_t* _tmp12_;
					_tmp6_ = _tmp5_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp8_ = i;
					_tmp9_ = self->priv->number_patterns;
					_tmp9__length1 = self->priv->number_patterns_length1;
					if (!(_tmp8_ < _tmp9__length1)) {
						break;
					}
					_tmp10_ = self->priv->number_patterns;
					_tmp10__length1 = self->priv->number_patterns_length1;
					_tmp11_ = i;
					_cairo_pattern_destroy0 (_tmp10_[_tmp11_]);
					_tmp10_[_tmp11_] = NULL;
					_tmp12_ = _tmp10_[_tmp11_];
				}
			}
		}
	}
	_tmp13_ = minefield_view_get_minefield (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_->width;
	_tmp16_ = minefield_view_get_mine_size (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = minefield_view_get_minefield (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_->height;
	_tmp21_ = minefield_view_get_mine_size (self);
	_tmp22_ = _tmp21_;
	_tmp23_[0] = (gdouble) (_tmp15_ * _tmp17_);
	_tmp23_[1] = (gdouble) (_tmp20_ * _tmp22_);
	memcpy (dimensions, _tmp23_, 2 * sizeof (gdouble));
	_tmp24_ = minefield_view_get_x_offset (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = dimensions[0];
	_tmp27_ = minefield_view_get_y_offset (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = dimensions[1];
	_tmp30_[0] = _tmp25_ + (0.5 * _tmp26_);
	_tmp30_[1] = _tmp28_ + (0.5 * _tmp29_);
	memcpy (centre, _tmp30_, 2 * sizeof (gdouble));
	_tmp31_ = dimensions[0];
	_tmp32_ = dimensions[1];
	_tmp33_ = fmax (_tmp31_, _tmp32_);
	radius = _tmp33_;
	_tmp34_ = centre[0];
	_tmp35_ = centre[1];
	_tmp36_ = centre[0];
	_tmp37_ = centre[1];
	_tmp38_ = radius;
	_tmp39_ = cairo_pattern_create_radial (_tmp34_, _tmp35_, 0.0, _tmp36_, _tmp37_, _tmp38_);
	pattern = _tmp39_;
	_tmp40_ = pattern;
	cairo_pattern_add_color_stop_rgba (_tmp40_, 0.0, 0.0, 0.0, 0.0, 0.1);
	_tmp41_ = pattern;
	cairo_pattern_add_color_stop_rgba (_tmp41_, 1.0, 0.0, 0.0, 0.0, 0.4);
	_tmp42_ = cr;
	_tmp43_ = minefield_view_get_x_offset (self);
	_tmp44_ = _tmp43_;
	_tmp45_ = minefield_view_get_y_offset (self);
	_tmp46_ = _tmp45_;
	_tmp47_ = dimensions[0];
	_tmp48_ = dimensions[1];
	cairo_rectangle (_tmp42_, _tmp44_ - 0.5, _tmp46_ - 0.5, _tmp47_ + 0.5, _tmp48_ + 0.5);
	_tmp49_ = cr;
	cairo_save (_tmp49_);
	_tmp50_ = cr;
	_tmp51_ = pattern;
	cairo_set_source (_tmp50_, _tmp51_);
	_tmp52_ = cr;
	cairo_fill_preserve (_tmp52_);
	_tmp53_ = cr;
	cairo_set_line_width (_tmp53_, 0.5);
	_tmp54_ = cr;
	cairo_set_source_rgba (_tmp54_, 0.0, 0.0, 0.0, 1.0);
	_tmp55_ = cr;
	cairo_stroke (_tmp55_);
	_tmp56_ = cr;
	cairo_restore (_tmp56_);
	_tmp57_ = cr;
	cairo_save (_tmp57_);
	_tmp58_ = cr;
	cairo_set_line_width (_tmp58_, 0.5);
	_tmp59_ = cr;
	cairo_set_source_rgba (_tmp59_, 0.0, 0.0, 0.0, 1.0);
	_tmp60_ = g_new0 (gdouble, 2);
	_tmp60_[0] = (gdouble) 2;
	_tmp60_[1] = (gdouble) 2;
	dots = _tmp60_;
	dots_length1 = 2;
	_dots_size_ = dots_length1;
	_tmp61_ = cr;
	_tmp62_ = dots;
	_tmp62__length1 = dots_length1;
	cairo_set_dash (_tmp61_, _tmp62_, _tmp62__length1, (gdouble) 0);
	{
		gint x;
		x = 1;
		{
			gboolean _tmp63_;
			_tmp63_ = TRUE;
			while (TRUE) {
				gboolean _tmp64_;
				gint _tmp66_;
				Minefield* _tmp67_;
				Minefield* _tmp68_;
				guint _tmp69_;
				cairo_t* _tmp70_;
				guint _tmp71_;
				guint _tmp72_;
				gint _tmp73_;
				guint _tmp74_;
				guint _tmp75_;
				guint _tmp76_;
				guint _tmp77_;
				cairo_t* _tmp78_;
				guint _tmp79_;
				guint _tmp80_;
				gint _tmp81_;
				guint _tmp82_;
				guint _tmp83_;
				guint _tmp84_;
				guint _tmp85_;
				gdouble _tmp86_;
				cairo_t* _tmp87_;
				_tmp64_ = _tmp63_;
				if (!_tmp64_) {
					gint _tmp65_;
					_tmp65_ = x;
					x = _tmp65_ + 1;
				}
				_tmp63_ = FALSE;
				_tmp66_ = x;
				_tmp67_ = minefield_view_get_minefield (self);
				_tmp68_ = _tmp67_;
				_tmp69_ = _tmp68_->width;
				if (!(((guint) _tmp66_) < _tmp69_)) {
					break;
				}
				_tmp70_ = cr;
				_tmp71_ = minefield_view_get_x_offset (self);
				_tmp72_ = _tmp71_;
				_tmp73_ = x;
				_tmp74_ = minefield_view_get_mine_size (self);
				_tmp75_ = _tmp74_;
				_tmp76_ = minefield_view_get_y_offset (self);
				_tmp77_ = _tmp76_;
				cairo_move_to (_tmp70_, (gdouble) (_tmp72_ + (_tmp73_ * _tmp75_)), (gdouble) _tmp77_);
				_tmp78_ = cr;
				_tmp79_ = minefield_view_get_x_offset (self);
				_tmp80_ = _tmp79_;
				_tmp81_ = x;
				_tmp82_ = minefield_view_get_mine_size (self);
				_tmp83_ = _tmp82_;
				_tmp84_ = minefield_view_get_y_offset (self);
				_tmp85_ = _tmp84_;
				_tmp86_ = dimensions[1];
				cairo_line_to (_tmp78_, (gdouble) (_tmp80_ + (_tmp81_ * _tmp83_)), _tmp85_ + _tmp86_);
				_tmp87_ = cr;
				cairo_stroke (_tmp87_);
			}
		}
	}
	{
		gint y;
		y = 1;
		{
			gboolean _tmp88_;
			_tmp88_ = TRUE;
			while (TRUE) {
				gboolean _tmp89_;
				gint _tmp91_;
				Minefield* _tmp92_;
				Minefield* _tmp93_;
				guint _tmp94_;
				cairo_t* _tmp95_;
				guint _tmp96_;
				guint _tmp97_;
				guint _tmp98_;
				guint _tmp99_;
				gint _tmp100_;
				guint _tmp101_;
				guint _tmp102_;
				cairo_t* _tmp103_;
				guint _tmp104_;
				guint _tmp105_;
				gdouble _tmp106_;
				guint _tmp107_;
				guint _tmp108_;
				gint _tmp109_;
				guint _tmp110_;
				guint _tmp111_;
				cairo_t* _tmp112_;
				_tmp89_ = _tmp88_;
				if (!_tmp89_) {
					gint _tmp90_;
					_tmp90_ = y;
					y = _tmp90_ + 1;
				}
				_tmp88_ = FALSE;
				_tmp91_ = y;
				_tmp92_ = minefield_view_get_minefield (self);
				_tmp93_ = _tmp92_;
				_tmp94_ = _tmp93_->height;
				if (!(((guint) _tmp91_) < _tmp94_)) {
					break;
				}
				_tmp95_ = cr;
				_tmp96_ = minefield_view_get_x_offset (self);
				_tmp97_ = _tmp96_;
				_tmp98_ = minefield_view_get_y_offset (self);
				_tmp99_ = _tmp98_;
				_tmp100_ = y;
				_tmp101_ = minefield_view_get_mine_size (self);
				_tmp102_ = _tmp101_;
				cairo_move_to (_tmp95_, (gdouble) _tmp97_, (gdouble) (_tmp99_ + (_tmp100_ * _tmp102_)));
				_tmp103_ = cr;
				_tmp104_ = minefield_view_get_x_offset (self);
				_tmp105_ = _tmp104_;
				_tmp106_ = dimensions[0];
				_tmp107_ = minefield_view_get_y_offset (self);
				_tmp108_ = _tmp107_;
				_tmp109_ = y;
				_tmp110_ = minefield_view_get_mine_size (self);
				_tmp111_ = _tmp110_;
				cairo_line_to (_tmp103_, _tmp105_ + _tmp106_, (gdouble) (_tmp108_ + (_tmp109_ * _tmp111_)));
				_tmp112_ = cr;
				cairo_stroke (_tmp112_);
			}
		}
	}
	_tmp113_ = cr;
	cairo_restore (_tmp113_);
	{
		gint x;
		x = 0;
		{
			gboolean _tmp114_;
			_tmp114_ = TRUE;
			while (TRUE) {
				gboolean _tmp115_;
				gint _tmp117_;
				Minefield* _tmp118_;
				Minefield* _tmp119_;
				guint _tmp120_;
				_tmp115_ = _tmp114_;
				if (!_tmp115_) {
					gint _tmp116_;
					_tmp116_ = x;
					x = _tmp116_ + 1;
				}
				_tmp114_ = FALSE;
				_tmp117_ = x;
				_tmp118_ = minefield_view_get_minefield (self);
				_tmp119_ = _tmp118_;
				_tmp120_ = _tmp119_->width;
				if (!(((guint) _tmp117_) < _tmp120_)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp121_;
						_tmp121_ = TRUE;
						while (TRUE) {
							gboolean _tmp122_;
							gint _tmp124_;
							Minefield* _tmp125_;
							Minefield* _tmp126_;
							guint _tmp127_;
							cairo_t* _tmp128_;
							cairo_t* _tmp129_;
							guint _tmp130_;
							guint _tmp131_;
							gint _tmp132_;
							guint _tmp133_;
							guint _tmp134_;
							guint _tmp135_;
							guint _tmp136_;
							gint _tmp137_;
							guint _tmp138_;
							guint _tmp139_;
							cairo_t* _tmp140_;
							gint _tmp141_;
							gint _tmp142_;
							cairo_t* _tmp143_;
							_tmp122_ = _tmp121_;
							if (!_tmp122_) {
								gint _tmp123_;
								_tmp123_ = y;
								y = _tmp123_ + 1;
							}
							_tmp121_ = FALSE;
							_tmp124_ = y;
							_tmp125_ = minefield_view_get_minefield (self);
							_tmp126_ = _tmp125_;
							_tmp127_ = _tmp126_->height;
							if (!(((guint) _tmp124_) < _tmp127_)) {
								break;
							}
							_tmp128_ = cr;
							cairo_save (_tmp128_);
							_tmp129_ = cr;
							_tmp130_ = minefield_view_get_x_offset (self);
							_tmp131_ = _tmp130_;
							_tmp132_ = x;
							_tmp133_ = minefield_view_get_mine_size (self);
							_tmp134_ = _tmp133_;
							_tmp135_ = minefield_view_get_y_offset (self);
							_tmp136_ = _tmp135_;
							_tmp137_ = y;
							_tmp138_ = minefield_view_get_mine_size (self);
							_tmp139_ = _tmp138_;
							cairo_translate (_tmp129_, (gdouble) (_tmp131_ + (_tmp132_ * _tmp134_)), (gdouble) (_tmp136_ + (_tmp137_ * _tmp139_)));
							_tmp140_ = cr;
							_tmp141_ = x;
							_tmp142_ = y;
							minefield_view_draw_square (self, _tmp140_, (guint) _tmp141_, (guint) _tmp142_);
							_tmp143_ = cr;
							cairo_restore (_tmp143_);
						}
					}
				}
			}
		}
	}
	_tmp144_ = self->priv->keyboard_cursor;
	_tmp145_ = position_get_is_set (_tmp144_);
	_tmp146_ = _tmp145_;
	if (_tmp146_) {
		guint _tmp147_;
		guint _tmp148_;
		Position* _tmp149_;
		gint _tmp150_;
		gint _tmp151_;
		guint _tmp152_;
		guint _tmp153_;
		guint _tmp154_;
		guint _tmp155_;
		Position* _tmp156_;
		gint _tmp157_;
		gint _tmp158_;
		guint _tmp159_;
		guint _tmp160_;
		gdouble _tmp161_[2] = {0};
		gdouble key_centre[2];
		gdouble _tmp162_;
		gdouble _tmp163_;
		gdouble _tmp164_;
		gdouble _tmp165_;
		guint _tmp166_;
		guint _tmp167_;
		cairo_pattern_t* _tmp168_;
		cairo_pattern_t* key_cursor;
		cairo_pattern_t* _tmp169_;
		cairo_pattern_t* _tmp170_;
		cairo_pattern_t* _tmp171_;
		cairo_pattern_t* _tmp172_;
		cairo_pattern_t* _tmp173_;
		cairo_t* _tmp174_;
		cairo_t* _tmp175_;
		gdouble _tmp176_;
		guint _tmp177_;
		guint _tmp178_;
		gdouble _tmp179_;
		guint _tmp180_;
		guint _tmp181_;
		guint _tmp182_;
		guint _tmp183_;
		guint _tmp184_;
		guint _tmp185_;
		cairo_t* _tmp186_;
		cairo_pattern_t* _tmp187_;
		cairo_t* _tmp188_;
		cairo_t* _tmp189_;
		_tmp147_ = minefield_view_get_x_offset (self);
		_tmp148_ = _tmp147_;
		_tmp149_ = self->priv->keyboard_cursor;
		_tmp150_ = position_get_x (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp152_ = minefield_view_get_mine_size (self);
		_tmp153_ = _tmp152_;
		_tmp154_ = minefield_view_get_y_offset (self);
		_tmp155_ = _tmp154_;
		_tmp156_ = self->priv->keyboard_cursor;
		_tmp157_ = position_get_y (_tmp156_);
		_tmp158_ = _tmp157_;
		_tmp159_ = minefield_view_get_mine_size (self);
		_tmp160_ = _tmp159_;
		_tmp161_[0] = _tmp148_ + ((_tmp151_ + 0.5) * _tmp153_);
		_tmp161_[1] = _tmp155_ + ((_tmp158_ + 0.5) * _tmp160_);
		memcpy (key_centre, _tmp161_, 2 * sizeof (gdouble));
		_tmp162_ = key_centre[0];
		_tmp163_ = key_centre[1];
		_tmp164_ = key_centre[0];
		_tmp165_ = key_centre[1];
		_tmp166_ = minefield_view_get_mine_size (self);
		_tmp167_ = _tmp166_;
		_tmp168_ = cairo_pattern_create_radial (_tmp162_, _tmp163_, 0.0, _tmp164_, _tmp165_, 0.25 * _tmp167_);
		key_cursor = _tmp168_;
		_tmp169_ = key_cursor;
		cairo_pattern_add_color_stop_rgba (_tmp169_, 0.0, 1.0, 1.0, 1.0, 1.0);
		_tmp170_ = key_cursor;
		cairo_pattern_add_color_stop_rgba (_tmp170_, 0.8, 1.0, 1.0, 1.0, 0.1);
		_tmp171_ = key_cursor;
		cairo_pattern_add_color_stop_rgba (_tmp171_, 0.9, 0.0, 0.0, 0.0, 0.5);
		_tmp172_ = key_cursor;
		cairo_pattern_add_color_stop_rgba (_tmp172_, 1.0, 0.0, 0.0, 0.0, 0.2);
		_tmp173_ = key_cursor;
		cairo_pattern_add_color_stop_rgba (_tmp173_, 1.0, 0.0, 0.0, 0.0, 0.0);
		_tmp174_ = cr;
		cairo_save (_tmp174_);
		_tmp175_ = cr;
		_tmp176_ = key_centre[0];
		_tmp177_ = minefield_view_get_mine_size (self);
		_tmp178_ = _tmp177_;
		_tmp179_ = key_centre[1];
		_tmp180_ = minefield_view_get_mine_size (self);
		_tmp181_ = _tmp180_;
		_tmp182_ = minefield_view_get_mine_size (self);
		_tmp183_ = _tmp182_;
		_tmp184_ = minefield_view_get_mine_size (self);
		_tmp185_ = _tmp184_;
		cairo_rectangle (_tmp175_, _tmp176_ - (0.45 * _tmp178_), _tmp179_ - (0.45 * _tmp181_), 0.9 * _tmp183_, 0.9 * _tmp185_);
		_tmp186_ = cr;
		_tmp187_ = key_cursor;
		cairo_set_source (_tmp186_, _tmp187_);
		_tmp188_ = cr;
		cairo_fill (_tmp188_);
		_tmp189_ = cr;
		cairo_restore (_tmp189_);
		_cairo_pattern_destroy0 (key_cursor);
	}
	_tmp190_ = minefield_view_get_minefield (self);
	_tmp191_ = _tmp190_;
	_tmp192_ = minefield_get_paused (_tmp191_);
	_tmp193_ = _tmp192_;
	if (_tmp193_) {
		cairo_t* _tmp194_;
		cairo_t* _tmp195_;
		cairo_t* _tmp196_;
		cairo_t* _tmp197_;
		gint _tmp198_ = 0;
		const gchar* _tmp199_ = NULL;
		gchar* _tmp200_;
		gchar* text;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp201_;
		const gchar* _tmp202_;
		cairo_text_extents_t _tmp203_ = {0};
		cairo_t* _tmp204_;
		gint _tmp205_ = 0;
		cairo_text_extents_t _tmp206_;
		gdouble _tmp207_;
		gint _tmp208_ = 0;
		cairo_text_extents_t _tmp209_;
		gdouble _tmp210_;
		cairo_t* _tmp211_;
		cairo_t* _tmp212_;
		const gchar* _tmp213_;
		_tmp194_ = cr;
		cairo_set_source_rgba (_tmp194_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
		_tmp195_ = cr;
		cairo_paint (_tmp195_);
		_tmp196_ = cr;
		cairo_select_font_face (_tmp196_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		_tmp197_ = cr;
		_tmp198_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		cairo_set_font_size (_tmp197_, _tmp198_ * 0.125);
		_tmp199_ = _ ("Paused");
		_tmp200_ = g_strdup (_tmp199_);
		text = _tmp200_;
		_tmp201_ = cr;
		_tmp202_ = text;
		cairo_text_extents (_tmp201_, _tmp202_, &_tmp203_);
		extents = _tmp203_;
		_tmp204_ = cr;
		_tmp205_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp206_ = extents;
		_tmp207_ = _tmp206_.width;
		_tmp208_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp209_ = extents;
		_tmp210_ = _tmp209_.height;
		cairo_move_to (_tmp204_, (_tmp205_ - _tmp207_) / 2.0, (_tmp208_ + _tmp210_) / 2.0);
		_tmp211_ = cr;
		cairo_set_source_rgb (_tmp211_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp212_ = cr;
		_tmp213_ = text;
		cairo_show_text (_tmp212_, _tmp213_);
		_g_free0 (text);
	}
	result = FALSE;
	dots = (g_free (dots), NULL);
	_cairo_pattern_destroy0 (pattern);
	return result;
}


static void minefield_view_toggle_mark (MinefieldView* self, guint x, guint y) {
	Minefield* _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gboolean _tmp4_ = FALSE;
	Minefield* _tmp5_;
	Minefield* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	FlagType _tmp9_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = y;
	_tmp4_ = minefield_is_cleared (_tmp1_, _tmp2_, _tmp3_);
	if (_tmp4_) {
		return;
	}
	_tmp5_ = minefield_view_get_minefield (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = x;
	_tmp8_ = y;
	_tmp9_ = minefield_get_flag (_tmp6_, _tmp7_, _tmp8_);
	switch (_tmp9_) {
		case FLAG_TYPE_NONE:
		{
			gboolean _tmp10_ = FALSE;
			Minefield* _tmp11_;
			Minefield* _tmp12_;
			guint _tmp13_;
			guint _tmp14_;
			Minefield* _tmp15_;
			Minefield* _tmp16_;
			guint _tmp17_;
			gboolean _tmp19_;
			_tmp11_ = minefield_view_get_minefield (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = minefield_get_n_flags (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = minefield_view_get_minefield (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_->n_mines;
			if (_tmp14_ >= _tmp17_) {
				gboolean _tmp18_;
				_tmp18_ = self->priv->use_question_marks;
				_tmp10_ = _tmp18_;
			} else {
				_tmp10_ = FALSE;
			}
			_tmp19_ = _tmp10_;
			if (_tmp19_) {
				Minefield* _tmp20_;
				Minefield* _tmp21_;
				guint _tmp22_;
				guint _tmp23_;
				_tmp20_ = minefield_view_get_minefield (self);
				_tmp21_ = _tmp20_;
				_tmp22_ = x;
				_tmp23_ = y;
				minefield_set_flag (_tmp21_, _tmp22_, _tmp23_, FLAG_TYPE_MAYBE);
			} else {
				Minefield* _tmp24_;
				Minefield* _tmp25_;
				guint _tmp26_;
				guint _tmp27_;
				_tmp24_ = minefield_view_get_minefield (self);
				_tmp25_ = _tmp24_;
				_tmp26_ = x;
				_tmp27_ = y;
				minefield_set_flag (_tmp25_, _tmp26_, _tmp27_, FLAG_TYPE_FLAG);
			}
			break;
		}
		case FLAG_TYPE_MAYBE:
		{
			Minefield* _tmp28_;
			Minefield* _tmp29_;
			guint _tmp30_;
			guint _tmp31_;
			_tmp28_ = minefield_view_get_minefield (self);
			_tmp29_ = _tmp28_;
			_tmp30_ = x;
			_tmp31_ = y;
			minefield_set_flag (_tmp29_, _tmp30_, _tmp31_, FLAG_TYPE_NONE);
			break;
		}
		case FLAG_TYPE_FLAG:
		{
			gboolean _tmp32_;
			_tmp32_ = self->priv->use_question_marks;
			if (_tmp32_) {
				Minefield* _tmp33_;
				Minefield* _tmp34_;
				guint _tmp35_;
				guint _tmp36_;
				_tmp33_ = minefield_view_get_minefield (self);
				_tmp34_ = _tmp33_;
				_tmp35_ = x;
				_tmp36_ = y;
				minefield_set_flag (_tmp34_, _tmp35_, _tmp36_, FLAG_TYPE_MAYBE);
			} else {
				Minefield* _tmp37_;
				Minefield* _tmp38_;
				guint _tmp39_;
				guint _tmp40_;
				_tmp37_ = minefield_view_get_minefield (self);
				_tmp38_ = _tmp37_;
				_tmp39_ = x;
				_tmp40_ = y;
				minefield_set_flag (_tmp38_, _tmp39_, _tmp40_, FLAG_TYPE_NONE);
			}
			break;
		}
		default:
		break;
	}
}


static void minefield_view_redraw_adjacent (MinefieldView* self, guint x, guint y) {
	g_return_if_fail (self != NULL);
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				guint _tmp0_;
				Neighbour _tmp1_;
				gint _tmp2_;
				gint nx;
				guint _tmp3_;
				Neighbour _tmp4_;
				gint _tmp5_;
				gint ny;
				Minefield* _tmp6_;
				Minefield* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				gboolean _tmp10_ = FALSE;
				_tmp0_ = x;
				_tmp1_ = neighbour;
				_tmp2_ = _tmp1_.x;
				nx = ((gint) _tmp0_) + _tmp2_;
				_tmp3_ = y;
				_tmp4_ = neighbour;
				_tmp5_ = _tmp4_.y;
				ny = ((gint) _tmp3_) + _tmp5_;
				_tmp6_ = minefield_view_get_minefield (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = nx;
				_tmp9_ = ny;
				_tmp10_ = minefield_is_location (_tmp7_, _tmp8_, _tmp9_);
				if (_tmp10_) {
					gint _tmp11_;
					gint _tmp12_;
					_tmp11_ = nx;
					_tmp12_ = ny;
					minefield_view_redraw_sector_cb (self, (guint) _tmp11_, (guint) _tmp12_);
				}
			}
		}
	}
}


static gpointer _minefield_ref0 (gpointer self) {
	return self ? minefield_ref (self) : NULL;
}


static void minefield_view_multi_release (MinefieldView* self, guint x, guint y) {
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp11_;
	Minefield* _tmp12_;
	Minefield* _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	guint _tmp16_ = 0U;
	guint n_mines;
	guint n_flags;
	guint n_unknown;
	gboolean do_clear;
	guint _tmp40_;
	guint _tmp41_;
	Minefield* _tmp47_;
	Minefield* _tmp48_;
	Minefield* _tmp49_;
	Minefield* m;
	g_return_if_fail (self != NULL);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = x;
	_tmp4_ = y;
	_tmp5_ = minefield_is_cleared (_tmp2_, _tmp3_, _tmp4_);
	if (!_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp6_;
		Minefield* _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
		FlagType _tmp10_ = 0;
		_tmp6_ = minefield_view_get_minefield (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = x;
		_tmp9_ = y;
		_tmp10_ = minefield_get_flag (_tmp7_, _tmp8_, _tmp9_);
		_tmp0_ = _tmp10_ == FLAG_TYPE_FLAG;
	}
	_tmp11_ = _tmp0_;
	if (_tmp11_) {
		return;
	}
	_tmp12_ = minefield_view_get_minefield (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = x;
	_tmp15_ = y;
	_tmp16_ = minefield_get_n_adjacent_mines (_tmp13_, _tmp14_, _tmp15_);
	n_mines = _tmp16_;
	n_flags = (guint) 0;
	n_unknown = (guint) 0;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				guint _tmp17_;
				Neighbour _tmp18_;
				gint _tmp19_;
				gint nx;
				guint _tmp20_;
				Neighbour _tmp21_;
				gint _tmp22_;
				gint ny;
				Minefield* _tmp23_;
				Minefield* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gboolean _tmp27_ = FALSE;
				Minefield* _tmp28_;
				Minefield* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				FlagType _tmp32_ = 0;
				Minefield* _tmp34_;
				Minefield* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				gboolean _tmp38_ = FALSE;
				_tmp17_ = x;
				_tmp18_ = neighbour;
				_tmp19_ = _tmp18_.x;
				nx = ((gint) _tmp17_) + _tmp19_;
				_tmp20_ = y;
				_tmp21_ = neighbour;
				_tmp22_ = _tmp21_.y;
				ny = ((gint) _tmp20_) + _tmp22_;
				_tmp23_ = minefield_view_get_minefield (self);
				_tmp24_ = _tmp23_;
				_tmp25_ = nx;
				_tmp26_ = ny;
				_tmp27_ = minefield_is_location (_tmp24_, _tmp25_, _tmp26_);
				if (!_tmp27_) {
					continue;
				}
				_tmp28_ = minefield_view_get_minefield (self);
				_tmp29_ = _tmp28_;
				_tmp30_ = nx;
				_tmp31_ = ny;
				_tmp32_ = minefield_get_flag (_tmp29_, (guint) _tmp30_, (guint) _tmp31_);
				if (_tmp32_ == FLAG_TYPE_FLAG) {
					guint _tmp33_;
					_tmp33_ = n_flags;
					n_flags = _tmp33_ + 1;
				}
				_tmp34_ = minefield_view_get_minefield (self);
				_tmp35_ = _tmp34_;
				_tmp36_ = nx;
				_tmp37_ = ny;
				_tmp38_ = minefield_is_cleared (_tmp35_, (guint) _tmp36_, (guint) _tmp37_);
				if (!_tmp38_) {
					guint _tmp39_;
					_tmp39_ = n_unknown;
					n_unknown = _tmp39_ + 1;
				}
			}
		}
	}
	do_clear = FALSE;
	_tmp40_ = n_mines;
	_tmp41_ = n_flags;
	if (_tmp40_ == _tmp41_) {
		do_clear = TRUE;
	} else {
		gboolean _tmp42_ = FALSE;
		gboolean _tmp43_;
		gboolean _tmp46_;
		_tmp43_ = self->priv->use_autoflag;
		if (_tmp43_) {
			guint _tmp44_;
			guint _tmp45_;
			_tmp44_ = n_unknown;
			_tmp45_ = n_mines;
			_tmp42_ = _tmp44_ == _tmp45_;
		} else {
			_tmp42_ = FALSE;
		}
		_tmp46_ = _tmp42_;
		if (_tmp46_) {
			do_clear = FALSE;
		} else {
			return;
		}
	}
	_tmp47_ = minefield_view_get_minefield (self);
	_tmp48_ = _tmp47_;
	_tmp49_ = _minefield_ref0 (_tmp48_);
	m = _tmp49_;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				guint _tmp50_;
				Neighbour _tmp51_;
				gint _tmp52_;
				gint nx;
				guint _tmp53_;
				Neighbour _tmp54_;
				gint _tmp55_;
				gint ny;
				Minefield* _tmp56_;
				gint _tmp57_;
				gint _tmp58_;
				gboolean _tmp59_ = FALSE;
				gboolean _tmp60_ = FALSE;
				gboolean _tmp61_;
				gboolean _tmp66_;
				_tmp50_ = x;
				_tmp51_ = neighbour;
				_tmp52_ = _tmp51_.x;
				nx = ((gint) _tmp50_) + _tmp52_;
				_tmp53_ = y;
				_tmp54_ = neighbour;
				_tmp55_ = _tmp54_.y;
				ny = ((gint) _tmp53_) + _tmp55_;
				_tmp56_ = m;
				_tmp57_ = nx;
				_tmp58_ = ny;
				_tmp59_ = minefield_is_location (_tmp56_, _tmp57_, _tmp58_);
				if (!_tmp59_) {
					continue;
				}
				_tmp61_ = do_clear;
				if (_tmp61_) {
					Minefield* _tmp62_;
					gint _tmp63_;
					gint _tmp64_;
					FlagType _tmp65_ = 0;
					_tmp62_ = m;
					_tmp63_ = nx;
					_tmp64_ = ny;
					_tmp65_ = minefield_get_flag (_tmp62_, (guint) _tmp63_, (guint) _tmp64_);
					_tmp60_ = _tmp65_ != FLAG_TYPE_FLAG;
				} else {
					_tmp60_ = FALSE;
				}
				_tmp66_ = _tmp60_;
				if (_tmp66_) {
					Minefield* _tmp67_;
					gint _tmp68_;
					gint _tmp69_;
					_tmp67_ = m;
					_tmp68_ = nx;
					_tmp69_ = ny;
					minefield_clear_mine (_tmp67_, (guint) _tmp68_, (guint) _tmp69_);
				} else {
					Minefield* _tmp70_;
					gint _tmp71_;
					gint _tmp72_;
					_tmp70_ = m;
					_tmp71_ = nx;
					_tmp72_ = ny;
					minefield_set_flag (_tmp70_, (guint) _tmp71_, (guint) _tmp72_, FLAG_TYPE_FLAG);
				}
			}
		}
	}
	_minefield_unref0 (m);
}


static gboolean minefield_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	GdkEventButton _tmp0_;
	GdkEventType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp4_;
	Minefield* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp11_;
	gboolean _tmp16_;
	gboolean _tmp17_ = FALSE;
	Position* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp24_;
	Position* _tmp25_;
	Position* _tmp26_;
	GdkEventButton _tmp27_;
	gdouble _tmp28_;
	guint _tmp29_;
	guint _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	gdouble _tmp33_ = 0.0;
	Position* _tmp34_;
	GdkEventButton _tmp35_;
	gdouble _tmp36_;
	guint _tmp37_;
	guint _tmp38_;
	guint _tmp39_;
	guint _tmp40_;
	gdouble _tmp41_ = 0.0;
	Position* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_ = FALSE;
	GdkEventButton _tmp46_;
	guint _tmp47_;
	gboolean _tmp54_;
	Position* _tmp64_;
	Position* _tmp65_;
	Position* _tmp66_;
	gint _tmp67_;
	gint _tmp68_;
	Position* _tmp69_;
	gint _tmp70_;
	gint _tmp71_;
	gint* _tmp72_ = NULL;
	gint* _tmp73_;
	gint _tmp73__length1;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ != GDK_BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp4_ = minefield_view_get_minefield (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->exploded;
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		Minefield* _tmp7_;
		Minefield* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = minefield_get_is_complete (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp10_;
	}
	_tmp11_ = _tmp3_;
	if (_tmp11_) {
		_tmp2_ = TRUE;
	} else {
		Minefield* _tmp12_;
		Minefield* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = minefield_view_get_minefield (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = minefield_get_paused (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp2_ = _tmp15_;
	}
	_tmp16_ = _tmp2_;
	if (_tmp16_) {
		result = FALSE;
		return result;
	}
	_tmp18_ = self->priv->selected;
	_tmp19_ = position_get_is_set (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_) {
		Position* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp21_ = self->priv->keyboard_cursor;
		_tmp22_ = position_get_is_set (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp17_ = _tmp23_;
	} else {
		_tmp17_ = FALSE;
	}
	_tmp24_ = _tmp17_;
	if (_tmp24_) {
		result = FALSE;
		return result;
	}
	_tmp25_ = self->priv->selected;
	position_set_is_set (_tmp25_, FALSE);
	_tmp26_ = self->priv->selected;
	_tmp27_ = *event;
	_tmp28_ = _tmp27_.x;
	_tmp29_ = minefield_view_get_x_offset (self);
	_tmp30_ = _tmp29_;
	_tmp31_ = minefield_view_get_mine_size (self);
	_tmp32_ = _tmp31_;
	_tmp33_ = floor ((_tmp28_ - _tmp30_) / _tmp32_);
	position_set_x (_tmp26_, (gint) _tmp33_);
	_tmp34_ = self->priv->selected;
	_tmp35_ = *event;
	_tmp36_ = _tmp35_.y;
	_tmp37_ = minefield_view_get_y_offset (self);
	_tmp38_ = _tmp37_;
	_tmp39_ = minefield_view_get_mine_size (self);
	_tmp40_ = _tmp39_;
	_tmp41_ = floor ((_tmp36_ - _tmp38_) / _tmp40_);
	position_set_y (_tmp34_, (gint) _tmp41_);
	_tmp42_ = self->priv->selected;
	_tmp43_ = position_get_is_valid (_tmp42_);
	_tmp44_ = _tmp43_;
	if (!_tmp44_) {
		result = FALSE;
		return result;
	}
	_tmp46_ = *event;
	_tmp47_ = _tmp46_.button;
	if (_tmp47_ == ((guint) 3)) {
		_tmp45_ = TRUE;
	} else {
		gboolean _tmp48_ = FALSE;
		GdkEventButton _tmp49_;
		guint _tmp50_;
		gboolean _tmp53_;
		_tmp49_ = *event;
		_tmp50_ = _tmp49_.button;
		if (_tmp50_ == ((guint) 1)) {
			GdkEventButton _tmp51_;
			GdkModifierType _tmp52_;
			_tmp51_ = *event;
			_tmp52_ = _tmp51_.state;
			_tmp48_ = (_tmp52_ & GDK_CONTROL_MASK) != 0;
		} else {
			_tmp48_ = FALSE;
		}
		_tmp53_ = _tmp48_;
		_tmp45_ = _tmp53_;
	}
	_tmp54_ = _tmp45_;
	if (_tmp54_) {
		Position* _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		Position* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		_tmp55_ = self->priv->selected;
		_tmp56_ = position_get_x (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = self->priv->selected;
		_tmp59_ = position_get_y (_tmp58_);
		_tmp60_ = _tmp59_;
		minefield_view_toggle_mark (self, (guint) _tmp57_, (guint) _tmp60_);
		g_signal_emit_by_name (self, "unlook");
	} else {
		GdkEventButton _tmp61_;
		guint _tmp62_;
		_tmp61_ = *event;
		_tmp62_ = _tmp61_.button;
		if (_tmp62_ == ((guint) 1)) {
			Position* _tmp63_;
			_tmp63_ = self->priv->selected;
			position_set_is_set (_tmp63_, TRUE);
			g_signal_emit_by_name (self, "look");
		}
	}
	_tmp64_ = self->priv->keyboard_cursor;
	position_set_is_set (_tmp64_, FALSE);
	_tmp65_ = self->priv->keyboard_cursor;
	_tmp66_ = self->priv->selected;
	_tmp67_ = position_get_x (_tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = self->priv->selected;
	_tmp70_ = position_get_y (_tmp69_);
	_tmp71_ = _tmp70_;
	_tmp72_ = g_new0 (gint, 2);
	_tmp72_[0] = _tmp68_;
	_tmp72_[1] = _tmp71_;
	_tmp73_ = _tmp72_;
	_tmp73__length1 = 2;
	position_set_position (_tmp65_, _tmp73_, 2);
	_tmp73_ = (g_free (_tmp73_), NULL);
	result = FALSE;
	return result;
}


static gboolean minefield_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Minefield* _tmp2_;
	Minefield* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp9_;
	gboolean _tmp14_;
	gboolean _tmp15_ = FALSE;
	Position* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp22_;
	GdkEventMotion _tmp23_;
	gdouble _tmp24_;
	guint _tmp25_;
	guint _tmp26_;
	guint _tmp27_;
	guint _tmp28_;
	gdouble _tmp29_ = 0.0;
	gint x;
	GdkEventMotion _tmp30_;
	gdouble _tmp31_;
	guint _tmp32_;
	guint _tmp33_;
	guint _tmp34_;
	guint _tmp35_;
	gdouble _tmp36_ = 0.0;
	gint y;
	Position* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gint* _tmp40_ = NULL;
	gint* _tmp41_;
	gint _tmp41__length1;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = minefield_view_get_minefield (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->exploded;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		Minefield* _tmp5_;
		Minefield* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = minefield_view_get_minefield (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = minefield_get_is_complete (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp1_ = _tmp8_;
	}
	_tmp9_ = _tmp1_;
	if (_tmp9_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp10_;
		Minefield* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp10_ = minefield_view_get_minefield (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = minefield_get_paused (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp0_ = _tmp13_;
	}
	_tmp14_ = _tmp0_;
	if (_tmp14_) {
		result = FALSE;
		return result;
	}
	_tmp16_ = self->priv->selected;
	_tmp17_ = position_get_is_set (_tmp16_);
	_tmp18_ = _tmp17_;
	if (!_tmp18_) {
		_tmp15_ = TRUE;
	} else {
		Position* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp19_ = self->priv->keyboard_cursor;
		_tmp20_ = position_get_is_set (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = _tmp21_;
	}
	_tmp22_ = _tmp15_;
	if (_tmp22_) {
		result = FALSE;
		return result;
	}
	_tmp23_ = *event;
	_tmp24_ = _tmp23_.x;
	_tmp25_ = minefield_view_get_x_offset (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = minefield_view_get_mine_size (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = floor ((_tmp24_ - _tmp26_) / _tmp28_);
	x = (gint) _tmp29_;
	_tmp30_ = *event;
	_tmp31_ = _tmp30_.y;
	_tmp32_ = minefield_view_get_y_offset (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = minefield_view_get_mine_size (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = floor ((_tmp31_ - _tmp33_) / _tmp35_);
	y = (gint) _tmp36_;
	_tmp37_ = self->priv->selected;
	_tmp38_ = x;
	_tmp39_ = y;
	_tmp40_ = g_new0 (gint, 2);
	_tmp40_[0] = _tmp38_;
	_tmp40_[1] = _tmp39_;
	_tmp41_ = _tmp40_;
	_tmp41__length1 = 2;
	position_set_position (_tmp37_, _tmp41_, 2);
	_tmp41_ = (g_free (_tmp41_), NULL);
	result = FALSE;
	return result;
}


static gboolean minefield_view_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	GdkEventButton _tmp0_;
	guint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp4_;
	Minefield* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp11_;
	gboolean _tmp16_;
	gboolean _tmp17_ = FALSE;
	Position* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp24_;
	Minefield* _tmp25_;
	Minefield* _tmp26_;
	Position* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	Position* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gboolean _tmp33_ = FALSE;
	Position* _tmp63_;
	Position* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	Position* _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	gint* _tmp70_ = NULL;
	gint* _tmp71_;
	gint _tmp71__length1;
	Position* _tmp72_;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.button;
	if (_tmp1_ != ((guint) 1)) {
		result = FALSE;
		return result;
	}
	_tmp4_ = minefield_view_get_minefield (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->exploded;
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		Minefield* _tmp7_;
		Minefield* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = minefield_get_is_complete (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp10_;
	}
	_tmp11_ = _tmp3_;
	if (_tmp11_) {
		_tmp2_ = TRUE;
	} else {
		Minefield* _tmp12_;
		Minefield* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = minefield_view_get_minefield (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = minefield_get_paused (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp2_ = _tmp15_;
	}
	_tmp16_ = _tmp2_;
	if (_tmp16_) {
		result = FALSE;
		return result;
	}
	_tmp18_ = self->priv->selected;
	_tmp19_ = position_get_is_set (_tmp18_);
	_tmp20_ = _tmp19_;
	if (!_tmp20_) {
		_tmp17_ = TRUE;
	} else {
		Position* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp21_ = self->priv->keyboard_cursor;
		_tmp22_ = position_get_is_set (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp17_ = _tmp23_;
	}
	_tmp24_ = _tmp17_;
	if (_tmp24_) {
		result = FALSE;
		return result;
	}
	g_signal_emit_by_name (self, "unlook");
	_tmp25_ = minefield_view_get_minefield (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->selected;
	_tmp28_ = position_get_x (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = self->priv->selected;
	_tmp31_ = position_get_y (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = minefield_is_cleared (_tmp26_, (guint) _tmp29_, (guint) _tmp32_);
	if (_tmp33_) {
		Position* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		Position* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		Position* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		Position* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		_tmp34_ = self->priv->selected;
		_tmp35_ = position_get_x (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = self->priv->selected;
		_tmp38_ = position_get_y (_tmp37_);
		_tmp39_ = _tmp38_;
		minefield_view_multi_release (self, (guint) _tmp36_, (guint) _tmp39_);
		_tmp40_ = self->priv->selected;
		_tmp41_ = position_get_x (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = self->priv->selected;
		_tmp44_ = position_get_y (_tmp43_);
		_tmp45_ = _tmp44_;
		minefield_view_redraw_adjacent (self, (guint) _tmp42_, (guint) _tmp45_);
	} else {
		Minefield* _tmp46_;
		Minefield* _tmp47_;
		Position* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		Position* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		FlagType _tmp54_ = 0;
		_tmp46_ = minefield_view_get_minefield (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = self->priv->selected;
		_tmp49_ = position_get_x (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = self->priv->selected;
		_tmp52_ = position_get_y (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = minefield_get_flag (_tmp47_, (guint) _tmp50_, (guint) _tmp53_);
		if (_tmp54_ != FLAG_TYPE_FLAG) {
			Minefield* _tmp55_;
			Minefield* _tmp56_;
			Position* _tmp57_;
			gint _tmp58_;
			gint _tmp59_;
			Position* _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			_tmp55_ = minefield_view_get_minefield (self);
			_tmp56_ = _tmp55_;
			_tmp57_ = self->priv->selected;
			_tmp58_ = position_get_x (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = self->priv->selected;
			_tmp61_ = position_get_y (_tmp60_);
			_tmp62_ = _tmp61_;
			minefield_clear_mine (_tmp56_, (guint) _tmp59_, (guint) _tmp62_);
		}
	}
	_tmp63_ = self->priv->keyboard_cursor;
	_tmp64_ = self->priv->selected;
	_tmp65_ = position_get_x (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = self->priv->selected;
	_tmp68_ = position_get_y (_tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = g_new0 (gint, 2);
	_tmp70_[0] = _tmp66_;
	_tmp70_[1] = _tmp69_;
	_tmp71_ = _tmp70_;
	_tmp71__length1 = 2;
	position_set_position (_tmp63_, _tmp71_, 2);
	_tmp71_ = (g_free (_tmp71_), NULL);
	_tmp72_ = self->priv->selected;
	position_set_is_set (_tmp72_, FALSE);
	result = FALSE;
	return result;
}


static gboolean minefield_view_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Minefield* _tmp2_;
	Minefield* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp9_;
	gboolean _tmp14_;
	gboolean _tmp15_ = FALSE;
	Position* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp22_;
	Position* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint x;
	Position* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint y;
	GdkEventKey _tmp29_;
	guint _tmp30_;
	gboolean _tmp53_ = FALSE;
	gint _tmp54_;
	Position* _tmp55_;
	gint _tmp56_;
	gint _tmp57_;
	gboolean _tmp62_;
	Position* _tmp63_;
	gboolean _tmp64_;
	gboolean _tmp65_;
	Position* _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	gint* _tmp70_ = NULL;
	gint* _tmp71_;
	gint _tmp71__length1;
	Position* _tmp72_;
	gboolean _tmp73_;
	gboolean _tmp74_;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = minefield_view_get_minefield (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->exploded;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		Minefield* _tmp5_;
		Minefield* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = minefield_view_get_minefield (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = minefield_get_is_complete (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp1_ = _tmp8_;
	}
	_tmp9_ = _tmp1_;
	if (_tmp9_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp10_;
		Minefield* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp10_ = minefield_view_get_minefield (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = minefield_get_paused (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp0_ = _tmp13_;
	}
	_tmp14_ = _tmp0_;
	if (_tmp14_) {
		result = FALSE;
		return result;
	}
	_tmp16_ = self->priv->selected;
	_tmp17_ = position_get_is_set (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		Position* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp19_ = self->priv->keyboard_cursor;
		_tmp20_ = position_get_is_set (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = !_tmp21_;
	} else {
		_tmp15_ = FALSE;
	}
	_tmp22_ = _tmp15_;
	if (_tmp22_) {
		result = FALSE;
		return result;
	}
	_tmp23_ = self->priv->keyboard_cursor;
	_tmp24_ = position_get_x (_tmp23_);
	_tmp25_ = _tmp24_;
	x = _tmp25_;
	_tmp26_ = self->priv->keyboard_cursor;
	_tmp27_ = position_get_y (_tmp26_);
	_tmp28_ = _tmp27_;
	y = _tmp28_;
	_tmp29_ = *event;
	_tmp30_ = _tmp29_.keyval;
	switch (_tmp30_) {
		case GDK_KEY_Left:
		case GDK_KEY_h:
		{
			gint _tmp31_;
			_tmp31_ = x;
			x = _tmp31_ - 1;
			break;
		}
		case GDK_KEY_Right:
		case GDK_KEY_l:
		{
			gint _tmp32_;
			_tmp32_ = x;
			x = _tmp32_ + 1;
			break;
		}
		case GDK_KEY_Up:
		case GDK_KEY_k:
		{
			gint _tmp33_;
			_tmp33_ = y;
			y = _tmp33_ - 1;
			break;
		}
		case GDK_KEY_Down:
		case GDK_KEY_j:
		{
			gint _tmp34_;
			_tmp34_ = y;
			y = _tmp34_ + 1;
			break;
		}
		case GDK_KEY_space:
		case GDK_KEY_Return:
		{
			Position* _tmp35_;
			gboolean _tmp36_;
			gboolean _tmp37_;
			_tmp35_ = self->priv->keyboard_cursor;
			_tmp36_ = position_get_is_set (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_) {
				Position* _tmp38_;
				GdkEventKey _tmp39_;
				GdkModifierType _tmp40_;
				_tmp38_ = self->priv->selected;
				position_set_is_set (_tmp38_, FALSE);
				_tmp39_ = *event;
				_tmp40_ = _tmp39_.state;
				if ((_tmp40_ & GDK_CONTROL_MASK) != 0) {
					Position* _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					Position* _tmp44_;
					gint _tmp45_;
					gint _tmp46_;
					_tmp41_ = self->priv->keyboard_cursor;
					_tmp42_ = position_get_x (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = self->priv->keyboard_cursor;
					_tmp45_ = position_get_y (_tmp44_);
					_tmp46_ = _tmp45_;
					minefield_view_toggle_mark (self, (guint) _tmp43_, (guint) _tmp46_);
				} else {
					Position* _tmp47_;
					gint _tmp48_;
					gint _tmp49_;
					gint* _tmp50_ = NULL;
					gint* _tmp51_;
					gint _tmp51__length1;
					Position* _tmp52_;
					_tmp47_ = self->priv->selected;
					_tmp48_ = x;
					_tmp49_ = y;
					_tmp50_ = g_new0 (gint, 2);
					_tmp50_[0] = _tmp48_;
					_tmp50_[1] = _tmp49_;
					_tmp51_ = _tmp50_;
					_tmp51__length1 = 2;
					position_set_position (_tmp47_, _tmp51_, 2);
					_tmp51_ = (g_free (_tmp51_), NULL);
					_tmp52_ = self->priv->selected;
					position_set_is_set (_tmp52_, TRUE);
					g_signal_emit_by_name (self, "look");
				}
			}
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	_tmp54_ = x;
	_tmp55_ = self->priv->keyboard_cursor;
	_tmp56_ = position_get_x (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp54_ == _tmp57_) {
		gint _tmp58_;
		Position* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		_tmp58_ = y;
		_tmp59_ = self->priv->keyboard_cursor;
		_tmp60_ = position_get_y (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp53_ = _tmp58_ == _tmp61_;
	} else {
		_tmp53_ = FALSE;
	}
	_tmp62_ = _tmp53_;
	if (_tmp62_) {
		result = TRUE;
		return result;
	}
	_tmp63_ = self->priv->keyboard_cursor;
	_tmp64_ = position_get_is_set (_tmp63_);
	_tmp65_ = _tmp64_;
	if (!_tmp65_) {
		Position* _tmp66_;
		_tmp66_ = self->priv->keyboard_cursor;
		position_set_is_set (_tmp66_, TRUE);
		result = TRUE;
		return result;
	}
	_tmp67_ = self->priv->keyboard_cursor;
	_tmp68_ = x;
	_tmp69_ = y;
	_tmp70_ = g_new0 (gint, 2);
	_tmp70_[0] = _tmp68_;
	_tmp70_[1] = _tmp69_;
	_tmp71_ = _tmp70_;
	_tmp71__length1 = 2;
	position_set_position (_tmp67_, _tmp71_, 2);
	_tmp71_ = (g_free (_tmp71_), NULL);
	_tmp72_ = self->priv->selected;
	_tmp73_ = position_get_is_set (_tmp72_);
	_tmp74_ = _tmp73_;
	if (_tmp74_) {
		Position* _tmp75_;
		Position* _tmp76_;
		gint _tmp77_;
		gint _tmp78_;
		Position* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint* _tmp82_ = NULL;
		gint* _tmp83_;
		gint _tmp83__length1;
		_tmp75_ = self->priv->selected;
		_tmp76_ = self->priv->keyboard_cursor;
		_tmp77_ = position_get_x (_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = self->priv->keyboard_cursor;
		_tmp80_ = position_get_y (_tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = g_new0 (gint, 2);
		_tmp82_[0] = _tmp78_;
		_tmp82_[1] = _tmp81_;
		_tmp83_ = _tmp82_;
		_tmp83__length1 = 2;
		position_set_position (_tmp75_, _tmp83_, 2);
		_tmp83_ = (g_free (_tmp83_), NULL);
	}
	result = TRUE;
	return result;
}


static gboolean minefield_view_real_key_release_event (GtkWidget* base, GdkEventKey* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	GdkEventKey _tmp0_;
	guint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp4_;
	Minefield* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp11_;
	gboolean _tmp16_;
	gboolean _tmp17_ = FALSE;
	Position* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp24_;
	Minefield* _tmp25_;
	Minefield* _tmp26_;
	Position* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	Position* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gboolean _tmp33_ = FALSE;
	Position* _tmp63_;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.keyval;
	if (_tmp1_ != ((guint) GDK_KEY_space)) {
		result = FALSE;
		return result;
	}
	_tmp4_ = minefield_view_get_minefield (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->exploded;
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		Minefield* _tmp7_;
		Minefield* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = minefield_get_is_complete (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp10_;
	}
	_tmp11_ = _tmp3_;
	if (_tmp11_) {
		_tmp2_ = TRUE;
	} else {
		Minefield* _tmp12_;
		Minefield* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = minefield_view_get_minefield (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = minefield_get_paused (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp2_ = _tmp15_;
	}
	_tmp16_ = _tmp2_;
	if (_tmp16_) {
		result = FALSE;
		return result;
	}
	_tmp18_ = self->priv->selected;
	_tmp19_ = position_get_is_set (_tmp18_);
	_tmp20_ = _tmp19_;
	if (!_tmp20_) {
		_tmp17_ = TRUE;
	} else {
		Position* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp21_ = self->priv->keyboard_cursor;
		_tmp22_ = position_get_is_set (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp17_ = !_tmp23_;
	}
	_tmp24_ = _tmp17_;
	if (_tmp24_) {
		result = FALSE;
		return result;
	}
	g_signal_emit_by_name (self, "unlook");
	_tmp25_ = minefield_view_get_minefield (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->selected;
	_tmp28_ = position_get_x (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = self->priv->selected;
	_tmp31_ = position_get_y (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = minefield_is_cleared (_tmp26_, (guint) _tmp29_, (guint) _tmp32_);
	if (_tmp33_) {
		Position* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		Position* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		Position* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		Position* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		_tmp34_ = self->priv->selected;
		_tmp35_ = position_get_x (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = self->priv->selected;
		_tmp38_ = position_get_y (_tmp37_);
		_tmp39_ = _tmp38_;
		minefield_view_multi_release (self, (guint) _tmp36_, (guint) _tmp39_);
		_tmp40_ = self->priv->selected;
		_tmp41_ = position_get_x (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = self->priv->selected;
		_tmp44_ = position_get_y (_tmp43_);
		_tmp45_ = _tmp44_;
		minefield_view_redraw_adjacent (self, (guint) _tmp42_, (guint) _tmp45_);
	} else {
		Minefield* _tmp46_;
		Minefield* _tmp47_;
		Position* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		Position* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		FlagType _tmp54_ = 0;
		_tmp46_ = minefield_view_get_minefield (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = self->priv->selected;
		_tmp49_ = position_get_x (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = self->priv->selected;
		_tmp52_ = position_get_y (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = minefield_get_flag (_tmp47_, (guint) _tmp50_, (guint) _tmp53_);
		if (_tmp54_ != FLAG_TYPE_FLAG) {
			Minefield* _tmp55_;
			Minefield* _tmp56_;
			Position* _tmp57_;
			gint _tmp58_;
			gint _tmp59_;
			Position* _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			_tmp55_ = minefield_view_get_minefield (self);
			_tmp56_ = _tmp55_;
			_tmp57_ = self->priv->selected;
			_tmp58_ = position_get_x (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = self->priv->selected;
			_tmp61_ = position_get_y (_tmp60_);
			_tmp62_ = _tmp61_;
			minefield_clear_mine (_tmp56_, (guint) _tmp59_, (guint) _tmp62_);
		}
	}
	_tmp63_ = self->priv->selected;
	position_set_is_set (_tmp63_, FALSE);
	result = FALSE;
	return result;
}


static guint minefield_view_get_mine_size (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	guint _tmp3_;
	gint _tmp4_ = 0;
	Minefield* _tmp5_;
	Minefield* _tmp6_;
	guint _tmp7_;
	gint _tmp8_ = 0;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->width;
	_tmp4_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp5_ = minefield_view_get_minefield (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->height;
	_tmp8_ = MIN (_tmp0_ / ((gint) _tmp3_), _tmp4_ / ((gint) _tmp7_));
	result = (guint) _tmp8_;
	return result;
}


static guint minefield_view_get_x_offset (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->width;
	_tmp4_ = minefield_view_get_mine_size (self);
	_tmp5_ = _tmp4_;
	result = (_tmp0_ - (_tmp3_ * _tmp5_)) / 2;
	return result;
}


static guint minefield_view_get_y_offset (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->height;
	_tmp4_ = minefield_view_get_mine_size (self);
	_tmp5_ = _tmp4_;
	result = (_tmp0_ - (_tmp3_ * _tmp5_)) / 2;
	return result;
}


static guint minefield_view_get_minimum_size (MinefieldView* self) {
	guint result;
	Minefield* _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	guint w;
	Minefield* _tmp3_;
	Minefield* _tmp4_;
	guint _tmp5_;
	guint h;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_ = 0U;
	guint s;
	guint _tmp9_;
	guint _tmp10_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->width;
	w = 320 / _tmp2_;
	_tmp3_ = minefield_view_get_minefield (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->height;
	h = 200 / _tmp5_;
	_tmp6_ = w;
	_tmp7_ = h;
	_tmp8_ = MIN (_tmp6_, _tmp7_);
	s = _tmp8_;
	_tmp9_ = s;
	if (_tmp9_ < ((guint) 30)) {
		s = (guint) 30;
	}
	_tmp10_ = s;
	result = _tmp10_;
	return result;
}


Minefield* minefield_view_get_minefield (MinefieldView* self) {
	Minefield* result;
	Minefield* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_minefield;
	result = _tmp0_;
	return result;
}


static void _minefield_view_redraw_sector_cb_position_redraw (Position* _sender, guint x, guint y, gpointer self) {
	minefield_view_redraw_sector_cb (self, x, y);
}


static void _minefield_view_minefield___lambda2_ (MinefieldView* self, guint x, guint y) {
	Minefield* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = self->priv->_minefield;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = minefield_is_cleared (_tmp0_, _tmp1_, _tmp2_);
	if (_tmp3_) {
		guint _tmp4_;
		guint _tmp5_;
		_tmp4_ = x;
		_tmp5_ = y;
		minefield_view_redraw_adjacent (self, _tmp4_, _tmp5_);
	}
}


static void __minefield_view_minefield___lambda2__position_redraw (Position* _sender, guint x, guint y, gpointer self) {
	_minefield_view_minefield___lambda2_ (self, x, y);
}


static gint _minefield_view_minefield___lambda3_ (MinefieldView* self, gint x) {
	gint result = 0;
	gint _tmp0_;
	_tmp0_ = x;
	result = _tmp0_;
	return result;
}


static gint __minefield_view_minefield___lambda3__position_set_x (Position* _sender, gint x, gpointer self) {
	gint result;
	result = _minefield_view_minefield___lambda3_ (self, x);
	return result;
}


static gint _minefield_view_minefield___lambda4_ (MinefieldView* self, gint y) {
	gint result = 0;
	gint _tmp0_;
	_tmp0_ = y;
	result = _tmp0_;
	return result;
}


static gint __minefield_view_minefield___lambda4__position_set_y (Position* _sender, gint y, gpointer self) {
	gint result;
	result = _minefield_view_minefield___lambda4_ (self, y);
	return result;
}


static gboolean _minefield_is_location_position_validate (Position* _sender, gint x, gint y, gpointer self) {
	gboolean result;
	result = minefield_is_location (self, x, y);
	return result;
}


static gint _minefield_view_minefield___lambda5_ (MinefieldView* self, gint x) {
	gint result = 0;
	gint _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	_tmp0_ = x;
	_tmp1_ = self->priv->_minefield;
	_tmp2_ = _tmp1_->width;
	result = (gint) (_tmp0_ % _tmp2_);
	return result;
}


static gint __minefield_view_minefield___lambda5__position_set_x (Position* _sender, gint x, gpointer self) {
	gint result;
	result = _minefield_view_minefield___lambda5_ (self, x);
	return result;
}


static gint _minefield_view_minefield___lambda6_ (MinefieldView* self, gint y) {
	gint result = 0;
	gint _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	_tmp0_ = y;
	_tmp1_ = self->priv->_minefield;
	_tmp2_ = _tmp1_->height;
	result = (gint) (_tmp0_ % _tmp2_);
	return result;
}


static gint __minefield_view_minefield___lambda6__position_set_y (Position* _sender, gint y, gpointer self) {
	gint result;
	result = _minefield_view_minefield___lambda6_ (self, y);
	return result;
}


static gboolean _minefield_view_minefield___lambda7_ (MinefieldView* self, gint x, gint y) {
	gboolean result = FALSE;
	result = TRUE;
	return result;
}


static gboolean __minefield_view_minefield___lambda7__position_validate (Position* _sender, gint x, gint y, gpointer self) {
	gboolean result;
	result = _minefield_view_minefield___lambda7_ (self, x, y);
	return result;
}


static void _minefield_view_redraw_sector_cb_minefield_redraw_sector (Minefield* _sender, guint x, guint y, gpointer self) {
	minefield_view_redraw_sector_cb (self, x, y);
}


static void _minefield_view_explode_cb_minefield_explode (Minefield* _sender, gpointer self) {
	minefield_view_explode_cb (self, _sender);
}


static void _minefield_view_minefield___lambda8_ (MinefieldView* self) {
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void __minefield_view_minefield___lambda8__minefield_paused_changed (Minefield* _sender, gpointer self) {
	_minefield_view_minefield___lambda8_ (self);
}


void minefield_view_set_minefield (MinefieldView* self, Minefield* value) {
	Minefield* _tmp0_;
	Minefield* _tmp2_;
	Minefield* _tmp3_;
	Position* _tmp4_;
	Position* _tmp5_;
	Position* _tmp6_;
	Position* _tmp7_;
	Position* _tmp8_;
	Position* _tmp9_;
	Minefield* _tmp10_;
	Position* _tmp11_;
	Position* _tmp12_;
	gint* _tmp13_ = NULL;
	gint* _tmp14_;
	gint _tmp14__length1;
	Position* _tmp15_;
	Position* _tmp16_;
	Position* _tmp17_;
	Position* _tmp18_;
	Minefield* _tmp19_;
	Minefield* _tmp20_;
	Minefield* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_minefield;
	if (_tmp0_ != NULL) {
		Minefield* _tmp1_;
		_tmp1_ = self->priv->_minefield;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = value;
	_tmp3_ = _minefield_ref0 (_tmp2_);
	_minefield_unref0 (self->priv->_minefield);
	self->priv->_minefield = _tmp3_;
	_tmp4_ = self->priv->selected;
	position_set_is_set (_tmp4_, FALSE);
	_tmp5_ = self->priv->selected;
	g_signal_connect_object (_tmp5_, "redraw", (GCallback) _minefield_view_redraw_sector_cb_position_redraw, self, 0);
	_tmp6_ = self->priv->selected;
	g_signal_connect_object (_tmp6_, "redraw", (GCallback) __minefield_view_minefield___lambda2__position_redraw, self, 0);
	_tmp7_ = self->priv->selected;
	g_signal_connect_object (_tmp7_, "set-x", (GCallback) __minefield_view_minefield___lambda3__position_set_x, self, 0);
	_tmp8_ = self->priv->selected;
	g_signal_connect_object (_tmp8_, "set-y", (GCallback) __minefield_view_minefield___lambda4__position_set_y, self, 0);
	_tmp9_ = self->priv->selected;
	_tmp10_ = self->priv->_minefield;
	g_signal_connect (_tmp9_, "validate", (GCallback) _minefield_is_location_position_validate, _tmp10_);
	_tmp11_ = self->priv->keyboard_cursor;
	position_set_is_set (_tmp11_, FALSE);
	_tmp12_ = self->priv->keyboard_cursor;
	_tmp13_ = g_new0 (gint, 2);
	_tmp13_[0] = 0;
	_tmp13_[1] = 0;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 2;
	position_set_position (_tmp12_, _tmp14_, 2);
	_tmp14_ = (g_free (_tmp14_), NULL);
	_tmp15_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp15_, "redraw", (GCallback) _minefield_view_redraw_sector_cb_position_redraw, self, 0);
	_tmp16_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp16_, "set-x", (GCallback) __minefield_view_minefield___lambda5__position_set_x, self, 0);
	_tmp17_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp17_, "set-y", (GCallback) __minefield_view_minefield___lambda6__position_set_y, self, 0);
	_tmp18_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp18_, "validate", (GCallback) __minefield_view_minefield___lambda7__position_validate, self, 0);
	_tmp19_ = self->priv->_minefield;
	g_signal_connect_object (_tmp19_, "redraw-sector", (GCallback) _minefield_view_redraw_sector_cb_minefield_redraw_sector, self, 0);
	_tmp20_ = self->priv->_minefield;
	g_signal_connect_object (_tmp20_, "explode", (GCallback) _minefield_view_explode_cb_minefield_explode, self, 0);
	_tmp21_ = self->priv->_minefield;
	g_signal_connect_object (_tmp21_, "paused-changed", (GCallback) __minefield_view_minefield___lambda8__minefield_paused_changed, self, 0);
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "minefield");
}


static void minefield_view_class_init (MinefieldViewClass * klass) {
	minefield_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MinefieldViewPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_width = minefield_view_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = minefield_view_real_get_preferred_height;
	GTK_WIDGET_CLASS (klass)->draw = minefield_view_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = minefield_view_real_button_press_event;
	GTK_WIDGET_CLASS (klass)->motion_notify_event = minefield_view_real_motion_notify_event;
	GTK_WIDGET_CLASS (klass)->button_release_event = minefield_view_real_button_release_event;
	GTK_WIDGET_CLASS (klass)->key_press_event = minefield_view_real_key_press_event;
	GTK_WIDGET_CLASS (klass)->key_release_event = minefield_view_real_key_release_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_minefield_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_minefield_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = minefield_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_VIEW_MINEFIELD, param_spec_minefield ("minefield", "minefield", "minefield", TYPE_MINEFIELD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("look", TYPE_MINEFIELD_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("unlook", TYPE_MINEFIELD_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void minefield_view_instance_init (MinefieldView * self) {
	self->priv = MINEFIELD_VIEW_GET_PRIVATE (self);
	self->priv->render_size = (guint) 0;
}


static void minefield_view_finalize (GObject* obj) {
	MinefieldView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINEFIELD_VIEW, MinefieldView);
	_g_object_unref0 (self->priv->keyboard_cursor);
	_g_object_unref0 (self->priv->selected);
	_cairo_pattern_destroy0 (self->priv->flag_pattern);
	_cairo_pattern_destroy0 (self->priv->mine_pattern);
	_cairo_pattern_destroy0 (self->priv->question_pattern);
	_cairo_pattern_destroy0 (self->priv->bang_pattern);
	_cairo_pattern_destroy0 (self->priv->warning_pattern);
	self->priv->number_patterns = (_vala_array_free (self->priv->number_patterns, self->priv->number_patterns_length1, (GDestroyNotify) cairo_pattern_destroy), NULL);
	_minefield_unref0 (self->priv->_minefield);
	G_OBJECT_CLASS (minefield_view_parent_class)->finalize (obj);
}


GType minefield_view_get_type (void) {
	static volatile gsize minefield_view_type_id__volatile = 0;
	if (g_once_init_enter (&minefield_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MinefieldViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) minefield_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MinefieldView), 0, (GInstanceInitFunc) minefield_view_instance_init, NULL };
		GType minefield_view_type_id;
		minefield_view_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "MinefieldView", &g_define_type_info, 0);
		g_once_init_leave (&minefield_view_type_id__volatile, minefield_view_type_id);
	}
	return minefield_view_type_id__volatile;
}


static void _vala_minefield_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MinefieldView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MINEFIELD_VIEW, MinefieldView);
	switch (property_id) {
		case MINEFIELD_VIEW_MINEFIELD:
		value_set_minefield (value, minefield_view_get_minefield (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_minefield_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MinefieldView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MINEFIELD_VIEW, MinefieldView);
	switch (property_id) {
		case MINEFIELD_VIEW_MINEFIELD:
		minefield_view_set_minefield (self, value_get_minefield (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



