/* rygel-http-time-seek-test.c generated by valac 0.20.1.2-ca5c2, the Vala compiler
 * generated from rygel-http-time-seek-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                               <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;
typedef struct _RygelHTTPTranscodeHandlerPrivate RygelHTTPTranscodeHandlerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_HTTP_TIME_SEEK_TEST (rygel_http_time_seek_test_get_type ())
#define RYGEL_HTTP_TIME_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTest))
#define RYGEL_HTTP_TIME_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTestClass))
#define RYGEL_IS_HTTP_TIME_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_TEST))
#define RYGEL_IS_HTTP_TIME_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_TEST))
#define RYGEL_HTTP_TIME_SEEK_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTestClass))

typedef struct _RygelHTTPTimeSeekTest RygelHTTPTimeSeekTest;
typedef struct _RygelHTTPTimeSeekTestClass RygelHTTPTimeSeekTestClass;
typedef struct _RygelHTTPTimeSeekTestPrivate RygelHTTPTimeSeekTestPrivate;

#define RYGEL_HTTP_TIME_SEEK_TEST_TYPE_TEST_TYPE (rygel_http_time_seek_test_test_type_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_TEST_ERROR_SKIP
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPTranscodeHandler {
	GObject parent_instance;
	RygelHTTPTranscodeHandlerPrivate * priv;
};

struct _RygelHTTPTranscodeHandlerClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gint64 size;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelClientHacks {
	GObject parent_instance;
	RygelClientHacksPrivate * priv;
};

struct _RygelClientHacksClass {
	GObjectClass parent_class;
};

struct _RygelThumbnail {
	GObject parent_instance;
	RygelThumbnailPrivate * priv;
};

struct _RygelThumbnailClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupMessage* msg;
	RygelMediaObject* object;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPTranscodeHandler* handler;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelHTTPTimeSeekTest {
	GObject parent_instance;
	RygelHTTPTimeSeekTestPrivate * priv;
};

struct _RygelHTTPTimeSeekTestClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING,
	RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING,
	RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_MIXED_PARSING
} RygelHTTPTimeSeekTestTestType;

struct _RygelHTTPTimeSeekTestPrivate {
	GRegex* range_regex;
	RygelHTTPTimeSeekTestTestType test_type;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()

static gpointer rygel_http_transcode_handler_parent_class = NULL;
static gpointer rygel_media_object_parent_class = NULL;
static gpointer rygel_media_container_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_audio_item_parent_class = NULL;
static gpointer rygel_client_hacks_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_http_get_parent_class = NULL;
static gpointer rygel_http_time_seek_test_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TRANSCODE_HANDLER_DUMMY_PROPERTY
};
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (void);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
static void rygel_media_object_finalize (GObject* obj);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
RygelMediaContainer* rygel_media_container_new (void);
RygelMediaContainer* rygel_media_container_construct (GType object_type);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
RygelMediaItem* rygel_media_item_construct (GType object_type);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_AUDIO_ITEM_DUMMY_PROPERTY
};
RygelAudioItem* rygel_audio_item_new (void);
RygelAudioItem* rygel_audio_item_construct (GType object_type);
static void rygel_audio_item_finalize (GObject* obj);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_CLIENT_HACKS_DUMMY_PROPERTY
};
RygelClientHacks* rygel_client_hacks_create (SoupMessage* msg, GError** error);
RygelClientHacks* rygel_client_hacks_new (void);
RygelClientHacks* rygel_client_hacks_construct (GType object_type);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GET_ITEM_URI "http://DoesntMatterWhatThisIs"
RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop);
RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_strings (const gchar* start, const gchar* stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_strings (GType object_type, const gchar* start, const gchar* stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
static void rygel_http_get_add_string_headers (RygelHTTPGet* self, const gchar* start, const gchar* stop);
static void rygel_http_get_finalize (GObject* obj);
GType rygel_http_time_seek_test_get_type (void) G_GNUC_CONST;
static GType rygel_http_time_seek_test_test_type_get_type (void) G_GNUC_UNUSED;
#define RYGEL_HTTP_TIME_SEEK_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTestPrivate))
enum  {
	RYGEL_HTTP_TIME_SEEK_TEST_DUMMY_PROPERTY
};
gint rygel_http_time_seek_test_main (gchar** args, int args_length1);
static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_new (void);
static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_construct (GType object_type);
GQuark rygel_http_seek_error_quark (void);
void rygel_http_time_seek_test_run (RygelHTTPTimeSeekTest* self, GError** error);
static void rygel_http_time_seek_test_test_no_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_start_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_stop_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_start_stop_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_seek (RygelHTTPTimeSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error);
gboolean rygel_http_time_seek_needed (RygelHTTPGet* request);
RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
void rygel_http_seek_add_response_headers (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
gboolean rygel_http_time_seek_requested (RygelHTTPGet* request);
static void rygel_http_time_seek_test_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type) {
	RygelHTTPTranscodeHandler * self = NULL;
	self = (RygelHTTPTranscodeHandler*) g_object_new (object_type, NULL);
	return self;
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (void) {
	return rygel_http_transcode_handler_construct (RYGEL_TYPE_HTTP_TRANSCODE_HANDLER);
}


static void rygel_http_transcode_handler_class_init (RygelHTTPTranscodeHandlerClass * klass) {
	rygel_http_transcode_handler_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_http_transcode_handler_instance_init (RygelHTTPTranscodeHandler * self) {
}


GType rygel_http_transcode_handler_get_type (void) {
	static volatile gsize rygel_http_transcode_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_transcode_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTranscodeHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_transcode_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTranscodeHandler), 0, (GInstanceInitFunc) rygel_http_transcode_handler_instance_init, NULL };
		GType rygel_http_transcode_handler_type_id;
		rygel_http_transcode_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPTranscodeHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_transcode_handler_type_id__volatile, rygel_http_transcode_handler_type_id);
	}
	return rygel_http_transcode_handler_type_id__volatile;
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject * self = NULL;
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
	return self;
}


RygelMediaObject* rygel_media_object_new (void) {
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
	self->size = (gint64) (-1);
}


static void rygel_media_object_finalize (GObject* obj) {
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


RygelMediaContainer* rygel_media_container_construct (GType object_type) {
	RygelMediaContainer * self = NULL;
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
	return self;
}


RygelMediaContainer* rygel_media_container_new (void) {
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER);
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


gboolean rygel_media_item_is_live_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = TRUE;
	return result;
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem * self = NULL;
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
	return self;
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelAudioItem* rygel_audio_item_construct (GType object_type) {
	RygelAudioItem * self = NULL;
	self = (RygelAudioItem*) rygel_media_item_construct (object_type);
	return self;
}


RygelAudioItem* rygel_audio_item_new (void) {
	return rygel_audio_item_construct (RYGEL_TYPE_AUDIO_ITEM);
}


static void rygel_audio_item_class_init (RygelAudioItemClass * klass) {
	rygel_audio_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_audio_item_finalize;
}


static void rygel_audio_item_instance_init (RygelAudioItem * self) {
	self->duration = (gint64) 2048;
}


static void rygel_audio_item_finalize (GObject* obj) {
	RygelAudioItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem);
	G_OBJECT_CLASS (rygel_audio_item_parent_class)->finalize (obj);
}


GType rygel_audio_item_get_type (void) {
	static volatile gsize rygel_audio_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_audio_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAudioItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_audio_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAudioItem), 0, (GInstanceInitFunc) rygel_audio_item_instance_init, NULL };
		GType rygel_audio_item_type_id;
		rygel_audio_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelAudioItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_audio_item_type_id__volatile, rygel_audio_item_type_id);
	}
	return rygel_audio_item_type_id__volatile;
}


RygelClientHacks* rygel_client_hacks_create (SoupMessage* msg, GError** error) {
	RygelClientHacks* result = NULL;
	RygelClientHacks* _tmp0_;
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = rygel_client_hacks_new ();
	result = _tmp0_;
	return result;
}


gboolean rygel_client_hacks_force_seek (RygelClientHacks* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}


RygelClientHacks* rygel_client_hacks_construct (GType object_type) {
	RygelClientHacks * self = NULL;
	self = (RygelClientHacks*) g_object_new (object_type, NULL);
	return self;
}


RygelClientHacks* rygel_client_hacks_new (void) {
	return rygel_client_hacks_construct (RYGEL_TYPE_CLIENT_HACKS);
}


static void rygel_client_hacks_class_init (RygelClientHacksClass * klass) {
	rygel_client_hacks_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_client_hacks_instance_init (RygelClientHacks * self) {
}


GType rygel_client_hacks_get_type (void) {
	static volatile gsize rygel_client_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_client_hacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelClientHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_client_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelClientHacks), 0, (GInstanceInitFunc) rygel_client_hacks_instance_init, NULL };
		GType rygel_client_hacks_type_id;
		rygel_client_hacks_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelClientHacks", &g_define_type_info, 0);
		g_once_init_leave (&rygel_client_hacks_type_id__volatile, rygel_client_hacks_type_id);
	}
	return rygel_client_hacks_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail * self = NULL;
	self = (RygelThumbnail*) g_object_new (object_type, NULL);
	return self;
}


RygelThumbnail* rygel_thumbnail_new (void) {
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, NULL };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnail", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle * self = NULL;
	self = (RygelSubtitle*) g_object_new (object_type, NULL);
	return self;
}


RygelSubtitle* rygel_subtitle_new (void) {
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, NULL };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitle", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	SoupMessage* _tmp0_;
	RygelAudioItem* _tmp1_;
	RygelHTTPTranscodeHandler* _tmp2_;
	RygelThumbnail* _tmp3_;
	RygelThumbnail* _tmp4_;
	RygelSubtitle* _tmp5_;
	RygelSubtitle* _tmp6_;
	self = (RygelHTTPGet*) g_object_new (object_type, NULL);
	_tmp0_ = soup_message_new ("HTTP", RYGEL_HTTP_GET_ITEM_URI);
	_g_object_unref0 (self->msg);
	self->msg = _tmp0_;
	_tmp1_ = rygel_audio_item_new ();
	_g_object_unref0 (self->object);
	self->object = (RygelMediaObject*) _tmp1_;
	_tmp2_ = rygel_http_transcode_handler_new ();
	_g_object_unref0 (self->handler);
	self->handler = _tmp2_;
	_tmp3_ = thumbnail;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->thumbnail);
	self->thumbnail = _tmp4_;
	_tmp5_ = subtitle;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->subtitle);
	self->subtitle = _tmp6_;
	return self;
}


RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, thumbnail, subtitle);
}


RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	gint64 _tmp2_;
	_tmp0_ = thumbnail;
	_tmp1_ = subtitle;
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
	_tmp2_ = start;
	rygel_http_get_add_headers (self, _tmp2_, (gint64) (-1));
	return self;
}


RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	return rygel_http_get_construct_seek_start (RYGEL_TYPE_HTTP_GET, start, thumbnail, subtitle);
}


RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	gint64 _tmp2_;
	_tmp0_ = thumbnail;
	_tmp1_ = subtitle;
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
	_tmp2_ = stop;
	rygel_http_get_add_headers (self, (gint64) 0, _tmp2_);
	return self;
}


RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	return rygel_http_get_construct_seek_stop (RYGEL_TYPE_HTTP_GET, stop, thumbnail, subtitle);
}


RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	_tmp0_ = thumbnail;
	_tmp1_ = subtitle;
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
	_tmp2_ = start;
	_tmp3_ = stop;
	rygel_http_get_add_headers (self, _tmp2_, _tmp3_);
	return self;
}


RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	return rygel_http_get_construct_seek_start_stop (RYGEL_TYPE_HTTP_GET, start, stop, thumbnail, subtitle);
}


RygelHTTPGet* rygel_http_get_construct_seek_strings (GType object_type, const gchar* start, const gchar* stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (start != NULL, NULL);
	g_return_val_if_fail (stop != NULL, NULL);
	_tmp0_ = thumbnail;
	_tmp1_ = subtitle;
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
	_tmp2_ = start;
	_tmp3_ = stop;
	rygel_http_get_add_string_headers (self, _tmp2_, _tmp3_);
	return self;
}


RygelHTTPGet* rygel_http_get_new_seek_strings (const gchar* start, const gchar* stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	return rygel_http_get_construct_seek_strings (RYGEL_TYPE_HTTP_GET, start, stop, thumbnail, subtitle);
}


static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop) {
	gint64 _tmp0_;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* stop_str;
	gint64 _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* range;
	SoupMessage* _tmp17_;
	SoupMessageHeaders* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = start;
	g_return_if_fail (_tmp0_ >= ((gint64) 0));
	_tmp2_ = stop;
	if (_tmp2_ > ((gint64) 0)) {
		gint64 _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp3_ = stop;
		_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp5_;
	}
	_tmp6_ = _tmp1_;
	_tmp7_ = g_strdup (_tmp6_);
	stop_str = _tmp7_;
	_tmp8_ = start;
	_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat ("npt=", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, "-", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp14_, stop_str, NULL);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	range = _tmp16_;
	_tmp17_ = self->msg;
	_tmp18_ = _tmp17_->request_headers;
	soup_message_headers_append (_tmp18_, "TimeSeekRange.dlna.org", range);
	_g_free0 (range);
	_g_free0 (stop_str);
	_g_free0 (_tmp1_);
}


static void rygel_http_get_add_string_headers (RygelHTTPGet* self, const gchar* start, const gchar* stop) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* range;
	SoupMessage* _tmp8_;
	SoupMessageHeaders* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (stop != NULL);
	_tmp0_ = start;
	_tmp1_ = g_strconcat ("npt=", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "-", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = stop;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	range = _tmp7_;
	_tmp8_ = self->msg;
	_tmp9_ = _tmp8_->request_headers;
	soup_message_headers_append (_tmp9_, "TimeSeekRange.dlna.org", range);
	_g_free0 (range);
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET, RygelHTTPGet);
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->object);
	_g_object_unref0 (self->thumbnail);
	_g_object_unref0 (self->subtitle);
	_g_object_unref0 (self->handler);
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
}


GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}


static GType rygel_http_time_seek_test_test_type_get_type (void) {
	static volatile gsize rygel_http_time_seek_test_test_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_test_test_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING, "RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING", "test-seconds-parsing"}, {RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING, "RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING", "test-hhmmss-parsing"}, {RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_MIXED_PARSING, "RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_MIXED_PARSING", "test-mixed-parsing"}, {0, NULL, NULL}};
		GType rygel_http_time_seek_test_test_type_type_id;
		rygel_http_time_seek_test_test_type_type_id = g_enum_register_static ("RygelHTTPTimeSeekTestTestType", values);
		g_once_init_leave (&rygel_http_time_seek_test_test_type_type_id__volatile, rygel_http_time_seek_test_test_type_type_id);
	}
	return rygel_http_time_seek_test_test_type_type_id__volatile;
}


gint rygel_http_time_seek_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPTimeSeekTest* _tmp0_;
		RygelHTTPTimeSeekTest* test;
		RygelHTTPTimeSeekTest* _tmp1_;
		_tmp0_ = rygel_http_time_seek_test_new ();
		test = _tmp0_;
		_tmp1_ = test;
		rygel_http_time_seek_test_run (_tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (test);
			goto __catch0_g_error;
		}
		_g_object_unref0 (test);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->message;
		g_critical ("rygel-http-time-seek-test.vala:144: %s", _tmp3_);
		result = -1;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return rygel_http_time_seek_test_main (argv, argc);
}


void rygel_http_time_seek_test_run (RygelHTTPTimeSeekTest* self, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelThumbnail** _tmp1_ = NULL;
	RygelThumbnail** thumbnails;
	gint thumbnails_length1;
	gint _thumbnails_size_;
	RygelSubtitle* _tmp2_;
	RygelSubtitle** _tmp3_ = NULL;
	RygelSubtitle** subtitles;
	gint subtitles_length1;
	gint _subtitles_size_;
	RygelThumbnail** _tmp4_;
	gint _tmp4__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = rygel_thumbnail_new ();
	_tmp1_ = g_new0 (RygelThumbnail*, 2 + 1);
	_tmp1_[0] = NULL;
	_tmp1_[1] = _tmp0_;
	thumbnails = _tmp1_;
	thumbnails_length1 = 2;
	_thumbnails_size_ = thumbnails_length1;
	_tmp2_ = rygel_subtitle_new ();
	_tmp3_ = g_new0 (RygelSubtitle*, 2 + 1);
	_tmp3_[0] = NULL;
	_tmp3_[1] = _tmp2_;
	subtitles = _tmp3_;
	subtitles_length1 = 2;
	_subtitles_size_ = subtitles_length1;
	_tmp4_ = thumbnails;
	_tmp4__length1 = thumbnails_length1;
	{
		RygelThumbnail** thumbnail_collection = NULL;
		gint thumbnail_collection_length1 = 0;
		gint _thumbnail_collection_size_ = 0;
		gint thumbnail_it = 0;
		thumbnail_collection = _tmp4_;
		thumbnail_collection_length1 = _tmp4__length1;
		for (thumbnail_it = 0; thumbnail_it < _tmp4__length1; thumbnail_it = thumbnail_it + 1) {
			RygelThumbnail* _tmp5_;
			RygelThumbnail* thumbnail = NULL;
			_tmp5_ = _g_object_ref0 (thumbnail_collection[thumbnail_it]);
			thumbnail = _tmp5_;
			{
				RygelSubtitle** _tmp6_;
				gint _tmp6__length1;
				_tmp6_ = subtitles;
				_tmp6__length1 = subtitles_length1;
				{
					RygelSubtitle** subtitle_collection = NULL;
					gint subtitle_collection_length1 = 0;
					gint _subtitle_collection_size_ = 0;
					gint subtitle_it = 0;
					subtitle_collection = _tmp6_;
					subtitle_collection_length1 = _tmp6__length1;
					for (subtitle_it = 0; subtitle_it < _tmp6__length1; subtitle_it = subtitle_it + 1) {
						RygelSubtitle* _tmp7_;
						RygelSubtitle* subtitle = NULL;
						_tmp7_ = _g_object_ref0 (subtitle_collection[subtitle_it]);
						subtitle = _tmp7_;
						{
							RygelThumbnail* _tmp8_;
							RygelSubtitle* _tmp9_;
							RygelThumbnail* _tmp10_;
							RygelSubtitle* _tmp11_;
							RygelThumbnail* _tmp12_;
							RygelSubtitle* _tmp13_;
							RygelThumbnail* _tmp14_;
							RygelSubtitle* _tmp15_;
							RygelThumbnail* _tmp16_;
							RygelSubtitle* _tmp17_;
							RygelThumbnail* _tmp18_;
							RygelSubtitle* _tmp19_;
							RygelThumbnail* _tmp20_;
							RygelSubtitle* _tmp21_;
							RygelThumbnail* _tmp22_;
							RygelSubtitle* _tmp23_;
							self->priv->test_type = RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING;
							_tmp8_ = thumbnail;
							_tmp9_ = subtitle;
							rygel_http_time_seek_test_test_no_seek (self, _tmp8_, _tmp9_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp10_ = thumbnail;
							_tmp11_ = subtitle;
							rygel_http_time_seek_test_test_start_only_seek (self, _tmp10_, _tmp11_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp12_ = thumbnail;
							_tmp13_ = subtitle;
							rygel_http_time_seek_test_test_stop_only_seek (self, _tmp12_, _tmp13_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp14_ = thumbnail;
							_tmp15_ = subtitle;
							rygel_http_time_seek_test_test_start_stop_seek (self, _tmp14_, _tmp15_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							self->priv->test_type = RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING;
							_tmp16_ = thumbnail;
							_tmp17_ = subtitle;
							rygel_http_time_seek_test_test_start_only_seek (self, _tmp16_, _tmp17_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp18_ = thumbnail;
							_tmp19_ = subtitle;
							rygel_http_time_seek_test_test_stop_only_seek (self, _tmp18_, _tmp19_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp20_ = thumbnail;
							_tmp21_ = subtitle;
							rygel_http_time_seek_test_test_start_stop_seek (self, _tmp20_, _tmp21_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							self->priv->test_type = RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_MIXED_PARSING;
							_tmp22_ = thumbnail;
							_tmp23_ = subtitle;
							rygel_http_time_seek_test_test_start_stop_seek (self, _tmp22_, _tmp23_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_g_object_unref0 (subtitle);
						}
					}
				}
				_g_object_unref0 (thumbnail);
			}
		}
	}
	subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
	thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
}


static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_construct (GType object_type) {
	RygelHTTPTimeSeekTest * self = NULL;
	gchar* _tmp0_;
	gchar* expression;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPTimeSeekTest*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup ("npt=[0-9]+\\.[0-9][0-9][0-9]-" "[0-9]+\\.[0-9][0-9][0-9]/" "[0-9]+\\.[0-9][0-9][0-9]");
	expression = _tmp0_;
	{
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new (expression, G_REGEX_CASELESS, 0, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_free0 (expression);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (self->priv->range_regex);
		self->priv->range_regex = _tmp2_;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (expression);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (expression);
	return self;
}


static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_new (void) {
	return rygel_http_time_seek_test_construct (RYGEL_TYPE_HTTP_TIME_SEEK_TEST);
}


static void rygel_http_time_seek_test_test_no_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* request;
	RygelMediaObject* _tmp3_;
	RygelAudioItem* _tmp4_;
	RygelAudioItem* audio_item;
	gint64 _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = thumbnail;
	_tmp1_ = subtitle;
	_tmp2_ = rygel_http_get_new (_tmp0_, _tmp1_);
	request = _tmp2_;
	_tmp3_ = request->object;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp3_) : NULL);
	audio_item = _tmp4_;
	_tmp5_ = audio_item->duration;
	rygel_http_time_seek_test_test_seek (self, request, (gint64) 0, (_tmp5_ * G_TIME_SPAN_SECOND) - G_TIME_SPAN_MILLISECOND, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (audio_item);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (audio_item);
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (audio_item);
	_g_object_unref0 (request);
}


static void rygel_http_time_seek_test_test_start_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelHTTPGet* request;
	RygelHTTPTimeSeekTestTestType _tmp0_;
	RygelHTTPGet* _tmp7_;
	RygelMediaObject* _tmp8_;
	RygelAudioItem* _tmp9_;
	RygelAudioItem* audio_item;
	RygelHTTPGet* _tmp10_;
	gint64 _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	request = NULL;
	_tmp0_ = self->priv->test_type;
	switch (_tmp0_) {
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING:
		{
			RygelThumbnail* _tmp1_;
			RygelSubtitle* _tmp2_;
			RygelHTTPGet* _tmp3_;
			_tmp1_ = thumbnail;
			_tmp2_ = subtitle;
			_tmp3_ = rygel_http_get_new_seek_start ((gint64) 128, _tmp1_, _tmp2_);
			_g_object_unref0 (request);
			request = _tmp3_;
			break;
		}
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING:
		{
			RygelThumbnail* _tmp4_;
			RygelSubtitle* _tmp5_;
			RygelHTTPGet* _tmp6_;
			_tmp4_ = thumbnail;
			_tmp5_ = subtitle;
			_tmp6_ = rygel_http_get_new_seek_strings ("00:02:08.000", "", _tmp4_, _tmp5_);
			_g_object_unref0 (request);
			request = _tmp6_;
			break;
		}
		default:
		break;
	}
	_tmp7_ = request;
	_tmp8_ = _tmp7_->object;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp8_) : NULL);
	audio_item = _tmp9_;
	_tmp10_ = request;
	_tmp11_ = audio_item->duration;
	rygel_http_time_seek_test_test_seek (self, _tmp10_, (gint64) (128 * G_TIME_SPAN_SECOND), (_tmp11_ * G_TIME_SPAN_SECOND) - G_TIME_SPAN_MILLISECOND, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (audio_item);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (audio_item);
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (audio_item);
	_g_object_unref0 (request);
}


static void rygel_http_time_seek_test_test_stop_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelHTTPGet* request;
	RygelHTTPTimeSeekTestTestType _tmp0_;
	RygelHTTPGet* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	request = NULL;
	_tmp0_ = self->priv->test_type;
	switch (_tmp0_) {
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING:
		{
			RygelThumbnail* _tmp1_;
			RygelSubtitle* _tmp2_;
			RygelHTTPGet* _tmp3_;
			_tmp1_ = thumbnail;
			_tmp2_ = subtitle;
			_tmp3_ = rygel_http_get_new_seek_stop ((gint64) 128, _tmp1_, _tmp2_);
			_g_object_unref0 (request);
			request = _tmp3_;
			break;
		}
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING:
		{
			RygelThumbnail* _tmp4_;
			RygelSubtitle* _tmp5_;
			RygelHTTPGet* _tmp6_;
			_tmp4_ = thumbnail;
			_tmp5_ = subtitle;
			_tmp6_ = rygel_http_get_new_seek_strings ("00:00:00.000", "00:02:08.000", _tmp4_, _tmp5_);
			_g_object_unref0 (request);
			request = _tmp6_;
			break;
		}
		default:
		break;
	}
	_tmp7_ = request;
	rygel_http_time_seek_test_test_seek (self, _tmp7_, (gint64) 0, (gint64) (128 * G_TIME_SPAN_SECOND), &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (request);
}


static void rygel_http_time_seek_test_test_start_stop_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelHTTPGet* request;
	RygelHTTPTimeSeekTestTestType _tmp0_;
	RygelHTTPGet* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	request = NULL;
	_tmp0_ = self->priv->test_type;
	switch (_tmp0_) {
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_SECONDS_PARSING:
		{
			RygelThumbnail* _tmp1_;
			RygelSubtitle* _tmp2_;
			RygelHTTPGet* _tmp3_;
			_tmp1_ = thumbnail;
			_tmp2_ = subtitle;
			_tmp3_ = rygel_http_get_new_seek_start_stop ((gint64) 128, (gint64) 256, _tmp1_, _tmp2_);
			_g_object_unref0 (request);
			request = _tmp3_;
			break;
		}
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_HHMMSS_PARSING:
		{
			RygelThumbnail* _tmp4_;
			RygelSubtitle* _tmp5_;
			RygelHTTPGet* _tmp6_;
			_tmp4_ = thumbnail;
			_tmp5_ = subtitle;
			_tmp6_ = rygel_http_get_new_seek_strings ("00:02:08.000", "00:04:16.000", _tmp4_, _tmp5_);
			_g_object_unref0 (request);
			request = _tmp6_;
			break;
		}
		case RYGEL_HTTP_TIME_SEEK_TEST_TEST_TYPE_TEST_MIXED_PARSING:
		{
			RygelThumbnail* _tmp7_;
			RygelSubtitle* _tmp8_;
			RygelHTTPGet* _tmp9_;
			_tmp7_ = thumbnail;
			_tmp8_ = subtitle;
			_tmp9_ = rygel_http_get_new_seek_strings ("00:02:08.000", "256.000", _tmp7_, _tmp8_);
			_g_object_unref0 (request);
			request = _tmp9_;
			break;
		}
		default:
		break;
	}
	_tmp10_ = request;
	rygel_http_time_seek_test_test_seek (self, _tmp10_, (gint64) (128 * G_TIME_SPAN_SECOND), (gint64) (256 * G_TIME_SPAN_SECOND), &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (request);
}


static void rygel_http_time_seek_test_test_seek (RygelHTTPTimeSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error) {
	RygelHTTPGet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelHTTPGet* _tmp2_;
	RygelHTTPTimeSeek* _tmp3_;
	RygelHTTPTimeSeek* seek;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_;
	gint64 _tmp9_;
	gint64 _tmp10_;
	gint64 _tmp11_;
	gint64 _tmp12_;
	gint64 _tmp13_;
	gint64 _tmp14_;
	gint64 _tmp15_;
	RygelHTTPGet* _tmp16_;
	RygelMediaObject* _tmp17_;
	RygelAudioItem* _tmp18_;
	RygelAudioItem* audio_item;
	gint64 _tmp19_;
	gint64 _tmp20_;
	RygelAudioItem* _tmp21_;
	gint64 _tmp22_;
	RygelHTTPGet* _tmp23_;
	SoupMessage* _tmp24_;
	SoupMessageHeaders* _tmp25_;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	gchar* header;
	const gchar* _tmp28_;
	GRegex* _tmp29_;
	const gchar* _tmp30_;
	gboolean _tmp31_ = FALSE;
	RygelHTTPGet* _tmp32_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (request != NULL);
	_tmp0_ = request;
	_tmp1_ = rygel_http_time_seek_needed (_tmp0_);
	_vala_assert (_tmp1_, "HTTPTimeSeek.needed (request)");
	_tmp2_ = request;
	_tmp3_ = rygel_http_time_seek_new (_tmp2_, &_inner_error_);
	seek = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	rygel_http_seek_add_response_headers ((RygelHTTPSeek*) seek);
	_vala_assert (seek != NULL, "seek != null");
	_tmp4_ = rygel_http_seek_get_start ((RygelHTTPSeek*) seek);
	_tmp5_ = _tmp4_;
	_tmp6_ = start;
	_vala_assert (_tmp5_ == _tmp6_, "seek.start == start");
	_tmp7_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) seek);
	_tmp8_ = _tmp7_;
	_tmp9_ = stop;
	_vala_assert (_tmp8_ == _tmp9_, "seek.stop == stop");
	_tmp10_ = rygel_http_seek_get_length ((RygelHTTPSeek*) seek);
	_tmp11_ = _tmp10_;
	_tmp12_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) seek);
	_tmp13_ = _tmp12_;
	_tmp14_ = rygel_http_seek_get_start ((RygelHTTPSeek*) seek);
	_tmp15_ = _tmp14_;
	_vala_assert (_tmp11_ == ((_tmp13_ + G_TIME_SPAN_MILLISECOND) - _tmp15_), "seek.length == seek.stop + TimeSpan.MILLISECOND - seek.start");
	_tmp16_ = request;
	_tmp17_ = _tmp16_->object;
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp17_) : NULL);
	audio_item = _tmp18_;
	_tmp19_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek);
	_tmp20_ = _tmp19_;
	_tmp21_ = audio_item;
	_tmp22_ = _tmp21_->duration;
	_vala_assert (_tmp20_ == (_tmp22_ * G_TIME_SPAN_SECOND), "seek.total_length == audio_item.duration * TimeSpan.SECOND");
	_tmp23_ = request;
	_tmp24_ = _tmp23_->msg;
	_tmp25_ = _tmp24_->response_headers;
	_tmp26_ = soup_message_headers_get_one (_tmp25_, "TimeSeekRange.dlna.org");
	_tmp27_ = g_strdup (_tmp26_);
	header = _tmp27_;
	_tmp28_ = header;
	_vala_assert (_tmp28_ != NULL, "header != null");
	_tmp29_ = self->priv->range_regex;
	_tmp30_ = header;
	_tmp31_ = g_regex_match (_tmp29_, _tmp30_, 0, NULL);
	_vala_assert (_tmp31_, "this.range_regex.match (header)");
	_tmp32_ = request;
	rygel_http_time_seek_requested (_tmp32_);
	_g_free0 (header);
	_g_object_unref0 (audio_item);
	_g_object_unref0 (seek);
}


static void rygel_http_time_seek_test_class_init (RygelHTTPTimeSeekTestClass * klass) {
	rygel_http_time_seek_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPTimeSeekTestPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_http_time_seek_test_finalize;
}


static void rygel_http_time_seek_test_instance_init (RygelHTTPTimeSeekTest * self) {
	self->priv = RYGEL_HTTP_TIME_SEEK_TEST_GET_PRIVATE (self);
}


static void rygel_http_time_seek_test_finalize (GObject* obj) {
	RygelHTTPTimeSeekTest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTest);
	_g_regex_unref0 (self->priv->range_regex);
	G_OBJECT_CLASS (rygel_http_time_seek_test_parent_class)->finalize (obj);
}


GType rygel_http_time_seek_test_get_type (void) {
	static volatile gsize rygel_http_time_seek_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeekTest), 0, (GInstanceInitFunc) rygel_http_time_seek_test_instance_init, NULL };
		GType rygel_http_time_seek_test_type_id;
		rygel_http_time_seek_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPTimeSeekTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_test_type_id__volatile, rygel_http_time_seek_test_type_id);
	}
	return rygel_http_time_seek_test_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



