/* rygel-media-art-store.c generated by valac 0.20.1.2-ca5c2, the Vala compiler
 * generated from rygel-media-art-store.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define RYGEL_TYPE_MEDIA_ART_STORE (rygel_media_art_store_get_type ())
#define RYGEL_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore))
#define RYGEL_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))
#define RYGEL_IS_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_IS_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_MEDIA_ART_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))

typedef struct _RygelMediaArtStore RygelMediaArtStore;
typedef struct _RygelMediaArtStoreClass RygelMediaArtStoreClass;
typedef struct _RygelMediaArtStorePrivate RygelMediaArtStorePrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

typedef enum  {
	MEDIA_ART_STORE_ERROR_NO_DIR,
	MEDIA_ART_STORE_ERROR_NO_MEDIA_ART
} MediaArtStoreError;
#define MEDIA_ART_STORE_ERROR media_art_store_error_quark ()
struct _RygelMediaArtStore {
	GObject parent_instance;
	RygelMediaArtStorePrivate * priv;
};

struct _RygelMediaArtStoreClass {
	GObjectClass parent_class;
};

struct _RygelMediaArtStorePrivate {
	GRegex* char_remove_regex;
	GRegex* char_convert_regex;
	GRegex* space_compress_regex;
	GRegex** block_regexes;
	gint block_regexes_length1;
	gint _block_regexes_size_;
	gchar* directory;
};


static gpointer rygel_media_art_store_parent_class = NULL;
static RygelMediaArtStore* rygel_media_art_store_media_art_store;
static RygelMediaArtStore* rygel_media_art_store_media_art_store = NULL;
static gboolean rygel_media_art_store_first_time;
static gboolean rygel_media_art_store_first_time = TRUE;

GQuark media_art_store_error_quark (void);
GType rygel_media_art_store_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_ART_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStorePrivate))
enum  {
	RYGEL_MEDIA_ART_STORE_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_ART_STORE_PLACEHOLDER_HASH "7215ee9c7d9dc229d2921a40e899ec5f"
#define RYGEL_MEDIA_ART_STORE_INVALID_CHARS "()[]<>{}_!@#$^&*+=|\\/\"'?~"
#define RYGEL_MEDIA_ART_STORE_CONVERT_CHARS "\t"
#define RYGEL_MEDIA_ART_STORE_BLOCK_PATTERN "%s[^%s]*%s"
RygelMediaArtStore* rygel_media_art_store_get_default (void);
static RygelMediaArtStore* rygel_media_art_store_new (GError** error);
static RygelMediaArtStore* rygel_media_art_store_construct (GType object_type, GError** error);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
RygelThumbnail* rygel_media_art_store_find_media_art (RygelMediaArtStore* self, RygelMusicItem* item, gboolean simple, GError** error);
GFile* rygel_media_art_store_get_media_art_file (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item, gboolean simple);
RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_thumbnail_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMusicItem* item, GError** error);
static gchar* rygel_media_art_store_get_simple_hash (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item);
static gchar* rygel_media_art_store_get_hash (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item);
static void _vala_array_add1 (GRegex*** array, int* length, int* size, GRegex* value);
static gchar* rygel_media_art_store_normalize_and_hash (RygelMediaArtStore* self, const gchar* input, gboolean utf8_only);
const gchar* rygel_music_item_get_artist (RygelMusicItem* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_music_item_get_album (RygelMusicItem* self);
static gchar* rygel_media_art_store_strip_invalid_entities (RygelMediaArtStore* self, const gchar* original);
static void rygel_media_art_store_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* RYGEL_MEDIA_ART_STORE_BLOCKS[4] = {"()", "{}", "[]", "<>"};

GQuark media_art_store_error_quark (void) {
	return g_quark_from_static_string ("media_art_store_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaArtStore* rygel_media_art_store_get_default (void) {
	RygelMediaArtStore* result = NULL;
	gboolean _tmp0_;
	RygelMediaArtStore* _tmp5_;
	RygelMediaArtStore* _tmp6_;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_media_art_store_first_time;
	if (_tmp0_) {
		{
			RygelMediaArtStore* _tmp1_;
			RygelMediaArtStore* _tmp2_;
			_tmp1_ = rygel_media_art_store_new (&_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == MEDIA_ART_STORE_ERROR) {
					goto __catch0_media_art_store_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_object_unref0 (rygel_media_art_store_media_art_store);
			rygel_media_art_store_media_art_store = _tmp2_;
		}
		goto __finally0;
		__catch0_media_art_store_error:
		{
			GError* _error_ = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = _error_;
			_tmp4_ = _tmp3_->message;
			g_warning ("rygel-media-art-store.vala:54: No media art available: %s", _tmp4_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	rygel_media_art_store_first_time = FALSE;
	_tmp5_ = rygel_media_art_store_media_art_store;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	result = _tmp6_;
	return result;
}


RygelThumbnail* rygel_media_art_store_find_media_art (RygelMediaArtStore* self, RygelMusicItem* item, gboolean simple, GError** error) {
	RygelThumbnail* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** types;
	gint types_length1;
	gint _types_size_;
	GFile* file;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFileInfo* _tmp16_ = NULL;
	GFileInfo* info;
	GFileInfo* _tmp17_;
	gboolean _tmp18_ = FALSE;
	RygelThumbnail* _tmp19_;
	RygelThumbnail* thumb;
	RygelThumbnail* _tmp20_;
	GFile* _tmp21_;
	gchar* _tmp22_ = NULL;
	RygelThumbnail* _tmp23_;
	GFileInfo* _tmp24_;
	gint64 _tmp25_ = 0LL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = g_strdup ("track");
	_tmp1_ = g_strdup ("album");
	_tmp2_ = g_strdup ("artist");
	_tmp3_ = g_strdup ("podcast");
	_tmp4_ = g_strdup ("radio");
	_tmp5_ = g_new0 (gchar*, 5 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	types = _tmp5_;
	types_length1 = 5;
	_types_size_ = types_length1;
	file = NULL;
	_tmp6_ = types;
	_tmp6__length1 = types_length1;
	{
		gchar** type_collection = NULL;
		gint type_collection_length1 = 0;
		gint _type_collection_size_ = 0;
		gint type_it = 0;
		type_collection = _tmp6_;
		type_collection_length1 = _tmp6__length1;
		for (type_it = 0; type_it < _tmp6__length1; type_it = type_it + 1) {
			gchar* _tmp7_;
			gchar* type = NULL;
			_tmp7_ = g_strdup (type_collection[type_it]);
			type = _tmp7_;
			{
				const gchar* _tmp8_;
				RygelMusicItem* _tmp9_;
				gboolean _tmp10_;
				GFile* _tmp11_ = NULL;
				GFile* _tmp12_;
				gboolean _tmp13_ = FALSE;
				_tmp8_ = type;
				_tmp9_ = item;
				_tmp10_ = simple;
				_tmp11_ = rygel_media_art_store_get_media_art_file (self, _tmp8_, _tmp9_, _tmp10_);
				_g_object_unref0 (file);
				file = _tmp11_;
				_tmp12_ = file;
				_tmp13_ = g_file_query_exists (_tmp12_, NULL);
				if (_tmp13_) {
					_g_free0 (type);
					break;
				} else {
					_g_object_unref0 (file);
					file = NULL;
				}
				_g_free0 (type);
			}
		}
	}
	_tmp14_ = file;
	if (_tmp14_ == NULL) {
		result = NULL;
		_g_object_unref0 (file);
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp15_ = file;
	_tmp16_ = g_file_query_info (_tmp15_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp16_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	_tmp17_ = info;
	_tmp18_ = g_file_info_get_attribute_boolean (_tmp17_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	if (!_tmp18_) {
		result = NULL;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp19_ = rygel_thumbnail_new ("image/jpeg", "JPEG_TN", "jpg");
	thumb = _tmp19_;
	_tmp20_ = thumb;
	_tmp21_ = file;
	_tmp22_ = g_file_get_uri (_tmp21_);
	_g_free0 (((RygelIconInfo*) _tmp20_)->uri);
	((RygelIconInfo*) _tmp20_)->uri = _tmp22_;
	_tmp23_ = thumb;
	_tmp24_ = info;
	_tmp25_ = g_file_info_get_size (_tmp24_);
	((RygelIconInfo*) _tmp23_)->size = (gint64) _tmp25_;
	result = thumb;
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMusicItem* item, GError** error) {
	RygelThumbnail* result = NULL;
	RygelMusicItem* _tmp0_;
	RygelThumbnail* _tmp1_ = NULL;
	RygelThumbnail* thumb;
	RygelThumbnail* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = rygel_media_art_store_find_media_art (self, _tmp0_, FALSE, &_inner_error_);
	thumb = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp2_ = thumb;
	if (_tmp2_ == NULL) {
		RygelMusicItem* _tmp3_;
		RygelThumbnail* _tmp4_ = NULL;
		RygelThumbnail* _tmp5_;
		_tmp3_ = item;
		_tmp4_ = rygel_media_art_store_find_media_art (self, _tmp3_, TRUE, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_rygel_icon_info_unref0 (thumb);
			return NULL;
		}
		_rygel_icon_info_unref0 (thumb);
		thumb = _tmp5_;
	}
	result = thumb;
	return result;
}


GFile* rygel_media_art_store_get_media_art_file (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item, gboolean simple) {
	GFile* result = NULL;
	gchar* hash = NULL;
	gchar* suffix = NULL;
	gboolean _tmp0_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* file_path;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* path;
	GFile* _tmp15_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = simple;
	if (_tmp0_) {
		const gchar* _tmp1_;
		RygelMusicItem* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp1_ = type;
		_tmp2_ = item;
		_tmp3_ = rygel_media_art_store_get_simple_hash (self, _tmp1_, _tmp2_);
		_g_free0 (hash);
		hash = _tmp3_;
		_tmp4_ = g_strdup ("jpg");
		_g_free0 (suffix);
		suffix = _tmp4_;
	} else {
		const gchar* _tmp5_;
		RygelMusicItem* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp5_ = type;
		_tmp6_ = item;
		_tmp7_ = rygel_media_art_store_get_hash (self, _tmp5_, _tmp6_);
		_g_free0 (hash);
		hash = _tmp7_;
		_tmp8_ = g_strdup ("jpeg");
		_g_free0 (suffix);
		suffix = _tmp8_;
	}
	_tmp9_ = type;
	_tmp10_ = hash;
	_tmp11_ = suffix;
	_tmp12_ = g_strdup_printf ("%s-%s.%s", _tmp9_, _tmp10_, _tmp11_);
	file_path = _tmp12_;
	_tmp13_ = self->priv->directory;
	_tmp14_ = g_build_filename (_tmp13_, file_path, NULL);
	path = _tmp14_;
	_tmp15_ = g_file_new_for_path (path);
	result = _tmp15_;
	_g_free0 (path);
	_g_free0 (file_path);
	_g_free0 (suffix);
	_g_free0 (hash);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void _vala_array_add1 (GRegex*** array, int* length, int* size, GRegex* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GRegex*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static RygelMediaArtStore* rygel_media_art_store_construct (GType object_type, GError** error) {
	RygelMediaArtStore * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* dir;
	const gchar* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* file;
	GFile* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError * _inner_error_ = NULL;
	self = (RygelMediaArtStore*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "media-art", NULL);
	dir = _tmp1_;
	_tmp2_ = dir;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	file = _tmp3_;
	_tmp4_ = file;
	_tmp5_ = g_file_query_exists (_tmp4_, NULL);
	if (!_tmp5_) {
		const gchar* _tmp6_;
		_tmp6_ = dir;
		g_mkdir_with_parents (_tmp6_, 0750);
	}
	_tmp7_ = dir;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (self->priv->directory);
	self->priv->directory = _tmp8_;
	{
		gchar* _tmp9_ = NULL;
		gchar* regex_string;
		const gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		GRegex* _tmp13_;
		GRegex* _tmp14_;
		GRegex* _tmp15_;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		GRegex* _tmp20_;
		GRegex* _tmp21_;
		GRegex* _tmp22_;
		GRegex* _tmp23_;
		GRegex* _tmp24_;
		GRegex** _tmp25_ = NULL;
		_tmp9_ = g_regex_escape_string (RYGEL_MEDIA_ART_STORE_INVALID_CHARS, -1);
		regex_string = _tmp9_;
		_tmp10_ = regex_string;
		_tmp11_ = g_strdup_printf ("[%s]", _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_regex_new (_tmp12_, 0, 0, &_inner_error_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		_tmp15_ = _tmp14_;
		if (_inner_error_ != NULL) {
			_g_free0 (regex_string);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_free0 (regex_string);
			_g_object_unref0 (file);
			_g_free0 (dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (self->priv->char_remove_regex);
		self->priv->char_remove_regex = _tmp15_;
		_tmp16_ = g_regex_escape_string (RYGEL_MEDIA_ART_STORE_CONVERT_CHARS, -1);
		_g_free0 (regex_string);
		regex_string = _tmp16_;
		_tmp17_ = regex_string;
		_tmp18_ = g_strdup_printf ("[%s]", _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_regex_new (_tmp19_, 0, 0, &_inner_error_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp19_);
		_tmp22_ = _tmp21_;
		if (_inner_error_ != NULL) {
			_g_free0 (regex_string);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_free0 (regex_string);
			_g_object_unref0 (file);
			_g_free0 (dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (self->priv->char_convert_regex);
		self->priv->char_convert_regex = _tmp22_;
		_tmp23_ = g_regex_new ("\\s+", 0, 0, &_inner_error_);
		_tmp24_ = _tmp23_;
		if (_inner_error_ != NULL) {
			_g_free0 (regex_string);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_free0 (regex_string);
			_g_object_unref0 (file);
			_g_free0 (dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (self->priv->space_compress_regex);
		self->priv->space_compress_regex = _tmp24_;
		_tmp25_ = g_new0 (GRegex*, 0 + 1);
		self->priv->block_regexes = (_vala_array_free (self->priv->block_regexes, self->priv->block_regexes_length1, (GDestroyNotify) g_regex_unref), NULL);
		self->priv->block_regexes = _tmp25_;
		self->priv->block_regexes_length1 = 0;
		self->priv->_block_regexes_size_ = self->priv->block_regexes_length1;
		{
			const gchar** block_collection = NULL;
			gint block_collection_length1 = 0;
			gint _block_collection_size_ = 0;
			gint block_it = 0;
			block_collection = RYGEL_MEDIA_ART_STORE_BLOCKS;
			block_collection_length1 = G_N_ELEMENTS (RYGEL_MEDIA_ART_STORE_BLOCKS);
			for (block_it = 0; block_it < G_N_ELEMENTS (RYGEL_MEDIA_ART_STORE_BLOCKS); block_it = block_it + 1) {
				const gchar* block = NULL;
				block = block_collection[block_it];
				{
					const gchar* _tmp26_;
					gchar _tmp27_ = '\0';
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_;
					const gchar* _tmp32_;
					gchar _tmp33_ = '\0';
					gchar* _tmp34_ = NULL;
					gchar* _tmp35_;
					gchar* _tmp36_ = NULL;
					gchar* _tmp37_;
					const gchar* _tmp38_;
					gchar _tmp39_ = '\0';
					gchar* _tmp40_ = NULL;
					gchar* _tmp41_;
					gchar* _tmp42_ = NULL;
					gchar* _tmp43_;
					gchar* _tmp44_ = NULL;
					gchar* _tmp45_;
					gchar* block_re;
					const gchar* _tmp46_;
					GRegex* _tmp47_;
					GRegex* _tmp48_;
					GRegex** _tmp49_;
					gint _tmp49__length1;
					_tmp26_ = block;
					_tmp27_ = string_get (_tmp26_, (glong) 0);
					_tmp28_ = g_strdup_printf ("%C", _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = g_regex_escape_string (_tmp29_, -1);
					_tmp31_ = _tmp30_;
					_tmp32_ = block;
					_tmp33_ = string_get (_tmp32_, (glong) 1);
					_tmp34_ = g_strdup_printf ("%C", _tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = g_regex_escape_string (_tmp35_, -1);
					_tmp37_ = _tmp36_;
					_tmp38_ = block;
					_tmp39_ = string_get (_tmp38_, (glong) 1);
					_tmp40_ = g_strdup_printf ("%C", _tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = g_regex_escape_string (_tmp41_, -1);
					_tmp43_ = _tmp42_;
					_tmp44_ = g_strdup_printf (RYGEL_MEDIA_ART_STORE_BLOCK_PATTERN, _tmp31_, _tmp37_, _tmp43_);
					_tmp45_ = _tmp44_;
					_g_free0 (_tmp43_);
					_g_free0 (_tmp41_);
					_g_free0 (_tmp37_);
					_g_free0 (_tmp35_);
					_g_free0 (_tmp31_);
					_g_free0 (_tmp29_);
					block_re = _tmp45_;
					_tmp46_ = block_re;
					_tmp47_ = g_regex_new (_tmp46_, 0, 0, &_inner_error_);
					_tmp48_ = _tmp47_;
					if (_inner_error_ != NULL) {
						_g_free0 (block_re);
						_g_free0 (regex_string);
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch1_g_regex_error;
						}
						_g_free0 (block_re);
						_g_free0 (regex_string);
						_g_object_unref0 (file);
						_g_free0 (dir);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp49_ = self->priv->block_regexes;
					_tmp49__length1 = self->priv->block_regexes_length1;
					_vala_array_add1 (&self->priv->block_regexes, &self->priv->block_regexes_length1, &self->priv->_block_regexes_size_, _tmp48_);
					_g_free0 (block_re);
				}
			}
		}
		_g_free0 (regex_string);
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == MEDIA_ART_STORE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file);
			_g_free0 (dir);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (file);
			_g_free0 (dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (file);
	_g_free0 (dir);
	return self;
}


static RygelMediaArtStore* rygel_media_art_store_new (GError** error) {
	return rygel_media_art_store_construct (RYGEL_TYPE_MEDIA_ART_STORE, error);
}


static gchar* rygel_media_art_store_get_simple_hash (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item) {
	gchar* result = NULL;
	gchar* hash = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = type;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("artist")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("radio"))))) {
		switch (0) {
			default:
			{
				RygelMusicItem* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_ = NULL;
				_tmp4_ = item;
				_tmp5_ = rygel_music_item_get_artist (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = rygel_media_art_store_normalize_and_hash (self, _tmp6_, TRUE);
				_g_free0 (hash);
				hash = _tmp7_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("podcast")))) {
		switch (0) {
			default:
			{
				RygelMusicItem* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				_tmp8_ = item;
				_tmp9_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = rygel_media_art_store_normalize_and_hash (self, _tmp10_, TRUE);
				_g_free0 (hash);
				hash = _tmp11_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("album")))) {
		switch (0) {
			default:
			{
				RygelMusicItem* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				RygelMusicItem* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_ = NULL;
				_tmp12_ = item;
				_tmp13_ = rygel_music_item_get_artist (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strconcat (_tmp14_, "\t", NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = item;
				_tmp18_ = rygel_music_item_get_album (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strconcat (_tmp16_, _tmp19_, NULL);
				_tmp21_ = _tmp20_;
				_tmp22_ = rygel_media_art_store_normalize_and_hash (self, _tmp21_, TRUE);
				_g_free0 (hash);
				hash = _tmp22_;
				_g_free0 (_tmp21_);
				_g_free0 (_tmp16_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("track")))) {
		switch (0) {
			default:
			{
				RygelMusicItem* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				RygelMusicItem* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				RygelMusicItem* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_ = NULL;
				_tmp23_ = item;
				_tmp24_ = rygel_music_item_get_artist (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strconcat (_tmp25_, "\t", NULL);
				_tmp27_ = _tmp26_;
				_tmp28_ = item;
				_tmp29_ = rygel_music_item_get_album (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strconcat (_tmp27_, _tmp30_, NULL);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strconcat (_tmp32_, "\t", NULL);
				_tmp34_ = _tmp33_;
				_tmp35_ = item;
				_tmp36_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = g_strconcat (_tmp34_, _tmp37_, NULL);
				_tmp39_ = _tmp38_;
				_tmp40_ = rygel_media_art_store_normalize_and_hash (self, _tmp39_, TRUE);
				_g_free0 (hash);
				hash = _tmp40_;
				_g_free0 (_tmp39_);
				_g_free0 (_tmp34_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp27_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	result = hash;
	return result;
}


static gchar* rygel_media_art_store_get_hash (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item) {
	gchar* result = NULL;
	gchar* b;
	gchar* c;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	b = NULL;
	c = NULL;
	_tmp0_ = type;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("track")))) {
		switch (0) {
			default:
			{
				RygelMusicItem* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				RygelMusicItem* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_;
				RygelMusicItem* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_ = NULL;
				_tmp4_ = item;
				_tmp5_ = rygel_music_item_get_artist (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = rygel_media_art_store_normalize_and_hash (self, _tmp6_, FALSE);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strconcat (_tmp8_, "-", NULL);
				_tmp10_ = _tmp9_;
				_tmp11_ = item;
				_tmp12_ = rygel_music_item_get_album (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = rygel_media_art_store_normalize_and_hash (self, _tmp13_, FALSE);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat (_tmp10_, _tmp15_, NULL);
				_g_free0 (b);
				b = _tmp16_;
				_g_free0 (_tmp15_);
				_g_free0 (_tmp10_);
				_g_free0 (_tmp8_);
				_tmp17_ = item;
				_tmp18_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = rygel_media_art_store_normalize_and_hash (self, _tmp19_, FALSE);
				_g_free0 (c);
				c = _tmp20_;
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("album")))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("artist"))))) {
		switch (0) {
			default:
			{
				RygelMusicItem* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_ = NULL;
				RygelMusicItem* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				gchar* _tmp28_ = NULL;
				_tmp21_ = item;
				_tmp22_ = rygel_music_item_get_artist (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = rygel_media_art_store_normalize_and_hash (self, _tmp23_, FALSE);
				_g_free0 (b);
				b = _tmp24_;
				_tmp25_ = item;
				_tmp26_ = rygel_music_item_get_album (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = rygel_media_art_store_normalize_and_hash (self, _tmp27_, FALSE);
				_g_free0 (c);
				c = _tmp28_;
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("radio")))) || (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("podcast"))))) {
		switch (0) {
			default:
			{
				RygelMusicItem* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				gchar* _tmp32_ = NULL;
				gchar* _tmp33_;
				_tmp29_ = item;
				_tmp30_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = rygel_media_art_store_normalize_and_hash (self, _tmp31_, FALSE);
				_g_free0 (b);
				b = _tmp32_;
				_tmp33_ = g_strdup (RYGEL_MEDIA_ART_STORE_PLACEHOLDER_HASH);
				_g_free0 (c);
				c = _tmp33_;
				break;
			}
		}
	}
	_tmp34_ = b;
	_tmp35_ = c;
	_tmp36_ = g_strdup_printf ("%s-%s", _tmp34_, _tmp35_);
	result = _tmp36_;
	_g_free0 (c);
	_g_free0 (b);
	return result;
}


static gchar* rygel_media_art_store_normalize_and_hash (RygelMediaArtStore* self, const gchar* input, gboolean utf8_only) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* normalized;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp4_;
	const gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (" ");
	normalized = _tmp0_;
	_tmp2_ = input;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = input;
		_tmp1_ = g_strcmp0 (_tmp3_, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		gboolean _tmp5_;
		const gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		_tmp5_ = utf8_only;
		if (_tmp5_) {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = input;
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (normalized);
			normalized = _tmp7_;
		} else {
			const gchar* _tmp8_;
			gchar* _tmp9_ = NULL;
			const gchar* _tmp10_;
			gchar* _tmp11_ = NULL;
			_tmp8_ = input;
			_tmp9_ = rygel_media_art_store_strip_invalid_entities (self, _tmp8_);
			_g_free0 (normalized);
			normalized = _tmp9_;
			_tmp10_ = normalized;
			_tmp11_ = g_utf8_strdown (_tmp10_, (gssize) (-1));
			_g_free0 (normalized);
			normalized = _tmp11_;
		}
		_tmp12_ = normalized;
		_tmp13_ = g_utf8_normalize (_tmp12_, (gssize) (-1), G_NORMALIZE_ALL);
		_g_free0 (normalized);
		normalized = _tmp13_;
	}
	_tmp14_ = normalized;
	_tmp15_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp14_, (gsize) (-1));
	result = _tmp15_;
	_g_free0 (normalized);
	return result;
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


static gchar* rygel_media_art_store_strip_invalid_entities (RygelMediaArtStore* self, const gchar* original) {
	gchar* result = NULL;
	gchar* p = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (original != NULL, NULL);
	_tmp0_ = original;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (p);
	p = _tmp1_;
	{
		GRegex** _tmp2_;
		gint _tmp2__length1;
		GRegex* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		GRegex* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		_tmp2_ = self->priv->block_regexes;
		_tmp2__length1 = self->priv->block_regexes_length1;
		{
			GRegex** re_collection = NULL;
			gint re_collection_length1 = 0;
			gint _re_collection_size_ = 0;
			gint re_it = 0;
			re_collection = _tmp2_;
			re_collection_length1 = _tmp2__length1;
			for (re_it = 0; re_it < _tmp2__length1; re_it = re_it + 1) {
				GRegex* _tmp3_;
				GRegex* re = NULL;
				_tmp3_ = _g_regex_ref0 (re_collection[re_it]);
				re = _tmp3_;
				{
					GRegex* _tmp4_;
					const gchar* _tmp5_;
					gchar* _tmp6_ = NULL;
					gchar* _tmp7_;
					_tmp4_ = re;
					_tmp5_ = p;
					_tmp6_ = g_regex_replace_literal (_tmp4_, _tmp5_, (gssize) (-1), 0, "", 0, &_inner_error_);
					_tmp7_ = _tmp6_;
					if (_inner_error_ != NULL) {
						_g_regex_unref0 (re);
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch2_g_regex_error;
						}
						_g_regex_unref0 (re);
						_g_free0 (p);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_free0 (p);
					p = _tmp7_;
					_g_regex_unref0 (re);
				}
			}
		}
		_tmp8_ = self->priv->char_remove_regex;
		_tmp9_ = p;
		_tmp10_ = g_regex_replace_literal (_tmp8_, _tmp9_, (gssize) (-1), 0, "", 0, &_inner_error_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_free0 (p);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (p);
		p = _tmp11_;
		_tmp12_ = self->priv->char_convert_regex;
		_tmp13_ = p;
		_tmp14_ = g_regex_replace_literal (_tmp12_, _tmp13_, (gssize) (-1), 0, " ", 0, &_inner_error_);
		_tmp15_ = _tmp14_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_free0 (p);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (p);
		p = _tmp15_;
		_tmp16_ = self->priv->space_compress_regex;
		_tmp17_ = p;
		_tmp18_ = g_regex_replace_literal (_tmp16_, _tmp17_, (gssize) (-1), 0, " ", 0, &_inner_error_);
		_tmp19_ = _tmp18_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_free0 (p);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (p);
		p = _tmp19_;
		result = p;
		return result;
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally2:
	_g_free0 (p);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void rygel_media_art_store_class_init (RygelMediaArtStoreClass * klass) {
	rygel_media_art_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaArtStorePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_art_store_finalize;
}


static void rygel_media_art_store_instance_init (RygelMediaArtStore * self) {
	self->priv = RYGEL_MEDIA_ART_STORE_GET_PRIVATE (self);
}


static void rygel_media_art_store_finalize (GObject* obj) {
	RygelMediaArtStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore);
	_g_regex_unref0 (self->priv->char_remove_regex);
	_g_regex_unref0 (self->priv->char_convert_regex);
	_g_regex_unref0 (self->priv->space_compress_regex);
	self->priv->block_regexes = (_vala_array_free (self->priv->block_regexes, self->priv->block_regexes_length1, (GDestroyNotify) g_regex_unref), NULL);
	_g_free0 (self->priv->directory);
	G_OBJECT_CLASS (rygel_media_art_store_parent_class)->finalize (obj);
}


/**
 * This maps RygelMusicItem objects to their cached cover art,
 * implementing the GNOME [[https://live.gnome.org/MediaArtStorageSpec|MediaArt storage specification]]
 * and the simplified version that Banshee uses.
 */
GType rygel_media_art_store_get_type (void) {
	static volatile gsize rygel_media_art_store_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_art_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaArtStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_art_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaArtStore), 0, (GInstanceInitFunc) rygel_media_art_store_instance_init, NULL };
		GType rygel_media_art_store_type_id;
		rygel_media_art_store_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaArtStore", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_art_store_type_id__volatile, rygel_media_art_store_type_id);
	}
	return rygel_media_art_store_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



