/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

GdkEventType GdkEventVisibility_get_type (GdkEventVisibility * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventVisibility
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventVisibility_getType (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventVisibility *obj_g = (GdkEventVisibility *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventVisibility_get_type (obj_g));
}

GdkWindow * GdkEventVisibility_get_window (GdkEventVisibility * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventVisibility
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventVisibility_getWindow (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventVisibility *obj_g = (GdkEventVisibility *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventVisibility_get_window (obj_g));
}

gboolean GdkEventVisibility_get_send_event (GdkEventVisibility * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventVisibility
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventVisibility_getSendEvent (JNIEnv *env, jclass 
    cls, jobject obj) 
{
    GdkEventVisibility *obj_g = (GdkEventVisibility *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventVisibility_get_send_event (obj_g));
}

GdkVisibilityState GdkEventVisibility_get_state (GdkEventVisibility * cptr) 
{
    return cptr->state;
}

/*
 * Class:     org.gnu.gdk.EventVisibility
 * Method:    getState
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventVisibility_getState (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventVisibility *obj_g = (GdkEventVisibility *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventVisibility_get_state (obj_g));
}


#ifdef __cplusplus
}

#endif
