// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_RADIOBUTTON_H
#define _GTKMM_RADIOBUTTON_H


#include <glibmm.h>

/* $Id: radiobutton.hg,v 1.7 2004/03/06 13:56:22 murrayc Exp $ */

/* radiobutton.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/checkbutton.h>
#include <gtkmm/radiobuttongroup.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkRadioButton GtkRadioButton;
typedef struct _GtkRadioButtonClass GtkRadioButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class RadioButton_Class; } // namespace Gtk
namespace Gtk
{

/** A single radio button performs the same basic function as a Gtk::CheckButton, as its position in the object hierarchy reflects. It is only when multiple radio buttons are grouped together that they become a different user interface component in their own right.
 * Every radio button is a member of some group of radio buttons. When one is selected, all other radio buttons in the same group are deselected. A Gtk::RadioButton gives the user a choice from many options.
 * After constructing the first RadioButton in a group, use get_group() and provide this Group to the constructors ot the other RadioButtons in the same group.
 * To remove a Gtk::RadioButton from one group and make it part of a new one, use set_group().
 *
 * @ingroup Widgets
 */

class RadioButton : public CheckButton
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef RadioButton CppObjectType;
  typedef RadioButton_Class CppClassType;
  typedef GtkRadioButton BaseObjectType;
  typedef GtkRadioButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~RadioButton();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class RadioButton_Class;
  static CppClassType radiobutton_class_;

  // noncopyable
  RadioButton(const RadioButton&);
  RadioButton& operator=(const RadioButton&);

protected:
  explicit RadioButton(const Glib::ConstructParams& construct_params);
  explicit RadioButton(GtkRadioButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkRadioButton*       gobj()       { return reinterpret_cast<GtkRadioButton*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkRadioButton* gobj() const { return reinterpret_cast<GtkRadioButton*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_group_changed();


private:

  
public:
  typedef RadioButtonGroup Group;

  RadioButton();
  explicit RadioButton(const Glib::ustring& label, bool mnemonic = false);

  /** Create an empty RadioButton belonging to the specified group,
   * into which you can add() a widget.
   * If you wish to add a Gtk::Label,
   * you may want to
   * use the Gtk::RadioButton(const Group& group, const Glib::ustring& label, bool mnemonic)
   * constructor directly instead.
   */
  explicit RadioButton(Group& group);

  /** Create a button belonging to the specified group, with a label inside.
   * You won't be able to add a widget to this button
   * since it already contains a Gtk::Label.
   */
  RadioButton(Group& group, const Glib::ustring& label, bool mnemonic = false);
  

  Group get_group();
  void set_group(Group& group);
  void reset_group();
  

  Glib::SignalProxy0< void > signal_group_changed();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::RadioButton
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gtk::RadioButton* wrap(GtkRadioButton* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_RADIOBUTTON_H */

