// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gtkmm/window.h>
#include <gtkmm/private/window_p.h>

// -*- c++ -*-
/* $Id: window.ccg,v 1.5 2006/05/10 20:59:28 murrayc Exp $ */

/* 
 *
 * Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/accelgroup.h>
#include <gdkmm/cursor.h>
#include <gtk/gtkwindow.h>


namespace Gtk
{

Glib::RefPtr<AccelGroup> Window::get_accel_group()
{
  //There doesn't seem to be any gtk_window_get_accel_group().
  //I think that you're supposed to remember what you added yourself.
  //And that's what we do here.

  if(!accel_group_)
  {
    accel_group_ = AccelGroup::create();
    add_accel_group(accel_group_);
  }

  return accel_group_;
}

bool Window::is_toplevel() const
{
  return gobj()->type == GTK_WINDOW_TOPLEVEL;
}

bool Window::is_popup() const
{
  return gobj()->type == GTK_WINDOW_POPUP;
}

void Window::raise()
{
  get_window()->raise();
}

void Window::set_manage()
{
  g_warning("gtkmm: Attempt to call Gtk::manage() on a Gtk::Window, but a Gtk::Window has no parent container to manage its lifetime.\n");
}

void Window::destroy_()
{
  //Called from destructors.
  //overridden so that the correct _destroy_c_instance() ends up being called by the destructor.

  //GTKMM_LIFECYCLE

  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Gtk::Window::destroy_(): gobject_: %10X\n", gobject_);
  if(gobject_)
   g_warning("  gtypename: %s\n", G_OBJECT_TYPE_NAME(gobject_));
  #endif

  if ( !cpp_destruction_in_progress_ ) //see comment below.
  {
    //Prevent destroy_notify_() from running as a possible side-effect of gtk_object_destroy.
    //We can't predict whether destroy_notify_() will really be run, so we'll disconnect the C++ instance here.
    cpp_destruction_in_progress_ = true;

    //destroy the C instance:
    _destroy_c_instance();
  }

  //The C++ destructor will be reached later. This function was called by a destructor.
}

void Window::_destroy_c_instance()
{
  //We override this,
  //because though top-level windows can only be destroyed with gtk_widget_destroy, according to Owen Taylor. murrayc.
  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Gtk::Window::_destroy_c_instance() gobject_=%10X\n", gobject_);
  #endif

  cpp_destruction_in_progress_ = true;

  // remove our hook.
  GtkObject* object = (GtkObject*)gobj();
  if (object)
  {
    disconnect_cpp_wrapper();
    //If we are killing the C++ instance before the C instance, then this might lead to strange behaviour.
    //If this is a problem, then you'll have to use a managed() object, which will die only upon GTK+'s request.

    //We can't do anything with the gobject_ if it's already been disposed.
    //This prevents us from unref-ing it again, or destroying it again after GTK+ has told us that it has been disposed.
    if (!gobject_disposed_)
    {
      //Windows can not be unrefed. They are "self-owning".
      gtk_object_destroy(object);
    }

    //Glib::Object::~Object() will not g_object_unref() it too. because gobject_ is now 0.
  }
}

void Window_Class::dispose_vfunc_callback(GObject* self)
{
  //Avoid disposal of Windows on delete_event (window close) signal.
  
  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Window_Class::dispose_vfunc_callback(): gobject_: %p\n", (void*)self);
  #endif

  Widget *const obj = dynamic_cast<Widget*>(
      Glib::ObjectBase::_get_current_wrapper(self));

  // This function might be invoked recursively because we're triggering
  // several signal emissions, particularly signal_hide().  Therefore we
  // have to test for cpp_destruction_in_progress_ at this point.

  if(obj && !obj->_cpp_destruction_is_in_progress()) //When it should really be destroyed, we zero gobj_.
  {
    GtkWidget* const pWidget = obj->gobj();
    g_return_if_fail(pWidget == GTK_WIDGET(self));

    // Abort dispose if the widget isn't managed, in order to prevent
    // the nasty self-destroying behaviour of GTK+.  This applies to:
    //
    // - GtkWindow, if it received "delete_event"
    // - GtkDialog, which destroys on "response" by default

    #ifdef GLIBMM_DEBUG_REFCOUNTING
    g_warning("Window_Class::dispose_vfunc_callback(): before gtk_widget_hide().");
    #endif

    // Now hide the widget.  The C++ object must _not_ be accessed anymore
    // after this call, because a signal_hide() handler might delete it.
    gtk_widget_hide(pWidget);

    #ifdef GLIBMM_DEBUG_REFCOUNTING
    g_warning("Window_Class::dispose_vfunc_callback(): after gtk_widget_hide().");
    #endif

    // GTKMM_LIFECYCLE
    return; // Prevent calling of normal C dispose vfunc (see below)
  }
  else
  {
    #ifdef GLIBMM_DEBUG_REFCOUNTING
    //g_warning("Window_Class::dispose_vfunc_callback(): unreferenced: before gtk_widget_hide().");
    #endif

    // Always hide widgets on gtk_object_destroy(), regardless of whether
    // the widget is managed or not.  This is done for consistency so that
    // connecting to signal_hide() is guaranteed to work.
    //gtk_widget_hide(pWidget);

    #ifdef GLIBMM_DEBUG_REFCOUNTING
    //g_warning("Window_Class::dispose_vfunc_callback(): unreferenced:  after gtk_widget_hide().");
    #endif
  
    GObjectClass *const base = static_cast<GObjectClass*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)));

    #ifdef GLIBMM_DEBUG_REFCOUNTING
    g_warning("Window_Class::dispose_vfunc_callback(): before calling base->dispose.");
    #endif

    if(base->dispose)
      (*base->dispose)(self);

    #ifdef GLIBMM_DEBUG_REFCOUNTING
    g_warning("Window_Class::dispose_vfunc_callback(): after calling base->dispose.");
    #endif
  }
}

void Window::unset_focus()
{
  gtk_window_set_focus(gobj(), 0 /* See GTK+ docs */);
}

void Window::unset_default()
{
  gtk_window_set_default(gobj(), 0 /* See GTK+ docs */);
}
   
} // namespace Gtk


namespace
{

static void Window_signal_set_focus_callback(GtkWindow* self, GtkWidget* p0,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,Widget* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Window_signal_set_focus_info =
{
  "set_focus",
  (GCallback) &Window_signal_set_focus_callback,
  (GCallback) &Window_signal_set_focus_callback
};


static gboolean Window_signal_frame_event_callback(GtkWindow* self, GdkEvent* p0,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< bool,GdkEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Window_signal_frame_event_notify_callback(GtkWindow* self, GdkEvent* p0, void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,GdkEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Window_signal_frame_event_info =
{
  "frame_event",
  (GCallback) &Window_signal_frame_event_callback,
  (GCallback) &Window_signal_frame_event_notify_callback
};

} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::WindowGroup> wrap(GtkWindowGroup* object, bool take_copy)
{
  return Glib::RefPtr<Gtk::WindowGroup>( dynamic_cast<Gtk::WindowGroup*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& WindowGroup_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &WindowGroup_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_window_group_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void WindowGroup_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* WindowGroup_Class::wrap_new(GObject* object)
{
  return new WindowGroup((GtkWindowGroup*)object);
}


/* The implementation: */

GtkWindowGroup* WindowGroup::gobj_copy()
{
  reference();
  return gobj();
}

WindowGroup::WindowGroup(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{}

WindowGroup::WindowGroup(GtkWindowGroup* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

WindowGroup::~WindowGroup()
{}


WindowGroup::CppClassType WindowGroup::windowgroup_class_; // initialize static member

GType WindowGroup::get_type()
{
  return windowgroup_class_.init().get_type();
}

GType WindowGroup::get_base_type()
{
  return gtk_window_group_get_type();
}


WindowGroup::WindowGroup()
:
  Glib::ObjectBase(0), //Mark this class as gtkmmproc-generated, rather than a custom class, to allow vfunc optimisations.
  Glib::Object(Glib::ConstructParams(windowgroup_class_.init()))
{
  }

Glib::RefPtr<WindowGroup> WindowGroup::create()
{
  return Glib::RefPtr<WindowGroup>( new WindowGroup() );
}
void WindowGroup::add_window(Window& window)
{
gtk_window_group_add_window(gobj(), (window).gobj()); 
}

void WindowGroup::remove_window(Window& window)
{
gtk_window_group_remove_window(gobj(), (window).gobj()); 
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gtk


namespace Glib
{

Gtk::Window* wrap(GtkWindow* object, bool take_copy)
{
  return dynamic_cast<Gtk::Window *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Window_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Window_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_window_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void Window_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED //We always need dispose_vfunc_callback
    reinterpret_cast<GObjectClass*>(klass)->dispose = &dispose_vfunc_callback;
#ifdef GLIBMM_VFUNCS_ENABLED
  #endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->set_focus = &set_focus_callback;
  klass->frame_event = &frame_event_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Window_Class::set_focus_callback(GtkWindow* self, GtkWidget* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      // Call the virtual member method, which derived classes might override.
      obj->on_set_focus(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->set_focus)
      (*base->set_focus)(self, p0);
  }
}

gboolean Window_Class::frame_event_callback(GtkWindow* self, GdkEvent* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      // Call the virtual member method, which derived classes might override.
      return static_cast<int>(obj->on_frame_event(p0));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->frame_event)
      return (*base->frame_event)(self, p0);
  }

  typedef gboolean RType;
  return RType();
}

#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Window_Class::wrap_new(GObject* o)
{
  return new Window((GtkWindow*)(o)); //top-level windows can not be manage()ed.

}


/* The implementation: */

Window::Window(const Glib::ConstructParams& construct_params)
:
  Gtk::Bin(construct_params)
{
  }

Window::Window(GtkWindow* castitem)
:
  Gtk::Bin((GtkBin*)(castitem))
{
  }

Window::~Window()
{
  destroy_();
}

Window::CppClassType Window::window_class_; // initialize static member

GType Window::get_type()
{
  return window_class_.init().get_type();
}

GType Window::get_base_type()
{
  return gtk_window_get_type();
}

Window::Window(WindowType type)
:
  Glib::ObjectBase(0), //Mark this class as gtkmmproc-generated, rather than a custom class, to allow vfunc optimisations.
  Gtk::Bin(Glib::ConstructParams(window_class_.init(), "type", ((GtkWindowType)(type)), (char*) 0))
{
  }

 WindowType Window::get_window_type() const
{
  return static_cast<WindowType>(gobj()->type);
}
 
 Glib::RefPtr<Gdk::Window> Window::get_frame()
{
  Glib::RefPtr<Gdk::Window> ref_ptr(Glib::wrap((GdkWindowObject*)(gobj()->frame)));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<const Gdk::Window> Window::get_frame() const
{
  Glib::RefPtr<const Gdk::Window> ref_ptr(Glib::wrap((GdkWindowObject*)(gobj()->frame)));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}
 
void Window::set_title(const Glib::ustring& title)
{
gtk_window_set_title(gobj(), title.c_str()); 
}

Glib::ustring Window::get_title() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_window_get_title(const_cast<GtkWindow*>(gobj())));
}

void Window::set_wmclass(const Glib::ustring& wmclass_name, const Glib::ustring& wmclass_class)
{
gtk_window_set_wmclass(gobj(), wmclass_name.c_str(), wmclass_class.c_str()); 
}

void Window::set_role(const Glib::ustring& role)
{
gtk_window_set_role(gobj(), role.c_str()); 
}

Glib::ustring Window::get_role() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_window_get_role(const_cast<GtkWindow*>(gobj())));
}

void Window::add_accel_group(const Glib::RefPtr<AccelGroup>& accel_group)
{
gtk_window_add_accel_group(gobj(), Glib::unwrap(accel_group)); 
}

void Window::remove_accel_group(const Glib::RefPtr<AccelGroup>& accel_group)
{
gtk_window_remove_accel_group(gobj(), Glib::unwrap(accel_group)); 
}

void Window::set_position(WindowPosition position)
{
gtk_window_set_position(gobj(), ((GtkWindowPosition)(position))); 
}

bool Window::activate_focus()
{
  return gtk_window_activate_focus(gobj());
}

void Window::set_focus(Gtk::Widget& focus)
{
gtk_window_set_focus(gobj(), (focus).gobj()); 
}

Widget* Window::get_focus()
{
  return Glib::wrap(gtk_window_get_focus(gobj()));
}

const Widget* Window::get_focus() const
{
  return const_cast<Window*>(this)->get_focus();
}

void Window::set_default(Gtk::Widget& default_widget)
{
gtk_window_set_default(gobj(), (default_widget).gobj()); 
}

bool Window::activate_default()
{
  return gtk_window_activate_default(gobj());
}

void Window::set_transient_for(Window& parent)
{
gtk_window_set_transient_for(gobj(), (parent).gobj()); 
}

Window* Window::get_transient_for()
{
  return Glib::wrap(gtk_window_get_transient_for(gobj()));
}

const Window* Window::get_transient_for() const
{
  return const_cast<Window*>(this)->get_transient_for();
}

void Window::set_type_hint(Gdk::WindowTypeHint hint)
{
gtk_window_set_type_hint(gobj(), ((GdkWindowTypeHint)(hint))); 
}

Gdk::WindowTypeHint Window::get_type_hint() const
{
  return ((Gdk::WindowTypeHint)(gtk_window_get_type_hint(const_cast<GtkWindow*>(gobj()))));
}

void Window::set_skip_taskbar_hint(bool setting)
{
gtk_window_set_skip_taskbar_hint(gobj(), static_cast<int>(setting)); 
}

bool Window::get_skip_taskbar_hint() const
{
  return gtk_window_get_skip_taskbar_hint(const_cast<GtkWindow*>(gobj()));
}

void Window::set_skip_pager_hint(bool setting)
{
gtk_window_set_skip_pager_hint(gobj(), static_cast<int>(setting)); 
}

bool Window::get_skip_pager_hint() const
{
  return gtk_window_get_skip_pager_hint(const_cast<GtkWindow*>(gobj()));
}

void Window::set_urgency_hint(bool setting)
{
gtk_window_set_urgency_hint(gobj(), static_cast<int>(setting)); 
}

bool Window::get_urgency_hint() const
{
  return gtk_window_get_urgency_hint(const_cast<GtkWindow*>(gobj()));
}

bool Window::get_destroy_with_parent() const
{
  return gtk_window_get_destroy_with_parent(const_cast<GtkWindow*>(gobj()));
}

void Window::set_resizable(bool resizable)
{
gtk_window_set_resizable(gobj(), static_cast<int>(resizable)); 
}

bool Window::get_resizable() const
{
  return gtk_window_get_resizable(const_cast<GtkWindow*>(gobj()));
}

void Window::set_gravity(Gdk::Gravity gravity)
{
gtk_window_set_gravity(gobj(), ((GdkGravity)(gravity))); 
}

Gdk::Gravity Window::get_gravity() const
{
  return ((Gdk::Gravity)(gtk_window_get_gravity(const_cast<GtkWindow*>(gobj()))));
}

void Window::set_geometry_hints(Widget& geometry_widget, const Gdk::Geometry& geometry, Gdk::WindowHints geom_mask)
{
gtk_window_set_geometry_hints(gobj(), (geometry_widget).gobj(), const_cast<GdkGeometry*>(&(geometry)), ((GdkWindowHints)(geom_mask))); 
}

void Window::set_screen(const Glib::RefPtr<Gdk::Screen>& screen)
{
gtk_window_set_screen(gobj(), Glib::unwrap(screen)); 
}

Glib::RefPtr<Gdk::Screen> Window::get_screen()
{

  Glib::RefPtr<Gdk::Screen> retvalue = Glib::wrap(gtk_window_get_screen(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Gdk::Screen> Window::get_screen() const
{
  return const_cast<Window*>(this)->get_screen();
}

void Window::set_has_frame(bool setting)
{
gtk_window_set_has_frame(gobj(), static_cast<int>(setting)); 
}

bool Window::get_has_frame() const
{
  return gtk_window_get_has_frame(const_cast<GtkWindow*>(gobj()));
}

void Window::set_frame_dimensions(int left, int top, int right, int bottom)
{
gtk_window_set_frame_dimensions(gobj(), left, top, right, bottom); 
}

void Window::get_frame_dimensions(int& left, int& top, int& right, int& bottom) const
{
gtk_window_get_frame_dimensions(const_cast<GtkWindow*>(gobj()), &left, &top, &right, &bottom); 
}

void Window::set_decorated(bool setting)
{
gtk_window_set_decorated(gobj(), static_cast<int>(setting)); 
}

bool Window::get_decorated() const
{
  return gtk_window_get_decorated(const_cast<GtkWindow*>(gobj()));
}

void Window::set_deletable(bool setting)
{
gtk_window_set_deletable(gobj(), static_cast<int>(setting)); 
}

bool Window::get_deletable() const
{
  return gtk_window_get_deletable(const_cast<GtkWindow*>(gobj()));
}

Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> > Window::get_icon_list()
{
  return Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> >(gtk_window_get_icon_list(gobj()), Glib::OWNERSHIP_SHALLOW);
}

Glib::ListHandle< Glib::RefPtr<const Gdk::Pixbuf> > Window::get_icon_list() const
{
  return Glib::ListHandle< Glib::RefPtr<const Gdk::Pixbuf> >(gtk_window_get_icon_list(const_cast<GtkWindow*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

void Window::set_icon_list(const Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> >& list)
{
gtk_window_set_icon_list(gobj(), list.data()); 
}

void Window::set_icon(const Glib::RefPtr<Gdk::Pixbuf>& icon)
{
gtk_window_set_icon(gobj(), Glib::unwrap(icon)); 
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Window::set_icon_from_file(const std::string& filename)
#else
bool Window::set_icon_from_file(const std::string& filename, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gtk_window_set_icon_from_file(gobj(), filename.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

Glib::RefPtr<Gdk::Pixbuf> Window::get_icon()
{

  Glib::RefPtr<Gdk::Pixbuf> retvalue = Glib::wrap(gtk_window_get_icon(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Gdk::Pixbuf> Window::get_icon() const
{
  return const_cast<Window*>(this)->get_icon();
}

void Window::set_default_icon_list(const Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> >& list)
{
gtk_window_set_default_icon_list(list.data());
}

Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> > Window::get_default_icon_list()
{
  return Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> >(gtk_window_get_default_icon_list(), Glib::OWNERSHIP_SHALLOW);
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Window::set_default_icon_from_file(const std::string& filename)
#else
bool Window::set_default_icon_from_file(const std::string& filename, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gtk_window_set_default_icon_from_file(filename.c_str(), &(gerror));

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;
}

void Window::set_auto_startup_notification(bool setting)
{
gtk_window_set_auto_startup_notification(static_cast<int>(setting));
}

void Window::set_modal(bool modal)
{
gtk_window_set_modal(gobj(), static_cast<int>(modal)); 
}

bool Window::get_modal() const
{
  return gtk_window_get_modal(const_cast<GtkWindow*>(gobj()));
}

Glib::ListHandle<Window*> Window::list_toplevels()
{
  return Glib::ListHandle<Window*>(gtk_window_list_toplevels(), Glib::OWNERSHIP_SHALLOW);
}

void Window::add_mnemonic(guint keyval, Widget& target)
{
gtk_window_add_mnemonic(gobj(), keyval, (target).gobj()); 
}

void Window::remove_mnemonic(guint keyval, Widget& target)
{
gtk_window_remove_mnemonic(gobj(), keyval, (target).gobj()); 
}

bool Window::mnemonic_activate(guint keyval, Gdk::ModifierType modifier)
{
  return gtk_window_mnemonic_activate(gobj(), keyval, ((GdkModifierType)(modifier)));
}

void Window::set_mnemonic_modifier(Gdk::ModifierType modifier)
{
gtk_window_set_mnemonic_modifier(gobj(), ((GdkModifierType)(modifier))); 
}

Gdk::ModifierType Window::get_mnemonic_modifier()
{
  return ((Gdk::ModifierType)(gtk_window_get_mnemonic_modifier(gobj())));
}

void Window::present()
{
gtk_window_present(gobj()); 
}

void Window::present(guint32 timestamp)
{
gtk_window_present_with_time(gobj(), timestamp); 
}

void Window::iconify()
{
gtk_window_iconify(gobj()); 
}

void Window::deiconify()
{
gtk_window_deiconify(gobj()); 
}

void Window::stick()
{
gtk_window_stick(gobj()); 
}

void Window::unstick()
{
gtk_window_unstick(gobj()); 
}

void Window::maximize()
{
gtk_window_maximize(gobj()); 
}

void Window::unmaximize()
{
gtk_window_unmaximize(gobj()); 
}

void Window::fullscreen()
{
gtk_window_fullscreen(gobj()); 
}

void Window::unfullscreen()
{
gtk_window_unfullscreen(gobj()); 
}

void Window::begin_resize_drag(Gdk::WindowEdge edge, int button, int root_x, int root_y, guint32 timestamp)
{
gtk_window_begin_resize_drag(gobj(), ((GdkWindowEdge)(edge)), button, root_x, root_y, timestamp); 
}

void Window::begin_move_drag(int button, int root_x, int root_y, guint32 timestamp)
{
gtk_window_begin_move_drag(gobj(), button, root_x, root_y, timestamp); 
}

void Window::set_default_size(int width, int height)
{
gtk_window_set_default_size(gobj(), width, height); 
}

void Window::get_default_size(int& width, int& height) const
{
gtk_window_get_default_size(const_cast<GtkWindow*>(gobj()), &width, &height); 
}

void Window::resize(int width, int height)
{
gtk_window_resize(gobj(), width, height); 
}

void Window::get_size(int& width, int& height) const
{
gtk_window_get_size(const_cast<GtkWindow*>(gobj()), &width, &height); 
}

void Window::move(int x, int y)
{
gtk_window_move(gobj(), x, y); 
}

void Window::get_position(int& root_x, int& root_y) const
{
gtk_window_get_position(const_cast<GtkWindow*>(gobj()), &root_x, &root_y); 
}

bool Window::parse_geometry(const Glib::ustring& geometry)
{
  return gtk_window_parse_geometry(gobj(), geometry.c_str());
}

Glib::RefPtr<WindowGroup> Window::get_group()
{

  Glib::RefPtr<WindowGroup> retvalue = Glib::wrap(gtk_window_get_group(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const WindowGroup> Window::get_group() const
{
  return const_cast<Window*>(this)->get_group();
}

void Window::reshow_with_initial_size()
{
gtk_window_reshow_with_initial_size(gobj()); 
}

void Window::set_default_icon(const Glib::RefPtr<Gdk::Pixbuf>& icon)
{
gtk_window_set_default_icon(Glib::unwrap(icon));
}

void Window::set_keep_above(bool setting)
{
gtk_window_set_keep_above(gobj(), static_cast<int>(setting)); 
}

void Window::set_keep_below(bool setting)
{
gtk_window_set_keep_below(gobj(), static_cast<int>(setting)); 
}


Glib::SignalProxy1< void,Widget* > Window::signal_set_focus()
{
  return Glib::SignalProxy1< void,Widget* >(this, &Window_signal_set_focus_info);
}

Glib::SignalProxy1< bool,GdkEvent* > Window::signal_frame_event()
{
  return Glib::SignalProxy1< bool,GdkEvent* >(this, &Window_signal_frame_event_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Window::property_title() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "title");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Window::property_title() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "title");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Window::property_allow_shrink() 
{
  return Glib::PropertyProxy<bool>(this, "allow-shrink");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Window::property_allow_shrink() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "allow-shrink");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Window::property_allow_grow() 
{
  return Glib::PropertyProxy<bool>(this, "allow-grow");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Window::property_allow_grow() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "allow-grow");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Window::property_resizable() 
{
  return Glib::PropertyProxy<bool>(this, "resizable");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Window::property_resizable() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "resizable");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Window::property_modal() 
{
  return Glib::PropertyProxy<bool>(this, "modal");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Window::property_modal() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "modal");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<WindowPosition> Window::property_window_position() 
{
  return Glib::PropertyProxy<WindowPosition>(this, "window-position");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<WindowPosition> Window::property_window_position() const
{
  return Glib::PropertyProxy_ReadOnly<WindowPosition>(this, "window-position");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Window::property_default_width() 
{
  return Glib::PropertyProxy<int>(this, "default-width");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Window::property_default_width() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "default-width");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Window::property_default_height() 
{
  return Glib::PropertyProxy<int>(this, "default-height");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Window::property_default_height() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "default-height");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Window::property_destroy_with_parent() 
{
  return Glib::PropertyProxy<bool>(this, "destroy-with-parent");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Window::property_destroy_with_parent() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "destroy-with-parent");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > Window::property_icon() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> >(this, "icon");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Pixbuf> > Window::property_icon() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Pixbuf> >(this, "icon");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<Gdk::Screen> > Window::property_screen() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Screen> >(this, "screen");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Screen> > Window::property_screen() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Screen> >(this, "screen");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Window::property_is_active() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "is-active");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Window::property_has_toplevel_focus() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "has-toplevel-focus");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<GdkWindowTypeHint> Window::property_type_hint() 
{
  return Glib::PropertyProxy<GdkWindowTypeHint>(this, "type-hint");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<GdkWindowTypeHint> Window::property_type_hint() const
{
  return Glib::PropertyProxy_ReadOnly<GdkWindowTypeHint>(this, "type-hint");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Window::property_skip_taskbar_hint() 
{
  return Glib::PropertyProxy<bool>(this, "skip-taskbar-hint");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Window::property_skip_taskbar_hint() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "skip-taskbar-hint");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Window::property_skip_pager_hint() 
{
  return Glib::PropertyProxy<bool>(this, "skip-pager-hint");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Window::property_skip_pager_hint() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "skip-pager-hint");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Window::property_role() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "role");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Window::property_role() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "role");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Window::property_decorated() 
{
  return Glib::PropertyProxy<bool>(this, "decorated");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Window::property_decorated() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "decorated");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Gdk::Gravity> Window::property_gravity() 
{
  return Glib::PropertyProxy<Gdk::Gravity>(this, "gravity");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Gdk::Gravity> Window::property_gravity() const
{
  return Glib::PropertyProxy_ReadOnly<Gdk::Gravity>(this, "gravity");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Window::property_urgency_hint() 
{
  return Glib::PropertyProxy<bool>(this, "urgency-hint");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Window::property_urgency_hint() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "urgency-hint");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Window::property_deletable() 
{
  return Glib::PropertyProxy<bool>(this, "deletable");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Window::property_deletable() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "deletable");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Gtk::Window::on_set_focus(Widget* focus)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_focus)
    (*base->set_focus)(gobj(),(GtkWidget*)Glib::unwrap(focus));
}

bool Gtk::Window::on_frame_event(GdkEvent* event)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->frame_event)
    return (*base->frame_event)(gobj(),event);

  typedef bool RType;
  return RType();
}

#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gtk


