/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:29 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * A widget that lists the available fonts, styles and sizes, allowing the
 * user to select a font.  It is used in the {@link FontSelectionDialog} 
 * widget to provide a dialog box for selecting fonts.
 * @see FontSelectionDialog
 */
public class FontSelection extends VBox {
	/**
	 * Creates a new font selection widget
	 */
	public FontSelection() {
		noopInit();
	}
	
	/**
	 * Construct a new FontSelection from a handle to a native resource.
	 */
	public FontSelection(int handle) {
	    super(handle);
	}
	
	protected void noopInit() {
		if (-1 == handle) {
			handle = gtk_font_selection_new();
			initializeEventHandlers();
		}
	}

	/**
	 * Exception used when a request was made to set a font which is not
	 * available.
	 */
	class FontNotFoundException extends Exception {
	}

	/**
	 * Sets the currently-selected font.
	 * @param font The name of the font to be selected
	 */
	public void setFont(String font) throws FontNotFoundException {
		if (!gtk_font_selection_set_font_name(handle, font)) {
			throw new FontNotFoundException();
		}
	}

	/**
	 * Returns the name of the currently selected font.
	 * @return The name of the selected font.
	 */
	public String getFont() {
		return gtk_font_selection_get_font_name(handle);
	}

	/**
	 * Returns the text which appears in the preview box.
	 */
	public String getPreviewText() {
		return gtk_font_selection_get_preview_text(handle);
	}

	/**
	 * Sets the text to appear in the preview box.
	 * @param previewText The text which should appear in the preview box
	 */
	public void getPreviewText(String previewText) {
		gtk_font_selection_set_preview_text(handle, previewText);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_font_selection_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_font_selection_get_type();
	native static final protected int gtk_font_selection_new();
	native static final protected String gtk_font_selection_get_font_name(int fontsel);
	native static final protected boolean gtk_font_selection_set_font_name(int fontsel, String fontname);
	native static final protected String gtk_font_selection_get_preview_text(int fontsel);
	native static final protected void gtk_font_selection_set_preview_text(int fontsel, String text);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
