// Generated by gtkmmproc -- DO NOT MODIFY!

#include <gtkmm/actiongroup.h>
#include <gtkmm/private/actiongroup_p.h>

// -*- c++ -*-
/* $Id: actiongroup.ccg,v 1.4 2003/11/04 18:11:36 murrayc Exp $ */

/* Copyright 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkactiongroup.h>
#include <gtkmm/accelmap.h>


namespace Gtk
{

void ActionGroup::add(const Glib::RefPtr<Action>& action, const Action::SlotActivate& slot)
{
  //This is meant to be similar to the gtk_action_group_add_actions() convenience method that is used from C.
  //This also does the work of gtk_action_group_add_toggle_actions() and gtk_action_group_add_radio_actions_full(),
  //because the extra stuff there is already done when the Action (or a derived type, such as ToggleAction) is create()ed.
  
  action->signal_activate().connect(slot);
  //TODO: Use the translation_func?
  add(action);
}

void ActionGroup::add(const Glib::RefPtr<Action>& action, const AccelKey& accel_key, const Action::SlotActivate& slot)
{
  //This is meant to be similar to the gtk_action_group_add_actions() convenience method that is used from C.
  //This also does the work of gtk_action_group_add_toggle_actions() and gtk_action_group_add_radio_actions_full(),
  //because the extra stuff there is already done when the Action (or a derived type, such as ToggleAction) is create()ed.

  add(action, slot);

  //Create the accel path (a kind of unique key):
  Glib::ustring accel_path = "<Actions>/" + get_name() + "/" + action->get_name();

  //Register the accel path:
  Gtk::AccelMap::add_entry(accel_path, accel_key.get_key(), accel_key.get_mod());

  //USe the accel path:
  action->set_accel_path(accel_path);
}  


} // namespace Gtk


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::ActionGroup> wrap(GtkActionGroup* object, bool take_copy)
{
  return Glib::RefPtr<Gtk::ActionGroup>( dynamic_cast<Gtk::ActionGroup*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& ActionGroup_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &ActionGroup_Class::class_init_function;

    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually necessary?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_action_group_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void ActionGroup_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

}


Glib::ObjectBase* ActionGroup_Class::wrap_new(GObject* object)
{
  return new ActionGroup((GtkActionGroup*)object);
}


/* The implementation: */

GtkActionGroup* ActionGroup::gobj_copy()
{
  reference();
  return gobj();
}

ActionGroup::ActionGroup(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{}

ActionGroup::ActionGroup(GtkActionGroup* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

ActionGroup::~ActionGroup()
{}

ActionGroup::CppClassType ActionGroup::actiongroup_class_; // initialize static member

GType ActionGroup::get_type()
{
  return actiongroup_class_.init().get_type();
}

GType ActionGroup::get_base_type()
{
  return gtk_action_group_get_type();
}


ActionGroup::ActionGroup(const Glib::ustring& name)
:
  Glib::ObjectBase(0), //Mark this class as gtkmmproc-generated, rather than a custom class, to allow vfunc optimisations.
  Glib::Object(Glib::ConstructParams(actiongroup_class_.init(), "name", name.c_str(), (char*) 0))
{
  }

Glib::RefPtr<ActionGroup> ActionGroup::create(const Glib::ustring& name)
{
  return Glib::RefPtr<ActionGroup>( new ActionGroup(name) );
}
Glib::ustring ActionGroup::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_action_group_get_name(const_cast<GtkActionGroup*>(gobj())));
}

Glib::RefPtr<Action> ActionGroup::get_action(const Glib::ustring& action_name)
{
  return Glib::wrap(gtk_action_group_get_action(gobj(), action_name.c_str()));
}

Glib::RefPtr<const Action> ActionGroup::get_action(const Glib::ustring& action_name) const
{
  return Glib::wrap(gtk_action_group_get_action(const_cast<GtkActionGroup*>(gobj()), action_name.c_str()));
}

Glib::ListHandle< Glib::RefPtr<Action> > ActionGroup::get_actions()
{
  return Glib::ListHandle< Glib::RefPtr<Action> >(gtk_action_group_list_actions(gobj()), Glib::OWNERSHIP_SHALLOW);
}

void ActionGroup::add(const Glib::RefPtr<Action>& action)
{
  gtk_action_group_add_action(gobj(), Glib::unwrap(action));
}

void ActionGroup::remove(const Glib::RefPtr<Action>& action)
{
  gtk_action_group_remove_action(gobj(), Glib::unwrap(action));
}


} // namespace Gtk


