// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TEXTVIEW_H
#define _GTKMM_TEXTVIEW_H

#include <glibmm.h>

/* $Id: textview.hg,v 1.4 2003/11/01 17:02:39 murrayc Exp $ */

/* Copyright(C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>
#include <gtkmm/textbuffer.h>
#include <gtkmm/textmark.h>
#include <gtkmm/menu.h>
#include <gtkmm/adjustment.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTextView GtkTextView;
typedef struct _GtkTextViewClass GtkTextViewClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TextView_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum TextWindowType
{
  TEXT_WINDOW_PRIVATE,
  TEXT_WINDOW_WIDGET,
  TEXT_WINDOW_TEXT,
  TEXT_WINDOW_LEFT,
  TEXT_WINDOW_RIGHT,
  TEXT_WINDOW_TOP,
  TEXT_WINDOW_BOTTOM
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TextWindowType> : public Glib::Value_Enum<Gtk::TextWindowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** @defgroup TextView TextView Classes
 * These classes are used with the Gtk::TextView widget.
 */

/** Multi-line text editing widget. It displays a Gtk::TextBuffer.
 * @ingroup Widgets
 * @ingroup Containers
 * @ingroup TextView
 */

class TextView : public Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TextView CppObjectType;
  typedef TextView_Class CppClassType;
  typedef GtkTextView BaseObjectType;
  typedef GtkTextViewClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TextView();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class TextView_Class;
  static CppClassType textview_class_;

  // noncopyable
  TextView(const TextView&);
  TextView& operator=(const TextView&);

protected:
  explicit TextView(const Glib::ConstructParams& construct_params);
  explicit TextView(GtkTextView* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkTextView*       gobj()       { return reinterpret_cast<GtkTextView*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkTextView* gobj() const { return reinterpret_cast<GtkTextView*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_set_scroll_adjustments(Adjustment* hadjustment, Adjustment* vadjustment);
  virtual void on_populate_popup(Menu* menu);
  virtual void on_set_anchor();
  virtual void on_insert_at_cursor(const Glib::ustring& str);


private:

public:
  TextView();
  explicit TextView(const Glib::RefPtr<TextBuffer>& buffer);

  
  void set_buffer(const Glib::RefPtr<TextBuffer>& buffer);
  
  Glib::RefPtr<TextBuffer> get_buffer();
  
  Glib::RefPtr<const TextBuffer> get_buffer() const;

  bool scroll_to_iter(TextBuffer::iterator& iter, double within_margin);
  bool scroll_to_iter(TextBuffer::iterator& iter, double within_margin, double xalign, double yalign);
  

  void scroll_to_mark(const Glib::RefPtr<TextBuffer::Mark>&mark, double within_margin);
  void scroll_to_mark(const Glib::RefPtr<TextBuffer::Mark>&mark, double within_margin, double xalign, double yalign);
  

  void scroll_mark_onscreen(const Glib::RefPtr<TextBuffer::Mark>& mark);
  
  bool move_mark_onscreen(const Glib::RefPtr<TextBuffer::Mark>& mark);
  
  bool place_cursor_onscreen();

  
  void get_visible_rect(Gdk::Rectangle& visible_rect);
  
  void set_cursor_visible(bool setting = true);
  
  bool get_cursor_visible() const;

  
  void get_iter_location(const TextBuffer::iterator&  iter,
                                                    Gdk::Rectangle& location);
  
  void get_iter_at_location(TextBuffer::iterator& iter, int x, int y);
  
  void get_line_yrange(const TextBuffer::iterator&  iter,
                                                   int& y, int& height);

  
  void get_line_at_y(TextBuffer::iterator&  target_iter, int y, int& line_top);

  
  void buffer_to_window_coords(TextWindowType  win,
                                            int buffer_x, int buffer_y,
                                            int& window_x, int& window_y);
  
  void window_to_buffer_coords(TextWindowType  win,
                                            int window_x, int window_y,
                                            int& buffer_x, int& buffer_y);

  
  Glib::RefPtr<Gdk::Window> get_window(TextWindowType win);
  
  Glib::RefPtr<const Gdk::Window> get_window(TextWindowType win) const;
  
  TextWindowType get_window_type(const Glib::RefPtr<Gdk::Window>& window);

  
  void set_border_window_size(TextWindowType  type, int size);
  
  int get_border_window_size(TextWindowType type);

  
  bool forward_display_line(TextBuffer::iterator& iter);
  
  bool backward_display_line(TextBuffer::iterator& iter);
  
  bool forward_display_line_end(TextBuffer::iterator& iter);
  
  bool backward_display_line_start(TextBuffer::iterator& iter);
  
  bool starts_display_line(const TextBuffer::iterator&  iter);
  
  bool move_visually(TextBuffer::iterator& iter, int count);

  
  void add_child_at_anchor(Widget& child, const Glib::RefPtr<TextChildAnchor>& anchor);

  
  void add_child_in_window(Widget& child, TextWindowType which_window,
                                        int xpos, int ypos);

  
  void move_child(Widget& child, int xpos,int ypos);

  
  void set_wrap_mode(WrapMode wrap_mode);
  
  WrapMode get_wrap_mode();
  
  void set_editable(bool setting = true);
  
  bool get_editable() const;
  
  void set_pixels_above_lines(int pixels_above_lines);
  
  int get_pixels_above_lines();
  
  void set_pixels_below_lines(int pixels_below_lines);
  
  int get_pixels_below_lines();
  
  void set_pixels_inside_wrap(int pixels_inside_wrap);
  
  int get_pixels_inside_wrap();
  
  void set_justification(Justification justification);
  
  Justification get_justification();
  
  void set_left_margin(int left_margin);
  
  int get_left_margin();
  
  void set_right_margin(int right_margin);
  
  int get_right_margin();
  
  void set_indent(int indent);
  
  int get_indent();
  
  void set_tabs(Pango::TabArray& tabs);
  
  Pango::TabArray get_tabs();
  
  TextAttributes get_default_attributes();

  
  void set_overwrite(bool overwrite = true);
  
  bool get_overwrite() const;
  
  
  void set_accepts_tab(bool accepts_tab = true);
  
  bool get_accepts_tab() const;
    
  
  /**
   * @par Prototype:
   * <tt>void %set_scroll_adjustments(Adjustment* hadjustment, Adjustment* vadjustment)</tt>
   */
  Glib::SignalProxy2< void,Adjustment*,Adjustment* > signal_set_scroll_adjustments();

  
  /**
   * @par Prototype:
   * <tt>void %populate_popup(Menu* menu)</tt>
   */
  Glib::SignalProxy1< void,Menu* > signal_populate_popup();


  /**
   * @par Prototype:
   * <tt>void %set_anchor()</tt>
   */
  Glib::SignalProxy0< void > signal_set_anchor();

  
  /**
   * @par Prototype:
   * <tt>void %insert_at_cursor(const Glib::ustring& str)</tt>
   */
  Glib::SignalProxy1< void,const Glib::ustring& > signal_insert_at_cursor();

  
  //Keybinding signals:
  
  
  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<int> property_pixels_above_lines();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<int> property_pixels_below_lines();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<int> property_pixels_inside_wrap();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_editable();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<WrapMode> property_wrap_mode();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<Justification> property_justification();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<int> property_left_margin();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<int> property_right_margin();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<int> property_indent();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<Pango::TabArray> property_tabs();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_cursor_visible();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy< Glib::RefPtr<TextBuffer> > property_buffer();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_overwrite();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_accepts_tab();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::TextView */
  Gtk::TextView* wrap(GtkTextView* object, bool take_copy = false);
}
#endif /* _GTKMM_TEXTVIEW_H */

