/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_ColorButton
#define _Included_org_gnu_gtk_ColorButton
#ifdef __cplusplus
extern "C" {
#endif
/* Inaccessible static: evtMap */
/* Inaccessible static: class_000240 */
/* Inaccessible static: class_000241 */
/* Inaccessible static: class_000242 */
/* Inaccessible static: class_000243 */
/* Inaccessible static: class_000244 */
/* Inaccessible static: class_000245 */
/* Inaccessible static: evtMap */
/* Inaccessible static: class_000240 */
/* Inaccessible static: evtMap */
/* Inaccessible static: class_000240 */
/*
 * Class:     org_gnu_gtk_ColorButton
 * Method:    gtk_color_button_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ColorButton_gtk_1color_1button_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_color_button_get_type();
}

/*
 * Class:     org_gnu_gtk_ColorButton
 * Method:    gtk_color_button_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ColorButton_gtk_1color_1button_1new
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_color_button_new();
}

/*
 * Class:     org_gnu_gtk_ColorButton
 * Method:    gtk_color_button_new_with_color
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ColorButton_gtk_1color_1button_1new_1with_1color
  (JNIEnv *env, jclass cls, jint color)
{
	return (jint)gtk_color_button_new_with_color((GdkColor*)color);
}

/*
 * Class:     org_gnu_gtk_ColorButton
 * Method:    gtk_color_button_set_color
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ColorButton_gtk_1color_1button_1set_1color
  (JNIEnv *env, jclass cls, jint button, jint color)
{
	gtk_color_button_set_color((GtkColorButton*)button, (GdkColor*)color);
}

/*
 * Class:     org_gnu_gtk_ColorButton
 * Method:    gtk_color_button_set_alpha
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ColorButton_gtk_1color_1button_1set_1alpha
  (JNIEnv *env, jclass cls, jint button, jint alpha)
{
	gtk_color_button_set_alpha((GtkColorButton*)button, (guint16)alpha);
}

/*
 * Class:     org_gnu_gtk_ColorButton
 * Method:    gtk_color_button_get_color
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ColorButton_gtk_1color_1button_1get_1color
  (JNIEnv *env, jclass cls, jint button)
{
	GdkColor *color;
	gtk_color_button_get_color((GtkColorButton*)button, color);
	return (jint)color;
}

/*
 * Class:     org_gnu_gtk_ColorButton
 * Method:    gtk_color_button_get_alpha
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ColorButton_gtk_1color_1button_1get_1alpha
  (JNIEnv *env, jclass cls, jint button)
{
	return (jint)gtk_color_button_get_alpha((GtkColorButton*)button);
}

/*
 * Class:     org_gnu_gtk_ColorButton
 * Method:    gtk_color_button_set_use_alpha
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ColorButton_gtk_1color_1button_1set_1use_1alpha
  (JNIEnv *env, jclass cls, jint button, jboolean useAlpha)
{
	gtk_color_button_set_use_alpha((GtkColorButton*)button, (gboolean)useAlpha);
}

/*
 * Class:     org_gnu_gtk_ColorButton
 * Method:    gtk_color_button_get_use_alpha
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_ColorButton_gtk_1color_1button_1get_1use_1alpha
  (JNIEnv *env, jclass cls, jint button)
{
	return (jboolean)gtk_color_button_get_use_alpha((GtkColorButton*)button);
}

/*
 * Class:     org_gnu_gtk_ColorButton
 * Method:    gtk_color_button_set_title
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ColorButton_gtk_1color_1button_1set_1title
  (JNIEnv *env, jclass cls, jint button, jstring title)
{
	const gchar* t = (gchar*)(*env)->GetStringUTFChars(env, title, NULL);
	gtk_color_button_set_title((GtkColorButton*)button, t);
	(*env)->ReleaseStringUTFChars(env, title, t);
}

/*
 * Class:     org_gnu_gtk_ColorButton
 * Method:    gtk_color_button_get_title
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_ColorButton_gtk_1color_1button_1get_1title
  (JNIEnv *env, jclass cls, jint button)
{
	const gchar *title = gtk_color_button_get_title((GtkColorButton*)button);
	return (*env)->NewStringUTF(env, title);
}

#ifdef __cplusplus
}
#endif
#endif
