/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.Boxed;

/**
 * The PangoRectangle structure represents a rectangle. It is frequently used to
 * represent the logical or ink extents of a single glyph or section of text.
 */
public class Rectangle extends Boxed 
{

	protected Rectangle(int handle){
		this.handle = handle;
	}

	/**
	 * Returns X coordinate of the left side of the rectangle.
	 */
	public int getX(){
		return getX(handle);
	}

	/**
	 * Returns Y coordinate of the the top side of the rectangle.
	 */
	public int getY(){
		return getY(handle);
	}

	/**
	 * Returns width of the rectangle.
	 */
	public int getWidth(){
		return getWidth(handle);
	}

	/**
	 * Returns height of the rectangle.
	 */
	public int getHeight(){
		return getHeight(handle);
}	
		
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getX (int obj);
    native static final protected int getY (int obj);
    native static final protected int getWidth (int obj);
    native static final protected int getHeight (int obj);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

