/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <valacodegen.h>
#include <valagee.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <config.h>
#include <gobject/gvaluecollector.h>

#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};

static gint ValaCompiler_private_offset;
static gpointer vala_compiler_parent_class = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_packages;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_library;
static gchar* vala_compiler_shared_library;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_directory;
static gboolean vala_compiler_version;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_ccode_only;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename;
static gchar** vala_compiler_fast_vapis;
static gboolean vala_compiler_vapi_comments;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_depfile;
static gboolean vala_compiler_list_sources;
static gchar* vala_compiler_symbols_filename;
static gboolean vala_compiler_compile_only;
static gchar* vala_compiler_output;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_mem_profiler;
static gchar** vala_compiler_defines;
static gchar* vala_compiler_entry_point;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_hide_internal;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_disable_since_check;
static gboolean vala_compiler_keep_going;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_gobject_tracing;
static gchar* vala_compiler_cc_command;
static gchar** vala_compiler_cc_options;
static gchar* vala_compiler_pkg_config_command;
static gchar* vala_compiler_dump_tree;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_disable_colored_output;
static gchar* vala_compiler_target_glib;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources_directories;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_disable_version_header;
static gchar* vala_compiler_run_args;
static gboolean vala_compiler_abi_stability;
static gchar** vala_compiler_sources;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_shared_library = NULL;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources = NULL;
static gchar** vala_compiler_gresources_directories = NULL;
static gboolean vala_compiler_ccode_only = FALSE;
static gboolean vala_compiler_abi_stability = FALSE;
static gchar* vala_compiler_header_filename = NULL;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gboolean vala_compiler_vapi_comments = FALSE;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_hide_internal = FALSE;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_since_check = FALSE;
static gboolean vala_compiler_disable_warnings = FALSE;
static gboolean vala_compiler_keep_going = FALSE;
static gboolean vala_compiler_list_sources = FALSE;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_pkg_config_command = NULL;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode = FALSE;
static ValaProfile vala_compiler_profile;
static ValaProfile vala_compiler_profile = 0;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gboolean vala_compiler_disable_colored_output = FALSE;
static ValaReportColored vala_compiler_colored_output;
static ValaReportColored vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_depfile = NULL;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;
static gchar* vala_compiler_run_args = NULL;

 G_GNUC_INTERNAL gpointer vala_compiler_ref (gpointer instance);
 G_GNUC_INTERNAL void vala_compiler_unref (gpointer instance);
 G_GNUC_INTERNAL GParamSpec* vala_param_spec_compiler (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
 G_GNUC_INTERNAL void vala_value_set_compiler (GValue* value,
                              gpointer v_object) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL void vala_value_take_compiler (GValue* value,
                               gpointer v_object);
 G_GNUC_INTERNAL gpointer vala_value_get_compiler (const GValue* value) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GType vala_compiler_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaCompiler, vala_compiler_unref)
#define VALA_COMPILER_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gboolean vala_compiler_option_deprecated (const gchar* option_name,
                                          const gchar* val,
                                          void* data,
                                          GError** error);
static gboolean vala_compiler_option_parse_profile (const gchar* option_name,
                                             const gchar* val,
                                             void* data,
                                             GError** error);
static gboolean vala_compiler_option_parse_color (const gchar* option_name,
                                           const gchar* val,
                                           void* data,
                                           GError** error);
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gint vala_compiler_run_source (gchar** args,
                               gint args_length1);
 G_GNUC_INTERNAL ValaCompiler* vala_compiler_new (void);
 G_GNUC_INTERNAL ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_,
                  GPid pid,
                  gint status);
static void ____lambda4__gchild_watch_func (GPid pid,
                                     gint status,
                                     gpointer self);
static gint vala_compiler_main (gchar** args,
                         gint args_length1);
static void vala_compiler_finalize (ValaCompiler * obj);
static GType vala_compiler_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[63] = {{"vapidir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"shared-library", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_shared_library, "Shared library name used in generated gir", "NAME"}, {"gir", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Change output directory from current working directory", "DIRECTORY"}, {"version", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, (gint) (G_OPTION_FLAG_OPTIONAL_ARG | G_OPTION_FLAG_NO_ARG), G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_deprecated, "Use C header file (DEPRECATED AND IGNORED)", NULL}, {"includedir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"vapi-comments", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_vapi_comments, "Include comments in generated vapi", NULL}, {"deps", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"depfile", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_depfile, "Write make-style external dependency information for build systems to " \
"this file", NULL}, {"list-sources", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_list_sources, "Output a list of all source and binding files which are used", NULL}, {"symbols", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, (gint) (G_OPTION_FLAG_OPTIONAL_ARG | G_OPTION_FLAG_NO_ARG), G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_deprecated, "Enable multithreading support (DEPRECATED AND IGNORED)", NULL}, {"enable-mem-profiler", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"hide-internal", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_hide_internal, "Hide symbols marked as internal", NULL}, {"enable-experimental", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"disable-since-check", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_disable_since_check, "Do not check whether used symbols exist in local packages", NULL}, {"keep-going", 'k', (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_keep_going, "Continue as much as possible after an error", NULL}, {"enable-experimental-non-null", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"pkg-config", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_pkg_config_command, "Use COMMAND as pkg-config command", "COMMAND"}, {"dump-tree", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_parse_profile, "Minimum runtime dependency: 'gobject' (default) or 'posix' (minimal li" \
"bc)", "PROFILE"}, {"quiet", 'q', (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"no-color", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_disable_colored_output, "Disable colored output, alias for --color=never", NULL}, {"color", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_parse_color, "Enable color output, options are 'always', 'never', or 'auto'", "WHEN"}, {"target-glib", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "'MAJOR.MINOR', or 'auto'"}, {"gresources", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"gresourcesdir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources_directories, "Look for resources in DIRECTORY", "DIRECTORY..."}, {"enable-version-header", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"run-args", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_run_args, "Arguments passed to directly compiled executable", NULL}, {"abi-stability", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_abi_stability, "Enable support for ABI stability", NULL}, {G_OPTION_REMAINING, (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static inline gpointer
vala_compiler_get_instance_private (ValaCompiler* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCompiler_private_offset);
}

static gboolean
vala_compiler_option_parse_color (const gchar* option_name,
                                  const gchar* val,
                                  void* data,
                                  GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = val;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("auto")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("never")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (NULL)))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("always"))))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_ALWAYS;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp3_;
				_tmp3_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "Invalid --color argument '%s'", val);
				_inner_error0_ = _tmp3_;
				if (_inner_error0_->domain == G_OPTION_ERROR) {
					gboolean _tmp4_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp4_;
				} else {
					gboolean _tmp5_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp5_;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_compiler_option_parse_profile (const gchar* option_name,
                                    const gchar* val,
                                    void* data,
                                    GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = val;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (NULL)))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("gobject-2.0"))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("gobject"))))) {
		switch (0) {
			default:
			{
				vala_compiler_profile = VALA_PROFILE_GOBJECT;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("posix")))) {
		switch (0) {
			default:
			{
				vala_compiler_profile = VALA_PROFILE_POSIX;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp3_;
				_tmp3_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "Invalid --profile argument '%s'", val);
				_inner_error0_ = _tmp3_;
				if (_inner_error0_->domain == G_OPTION_ERROR) {
					gboolean _tmp4_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp4_;
				} else {
					gboolean _tmp5_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp5_;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_compiler_option_deprecated (const gchar* option_name,
                                 const gchar* val,
                                 void* data,
                                 GError** error)
{
	FILE* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Command-line option `%s` is deprecated and will be ignored\n", option_name);
	result = TRUE;
	return result;
}

static gint
vala_compiler_quit (ValaCompiler* self)
{
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	gboolean _tmp7_ = FALSE;
	ValaCodeContext* _tmp8_;
	ValaReport* _tmp9_;
	ValaReport* _tmp10_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	if (vala_report_get_errors (_tmp3_) == 0) {
		ValaCodeContext* _tmp4_;
		ValaReport* _tmp5_;
		ValaReport* _tmp6_;
		_tmp4_ = self->priv->context;
		_tmp5_ = vala_code_context_get_report (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = vala_report_get_warnings (_tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_code_context_pop ();
		result = 0;
		return result;
	}
	_tmp8_ = self->priv->context;
	_tmp9_ = vala_code_context_get_report (_tmp8_);
	_tmp10_ = _tmp9_;
	if (vala_report_get_errors (_tmp10_) == 0) {
		gboolean _tmp11_ = FALSE;
		if (!vala_compiler_fatal_warnings) {
			_tmp11_ = TRUE;
		} else {
			ValaCodeContext* _tmp12_;
			ValaReport* _tmp13_;
			ValaReport* _tmp14_;
			_tmp12_ = self->priv->context;
			_tmp13_ = vala_code_context_get_report (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp11_ = vala_report_get_warnings (_tmp14_) == 0;
		}
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		if (!vala_compiler_quiet_mode) {
			FILE* _tmp15_;
			ValaCodeContext* _tmp16_;
			ValaReport* _tmp17_;
			ValaReport* _tmp18_;
			_tmp15_ = stdout;
			_tmp16_ = self->priv->context;
			_tmp17_ = vala_code_context_get_report (_tmp16_);
			_tmp18_ = _tmp17_;
			fprintf (_tmp15_, "Compilation succeeded - %d warning(s)\n", vala_report_get_warnings (_tmp18_));
		}
		vala_code_context_pop ();
		result = 0;
		return result;
	} else {
		if (!vala_compiler_quiet_mode) {
			FILE* _tmp19_;
			ValaCodeContext* _tmp20_;
			ValaReport* _tmp21_;
			ValaReport* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaReport* _tmp24_;
			ValaReport* _tmp25_;
			_tmp19_ = stdout;
			_tmp20_ = self->priv->context;
			_tmp21_ = vala_code_context_get_report (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = self->priv->context;
			_tmp24_ = vala_code_context_get_report (_tmp23_);
			_tmp25_ = _tmp24_;
			fprintf (_tmp19_, "Compilation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (_tmp22_), vala_report_get_warnings (_tmp25_));
		}
		vala_code_context_pop ();
		result = 1;
		return result;
	}
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
vala_compiler_run (ValaCompiler* self)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReportColored _tmp2_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	ValaCodeContext* _tmp26_;
	ValaCodeContext* _tmp27_;
	ValaCodeContext* _tmp28_;
	ValaCodeContext* _tmp29_;
	ValaCodeContext* _tmp30_;
	ValaCodeContext* _tmp31_;
	ValaCodeContext* _tmp32_;
	ValaCodeContext* _tmp33_;
	ValaCodeContext* _tmp34_;
	ValaCodeContext* _tmp35_;
	ValaReport* _tmp36_;
	ValaReport* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaReport* _tmp39_;
	ValaReport* _tmp40_;
	ValaCodeContext* _tmp41_;
	ValaCodeContext* _tmp42_;
	ValaCodeContext* _tmp43_;
	gboolean _tmp44_ = FALSE;
	ValaCodeContext* _tmp46_;
	ValaCodeContext* _tmp47_;
	ValaCodeContext* _tmp48_;
	const gchar* _tmp49_;
	ValaCodeContext* _tmp50_;
	const gchar* _tmp51_;
	ValaCodeContext* _tmp52_;
	const gchar* _tmp53_;
	ValaCodeContext* _tmp54_;
	const gchar* _tmp55_;
	ValaCodeContext* _tmp56_;
	const gchar* _tmp57_;
	gboolean _tmp58_ = FALSE;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	const gchar* _tmp68_;
	ValaCodeContext* _tmp77_;
	gchar** _tmp78_;
	gint _tmp78__length1;
	ValaCodeContext* _tmp79_;
	ValaCodeContext* _tmp80_;
	gchar** _tmp81_;
	gint _tmp81__length1;
	ValaCodeContext* _tmp82_;
	gchar** _tmp83_;
	gint _tmp83__length1;
	ValaCodeContext* _tmp84_;
	ValaCodeContext* _tmp85_;
	ValaCodeContext* _tmp86_;
	gboolean _tmp87_ = FALSE;
	const gchar* _tmp88_;
	ValaCodeContext* _tmp89_;
	const gchar* _tmp90_;
	ValaCodeContext* _tmp91_;
	const gchar* _tmp92_;
	ValaCodeContext* _tmp96_;
	const gchar* _tmp97_;
	ValaCodeContext* _tmp98_;
	ValaProfile _tmp99_;
	const gchar* _tmp100_;
	gchar** _tmp103_;
	gint _tmp103__length1;
	gchar** _tmp108_;
	gint _tmp108__length1;
	gchar** _tmp113_;
	gint _tmp113__length1;
	ValaCodeContext* _tmp124_;
	gchar** _tmp125_;
	gint _tmp125__length1;
	ValaCodeContext* _tmp126_;
	gchar** _tmp127_;
	gint _tmp127__length1;
	gboolean _tmp128_ = FALSE;
	ValaCodeContext* _tmp129_;
	ValaReport* _tmp130_;
	ValaReport* _tmp131_;
	ValaCodeContext* _tmp136_;
	ValaProfile _tmp137_;
	ValaProfile _tmp138_;
	gboolean has_c_files = FALSE;
	gboolean has_h_files = FALSE;
	gchar** _tmp145_;
	gint _tmp145__length1;
	gboolean _tmp151_ = FALSE;
	gboolean _tmp153_ = FALSE;
	ValaCodeContext* _tmp154_;
	ValaReport* _tmp155_;
	ValaReport* _tmp156_;
	ValaParser* parser = NULL;
	ValaParser* _tmp183_;
	ValaParser* _tmp184_;
	ValaCodeContext* _tmp185_;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp186_;
	ValaGenieParser* _tmp187_;
	ValaCodeContext* _tmp188_;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp189_;
	ValaGirParser* _tmp190_;
	ValaCodeContext* _tmp191_;
	gboolean _tmp192_ = FALSE;
	ValaCodeContext* _tmp193_;
	ValaReport* _tmp194_;
	ValaReport* _tmp195_;
	const gchar* _tmp200_;
	ValaCodeContext* _tmp205_;
	gboolean _tmp206_ = FALSE;
	ValaCodeContext* _tmp207_;
	ValaReport* _tmp208_;
	ValaReport* _tmp209_;
	gboolean _tmp214_ = FALSE;
	gboolean _tmp215_ = FALSE;
	const gchar* _tmp221_;
	gboolean _tmp226_ = FALSE;
	ValaCodeContext* _tmp227_;
	ValaReport* _tmp228_;
	ValaReport* _tmp229_;
	ValaCodeContext* _tmp234_;
	ValaCodeGenerator* _tmp235_;
	ValaCodeGenerator* _tmp236_;
	ValaCodeContext* _tmp237_;
	gboolean _tmp238_ = FALSE;
	ValaCodeContext* _tmp239_;
	ValaReport* _tmp240_;
	ValaReport* _tmp241_;
	gboolean _tmp246_ = FALSE;
	const gchar* _tmp247_;
	const gchar* _tmp251_;
	const gchar* _tmp294_;
	const gchar* _tmp307_;
	const gchar* _tmp350_;
	const gchar* _tmp353_;
	gboolean _tmp356_ = FALSE;
	ValaCodeContext* _tmp357_;
	ValaReport* _tmp358_;
	ValaReport* _tmp359_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	if (vala_compiler_disable_colored_output) {
		vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
	}
	_tmp2_ = vala_compiler_colored_output;
	if (_tmp2_ != VALA_REPORT_COLORED_NEVER) {
		const gchar* env_colors = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp3_;
		_tmp4_ = env_colors;
		if (_tmp4_ != NULL) {
			ValaCodeContext* _tmp5_;
			ValaReport* _tmp6_;
			ValaReport* _tmp7_;
			const gchar* _tmp8_;
			ValaReportColored _tmp9_;
			_tmp5_ = self->priv->context;
			_tmp6_ = vala_code_context_get_report (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = env_colors;
			_tmp9_ = vala_compiler_colored_output;
			vala_report_set_colors (_tmp7_, _tmp8_, _tmp9_);
		} else {
			ValaCodeContext* _tmp10_;
			ValaReport* _tmp11_;
			ValaReport* _tmp12_;
			ValaReportColored _tmp13_;
			_tmp10_ = self->priv->context;
			_tmp11_ = vala_code_context_get_report (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_compiler_colored_output;
			vala_report_set_colors (_tmp12_, VALA_COMPILER_DEFAULT_COLORS, _tmp13_);
		}
	}
	if (!vala_compiler_ccode_only) {
		_tmp15_ = !vala_compiler_compile_only;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		const gchar* _tmp16_;
		_tmp16_ = vala_compiler_output;
		_tmp14_ = _tmp16_ == NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		_tmp17_ = vala_compiler_sources;
		_tmp17__length1 = _vala_array_length (vala_compiler_sources);
		_tmp18_ = _tmp17_[0];
		if (string_last_index_of_char (_tmp18_, (gunichar) '.', 0) != -1) {
			gint dot = 0;
			gchar** _tmp19_;
			gint _tmp19__length1;
			const gchar* _tmp20_;
			gchar** _tmp21_;
			gint _tmp21__length1;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp19_ = vala_compiler_sources;
			_tmp19__length1 = _vala_array_length (vala_compiler_sources);
			_tmp20_ = _tmp19_[0];
			dot = string_last_index_of_char (_tmp20_, (gunichar) '.', 0);
			_tmp21_ = vala_compiler_sources;
			_tmp21__length1 = _vala_array_length (vala_compiler_sources);
			_tmp22_ = _tmp21_[0];
			_tmp23_ = string_substring (_tmp22_, (glong) 0, (glong) dot);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_path_get_basename (_tmp24_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp25_;
			_g_free0 (_tmp24_);
		}
	}
	_tmp26_ = self->priv->context;
	vala_code_context_set_assert (_tmp26_, !vala_compiler_disable_assert);
	_tmp27_ = self->priv->context;
	vala_code_context_set_checking (_tmp27_, vala_compiler_enable_checking);
	_tmp28_ = self->priv->context;
	vala_code_context_set_deprecated (_tmp28_, vala_compiler_deprecated);
	_tmp29_ = self->priv->context;
	vala_code_context_set_since_check (_tmp29_, !vala_compiler_disable_since_check);
	_tmp30_ = self->priv->context;
	vala_code_context_set_hide_internal (_tmp30_, vala_compiler_hide_internal);
	_tmp31_ = self->priv->context;
	vala_code_context_set_experimental (_tmp31_, vala_compiler_experimental);
	_tmp32_ = self->priv->context;
	vala_code_context_set_experimental_non_null (_tmp32_, vala_compiler_experimental_non_null);
	_tmp33_ = self->priv->context;
	vala_code_context_set_gobject_tracing (_tmp33_, vala_compiler_gobject_tracing);
	_tmp34_ = self->priv->context;
	vala_code_context_set_keep_going (_tmp34_, vala_compiler_keep_going);
	_tmp35_ = self->priv->context;
	_tmp36_ = vala_code_context_get_report (_tmp35_);
	_tmp37_ = _tmp36_;
	vala_report_set_enable_warnings (_tmp37_, !vala_compiler_disable_warnings);
	_tmp38_ = self->priv->context;
	_tmp39_ = vala_code_context_get_report (_tmp38_);
	_tmp40_ = _tmp39_;
	vala_report_set_verbose_errors (_tmp40_, !vala_compiler_quiet_mode);
	_tmp41_ = self->priv->context;
	vala_code_context_set_verbose_mode (_tmp41_, vala_compiler_verbose_mode);
	_tmp42_ = self->priv->context;
	vala_code_context_set_version_header (_tmp42_, !vala_compiler_disable_version_header);
	_tmp43_ = self->priv->context;
	vala_code_context_set_ccode_only (_tmp43_, vala_compiler_ccode_only);
	if (vala_compiler_ccode_only) {
		gchar** _tmp45_;
		gint _tmp45__length1;
		_tmp45_ = vala_compiler_cc_options;
		_tmp45__length1 = _vala_array_length (vala_compiler_cc_options);
		_tmp44_ = _tmp45_ != NULL;
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		vala_report_warning (NULL, "-X has no effect when -C or --ccode is set");
	}
	_tmp46_ = self->priv->context;
	vala_code_context_set_abi_stability (_tmp46_, vala_compiler_abi_stability);
	_tmp47_ = self->priv->context;
	vala_code_context_set_compile_only (_tmp47_, vala_compiler_compile_only);
	_tmp48_ = self->priv->context;
	_tmp49_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp48_, _tmp49_);
	_tmp50_ = self->priv->context;
	_tmp51_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp50_, _tmp51_);
	_tmp52_ = self->priv->context;
	_tmp53_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp52_, _tmp53_);
	_tmp54_ = self->priv->context;
	_tmp55_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp54_, _tmp55_);
	_tmp56_ = self->priv->context;
	_tmp57_ = vala_compiler_output;
	vala_code_context_set_output (_tmp56_, _tmp57_);
	_tmp59_ = vala_compiler_output;
	if (_tmp59_ != NULL) {
		_tmp58_ = vala_compiler_ccode_only;
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		vala_report_warning (NULL, "--output and -o have no effect when -C or --ccode is set");
	}
	_tmp60_ = vala_compiler_basedir;
	if (_tmp60_ == NULL) {
		ValaCodeContext* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		_tmp61_ = self->priv->context;
		_tmp62_ = vala_code_context_realpath (".");
		_tmp63_ = _tmp62_;
		vala_code_context_set_basedir (_tmp61_, _tmp63_);
		_g_free0 (_tmp63_);
	} else {
		ValaCodeContext* _tmp64_;
		const gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		_tmp64_ = self->priv->context;
		_tmp65_ = vala_compiler_basedir;
		_tmp66_ = vala_code_context_realpath (_tmp65_);
		_tmp67_ = _tmp66_;
		vala_code_context_set_basedir (_tmp64_, _tmp67_);
		_g_free0 (_tmp67_);
	}
	_tmp68_ = vala_compiler_directory;
	if (_tmp68_ != NULL) {
		ValaCodeContext* _tmp69_;
		const gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		_tmp69_ = self->priv->context;
		_tmp70_ = vala_compiler_directory;
		_tmp71_ = vala_code_context_realpath (_tmp70_);
		_tmp72_ = _tmp71_;
		vala_code_context_set_directory (_tmp69_, _tmp72_);
		_g_free0 (_tmp72_);
	} else {
		ValaCodeContext* _tmp73_;
		ValaCodeContext* _tmp74_;
		const gchar* _tmp75_;
		const gchar* _tmp76_;
		_tmp73_ = self->priv->context;
		_tmp74_ = self->priv->context;
		_tmp75_ = vala_code_context_get_basedir (_tmp74_);
		_tmp76_ = _tmp75_;
		vala_code_context_set_directory (_tmp73_, _tmp76_);
	}
	_tmp77_ = self->priv->context;
	_tmp78_ = vala_compiler_vapi_directories;
	_tmp78__length1 = _vala_array_length (vala_compiler_vapi_directories);
	vala_code_context_set_vapi_directories (_tmp77_, _tmp78_, _tmp78__length1);
	_tmp79_ = self->priv->context;
	vala_code_context_set_vapi_comments (_tmp79_, vala_compiler_vapi_comments);
	_tmp80_ = self->priv->context;
	_tmp81_ = vala_compiler_gir_directories;
	_tmp81__length1 = _vala_array_length (vala_compiler_gir_directories);
	vala_code_context_set_gir_directories (_tmp80_, _tmp81_, _tmp81__length1);
	_tmp82_ = self->priv->context;
	_tmp83_ = vala_compiler_metadata_directories;
	_tmp83__length1 = _vala_array_length (vala_compiler_metadata_directories);
	vala_code_context_set_metadata_directories (_tmp82_, _tmp83_, _tmp83__length1);
	_tmp84_ = self->priv->context;
	vala_code_context_set_debug (_tmp84_, vala_compiler_debug);
	_tmp85_ = self->priv->context;
	vala_code_context_set_mem_profiler (_tmp85_, vala_compiler_mem_profiler);
	_tmp86_ = self->priv->context;
	vala_code_context_set_save_temps (_tmp86_, vala_compiler_save_temps);
	if (vala_compiler_ccode_only) {
		_tmp87_ = vala_compiler_save_temps;
	} else {
		_tmp87_ = FALSE;
	}
	if (_tmp87_) {
		vala_report_warning (NULL, "--save-temps has no effect when -C or --ccode is set");
	}
	_tmp88_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = vala_compiler_nostdpkg | (_tmp88_ != NULL);
	_tmp89_ = self->priv->context;
	_tmp90_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp89_, _tmp90_);
	_tmp91_ = self->priv->context;
	vala_code_context_set_run_output (_tmp91_, vala_compiler_run_output);
	_tmp92_ = vala_compiler_pkg_config_command;
	if (_tmp92_ == NULL) {
		const gchar* _tmp93_ = NULL;
		const gchar* _tmp94_;
		gchar* _tmp95_;
		_tmp94_ = g_getenv ("PKG_CONFIG");
		_tmp93_ = _tmp94_;
		if (_tmp93_ == NULL) {
			_tmp93_ = "pkg-config";
		}
		_tmp95_ = g_strdup (_tmp93_);
		_g_free0 (vala_compiler_pkg_config_command);
		vala_compiler_pkg_config_command = _tmp95_;
	}
	_tmp96_ = self->priv->context;
	_tmp97_ = vala_compiler_pkg_config_command;
	vala_code_context_set_pkg_config_command (_tmp96_, _tmp97_);
	_tmp98_ = self->priv->context;
	_tmp99_ = vala_compiler_profile;
	vala_code_context_set_target_profile (_tmp98_, _tmp99_, !vala_compiler_nostdpkg);
	_tmp100_ = vala_compiler_target_glib;
	if (_tmp100_ != NULL) {
		ValaCodeContext* _tmp101_;
		const gchar* _tmp102_;
		_tmp101_ = self->priv->context;
		_tmp102_ = vala_compiler_target_glib;
		vala_code_context_set_target_glib_version (_tmp101_, _tmp102_);
	}
	_tmp103_ = vala_compiler_defines;
	_tmp103__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp103_ != NULL) {
		gchar** _tmp104_;
		gint _tmp104__length1;
		_tmp104_ = vala_compiler_defines;
		_tmp104__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp104_;
			define_collection_length1 = _tmp104__length1;
			for (define_it = 0; define_it < define_collection_length1; define_it = define_it + 1) {
				gchar* _tmp105_;
				gchar* define = NULL;
				_tmp105_ = g_strdup (define_collection[define_it]);
				define = _tmp105_;
				{
					ValaCodeContext* _tmp106_;
					const gchar* _tmp107_;
					_tmp106_ = self->priv->context;
					_tmp107_ = define;
					vala_code_context_add_define (_tmp106_, _tmp107_);
					_g_free0 (define);
				}
			}
		}
	}
	_tmp108_ = vala_compiler_packages;
	_tmp108__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp108_ != NULL) {
		gchar** _tmp109_;
		gint _tmp109__length1;
		_tmp109_ = vala_compiler_packages;
		_tmp109__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp109_;
			package_collection_length1 = _tmp109__length1;
			for (package_it = 0; package_it < package_collection_length1; package_it = package_it + 1) {
				gchar* _tmp110_;
				gchar* package = NULL;
				_tmp110_ = g_strdup (package_collection[package_it]);
				package = _tmp110_;
				{
					ValaCodeContext* _tmp111_;
					const gchar* _tmp112_;
					_tmp111_ = self->priv->context;
					_tmp112_ = package;
					vala_code_context_add_external_package (_tmp111_, _tmp112_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp113_ = vala_compiler_fast_vapis;
	_tmp113__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp113_ != NULL) {
		gchar** _tmp114_;
		gint _tmp114__length1;
		ValaCodeContext* _tmp123_;
		_tmp114_ = vala_compiler_fast_vapis;
		_tmp114__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp114_;
			vapi_collection_length1 = _tmp114__length1;
			for (vapi_it = 0; vapi_it < vapi_collection_length1; vapi_it = vapi_it + 1) {
				gchar* _tmp115_;
				gchar* vapi = NULL;
				_tmp115_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp115_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp116_;
					gchar* _tmp117_;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp118_;
					const gchar* _tmp119_;
					ValaSourceFile* _tmp120_;
					ValaCodeContext* _tmp121_;
					ValaSourceFile* _tmp122_;
					_tmp116_ = vapi;
					_tmp117_ = vala_code_context_realpath (_tmp116_);
					rpath = _tmp117_;
					_tmp118_ = self->priv->context;
					_tmp119_ = rpath;
					_tmp120_ = vala_source_file_new (_tmp118_, VALA_SOURCE_FILE_TYPE_FAST, _tmp119_, NULL, FALSE);
					source_file = _tmp120_;
					_tmp121_ = self->priv->context;
					_tmp122_ = source_file;
					vala_code_context_add_source_file (_tmp121_, _tmp122_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp123_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp123_, TRUE);
	}
	_tmp124_ = self->priv->context;
	_tmp125_ = vala_compiler_gresources;
	_tmp125__length1 = _vala_array_length (vala_compiler_gresources);
	vala_code_context_set_gresources (_tmp124_, _tmp125_, _tmp125__length1);
	_tmp126_ = self->priv->context;
	_tmp127_ = vala_compiler_gresources_directories;
	_tmp127__length1 = _vala_array_length (vala_compiler_gresources_directories);
	vala_code_context_set_gresources_directories (_tmp126_, _tmp127_, _tmp127__length1);
	_tmp129_ = self->priv->context;
	_tmp130_ = vala_code_context_get_report (_tmp129_);
	_tmp131_ = _tmp130_;
	if (vala_report_get_errors (_tmp131_) > 0) {
		_tmp128_ = TRUE;
	} else {
		gboolean _tmp132_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp133_;
			ValaReport* _tmp134_;
			ValaReport* _tmp135_;
			_tmp133_ = self->priv->context;
			_tmp134_ = vala_code_context_get_report (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp132_ = vala_report_get_warnings (_tmp135_) > 0;
		} else {
			_tmp132_ = FALSE;
		}
		_tmp128_ = _tmp132_;
	}
	if (_tmp128_) {
		result = vala_compiler_quit (self);
		return result;
	}
	_tmp136_ = self->priv->context;
	_tmp137_ = vala_code_context_get_profile (_tmp136_);
	_tmp138_ = _tmp137_;
	if (_tmp138_ == VALA_PROFILE_GOBJECT) {
		ValaCodeContext* _tmp139_;
		ValaGDBusServerModule* _tmp140_;
		ValaGDBusServerModule* _tmp141_;
		_tmp139_ = self->priv->context;
		_tmp140_ = vala_gd_bus_server_module_new ();
		_tmp141_ = _tmp140_;
		vala_code_context_set_codegen (_tmp139_, (ValaCodeGenerator*) _tmp141_);
		_vala_code_visitor_unref0 (_tmp141_);
	} else {
		ValaCodeContext* _tmp142_;
		ValaCCodeDelegateModule* _tmp143_;
		ValaCCodeDelegateModule* _tmp144_;
		_tmp142_ = self->priv->context;
		_tmp143_ = vala_ccode_delegate_module_new ();
		_tmp144_ = _tmp143_;
		vala_code_context_set_codegen (_tmp142_, (ValaCodeGenerator*) _tmp144_);
		_vala_code_visitor_unref0 (_tmp144_);
	}
	has_c_files = FALSE;
	has_h_files = FALSE;
	_tmp145_ = vala_compiler_sources;
	_tmp145__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp145_;
		source_collection_length1 = _tmp145__length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			gchar* _tmp146_;
			gchar* source = NULL;
			_tmp146_ = g_strdup (source_collection[source_it]);
			source = _tmp146_;
			{
				ValaCodeContext* _tmp147_;
				const gchar* _tmp148_;
				_tmp147_ = self->priv->context;
				_tmp148_ = source;
				if (vala_code_context_add_source_filename (_tmp147_, _tmp148_, vala_compiler_run_output, TRUE)) {
					const gchar* _tmp149_;
					_tmp149_ = source;
					if (g_str_has_suffix (_tmp149_, ".c")) {
						has_c_files = TRUE;
					} else {
						const gchar* _tmp150_;
						_tmp150_ = source;
						if (g_str_has_suffix (_tmp150_, ".h")) {
							has_h_files = TRUE;
						}
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	if (vala_compiler_ccode_only) {
		gboolean _tmp152_ = FALSE;
		if (has_c_files) {
			_tmp152_ = TRUE;
		} else {
			_tmp152_ = has_h_files;
		}
		_tmp151_ = _tmp152_;
	} else {
		_tmp151_ = FALSE;
	}
	if (_tmp151_) {
		vala_report_warning (NULL, "C header and source files are ignored when -C or --ccode is set");
	}
	_tmp154_ = self->priv->context;
	_tmp155_ = vala_code_context_get_report (_tmp154_);
	_tmp156_ = _tmp155_;
	if (vala_report_get_errors (_tmp156_) > 0) {
		_tmp153_ = TRUE;
	} else {
		gboolean _tmp157_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp158_;
			ValaReport* _tmp159_;
			ValaReport* _tmp160_;
			_tmp158_ = self->priv->context;
			_tmp159_ = vala_code_context_get_report (_tmp158_);
			_tmp160_ = _tmp159_;
			_tmp157_ = vala_report_get_warnings (_tmp160_) > 0;
		} else {
			_tmp157_ = FALSE;
		}
		_tmp153_ = _tmp157_;
	}
	if (_tmp153_) {
		result = vala_compiler_quit (self);
		return result;
	}
	if (vala_compiler_list_sources) {
		{
			ValaList* _file_list = NULL;
			ValaCodeContext* _tmp161_;
			ValaList* _tmp162_;
			gint _file_size = 0;
			ValaList* _tmp163_;
			gint _tmp164_;
			gint _tmp165_;
			gint _file_index = 0;
			_tmp161_ = self->priv->context;
			_tmp162_ = vala_code_context_get_source_files (_tmp161_);
			_file_list = _tmp162_;
			_tmp163_ = _file_list;
			_tmp164_ = vala_collection_get_size ((ValaCollection*) _tmp163_);
			_tmp165_ = _tmp164_;
			_file_size = _tmp165_;
			_file_index = -1;
			while (TRUE) {
				gint _tmp166_;
				gint _tmp167_;
				ValaSourceFile* file = NULL;
				ValaList* _tmp168_;
				gpointer _tmp169_;
				ValaSourceFile* _tmp170_;
				const gchar* _tmp171_;
				const gchar* _tmp172_;
				_file_index = _file_index + 1;
				_tmp166_ = _file_index;
				_tmp167_ = _file_size;
				if (!(_tmp166_ < _tmp167_)) {
					break;
				}
				_tmp168_ = _file_list;
				_tmp169_ = vala_list_get (_tmp168_, _file_index);
				file = (ValaSourceFile*) _tmp169_;
				_tmp170_ = file;
				_tmp171_ = vala_source_file_get_filename (_tmp170_);
				_tmp172_ = _tmp171_;
				g_print ("%s\n", _tmp172_);
				_vala_source_file_unref0 (file);
			}
		}
		if (!vala_compiler_ccode_only) {
			{
				ValaList* _filename_list = NULL;
				ValaCodeContext* _tmp173_;
				ValaList* _tmp174_;
				gint _filename_size = 0;
				ValaList* _tmp175_;
				gint _tmp176_;
				gint _tmp177_;
				gint _filename_index = 0;
				_tmp173_ = self->priv->context;
				_tmp174_ = vala_code_context_get_c_source_files (_tmp173_);
				_filename_list = _tmp174_;
				_tmp175_ = _filename_list;
				_tmp176_ = vala_collection_get_size ((ValaCollection*) _tmp175_);
				_tmp177_ = _tmp176_;
				_filename_size = _tmp177_;
				_filename_index = -1;
				while (TRUE) {
					gint _tmp178_;
					gint _tmp179_;
					gchar* filename = NULL;
					ValaList* _tmp180_;
					gpointer _tmp181_;
					const gchar* _tmp182_;
					_filename_index = _filename_index + 1;
					_tmp178_ = _filename_index;
					_tmp179_ = _filename_size;
					if (!(_tmp178_ < _tmp179_)) {
						break;
					}
					_tmp180_ = _filename_list;
					_tmp181_ = vala_list_get (_tmp180_, _filename_index);
					filename = (gchar*) _tmp181_;
					_tmp182_ = filename;
					g_print ("%s\n", _tmp182_);
					_g_free0 (filename);
				}
			}
		}
		result = 0;
		return result;
	}
	_tmp183_ = vala_parser_new ();
	parser = _tmp183_;
	_tmp184_ = parser;
	_tmp185_ = self->priv->context;
	vala_parser_parse (_tmp184_, _tmp185_);
	_tmp186_ = vala_genie_parser_new ();
	genie_parser = _tmp186_;
	_tmp187_ = genie_parser;
	_tmp188_ = self->priv->context;
	vala_genie_parser_parse (_tmp187_, _tmp188_);
	_tmp189_ = vala_gir_parser_new ();
	gir_parser = _tmp189_;
	_tmp190_ = gir_parser;
	_tmp191_ = self->priv->context;
	vala_gir_parser_parse (_tmp190_, _tmp191_);
	_tmp193_ = self->priv->context;
	_tmp194_ = vala_code_context_get_report (_tmp193_);
	_tmp195_ = _tmp194_;
	if (vala_report_get_errors (_tmp195_) > 0) {
		_tmp192_ = TRUE;
	} else {
		gboolean _tmp196_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp197_;
			ValaReport* _tmp198_;
			ValaReport* _tmp199_;
			_tmp197_ = self->priv->context;
			_tmp198_ = vala_code_context_get_report (_tmp197_);
			_tmp199_ = _tmp198_;
			_tmp196_ = vala_report_get_warnings (_tmp199_) > 0;
		} else {
			_tmp196_ = FALSE;
		}
		_tmp192_ = _tmp196_;
	}
	if (_tmp192_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp200_ = vala_compiler_fast_vapi_filename;
	if (_tmp200_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp201_;
		ValaCodeWriter* _tmp202_;
		ValaCodeContext* _tmp203_;
		const gchar* _tmp204_;
		_tmp201_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp201_;
		_tmp202_ = interface_writer;
		_tmp203_ = self->priv->context;
		_tmp204_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp202_, _tmp203_, _tmp204_);
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp205_ = self->priv->context;
	vala_code_context_check (_tmp205_);
	_tmp207_ = self->priv->context;
	_tmp208_ = vala_code_context_get_report (_tmp207_);
	_tmp209_ = _tmp208_;
	if (vala_report_get_errors (_tmp209_) > 0) {
		_tmp206_ = TRUE;
	} else {
		gboolean _tmp210_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp211_;
			ValaReport* _tmp212_;
			ValaReport* _tmp213_;
			_tmp211_ = self->priv->context;
			_tmp212_ = vala_code_context_get_report (_tmp211_);
			_tmp213_ = _tmp212_;
			_tmp210_ = vala_report_get_warnings (_tmp213_) > 0;
		} else {
			_tmp210_ = FALSE;
		}
		_tmp206_ = _tmp210_;
	}
	if (_tmp206_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	if (!vala_compiler_ccode_only) {
		_tmp215_ = !vala_compiler_compile_only;
	} else {
		_tmp215_ = FALSE;
	}
	if (_tmp215_) {
		const gchar* _tmp216_;
		_tmp216_ = vala_compiler_library;
		_tmp214_ = _tmp216_ == NULL;
	} else {
		_tmp214_ = FALSE;
	}
	if (_tmp214_) {
		gboolean _tmp217_ = FALSE;
		if (!has_c_files) {
			ValaCodeContext* _tmp218_;
			ValaMethod* _tmp219_;
			ValaMethod* _tmp220_;
			_tmp218_ = self->priv->context;
			_tmp219_ = vala_code_context_get_entry_point (_tmp218_);
			_tmp220_ = _tmp219_;
			_tmp217_ = _tmp220_ == NULL;
		} else {
			_tmp217_ = FALSE;
		}
		if (_tmp217_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp221_ = vala_compiler_dump_tree;
	if (_tmp221_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp222_;
		ValaCodeWriter* _tmp223_;
		ValaCodeContext* _tmp224_;
		const gchar* _tmp225_;
		_tmp222_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp222_;
		_tmp223_ = code_writer;
		_tmp224_ = self->priv->context;
		_tmp225_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp223_, _tmp224_, _tmp225_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp227_ = self->priv->context;
	_tmp228_ = vala_code_context_get_report (_tmp227_);
	_tmp229_ = _tmp228_;
	if (vala_report_get_errors (_tmp229_) > 0) {
		_tmp226_ = TRUE;
	} else {
		gboolean _tmp230_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp231_;
			ValaReport* _tmp232_;
			ValaReport* _tmp233_;
			_tmp231_ = self->priv->context;
			_tmp232_ = vala_code_context_get_report (_tmp231_);
			_tmp233_ = _tmp232_;
			_tmp230_ = vala_report_get_warnings (_tmp233_) > 0;
		} else {
			_tmp230_ = FALSE;
		}
		_tmp226_ = _tmp230_;
	}
	if (_tmp226_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp234_ = self->priv->context;
	_tmp235_ = vala_code_context_get_codegen (_tmp234_);
	_tmp236_ = _tmp235_;
	_tmp237_ = self->priv->context;
	vala_code_generator_emit (_tmp236_, _tmp237_);
	_tmp239_ = self->priv->context;
	_tmp240_ = vala_code_context_get_report (_tmp239_);
	_tmp241_ = _tmp240_;
	if (vala_report_get_errors (_tmp241_) > 0) {
		_tmp238_ = TRUE;
	} else {
		gboolean _tmp242_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp243_;
			ValaReport* _tmp244_;
			ValaReport* _tmp245_;
			_tmp243_ = self->priv->context;
			_tmp244_ = vala_code_context_get_report (_tmp243_);
			_tmp245_ = _tmp244_;
			_tmp242_ = vala_report_get_warnings (_tmp245_) > 0;
		} else {
			_tmp242_ = FALSE;
		}
		_tmp238_ = _tmp242_;
	}
	if (_tmp238_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp247_ = vala_compiler_vapi_filename;
	if (_tmp247_ == NULL) {
		const gchar* _tmp248_;
		_tmp248_ = vala_compiler_library;
		_tmp246_ = _tmp248_ != NULL;
	} else {
		_tmp246_ = FALSE;
	}
	if (_tmp246_) {
		const gchar* _tmp249_;
		gchar* _tmp250_;
		_tmp249_ = vala_compiler_library;
		_tmp250_ = g_strdup_printf ("%s.vapi", _tmp249_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp250_;
	}
	_tmp251_ = vala_compiler_library;
	if (_tmp251_ != NULL) {
		const gchar* _tmp252_;
		_tmp252_ = vala_compiler_gir;
		if (_tmp252_ != NULL) {
			ValaCodeContext* _tmp253_;
			ValaProfile _tmp254_;
			ValaProfile _tmp255_;
			_tmp253_ = self->priv->context;
			_tmp254_ = vala_code_context_get_profile (_tmp253_);
			_tmp255_ = _tmp254_;
			if (_tmp255_ == VALA_PROFILE_GOBJECT) {
				gchar* gir_base = NULL;
				const gchar* _tmp256_;
				gchar* _tmp257_;
				glong gir_len = 0L;
				const gchar* _tmp258_;
				gint _tmp259_;
				gint _tmp260_;
				gint last_hyphen = 0;
				const gchar* _tmp261_;
				gboolean _tmp262_ = FALSE;
				_tmp256_ = vala_compiler_gir;
				_tmp257_ = g_path_get_basename (_tmp256_);
				gir_base = _tmp257_;
				_tmp258_ = gir_base;
				_tmp259_ = strlen (_tmp258_);
				_tmp260_ = _tmp259_;
				gir_len = (glong) _tmp260_;
				_tmp261_ = gir_base;
				last_hyphen = string_last_index_of_char (_tmp261_, (gunichar) '-', 0);
				if (last_hyphen == -1) {
					_tmp262_ = TRUE;
				} else {
					const gchar* _tmp263_;
					_tmp263_ = gir_base;
					_tmp262_ = !g_str_has_suffix (_tmp263_, ".gir");
				}
				if (_tmp262_) {
					const gchar* _tmp264_;
					_tmp264_ = vala_compiler_gir;
					vala_report_error (NULL, "GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp264_);
				} else {
					gchar* gir_namespace = NULL;
					const gchar* _tmp265_;
					gchar* _tmp266_;
					gchar* gir_version = NULL;
					const gchar* _tmp267_;
					gchar* _tmp268_;
					const gchar* _tmp269_;
					gboolean _tmp270_ = FALSE;
					gboolean _tmp271_ = FALSE;
					gboolean _tmp272_ = FALSE;
					const gchar* _tmp273_;
					_tmp265_ = gir_base;
					_tmp266_ = string_substring (_tmp265_, (glong) 0, (glong) last_hyphen);
					gir_namespace = _tmp266_;
					_tmp267_ = gir_base;
					_tmp268_ = string_substring (_tmp267_, (glong) (last_hyphen + 1), (gir_len - last_hyphen) - 5);
					gir_version = _tmp268_;
					_tmp269_ = gir_version;
					g_strcanon (_tmp269_, "0123456789.", '?');
					_tmp273_ = gir_namespace;
					if (g_strcmp0 (_tmp273_, "") == 0) {
						_tmp272_ = TRUE;
					} else {
						const gchar* _tmp274_;
						_tmp274_ = gir_version;
						_tmp272_ = g_strcmp0 (_tmp274_, "") == 0;
					}
					if (_tmp272_) {
						_tmp271_ = TRUE;
					} else {
						const gchar* _tmp275_;
						_tmp275_ = gir_version;
						_tmp271_ = !g_ascii_isdigit (string_get (_tmp275_, (glong) 0));
					}
					if (_tmp271_) {
						_tmp270_ = TRUE;
					} else {
						const gchar* _tmp276_;
						_tmp276_ = gir_version;
						_tmp270_ = string_contains (_tmp276_, "?");
					}
					if (_tmp270_) {
						const gchar* _tmp277_;
						_tmp277_ = vala_compiler_gir;
						vala_report_error (NULL, "GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp277_);
					} else {
						ValaGIRWriter* gir_writer = NULL;
						ValaGIRWriter* _tmp278_;
						gchar* gir_directory = NULL;
						gchar* _tmp279_;
						const gchar* _tmp280_;
						ValaGIRWriter* _tmp285_;
						ValaCodeContext* _tmp286_;
						const gchar* _tmp287_;
						const gchar* _tmp288_;
						const gchar* _tmp289_;
						const gchar* _tmp290_;
						const gchar* _tmp291_;
						const gchar* _tmp292_;
						_tmp278_ = vala_gir_writer_new ();
						gir_writer = _tmp278_;
						_tmp279_ = g_strdup (".");
						gir_directory = _tmp279_;
						_tmp280_ = vala_compiler_directory;
						if (_tmp280_ != NULL) {
							ValaCodeContext* _tmp281_;
							const gchar* _tmp282_;
							const gchar* _tmp283_;
							gchar* _tmp284_;
							_tmp281_ = self->priv->context;
							_tmp282_ = vala_code_context_get_directory (_tmp281_);
							_tmp283_ = _tmp282_;
							_tmp284_ = g_strdup (_tmp283_);
							_g_free0 (gir_directory);
							gir_directory = _tmp284_;
						}
						_tmp285_ = gir_writer;
						_tmp286_ = self->priv->context;
						_tmp287_ = gir_directory;
						_tmp288_ = vala_compiler_gir;
						_tmp289_ = gir_namespace;
						_tmp290_ = gir_version;
						_tmp291_ = vala_compiler_library;
						_tmp292_ = vala_compiler_shared_library;
						vala_gir_writer_write_file (_tmp285_, _tmp286_, _tmp287_, _tmp288_, _tmp289_, _tmp290_, _tmp291_, _tmp292_);
						_g_free0 (gir_directory);
						_vala_code_visitor_unref0 (gir_writer);
					}
					_g_free0 (gir_version);
					_g_free0 (gir_namespace);
				}
				_g_free0 (gir_base);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	} else {
		const gchar* _tmp293_;
		_tmp293_ = vala_compiler_gir;
		if (_tmp293_ != NULL) {
			vala_report_warning (NULL, "--gir has no effect without --library");
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
		}
	}
	_tmp294_ = vala_compiler_vapi_filename;
	if (_tmp294_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp295_;
		gboolean _tmp296_ = FALSE;
		const gchar* _tmp297_;
		ValaCodeWriter* _tmp304_;
		ValaCodeContext* _tmp305_;
		const gchar* _tmp306_;
		_tmp295_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp295_;
		_tmp297_ = vala_compiler_directory;
		if (_tmp297_ != NULL) {
			const gchar* _tmp298_;
			_tmp298_ = vala_compiler_vapi_filename;
			_tmp296_ = !g_path_is_absolute (_tmp298_);
		} else {
			_tmp296_ = FALSE;
		}
		if (_tmp296_) {
			ValaCodeContext* _tmp299_;
			const gchar* _tmp300_;
			const gchar* _tmp301_;
			const gchar* _tmp302_;
			gchar* _tmp303_;
			_tmp299_ = self->priv->context;
			_tmp300_ = vala_code_context_get_directory (_tmp299_);
			_tmp301_ = _tmp300_;
			_tmp302_ = vala_compiler_vapi_filename;
			_tmp303_ = g_strdup_printf ("%s%c%s", _tmp301_, (gint) G_DIR_SEPARATOR, _tmp302_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp303_;
		}
		_tmp304_ = interface_writer;
		_tmp305_ = self->priv->context;
		_tmp306_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp304_, _tmp305_, _tmp306_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp307_ = vala_compiler_internal_vapi_filename;
	if (_tmp307_ != NULL) {
		gboolean _tmp308_ = FALSE;
		const gchar* _tmp309_;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp311_;
		ValaCodeContext* _tmp312_;
		const gchar* _tmp313_;
		const gchar* _tmp314_;
		gchar* vapi_filename = NULL;
		const gchar* _tmp337_;
		gchar* _tmp338_;
		gboolean _tmp339_ = FALSE;
		const gchar* _tmp340_;
		ValaCodeWriter* _tmp347_;
		ValaCodeContext* _tmp348_;
		const gchar* _tmp349_;
		_tmp309_ = vala_compiler_internal_header_filename;
		if (_tmp309_ == NULL) {
			_tmp308_ = TRUE;
		} else {
			const gchar* _tmp310_;
			_tmp310_ = vala_compiler_header_filename;
			_tmp308_ = _tmp310_ == NULL;
		}
		if (_tmp308_) {
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			result = vala_compiler_quit (self);
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp311_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp311_;
		_tmp312_ = self->priv->context;
		_tmp313_ = vala_code_context_get_includedir (_tmp312_);
		_tmp314_ = _tmp313_;
		if (_tmp314_ != NULL) {
			gchar* prefixed_header_filename = NULL;
			ValaCodeContext* _tmp315_;
			const gchar* _tmp316_;
			const gchar* _tmp317_;
			const gchar* _tmp318_;
			gchar* _tmp319_;
			gchar* _tmp320_;
			gchar* _tmp321_;
			gchar* _tmp322_;
			gchar* prefixed_internal_header_filename = NULL;
			ValaCodeContext* _tmp323_;
			const gchar* _tmp324_;
			const gchar* _tmp325_;
			const gchar* _tmp326_;
			gchar* _tmp327_;
			gchar* _tmp328_;
			gchar* _tmp329_;
			gchar* _tmp330_;
			ValaCodeWriter* _tmp331_;
			const gchar* _tmp332_;
			const gchar* _tmp333_;
			_tmp315_ = self->priv->context;
			_tmp316_ = vala_code_context_get_includedir (_tmp315_);
			_tmp317_ = _tmp316_;
			_tmp318_ = vala_compiler_header_filename;
			_tmp319_ = g_path_get_basename (_tmp318_);
			_tmp320_ = _tmp319_;
			_tmp321_ = g_build_path ("/", _tmp317_, _tmp320_, NULL);
			_tmp322_ = _tmp321_;
			_g_free0 (_tmp320_);
			prefixed_header_filename = _tmp322_;
			_tmp323_ = self->priv->context;
			_tmp324_ = vala_code_context_get_includedir (_tmp323_);
			_tmp325_ = _tmp324_;
			_tmp326_ = vala_compiler_internal_header_filename;
			_tmp327_ = g_path_get_basename (_tmp326_);
			_tmp328_ = _tmp327_;
			_tmp329_ = g_build_path ("/", _tmp325_, _tmp328_, NULL);
			_tmp330_ = _tmp329_;
			_g_free0 (_tmp328_);
			prefixed_internal_header_filename = _tmp330_;
			_tmp331_ = interface_writer;
			_tmp332_ = prefixed_header_filename;
			_tmp333_ = prefixed_internal_header_filename;
			vala_code_writer_set_cheader_override (_tmp331_, _tmp332_, _tmp333_);
			_g_free0 (prefixed_internal_header_filename);
			_g_free0 (prefixed_header_filename);
		} else {
			ValaCodeWriter* _tmp334_;
			const gchar* _tmp335_;
			const gchar* _tmp336_;
			_tmp334_ = interface_writer;
			_tmp335_ = vala_compiler_header_filename;
			_tmp336_ = vala_compiler_internal_header_filename;
			vala_code_writer_set_cheader_override (_tmp334_, _tmp335_, _tmp336_);
		}
		_tmp337_ = vala_compiler_internal_vapi_filename;
		_tmp338_ = g_strdup (_tmp337_);
		vapi_filename = _tmp338_;
		_tmp340_ = vala_compiler_directory;
		if (_tmp340_ != NULL) {
			const gchar* _tmp341_;
			_tmp341_ = vapi_filename;
			_tmp339_ = !g_path_is_absolute (_tmp341_);
		} else {
			_tmp339_ = FALSE;
		}
		if (_tmp339_) {
			ValaCodeContext* _tmp342_;
			const gchar* _tmp343_;
			const gchar* _tmp344_;
			const gchar* _tmp345_;
			gchar* _tmp346_;
			_tmp342_ = self->priv->context;
			_tmp343_ = vala_code_context_get_directory (_tmp342_);
			_tmp344_ = _tmp343_;
			_tmp345_ = vapi_filename;
			_tmp346_ = g_strdup_printf ("%s%c%s", _tmp344_, (gint) G_DIR_SEPARATOR, _tmp345_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp346_;
		}
		_tmp347_ = interface_writer;
		_tmp348_ = self->priv->context;
		_tmp349_ = vapi_filename;
		vala_code_writer_write_file (_tmp347_, _tmp348_, _tmp349_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp350_ = vala_compiler_dependencies;
	if (_tmp350_ != NULL) {
		ValaCodeContext* _tmp351_;
		const gchar* _tmp352_;
		_tmp351_ = self->priv->context;
		_tmp352_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp351_, _tmp352_);
	}
	_tmp353_ = vala_compiler_depfile;
	if (_tmp353_ != NULL) {
		ValaCodeContext* _tmp354_;
		const gchar* _tmp355_;
		_tmp354_ = self->priv->context;
		_tmp355_ = vala_compiler_depfile;
		vala_code_context_write_external_dependencies (_tmp354_, _tmp355_);
	}
	_tmp357_ = self->priv->context;
	_tmp358_ = vala_code_context_get_report (_tmp357_);
	_tmp359_ = _tmp358_;
	if (vala_report_get_errors (_tmp359_) > 0) {
		_tmp356_ = TRUE;
	} else {
		gboolean _tmp360_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp361_;
			ValaReport* _tmp362_;
			ValaReport* _tmp363_;
			_tmp361_ = self->priv->context;
			_tmp362_ = vala_code_context_get_report (_tmp361_);
			_tmp363_ = _tmp362_;
			_tmp360_ = vala_report_get_warnings (_tmp363_) > 0;
		} else {
			_tmp360_ = FALSE;
		}
		_tmp356_ = _tmp360_;
	}
	if (_tmp356_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	if (!vala_compiler_ccode_only) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp364_;
		gboolean _tmp365_ = FALSE;
		const gchar* _tmp366_;
		gchar** _tmp370_;
		gint _tmp370__length1;
		_tmp364_ = vala_ccode_compiler_new ();
		ccompiler = _tmp364_;
		_tmp366_ = vala_compiler_cc_command;
		if (_tmp366_ == NULL) {
			const gchar* _tmp367_;
			_tmp367_ = g_getenv ("CC");
			_tmp365_ = _tmp367_ != NULL;
		} else {
			_tmp365_ = FALSE;
		}
		if (_tmp365_) {
			const gchar* _tmp368_;
			gchar* _tmp369_;
			_tmp368_ = g_getenv ("CC");
			_tmp369_ = g_strdup (_tmp368_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp369_;
		}
		_tmp370_ = vala_compiler_cc_options;
		_tmp370__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp370_ == NULL) {
			ValaCCodeCompiler* _tmp371_;
			ValaCodeContext* _tmp372_;
			const gchar* _tmp373_;
			gchar** _tmp374_;
			gchar** _tmp375_;
			gint _tmp375__length1;
			_tmp371_ = ccompiler;
			_tmp372_ = self->priv->context;
			_tmp373_ = vala_compiler_cc_command;
			_tmp374_ = g_new0 (gchar*, 0 + 1);
			_tmp375_ = _tmp374_;
			_tmp375__length1 = 0;
			vala_ccode_compiler_compile (_tmp371_, _tmp372_, _tmp373_, _tmp375_, (gint) 0);
			_tmp375_ = (_vala_array_free (_tmp375_, _tmp375__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp376_;
			ValaCodeContext* _tmp377_;
			const gchar* _tmp378_;
			gchar** _tmp379_;
			gint _tmp379__length1;
			_tmp376_ = ccompiler;
			_tmp377_ = self->priv->context;
			_tmp378_ = vala_compiler_cc_command;
			_tmp379_ = vala_compiler_cc_options;
			_tmp379__length1 = _vala_array_length (vala_compiler_cc_options);
			vala_ccode_compiler_compile (_tmp376_, _tmp377_, _tmp378_, _tmp379_, (gint) _tmp379__length1);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	result = vala_compiler_quit (self);
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda4_ (Block1Data* _data1_,
             GPid pid,
             gint status)
{
	GMainLoop* _tmp0_;
	_data1_->child_status = (status & 0xff00) >> 8;
	_tmp0_ = _data1_->loop;
	g_main_loop_quit (_tmp0_);
}

static void
____lambda4__gchild_watch_func (GPid pid,
                                gint status,
                                gpointer self)
{
	___lambda4_ (self, pid, status);
}

static gint
vala_compiler_run_source (gchar** args,
                          gint args_length1)
{
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gint outputfd = 0;
	const gchar* _tmp21_;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp22_;
	gint ret = 0;
	ValaCompiler* _tmp23_;
	const gchar* _tmp24_;
	gchar** target_args = NULL;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gint target_args_length1;
	gint _target_args_size_;
	const gchar* _tmp29_;
	gint _tmp46_ = -1;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		_tmp0_ = g_option_context_new ("- Vala Interpreter");
		opt_context = _tmp0_;
		_tmp1_ = opt_context;
		g_option_context_set_help_enabled (_tmp1_, TRUE);
		_tmp2_ = opt_context;
		g_option_context_add_main_entries (_tmp2_, VALA_COMPILER_options, NULL);
		_tmp3_ = opt_context;
		g_option_context_parse (_tmp3_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		_tmp8_ = stdout;
		_tmp9_ = args[0];
		fprintf (_tmp8_, "Run '%s --help' to see a full list of available command line options.\n", _tmp9_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp10_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	if (vala_compiler_version) {
		FILE* _tmp11_;
		_tmp11_ = stdout;
		fprintf (_tmp11_, "Vala %s\n", VALA_BUILD_VERSION);
		result = 0;
		return result;
	} else {
		if (vala_compiler_api_version) {
			FILE* _tmp12_;
			_tmp12_ = stdout;
			fprintf (_tmp12_, "%s\n", VALA_API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp13_ = vala_compiler_sources;
	_tmp13__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp13_ == NULL) {
		FILE* _tmp14_;
		_tmp14_ = stderr;
		fprintf (_tmp14_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp15_ = g_get_tmp_dir ();
	_tmp16_ = vala_compiler_sources;
	_tmp16__length1 = _vala_array_length (vala_compiler_sources);
	_tmp17_ = _tmp16_[0];
	_tmp18_ = g_path_get_basename (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp15_, _tmp19_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp20_;
	_g_free0 (_tmp19_);
	_tmp21_ = vala_compiler_output;
	outputfd = g_mkstemp (_tmp21_);
	if (outputfd < 0) {
		result = 1;
		return result;
	}
	vala_compiler_ccode_only = FALSE;
	vala_compiler_compile_only = FALSE;
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_g_free0 (vala_compiler_library);
	vala_compiler_library = NULL;
	_g_free0 (vala_compiler_shared_library);
	vala_compiler_shared_library = NULL;
	_tmp22_ = vala_compiler_new ();
	compiler = _tmp22_;
	_tmp23_ = compiler;
	ret = vala_compiler_run (_tmp23_);
	if (ret != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	close (outputfd);
	_tmp24_ = vala_compiler_output;
	if (g_chmod (_tmp24_, 0700) != 0) {
		const gchar* _tmp25_;
		_tmp25_ = vala_compiler_output;
		g_unlink (_tmp25_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp26_ = vala_compiler_output;
	_tmp27_ = g_strdup (_tmp26_);
	_tmp28_ = g_new0 (gchar*, 1 + 1);
	_tmp28_[0] = _tmp27_;
	target_args = _tmp28_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	_tmp29_ = vala_compiler_run_args;
	if (_tmp29_ != NULL) {
		gchar** target_run_args = NULL;
		const gchar* _tmp30_;
		gchar** _tmp31_;
		gchar** _tmp32_;
		gint target_run_args_length1;
		gint _target_run_args_size_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		_tmp30_ = vala_compiler_run_args;
		_tmp32_ = _tmp31_ = g_strsplit (_tmp30_, " ", 0);
		target_run_args = _tmp32_;
		target_run_args_length1 = _vala_array_length (_tmp31_);
		_target_run_args_size_ = target_run_args_length1;
		_tmp33_ = target_run_args;
		_tmp33__length1 = target_run_args_length1;
		{
			gchar** arg_collection = NULL;
			gint arg_collection_length1 = 0;
			gint _arg_collection_size_ = 0;
			gint arg_it = 0;
			arg_collection = _tmp33_;
			arg_collection_length1 = _tmp33__length1;
			for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
				gchar* _tmp34_;
				gchar* arg = NULL;
				_tmp34_ = g_strdup (arg_collection[arg_it]);
				arg = _tmp34_;
				{
					const gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp35_ = arg;
					_tmp36_ = g_strdup (_tmp35_);
					_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp36_);
					_g_free0 (arg);
				}
			}
		}
		target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp37_;
		gchar** _tmp38_;
		gint _tmp38__length1;
		GPid _tmp39_ = 0;
		const gchar* _tmp41_;
		GMainLoop* _tmp42_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp37_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp37_;
		_data1_->child_status = 0;
		_tmp38_ = target_args;
		_tmp38__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp38_, NULL, G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp39_, &_inner_error0_);
		pid = _tmp39_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp40_ = -1;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp40_;
		}
		_tmp41_ = vala_compiler_output;
		g_unlink (_tmp41_);
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, pid, ____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp42_ = _data1_->loop;
		g_main_loop_run (_tmp42_);
		result = _data1_->child_status;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp43_;
		GError* _tmp44_;
		const gchar* _tmp45_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp43_ = stdout;
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		fprintf (_tmp43_, "%s\n", _tmp45_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp46_;
}

static gint
vala_compiler_main (gchar** args,
                    gint args_length1)
{
	const gchar* _tmp0_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp24_ = FALSE;
	gchar** _tmp25_;
	gint _tmp25__length1;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp28_;
	ValaCompiler* _tmp29_;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	setlocale (LC_ALL, "");
	_tmp0_ = vala_get_build_version ();
	if (g_strcmp0 (_tmp0_, VALA_BUILD_VERSION) != 0) {
		FILE* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = stderr;
		_tmp2_ = vala_get_build_version ();
		fprintf (_tmp1_, "Integrity check failed (libvala %s doesn't match valac %s)\n", _tmp2_, VALA_BUILD_VERSION);
		result = 1;
		return result;
	}
	_tmp4_ = args[0];
	_tmp5_ = g_path_get_basename (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strcmp0 (_tmp6_, "vala") == 0;
	_g_free0 (_tmp6_);
	if (_tmp7_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = args[0];
		_tmp9_ = g_path_get_basename (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = g_strcmp0 (_tmp10_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp10_);
	}
	if (_tmp3_) {
		result = vala_compiler_run_source (args, (gint) args_length1);
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp11_;
		GOptionContext* _tmp12_;
		GOptionContext* _tmp13_;
		GOptionContext* _tmp14_;
		_tmp11_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp11_;
		_tmp12_ = opt_context;
		g_option_context_set_help_enabled (_tmp12_, TRUE);
		_tmp13_ = opt_context;
		g_option_context_add_main_entries (_tmp13_, VALA_COMPILER_options, NULL);
		_tmp14_ = opt_context;
		g_option_context_parse (_tmp14_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp15_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp15_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		FILE* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = stdout;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		fprintf (_tmp16_, "%s\n", _tmp18_);
		_tmp19_ = stdout;
		_tmp20_ = args[0];
		fprintf (_tmp19_, "Run '%s --help' to see a full list of available command line options.\n", _tmp20_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp21_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp21_;
	}
	if (vala_compiler_version) {
		FILE* _tmp22_;
		_tmp22_ = stdout;
		fprintf (_tmp22_, "Vala %s\n", VALA_BUILD_VERSION);
		result = 0;
		return result;
	} else {
		if (vala_compiler_api_version) {
			FILE* _tmp23_;
			_tmp23_ = stdout;
			fprintf (_tmp23_, "%s\n", VALA_API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp25_ = vala_compiler_sources;
	_tmp25__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp25_ == NULL) {
		gchar** _tmp26_;
		gint _tmp26__length1;
		_tmp26_ = vala_compiler_fast_vapis;
		_tmp26__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp24_ = _tmp26_ == NULL;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		FILE* _tmp27_;
		_tmp27_ = stderr;
		fprintf (_tmp27_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp28_ = vala_compiler_new ();
	compiler = _tmp28_;
	_tmp29_ = compiler;
	result = vala_compiler_run (_tmp29_);
	_vala_compiler_unref0 (compiler);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return vala_compiler_main (argv, argc);
}

 G_GNUC_INTERNAL ValaCompiler*
vala_compiler_construct (GType object_type)
{
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}

 G_GNUC_INTERNAL ValaCompiler*
vala_compiler_new (void)
{
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}

static void
vala_value_compiler_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_compiler_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_compiler_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_compiler_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_compiler_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_compiler_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	ValaCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}

 G_GNUC_INTERNAL GParamSpec*
vala_param_spec_compiler (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

 G_GNUC_INTERNAL gpointer
vala_value_get_compiler (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}

 G_GNUC_INTERNAL void
vala_value_set_compiler (GValue* value,
                         gpointer v_object)
{
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}

 G_GNUC_INTERNAL void
vala_value_take_compiler (GValue* value,
                          gpointer v_object)
{
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}

static void
vala_compiler_class_init (ValaCompilerClass * klass,
                          gpointer klass_data)
{
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCompilerClass *) klass)->finalize = vala_compiler_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCompiler_private_offset);
}

static void
vala_compiler_instance_init (ValaCompiler * self,
                             gpointer klass)
{
	self->priv = vala_compiler_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_compiler_finalize (ValaCompiler * obj)
{
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}

static GType
vala_compiler_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_compiler_type_id;
	vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaCompiler_private_offset = g_type_add_instance_private (vala_compiler_type_id, sizeof (ValaCompilerPrivate));
	return vala_compiler_type_id;
}

 G_GNUC_INTERNAL GType
vala_compiler_get_type (void)
{
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		GType vala_compiler_type_id;
		vala_compiler_type_id = vala_compiler_get_type_once ();
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}

 G_GNUC_INTERNAL gpointer
vala_compiler_ref (gpointer instance)
{
	ValaCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

 G_GNUC_INTERNAL void
vala_compiler_unref (gpointer instance)
{
	ValaCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

