/* valasemanticanalyzer.c generated by valac, the Vala compiler
 * generated from valasemanticanalyzer.vala, do not modify */

/* valasemanticanalyzer.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaSemanticAnalyzerPrivate {
	ValaCodeContext* context;
	ValaSymbol* _current_symbol;
	ValaSourceFile* _current_source_file;
	ValaDelegate* destroy_notify;
};

static gint ValaSemanticAnalyzer_private_offset;
static gpointer vala_semantic_analyzer_parent_class = NULL;

static void vala_semantic_analyzer_real_visit_source_file (ValaCodeVisitor* base,
                                                    ValaSourceFile* file);
static gboolean vala_semantic_analyzer_check_argument (ValaSemanticAnalyzer* self,
                                                ValaExpression* arg,
                                                gint i,
                                                ValaParameterDirection direction);
static ValaDataType* vala_semantic_analyzer_get_instance_base_type (ValaDataType* instance_type,
                                                             ValaDataType* base_type,
                                                             ValaCodeNode* node_reference);
 G_GNUC_INTERNAL ValaDataType* vala_semantic_analyzer_get_instance_base_type_for_member (ValaDataType* derived_instance_type,
                                                                        ValaTypeSymbol* type_symbol,
                                                                        ValaCodeNode* node_reference);
static ValaStruct* vala_semantic_analyzer_get_arithmetic_struct (ValaSemanticAnalyzer* self,
                                                          ValaDataType* type);
static void vala_semantic_analyzer_check_type_argument (ValaSemanticAnalyzer* self,
                                                 ValaDataType* type_arg);
static void vala_semantic_analyzer_finalize (ValaCodeVisitor * obj);
static GType vala_semantic_analyzer_get_type_once (void);

static inline gpointer
vala_semantic_analyzer_get_instance_private (ValaSemanticAnalyzer* self)
{
	return G_STRUCT_MEMBER_P (self, ValaSemanticAnalyzer_private_offset);
}

ValaSymbol*
vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self)
{
	ValaSymbol* result;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_symbol;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self,
                                           ValaSymbol* value)
{
	ValaSymbol* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_current_symbol);
	self->priv->_current_symbol = _tmp0_;
}

ValaSourceFile*
vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self)
{
	ValaSourceFile* result;
	ValaSourceFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_source_file;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

void
vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self,
                                                ValaSourceFile* value)
{
	ValaSourceFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_source_file_ref0 (value);
	_vala_source_file_unref0 (self->priv->_current_source_file);
	self->priv->_current_source_file = _tmp0_;
}

ValaTypeSymbol*
vala_semantic_analyzer_get_current_type_symbol (ValaSemanticAnalyzer* self)
{
	ValaTypeSymbol* result;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_symbol;
	sym = _tmp0_;
	while (TRUE) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp1_ = sym;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = sym;
		if (VALA_IS_TYPESYMBOL (_tmp2_)) {
			ValaSymbol* _tmp3_;
			_tmp3_ = sym;
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			return result;
		}
		_tmp4_ = sym;
		_tmp5_ = vala_symbol_get_parent_symbol (_tmp4_);
		_tmp6_ = _tmp5_;
		sym = _tmp6_;
	}
	result = NULL;
	return result;
}

ValaClass*
vala_semantic_analyzer_get_current_class (ValaSemanticAnalyzer* self)
{
	ValaClass* result;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_semantic_analyzer_get_current_type_symbol (self);
	_tmp1_ = _tmp0_;
	result = VALA_IS_CLASS (_tmp1_) ? ((ValaClass*) _tmp1_) : NULL;
	return result;
}

ValaStruct*
vala_semantic_analyzer_get_current_struct (ValaSemanticAnalyzer* self)
{
	ValaStruct* result;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_semantic_analyzer_get_current_type_symbol (self);
	_tmp1_ = _tmp0_;
	result = VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL;
	return result;
}

ValaMethod*
vala_semantic_analyzer_get_current_method (ValaSemanticAnalyzer* self)
{
	ValaMethod* result;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_symbol;
	sym = _tmp0_;
	while (TRUE) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp1_ = sym;
		if (!VALA_IS_BLOCK (_tmp1_)) {
			break;
		}
		_tmp2_ = sym;
		_tmp3_ = vala_symbol_get_parent_symbol (_tmp2_);
		_tmp4_ = _tmp3_;
		sym = _tmp4_;
	}
	_tmp5_ = sym;
	result = VALA_IS_METHOD (_tmp5_) ? ((ValaMethod*) _tmp5_) : NULL;
	return result;
}

ValaMethod*
vala_semantic_analyzer_get_current_async_method (ValaSemanticAnalyzer* self)
{
	ValaMethod* result;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_symbol;
	sym = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		ValaSymbol* _tmp2_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp4_;
		gboolean _tmp5_ = FALSE;
		ValaMethod* _tmp6_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp2_ = sym;
		if (VALA_IS_BLOCK (_tmp2_)) {
			_tmp1_ = TRUE;
		} else {
			ValaSymbol* _tmp3_;
			_tmp3_ = sym;
			_tmp1_ = VALA_IS_METHOD (_tmp3_);
		}
		if (!_tmp1_) {
			break;
		}
		_tmp4_ = sym;
		m = VALA_IS_METHOD (_tmp4_) ? ((ValaMethod*) _tmp4_) : NULL;
		_tmp6_ = m;
		if (_tmp6_ != NULL) {
			ValaMethod* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp7_ = m;
			_tmp8_ = vala_method_get_coroutine (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			break;
		}
		_tmp10_ = sym;
		_tmp11_ = vala_symbol_get_parent_symbol (_tmp10_);
		_tmp12_ = _tmp11_;
		sym = _tmp12_;
	}
	_tmp13_ = sym;
	result = VALA_IS_METHOD (_tmp13_) ? ((ValaMethod*) _tmp13_) : NULL;
	return result;
}

ValaPropertyAccessor*
vala_semantic_analyzer_get_current_property_accessor (ValaSemanticAnalyzer* self)
{
	ValaPropertyAccessor* result;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_symbol;
	sym = _tmp0_;
	while (TRUE) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp1_ = sym;
		if (!VALA_IS_BLOCK (_tmp1_)) {
			break;
		}
		_tmp2_ = sym;
		_tmp3_ = vala_symbol_get_parent_symbol (_tmp2_);
		_tmp4_ = _tmp3_;
		sym = _tmp4_;
	}
	_tmp5_ = sym;
	result = VALA_IS_PROPERTY_ACCESSOR (_tmp5_) ? ((ValaPropertyAccessor*) _tmp5_) : NULL;
	return result;
}

ValaSymbol*
vala_semantic_analyzer_get_current_method_or_property_accessor (ValaSemanticAnalyzer* self)
{
	ValaSymbol* result;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_symbol;
	sym = _tmp0_;
	while (TRUE) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp1_ = sym;
		if (!VALA_IS_BLOCK (_tmp1_)) {
			break;
		}
		_tmp2_ = sym;
		_tmp3_ = vala_symbol_get_parent_symbol (_tmp2_);
		_tmp4_ = _tmp3_;
		sym = _tmp4_;
	}
	_tmp5_ = sym;
	if (VALA_IS_METHOD (_tmp5_)) {
		ValaSymbol* _tmp6_;
		_tmp6_ = sym;
		result = _tmp6_;
		return result;
	} else {
		ValaSymbol* _tmp7_;
		_tmp7_ = sym;
		if (VALA_IS_PROPERTY_ACCESSOR (_tmp7_)) {
			ValaSymbol* _tmp8_;
			_tmp8_ = sym;
			result = _tmp8_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}

ValaDataType*
vala_semantic_analyzer_get_current_return_type (ValaSemanticAnalyzer* self)
{
	ValaDataType* result;
	ValaMethod* m = NULL;
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp2_;
	ValaPropertyAccessor* acc = NULL;
	ValaPropertyAccessor* _tmp6_;
	ValaPropertyAccessor* _tmp7_;
	ValaPropertyAccessor* _tmp8_;
	gboolean _tmp16_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_semantic_analyzer_get_current_method (self);
	_tmp1_ = _tmp0_;
	m = _tmp1_;
	_tmp2_ = m;
	if (_tmp2_ != NULL) {
		ValaMethod* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		_tmp3_ = m;
		_tmp4_ = vala_callable_get_return_type ((ValaCallable*) _tmp3_);
		_tmp5_ = _tmp4_;
		result = _tmp5_;
		return result;
	}
	_tmp6_ = vala_semantic_analyzer_get_current_property_accessor (self);
	_tmp7_ = _tmp6_;
	acc = _tmp7_;
	_tmp8_ = acc;
	if (_tmp8_ != NULL) {
		ValaPropertyAccessor* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = acc;
		_tmp10_ = vala_property_accessor_get_readable (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_) {
			ValaPropertyAccessor* _tmp12_;
			ValaDataType* _tmp13_;
			ValaDataType* _tmp14_;
			_tmp12_ = acc;
			_tmp13_ = vala_property_accessor_get_value_type (_tmp12_);
			_tmp14_ = _tmp13_;
			result = _tmp14_;
			return result;
		} else {
			ValaDataType* _tmp15_;
			_tmp15_ = self->void_type;
			result = _tmp15_;
			return result;
		}
	}
	if (vala_semantic_analyzer_is_in_constructor (self)) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = vala_semantic_analyzer_is_in_destructor (self);
	}
	if (_tmp16_) {
		ValaDataType* _tmp17_;
		_tmp17_ = self->void_type;
		result = _tmp17_;
		return result;
	}
	result = NULL;
	return result;
}

ValaSemanticAnalyzer*
vala_semantic_analyzer_construct (GType object_type)
{
	ValaSemanticAnalyzer* self = NULL;
	self = (ValaSemanticAnalyzer*) vala_code_visitor_construct (object_type);
	return self;
}

ValaSemanticAnalyzer*
vala_semantic_analyzer_new (void)
{
	return vala_semantic_analyzer_construct (VALA_TYPE_SEMANTIC_ANALYZER);
}

/**
 * Analyze and check code in the specified context.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}

void
vala_semantic_analyzer_analyze (ValaSemanticAnalyzer* self,
                                ValaCodeContext* context)
{
	ValaCodeContext* _tmp0_;
	ValaNamespace* root_symbol = NULL;
	ValaNamespace* _tmp1_;
	ValaNamespace* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaStruct* _tmp8_;
	ValaBooleanType* _tmp9_;
	ValaNamespace* _tmp10_;
	ValaScope* _tmp11_;
	ValaScope* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaStruct* _tmp14_;
	ValaIntegerType* _tmp15_;
	ValaNamespace* _tmp16_;
	ValaScope* _tmp17_;
	ValaScope* _tmp18_;
	ValaSymbol* _tmp19_;
	ValaStruct* _tmp20_;
	ValaIntegerType* _tmp21_;
	ValaNamespace* _tmp22_;
	ValaScope* _tmp23_;
	ValaScope* _tmp24_;
	ValaSymbol* _tmp25_;
	ValaStruct* _tmp26_;
	ValaIntegerType* _tmp27_;
	ValaNamespace* _tmp28_;
	ValaScope* _tmp29_;
	ValaScope* _tmp30_;
	ValaSymbol* _tmp31_;
	ValaStruct* _tmp32_;
	ValaIntegerType* _tmp33_;
	ValaNamespace* _tmp34_;
	ValaScope* _tmp35_;
	ValaScope* _tmp36_;
	ValaSymbol* _tmp37_;
	ValaStruct* _tmp38_;
	ValaIntegerType* _tmp39_;
	ValaNamespace* _tmp40_;
	ValaScope* _tmp41_;
	ValaScope* _tmp42_;
	ValaSymbol* _tmp43_;
	ValaStruct* _tmp44_;
	ValaIntegerType* _tmp45_;
	ValaNamespace* _tmp46_;
	ValaScope* _tmp47_;
	ValaScope* _tmp48_;
	ValaSymbol* _tmp49_;
	ValaStruct* _tmp50_;
	ValaIntegerType* _tmp51_;
	ValaNamespace* _tmp52_;
	ValaScope* _tmp53_;
	ValaScope* _tmp54_;
	ValaSymbol* _tmp55_;
	ValaStruct* _tmp56_;
	ValaIntegerType* _tmp57_;
	ValaNamespace* _tmp58_;
	ValaScope* _tmp59_;
	ValaScope* _tmp60_;
	ValaSymbol* _tmp61_;
	ValaStruct* _tmp62_;
	ValaIntegerType* _tmp63_;
	ValaNamespace* _tmp64_;
	ValaScope* _tmp65_;
	ValaScope* _tmp66_;
	ValaSymbol* _tmp67_;
	ValaStruct* _tmp68_;
	ValaIntegerType* _tmp69_;
	ValaNamespace* _tmp70_;
	ValaScope* _tmp71_;
	ValaScope* _tmp72_;
	ValaSymbol* _tmp73_;
	ValaStruct* _tmp74_;
	ValaIntegerType* _tmp75_;
	ValaNamespace* _tmp76_;
	ValaScope* _tmp77_;
	ValaScope* _tmp78_;
	ValaSymbol* _tmp79_;
	ValaStruct* _tmp80_;
	ValaIntegerType* _tmp81_;
	ValaNamespace* _tmp82_;
	ValaScope* _tmp83_;
	ValaScope* _tmp84_;
	ValaSymbol* _tmp85_;
	ValaStruct* _tmp86_;
	ValaIntegerType* _tmp87_;
	ValaNamespace* _tmp88_;
	ValaScope* _tmp89_;
	ValaScope* _tmp90_;
	ValaSymbol* _tmp91_;
	ValaStruct* _tmp92_;
	ValaIntegerType* _tmp93_;
	ValaNamespace* _tmp94_;
	ValaScope* _tmp95_;
	ValaScope* _tmp96_;
	ValaSymbol* _tmp97_;
	ValaStruct* _tmp98_;
	ValaIntegerType* _tmp99_;
	ValaNamespace* _tmp100_;
	ValaScope* _tmp101_;
	ValaScope* _tmp102_;
	ValaSymbol* _tmp103_;
	ValaStruct* _tmp104_;
	ValaIntegerType* _tmp105_;
	ValaNamespace* _tmp106_;
	ValaScope* _tmp107_;
	ValaScope* _tmp108_;
	ValaSymbol* _tmp109_;
	ValaStruct* _tmp110_;
	ValaFloatingType* _tmp111_;
	ValaNamespace* _tmp112_;
	ValaScope* _tmp113_;
	ValaScope* _tmp114_;
	ValaSymbol* _tmp115_;
	ValaClass* _tmp116_;
	ValaObjectType* _tmp117_;
	ValaNamespace* _tmp118_;
	ValaScope* _tmp119_;
	ValaScope* _tmp120_;
	ValaSymbol* _tmp121_;
	ValaStruct* _tmp122_;
	ValaStructValueType* _tmp123_;
	ValaStruct* unichar_struct = NULL;
	ValaNamespace* _tmp124_;
	ValaScope* _tmp125_;
	ValaScope* _tmp126_;
	ValaSymbol* _tmp127_;
	ValaStruct* _tmp128_;
	ValaProfile _tmp131_;
	ValaProfile _tmp132_;
	ValaNamespace* _tmp240_;
	ValaNamespace* _tmp241_;
	ValaNamespace* _tmp242_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = vala_code_context_get_root (context);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (_tmp2_);
	root_symbol = _tmp3_;
	_tmp4_ = root_symbol;
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_scope_lookup (_tmp6_, "bool");
	_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp9_ = vala_boolean_type_new (_tmp8_);
	_vala_code_node_unref0 (self->bool_type);
	self->bool_type = (ValaDataType*) _tmp9_;
	_vala_code_node_unref0 (_tmp8_);
	_tmp10_ = root_symbol;
	_tmp11_ = vala_symbol_get_scope ((ValaSymbol*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_scope_lookup (_tmp12_, "char");
	_tmp14_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp15_ = vala_integer_type_new (_tmp14_, NULL, NULL);
	_vala_code_node_unref0 (self->char_type);
	self->char_type = (ValaDataType*) _tmp15_;
	_vala_code_node_unref0 (_tmp14_);
	_tmp16_ = root_symbol;
	_tmp17_ = vala_symbol_get_scope ((ValaSymbol*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_scope_lookup (_tmp18_, "uchar");
	_tmp20_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp21_ = vala_integer_type_new (_tmp20_, NULL, NULL);
	_vala_code_node_unref0 (self->uchar_type);
	self->uchar_type = (ValaDataType*) _tmp21_;
	_vala_code_node_unref0 (_tmp20_);
	_tmp22_ = root_symbol;
	_tmp23_ = vala_symbol_get_scope ((ValaSymbol*) _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_scope_lookup (_tmp24_, "short");
	_tmp26_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp27_ = vala_integer_type_new (_tmp26_, NULL, NULL);
	_vala_code_node_unref0 (self->short_type);
	self->short_type = (ValaDataType*) _tmp27_;
	_vala_code_node_unref0 (_tmp26_);
	_tmp28_ = root_symbol;
	_tmp29_ = vala_symbol_get_scope ((ValaSymbol*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_scope_lookup (_tmp30_, "ushort");
	_tmp32_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp33_ = vala_integer_type_new (_tmp32_, NULL, NULL);
	_vala_code_node_unref0 (self->ushort_type);
	self->ushort_type = (ValaDataType*) _tmp33_;
	_vala_code_node_unref0 (_tmp32_);
	_tmp34_ = root_symbol;
	_tmp35_ = vala_symbol_get_scope ((ValaSymbol*) _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = vala_scope_lookup (_tmp36_, "int");
	_tmp38_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp39_ = vala_integer_type_new (_tmp38_, NULL, NULL);
	_vala_code_node_unref0 (self->int_type);
	self->int_type = (ValaDataType*) _tmp39_;
	_vala_code_node_unref0 (_tmp38_);
	_tmp40_ = root_symbol;
	_tmp41_ = vala_symbol_get_scope ((ValaSymbol*) _tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_scope_lookup (_tmp42_, "uint");
	_tmp44_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp45_ = vala_integer_type_new (_tmp44_, NULL, NULL);
	_vala_code_node_unref0 (self->uint_type);
	self->uint_type = (ValaDataType*) _tmp45_;
	_vala_code_node_unref0 (_tmp44_);
	_tmp46_ = root_symbol;
	_tmp47_ = vala_symbol_get_scope ((ValaSymbol*) _tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_scope_lookup (_tmp48_, "long");
	_tmp50_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp51_ = vala_integer_type_new (_tmp50_, NULL, NULL);
	_vala_code_node_unref0 (self->long_type);
	self->long_type = (ValaDataType*) _tmp51_;
	_vala_code_node_unref0 (_tmp50_);
	_tmp52_ = root_symbol;
	_tmp53_ = vala_symbol_get_scope ((ValaSymbol*) _tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_scope_lookup (_tmp54_, "ulong");
	_tmp56_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp57_ = vala_integer_type_new (_tmp56_, NULL, NULL);
	_vala_code_node_unref0 (self->ulong_type);
	self->ulong_type = (ValaDataType*) _tmp57_;
	_vala_code_node_unref0 (_tmp56_);
	_tmp58_ = root_symbol;
	_tmp59_ = vala_symbol_get_scope ((ValaSymbol*) _tmp58_);
	_tmp60_ = _tmp59_;
	_tmp61_ = vala_scope_lookup (_tmp60_, "int8");
	_tmp62_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp63_ = vala_integer_type_new (_tmp62_, NULL, NULL);
	_vala_code_node_unref0 (self->int8_type);
	self->int8_type = (ValaDataType*) _tmp63_;
	_vala_code_node_unref0 (_tmp62_);
	_tmp64_ = root_symbol;
	_tmp65_ = vala_symbol_get_scope ((ValaSymbol*) _tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = vala_scope_lookup (_tmp66_, "uint8");
	_tmp68_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp69_ = vala_integer_type_new (_tmp68_, NULL, NULL);
	_vala_code_node_unref0 (self->uint8_type);
	self->uint8_type = (ValaDataType*) _tmp69_;
	_vala_code_node_unref0 (_tmp68_);
	_tmp70_ = root_symbol;
	_tmp71_ = vala_symbol_get_scope ((ValaSymbol*) _tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = vala_scope_lookup (_tmp72_, "int16");
	_tmp74_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp75_ = vala_integer_type_new (_tmp74_, NULL, NULL);
	_vala_code_node_unref0 (self->int16_type);
	self->int16_type = (ValaDataType*) _tmp75_;
	_vala_code_node_unref0 (_tmp74_);
	_tmp76_ = root_symbol;
	_tmp77_ = vala_symbol_get_scope ((ValaSymbol*) _tmp76_);
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_scope_lookup (_tmp78_, "uint16");
	_tmp80_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp81_ = vala_integer_type_new (_tmp80_, NULL, NULL);
	_vala_code_node_unref0 (self->uint16_type);
	self->uint16_type = (ValaDataType*) _tmp81_;
	_vala_code_node_unref0 (_tmp80_);
	_tmp82_ = root_symbol;
	_tmp83_ = vala_symbol_get_scope ((ValaSymbol*) _tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = vala_scope_lookup (_tmp84_, "int32");
	_tmp86_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp87_ = vala_integer_type_new (_tmp86_, NULL, NULL);
	_vala_code_node_unref0 (self->int32_type);
	self->int32_type = (ValaDataType*) _tmp87_;
	_vala_code_node_unref0 (_tmp86_);
	_tmp88_ = root_symbol;
	_tmp89_ = vala_symbol_get_scope ((ValaSymbol*) _tmp88_);
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_scope_lookup (_tmp90_, "uint32");
	_tmp92_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp93_ = vala_integer_type_new (_tmp92_, NULL, NULL);
	_vala_code_node_unref0 (self->uint32_type);
	self->uint32_type = (ValaDataType*) _tmp93_;
	_vala_code_node_unref0 (_tmp92_);
	_tmp94_ = root_symbol;
	_tmp95_ = vala_symbol_get_scope ((ValaSymbol*) _tmp94_);
	_tmp96_ = _tmp95_;
	_tmp97_ = vala_scope_lookup (_tmp96_, "size_t");
	_tmp98_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp99_ = vala_integer_type_new (_tmp98_, NULL, NULL);
	_vala_code_node_unref0 (self->size_t_type);
	self->size_t_type = (ValaDataType*) _tmp99_;
	_vala_code_node_unref0 (_tmp98_);
	_tmp100_ = root_symbol;
	_tmp101_ = vala_symbol_get_scope ((ValaSymbol*) _tmp100_);
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_scope_lookup (_tmp102_, "ssize_t");
	_tmp104_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp105_ = vala_integer_type_new (_tmp104_, NULL, NULL);
	_vala_code_node_unref0 (self->ssize_t_type);
	self->ssize_t_type = (ValaDataType*) _tmp105_;
	_vala_code_node_unref0 (_tmp104_);
	_tmp106_ = root_symbol;
	_tmp107_ = vala_symbol_get_scope ((ValaSymbol*) _tmp106_);
	_tmp108_ = _tmp107_;
	_tmp109_ = vala_scope_lookup (_tmp108_, "double");
	_tmp110_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp111_ = vala_floating_type_new (_tmp110_);
	_vala_code_node_unref0 (self->double_type);
	self->double_type = (ValaDataType*) _tmp111_;
	_vala_code_node_unref0 (_tmp110_);
	_tmp112_ = root_symbol;
	_tmp113_ = vala_symbol_get_scope ((ValaSymbol*) _tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = vala_scope_lookup (_tmp114_, "string");
	_tmp116_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, VALA_TYPE_CLASS, ValaClass);
	_tmp117_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp116_);
	_vala_code_node_unref0 (self->string_type);
	self->string_type = (ValaDataType*) _tmp117_;
	_vala_code_node_unref0 (_tmp116_);
	_tmp118_ = root_symbol;
	_tmp119_ = vala_symbol_get_scope ((ValaSymbol*) _tmp118_);
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_scope_lookup (_tmp120_, "va_list");
	_tmp122_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp123_ = vala_struct_value_type_new (_tmp122_);
	_vala_code_node_unref0 (self->va_list_type);
	self->va_list_type = (ValaDataType*) _tmp123_;
	_vala_code_node_unref0 (_tmp122_);
	_tmp124_ = root_symbol;
	_tmp125_ = vala_symbol_get_scope ((ValaSymbol*) _tmp124_);
	_tmp126_ = _tmp125_;
	_tmp127_ = vala_scope_lookup (_tmp126_, "unichar");
	unichar_struct = G_TYPE_CHECK_INSTANCE_CAST (_tmp127_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp128_ = unichar_struct;
	if (_tmp128_ != NULL) {
		ValaStruct* _tmp129_;
		ValaIntegerType* _tmp130_;
		_tmp129_ = unichar_struct;
		_tmp130_ = vala_integer_type_new (_tmp129_, NULL, NULL);
		_vala_code_node_unref0 (self->unichar_type);
		self->unichar_type = (ValaDataType*) _tmp130_;
	}
	_tmp131_ = vala_code_context_get_profile (context);
	_tmp132_ = _tmp131_;
	if (_tmp132_ == VALA_PROFILE_GOBJECT) {
		ValaSymbol* glib_ns = NULL;
		ValaNamespace* _tmp133_;
		ValaScope* _tmp134_;
		ValaScope* _tmp135_;
		ValaSymbol* _tmp136_;
		ValaSymbol* _tmp137_;
		ValaScope* _tmp138_;
		ValaScope* _tmp139_;
		ValaSymbol* _tmp140_;
		ValaSymbol* _tmp141_;
		ValaScope* _tmp142_;
		ValaScope* _tmp143_;
		ValaSymbol* _tmp144_;
		ValaStruct* _tmp145_;
		ValaIntegerType* _tmp146_;
		ValaSymbol* _tmp147_;
		ValaScope* _tmp148_;
		ValaScope* _tmp149_;
		ValaSymbol* _tmp150_;
		ValaStruct* _tmp151_;
		ValaStructValueType* _tmp152_;
		ValaSymbol* _tmp153_;
		ValaScope* _tmp154_;
		ValaScope* _tmp155_;
		ValaSymbol* _tmp156_;
		ValaClass* _tmp157_;
		ValaObjectType* _tmp158_;
		ValaSymbol* _tmp159_;
		ValaScope* _tmp160_;
		ValaScope* _tmp161_;
		ValaSymbol* _tmp162_;
		ValaClass* _tmp163_;
		ValaObjectType* _tmp164_;
		ValaSymbol* _tmp165_;
		ValaScope* _tmp166_;
		ValaScope* _tmp167_;
		ValaSymbol* _tmp168_;
		ValaClass* _tmp169_;
		ValaObjectType* _tmp170_;
		ValaSymbol* _tmp171_;
		ValaScope* _tmp172_;
		ValaScope* _tmp173_;
		ValaSymbol* _tmp174_;
		ValaClass* _tmp175_;
		ValaObjectType* _tmp176_;
		ValaSymbol* _tmp177_;
		ValaScope* _tmp178_;
		ValaScope* _tmp179_;
		ValaSymbol* _tmp180_;
		ValaClass* _tmp181_;
		ValaObjectType* _tmp182_;
		ValaSymbol* _tmp183_;
		ValaScope* _tmp184_;
		ValaScope* _tmp185_;
		ValaSymbol* _tmp186_;
		ValaNamespace* _tmp187_;
		ValaScope* _tmp188_;
		ValaScope* _tmp189_;
		ValaSymbol* _tmp190_;
		ValaSymbol* _tmp191_;
		ValaScope* _tmp192_;
		ValaScope* _tmp193_;
		ValaSymbol* _tmp194_;
		ValaClass* _tmp195_;
		ValaObjectType* _tmp196_;
		ValaSymbol* _tmp197_;
		ValaScope* _tmp198_;
		ValaScope* _tmp199_;
		ValaSymbol* _tmp200_;
		ValaSymbol* _tmp201_;
		ValaScope* _tmp202_;
		ValaScope* _tmp203_;
		ValaSymbol* _tmp204_;
		ValaStruct* _tmp205_;
		ValaStructValueType* _tmp206_;
		ValaSymbol* _tmp207_;
		ValaScope* _tmp208_;
		ValaScope* _tmp209_;
		ValaSymbol* _tmp210_;
		ValaDelegate* _tmp211_;
		ValaDelegateType* _tmp212_;
		ValaSymbol* _tmp213_;
		ValaScope* _tmp214_;
		ValaScope* _tmp215_;
		ValaSymbol* _tmp216_;
		ValaDelegate* _tmp217_;
		ValaDelegateType* _tmp218_;
		_tmp133_ = root_symbol;
		_tmp134_ = vala_symbol_get_scope ((ValaSymbol*) _tmp133_);
		_tmp135_ = _tmp134_;
		_tmp136_ = vala_scope_lookup (_tmp135_, "GLib");
		glib_ns = _tmp136_;
		_tmp137_ = glib_ns;
		_tmp138_ = vala_symbol_get_scope (_tmp137_);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_scope_lookup (_tmp139_, "Object");
		_vala_code_node_unref0 (self->object_type);
		self->object_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp140_, VALA_TYPE_CLASS, ValaClass);
		_tmp141_ = glib_ns;
		_tmp142_ = vala_symbol_get_scope (_tmp141_);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_scope_lookup (_tmp143_, "Type");
		_tmp145_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp144_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp146_ = vala_integer_type_new (_tmp145_, NULL, NULL);
		_vala_code_node_unref0 (self->type_type);
		self->type_type = (ValaDataType*) _tmp146_;
		_vala_code_node_unref0 (_tmp145_);
		_tmp147_ = glib_ns;
		_tmp148_ = vala_symbol_get_scope (_tmp147_);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_scope_lookup (_tmp149_, "Value");
		_tmp151_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp150_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp152_ = vala_struct_value_type_new (_tmp151_);
		_vala_code_node_unref0 (self->gvalue_type);
		self->gvalue_type = _tmp152_;
		_vala_code_node_unref0 (_tmp151_);
		_tmp153_ = glib_ns;
		_tmp154_ = vala_symbol_get_scope (_tmp153_);
		_tmp155_ = _tmp154_;
		_tmp156_ = vala_scope_lookup (_tmp155_, "Variant");
		_tmp157_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp156_, VALA_TYPE_CLASS, ValaClass);
		_tmp158_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp157_);
		_vala_code_node_unref0 (self->gvariant_type);
		self->gvariant_type = _tmp158_;
		_vala_code_node_unref0 (_tmp157_);
		_tmp159_ = glib_ns;
		_tmp160_ = vala_symbol_get_scope (_tmp159_);
		_tmp161_ = _tmp160_;
		_tmp162_ = vala_scope_lookup (_tmp161_, "List");
		_tmp163_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_CLASS, ValaClass);
		_tmp164_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp163_);
		_vala_code_node_unref0 (self->glist_type);
		self->glist_type = (ValaDataType*) _tmp164_;
		_vala_code_node_unref0 (_tmp163_);
		_tmp165_ = glib_ns;
		_tmp166_ = vala_symbol_get_scope (_tmp165_);
		_tmp167_ = _tmp166_;
		_tmp168_ = vala_scope_lookup (_tmp167_, "SList");
		_tmp169_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp168_, VALA_TYPE_CLASS, ValaClass);
		_tmp170_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp169_);
		_vala_code_node_unref0 (self->gslist_type);
		self->gslist_type = (ValaDataType*) _tmp170_;
		_vala_code_node_unref0 (_tmp169_);
		_tmp171_ = glib_ns;
		_tmp172_ = vala_symbol_get_scope (_tmp171_);
		_tmp173_ = _tmp172_;
		_tmp174_ = vala_scope_lookup (_tmp173_, "Array");
		_tmp175_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp174_, VALA_TYPE_CLASS, ValaClass);
		_tmp176_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp175_);
		_vala_code_node_unref0 (self->garray_type);
		self->garray_type = (ValaDataType*) _tmp176_;
		_vala_code_node_unref0 (_tmp175_);
		_tmp177_ = glib_ns;
		_tmp178_ = vala_symbol_get_scope (_tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_scope_lookup (_tmp179_, "ValueArray");
		_tmp181_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp180_, VALA_TYPE_CLASS, ValaClass);
		_tmp182_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp181_);
		_vala_code_node_unref0 (self->gvaluearray_type);
		self->gvaluearray_type = (ValaDataType*) _tmp182_;
		_vala_code_node_unref0 (_tmp181_);
		_tmp183_ = glib_ns;
		_tmp184_ = vala_symbol_get_scope (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_scope_lookup (_tmp185_, "Error");
		_vala_code_node_unref0 (self->gerror_type);
		self->gerror_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp186_, VALA_TYPE_CLASS, ValaClass);
		_tmp187_ = root_symbol;
		_tmp188_ = vala_symbol_get_scope ((ValaSymbol*) _tmp187_);
		_tmp189_ = _tmp188_;
		_tmp190_ = vala_scope_lookup (_tmp189_, "GLib");
		_tmp191_ = _tmp190_;
		_tmp192_ = vala_symbol_get_scope (_tmp191_);
		_tmp193_ = _tmp192_;
		_tmp194_ = vala_scope_lookup (_tmp193_, "Regex");
		_tmp195_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp194_, VALA_TYPE_CLASS, ValaClass);
		_tmp196_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp195_);
		_vala_code_node_unref0 (self->regex_type);
		self->regex_type = (ValaDataType*) _tmp196_;
		_vala_code_node_unref0 (_tmp195_);
		_vala_code_node_unref0 (_tmp191_);
		_tmp197_ = glib_ns;
		_tmp198_ = vala_symbol_get_scope (_tmp197_);
		_tmp199_ = _tmp198_;
		_tmp200_ = vala_scope_lookup (_tmp199_, "Source");
		_vala_code_node_unref0 (self->gsource_type);
		self->gsource_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp200_, VALA_TYPE_CLASS, ValaClass);
		_tmp201_ = glib_ns;
		_tmp202_ = vala_symbol_get_scope (_tmp201_);
		_tmp203_ = _tmp202_;
		_tmp204_ = vala_scope_lookup (_tmp203_, "pointer");
		_tmp205_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp206_ = vala_struct_value_type_new (_tmp205_);
		_vala_code_node_unref0 (self->delegate_target_type);
		self->delegate_target_type = (ValaDataType*) _tmp206_;
		_vala_code_node_unref0 (_tmp205_);
		_tmp207_ = glib_ns;
		_tmp208_ = vala_symbol_get_scope (_tmp207_);
		_tmp209_ = _tmp208_;
		_tmp210_ = vala_scope_lookup (_tmp209_, "DestroyNotify");
		_vala_code_node_unref0 (self->priv->destroy_notify);
		self->priv->destroy_notify = G_TYPE_CHECK_INSTANCE_CAST (_tmp210_, VALA_TYPE_DELEGATE, ValaDelegate);
		_tmp211_ = self->priv->destroy_notify;
		_tmp212_ = vala_delegate_type_new (_tmp211_);
		_vala_code_node_unref0 (self->delegate_target_destroy_type);
		self->delegate_target_destroy_type = _tmp212_;
		_tmp213_ = glib_ns;
		_tmp214_ = vala_symbol_get_scope (_tmp213_);
		_tmp215_ = _tmp214_;
		_tmp216_ = vala_scope_lookup (_tmp215_, "BoxedCopyFunc");
		_tmp217_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp216_, VALA_TYPE_DELEGATE, ValaDelegate);
		_tmp218_ = vala_delegate_type_new (_tmp217_);
		_vala_code_node_unref0 (self->generics_dup_func_type);
		self->generics_dup_func_type = _tmp218_;
		_vala_code_node_unref0 (_tmp217_);
		_vala_code_node_unref0 (glib_ns);
	} else {
		ValaVoidType* _tmp219_;
		ValaVoidType* _tmp220_;
		ValaPointerType* _tmp221_;
		ValaVoidType* _tmp222_;
		ValaVoidType* _tmp223_;
		ValaDelegate* _tmp224_;
		ValaDelegate* _tmp225_;
		ValaVoidType* _tmp226_;
		ValaVoidType* _tmp227_;
		ValaPointerType* _tmp228_;
		ValaPointerType* _tmp229_;
		ValaParameter* _tmp230_;
		ValaParameter* _tmp231_;
		ValaDelegate* _tmp232_;
		ValaDelegate* _tmp233_;
		ValaNamespace* _tmp234_;
		ValaNamespace* _tmp235_;
		ValaScope* _tmp236_;
		ValaScope* _tmp237_;
		ValaDelegate* _tmp238_;
		ValaDelegateType* _tmp239_;
		_tmp219_ = vala_void_type_new (NULL);
		_tmp220_ = _tmp219_;
		_tmp221_ = vala_pointer_type_new ((ValaDataType*) _tmp220_, NULL);
		_vala_code_node_unref0 (self->delegate_target_type);
		self->delegate_target_type = (ValaDataType*) _tmp221_;
		_vala_code_node_unref0 (_tmp220_);
		_tmp222_ = vala_void_type_new (NULL);
		_tmp223_ = _tmp222_;
		_tmp224_ = vala_delegate_new ("ValaDestroyNotify", (ValaDataType*) _tmp223_, NULL, NULL);
		_vala_code_node_unref0 (self->priv->destroy_notify);
		self->priv->destroy_notify = _tmp224_;
		_vala_code_node_unref0 (_tmp223_);
		_tmp225_ = self->priv->destroy_notify;
		_tmp226_ = vala_void_type_new (NULL);
		_tmp227_ = _tmp226_;
		_tmp228_ = vala_pointer_type_new ((ValaDataType*) _tmp227_, NULL);
		_tmp229_ = _tmp228_;
		_tmp230_ = vala_parameter_new ("data", (ValaDataType*) _tmp229_, NULL);
		_tmp231_ = _tmp230_;
		vala_callable_add_parameter ((ValaCallable*) _tmp225_, _tmp231_);
		_vala_code_node_unref0 (_tmp231_);
		_vala_code_node_unref0 (_tmp229_);
		_vala_code_node_unref0 (_tmp227_);
		_tmp232_ = self->priv->destroy_notify;
		vala_delegate_set_has_target (_tmp232_, FALSE);
		_tmp233_ = self->priv->destroy_notify;
		_tmp234_ = vala_code_context_get_root (context);
		_tmp235_ = _tmp234_;
		_tmp236_ = vala_symbol_get_scope ((ValaSymbol*) _tmp235_);
		_tmp237_ = _tmp236_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp233_, _tmp237_);
		_tmp238_ = self->priv->destroy_notify;
		_tmp239_ = vala_delegate_type_new (_tmp238_);
		_vala_code_node_unref0 (self->delegate_target_destroy_type);
		self->delegate_target_destroy_type = _tmp239_;
	}
	_tmp240_ = root_symbol;
	vala_semantic_analyzer_set_current_symbol (self, (ValaSymbol*) _tmp240_);
	_tmp241_ = vala_code_context_get_root (context);
	_tmp242_ = _tmp241_;
	vala_code_node_check ((ValaCodeNode*) _tmp242_, context);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = NULL;
	_vala_code_node_unref0 (unichar_struct);
	_vala_code_node_unref0 (root_symbol);
}

static void
vala_semantic_analyzer_real_visit_source_file (ValaCodeVisitor* base,
                                               ValaSourceFile* file)
{
	ValaSemanticAnalyzer * self;
	ValaCodeContext* _tmp0_;
	self = (ValaSemanticAnalyzer*) base;
	g_return_if_fail (file != NULL);
	vala_semantic_analyzer_set_current_source_file (self, file);
	_tmp0_ = self->priv->context;
	vala_source_file_check (file, _tmp0_);
}

gboolean
vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self,
                                           ValaSymbol* sym,
                                           ValaDataType* type)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	result = vala_data_type_is_accessible (type, sym);
	return result;
}

ValaDataType*
vala_semantic_analyzer_get_value_type_for_symbol (ValaSemanticAnalyzer* self,
                                                  ValaSymbol* sym,
                                                  gboolean lvalue)
{
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	if (VALA_IS_FIELD (sym)) {
		ValaField* f = NULL;
		ValaDataType* type = NULL;
		ValaField* _tmp0_;
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		f = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField);
		_tmp0_ = f;
		_tmp1_ = vala_variable_get_variable_type ((ValaVariable*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_data_type_copy (_tmp2_);
		type = _tmp3_;
		if (!lvalue) {
			ValaDataType* _tmp4_;
			_tmp4_ = type;
			vala_data_type_set_value_owned (_tmp4_, FALSE);
		}
		result = type;
		return result;
	} else {
		if (VALA_IS_ENUM_VALUE (sym)) {
			ValaSymbol* _tmp5_;
			ValaSymbol* _tmp6_;
			ValaEnumValueType* _tmp7_;
			_tmp5_ = vala_symbol_get_parent_symbol (sym);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_enum_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_ENUM, ValaEnum));
			result = (ValaDataType*) _tmp7_;
			return result;
		} else {
			if (VALA_IS_CONSTANT (sym)) {
				ValaConstant* c = NULL;
				ValaConstant* _tmp8_;
				ValaDataType* _tmp9_;
				ValaDataType* _tmp10_;
				ValaDataType* _tmp11_;
				c = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant);
				_tmp8_ = c;
				_tmp9_ = vala_constant_get_type_reference (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = vala_data_type_copy (_tmp10_);
				result = _tmp11_;
				return result;
			} else {
				if (VALA_IS_PROPERTY (sym)) {
					ValaProperty* prop = NULL;
					prop = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty);
					if (lvalue) {
						gboolean _tmp12_ = FALSE;
						ValaProperty* _tmp13_;
						ValaPropertyAccessor* _tmp14_;
						ValaPropertyAccessor* _tmp15_;
						_tmp13_ = prop;
						_tmp14_ = vala_property_get_set_accessor (_tmp13_);
						_tmp15_ = _tmp14_;
						if (_tmp15_ != NULL) {
							ValaProperty* _tmp16_;
							ValaPropertyAccessor* _tmp17_;
							ValaPropertyAccessor* _tmp18_;
							ValaDataType* _tmp19_;
							ValaDataType* _tmp20_;
							_tmp16_ = prop;
							_tmp17_ = vala_property_get_set_accessor (_tmp16_);
							_tmp18_ = _tmp17_;
							_tmp19_ = vala_property_accessor_get_value_type (_tmp18_);
							_tmp20_ = _tmp19_;
							_tmp12_ = _tmp20_ != NULL;
						} else {
							_tmp12_ = FALSE;
						}
						if (_tmp12_) {
							ValaProperty* _tmp21_;
							ValaPropertyAccessor* _tmp22_;
							ValaPropertyAccessor* _tmp23_;
							ValaDataType* _tmp24_;
							ValaDataType* _tmp25_;
							ValaDataType* _tmp26_;
							_tmp21_ = prop;
							_tmp22_ = vala_property_get_set_accessor (_tmp21_);
							_tmp23_ = _tmp22_;
							_tmp24_ = vala_property_accessor_get_value_type (_tmp23_);
							_tmp25_ = _tmp24_;
							_tmp26_ = vala_data_type_copy (_tmp25_);
							result = _tmp26_;
							return result;
						}
					} else {
						gboolean _tmp27_ = FALSE;
						ValaProperty* _tmp28_;
						ValaPropertyAccessor* _tmp29_;
						ValaPropertyAccessor* _tmp30_;
						_tmp28_ = prop;
						_tmp29_ = vala_property_get_get_accessor (_tmp28_);
						_tmp30_ = _tmp29_;
						if (_tmp30_ != NULL) {
							ValaProperty* _tmp31_;
							ValaPropertyAccessor* _tmp32_;
							ValaPropertyAccessor* _tmp33_;
							ValaDataType* _tmp34_;
							ValaDataType* _tmp35_;
							_tmp31_ = prop;
							_tmp32_ = vala_property_get_get_accessor (_tmp31_);
							_tmp33_ = _tmp32_;
							_tmp34_ = vala_property_accessor_get_value_type (_tmp33_);
							_tmp35_ = _tmp34_;
							_tmp27_ = _tmp35_ != NULL;
						} else {
							_tmp27_ = FALSE;
						}
						if (_tmp27_) {
							ValaProperty* _tmp36_;
							ValaPropertyAccessor* _tmp37_;
							ValaPropertyAccessor* _tmp38_;
							ValaDataType* _tmp39_;
							ValaDataType* _tmp40_;
							ValaDataType* _tmp41_;
							_tmp36_ = prop;
							_tmp37_ = vala_property_get_get_accessor (_tmp36_);
							_tmp38_ = _tmp37_;
							_tmp39_ = vala_property_accessor_get_value_type (_tmp38_);
							_tmp40_ = _tmp39_;
							_tmp41_ = vala_data_type_copy (_tmp40_);
							result = _tmp41_;
							return result;
						}
					}
				} else {
					if (VALA_IS_PARAMETER (sym)) {
						ValaParameter* p = NULL;
						ValaDataType* type = NULL;
						ValaParameter* _tmp42_;
						ValaDataType* _tmp43_;
						ValaDataType* _tmp44_;
						ValaDataType* _tmp45_;
						p = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PARAMETER, ValaParameter);
						_tmp42_ = p;
						_tmp43_ = vala_variable_get_variable_type ((ValaVariable*) _tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = vala_data_type_copy (_tmp44_);
						type = _tmp45_;
						if (!lvalue) {
							ValaDataType* _tmp46_;
							_tmp46_ = type;
							vala_data_type_set_value_owned (_tmp46_, FALSE);
						}
						result = type;
						return result;
					} else {
						if (VALA_IS_LOCAL_VARIABLE (sym)) {
							ValaLocalVariable* local = NULL;
							ValaDataType* type = NULL;
							ValaLocalVariable* _tmp47_;
							ValaDataType* _tmp48_;
							ValaDataType* _tmp49_;
							ValaDataType* _tmp50_;
							local = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
							_tmp47_ = local;
							_tmp48_ = vala_variable_get_variable_type ((ValaVariable*) _tmp47_);
							_tmp49_ = _tmp48_;
							_tmp50_ = vala_data_type_copy (_tmp49_);
							type = _tmp50_;
							if (!lvalue) {
								ValaDataType* _tmp51_;
								_tmp51_ = type;
								vala_data_type_set_value_owned (_tmp51_, FALSE);
							}
							result = type;
							return result;
						} else {
							if (VALA_IS_METHOD (sym)) {
								ValaMethodType* _tmp52_;
								_tmp52_ = vala_method_type_new (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								result = (ValaDataType*) _tmp52_;
								return result;
							} else {
								if (VALA_IS_SIGNAL (sym)) {
									ValaSignalType* _tmp53_;
									_tmp53_ = vala_signal_type_new (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
									result = (ValaDataType*) _tmp53_;
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

ValaSymbol*
vala_semantic_analyzer_symbol_lookup_inherited (ValaSymbol* sym,
                                                const gchar* name)
{
	ValaSymbol* _result_ = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* result = NULL;
	g_return_val_if_fail (sym != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = vala_symbol_get_scope (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_scope_lookup (_tmp1_, name);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		result = _result_;
		return result;
	}
	if (VALA_IS_CLASS (sym)) {
		ValaClass* cl = NULL;
		ValaClass* _tmp23_;
		ValaClass* _tmp24_;
		ValaClass* _tmp25_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass);
		{
			ValaList* _base_type_list = NULL;
			ValaClass* _tmp4_;
			ValaList* _tmp5_;
			gint _base_type_size = 0;
			ValaList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _base_type_index = 0;
			_tmp4_ = cl;
			_tmp5_ = vala_class_get_base_types (_tmp4_);
			_base_type_list = _tmp5_;
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_base_type_size = _tmp8_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp11_;
				gpointer _tmp12_;
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_base_type_index = _base_type_index + 1;
				_tmp9_ = _base_type_index;
				_tmp10_ = _base_type_size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _base_type_list;
				_tmp12_ = vala_list_get (_tmp11_, _base_type_index);
				base_type = (ValaDataType*) _tmp12_;
				_tmp13_ = base_type;
				_tmp14_ = vala_data_type_get_type_symbol (_tmp13_);
				_tmp15_ = _tmp14_;
				if (VALA_IS_INTERFACE (_tmp15_)) {
					ValaDataType* _tmp16_;
					ValaTypeSymbol* _tmp17_;
					ValaTypeSymbol* _tmp18_;
					ValaScope* _tmp19_;
					ValaScope* _tmp20_;
					ValaSymbol* _tmp21_;
					ValaSymbol* _tmp22_;
					_tmp16_ = base_type;
					_tmp17_ = vala_data_type_get_type_symbol (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = vala_symbol_get_scope ((ValaSymbol*) _tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = vala_scope_lookup (_tmp20_, name);
					_vala_code_node_unref0 (_result_);
					_result_ = _tmp21_;
					_tmp22_ = _result_;
					if (_tmp22_ != NULL) {
						result = _result_;
						_vala_code_node_unref0 (base_type);
						return result;
					}
				}
				_vala_code_node_unref0 (base_type);
			}
		}
		_tmp23_ = cl;
		_tmp24_ = vala_class_get_base_class (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp25_ != NULL) {
			ValaClass* _tmp26_;
			ValaClass* _tmp27_;
			ValaClass* _tmp28_;
			ValaSymbol* _tmp29_;
			_tmp26_ = cl;
			_tmp27_ = vala_class_get_base_class (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp28_, name);
			result = _tmp29_;
			_vala_code_node_unref0 (_result_);
			return result;
		}
	} else {
		if (VALA_IS_STRUCT (sym)) {
			ValaStruct* st = NULL;
			ValaStruct* _tmp30_;
			ValaDataType* _tmp31_;
			ValaDataType* _tmp32_;
			st = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct);
			_tmp30_ = st;
			_tmp31_ = vala_struct_get_base_type (_tmp30_);
			_tmp32_ = _tmp31_;
			if (_tmp32_ != NULL) {
				ValaStruct* _tmp33_;
				ValaDataType* _tmp34_;
				ValaDataType* _tmp35_;
				ValaTypeSymbol* _tmp36_;
				ValaTypeSymbol* _tmp37_;
				ValaSymbol* _tmp38_;
				ValaSymbol* _tmp39_;
				_tmp33_ = st;
				_tmp34_ = vala_struct_get_base_type (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = vala_data_type_get_type_symbol (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp37_, name);
				_vala_code_node_unref0 (_result_);
				_result_ = _tmp38_;
				_tmp39_ = _result_;
				if (_tmp39_ != NULL) {
					result = _result_;
					return result;
				}
			}
		} else {
			if (VALA_IS_INTERFACE (sym)) {
				ValaInterface* iface = NULL;
				iface = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_INTERFACE, ValaInterface);
				{
					ValaList* _prerequisite_list = NULL;
					ValaInterface* _tmp40_;
					ValaList* _tmp41_;
					gint _prerequisite_size = 0;
					ValaList* _tmp42_;
					gint _tmp43_;
					gint _tmp44_;
					gint _prerequisite_index = 0;
					_tmp40_ = iface;
					_tmp41_ = vala_interface_get_prerequisites (_tmp40_);
					_prerequisite_list = _tmp41_;
					_tmp42_ = _prerequisite_list;
					_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
					_tmp44_ = _tmp43_;
					_prerequisite_size = _tmp44_;
					_prerequisite_index = -1;
					while (TRUE) {
						gint _tmp45_;
						gint _tmp46_;
						ValaDataType* prerequisite = NULL;
						ValaList* _tmp47_;
						gpointer _tmp48_;
						ValaDataType* _tmp49_;
						ValaTypeSymbol* _tmp50_;
						ValaTypeSymbol* _tmp51_;
						_prerequisite_index = _prerequisite_index + 1;
						_tmp45_ = _prerequisite_index;
						_tmp46_ = _prerequisite_size;
						if (!(_tmp45_ < _tmp46_)) {
							break;
						}
						_tmp47_ = _prerequisite_list;
						_tmp48_ = vala_list_get (_tmp47_, _prerequisite_index);
						prerequisite = (ValaDataType*) _tmp48_;
						_tmp49_ = prerequisite;
						_tmp50_ = vala_data_type_get_type_symbol (_tmp49_);
						_tmp51_ = _tmp50_;
						if (VALA_IS_INTERFACE (_tmp51_)) {
							ValaDataType* _tmp52_;
							ValaTypeSymbol* _tmp53_;
							ValaTypeSymbol* _tmp54_;
							ValaSymbol* _tmp55_;
							ValaSymbol* _tmp56_;
							_tmp52_ = prerequisite;
							_tmp53_ = vala_data_type_get_type_symbol (_tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp54_, name);
							_vala_code_node_unref0 (_result_);
							_result_ = _tmp55_;
							_tmp56_ = _result_;
							if (_tmp56_ != NULL) {
								result = _result_;
								_vala_code_node_unref0 (prerequisite);
								return result;
							}
						}
						_vala_code_node_unref0 (prerequisite);
					}
				}
				{
					ValaList* _prerequisite_list = NULL;
					ValaInterface* _tmp57_;
					ValaList* _tmp58_;
					gint _prerequisite_size = 0;
					ValaList* _tmp59_;
					gint _tmp60_;
					gint _tmp61_;
					gint _prerequisite_index = 0;
					_tmp57_ = iface;
					_tmp58_ = vala_interface_get_prerequisites (_tmp57_);
					_prerequisite_list = _tmp58_;
					_tmp59_ = _prerequisite_list;
					_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
					_tmp61_ = _tmp60_;
					_prerequisite_size = _tmp61_;
					_prerequisite_index = -1;
					while (TRUE) {
						gint _tmp62_;
						gint _tmp63_;
						ValaDataType* prerequisite = NULL;
						ValaList* _tmp64_;
						gpointer _tmp65_;
						ValaDataType* _tmp66_;
						ValaTypeSymbol* _tmp67_;
						ValaTypeSymbol* _tmp68_;
						_prerequisite_index = _prerequisite_index + 1;
						_tmp62_ = _prerequisite_index;
						_tmp63_ = _prerequisite_size;
						if (!(_tmp62_ < _tmp63_)) {
							break;
						}
						_tmp64_ = _prerequisite_list;
						_tmp65_ = vala_list_get (_tmp64_, _prerequisite_index);
						prerequisite = (ValaDataType*) _tmp65_;
						_tmp66_ = prerequisite;
						_tmp67_ = vala_data_type_get_type_symbol (_tmp66_);
						_tmp68_ = _tmp67_;
						if (VALA_IS_CLASS (_tmp68_)) {
							ValaDataType* _tmp69_;
							ValaTypeSymbol* _tmp70_;
							ValaTypeSymbol* _tmp71_;
							ValaSymbol* _tmp72_;
							ValaSymbol* _tmp73_;
							_tmp69_ = prerequisite;
							_tmp70_ = vala_data_type_get_type_symbol (_tmp69_);
							_tmp71_ = _tmp70_;
							_tmp72_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp71_, name);
							_vala_code_node_unref0 (_result_);
							_result_ = _tmp72_;
							_tmp73_ = _result_;
							if (_tmp73_ != NULL) {
								result = _result_;
								_vala_code_node_unref0 (prerequisite);
								return result;
							}
						}
						_vala_code_node_unref0 (prerequisite);
					}
				}
			}
		}
	}
	result = NULL;
	_vala_code_node_unref0 (_result_);
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaDataType*
vala_semantic_analyzer_get_data_type_for_symbol (ValaSymbol* sym)
{
	ValaDataType* type = NULL;
	ValaList* type_parameters = NULL;
	ValaList* _tmp31_;
	ValaDataType* result = NULL;
	g_return_val_if_fail (sym != NULL, NULL);
	type_parameters = NULL;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (sym)) {
		ValaClass* cl = NULL;
		gboolean _tmp0_ = FALSE;
		ValaClass* _tmp1_;
		cl = VALA_IS_CLASS (sym) ? ((ValaClass*) sym) : NULL;
		_tmp1_ = cl;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			_tmp2_ = cl;
			_tmp3_ = vala_class_get_is_error_base (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp0_ = _tmp4_;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			ValaErrorType* _tmp5_;
			_tmp5_ = vala_error_type_new (NULL, NULL, NULL);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp5_;
		} else {
			ValaObjectType* _tmp6_;
			ValaList* _tmp7_;
			ValaList* _tmp8_;
			_tmp6_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp6_;
			_tmp7_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp8_ = _vala_iterable_ref0 (_tmp7_);
			_vala_iterable_unref0 (type_parameters);
			type_parameters = _tmp8_;
		}
	} else {
		if (VALA_IS_STRUCT (sym)) {
			ValaStruct* st = NULL;
			ValaStruct* _tmp9_;
			ValaStruct* _tmp20_;
			ValaList* _tmp21_;
			ValaList* _tmp22_;
			st = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct);
			_tmp9_ = st;
			if (vala_struct_is_boolean_type (_tmp9_)) {
				ValaStruct* _tmp10_;
				ValaBooleanType* _tmp11_;
				_tmp10_ = st;
				_tmp11_ = vala_boolean_type_new (_tmp10_);
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp11_;
			} else {
				ValaStruct* _tmp12_;
				_tmp12_ = st;
				if (vala_struct_is_integer_type (_tmp12_)) {
					ValaStruct* _tmp13_;
					ValaIntegerType* _tmp14_;
					_tmp13_ = st;
					_tmp14_ = vala_integer_type_new (_tmp13_, NULL, NULL);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp14_;
				} else {
					ValaStruct* _tmp15_;
					_tmp15_ = st;
					if (vala_struct_is_floating_type (_tmp15_)) {
						ValaStruct* _tmp16_;
						ValaFloatingType* _tmp17_;
						_tmp16_ = st;
						_tmp17_ = vala_floating_type_new (_tmp16_);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp17_;
					} else {
						ValaStruct* _tmp18_;
						ValaStructValueType* _tmp19_;
						_tmp18_ = st;
						_tmp19_ = vala_struct_value_type_new (_tmp18_);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp19_;
					}
				}
			}
			_tmp20_ = st;
			_tmp21_ = vala_struct_get_type_parameters (_tmp20_);
			_tmp22_ = _vala_iterable_ref0 (_tmp21_);
			_vala_iterable_unref0 (type_parameters);
			type_parameters = _tmp22_;
		} else {
			if (VALA_IS_ENUM (sym)) {
				ValaEnumValueType* _tmp23_;
				_tmp23_ = vala_enum_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp23_;
			} else {
				if (VALA_IS_ERROR_DOMAIN (sym)) {
					ValaErrorType* _tmp24_;
					_tmp24_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), NULL, NULL);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp24_;
				} else {
					if (VALA_IS_ERROR_CODE (sym)) {
						ValaSymbol* _tmp25_;
						ValaSymbol* _tmp26_;
						ValaErrorType* _tmp27_;
						_tmp25_ = vala_symbol_get_parent_symbol (sym);
						_tmp26_ = _tmp25_;
						_tmp27_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_CODE, ValaErrorCode), NULL);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp27_;
					} else {
						gchar* _tmp28_;
						gchar* _tmp29_;
						ValaInvalidType* _tmp30_;
						_tmp28_ = vala_symbol_get_full_name (sym);
						_tmp29_ = _tmp28_;
						vala_report_error (NULL, "internal error: `%s' is not a supported type", _tmp29_);
						_g_free0 (_tmp29_);
						_tmp30_ = vala_invalid_type_new ();
						result = (ValaDataType*) _tmp30_;
						_vala_iterable_unref0 (type_parameters);
						_vala_code_node_unref0 (type);
						return result;
					}
				}
			}
		}
	}
	_tmp31_ = type_parameters;
	if (_tmp31_ != NULL) {
		{
			ValaList* _type_param_list = NULL;
			ValaList* _tmp32_;
			gint _type_param_size = 0;
			ValaList* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			gint _type_param_index = 0;
			_tmp32_ = type_parameters;
			_type_param_list = _tmp32_;
			_tmp33_ = _type_param_list;
			_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
			_tmp35_ = _tmp34_;
			_type_param_size = _tmp35_;
			_type_param_index = -1;
			while (TRUE) {
				gint _tmp36_;
				gint _tmp37_;
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp38_;
				gpointer _tmp39_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp40_;
				ValaGenericType* _tmp41_;
				ValaGenericType* _tmp42_;
				ValaDataType* _tmp43_;
				ValaGenericType* _tmp44_;
				_type_param_index = _type_param_index + 1;
				_tmp36_ = _type_param_index;
				_tmp37_ = _type_param_size;
				if (!(_tmp36_ < _tmp37_)) {
					break;
				}
				_tmp38_ = _type_param_list;
				_tmp39_ = vala_list_get (_tmp38_, _type_param_index);
				type_param = (ValaTypeParameter*) _tmp39_;
				_tmp40_ = type_param;
				_tmp41_ = vala_generic_type_new (_tmp40_);
				type_arg = _tmp41_;
				_tmp42_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp42_, TRUE);
				_tmp43_ = type;
				_tmp44_ = type_arg;
				vala_data_type_add_type_argument (_tmp43_, (ValaDataType*) _tmp44_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_param);
			}
		}
	}
	result = type;
	_vala_iterable_unref0 (type_parameters);
	return result;
}

ValaSymbol*
vala_semantic_analyzer_get_symbol_for_data_type (ValaDataType* type)
{
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp14_;
	ValaSymbol* result = NULL;
	g_return_val_if_fail (type != NULL, NULL);
	sym = NULL;
	if (VALA_IS_OBJECT_TYPE (type)) {
		ValaTypeSymbol* _tmp0_;
		ValaTypeSymbol* _tmp1_;
		_tmp0_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
		_tmp1_ = _tmp0_;
		sym = (ValaSymbol*) _tmp1_;
	} else {
		if (VALA_IS_CLASS_TYPE (type)) {
			ValaClass* _tmp2_;
			ValaClass* _tmp3_;
			_tmp2_ = vala_class_type_get_class_symbol (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_CLASS_TYPE, ValaClassType));
			_tmp3_ = _tmp2_;
			sym = (ValaSymbol*) _tmp3_;
		} else {
			if (VALA_IS_INTERFACE_TYPE (type)) {
				ValaInterface* _tmp4_;
				ValaInterface* _tmp5_;
				_tmp4_ = vala_interface_type_get_interface_symbol (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_INTERFACE_TYPE, ValaInterfaceType));
				_tmp5_ = _tmp4_;
				sym = (ValaSymbol*) _tmp5_;
			} else {
				if (VALA_IS_METHOD_TYPE (type)) {
					ValaMethod* _tmp6_;
					ValaMethod* _tmp7_;
					_tmp6_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_METHOD_TYPE, ValaMethodType));
					_tmp7_ = _tmp6_;
					sym = (ValaSymbol*) _tmp7_;
				} else {
					if (VALA_IS_SIGNAL_TYPE (type)) {
						ValaSignal* _tmp8_;
						ValaSignal* _tmp9_;
						_tmp8_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
						_tmp9_ = _tmp8_;
						sym = (ValaSymbol*) _tmp9_;
					} else {
						if (VALA_IS_DELEGATE_TYPE (type)) {
							ValaDelegate* _tmp10_;
							ValaDelegate* _tmp11_;
							_tmp10_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							_tmp11_ = _tmp10_;
							sym = (ValaSymbol*) _tmp11_;
						} else {
							if (VALA_IS_VALUE_TYPE (type)) {
								ValaTypeSymbol* _tmp12_;
								ValaTypeSymbol* _tmp13_;
								_tmp12_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_VALUE_TYPE, ValaValueType));
								_tmp13_ = _tmp12_;
								sym = (ValaSymbol*) _tmp13_;
							}
						}
					}
				}
			}
		}
	}
	_tmp14_ = sym;
	result = _tmp14_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gboolean
vala_semantic_analyzer_is_gobject_property (ValaSemanticAnalyzer* self,
                                            ValaProperty* prop)
{
	ValaObjectTypeSymbol* type_sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaObjectTypeSymbol* _tmp3_;
	ValaMemberBinding _tmp6_;
	ValaMemberBinding _tmp7_;
	ValaSymbolAccessibility _tmp8_;
	ValaSymbolAccessibility _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	ValaObjectTypeSymbol* _tmp21_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	ValaObjectTypeSymbol* _tmp31_;
	gboolean _tmp38_ = FALSE;
	ValaObjectTypeSymbol* _tmp39_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) prop);
	_tmp1_ = _tmp0_;
	type_sym = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1_) ? ((ValaObjectTypeSymbol*) _tmp1_) : NULL;
	_tmp3_ = type_sym;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		ValaObjectTypeSymbol* _tmp4_;
		ValaClass* _tmp5_;
		_tmp4_ = type_sym;
		_tmp5_ = self->object_type;
		_tmp2_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp4_, (ValaTypeSymbol*) _tmp5_);
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_property_get_binding (prop);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp8_ = vala_symbol_get_access ((ValaSymbol*) prop);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		result = FALSE;
		return result;
	}
	_tmp10_ = vala_property_get_property_type (prop);
	_tmp11_ = _tmp10_;
	if (!vala_semantic_analyzer_is_gobject_property_type (self, _tmp11_)) {
		gboolean _tmp12_ = FALSE;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp13_ = vala_property_get_property_type (prop);
		_tmp14_ = _tmp13_;
		if (VALA_IS_ARRAY_TYPE (_tmp14_)) {
			gboolean _tmp15_ = FALSE;
			if (!vala_code_node_get_attribute_bool ((ValaCodeNode*) prop, "CCode", "array_length", TRUE)) {
				_tmp15_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) prop, "CCode", "array_null_terminated", FALSE);
			} else {
				_tmp15_ = FALSE;
			}
			_tmp12_ = _tmp15_;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
		} else {
			gboolean _tmp16_ = FALSE;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			_tmp17_ = vala_property_get_property_type (prop);
			_tmp18_ = _tmp17_;
			if (VALA_IS_DELEGATE_TYPE (_tmp18_)) {
				_tmp16_ = !vala_code_node_get_attribute_bool ((ValaCodeNode*) prop, "CCode", "delegate_target", TRUE);
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
			} else {
				result = FALSE;
				return result;
			}
		}
	}
	_tmp21_ = type_sym;
	if (VALA_IS_CLASS (_tmp21_)) {
		ValaProperty* _tmp22_;
		ValaProperty* _tmp23_;
		_tmp22_ = vala_property_get_base_interface_property (prop);
		_tmp23_ = _tmp22_;
		_tmp20_ = _tmp23_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		ValaProperty* _tmp24_;
		ValaProperty* _tmp25_;
		_tmp24_ = vala_property_get_base_interface_property (prop);
		_tmp25_ = _tmp24_;
		_tmp19_ = !vala_semantic_analyzer_is_gobject_property (self, _tmp25_);
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		result = FALSE;
		return result;
	}
	_tmp26_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp27_ = _tmp26_;
	if (!g_ascii_isalpha (string_get (_tmp27_, (glong) 0))) {
		result = FALSE;
		return result;
	}
	_tmp31_ = type_sym;
	if (VALA_IS_INTERFACE (_tmp31_)) {
		gboolean _tmp32_;
		gboolean _tmp33_;
		_tmp32_ = vala_property_get_is_abstract (prop);
		_tmp33_ = _tmp32_;
		_tmp30_ = !_tmp33_;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		gboolean _tmp34_;
		gboolean _tmp35_;
		_tmp34_ = vala_symbol_get_external ((ValaSymbol*) prop);
		_tmp35_ = _tmp34_;
		_tmp29_ = !_tmp35_;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		gboolean _tmp36_;
		gboolean _tmp37_;
		_tmp36_ = vala_symbol_get_external_package ((ValaSymbol*) prop);
		_tmp37_ = _tmp36_;
		_tmp28_ = !_tmp37_;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		result = FALSE;
		return result;
	}
	_tmp39_ = type_sym;
	if (VALA_IS_INTERFACE (_tmp39_)) {
		ValaObjectTypeSymbol* _tmp40_;
		ValaAttribute* _tmp41_;
		_tmp40_ = type_sym;
		_tmp41_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp40_, "DBus");
		_tmp38_ = _tmp41_ != NULL;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

gboolean
vala_semantic_analyzer_is_gobject_property_type (ValaSemanticAnalyzer* self,
                                                 ValaDataType* property_type)
{
	ValaStruct* st = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp9_ = FALSE;
	ValaDelegateType* d = NULL;
	gboolean _tmp17_ = FALSE;
	ValaDelegateType* _tmp18_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (property_type != NULL, FALSE);
	_tmp0_ = vala_data_type_get_type_symbol (property_type);
	_tmp1_ = _tmp0_;
	st = VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL;
	_tmp2_ = st;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaStruct* _tmp4_;
		_tmp4_ = st;
		if (!vala_struct_is_simple_type (_tmp4_)) {
			ValaStruct* _tmp5_;
			_tmp5_ = st;
			_tmp3_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp5_, "CCode", "has_type_id", TRUE);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
		} else {
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp6_ = vala_data_type_get_nullable (property_type);
			_tmp7_ = _tmp6_;
			if (_tmp7_) {
				result = FALSE;
				return result;
			} else {
				ValaStruct* _tmp8_;
				_tmp8_ = st;
				if (!vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp8_, "CCode", "has_type_id", TRUE)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	if (VALA_IS_ARRAY_TYPE (property_type)) {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		ValaTypeSymbol* _tmp12_;
		ValaTypeSymbol* _tmp13_;
		ValaDataType* _tmp14_;
		ValaTypeSymbol* _tmp15_;
		ValaTypeSymbol* _tmp16_;
		_tmp10_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (property_type, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_data_type_get_type_symbol (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->string_type;
		_tmp15_ = vala_data_type_get_type_symbol (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp9_ = _tmp13_ != _tmp16_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		result = FALSE;
		return result;
	}
	d = VALA_IS_DELEGATE_TYPE (property_type) ? ((ValaDelegateType*) property_type) : NULL;
	_tmp18_ = d;
	if (_tmp18_ != NULL) {
		ValaDelegateType* _tmp19_;
		ValaDelegate* _tmp20_;
		ValaDelegate* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp19_ = d;
		_tmp20_ = vala_delegate_type_get_delegate_symbol (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_delegate_get_has_target (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp17_ = _tmp23_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gboolean
vala_semantic_analyzer_check_arguments (ValaSemanticAnalyzer* self,
                                        ValaExpression* expr,
                                        ValaDataType* mtype,
                                        ValaList* params,
                                        ValaList* args)
{
	gboolean _error_ = FALSE;
	ValaExpression* prev_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaIterator* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean diag = FALSE;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp95_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (expr != NULL, FALSE);
	g_return_val_if_fail (mtype != NULL, FALSE);
	g_return_val_if_fail (params != NULL, FALSE);
	g_return_val_if_fail (args != NULL, FALSE);
	_error_ = FALSE;
	prev_arg = NULL;
	_tmp0_ = vala_iterable_iterator ((ValaIterable*) args);
	arg_it = _tmp0_;
	if (VALA_IS_METHOD_TYPE (mtype)) {
		ValaMethod* _tmp2_;
		ValaMethod* _tmp3_;
		ValaAttribute* _tmp4_;
		_tmp2_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (mtype, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp3_, "Diagnostics");
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	diag = _tmp1_;
	ellipsis = FALSE;
	i = 0;
	{
		ValaList* _param_list = NULL;
		gint _param_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _param_index = 0;
		_param_list = params;
		_tmp5_ = _param_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_param_size = _tmp7_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaParameter* param = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaParameter* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			ValaParameter* _tmp15_;
			gboolean _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp26_ = FALSE;
			ValaIterator* _tmp27_;
			_param_index = _param_index + 1;
			_tmp8_ = _param_index;
			_tmp9_ = _param_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _param_list;
			_tmp11_ = vala_list_get (_tmp10_, _param_index);
			param = (ValaParameter*) _tmp11_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_ellipsis (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_) {
				ellipsis = TRUE;
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp15_ = param;
			_tmp16_ = vala_parameter_get_params_array (_tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_) {
				while (TRUE) {
					ValaIterator* _tmp18_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp19_;
					gpointer _tmp20_;
					ValaExpression* _tmp21_;
					ValaParameter* _tmp22_;
					ValaParameterDirection _tmp23_;
					ValaParameterDirection _tmp24_;
					gint _tmp25_;
					_tmp18_ = arg_it;
					if (!vala_iterator_next (_tmp18_)) {
						break;
					}
					_tmp19_ = arg_it;
					_tmp20_ = vala_iterator_get (_tmp19_);
					arg = (ValaExpression*) _tmp20_;
					_tmp21_ = arg;
					_tmp22_ = param;
					_tmp23_ = vala_parameter_get_direction (_tmp22_);
					_tmp24_ = _tmp23_;
					if (!vala_semantic_analyzer_check_argument (self, _tmp21_, i, _tmp24_)) {
						vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
						_error_ = TRUE;
					}
					_tmp25_ = i;
					i = _tmp25_ + 1;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp27_ = arg_it;
			if (_tmp27_ == NULL) {
				_tmp26_ = TRUE;
			} else {
				ValaIterator* _tmp28_;
				_tmp28_ = arg_it;
				_tmp26_ = !vala_iterator_next (_tmp28_);
			}
			if (_tmp26_) {
				ValaParameter* _tmp29_;
				ValaExpression* _tmp30_;
				ValaExpression* _tmp31_;
				_tmp29_ = param;
				_tmp30_ = vala_variable_get_initializer ((ValaVariable*) _tmp29_);
				_tmp31_ = _tmp30_;
				if (_tmp31_ == NULL) {
					ValaMethodType* m = NULL;
					ValaMethodType* _tmp32_;
					vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
					m = VALA_IS_METHOD_TYPE (mtype) ? ((ValaMethodType*) mtype) : NULL;
					_tmp32_ = m;
					if (_tmp32_ != NULL) {
						ValaSourceReference* _tmp33_;
						ValaSourceReference* _tmp34_;
						ValaMethodType* _tmp35_;
						ValaList* _tmp36_;
						gint _tmp37_;
						gint _tmp38_;
						gint _tmp39_;
						gint _tmp40_;
						ValaMethodType* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
						_tmp34_ = _tmp33_;
						_tmp35_ = m;
						_tmp36_ = vala_data_type_get_parameters ((ValaDataType*) _tmp35_);
						_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = vala_collection_get_size ((ValaCollection*) args);
						_tmp40_ = _tmp39_;
						_tmp41_ = m;
						_tmp42_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp41_, NULL);
						_tmp43_ = _tmp42_;
						vala_report_error (_tmp34_, "%d missing arguments for `%s'", _tmp38_ - _tmp40_, _tmp43_);
						_g_free0 (_tmp43_);
					} else {
						ValaSourceReference* _tmp44_;
						ValaSourceReference* _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp47_;
						gint _tmp48_;
						gint _tmp49_;
						_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
						_tmp45_ = _tmp44_;
						_tmp46_ = vala_code_node_to_string ((ValaCodeNode*) mtype);
						_tmp47_ = _tmp46_;
						_tmp48_ = vala_collection_get_size ((ValaCollection*) args);
						_tmp49_ = _tmp48_;
						vala_report_error (_tmp45_, "Too few arguments, method `%s' does not take %d arguments", _tmp47_, _tmp49_);
						_g_free0 (_tmp47_);
					}
					_error_ = TRUE;
				} else {
					ValaMethodCall* invocation_expr = NULL;
					ValaObjectCreationExpression* object_creation_expr = NULL;
					ValaMethodCall* _tmp50_;
					invocation_expr = VALA_IS_METHOD_CALL (expr) ? ((ValaMethodCall*) expr) : NULL;
					object_creation_expr = VALA_IS_OBJECT_CREATION_EXPRESSION (expr) ? ((ValaObjectCreationExpression*) expr) : NULL;
					_tmp50_ = invocation_expr;
					if (_tmp50_ != NULL) {
						ValaMethodCall* _tmp51_;
						ValaParameter* _tmp52_;
						ValaExpression* _tmp53_;
						ValaExpression* _tmp54_;
						_tmp51_ = invocation_expr;
						_tmp52_ = param;
						_tmp53_ = vala_variable_get_initializer ((ValaVariable*) _tmp52_);
						_tmp54_ = _tmp53_;
						vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp51_, _tmp54_);
					} else {
						ValaObjectCreationExpression* _tmp55_;
						_tmp55_ = object_creation_expr;
						if (_tmp55_ != NULL) {
							ValaObjectCreationExpression* _tmp56_;
							ValaParameter* _tmp57_;
							ValaExpression* _tmp58_;
							ValaExpression* _tmp59_;
							_tmp56_ = object_creation_expr;
							_tmp57_ = param;
							_tmp58_ = vala_variable_get_initializer ((ValaVariable*) _tmp57_);
							_tmp59_ = _tmp58_;
							vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp56_, _tmp59_);
						} else {
							g_assert_not_reached ();
						}
					}
					_vala_iterator_unref0 (arg_it);
					arg_it = NULL;
				}
			} else {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp60_;
				gpointer _tmp61_;
				ValaExpression* _tmp62_;
				ValaParameter* _tmp63_;
				ValaParameterDirection _tmp64_;
				ValaParameterDirection _tmp65_;
				ValaExpression* _tmp66_;
				ValaExpression* _tmp67_;
				gint _tmp68_;
				_tmp60_ = arg_it;
				_tmp61_ = vala_iterator_get (_tmp60_);
				arg = (ValaExpression*) _tmp61_;
				_tmp62_ = arg;
				_tmp63_ = param;
				_tmp64_ = vala_parameter_get_direction (_tmp63_);
				_tmp65_ = _tmp64_;
				if (!vala_semantic_analyzer_check_argument (self, _tmp62_, i, _tmp65_)) {
					vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
					_error_ = TRUE;
				}
				_tmp66_ = arg;
				_tmp67_ = _vala_code_node_ref0 (_tmp66_);
				_vala_code_node_unref0 (prev_arg);
				prev_arg = _tmp67_;
				_tmp68_ = i;
				i = _tmp68_ + 1;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
	}
	if (ellipsis) {
		ValaIterator* _tmp70_;
		ValaSourceReference* _tmp71_;
		ValaSourceReference* _tmp72_;
		_tmp70_ = arg_it;
		_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp72_ = _tmp71_;
		_tmp69_ = !vala_semantic_analyzer_check_variadic_arguments (self, _tmp70_, i, _tmp72_);
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
		_error_ = TRUE;
	} else {
		gboolean _tmp73_ = FALSE;
		gboolean _tmp74_ = FALSE;
		if (!ellipsis) {
			ValaIterator* _tmp75_;
			_tmp75_ = arg_it;
			_tmp74_ = _tmp75_ != NULL;
		} else {
			_tmp74_ = FALSE;
		}
		if (_tmp74_) {
			ValaIterator* _tmp76_;
			_tmp76_ = arg_it;
			_tmp73_ = vala_iterator_next (_tmp76_);
		} else {
			_tmp73_ = FALSE;
		}
		if (_tmp73_) {
			ValaMethodType* m = NULL;
			ValaMethodType* _tmp77_;
			vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
			m = VALA_IS_METHOD_TYPE (mtype) ? ((ValaMethodType*) mtype) : NULL;
			_tmp77_ = m;
			if (_tmp77_ != NULL) {
				ValaSourceReference* _tmp78_;
				ValaSourceReference* _tmp79_;
				gint _tmp80_;
				gint _tmp81_;
				ValaMethodType* _tmp82_;
				ValaList* _tmp83_;
				gint _tmp84_;
				gint _tmp85_;
				ValaMethodType* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
				_tmp79_ = _tmp78_;
				_tmp80_ = vala_collection_get_size ((ValaCollection*) args);
				_tmp81_ = _tmp80_;
				_tmp82_ = m;
				_tmp83_ = vala_data_type_get_parameters ((ValaDataType*) _tmp82_);
				_tmp84_ = vala_collection_get_size ((ValaCollection*) _tmp83_);
				_tmp85_ = _tmp84_;
				_tmp86_ = m;
				_tmp87_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp86_, NULL);
				_tmp88_ = _tmp87_;
				vala_report_error (_tmp79_, "%d extra arguments for `%s'", _tmp81_ - _tmp85_, _tmp88_);
				_g_free0 (_tmp88_);
			} else {
				ValaSourceReference* _tmp89_;
				ValaSourceReference* _tmp90_;
				gchar* _tmp91_;
				gchar* _tmp92_;
				gint _tmp93_;
				gint _tmp94_;
				_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
				_tmp90_ = _tmp89_;
				_tmp91_ = vala_code_node_to_string ((ValaCodeNode*) mtype);
				_tmp92_ = _tmp91_;
				_tmp93_ = vala_collection_get_size ((ValaCollection*) args);
				_tmp94_ = _tmp93_;
				vala_report_error (_tmp90_, "Too many arguments, method `%s' does not take %d arguments", _tmp92_, _tmp94_);
				_g_free0 (_tmp92_);
			}
			_error_ = TRUE;
		}
	}
	if (diag) {
		ValaExpression* _tmp96_;
		_tmp96_ = prev_arg;
		_tmp95_ = _tmp96_ != NULL;
	} else {
		_tmp95_ = FALSE;
	}
	if (_tmp95_) {
		ValaStringLiteral* format_arg = NULL;
		ValaExpression* _tmp97_;
		ValaStringLiteral* _tmp98_;
		_tmp97_ = prev_arg;
		format_arg = VALA_IS_STRING_LITERAL (_tmp97_) ? ((ValaStringLiteral*) _tmp97_) : NULL;
		_tmp98_ = format_arg;
		if (_tmp98_ != NULL) {
			ValaStringLiteral* _tmp99_;
			ValaSourceReference* _tmp100_;
			ValaSourceReference* _tmp101_;
			ValaSourceFile* _tmp102_;
			ValaSourceFile* _tmp103_;
			const gchar* _tmp104_;
			const gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			ValaSourceReference* _tmp108_;
			ValaSourceReference* _tmp109_;
			ValaSourceLocation _tmp110_ = {0};
			ValaSourceLocation _tmp111_;
			ValaStringLiteral* _tmp112_;
			const gchar* _tmp113_;
			const gchar* _tmp114_;
			gchar* _tmp115_;
			gchar* _tmp116_;
			gchar* _tmp117_;
			gchar* _tmp118_;
			_tmp99_ = format_arg;
			_tmp100_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp101_ = _tmp100_;
			_tmp102_ = vala_source_reference_get_file (_tmp101_);
			_tmp103_ = _tmp102_;
			_tmp104_ = vala_source_file_get_filename (_tmp103_);
			_tmp105_ = _tmp104_;
			_tmp106_ = g_path_get_basename (_tmp105_);
			_tmp107_ = _tmp106_;
			_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp109_ = _tmp108_;
			vala_source_reference_get_begin (_tmp109_, &_tmp110_);
			_tmp111_ = _tmp110_;
			_tmp112_ = format_arg;
			_tmp113_ = vala_string_literal_get_value (_tmp112_);
			_tmp114_ = _tmp113_;
			_tmp115_ = string_substring (_tmp114_, (glong) 1, (glong) -1);
			_tmp116_ = _tmp115_;
			_tmp117_ = g_strdup_printf ("\"%s:%d: %s", _tmp107_, _tmp111_.line, _tmp116_);
			_tmp118_ = _tmp117_;
			vala_string_literal_set_value (_tmp99_, _tmp118_);
			_g_free0 (_tmp118_);
			_g_free0 (_tmp116_);
			_g_free0 (_tmp107_);
		}
	}
	result = !_error_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (prev_arg);
	return result;
}

static gboolean
vala_semantic_analyzer_check_argument (ValaSemanticAnalyzer* self,
                                       ValaExpression* arg,
                                       gint i,
                                       ValaParameterDirection direction)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp67_;
	ValaDataType* _tmp68_;
	ValaMemberAccess* ma = NULL;
	gboolean _tmp102_ = FALSE;
	ValaMemberAccess* _tmp103_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (arg != NULL, FALSE);
	_tmp0_ = vala_code_node_get_error ((ValaCodeNode*) arg);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	} else {
		if (VALA_IS_NAMED_ARGUMENT (arg)) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
			_tmp3_ = _tmp2_;
			vala_report_error (_tmp3_, "Named arguments are not supported yet");
			result = FALSE;
			return result;
		} else {
			ValaDataType* _tmp4_;
			ValaDataType* _tmp5_;
			_tmp4_ = vala_expression_get_value_type (arg);
			_tmp5_ = _tmp4_;
			if (_tmp5_ == NULL) {
				gboolean _tmp6_ = FALSE;
				ValaDataType* _tmp7_;
				ValaDataType* _tmp8_;
				_tmp7_ = vala_expression_get_target_type (arg);
				_tmp8_ = _tmp7_;
				if (!VALA_IS_DELEGATE_TYPE (_tmp8_)) {
					_tmp6_ = TRUE;
				} else {
					ValaSymbol* _tmp9_;
					ValaSymbol* _tmp10_;
					_tmp9_ = vala_expression_get_symbol_reference (arg);
					_tmp10_ = _tmp9_;
					_tmp6_ = !VALA_IS_METHOD (_tmp10_);
				}
				if (_tmp6_) {
					ValaSourceReference* _tmp11_;
					ValaSourceReference* _tmp12_;
					_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
					_tmp12_ = _tmp11_;
					vala_report_error (_tmp12_, "Invalid type for argument %d", i + 1);
					result = FALSE;
					return result;
				}
			} else {
				gint arg_type = 0;
				ValaDataType* _tmp13_;
				ValaDataType* _tmp14_;
				arg_type = 1;
				_tmp13_ = vala_expression_get_value_type (arg);
				_tmp14_ = _tmp13_;
				if (VALA_IS_NULL_TYPE (_tmp14_)) {
					arg_type = 0;
				} else {
					if (VALA_IS_UNARY_EXPRESSION (arg)) {
						ValaUnaryExpression* unary = NULL;
						ValaUnaryExpression* _tmp15_;
						ValaUnaryExpression* _tmp16_;
						ValaUnaryOperator _tmp17_;
						ValaUnaryOperator _tmp18_;
						_tmp15_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (arg, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
						unary = _tmp15_;
						_tmp16_ = unary;
						_tmp17_ = vala_unary_expression_get_operator (_tmp16_);
						_tmp18_ = _tmp17_;
						if (_tmp18_ == VALA_UNARY_OPERATOR_REF) {
							arg_type = 2;
						} else {
							ValaUnaryExpression* _tmp19_;
							ValaUnaryOperator _tmp20_;
							ValaUnaryOperator _tmp21_;
							_tmp19_ = unary;
							_tmp20_ = vala_unary_expression_get_operator (_tmp19_);
							_tmp21_ = _tmp20_;
							if (_tmp21_ == VALA_UNARY_OPERATOR_OUT) {
								arg_type = 3;
							}
						}
						_vala_code_node_unref0 (unary);
					}
				}
				if (arg_type == 0) {
					if (direction == VALA_PARAMETER_DIRECTION_REF) {
						ValaSourceReference* _tmp22_;
						ValaSourceReference* _tmp23_;
						_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
						_tmp23_ = _tmp22_;
						vala_report_error (_tmp23_, "Argument %d: Cannot pass null to reference parameter", i + 1);
						result = FALSE;
						return result;
					} else {
						gboolean _tmp24_ = FALSE;
						if (direction != VALA_PARAMETER_DIRECTION_OUT) {
							ValaDataType* _tmp25_;
							ValaDataType* _tmp26_;
							gboolean _tmp27_;
							gboolean _tmp28_;
							_tmp25_ = vala_expression_get_target_type (arg);
							_tmp26_ = _tmp25_;
							_tmp27_ = vala_data_type_get_nullable (_tmp26_);
							_tmp28_ = _tmp27_;
							_tmp24_ = !_tmp28_;
						} else {
							_tmp24_ = FALSE;
						}
						if (_tmp24_) {
							ValaSourceReference* _tmp29_;
							ValaSourceReference* _tmp30_;
							_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
							_tmp30_ = _tmp29_;
							vala_report_warning (_tmp30_, "Argument %d: Cannot pass null to non-null parameter type", i + 1);
						}
					}
				} else {
					if (arg_type == 1) {
						if (direction != VALA_PARAMETER_DIRECTION_IN) {
							ValaSourceReference* _tmp31_;
							ValaSourceReference* _tmp32_;
							_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
							_tmp32_ = _tmp31_;
							vala_report_error (_tmp32_, "Argument %d: Cannot pass value to reference or output parameter", i + 1);
							result = FALSE;
							return result;
						}
					} else {
						if (arg_type == 2) {
							ValaDataType* _tmp35_;
							ValaDataType* _tmp36_;
							ValaDataType* _tmp46_;
							ValaDataType* _tmp47_;
							if (direction != VALA_PARAMETER_DIRECTION_REF) {
								ValaSourceReference* _tmp33_;
								ValaSourceReference* _tmp34_;
								_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
								_tmp34_ = _tmp33_;
								vala_report_error (_tmp34_, "Argument %d: Cannot pass ref argument to non-reference parameter", i + 1);
								result = FALSE;
								return result;
							}
							_tmp35_ = vala_expression_get_target_type (arg);
							_tmp36_ = _tmp35_;
							if (vala_data_type_is_disposable (_tmp36_)) {
								gboolean _tmp37_ = FALSE;
								ValaDataType* _tmp38_;
								ValaDataType* _tmp39_;
								_tmp38_ = vala_expression_get_value_type (arg);
								_tmp39_ = _tmp38_;
								if (!VALA_IS_POINTER_TYPE (_tmp39_)) {
									ValaDataType* _tmp40_;
									ValaDataType* _tmp41_;
									gboolean _tmp42_;
									gboolean _tmp43_;
									_tmp40_ = vala_expression_get_value_type (arg);
									_tmp41_ = _tmp40_;
									_tmp42_ = vala_data_type_get_value_owned (_tmp41_);
									_tmp43_ = _tmp42_;
									_tmp37_ = !_tmp43_;
								} else {
									_tmp37_ = FALSE;
								}
								if (_tmp37_) {
									ValaSourceReference* _tmp44_;
									ValaSourceReference* _tmp45_;
									_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
									_tmp45_ = _tmp44_;
									vala_report_error (_tmp45_, "Argument %d: Cannot pass unowned ref argument to owned reference param" \
"eter", i + 1);
									result = FALSE;
									return result;
								}
							}
							_tmp46_ = vala_expression_get_value_type (arg);
							_tmp47_ = _tmp46_;
							if (vala_data_type_is_disposable (_tmp47_)) {
								ValaDataType* _tmp48_;
								ValaDataType* _tmp49_;
								gboolean _tmp50_;
								gboolean _tmp51_;
								_tmp48_ = vala_expression_get_target_type (arg);
								_tmp49_ = _tmp48_;
								_tmp50_ = vala_data_type_get_value_owned (_tmp49_);
								_tmp51_ = _tmp50_;
								if (!_tmp51_) {
									ValaSourceReference* _tmp52_;
									ValaSourceReference* _tmp53_;
									_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
									_tmp53_ = _tmp52_;
									vala_report_error (_tmp53_, "Argument %d: Cannot pass owned ref argument to unowned reference param" \
"eter", i + 1);
									result = FALSE;
									return result;
								}
							}
						} else {
							if (arg_type == 3) {
								ValaDataType* _tmp56_;
								ValaDataType* _tmp57_;
								if (direction != VALA_PARAMETER_DIRECTION_OUT) {
									ValaSourceReference* _tmp54_;
									ValaSourceReference* _tmp55_;
									_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
									_tmp55_ = _tmp54_;
									vala_report_error (_tmp55_, "Argument %d: Cannot pass out argument to non-output parameter", i + 1);
									result = FALSE;
									return result;
								}
								_tmp56_ = vala_expression_get_target_type (arg);
								_tmp57_ = _tmp56_;
								if (vala_data_type_is_disposable (_tmp57_)) {
									gboolean _tmp58_ = FALSE;
									ValaDataType* _tmp59_;
									ValaDataType* _tmp60_;
									_tmp59_ = vala_expression_get_value_type (arg);
									_tmp60_ = _tmp59_;
									if (!VALA_IS_POINTER_TYPE (_tmp60_)) {
										ValaDataType* _tmp61_;
										ValaDataType* _tmp62_;
										gboolean _tmp63_;
										gboolean _tmp64_;
										_tmp61_ = vala_expression_get_value_type (arg);
										_tmp62_ = _tmp61_;
										_tmp63_ = vala_data_type_get_value_owned (_tmp62_);
										_tmp64_ = _tmp63_;
										_tmp58_ = !_tmp64_;
									} else {
										_tmp58_ = FALSE;
									}
									if (_tmp58_) {
										ValaSourceReference* _tmp65_;
										ValaSourceReference* _tmp66_;
										_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
										_tmp66_ = _tmp65_;
										vala_report_error (_tmp66_, "Invalid assignment from owned expression to unowned variable");
										result = FALSE;
										return result;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp67_ = vala_expression_get_target_type (arg);
	_tmp68_ = _tmp67_;
	if (_tmp68_ != NULL) {
		gboolean _tmp69_ = FALSE;
		gboolean _tmp70_ = FALSE;
		if (direction == VALA_PARAMETER_DIRECTION_IN) {
			_tmp70_ = TRUE;
		} else {
			_tmp70_ = direction == VALA_PARAMETER_DIRECTION_REF;
		}
		if (_tmp70_) {
			ValaDataType* _tmp71_;
			ValaDataType* _tmp72_;
			ValaDataType* _tmp73_;
			ValaDataType* _tmp74_;
			_tmp71_ = vala_expression_get_value_type (arg);
			_tmp72_ = _tmp71_;
			_tmp73_ = vala_expression_get_target_type (arg);
			_tmp74_ = _tmp73_;
			_tmp69_ = !vala_data_type_compatible (_tmp72_, _tmp74_);
		} else {
			_tmp69_ = FALSE;
		}
		if (_tmp69_) {
			ValaSourceReference* _tmp75_;
			ValaSourceReference* _tmp76_;
			ValaDataType* _tmp77_;
			ValaDataType* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			ValaDataType* _tmp81_;
			ValaDataType* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			_tmp75_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
			_tmp76_ = _tmp75_;
			_tmp77_ = vala_expression_get_value_type (arg);
			_tmp78_ = _tmp77_;
			_tmp79_ = vala_data_type_to_prototype_string (_tmp78_, NULL);
			_tmp80_ = _tmp79_;
			_tmp81_ = vala_expression_get_target_type (arg);
			_tmp82_ = _tmp81_;
			_tmp83_ = vala_data_type_to_prototype_string (_tmp82_, NULL);
			_tmp84_ = _tmp83_;
			vala_report_error (_tmp76_, "Argument %d: Cannot convert from `%s' to `%s'", i + 1, _tmp80_, _tmp84_);
			_g_free0 (_tmp84_);
			_g_free0 (_tmp80_);
			result = FALSE;
			return result;
		} else {
			gboolean _tmp85_ = FALSE;
			gboolean _tmp86_ = FALSE;
			gboolean _tmp87_ = FALSE;
			if (direction == VALA_PARAMETER_DIRECTION_REF) {
				_tmp87_ = TRUE;
			} else {
				_tmp87_ = direction == VALA_PARAMETER_DIRECTION_OUT;
			}
			if (_tmp87_) {
				ValaDataType* _tmp88_;
				ValaDataType* _tmp89_;
				ValaDataType* _tmp90_;
				ValaDataType* _tmp91_;
				_tmp88_ = vala_expression_get_target_type (arg);
				_tmp89_ = _tmp88_;
				_tmp90_ = vala_expression_get_value_type (arg);
				_tmp91_ = _tmp90_;
				_tmp86_ = !vala_data_type_compatible (_tmp89_, _tmp91_);
			} else {
				_tmp86_ = FALSE;
			}
			if (_tmp86_) {
				_tmp85_ = !VALA_IS_NULL_LITERAL (arg);
			} else {
				_tmp85_ = FALSE;
			}
			if (_tmp85_) {
				ValaSourceReference* _tmp92_;
				ValaSourceReference* _tmp93_;
				ValaDataType* _tmp94_;
				ValaDataType* _tmp95_;
				gchar* _tmp96_;
				gchar* _tmp97_;
				ValaDataType* _tmp98_;
				ValaDataType* _tmp99_;
				gchar* _tmp100_;
				gchar* _tmp101_;
				_tmp92_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
				_tmp93_ = _tmp92_;
				_tmp94_ = vala_expression_get_target_type (arg);
				_tmp95_ = _tmp94_;
				_tmp96_ = vala_data_type_to_prototype_string (_tmp95_, NULL);
				_tmp97_ = _tmp96_;
				_tmp98_ = vala_expression_get_value_type (arg);
				_tmp99_ = _tmp98_;
				_tmp100_ = vala_data_type_to_prototype_string (_tmp99_, NULL);
				_tmp101_ = _tmp100_;
				vala_report_error (_tmp93_, "Argument %d: Cannot convert from `%s' to `%s'", i + 1, _tmp97_, _tmp101_);
				_g_free0 (_tmp101_);
				_g_free0 (_tmp97_);
				result = FALSE;
				return result;
			}
		}
	}
	ma = VALA_IS_MEMBER_ACCESS (arg) ? ((ValaMemberAccess*) arg) : NULL;
	_tmp103_ = ma;
	if (_tmp103_ != NULL) {
		ValaMemberAccess* _tmp104_;
		gboolean _tmp105_;
		gboolean _tmp106_;
		_tmp104_ = ma;
		_tmp105_ = vala_member_access_get_prototype_access (_tmp104_);
		_tmp106_ = _tmp105_;
		_tmp102_ = _tmp106_;
	} else {
		_tmp102_ = FALSE;
	}
	if (_tmp102_) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp107_;
		ValaDataType* _tmp108_;
		gboolean _tmp109_ = FALSE;
		ValaDelegateType* _tmp110_;
		_tmp107_ = vala_expression_get_target_type (arg);
		_tmp108_ = _tmp107_;
		deleg_type = VALA_IS_DELEGATE_TYPE (_tmp108_) ? ((ValaDelegateType*) _tmp108_) : NULL;
		_tmp110_ = deleg_type;
		if (_tmp110_ == NULL) {
			_tmp109_ = TRUE;
		} else {
			ValaDelegateType* _tmp111_;
			ValaDelegate* _tmp112_;
			ValaDelegate* _tmp113_;
			gboolean _tmp114_;
			gboolean _tmp115_;
			_tmp111_ = deleg_type;
			_tmp112_ = vala_delegate_type_get_delegate_symbol (_tmp111_);
			_tmp113_ = _tmp112_;
			_tmp114_ = vala_delegate_get_has_target (_tmp113_);
			_tmp115_ = _tmp114_;
			_tmp109_ = _tmp115_;
		}
		if (_tmp109_) {
			ValaSourceReference* _tmp116_;
			ValaSourceReference* _tmp117_;
			ValaSymbol* _tmp118_;
			ValaSymbol* _tmp119_;
			gchar* _tmp120_;
			gchar* _tmp121_;
			_tmp116_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
			_tmp117_ = _tmp116_;
			_tmp118_ = vala_expression_get_symbol_reference (arg);
			_tmp119_ = _tmp118_;
			_tmp120_ = vala_symbol_get_full_name (_tmp119_);
			_tmp121_ = _tmp120_;
			vala_report_error (_tmp117_, "Access to instance member `%s' denied", _tmp121_);
			_g_free0 (_tmp121_);
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}

gboolean
vala_semantic_analyzer_check_variadic_arguments (ValaSemanticAnalyzer* self,
                                                 ValaIterator* arg_it,
                                                 gint i,
                                                 ValaSourceReference* source_reference)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		ValaExpression* arg = NULL;
		gpointer _tmp1_;
		ValaExpression* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gint _tmp41_;
		if (arg_it != NULL) {
			_tmp0_ = vala_iterator_next (arg_it);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp1_ = vala_iterator_get (arg_it);
		arg = (ValaExpression*) _tmp1_;
		_tmp2_ = arg;
		_tmp3_ = vala_code_node_get_error ((ValaCodeNode*) _tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			result = FALSE;
			_vala_code_node_unref0 (arg);
			return result;
		} else {
			ValaExpression* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			_tmp5_ = arg;
			_tmp6_ = vala_expression_get_value_type (_tmp5_);
			_tmp7_ = _tmp6_;
			if (VALA_IS_SIGNAL_TYPE (_tmp7_)) {
				ValaExpression* _tmp8_;
				ValaExpression* _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaSourceReference* _tmp11_;
				_tmp8_ = arg;
				vala_code_node_set_error ((ValaCodeNode*) _tmp8_, TRUE);
				_tmp9_ = arg;
				_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp9_);
				_tmp11_ = _tmp10_;
				vala_report_error (_tmp11_, "Cannot pass signals as arguments");
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			} else {
				ValaExpression* _tmp12_;
				ValaDataType* _tmp13_;
				ValaDataType* _tmp14_;
				_tmp12_ = arg;
				_tmp13_ = vala_expression_get_value_type (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ == NULL) {
					ValaExpression* _tmp15_;
					ValaSymbol* _tmp16_;
					ValaSymbol* _tmp17_;
					_tmp15_ = arg;
					_tmp16_ = vala_expression_get_symbol_reference (_tmp15_);
					_tmp17_ = _tmp16_;
					if (!VALA_IS_METHOD (_tmp17_)) {
						vala_report_error (source_reference, "Invalid type for argument %d", i + 1);
						result = FALSE;
						_vala_code_node_unref0 (arg);
						return result;
					}
				} else {
					gboolean _tmp18_ = FALSE;
					ValaExpression* _tmp19_;
					ValaDataType* _tmp20_;
					ValaDataType* _tmp21_;
					_tmp19_ = arg;
					_tmp20_ = vala_expression_get_target_type (_tmp19_);
					_tmp21_ = _tmp20_;
					if (_tmp21_ != NULL) {
						ValaExpression* _tmp22_;
						ValaDataType* _tmp23_;
						ValaDataType* _tmp24_;
						ValaExpression* _tmp25_;
						ValaDataType* _tmp26_;
						ValaDataType* _tmp27_;
						_tmp22_ = arg;
						_tmp23_ = vala_expression_get_value_type (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = arg;
						_tmp26_ = vala_expression_get_target_type (_tmp25_);
						_tmp27_ = _tmp26_;
						_tmp18_ = !vala_data_type_compatible (_tmp24_, _tmp27_);
					} else {
						_tmp18_ = FALSE;
					}
					if (_tmp18_) {
						ValaExpression* _tmp28_;
						ValaSourceReference* _tmp29_;
						ValaSourceReference* _tmp30_;
						ValaExpression* _tmp31_;
						ValaDataType* _tmp32_;
						ValaDataType* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						ValaExpression* _tmp36_;
						ValaDataType* _tmp37_;
						ValaDataType* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						_tmp28_ = arg;
						_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = arg;
						_tmp32_ = vala_expression_get_value_type (_tmp31_);
						_tmp33_ = _tmp32_;
						_tmp34_ = vala_code_node_to_string ((ValaCodeNode*) _tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = arg;
						_tmp37_ = vala_expression_get_target_type (_tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = vala_code_node_to_string ((ValaCodeNode*) _tmp38_);
						_tmp40_ = _tmp39_;
						vala_report_error (_tmp30_, "Argument %d: Cannot convert from `%s' to `%s'", i + 1, _tmp35_, _tmp40_);
						_g_free0 (_tmp40_);
						_g_free0 (_tmp35_);
						result = FALSE;
						_vala_code_node_unref0 (arg);
						return result;
					}
				}
			}
		}
		_tmp41_ = i;
		i = _tmp41_ + 1;
		_vala_code_node_unref0 (arg);
	}
	result = TRUE;
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

gboolean
vala_semantic_analyzer_check_print_format (ValaSemanticAnalyzer* self,
                                           const gchar* format,
                                           ValaIterator* arg_it,
                                           ValaSourceReference* source_reference)
{
	gboolean unsupported_format = FALSE;
	const gchar* format_it = NULL;
	gunichar c = 0U;
	const gchar* _tmp0_;
	gboolean _tmp83_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (format != NULL, FALSE);
	g_return_val_if_fail (arg_it != NULL, FALSE);
	unsupported_format = FALSE;
	format_it = format;
	_tmp0_ = format_it;
	c = string_get_char (_tmp0_, (glong) 0);
	while (TRUE) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint length = 0;
		ValaDataType* param_type = NULL;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		ValaDataType* _tmp79_;
		if (!(c != ((gunichar) '\0'))) {
			break;
		}
		if (c != ((gunichar) '%')) {
			const gchar* _tmp1_;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			_tmp1_ = format_it;
			_tmp2_ = g_utf8_next_char (_tmp1_);
			format_it = _tmp2_;
			_tmp3_ = format_it;
			c = string_get_char (_tmp3_, (glong) 0);
			continue;
		}
		_tmp4_ = format_it;
		_tmp5_ = g_utf8_next_char (_tmp4_);
		format_it = _tmp5_;
		_tmp6_ = format_it;
		c = string_get_char (_tmp6_, (glong) 0);
		while (TRUE) {
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			if (c == ((gunichar) '#')) {
				_tmp10_ = TRUE;
			} else {
				_tmp10_ = c == ((gunichar) '0');
			}
			if (_tmp10_) {
				_tmp9_ = TRUE;
			} else {
				_tmp9_ = c == ((gunichar) '-');
			}
			if (_tmp9_) {
				_tmp8_ = TRUE;
			} else {
				_tmp8_ = c == ((gunichar) ' ');
			}
			if (_tmp8_) {
				_tmp7_ = TRUE;
			} else {
				_tmp7_ = c == ((gunichar) '+');
			}
			if (!_tmp7_) {
				break;
			}
			_tmp11_ = format_it;
			_tmp12_ = g_utf8_next_char (_tmp11_);
			format_it = _tmp12_;
			_tmp13_ = format_it;
			c = string_get_char (_tmp13_, (glong) 0);
		}
		while (TRUE) {
			gboolean _tmp14_ = FALSE;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			if (c >= ((gunichar) '0')) {
				_tmp14_ = c <= ((gunichar) '9');
			} else {
				_tmp14_ = FALSE;
			}
			if (!_tmp14_) {
				break;
			}
			_tmp15_ = format_it;
			_tmp16_ = g_utf8_next_char (_tmp15_);
			format_it = _tmp16_;
			_tmp17_ = format_it;
			c = string_get_char (_tmp17_, (glong) 0);
		}
		if (c == ((gunichar) '.')) {
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = format_it;
			_tmp19_ = g_utf8_next_char (_tmp18_);
			format_it = _tmp19_;
			_tmp20_ = format_it;
			c = string_get_char (_tmp20_, (glong) 0);
			while (TRUE) {
				gboolean _tmp21_ = FALSE;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				if (c >= ((gunichar) '0')) {
					_tmp21_ = c <= ((gunichar) '9');
				} else {
					_tmp21_ = FALSE;
				}
				if (!_tmp21_) {
					break;
				}
				_tmp22_ = format_it;
				_tmp23_ = g_utf8_next_char (_tmp22_);
				format_it = _tmp23_;
				_tmp24_ = format_it;
				c = string_get_char (_tmp24_, (glong) 0);
			}
		}
		length = 0;
		if (c == ((gunichar) 'h')) {
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			length = -1;
			_tmp25_ = format_it;
			_tmp26_ = g_utf8_next_char (_tmp25_);
			format_it = _tmp26_;
			_tmp27_ = format_it;
			c = string_get_char (_tmp27_, (glong) 0);
			if (c == ((gunichar) 'h')) {
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				length = -2;
				_tmp28_ = format_it;
				_tmp29_ = g_utf8_next_char (_tmp28_);
				format_it = _tmp29_;
				_tmp30_ = format_it;
				c = string_get_char (_tmp30_, (glong) 0);
			}
		} else {
			if (c == ((gunichar) 'l')) {
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				length = 1;
				_tmp31_ = format_it;
				_tmp32_ = g_utf8_next_char (_tmp31_);
				format_it = _tmp32_;
				_tmp33_ = format_it;
				c = string_get_char (_tmp33_, (glong) 0);
			} else {
				if (c == ((gunichar) 'z')) {
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					length = 2;
					_tmp34_ = format_it;
					_tmp35_ = g_utf8_next_char (_tmp34_);
					format_it = _tmp35_;
					_tmp36_ = format_it;
					c = string_get_char (_tmp36_, (glong) 0);
				}
			}
		}
		param_type = NULL;
		if (c == ((gunichar) 'd')) {
			_tmp38_ = TRUE;
		} else {
			_tmp38_ = c == ((gunichar) 'i');
		}
		if (_tmp38_) {
			_tmp37_ = TRUE;
		} else {
			_tmp37_ = c == ((gunichar) 'c');
		}
		if (_tmp37_) {
			if (length == -2) {
				ValaDataType* _tmp39_;
				ValaDataType* _tmp40_;
				_tmp39_ = self->int8_type;
				_tmp40_ = _vala_code_node_ref0 (_tmp39_);
				_vala_code_node_unref0 (param_type);
				param_type = _tmp40_;
			} else {
				if (length == -1) {
					ValaDataType* _tmp41_;
					ValaDataType* _tmp42_;
					_tmp41_ = self->short_type;
					_tmp42_ = _vala_code_node_ref0 (_tmp41_);
					_vala_code_node_unref0 (param_type);
					param_type = _tmp42_;
				} else {
					if (length == 0) {
						ValaDataType* _tmp43_;
						ValaDataType* _tmp44_;
						_tmp43_ = self->int_type;
						_tmp44_ = _vala_code_node_ref0 (_tmp43_);
						_vala_code_node_unref0 (param_type);
						param_type = _tmp44_;
					} else {
						if (length == 1) {
							ValaDataType* _tmp45_;
							ValaDataType* _tmp46_;
							_tmp45_ = self->long_type;
							_tmp46_ = _vala_code_node_ref0 (_tmp45_);
							_vala_code_node_unref0 (param_type);
							param_type = _tmp46_;
						} else {
							if (length == 2) {
								ValaDataType* _tmp47_;
								ValaDataType* _tmp48_;
								_tmp47_ = self->ssize_t_type;
								_tmp48_ = _vala_code_node_ref0 (_tmp47_);
								_vala_code_node_unref0 (param_type);
								param_type = _tmp48_;
							}
						}
					}
				}
			}
		} else {
			gboolean _tmp49_ = FALSE;
			gboolean _tmp50_ = FALSE;
			gboolean _tmp51_ = FALSE;
			if (c == ((gunichar) 'o')) {
				_tmp51_ = TRUE;
			} else {
				_tmp51_ = c == ((gunichar) 'u');
			}
			if (_tmp51_) {
				_tmp50_ = TRUE;
			} else {
				_tmp50_ = c == ((gunichar) 'x');
			}
			if (_tmp50_) {
				_tmp49_ = TRUE;
			} else {
				_tmp49_ = c == ((gunichar) 'X');
			}
			if (_tmp49_) {
				if (length == -2) {
					ValaDataType* _tmp52_;
					ValaDataType* _tmp53_;
					_tmp52_ = self->uchar_type;
					_tmp53_ = _vala_code_node_ref0 (_tmp52_);
					_vala_code_node_unref0 (param_type);
					param_type = _tmp53_;
				} else {
					if (length == -1) {
						ValaDataType* _tmp54_;
						ValaDataType* _tmp55_;
						_tmp54_ = self->ushort_type;
						_tmp55_ = _vala_code_node_ref0 (_tmp54_);
						_vala_code_node_unref0 (param_type);
						param_type = _tmp55_;
					} else {
						if (length == 0) {
							ValaDataType* _tmp56_;
							ValaDataType* _tmp57_;
							_tmp56_ = self->uint_type;
							_tmp57_ = _vala_code_node_ref0 (_tmp56_);
							_vala_code_node_unref0 (param_type);
							param_type = _tmp57_;
						} else {
							if (length == 1) {
								ValaDataType* _tmp58_;
								ValaDataType* _tmp59_;
								_tmp58_ = self->ulong_type;
								_tmp59_ = _vala_code_node_ref0 (_tmp58_);
								_vala_code_node_unref0 (param_type);
								param_type = _tmp59_;
							} else {
								if (length == 2) {
									ValaDataType* _tmp60_;
									ValaDataType* _tmp61_;
									_tmp60_ = self->size_t_type;
									_tmp61_ = _vala_code_node_ref0 (_tmp60_);
									_vala_code_node_unref0 (param_type);
									param_type = _tmp61_;
								}
							}
						}
					}
				}
			} else {
				gboolean _tmp62_ = FALSE;
				gboolean _tmp63_ = FALSE;
				gboolean _tmp64_ = FALSE;
				gboolean _tmp65_ = FALSE;
				gboolean _tmp66_ = FALSE;
				gboolean _tmp67_ = FALSE;
				gboolean _tmp68_ = FALSE;
				if (c == ((gunichar) 'e')) {
					_tmp68_ = TRUE;
				} else {
					_tmp68_ = c == ((gunichar) 'E');
				}
				if (_tmp68_) {
					_tmp67_ = TRUE;
				} else {
					_tmp67_ = c == ((gunichar) 'f');
				}
				if (_tmp67_) {
					_tmp66_ = TRUE;
				} else {
					_tmp66_ = c == ((gunichar) 'F');
				}
				if (_tmp66_) {
					_tmp65_ = TRUE;
				} else {
					_tmp65_ = c == ((gunichar) 'g');
				}
				if (_tmp65_) {
					_tmp64_ = TRUE;
				} else {
					_tmp64_ = c == ((gunichar) 'G');
				}
				if (_tmp64_) {
					_tmp63_ = TRUE;
				} else {
					_tmp63_ = c == ((gunichar) 'a');
				}
				if (_tmp63_) {
					_tmp62_ = TRUE;
				} else {
					_tmp62_ = c == ((gunichar) 'A');
				}
				if (_tmp62_) {
					ValaDataType* _tmp69_;
					ValaDataType* _tmp70_;
					_tmp69_ = self->double_type;
					_tmp70_ = _vala_code_node_ref0 (_tmp69_);
					_vala_code_node_unref0 (param_type);
					param_type = _tmp70_;
				} else {
					if (c == ((gunichar) 's')) {
						ValaDataType* _tmp71_;
						ValaDataType* _tmp72_;
						_tmp71_ = self->string_type;
						_tmp72_ = _vala_code_node_ref0 (_tmp71_);
						_vala_code_node_unref0 (param_type);
						param_type = _tmp72_;
					} else {
						if (c == ((gunichar) 'p')) {
							ValaVoidType* _tmp73_;
							ValaVoidType* _tmp74_;
							ValaPointerType* _tmp75_;
							_tmp73_ = vala_void_type_new (NULL);
							_tmp74_ = _tmp73_;
							_tmp75_ = vala_pointer_type_new ((ValaDataType*) _tmp74_, NULL);
							_vala_code_node_unref0 (param_type);
							param_type = (ValaDataType*) _tmp75_;
							_vala_code_node_unref0 (_tmp74_);
						} else {
							if (c == ((gunichar) '%')) {
							} else {
								unsupported_format = TRUE;
								_vala_code_node_unref0 (param_type);
								break;
							}
						}
					}
				}
			}
		}
		if (c != ((gunichar) '\0')) {
			const gchar* _tmp76_;
			const gchar* _tmp77_;
			const gchar* _tmp78_;
			_tmp76_ = format_it;
			_tmp77_ = g_utf8_next_char (_tmp76_);
			format_it = _tmp77_;
			_tmp78_ = format_it;
			c = string_get_char (_tmp78_, (glong) 0);
		}
		_tmp79_ = param_type;
		if (_tmp79_ != NULL) {
			if (vala_iterator_next (arg_it)) {
				ValaExpression* arg = NULL;
				gpointer _tmp80_;
				ValaExpression* _tmp81_;
				ValaDataType* _tmp82_;
				_tmp80_ = vala_iterator_get (arg_it);
				arg = (ValaExpression*) _tmp80_;
				_tmp81_ = arg;
				_tmp82_ = param_type;
				vala_expression_set_target_type (_tmp81_, _tmp82_);
				_vala_code_node_unref0 (arg);
			} else {
				vala_report_error (source_reference, "Too few arguments for specified format");
				result = FALSE;
				_vala_code_node_unref0 (param_type);
				return result;
			}
		}
		_vala_code_node_unref0 (param_type);
	}
	if (!unsupported_format) {
		_tmp83_ = vala_iterator_next (arg_it);
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		vala_report_error (source_reference, "Too many arguments for specified format");
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static ValaDataType*
vala_semantic_analyzer_get_instance_base_type (ValaDataType* instance_type,
                                               ValaDataType* base_type,
                                               ValaCodeNode* node_reference)
{
	ValaDataType* instance_base_type = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaDataType* result = NULL;
	g_return_val_if_fail (instance_type != NULL, NULL);
	g_return_val_if_fail (base_type != NULL, NULL);
	_tmp0_ = vala_data_type_get_type_symbol (base_type);
	_tmp1_ = _tmp0_;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1_)) {
		ValaTypeSymbol* _tmp2_;
		ValaTypeSymbol* _tmp3_;
		ValaObjectType* _tmp4_;
		_tmp2_ = vala_data_type_get_type_symbol (base_type);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		_vala_code_node_unref0 (instance_base_type);
		instance_base_type = (ValaDataType*) _tmp4_;
	} else {
		ValaTypeSymbol* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		_tmp5_ = vala_data_type_get_type_symbol (base_type);
		_tmp6_ = _tmp5_;
		if (VALA_IS_STRUCT (_tmp6_)) {
			ValaTypeSymbol* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaStructValueType* _tmp9_;
			_tmp7_ = vala_data_type_get_type_symbol (base_type);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct));
			_vala_code_node_unref0 (instance_base_type);
			instance_base_type = (ValaDataType*) _tmp9_;
		} else {
			g_assert_not_reached ();
		}
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp10_;
		gint _type_arg_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _type_arg_index = 0;
		_tmp10_ = vala_data_type_get_type_arguments (base_type);
		_type_arg_list = _tmp10_;
		_tmp11_ = _type_arg_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_type_arg_size = _tmp13_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			ValaDataType* _tmp20_;
			ValaDataType* _tmp21_;
			_type_arg_index = _type_arg_index + 1;
			_tmp14_ = _type_arg_index;
			_tmp15_ = _type_arg_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _type_arg_list;
			_tmp17_ = vala_list_get (_tmp16_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp17_;
			_tmp18_ = type_arg;
			_tmp19_ = vala_data_type_get_actual_type (_tmp18_, instance_type, NULL, node_reference);
			_vala_code_node_unref0 (type_arg);
			type_arg = _tmp19_;
			_tmp20_ = instance_base_type;
			_tmp21_ = type_arg;
			vala_data_type_add_type_argument (_tmp20_, _tmp21_);
			_vala_code_node_unref0 (type_arg);
		}
	}
	result = instance_base_type;
	return result;
}

 G_GNUC_INTERNAL ValaDataType*
vala_semantic_analyzer_get_instance_base_type_for_member (ValaDataType* derived_instance_type,
                                                          ValaTypeSymbol* type_symbol,
                                                          ValaCodeNode* node_reference)
{
	ValaDataType* instance_type = NULL;
	ValaDataType* _tmp0_;
	gboolean _tmp7_ = FALSE;
	ValaDataType* _tmp8_;
	ValaDataType* instance_base_type = NULL;
	ValaDataType* _tmp15_;
	ValaTypeSymbol* _tmp16_;
	ValaTypeSymbol* _tmp17_;
	ValaDataType* result = NULL;
	g_return_val_if_fail (derived_instance_type != NULL, NULL);
	g_return_val_if_fail (type_symbol != NULL, NULL);
	_tmp0_ = _vala_code_node_ref0 (derived_instance_type);
	instance_type = _tmp0_;
	while (TRUE) {
		ValaDataType* _tmp1_;
		ValaPointerType* instance_pointer_type = NULL;
		ValaDataType* _tmp2_;
		ValaPointerType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		_tmp1_ = instance_type;
		if (!VALA_IS_POINTER_TYPE (_tmp1_)) {
			break;
		}
		_tmp2_ = instance_type;
		instance_pointer_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALA_TYPE_POINTER_TYPE, ValaPointerType);
		_tmp3_ = instance_pointer_type;
		_tmp4_ = vala_pointer_type_get_base_type (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (_tmp5_);
		_vala_code_node_unref0 (instance_type);
		instance_type = _tmp6_;
	}
	_tmp8_ = instance_type;
	if (VALA_IS_DELEGATE_TYPE (_tmp8_)) {
		ValaDataType* _tmp9_;
		ValaDelegate* _tmp10_;
		ValaDelegate* _tmp11_;
		_tmp9_ = instance_type;
		_tmp10_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		_tmp11_ = _tmp10_;
		_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == type_symbol;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		result = instance_type;
		return result;
	} else {
		ValaDataType* _tmp12_;
		ValaTypeSymbol* _tmp13_;
		ValaTypeSymbol* _tmp14_;
		_tmp12_ = instance_type;
		_tmp13_ = vala_data_type_get_type_symbol (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ == type_symbol) {
			result = instance_type;
			return result;
		}
	}
	instance_base_type = NULL;
	_tmp15_ = instance_type;
	_tmp16_ = vala_data_type_get_type_symbol (_tmp15_);
	_tmp17_ = _tmp16_;
	if (VALA_IS_CLASS (_tmp17_)) {
		ValaClass* cl = NULL;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaDataType* _tmp39_;
		_tmp18_ = instance_type;
		_tmp19_ = vala_data_type_get_type_symbol (_tmp18_);
		_tmp20_ = _tmp19_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_CLASS, ValaClass);
		{
			ValaList* _base_type_list = NULL;
			ValaClass* _tmp21_;
			ValaList* _tmp22_;
			gint _base_type_size = 0;
			ValaList* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gint _base_type_index = 0;
			_tmp21_ = cl;
			_tmp22_ = vala_class_get_base_types (_tmp21_);
			_base_type_list = _tmp22_;
			_tmp23_ = _base_type_list;
			_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
			_tmp25_ = _tmp24_;
			_base_type_size = _tmp25_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp26_;
				gint _tmp27_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp28_;
				gpointer _tmp29_;
				ValaDataType* _tmp30_;
				ValaTypeSymbol* _tmp31_;
				ValaTypeSymbol* _tmp32_;
				_base_type_index = _base_type_index + 1;
				_tmp26_ = _base_type_index;
				_tmp27_ = _base_type_size;
				if (!(_tmp26_ < _tmp27_)) {
					break;
				}
				_tmp28_ = _base_type_list;
				_tmp29_ = vala_list_get (_tmp28_, _base_type_index);
				base_type = (ValaDataType*) _tmp29_;
				_tmp30_ = base_type;
				_tmp31_ = vala_data_type_get_type_symbol (_tmp30_);
				_tmp32_ = _tmp31_;
				if (VALA_IS_INTERFACE (_tmp32_)) {
					ValaDataType* _tmp33_;
					ValaDataType* _tmp34_;
					ValaDataType* _tmp35_;
					ValaDataType* _tmp36_;
					ValaDataType* _tmp37_;
					ValaDataType* _tmp38_;
					_tmp33_ = instance_type;
					_tmp34_ = base_type;
					_tmp35_ = vala_semantic_analyzer_get_instance_base_type (_tmp33_, _tmp34_, node_reference);
					_tmp36_ = _tmp35_;
					_tmp37_ = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp36_, type_symbol, node_reference);
					_vala_code_node_unref0 (instance_base_type);
					instance_base_type = _tmp37_;
					_vala_code_node_unref0 (_tmp36_);
					_tmp38_ = instance_base_type;
					if (_tmp38_ != NULL) {
						result = instance_base_type;
						_vala_code_node_unref0 (base_type);
						_vala_code_node_unref0 (instance_type);
						return result;
					}
				}
				_vala_code_node_unref0 (base_type);
			}
		}
		_tmp39_ = instance_base_type;
		if (_tmp39_ == NULL) {
			{
				ValaList* _base_type_list = NULL;
				ValaClass* _tmp40_;
				ValaList* _tmp41_;
				gint _base_type_size = 0;
				ValaList* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				gint _base_type_index = 0;
				_tmp40_ = cl;
				_tmp41_ = vala_class_get_base_types (_tmp40_);
				_base_type_list = _tmp41_;
				_tmp42_ = _base_type_list;
				_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
				_tmp44_ = _tmp43_;
				_base_type_size = _tmp44_;
				_base_type_index = -1;
				while (TRUE) {
					gint _tmp45_;
					gint _tmp46_;
					ValaDataType* base_type = NULL;
					ValaList* _tmp47_;
					gpointer _tmp48_;
					ValaDataType* _tmp49_;
					ValaTypeSymbol* _tmp50_;
					ValaTypeSymbol* _tmp51_;
					_base_type_index = _base_type_index + 1;
					_tmp45_ = _base_type_index;
					_tmp46_ = _base_type_size;
					if (!(_tmp45_ < _tmp46_)) {
						break;
					}
					_tmp47_ = _base_type_list;
					_tmp48_ = vala_list_get (_tmp47_, _base_type_index);
					base_type = (ValaDataType*) _tmp48_;
					_tmp49_ = base_type;
					_tmp50_ = vala_data_type_get_type_symbol (_tmp49_);
					_tmp51_ = _tmp50_;
					if (VALA_IS_CLASS (_tmp51_)) {
						ValaDataType* _tmp52_;
						ValaDataType* _tmp53_;
						ValaDataType* _tmp54_;
						ValaDataType* _tmp55_;
						ValaDataType* _tmp56_;
						ValaDataType* _tmp57_;
						_tmp52_ = instance_type;
						_tmp53_ = base_type;
						_tmp54_ = vala_semantic_analyzer_get_instance_base_type (_tmp52_, _tmp53_, node_reference);
						_tmp55_ = _tmp54_;
						_tmp56_ = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp55_, type_symbol, node_reference);
						_vala_code_node_unref0 (instance_base_type);
						instance_base_type = _tmp56_;
						_vala_code_node_unref0 (_tmp55_);
						_tmp57_ = instance_base_type;
						if (_tmp57_ != NULL) {
							result = instance_base_type;
							_vala_code_node_unref0 (base_type);
							_vala_code_node_unref0 (instance_type);
							return result;
						}
					}
					_vala_code_node_unref0 (base_type);
				}
			}
		}
	} else {
		ValaDataType* _tmp58_;
		ValaTypeSymbol* _tmp59_;
		ValaTypeSymbol* _tmp60_;
		_tmp58_ = instance_type;
		_tmp59_ = vala_data_type_get_type_symbol (_tmp58_);
		_tmp60_ = _tmp59_;
		if (VALA_IS_STRUCT (_tmp60_)) {
			ValaStruct* st = NULL;
			ValaDataType* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			ValaTypeSymbol* _tmp63_;
			ValaStruct* _tmp64_;
			ValaDataType* _tmp65_;
			ValaDataType* _tmp66_;
			_tmp61_ = instance_type;
			_tmp62_ = vala_data_type_get_type_symbol (_tmp61_);
			_tmp63_ = _tmp62_;
			st = G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_STRUCT, ValaStruct);
			_tmp64_ = st;
			_tmp65_ = vala_struct_get_base_type (_tmp64_);
			_tmp66_ = _tmp65_;
			if (_tmp66_ != NULL) {
				ValaDataType* _tmp67_;
				ValaStruct* _tmp68_;
				ValaDataType* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				ValaDataType* _tmp73_;
				ValaDataType* _tmp74_;
				_tmp67_ = instance_type;
				_tmp68_ = st;
				_tmp69_ = vala_struct_get_base_type (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_semantic_analyzer_get_instance_base_type (_tmp67_, _tmp70_, node_reference);
				_tmp72_ = _tmp71_;
				_tmp73_ = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp72_, type_symbol, node_reference);
				_vala_code_node_unref0 (instance_base_type);
				instance_base_type = _tmp73_;
				_vala_code_node_unref0 (_tmp72_);
				_tmp74_ = instance_base_type;
				if (_tmp74_ != NULL) {
					result = instance_base_type;
					_vala_code_node_unref0 (instance_type);
					return result;
				}
			}
		} else {
			ValaDataType* _tmp75_;
			ValaTypeSymbol* _tmp76_;
			ValaTypeSymbol* _tmp77_;
			_tmp75_ = instance_type;
			_tmp76_ = vala_data_type_get_type_symbol (_tmp75_);
			_tmp77_ = _tmp76_;
			if (VALA_IS_INTERFACE (_tmp77_)) {
				ValaInterface* iface = NULL;
				ValaDataType* _tmp78_;
				ValaTypeSymbol* _tmp79_;
				ValaTypeSymbol* _tmp80_;
				ValaDataType* _tmp99_;
				_tmp78_ = instance_type;
				_tmp79_ = vala_data_type_get_type_symbol (_tmp78_);
				_tmp80_ = _tmp79_;
				iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_INTERFACE, ValaInterface);
				{
					ValaList* _prerequisite_list = NULL;
					ValaInterface* _tmp81_;
					ValaList* _tmp82_;
					gint _prerequisite_size = 0;
					ValaList* _tmp83_;
					gint _tmp84_;
					gint _tmp85_;
					gint _prerequisite_index = 0;
					_tmp81_ = iface;
					_tmp82_ = vala_interface_get_prerequisites (_tmp81_);
					_prerequisite_list = _tmp82_;
					_tmp83_ = _prerequisite_list;
					_tmp84_ = vala_collection_get_size ((ValaCollection*) _tmp83_);
					_tmp85_ = _tmp84_;
					_prerequisite_size = _tmp85_;
					_prerequisite_index = -1;
					while (TRUE) {
						gint _tmp86_;
						gint _tmp87_;
						ValaDataType* prerequisite = NULL;
						ValaList* _tmp88_;
						gpointer _tmp89_;
						ValaDataType* _tmp90_;
						ValaTypeSymbol* _tmp91_;
						ValaTypeSymbol* _tmp92_;
						_prerequisite_index = _prerequisite_index + 1;
						_tmp86_ = _prerequisite_index;
						_tmp87_ = _prerequisite_size;
						if (!(_tmp86_ < _tmp87_)) {
							break;
						}
						_tmp88_ = _prerequisite_list;
						_tmp89_ = vala_list_get (_tmp88_, _prerequisite_index);
						prerequisite = (ValaDataType*) _tmp89_;
						_tmp90_ = prerequisite;
						_tmp91_ = vala_data_type_get_type_symbol (_tmp90_);
						_tmp92_ = _tmp91_;
						if (VALA_IS_INTERFACE (_tmp92_)) {
							ValaDataType* _tmp93_;
							ValaDataType* _tmp94_;
							ValaDataType* _tmp95_;
							ValaDataType* _tmp96_;
							ValaDataType* _tmp97_;
							ValaDataType* _tmp98_;
							_tmp93_ = instance_type;
							_tmp94_ = prerequisite;
							_tmp95_ = vala_semantic_analyzer_get_instance_base_type (_tmp93_, _tmp94_, node_reference);
							_tmp96_ = _tmp95_;
							_tmp97_ = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp96_, type_symbol, node_reference);
							_vala_code_node_unref0 (instance_base_type);
							instance_base_type = _tmp97_;
							_vala_code_node_unref0 (_tmp96_);
							_tmp98_ = instance_base_type;
							if (_tmp98_ != NULL) {
								result = instance_base_type;
								_vala_code_node_unref0 (prerequisite);
								_vala_code_node_unref0 (instance_type);
								return result;
							}
						}
						_vala_code_node_unref0 (prerequisite);
					}
				}
				_tmp99_ = instance_base_type;
				if (_tmp99_ == NULL) {
					{
						ValaList* _prerequisite_list = NULL;
						ValaInterface* _tmp100_;
						ValaList* _tmp101_;
						gint _prerequisite_size = 0;
						ValaList* _tmp102_;
						gint _tmp103_;
						gint _tmp104_;
						gint _prerequisite_index = 0;
						_tmp100_ = iface;
						_tmp101_ = vala_interface_get_prerequisites (_tmp100_);
						_prerequisite_list = _tmp101_;
						_tmp102_ = _prerequisite_list;
						_tmp103_ = vala_collection_get_size ((ValaCollection*) _tmp102_);
						_tmp104_ = _tmp103_;
						_prerequisite_size = _tmp104_;
						_prerequisite_index = -1;
						while (TRUE) {
							gint _tmp105_;
							gint _tmp106_;
							ValaDataType* prerequisite = NULL;
							ValaList* _tmp107_;
							gpointer _tmp108_;
							ValaDataType* _tmp109_;
							ValaTypeSymbol* _tmp110_;
							ValaTypeSymbol* _tmp111_;
							_prerequisite_index = _prerequisite_index + 1;
							_tmp105_ = _prerequisite_index;
							_tmp106_ = _prerequisite_size;
							if (!(_tmp105_ < _tmp106_)) {
								break;
							}
							_tmp107_ = _prerequisite_list;
							_tmp108_ = vala_list_get (_tmp107_, _prerequisite_index);
							prerequisite = (ValaDataType*) _tmp108_;
							_tmp109_ = prerequisite;
							_tmp110_ = vala_data_type_get_type_symbol (_tmp109_);
							_tmp111_ = _tmp110_;
							if (VALA_IS_CLASS (_tmp111_)) {
								ValaDataType* _tmp112_;
								ValaDataType* _tmp113_;
								ValaDataType* _tmp114_;
								ValaDataType* _tmp115_;
								ValaDataType* _tmp116_;
								ValaDataType* _tmp117_;
								_tmp112_ = instance_type;
								_tmp113_ = prerequisite;
								_tmp114_ = vala_semantic_analyzer_get_instance_base_type (_tmp112_, _tmp113_, node_reference);
								_tmp115_ = _tmp114_;
								_tmp116_ = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp115_, type_symbol, node_reference);
								_vala_code_node_unref0 (instance_base_type);
								instance_base_type = _tmp116_;
								_vala_code_node_unref0 (_tmp115_);
								_tmp117_ = instance_base_type;
								if (_tmp117_ != NULL) {
									result = instance_base_type;
									_vala_code_node_unref0 (prerequisite);
									_vala_code_node_unref0 (instance_type);
									return result;
								}
							}
							_vala_code_node_unref0 (prerequisite);
						}
					}
				}
			}
		}
	}
	result = NULL;
	_vala_code_node_unref0 (instance_base_type);
	_vala_code_node_unref0 (instance_type);
	return result;
}

ValaDataType*
vala_semantic_analyzer_get_actual_type (ValaDataType* derived_instance_type,
                                        ValaList* method_type_arguments,
                                        ValaGenericType* generic_type,
                                        ValaCodeNode* node_reference)
{
	ValaDataType* actual_type = NULL;
	ValaTypeParameter* _tmp0_;
	ValaTypeParameter* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaDataType* _tmp67_;
	ValaDataType* _tmp69_;
	ValaDataType* _tmp70_;
	ValaDataType* _tmp71_;
	ValaSourceReference* _tmp72_;
	ValaSourceReference* _tmp73_;
	gboolean _tmp74_ = FALSE;
	ValaDataType* _tmp75_;
	gboolean _tmp76_;
	gboolean _tmp77_;
	ValaDataType* _tmp80_;
	ValaDataType* result = NULL;
	g_return_val_if_fail (generic_type != NULL, NULL);
	actual_type = NULL;
	_tmp0_ = vala_generic_type_get_type_parameter (generic_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (VALA_IS_TYPESYMBOL (_tmp3_)) {
		if (derived_instance_type != NULL) {
			ValaDataType* instance_type = NULL;
			ValaTypeParameter* _tmp4_;
			ValaTypeParameter* _tmp5_;
			ValaSymbol* _tmp6_;
			ValaSymbol* _tmp7_;
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			gint param_index = 0;
			ValaDataType* _tmp19_;
			ValaDataType* _tmp41_;
			ValaList* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			_tmp4_ = vala_generic_type_get_type_parameter (generic_type);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_semantic_analyzer_get_instance_base_type_for_member (derived_instance_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), node_reference);
			instance_type = _tmp8_;
			_tmp9_ = instance_type;
			if (_tmp9_ == NULL) {
				ValaInvalidType* _tmp18_;
				if (node_reference != NULL) {
					ValaCodeNode* reference = NULL;
					ValaSymbol* _tmp10_;
					ValaCodeNode* _tmp11_;
					ValaCodeNode* _tmp12_ = NULL;
					ValaCodeNode* _tmp13_;
					ValaSourceReference* _tmp14_;
					ValaSourceReference* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp10_ = vala_semantic_analyzer_get_symbol_for_data_type (derived_instance_type);
					_tmp11_ = _vala_code_node_ref0 ((ValaCodeNode*) _tmp10_);
					reference = _tmp11_;
					_tmp13_ = reference;
					_tmp12_ = _tmp13_;
					if (_tmp12_ == NULL) {
						_tmp12_ = node_reference;
					}
					_tmp14_ = vala_code_node_get_source_reference (_tmp12_);
					_tmp15_ = _tmp14_;
					_tmp16_ = vala_code_node_to_string ((ValaCodeNode*) generic_type);
					_tmp17_ = _tmp16_;
					vala_report_error (_tmp15_, "The type-parameter `%s' is missing", _tmp17_);
					_g_free0 (_tmp17_);
					vala_code_node_set_error (node_reference, TRUE);
					_vala_code_node_unref0 (reference);
				}
				_tmp18_ = vala_invalid_type_new ();
				result = (ValaDataType*) _tmp18_;
				_vala_code_node_unref0 (instance_type);
				_vala_code_node_unref0 (actual_type);
				return result;
			}
			_tmp19_ = instance_type;
			if (VALA_IS_DELEGATE_TYPE (_tmp19_)) {
				ValaDataType* _tmp20_;
				ValaDelegate* _tmp21_;
				ValaDelegate* _tmp22_;
				ValaTypeParameter* _tmp23_;
				ValaTypeParameter* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				_tmp20_ = instance_type;
				_tmp21_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp22_ = _tmp21_;
				_tmp23_ = vala_generic_type_get_type_parameter (generic_type);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_name ((ValaSymbol*) _tmp24_);
				_tmp26_ = _tmp25_;
				param_index = vala_typesymbol_get_type_parameter_index ((ValaTypeSymbol*) _tmp22_, _tmp26_);
			} else {
				ValaDataType* _tmp27_;
				ValaTypeSymbol* _tmp28_;
				ValaTypeSymbol* _tmp29_;
				ValaTypeParameter* _tmp30_;
				ValaTypeParameter* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				_tmp27_ = instance_type;
				_tmp28_ = vala_data_type_get_type_symbol (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_generic_type_get_type_parameter (generic_type);
				_tmp31_ = _tmp30_;
				_tmp32_ = vala_symbol_get_name ((ValaSymbol*) _tmp31_);
				_tmp33_ = _tmp32_;
				param_index = vala_typesymbol_get_type_parameter_index (_tmp29_, _tmp33_);
			}
			if (param_index == -1) {
				ValaInvalidType* _tmp40_;
				if (node_reference != NULL) {
					ValaSourceReference* _tmp34_;
					ValaSourceReference* _tmp35_;
					ValaTypeParameter* _tmp36_;
					ValaTypeParameter* _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					_tmp34_ = vala_code_node_get_source_reference (node_reference);
					_tmp35_ = _tmp34_;
					_tmp36_ = vala_generic_type_get_type_parameter (generic_type);
					_tmp37_ = _tmp36_;
					_tmp38_ = vala_symbol_get_name ((ValaSymbol*) _tmp37_);
					_tmp39_ = _tmp38_;
					vala_report_error (_tmp35_, "internal error: unknown type parameter %s", _tmp39_);
					vala_code_node_set_error (node_reference, TRUE);
				}
				_tmp40_ = vala_invalid_type_new ();
				result = (ValaDataType*) _tmp40_;
				_vala_code_node_unref0 (instance_type);
				_vala_code_node_unref0 (actual_type);
				return result;
			}
			_tmp41_ = instance_type;
			_tmp42_ = vala_data_type_get_type_arguments (_tmp41_);
			_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
			_tmp44_ = _tmp43_;
			if (param_index < _tmp44_) {
				ValaDataType* _tmp45_;
				ValaList* _tmp46_;
				gpointer _tmp47_;
				_tmp45_ = instance_type;
				_tmp46_ = vala_data_type_get_type_arguments (_tmp45_);
				_tmp47_ = vala_list_get (_tmp46_, param_index);
				_vala_code_node_unref0 (actual_type);
				actual_type = G_TYPE_CHECK_INSTANCE_CAST ((ValaDataType*) _tmp47_, VALA_TYPE_DATA_TYPE, ValaDataType);
			}
			_vala_code_node_unref0 (instance_type);
		}
	} else {
		ValaMethod* m = NULL;
		ValaTypeParameter* _tmp48_;
		ValaTypeParameter* _tmp49_;
		ValaSymbol* _tmp50_;
		ValaSymbol* _tmp51_;
		gint param_index = 0;
		ValaMethod* _tmp52_;
		ValaTypeParameter* _tmp53_;
		ValaTypeParameter* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		_tmp48_ = vala_generic_type_get_type_parameter (generic_type);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp49_);
		_tmp51_ = _tmp50_;
		m = G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, VALA_TYPE_METHOD, ValaMethod);
		_tmp52_ = m;
		_tmp53_ = vala_generic_type_get_type_parameter (generic_type);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_symbol_get_name ((ValaSymbol*) _tmp54_);
		_tmp56_ = _tmp55_;
		param_index = vala_method_get_type_parameter_index (_tmp52_, _tmp56_);
		if (param_index == -1) {
			ValaInvalidType* _tmp63_;
			if (node_reference != NULL) {
				ValaSourceReference* _tmp57_;
				ValaSourceReference* _tmp58_;
				ValaTypeParameter* _tmp59_;
				ValaTypeParameter* _tmp60_;
				const gchar* _tmp61_;
				const gchar* _tmp62_;
				_tmp57_ = vala_code_node_get_source_reference (node_reference);
				_tmp58_ = _tmp57_;
				_tmp59_ = vala_generic_type_get_type_parameter (generic_type);
				_tmp60_ = _tmp59_;
				_tmp61_ = vala_symbol_get_name ((ValaSymbol*) _tmp60_);
				_tmp62_ = _tmp61_;
				vala_report_error (_tmp58_, "internal error: unknown type parameter %s", _tmp62_);
				vala_code_node_set_error (node_reference, TRUE);
			}
			_tmp63_ = vala_invalid_type_new ();
			result = (ValaDataType*) _tmp63_;
			_vala_code_node_unref0 (actual_type);
			return result;
		}
		if (method_type_arguments != NULL) {
			gint _tmp64_;
			gint _tmp65_;
			_tmp64_ = vala_collection_get_size ((ValaCollection*) method_type_arguments);
			_tmp65_ = _tmp64_;
			if (param_index < _tmp65_) {
				gpointer _tmp66_;
				_tmp66_ = vala_list_get (method_type_arguments, param_index);
				_vala_code_node_unref0 (actual_type);
				actual_type = G_TYPE_CHECK_INSTANCE_CAST ((ValaDataType*) _tmp66_, VALA_TYPE_DATA_TYPE, ValaDataType);
			}
		}
	}
	_tmp67_ = actual_type;
	if (_tmp67_ == NULL) {
		ValaDataType* _tmp68_;
		_tmp68_ = _vala_code_node_ref0 ((ValaDataType*) generic_type);
		result = _tmp68_;
		_vala_code_node_unref0 (actual_type);
		return result;
	}
	_tmp69_ = actual_type;
	_tmp70_ = vala_data_type_copy (_tmp69_);
	_vala_code_node_unref0 (actual_type);
	actual_type = _tmp70_;
	_tmp71_ = actual_type;
	_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) generic_type);
	_tmp73_ = _tmp72_;
	vala_code_node_set_source_reference ((ValaCodeNode*) _tmp71_, _tmp73_);
	_tmp75_ = actual_type;
	_tmp76_ = vala_data_type_get_value_owned (_tmp75_);
	_tmp77_ = _tmp76_;
	if (_tmp77_) {
		gboolean _tmp78_;
		gboolean _tmp79_;
		_tmp78_ = vala_data_type_get_value_owned ((ValaDataType*) generic_type);
		_tmp79_ = _tmp78_;
		_tmp74_ = _tmp79_;
	} else {
		_tmp74_ = FALSE;
	}
	_tmp80_ = actual_type;
	vala_data_type_set_value_owned (_tmp80_, _tmp74_);
	result = actual_type;
	return result;
}

gboolean
vala_semantic_analyzer_is_in_instance_method (ValaSemanticAnalyzer* self)
{
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_current_symbol;
	sym = _tmp0_;
	while (TRUE) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp1_ = sym;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = sym;
		if (VALA_IS_CREATION_METHOD (_tmp2_)) {
			result = TRUE;
			return result;
		} else {
			ValaSymbol* _tmp3_;
			_tmp3_ = sym;
			if (VALA_IS_METHOD (_tmp3_)) {
				ValaMethod* m = NULL;
				ValaSymbol* _tmp4_;
				ValaMethod* _tmp5_;
				ValaMemberBinding _tmp6_;
				ValaMemberBinding _tmp7_;
				_tmp4_ = sym;
				m = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_METHOD, ValaMethod);
				_tmp5_ = m;
				_tmp6_ = vala_method_get_binding (_tmp5_);
				_tmp7_ = _tmp6_;
				result = _tmp7_ == VALA_MEMBER_BINDING_INSTANCE;
				return result;
			} else {
				ValaSymbol* _tmp8_;
				_tmp8_ = sym;
				if (VALA_IS_CONSTRUCTOR (_tmp8_)) {
					ValaConstructor* c = NULL;
					ValaSymbol* _tmp9_;
					ValaConstructor* _tmp10_;
					ValaMemberBinding _tmp11_;
					ValaMemberBinding _tmp12_;
					_tmp9_ = sym;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
					_tmp10_ = c;
					_tmp11_ = vala_constructor_get_binding (_tmp10_);
					_tmp12_ = _tmp11_;
					result = _tmp12_ == VALA_MEMBER_BINDING_INSTANCE;
					return result;
				} else {
					ValaSymbol* _tmp13_;
					_tmp13_ = sym;
					if (VALA_IS_DESTRUCTOR (_tmp13_)) {
						ValaDestructor* d = NULL;
						ValaSymbol* _tmp14_;
						ValaDestructor* _tmp15_;
						ValaMemberBinding _tmp16_;
						ValaMemberBinding _tmp17_;
						_tmp14_ = sym;
						d = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
						_tmp15_ = d;
						_tmp16_ = vala_destructor_get_binding (_tmp15_);
						_tmp17_ = _tmp16_;
						result = _tmp17_ == VALA_MEMBER_BINDING_INSTANCE;
						return result;
					} else {
						ValaSymbol* _tmp18_;
						_tmp18_ = sym;
						if (VALA_IS_PROPERTY (_tmp18_)) {
							ValaProperty* p = NULL;
							ValaSymbol* _tmp19_;
							ValaProperty* _tmp20_;
							ValaMemberBinding _tmp21_;
							ValaMemberBinding _tmp22_;
							_tmp19_ = sym;
							p = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp20_ = p;
							_tmp21_ = vala_property_get_binding (_tmp20_);
							_tmp22_ = _tmp21_;
							result = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
							return result;
						}
					}
				}
			}
		}
		_tmp23_ = sym;
		_tmp24_ = vala_symbol_get_parent_symbol (_tmp23_);
		_tmp25_ = _tmp24_;
		sym = _tmp25_;
	}
	result = FALSE;
	return result;
}

ValaExpression*
vala_semantic_analyzer_create_temp_access (ValaLocalVariable* local,
                                           ValaDataType* target_type)
{
	ValaExpression* temp_access = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaMemberAccess* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean target_owned = FALSE;
	gboolean _tmp8_ = FALSE;
	ValaExpression* result = NULL;
	g_return_val_if_fail (local != NULL, NULL);
	_tmp0_ = vala_symbol_get_name ((ValaSymbol*) local);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) local);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_member_access_new_simple (_tmp1_, _tmp3_);
	temp_access = (ValaExpression*) _tmp4_;
	if (target_type != NULL) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = vala_data_type_get_value_owned (target_type);
		_tmp7_ = _tmp6_;
		_tmp5_ = _tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	target_owned = _tmp5_;
	if (target_owned) {
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		_tmp9_ = vala_variable_get_variable_type ((ValaVariable*) local);
		_tmp10_ = _tmp9_;
		_tmp8_ = vala_data_type_is_disposable (_tmp10_);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaExpression* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaReferenceTransferExpression* _tmp14_;
		ValaDataType* _tmp15_ = NULL;
		ValaExpression* _tmp20_;
		ValaExpression* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		_tmp11_ = temp_access;
		_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) local);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_reference_transfer_expression_new (_tmp11_, _tmp13_);
		_vala_code_node_unref0 (temp_access);
		temp_access = (ValaExpression*) _tmp14_;
		if (target_type != NULL) {
			ValaDataType* _tmp16_;
			_tmp16_ = vala_data_type_copy (target_type);
			_vala_code_node_unref0 (_tmp15_);
			_tmp15_ = _tmp16_;
		} else {
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			_tmp17_ = vala_variable_get_variable_type ((ValaVariable*) local);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_data_type_copy (_tmp18_);
			_vala_code_node_unref0 (_tmp15_);
			_tmp15_ = _tmp19_;
		}
		_tmp20_ = temp_access;
		vala_expression_set_target_type (_tmp20_, _tmp15_);
		_tmp21_ = temp_access;
		_tmp22_ = vala_expression_get_target_type (_tmp21_);
		_tmp23_ = _tmp22_;
		vala_data_type_set_value_owned (_tmp23_, TRUE);
		_vala_code_node_unref0 (_tmp15_);
	} else {
		ValaDataType* _tmp24_ = NULL;
		ValaExpression* _tmp26_;
		if (target_type != NULL) {
			ValaDataType* _tmp25_;
			_tmp25_ = vala_data_type_copy (target_type);
			_vala_code_node_unref0 (_tmp24_);
			_tmp24_ = _tmp25_;
		} else {
			_vala_code_node_unref0 (_tmp24_);
			_tmp24_ = NULL;
		}
		_tmp26_ = temp_access;
		vala_expression_set_target_type (_tmp26_, _tmp24_);
		_vala_code_node_unref0 (_tmp24_);
	}
	result = temp_access;
	return result;
}

static ValaStruct*
vala_semantic_analyzer_get_arithmetic_struct (ValaSemanticAnalyzer* self,
                                              ValaDataType* type)
{
	ValaStruct* _result_ = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaStruct* _tmp3_;
	ValaStruct* _tmp7_;
	ValaStruct* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = vala_data_type_get_type_symbol (type);
	_tmp1_ = _tmp0_;
	_result_ = VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL;
	_tmp3_ = _result_;
	if (_tmp3_ == NULL) {
		_tmp2_ = VALA_IS_ENUM_VALUE_TYPE (type);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaDataType* _tmp4_;
		ValaTypeSymbol* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		_tmp4_ = self->int_type;
		_tmp5_ = vala_data_type_get_type_symbol (_tmp4_);
		_tmp6_ = _tmp5_;
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_STRUCT, ValaStruct);
		return result;
	}
	_tmp7_ = _result_;
	result = _tmp7_;
	return result;
}

ValaDataType*
vala_semantic_analyzer_get_arithmetic_result_type (ValaSemanticAnalyzer* self,
                                                   ValaDataType* left_type,
                                                   ValaDataType* right_type)
{
	ValaStruct* left = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* right = NULL;
	ValaStruct* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaStruct* _tmp3_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	ValaStruct* _tmp7_;
	ValaStruct* _tmp12_;
	ValaStruct* _tmp13_;
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (left_type != NULL, NULL);
	g_return_val_if_fail (right_type != NULL, NULL);
	_tmp0_ = vala_semantic_analyzer_get_arithmetic_struct (self, left_type);
	left = _tmp0_;
	_tmp1_ = vala_semantic_analyzer_get_arithmetic_struct (self, right_type);
	right = _tmp1_;
	_tmp3_ = left;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		ValaStruct* _tmp4_;
		_tmp4_ = right;
		_tmp2_ = _tmp4_ == NULL;
	}
	if (_tmp2_) {
		result = NULL;
		return result;
	}
	_tmp7_ = left;
	if (!vala_struct_is_floating_type (_tmp7_)) {
		ValaStruct* _tmp8_;
		_tmp8_ = left;
		_tmp6_ = !vala_struct_is_integer_type (_tmp8_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		ValaStruct* _tmp10_;
		_tmp10_ = right;
		if (!vala_struct_is_floating_type (_tmp10_)) {
			ValaStruct* _tmp11_;
			_tmp11_ = right;
			_tmp9_ = !vala_struct_is_integer_type (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		_tmp5_ = _tmp9_;
	}
	if (_tmp5_) {
		result = NULL;
		return result;
	}
	_tmp12_ = left;
	_tmp13_ = right;
	if (vala_struct_is_floating_type (_tmp12_) == vala_struct_is_floating_type (_tmp13_)) {
		ValaStruct* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		ValaStruct* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		_tmp14_ = left;
		_tmp15_ = vala_struct_get_rank (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = right;
		_tmp18_ = vala_struct_get_rank (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp16_ >= _tmp19_) {
			result = left_type;
			return result;
		} else {
			result = right_type;
			return result;
		}
	} else {
		ValaStruct* _tmp20_;
		_tmp20_ = left;
		if (vala_struct_is_floating_type (_tmp20_)) {
			result = left_type;
			return result;
		} else {
			result = right_type;
			return result;
		}
	}
}

ValaMethod*
vala_semantic_analyzer_find_current_method (ValaSemanticAnalyzer* self)
{
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_symbol;
	sym = _tmp0_;
	while (TRUE) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp1_ = sym;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = sym;
		if (VALA_IS_METHOD (_tmp2_)) {
			ValaSymbol* _tmp3_;
			_tmp3_ = sym;
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_METHOD, ValaMethod);
			return result;
		}
		_tmp4_ = sym;
		_tmp5_ = vala_symbol_get_parent_symbol (_tmp4_);
		_tmp6_ = _tmp5_;
		sym = _tmp6_;
	}
	result = NULL;
	return result;
}

ValaMethod*
vala_semantic_analyzer_find_parent_method (ValaSymbol* sym)
{
	ValaMethod* result = NULL;
	g_return_val_if_fail (sym != NULL, NULL);
	while (TRUE) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		if (!VALA_IS_BLOCK (sym)) {
			break;
		}
		_tmp0_ = vala_symbol_get_parent_symbol (sym);
		_tmp1_ = _tmp0_;
		sym = _tmp1_;
	}
	result = VALA_IS_METHOD (sym) ? ((ValaMethod*) sym) : NULL;
	return result;
}

ValaSymbol*
vala_semantic_analyzer_find_parent_method_or_property_accessor (ValaSymbol* sym)
{
	ValaSymbol* result = NULL;
	g_return_val_if_fail (sym != NULL, NULL);
	while (TRUE) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		if (!VALA_IS_BLOCK (sym)) {
			break;
		}
		_tmp0_ = vala_symbol_get_parent_symbol (sym);
		_tmp1_ = _tmp0_;
		sym = _tmp1_;
	}
	if (VALA_IS_METHOD (sym)) {
		result = sym;
		return result;
	} else {
		if (VALA_IS_PROPERTY_ACCESSOR (sym)) {
			result = sym;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}

ValaTypeSymbol*
vala_semantic_analyzer_find_parent_type_symbol (ValaSymbol* sym)
{
	ValaTypeSymbol* result = NULL;
	g_return_val_if_fail (sym != NULL, NULL);
	while (TRUE) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		if (!(sym != NULL)) {
			break;
		}
		if (VALA_IS_TYPESYMBOL (sym)) {
			result = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			return result;
		}
		_tmp0_ = vala_symbol_get_parent_symbol (sym);
		_tmp1_ = _tmp0_;
		sym = _tmp1_;
	}
	result = NULL;
	return result;
}

ValaDataType*
vala_semantic_analyzer_get_this_type (ValaSymbol* s,
                                      ValaTypeSymbol* parent)
{
	ValaTypeSymbol* _tmp0_ = NULL;
	ValaTypeSymbol* parent_type = NULL;
	ValaTypeSymbol* _tmp2_;
	ValaMemberBinding binding = 0;
	ValaDataType* this_type = NULL;
	ValaList* type_parameters = NULL;
	ValaMemberBinding _tmp18_;
	ValaList* _tmp57_;
	ValaDataType* result = NULL;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = parent;
	if (_tmp0_ == NULL) {
		ValaTypeSymbol* _tmp1_;
		_tmp1_ = vala_semantic_analyzer_find_parent_type_symbol (s);
		_tmp0_ = _tmp1_;
	}
	parent_type = _tmp0_;
	_tmp2_ = parent_type;
	if (_tmp2_ == NULL) {
		ValaTypeSymbol* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaInvalidType* _tmp6_;
		_tmp3_ = parent_type;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp3_);
		_tmp5_ = _tmp4_;
		vala_report_error (_tmp5_, "internal: Unsupported symbol type");
		_tmp6_ = vala_invalid_type_new ();
		result = (ValaDataType*) _tmp6_;
		return result;
	}
	if (VALA_IS_METHOD (s)) {
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp7_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (s, VALA_TYPE_METHOD, ValaMethod));
		_tmp8_ = _tmp7_;
		binding = _tmp8_;
	} else {
		if (VALA_IS_CONSTRUCTOR (s)) {
			ValaMemberBinding _tmp9_;
			ValaMemberBinding _tmp10_;
			_tmp9_ = vala_constructor_get_binding (G_TYPE_CHECK_INSTANCE_CAST (s, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
			_tmp10_ = _tmp9_;
			binding = _tmp10_;
		} else {
			if (VALA_IS_DESTRUCTOR (s)) {
				ValaMemberBinding _tmp11_;
				ValaMemberBinding _tmp12_;
				_tmp11_ = vala_destructor_get_binding (G_TYPE_CHECK_INSTANCE_CAST (s, VALA_TYPE_DESTRUCTOR, ValaDestructor));
				_tmp12_ = _tmp11_;
				binding = _tmp12_;
			} else {
				if (VALA_IS_PROPERTY (s)) {
					ValaMemberBinding _tmp13_;
					ValaMemberBinding _tmp14_;
					_tmp13_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (s, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp14_ = _tmp13_;
					binding = _tmp14_;
				} else {
					ValaSourceReference* _tmp15_;
					ValaSourceReference* _tmp16_;
					ValaInvalidType* _tmp17_;
					_tmp15_ = vala_code_node_get_source_reference ((ValaCodeNode*) s);
					_tmp16_ = _tmp15_;
					vala_report_error (_tmp16_, "internal: Unsupported symbol type");
					_tmp17_ = vala_invalid_type_new ();
					result = (ValaDataType*) _tmp17_;
					return result;
				}
			}
		}
	}
	this_type = NULL;
	type_parameters = NULL;
	_tmp18_ = binding;
	switch (_tmp18_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaTypeSymbol* _tmp19_;
			_tmp19_ = parent_type;
			if (VALA_IS_CLASS (_tmp19_)) {
				ValaTypeSymbol* _tmp20_;
				ValaObjectType* _tmp21_;
				ValaTypeSymbol* _tmp22_;
				ValaList* _tmp23_;
				ValaList* _tmp24_;
				_tmp20_ = parent_type;
				_tmp21_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (this_type);
				this_type = (ValaDataType*) _tmp21_;
				_tmp22_ = parent_type;
				_tmp23_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_CLASS, ValaClass));
				_tmp24_ = _vala_iterable_ref0 (_tmp23_);
				_vala_iterable_unref0 (type_parameters);
				type_parameters = _tmp24_;
			} else {
				ValaTypeSymbol* _tmp25_;
				_tmp25_ = parent_type;
				if (VALA_IS_INTERFACE (_tmp25_)) {
					ValaTypeSymbol* _tmp26_;
					ValaObjectType* _tmp27_;
					ValaTypeSymbol* _tmp28_;
					ValaList* _tmp29_;
					ValaList* _tmp30_;
					_tmp26_ = parent_type;
					_tmp27_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_INTERFACE, ValaInterface));
					_vala_code_node_unref0 (this_type);
					this_type = (ValaDataType*) _tmp27_;
					_tmp28_ = parent_type;
					_tmp29_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_INTERFACE, ValaInterface));
					_tmp30_ = _vala_iterable_ref0 (_tmp29_);
					_vala_iterable_unref0 (type_parameters);
					type_parameters = _tmp30_;
				} else {
					ValaTypeSymbol* _tmp31_;
					_tmp31_ = parent_type;
					if (VALA_IS_STRUCT (_tmp31_)) {
						ValaTypeSymbol* _tmp32_;
						ValaStructValueType* _tmp33_;
						ValaTypeSymbol* _tmp34_;
						ValaList* _tmp35_;
						ValaList* _tmp36_;
						_tmp32_ = parent_type;
						_tmp33_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_STRUCT, ValaStruct));
						_vala_code_node_unref0 (this_type);
						this_type = (ValaDataType*) _tmp33_;
						_tmp34_ = parent_type;
						_tmp35_ = vala_struct_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, VALA_TYPE_STRUCT, ValaStruct));
						_tmp36_ = _vala_iterable_ref0 (_tmp35_);
						_vala_iterable_unref0 (type_parameters);
						type_parameters = _tmp36_;
					} else {
						ValaTypeSymbol* _tmp37_;
						_tmp37_ = parent_type;
						if (VALA_IS_ENUM (_tmp37_)) {
							ValaTypeSymbol* _tmp38_;
							ValaEnumValueType* _tmp39_;
							_tmp38_ = parent_type;
							_tmp39_ = vala_enum_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM, ValaEnum));
							_vala_code_node_unref0 (this_type);
							this_type = (ValaDataType*) _tmp39_;
						} else {
							ValaTypeSymbol* _tmp40_;
							ValaSourceReference* _tmp41_;
							ValaSourceReference* _tmp42_;
							ValaInvalidType* _tmp43_;
							_tmp40_ = parent_type;
							_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp40_);
							_tmp42_ = _tmp41_;
							vala_report_error (_tmp42_, "internal: Unsupported symbol type");
							_tmp43_ = vala_invalid_type_new ();
							_vala_code_node_unref0 (this_type);
							this_type = (ValaDataType*) _tmp43_;
						}
					}
				}
			}
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaTypeSymbol* _tmp44_;
			_tmp44_ = parent_type;
			if (VALA_IS_CLASS (_tmp44_)) {
				ValaTypeSymbol* _tmp45_;
				ValaClassType* _tmp46_;
				_tmp45_ = parent_type;
				_tmp46_ = vala_class_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (this_type);
				this_type = (ValaDataType*) _tmp46_;
			} else {
				ValaTypeSymbol* _tmp47_;
				_tmp47_ = parent_type;
				if (VALA_IS_INTERFACE (_tmp47_)) {
					ValaTypeSymbol* _tmp48_;
					ValaInterfaceType* _tmp49_;
					_tmp48_ = parent_type;
					_tmp49_ = vala_interface_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_INTERFACE, ValaInterface));
					_vala_code_node_unref0 (this_type);
					this_type = (ValaDataType*) _tmp49_;
				} else {
					ValaTypeSymbol* _tmp50_;
					ValaSourceReference* _tmp51_;
					ValaSourceReference* _tmp52_;
					ValaInvalidType* _tmp53_;
					_tmp50_ = parent_type;
					_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp50_);
					_tmp52_ = _tmp51_;
					vala_report_error (_tmp52_, "internal: Unsupported symbol type");
					_tmp53_ = vala_invalid_type_new ();
					_vala_code_node_unref0 (this_type);
					this_type = (ValaDataType*) _tmp53_;
				}
			}
			break;
		}
		default:
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaSourceReference* _tmp54_;
			ValaSourceReference* _tmp55_;
			ValaInvalidType* _tmp56_;
			_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) s);
			_tmp55_ = _tmp54_;
			vala_report_error (_tmp55_, "internal: Does not support a parent instance");
			_tmp56_ = vala_invalid_type_new ();
			_vala_code_node_unref0 (this_type);
			this_type = (ValaDataType*) _tmp56_;
			break;
		}
	}
	_tmp57_ = type_parameters;
	if (_tmp57_ != NULL) {
		{
			ValaList* _type_param_list = NULL;
			ValaList* _tmp58_;
			gint _type_param_size = 0;
			ValaList* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gint _type_param_index = 0;
			_tmp58_ = type_parameters;
			_type_param_list = _tmp58_;
			_tmp59_ = _type_param_list;
			_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
			_tmp61_ = _tmp60_;
			_type_param_size = _tmp61_;
			_type_param_index = -1;
			while (TRUE) {
				gint _tmp62_;
				gint _tmp63_;
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp64_;
				gpointer _tmp65_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp66_;
				ValaGenericType* _tmp67_;
				ValaGenericType* _tmp68_;
				ValaDataType* _tmp69_;
				ValaGenericType* _tmp70_;
				_type_param_index = _type_param_index + 1;
				_tmp62_ = _type_param_index;
				_tmp63_ = _type_param_size;
				if (!(_tmp62_ < _tmp63_)) {
					break;
				}
				_tmp64_ = _type_param_list;
				_tmp65_ = vala_list_get (_tmp64_, _type_param_index);
				type_param = (ValaTypeParameter*) _tmp65_;
				_tmp66_ = type_param;
				_tmp67_ = vala_generic_type_new (_tmp66_);
				type_arg = _tmp67_;
				_tmp68_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp68_, TRUE);
				_tmp69_ = this_type;
				_tmp70_ = type_arg;
				vala_data_type_add_type_argument (_tmp69_, (ValaDataType*) _tmp70_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_param);
			}
		}
	}
	result = this_type;
	_vala_iterable_unref0 (type_parameters);
	return result;
}

gboolean
vala_semantic_analyzer_is_in_constructor (ValaSemanticAnalyzer* self)
{
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_current_symbol;
	sym = _tmp0_;
	while (TRUE) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		_tmp1_ = sym;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = sym;
		if (VALA_IS_CONSTRUCTOR (_tmp2_)) {
			result = TRUE;
			return result;
		}
		_tmp3_ = sym;
		_tmp4_ = vala_symbol_get_parent_symbol (_tmp3_);
		_tmp5_ = _tmp4_;
		sym = _tmp5_;
	}
	result = FALSE;
	return result;
}

gboolean
vala_semantic_analyzer_is_in_destructor (ValaSemanticAnalyzer* self)
{
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_current_symbol;
	sym = _tmp0_;
	while (TRUE) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		_tmp1_ = sym;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = sym;
		if (VALA_IS_DESTRUCTOR (_tmp2_)) {
			result = TRUE;
			return result;
		}
		_tmp3_ = sym;
		_tmp4_ = vala_symbol_get_parent_symbol (_tmp3_);
		_tmp5_ = _tmp4_;
		sym = _tmp5_;
	}
	result = FALSE;
	return result;
}

gboolean
vala_semantic_analyzer_is_reference_type_argument (ValaSemanticAnalyzer* self,
                                                   ValaDataType* type_arg)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_arg != NULL, FALSE);
	if (VALA_IS_ERROR_TYPE (type_arg)) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		ValaTypeSymbol* _tmp2_;
		ValaTypeSymbol* _tmp3_;
		_tmp2_ = vala_data_type_get_type_symbol (type_arg);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaTypeSymbol* _tmp4_;
			ValaTypeSymbol* _tmp5_;
			_tmp4_ = vala_data_type_get_type_symbol (type_arg);
			_tmp5_ = _tmp4_;
			_tmp1_ = vala_typesymbol_is_reference_type (_tmp5_);
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

gboolean
vala_semantic_analyzer_is_nullable_value_type_argument (ValaSemanticAnalyzer* self,
                                                        ValaDataType* type_arg)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_arg != NULL, FALSE);
	if (VALA_IS_VALUE_TYPE (type_arg)) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = vala_data_type_get_nullable (type_arg);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

gboolean
vala_semantic_analyzer_is_signed_integer_type_argument (ValaSemanticAnalyzer* self,
                                                        ValaDataType* type_arg)
{
	ValaStruct* st = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_arg != NULL, FALSE);
	_tmp0_ = vala_data_type_get_type_symbol (type_arg);
	_tmp1_ = _tmp0_;
	st = VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL;
	if (VALA_IS_ENUM_VALUE_TYPE (type_arg)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_data_type_get_nullable (type_arg);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			result = FALSE;
			return result;
		} else {
			ValaStruct* _tmp4_;
			_tmp4_ = st;
			if (_tmp4_ == NULL) {
				result = FALSE;
				return result;
			} else {
				ValaStruct* _tmp5_;
				ValaDataType* _tmp6_;
				ValaTypeSymbol* _tmp7_;
				ValaTypeSymbol* _tmp8_;
				_tmp5_ = st;
				_tmp6_ = self->bool_type;
				_tmp7_ = vala_data_type_get_type_symbol (_tmp6_);
				_tmp8_ = _tmp7_;
				if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp5_, _tmp8_)) {
					result = TRUE;
					return result;
				} else {
					ValaStruct* _tmp9_;
					ValaDataType* _tmp10_;
					ValaTypeSymbol* _tmp11_;
					ValaTypeSymbol* _tmp12_;
					_tmp9_ = st;
					_tmp10_ = self->char_type;
					_tmp11_ = vala_data_type_get_type_symbol (_tmp10_);
					_tmp12_ = _tmp11_;
					if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp9_, _tmp12_)) {
						result = TRUE;
						return result;
					} else {
						gboolean _tmp13_ = FALSE;
						ValaDataType* _tmp14_;
						_tmp14_ = self->unichar_type;
						if (_tmp14_ != NULL) {
							ValaStruct* _tmp15_;
							ValaDataType* _tmp16_;
							ValaTypeSymbol* _tmp17_;
							ValaTypeSymbol* _tmp18_;
							_tmp15_ = st;
							_tmp16_ = self->unichar_type;
							_tmp17_ = vala_data_type_get_type_symbol (_tmp16_);
							_tmp18_ = _tmp17_;
							_tmp13_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp15_, _tmp18_);
						} else {
							_tmp13_ = FALSE;
						}
						if (_tmp13_) {
							result = TRUE;
							return result;
						} else {
							ValaStruct* _tmp19_;
							ValaDataType* _tmp20_;
							ValaTypeSymbol* _tmp21_;
							ValaTypeSymbol* _tmp22_;
							_tmp19_ = st;
							_tmp20_ = self->short_type;
							_tmp21_ = vala_data_type_get_type_symbol (_tmp20_);
							_tmp22_ = _tmp21_;
							if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp19_, _tmp22_)) {
								result = TRUE;
								return result;
							} else {
								ValaStruct* _tmp23_;
								ValaDataType* _tmp24_;
								ValaTypeSymbol* _tmp25_;
								ValaTypeSymbol* _tmp26_;
								_tmp23_ = st;
								_tmp24_ = self->int_type;
								_tmp25_ = vala_data_type_get_type_symbol (_tmp24_);
								_tmp26_ = _tmp25_;
								if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp23_, _tmp26_)) {
									result = TRUE;
									return result;
								} else {
									ValaStruct* _tmp27_;
									ValaDataType* _tmp28_;
									ValaTypeSymbol* _tmp29_;
									ValaTypeSymbol* _tmp30_;
									_tmp27_ = st;
									_tmp28_ = self->long_type;
									_tmp29_ = vala_data_type_get_type_symbol (_tmp28_);
									_tmp30_ = _tmp29_;
									if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp27_, _tmp30_)) {
										result = TRUE;
										return result;
									} else {
										ValaStruct* _tmp31_;
										ValaDataType* _tmp32_;
										ValaTypeSymbol* _tmp33_;
										ValaTypeSymbol* _tmp34_;
										_tmp31_ = st;
										_tmp32_ = self->int8_type;
										_tmp33_ = vala_data_type_get_type_symbol (_tmp32_);
										_tmp34_ = _tmp33_;
										if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp31_, _tmp34_)) {
											result = TRUE;
											return result;
										} else {
											ValaStruct* _tmp35_;
											ValaDataType* _tmp36_;
											ValaTypeSymbol* _tmp37_;
											ValaTypeSymbol* _tmp38_;
											_tmp35_ = st;
											_tmp36_ = self->int16_type;
											_tmp37_ = vala_data_type_get_type_symbol (_tmp36_);
											_tmp38_ = _tmp37_;
											if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp35_, _tmp38_)) {
												result = TRUE;
												return result;
											} else {
												ValaStruct* _tmp39_;
												ValaDataType* _tmp40_;
												ValaTypeSymbol* _tmp41_;
												ValaTypeSymbol* _tmp42_;
												_tmp39_ = st;
												_tmp40_ = self->int32_type;
												_tmp41_ = vala_data_type_get_type_symbol (_tmp40_);
												_tmp42_ = _tmp41_;
												if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp39_, _tmp42_)) {
													result = TRUE;
													return result;
												} else {
													ValaStruct* _tmp43_;
													ValaDataType* _tmp44_;
													ValaTypeSymbol* _tmp45_;
													ValaTypeSymbol* _tmp46_;
													_tmp43_ = st;
													_tmp44_ = self->type_type;
													_tmp45_ = vala_data_type_get_type_symbol (_tmp44_);
													_tmp46_ = _tmp45_;
													if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp43_, _tmp46_)) {
														result = TRUE;
														return result;
													} else {
														result = FALSE;
														return result;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

gboolean
vala_semantic_analyzer_is_unsigned_integer_type_argument (ValaSemanticAnalyzer* self,
                                                          ValaDataType* type_arg)
{
	ValaStruct* st = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_arg != NULL, FALSE);
	_tmp0_ = vala_data_type_get_type_symbol (type_arg);
	_tmp1_ = _tmp0_;
	st = VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL;
	_tmp2_ = st;
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = vala_data_type_get_nullable (type_arg);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			result = FALSE;
			return result;
		} else {
			ValaStruct* _tmp5_;
			ValaDataType* _tmp6_;
			ValaTypeSymbol* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			_tmp5_ = st;
			_tmp6_ = self->uchar_type;
			_tmp7_ = vala_data_type_get_type_symbol (_tmp6_);
			_tmp8_ = _tmp7_;
			if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp5_, _tmp8_)) {
				result = TRUE;
				return result;
			} else {
				ValaStruct* _tmp9_;
				ValaDataType* _tmp10_;
				ValaTypeSymbol* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				_tmp9_ = st;
				_tmp10_ = self->ushort_type;
				_tmp11_ = vala_data_type_get_type_symbol (_tmp10_);
				_tmp12_ = _tmp11_;
				if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp9_, _tmp12_)) {
					result = TRUE;
					return result;
				} else {
					ValaStruct* _tmp13_;
					ValaDataType* _tmp14_;
					ValaTypeSymbol* _tmp15_;
					ValaTypeSymbol* _tmp16_;
					_tmp13_ = st;
					_tmp14_ = self->uint_type;
					_tmp15_ = vala_data_type_get_type_symbol (_tmp14_);
					_tmp16_ = _tmp15_;
					if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp13_, _tmp16_)) {
						result = TRUE;
						return result;
					} else {
						ValaStruct* _tmp17_;
						ValaDataType* _tmp18_;
						ValaTypeSymbol* _tmp19_;
						ValaTypeSymbol* _tmp20_;
						_tmp17_ = st;
						_tmp18_ = self->ulong_type;
						_tmp19_ = vala_data_type_get_type_symbol (_tmp18_);
						_tmp20_ = _tmp19_;
						if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp17_, _tmp20_)) {
							result = TRUE;
							return result;
						} else {
							ValaStruct* _tmp21_;
							ValaDataType* _tmp22_;
							ValaTypeSymbol* _tmp23_;
							ValaTypeSymbol* _tmp24_;
							_tmp21_ = st;
							_tmp22_ = self->uint8_type;
							_tmp23_ = vala_data_type_get_type_symbol (_tmp22_);
							_tmp24_ = _tmp23_;
							if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp21_, _tmp24_)) {
								result = TRUE;
								return result;
							} else {
								ValaStruct* _tmp25_;
								ValaDataType* _tmp26_;
								ValaTypeSymbol* _tmp27_;
								ValaTypeSymbol* _tmp28_;
								_tmp25_ = st;
								_tmp26_ = self->uint16_type;
								_tmp27_ = vala_data_type_get_type_symbol (_tmp26_);
								_tmp28_ = _tmp27_;
								if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp25_, _tmp28_)) {
									result = TRUE;
									return result;
								} else {
									ValaStruct* _tmp29_;
									ValaDataType* _tmp30_;
									ValaTypeSymbol* _tmp31_;
									ValaTypeSymbol* _tmp32_;
									_tmp29_ = st;
									_tmp30_ = self->uint32_type;
									_tmp31_ = vala_data_type_get_type_symbol (_tmp30_);
									_tmp32_ = _tmp31_;
									if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp29_, _tmp32_)) {
										result = TRUE;
										return result;
									} else {
										result = FALSE;
										return result;
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

void
vala_semantic_analyzer_check_type (ValaSemanticAnalyzer* self,
                                   ValaDataType* type)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaCodeContext* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp2_ = self->priv->context;
	if (_tmp2_ != NULL) {
		ValaCodeContext* _tmp3_;
		ValaProfile _tmp4_;
		ValaProfile _tmp5_;
		_tmp3_ = self->priv->context;
		_tmp4_ = vala_code_context_get_profile (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ == VALA_PROFILE_GOBJECT;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaTypeSymbol* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaDataType* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		ValaTypeSymbol* _tmp10_;
		_tmp6_ = vala_data_type_get_type_symbol (type);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->garray_type;
		_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp7_ == _tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp11_;
		gint _type_arg_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _type_arg_index = 0;
		_tmp11_ = vala_data_type_get_type_arguments (type);
		_type_arg_list = _tmp11_;
		_tmp12_ = _type_arg_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_type_arg_size = _tmp14_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaDataType* _tmp19_;
			ValaDataType* _tmp20_;
			_type_arg_index = _type_arg_index + 1;
			_tmp15_ = _type_arg_index;
			_tmp16_ = _type_arg_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _type_arg_list;
			_tmp18_ = vala_list_get (_tmp17_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp18_;
			_tmp19_ = type_arg;
			vala_semantic_analyzer_check_type (self, _tmp19_);
			_tmp20_ = type_arg;
			vala_semantic_analyzer_check_type_argument (self, _tmp20_);
			_vala_code_node_unref0 (type_arg);
		}
	}
}

void
vala_semantic_analyzer_check_type_arguments (ValaSemanticAnalyzer* self,
                                             ValaMemberAccess* access)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (access != NULL);
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp0_;
		gint _type_arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_arg_index = 0;
		_tmp0_ = vala_member_access_get_type_arguments (access);
		_type_arg_list = _tmp0_;
		_tmp1_ = _type_arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_arg_size = _tmp3_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			_type_arg_index = _type_arg_index + 1;
			_tmp4_ = _type_arg_index;
			_tmp5_ = _type_arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _type_arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp7_;
			_tmp8_ = type_arg;
			vala_semantic_analyzer_check_type (self, _tmp8_);
			_tmp9_ = type_arg;
			vala_semantic_analyzer_check_type_argument (self, _tmp9_);
			_vala_code_node_unref0 (type_arg);
		}
	}
}

static void
vala_semantic_analyzer_check_type_argument (ValaSemanticAnalyzer* self,
                                            ValaDataType* type_arg)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_arg != NULL);
	if (VALA_IS_GENERIC_TYPE (type_arg)) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = VALA_IS_NULL_TYPE (type_arg);
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = VALA_IS_POINTER_TYPE (type_arg);
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = VALA_IS_VOID_TYPE (type_arg);
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = vala_semantic_analyzer_is_reference_type_argument (self, type_arg);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = vala_semantic_analyzer_is_nullable_value_type_argument (self, type_arg);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = vala_semantic_analyzer_is_signed_integer_type_argument (self, type_arg);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_semantic_analyzer_is_unsigned_integer_type_argument (self, type_arg);
	}
	if (_tmp0_) {
	} else {
		if (VALA_IS_DELEGATE_TYPE (type_arg)) {
			ValaDelegateType* delegate_type = NULL;
			ValaDelegateType* _tmp7_;
			ValaDelegateType* _tmp8_;
			ValaDelegate* _tmp9_;
			ValaDelegate* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp7_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (type_arg, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			delegate_type = _tmp7_;
			_tmp8_ = delegate_type;
			_tmp9_ = vala_delegate_type_get_delegate_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_delegate_get_has_target (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_) {
				ValaSourceReference* _tmp13_;
				ValaSourceReference* _tmp14_;
				_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) type_arg);
				_tmp14_ = _tmp13_;
				vala_report_error (_tmp14_, "Delegates with target are not supported as generic type arguments");
			}
			_vala_code_node_unref0 (delegate_type);
		} else {
			if (VALA_IS_ARRAY_TYPE (type_arg)) {
				ValaSourceReference* _tmp15_;
				ValaSourceReference* _tmp16_;
				_tmp15_ = vala_code_node_get_source_reference ((ValaCodeNode*) type_arg);
				_tmp16_ = _tmp15_;
				vala_report_error (_tmp16_, "Arrays are not supported as generic type arguments");
			} else {
				ValaSourceReference* _tmp17_;
				ValaSourceReference* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) type_arg);
				_tmp18_ = _tmp17_;
				_tmp19_ = vala_code_node_to_string ((ValaCodeNode*) type_arg);
				_tmp20_ = _tmp19_;
				vala_report_error (_tmp18_, "`%s' is not a supported generic type argument, use `?' to box value ty" \
"pes", _tmp20_);
				_g_free0 (_tmp20_);
			}
		}
	}
}

static void
vala_semantic_analyzer_class_init (ValaSemanticAnalyzerClass * klass,
                                   gpointer klass_data)
{
	vala_semantic_analyzer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_semantic_analyzer_finalize;
	g_type_class_adjust_private_offset (klass, &ValaSemanticAnalyzer_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_semantic_analyzer_real_visit_source_file;
}

static void
vala_semantic_analyzer_instance_init (ValaSemanticAnalyzer * self,
                                      gpointer klass)
{
	ValaVoidType* _tmp0_;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	self->priv = vala_semantic_analyzer_get_instance_private (self);
	_tmp0_ = vala_void_type_new (NULL);
	self->void_type = (ValaDataType*) _tmp0_;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	self->replaced_nodes = (ValaList*) _tmp2_;
}

static void
vala_semantic_analyzer_finalize (ValaCodeVisitor * obj)
{
	ValaSemanticAnalyzer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer);
	_vala_code_context_unref0 (self->priv->context);
	_vala_code_node_unref0 (self->priv->_current_symbol);
	_vala_source_file_unref0 (self->priv->_current_source_file);
	_vala_code_node_unref0 (self->insert_block);
	_vala_code_node_unref0 (self->void_type);
	_vala_code_node_unref0 (self->bool_type);
	_vala_code_node_unref0 (self->char_type);
	_vala_code_node_unref0 (self->uchar_type);
	_vala_code_node_unref0 (self->short_type);
	_vala_code_node_unref0 (self->ushort_type);
	_vala_code_node_unref0 (self->int_type);
	_vala_code_node_unref0 (self->uint_type);
	_vala_code_node_unref0 (self->long_type);
	_vala_code_node_unref0 (self->ulong_type);
	_vala_code_node_unref0 (self->int8_type);
	_vala_code_node_unref0 (self->uint8_type);
	_vala_code_node_unref0 (self->int16_type);
	_vala_code_node_unref0 (self->uint16_type);
	_vala_code_node_unref0 (self->int32_type);
	_vala_code_node_unref0 (self->uint32_type);
	_vala_code_node_unref0 (self->size_t_type);
	_vala_code_node_unref0 (self->ssize_t_type);
	_vala_code_node_unref0 (self->unichar_type);
	_vala_code_node_unref0 (self->double_type);
	_vala_code_node_unref0 (self->string_type);
	_vala_code_node_unref0 (self->regex_type);
	_vala_code_node_unref0 (self->type_type);
	_vala_code_node_unref0 (self->va_list_type);
	_vala_code_node_unref0 (self->object_type);
	_vala_code_node_unref0 (self->gvalue_type);
	_vala_code_node_unref0 (self->gvariant_type);
	_vala_code_node_unref0 (self->glist_type);
	_vala_code_node_unref0 (self->gslist_type);
	_vala_code_node_unref0 (self->garray_type);
	_vala_code_node_unref0 (self->gvaluearray_type);
	_vala_code_node_unref0 (self->gerror_type);
	_vala_code_node_unref0 (self->list_type);
	_vala_code_node_unref0 (self->tuple_type);
	_vala_code_node_unref0 (self->gsource_type);
	_vala_code_node_unref0 (self->delegate_target_type);
	_vala_code_node_unref0 (self->delegate_target_destroy_type);
	_vala_code_node_unref0 (self->generics_dup_func_type);
	_vala_code_node_unref0 (self->priv->destroy_notify);
	_vala_iterable_unref0 (self->replaced_nodes);
	VALA_CODE_VISITOR_CLASS (vala_semantic_analyzer_parent_class)->finalize (obj);
}

/**
 * Code visitor analyzing and checking code.
 */
static GType
vala_semantic_analyzer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaSemanticAnalyzerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_semantic_analyzer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSemanticAnalyzer), 0, (GInstanceInitFunc) vala_semantic_analyzer_instance_init, NULL };
	GType vala_semantic_analyzer_type_id;
	vala_semantic_analyzer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaSemanticAnalyzer", &g_define_type_info, 0);
	ValaSemanticAnalyzer_private_offset = g_type_add_instance_private (vala_semantic_analyzer_type_id, sizeof (ValaSemanticAnalyzerPrivate));
	return vala_semantic_analyzer_type_id;
}

GType
vala_semantic_analyzer_get_type (void)
{
	static volatile gsize vala_semantic_analyzer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_semantic_analyzer_type_id__volatile)) {
		GType vala_semantic_analyzer_type_id;
		vala_semantic_analyzer_type_id = vala_semantic_analyzer_get_type_once ();
		g_once_init_leave (&vala_semantic_analyzer_type_id__volatile, vala_semantic_analyzer_type_id);
	}
	return vala_semantic_analyzer_type_id__volatile;
}

