/* gstreamer-base-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gst", gir_namespace = "GstBase", gir_version = "1.0", lower_case_cprefix = "gst_")]
namespace Gst {
	namespace Base {
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstAdapter", lower_case_cprefix = "gst_adapter_", type_id = "gst_adapter_get_type ()")]
		[GIR (name = "Adapter")]
		public class Adapter : GLib.Object {
			[CCode (has_construct_function = false)]
			public Adapter ();
			public size_t available ();
			public size_t available_fast ();
			public void clear ();
			public void copy ([CCode (array_length_cname = "size", array_length_pos = 2.1, array_length_type = "gsize")] out unowned uint8[] dest, size_t offset);
			[Version (since = "1.4")]
			public GLib.Bytes copy_bytes (size_t offset, size_t size);
			[Version (since = "1.10")]
			public uint64 distance_from_discont ();
			[Version (since = "1.10")]
			public Gst.ClockTime dts_at_discont ();
			public void flush (size_t flush);
			[Version (since = "1.6")]
			public Gst.Buffer? get_buffer (size_t nbytes);
			[Version (since = "1.6")]
			public Gst.Buffer? get_buffer_fast (size_t nbytes);
			[Version (since = "1.6")]
			public Gst.BufferList? get_buffer_list (size_t nbytes);
			[Version (since = "1.6")]
			public GLib.List<Gst.Buffer>? get_list (size_t nbytes);
			[CCode (array_length = false)]
			public unowned uint8[]? map (size_t size);
			public ssize_t masked_scan_uint32 (uint32 mask, uint32 pattern, size_t offset, size_t size);
			public ssize_t masked_scan_uint32_peek (uint32 mask, uint32 pattern, size_t offset, size_t size, out uint32 value);
			[Version (since = "1.10")]
			public uint64 offset_at_discont ();
			public Gst.ClockTime prev_dts (out uint64 distance);
			[Version (since = "1.2")]
			public Gst.ClockTime prev_dts_at_offset (size_t offset, out uint64 distance);
			[Version (since = "1.10")]
			public uint64 prev_offset (out uint64 distance);
			public Gst.ClockTime prev_pts (out uint64 distance);
			[Version (since = "1.2")]
			public Gst.ClockTime prev_pts_at_offset (size_t offset, out uint64 distance);
			[Version (since = "1.10")]
			public Gst.ClockTime pts_at_discont ();
			public void push (owned Gst.Buffer buf);
			[CCode (array_length = false)]
			public uint8[]? take (size_t nbytes);
			public Gst.Buffer? take_buffer (size_t nbytes);
			[Version (since = "1.2")]
			public Gst.Buffer? take_buffer_fast (size_t nbytes);
			[Version (since = "1.6")]
			public Gst.BufferList? take_buffer_list (size_t nbytes);
			public GLib.List<Gst.Buffer>? take_list (size_t nbytes);
			public void unmap ();
		}
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstAggregator", lower_case_cprefix = "gst_aggregator_", type_id = "gst_aggregator_get_type ()")]
		[GIR (name = "Aggregator")]
		[Version (since = "1.14")]
		public abstract class Aggregator : Gst.Element {
			public weak Gst.Pad srcpad;
			[CCode (has_construct_function = false)]
			protected Aggregator ();
			[NoWrapper]
			public virtual Gst.FlowReturn aggregate (bool timeout);
			[NoWrapper]
			public virtual Gst.Buffer clip (Gst.Base.AggregatorPad aggregator_pad, Gst.Buffer buf);
			[NoWrapper]
			public virtual bool decide_allocation (Gst.Query query);
			public virtual Gst.FlowReturn finish_buffer (owned Gst.Buffer buffer);
			[Version (since = "1.18")]
			public virtual Gst.FlowReturn finish_buffer_list (owned Gst.BufferList bufferlist);
			[NoWrapper]
			public virtual Gst.Caps fixate_src_caps (Gst.Caps caps);
			[NoWrapper]
			public virtual Gst.FlowReturn flush ();
			public void get_allocator (out Gst.Allocator? allocator, out unowned Gst.AllocationParams @params);
			public Gst.BufferPool? get_buffer_pool ();
			public Gst.ClockTime get_latency ();
			[NoWrapper]
			public virtual Gst.ClockTime get_next_time ();
			[Version (since = "1.18")]
			public virtual bool negotiate ();
			[NoWrapper]
			public virtual bool negotiated_src_caps (Gst.Caps caps);
			[Version (since = "1.18")]
			public virtual Gst.Sample? peek_next_sample (Gst.Base.AggregatorPad aggregator_pad);
			[NoWrapper]
			public virtual bool propose_allocation (Gst.Base.AggregatorPad pad, Gst.Query decide_query, Gst.Query query);
			[Version (since = "1.18")]
			public void selected_samples (Gst.ClockTime pts, Gst.ClockTime dts, Gst.ClockTime duration, Gst.Structure? info);
			public void set_latency (Gst.ClockTime min_latency, Gst.ClockTime max_latency);
			public void set_src_caps (Gst.Caps caps);
			[Version (since = "1.16")]
			public Gst.ClockTime simple_get_next_time ();
			[NoWrapper]
			public virtual bool sink_event (Gst.Base.AggregatorPad aggregator_pad, Gst.Event event);
			[NoWrapper]
			public virtual Gst.FlowReturn sink_event_pre_queue (Gst.Base.AggregatorPad aggregator_pad, Gst.Event event);
			[NoWrapper]
			public virtual bool sink_query (Gst.Base.AggregatorPad aggregator_pad, Gst.Query query);
			[NoWrapper]
			public virtual bool sink_query_pre_queue (Gst.Base.AggregatorPad aggregator_pad, Gst.Query query);
			[NoWrapper]
			public virtual bool src_activate (Gst.PadMode mode, bool active);
			[NoWrapper]
			public virtual bool src_event (Gst.Event event);
			[NoWrapper]
			public virtual bool src_query (Gst.Query query);
			[NoWrapper]
			public virtual bool start ();
			[NoWrapper]
			public virtual bool stop ();
			[Version (since = "1.18")]
			public void update_segment (Gst.Segment segment);
			[NoWrapper]
			public virtual Gst.FlowReturn update_src_caps (Gst.Caps caps, out Gst.Caps ret);
			[NoAccessorMethod]
			[Version (since = "1.18")]
			public bool emit_signals { get; set; }
			[NoAccessorMethod]
			public uint64 latency { get; set; }
			[NoAccessorMethod]
			[Version (since = "1.16")]
			public uint64 min_upstream_latency { get; set; }
			[NoAccessorMethod]
			public uint64 start_time { get; set; }
			[NoAccessorMethod]
			public Gst.Base.AggregatorStartTimeSelection start_time_selection { get; set; }
			[Version (since = "1.18")]
			public signal void samples_selected (Gst.Segment segment, uint64 pts, uint64 dts, uint64 duration, Gst.Structure? info);
		}
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstAggregatorPad", lower_case_cprefix = "gst_aggregator_pad_", type_id = "gst_aggregator_pad_get_type ()")]
		[GIR (name = "AggregatorPad")]
		[Version (since = "1.14")]
		public class AggregatorPad : Gst.Pad {
			public weak Gst.Segment segment;
			[CCode (has_construct_function = false)]
			protected AggregatorPad ();
			public bool drop_buffer ();
			[NoWrapper]
			public virtual Gst.FlowReturn flush (Gst.Base.Aggregator aggregator);
			[Version (since = "1.14.1")]
			public bool has_buffer ();
			public bool is_eos ();
			public Gst.Buffer? peek_buffer ();
			public Gst.Buffer? pop_buffer ();
			[NoWrapper]
			public virtual bool skip_buffer (Gst.Base.Aggregator aggregator, Gst.Buffer buffer);
			[NoAccessorMethod]
			[Version (since = "1.16")]
			public bool emit_signals { get; set; }
			public signal void buffer_consumed (Gst.Buffer object);
		}
		[CCode (cheader_filename = "gst/base/gstadapter.h,gst/base/gstbaseparse.h,gst/base/gstbasesink.h,gst/base/gstbasesrc.h,gst/base/gstbasetransform.h,gst/base/gstbitreader.h,gst/base/gstbytereader.h,gst/base/gstbytewriter.h,gst/base/gstcollectpads.h,gst/base/gstpushsrc.h,gst/base/gsttypefindhelper.h", cname = "GstBitReader", has_type_id = false)]
		[Compact]
		[GIR (name = "BitReader")]
		public class BitReader {
			public uint bit;
			public uint byte;
			[CCode (array_length_cname = "size", array_length_type = "guint")]
			public weak uint8[] data;
			public uint size;
			public BitReader ([CCode (array_length_type = "guint")] uint8[] data);
			[CCode (cname = "gst_bit_reader_free")]
			[DestroysInstance]
			public void free ();
			[CCode (cname = "gst_bit_reader_get_bits_uint16")]
			public bool get_bits_uint16 (out uint16 val, uint nbits);
			[CCode (cname = "gst_bit_reader_get_bits_uint32")]
			public bool get_bits_uint32 (out uint32 val, uint nbits);
			[CCode (cname = "gst_bit_reader_get_bits_uint64")]
			public bool get_bits_uint64 (out uint64 val, uint nbits);
			[CCode (cname = "gst_bit_reader_get_bits_uint8")]
			public bool get_bits_uint8 (out uint8 val, uint nbits);
			[CCode (cname = "gst_bit_reader_get_pos")]
			public uint get_pos ();
			[CCode (cname = "gst_bit_reader_get_remaining")]
			public uint get_remaining ();
			[CCode (cname = "gst_bit_reader_get_size")]
			public uint get_size ();
			[CCode (cname = "gst_bit_reader_init")]
			public void init ([CCode (array_length_cname = "size", array_length_pos = 1.1, array_length_type = "guint")] uint8[] data);
			[CCode (cname = "gst_bit_reader_peek_bits_uint16")]
			public bool peek_bits_uint16 (out uint16 val, uint nbits);
			[CCode (cname = "gst_bit_reader_peek_bits_uint32")]
			public bool peek_bits_uint32 (out uint32 val, uint nbits);
			[CCode (cname = "gst_bit_reader_peek_bits_uint64")]
			public bool peek_bits_uint64 (out uint64 val, uint nbits);
			[CCode (cname = "gst_bit_reader_peek_bits_uint8")]
			public bool peek_bits_uint8 (out uint8 val, uint nbits);
			[CCode (cname = "gst_bit_reader_set_pos")]
			public bool set_pos (uint pos);
			[CCode (cname = "gst_bit_reader_skip")]
			public bool skip (uint nbits);
			[CCode (cname = "gst_bit_reader_skip_to_byte")]
			public bool skip_to_byte ();
		}
		[CCode (cheader_filename = "gst/base/gstadapter.h,gst/base/gstbaseparse.h,gst/base/gstbasesink.h,gst/base/gstbasesrc.h,gst/base/gstbasetransform.h,gst/base/gstbitreader.h,gst/base/gstbytereader.h,gst/base/gstbytewriter.h,gst/base/gstcollectpads.h,gst/base/gstpushsrc.h,gst/base/gsttypefindhelper.h", cname = "GstBitReader", has_type_id = false)]
		[Compact]
		[GIR (name = "ByteReader")]
		public class ByteReader {
			public uint byte;
			[CCode (array_length_cname = "size", array_length_type = "guint")]
			public weak uint8[] data;
			public uint size;
			public ByteReader ([CCode (array_length_type = "guint")] uint8[] data);
			[CCode (cname = "gst_byte_reader_dup_data")]
			public bool dup_data ([CCode (array_length_cname = "size", array_length_pos = 0.5, array_length_type = "guint")] out uint8[] val);
			[CCode (cname = "gst_byte_reader_dup_string_utf16")]
			public bool dup_string_utf16 ([CCode (array_length = false, array_null_terminated = true)] out uint16[] str);
			[CCode (cname = "gst_byte_reader_dup_string_utf32")]
			public bool dup_string_utf32 ([CCode (array_length = false, array_null_terminated = true)] out uint32[] str);
			[CCode (cname = "gst_byte_reader_dup_string_utf8")]
			public bool dup_string_utf8 ([CCode (array_length = false, array_null_terminated = true)] out string[] str);
			[CCode (cname = "gst_byte_reader_free")]
			[DestroysInstance]
			public void free ();
			[CCode (cname = "gst_byte_reader_get_data")]
			public bool get_data ([CCode (array_length_cname = "size", array_length_pos = 0.5, array_length_type = "guint")] out unowned uint8[] val);
			[CCode (cname = "gst_byte_reader_get_float32_be")]
			public bool get_float32_be (out float val);
			[CCode (cname = "gst_byte_reader_get_float32_le")]
			public bool get_float32_le (out float val);
			[CCode (cname = "gst_byte_reader_get_float64_be")]
			public bool get_float64_be (out double val);
			[CCode (cname = "gst_byte_reader_get_float64_le")]
			public bool get_float64_le (out double val);
			[CCode (cname = "gst_byte_reader_get_int16_be")]
			public bool get_int16_be (out int16 val);
			[CCode (cname = "gst_byte_reader_get_int16_le")]
			public bool get_int16_le (out int16 val);
			[CCode (cname = "gst_byte_reader_get_int24_be")]
			public bool get_int24_be (out int32 val);
			[CCode (cname = "gst_byte_reader_get_int24_le")]
			public bool get_int24_le (out int32 val);
			[CCode (cname = "gst_byte_reader_get_int32_be")]
			public bool get_int32_be (out int32 val);
			[CCode (cname = "gst_byte_reader_get_int32_le")]
			public bool get_int32_le (out int32 val);
			[CCode (cname = "gst_byte_reader_get_int64_be")]
			public bool get_int64_be (out int64 val);
			[CCode (cname = "gst_byte_reader_get_int64_le")]
			public bool get_int64_le (out int64 val);
			[CCode (cname = "gst_byte_reader_get_int8")]
			public bool get_int8 (out int8 val);
			[CCode (cname = "gst_byte_reader_get_pos")]
			public uint get_pos ();
			[CCode (cname = "gst_byte_reader_get_remaining")]
			public uint get_remaining ();
			[CCode (cname = "gst_byte_reader_get_size")]
			public uint get_size ();
			[CCode (cname = "gst_byte_reader_get_string_utf8")]
			public bool get_string_utf8 ([CCode (array_length = false, array_null_terminated = true)] out unowned string[] str);
			[CCode (cname = "gst_byte_reader_get_uint16_be")]
			public bool get_uint16_be (out uint16 val);
			[CCode (cname = "gst_byte_reader_get_uint16_le")]
			public bool get_uint16_le (out uint16 val);
			[CCode (cname = "gst_byte_reader_get_uint24_be")]
			public bool get_uint24_be (out uint32 val);
			[CCode (cname = "gst_byte_reader_get_uint24_le")]
			public bool get_uint24_le (out uint32 val);
			[CCode (cname = "gst_byte_reader_get_uint32_be")]
			public bool get_uint32_be (out uint32 val);
			[CCode (cname = "gst_byte_reader_get_uint32_le")]
			public bool get_uint32_le (out uint32 val);
			[CCode (cname = "gst_byte_reader_get_uint64_be")]
			public bool get_uint64_be (out uint64 val);
			[CCode (cname = "gst_byte_reader_get_uint64_le")]
			public bool get_uint64_le (out uint64 val);
			[CCode (cname = "gst_byte_reader_get_uint8")]
			public bool get_uint8 (out uint8 val);
			[CCode (cname = "gst_byte_reader_init")]
			public void init ([CCode (array_length_cname = "size", array_length_pos = 1.1, array_length_type = "guint")] uint8[] data);
			[CCode (cname = "gst_byte_reader_masked_scan_uint32")]
			public uint masked_scan_uint32 (uint32 mask, uint32 pattern, uint offset, uint size);
			[CCode (cname = "gst_byte_reader_masked_scan_uint32_peek")]
			[Version (since = "1.6")]
			public uint masked_scan_uint32_peek (uint32 mask, uint32 pattern, uint offset, uint size, out uint32 value);
			[CCode (cname = "gst_byte_reader_peek_data")]
			public bool peek_data ([CCode (array_length_cname = "size", array_length_pos = 0.5, array_length_type = "guint")] out unowned uint8[] val);
			[CCode (cname = "gst_byte_reader_peek_float32_be")]
			public bool peek_float32_be (out float val);
			[CCode (cname = "gst_byte_reader_peek_float32_le")]
			public bool peek_float32_le (out float val);
			[CCode (cname = "gst_byte_reader_peek_float64_be")]
			public bool peek_float64_be (out double val);
			[CCode (cname = "gst_byte_reader_peek_float64_le")]
			public bool peek_float64_le (out double val);
			[CCode (cname = "gst_byte_reader_peek_int16_be")]
			public bool peek_int16_be (out int16 val);
			[CCode (cname = "gst_byte_reader_peek_int16_le")]
			public bool peek_int16_le (out int16 val);
			[CCode (cname = "gst_byte_reader_peek_int24_be")]
			public bool peek_int24_be (out int32 val);
			[CCode (cname = "gst_byte_reader_peek_int24_le")]
			public bool peek_int24_le (out int32 val);
			[CCode (cname = "gst_byte_reader_peek_int32_be")]
			public bool peek_int32_be (out int32 val);
			[CCode (cname = "gst_byte_reader_peek_int32_le")]
			public bool peek_int32_le (out int32 val);
			[CCode (cname = "gst_byte_reader_peek_int64_be")]
			public bool peek_int64_be (out int64 val);
			[CCode (cname = "gst_byte_reader_peek_int64_le")]
			public bool peek_int64_le (out int64 val);
			[CCode (cname = "gst_byte_reader_peek_int8")]
			public bool peek_int8 (out int8 val);
			[CCode (cname = "gst_byte_reader_peek_string_utf8")]
			public bool peek_string_utf8 ([CCode (array_length = false, array_null_terminated = true)] out unowned string[] str);
			[CCode (cname = "gst_byte_reader_peek_uint16_be")]
			public bool peek_uint16_be (out uint16 val);
			[CCode (cname = "gst_byte_reader_peek_uint16_le")]
			public bool peek_uint16_le (out uint16 val);
			[CCode (cname = "gst_byte_reader_peek_uint24_be")]
			public bool peek_uint24_be (out uint32 val);
			[CCode (cname = "gst_byte_reader_peek_uint24_le")]
			public bool peek_uint24_le (out uint32 val);
			[CCode (cname = "gst_byte_reader_peek_uint32_be")]
			public bool peek_uint32_be (out uint32 val);
			[CCode (cname = "gst_byte_reader_peek_uint32_le")]
			public bool peek_uint32_le (out uint32 val);
			[CCode (cname = "gst_byte_reader_peek_uint64_be")]
			public bool peek_uint64_be (out uint64 val);
			[CCode (cname = "gst_byte_reader_peek_uint64_le")]
			public bool peek_uint64_le (out uint64 val);
			[CCode (cname = "gst_byte_reader_peek_uint8")]
			public bool peek_uint8 (out uint8 val);
			[CCode (cname = "gst_byte_reader_set_pos")]
			public bool set_pos (uint pos);
			[CCode (cname = "gst_byte_reader_skip")]
			public bool skip (uint nbytes);
			[CCode (cname = "gst_byte_reader_skip_string_utf16")]
			public bool skip_string_utf16 ();
			[CCode (cname = "gst_byte_reader_skip_string_utf32")]
			public bool skip_string_utf32 ();
			[CCode (cname = "gst_byte_reader_skip_string_utf8")]
			public bool skip_string_utf8 ();
		}
		[CCode (cheader_filename = "gst/base/gstadapter.h,gst/base/gstbaseparse.h,gst/base/gstbasesink.h,gst/base/gstbasesrc.h,gst/base/gstbasetransform.h,gst/base/gstbitreader.h,gst/base/gstbytereader.h,gst/base/gstbytewriter.h,gst/base/gstcollectpads.h,gst/base/gstpushsrc.h,gst/base/gsttypefindhelper.h", cname = "GstBitReader", has_type_id = false)]
		[Compact]
		[GIR (name = "ByteWriter")]
		public class ByteWriter {
			public uint alloc_size;
			public bool fixed;
			public bool @owned;
			public weak Gst.Base.ByteReader parent;
			public ByteWriter ();
			[CCode (cname = "gst_byte_writer_ensure_free_space")]
			public bool ensure_free_space (uint size);
			[CCode (cname = "gst_byte_writer_fill")]
			public bool fill (uint8 value, uint size);
			[CCode (cname = "gst_byte_writer_free")]
			[DestroysInstance]
			public void free ();
			[CCode (cname = "gst_byte_writer_free_and_get_buffer")]
			[DestroysInstance]
			public Gst.Buffer free_and_get_buffer ();
			[CCode (cname = "gst_byte_writer_free_and_get_data")]
			[DestroysInstance]
			public uint8 free_and_get_data ();
			[CCode (cname = "gst_byte_writer_get_remaining")]
			public uint get_remaining ();
			[CCode (cname = "gst_byte_writer_init")]
			public void init ();
			[CCode (cname = "gst_byte_writer_init_with_data")]
			public void init_with_data ([CCode (array_length_cname = "size", array_length_pos = 1.5, array_length_type = "guint")] uint8[] data, bool initialized);
			[CCode (cname = "gst_byte_writer_init_with_size")]
			public void init_with_size (uint size, bool fixed);
			[CCode (cname = "gst_byte_writer_put_buffer")]
			public bool put_buffer (Gst.Buffer buffer, size_t offset, ssize_t size);
			[CCode (cname = "gst_byte_writer_put_data")]
			public bool put_data ([CCode (array_length_cname = "size", array_length_pos = 1.1, array_length_type = "guint")] uint8[] data);
			[CCode (cname = "gst_byte_writer_put_float32_be")]
			public bool put_float32_be (float val);
			[CCode (cname = "gst_byte_writer_put_float32_le")]
			public bool put_float32_le (float val);
			[CCode (cname = "gst_byte_writer_put_float64_be")]
			public bool put_float64_be (double val);
			[CCode (cname = "gst_byte_writer_put_float64_le")]
			public bool put_float64_le (double val);
			[CCode (cname = "gst_byte_writer_put_int16_be")]
			public bool put_int16_be (int16 val);
			[CCode (cname = "gst_byte_writer_put_int16_le")]
			public bool put_int16_le (int16 val);
			[CCode (cname = "gst_byte_writer_put_int24_be")]
			public bool put_int24_be (int32 val);
			[CCode (cname = "gst_byte_writer_put_int24_le")]
			public bool put_int24_le (int32 val);
			[CCode (cname = "gst_byte_writer_put_int32_be")]
			public bool put_int32_be (int32 val);
			[CCode (cname = "gst_byte_writer_put_int32_le")]
			public bool put_int32_le (int32 val);
			[CCode (cname = "gst_byte_writer_put_int64_be")]
			public bool put_int64_be (int64 val);
			[CCode (cname = "gst_byte_writer_put_int64_le")]
			public bool put_int64_le (int64 val);
			[CCode (cname = "gst_byte_writer_put_int8")]
			public bool put_int8 (int8 val);
			[CCode (cname = "gst_byte_writer_put_string_utf16")]
			public bool put_string_utf16 ([CCode (array_length = false, array_null_terminated = true)] uint16[] data);
			[CCode (cname = "gst_byte_writer_put_string_utf32")]
			public bool put_string_utf32 ([CCode (array_length = false, array_null_terminated = true)] uint32[] data);
			[CCode (cname = "gst_byte_writer_put_string_utf8")]
			public bool put_string_utf8 (string data);
			[CCode (cname = "gst_byte_writer_put_uint16_be")]
			public bool put_uint16_be (uint16 val);
			[CCode (cname = "gst_byte_writer_put_uint16_le")]
			public bool put_uint16_le (uint16 val);
			[CCode (cname = "gst_byte_writer_put_uint24_be")]
			public bool put_uint24_be (uint32 val);
			[CCode (cname = "gst_byte_writer_put_uint24_le")]
			public bool put_uint24_le (uint32 val);
			[CCode (cname = "gst_byte_writer_put_uint32_be")]
			public bool put_uint32_be (uint32 val);
			[CCode (cname = "gst_byte_writer_put_uint32_le")]
			public bool put_uint32_le (uint32 val);
			[CCode (cname = "gst_byte_writer_put_uint64_be")]
			public bool put_uint64_be (uint64 val);
			[CCode (cname = "gst_byte_writer_put_uint64_le")]
			public bool put_uint64_le (uint64 val);
			[CCode (cname = "gst_byte_writer_put_uint8")]
			public bool put_uint8 (uint8 val);
			[CCode (cname = "gst_byte_writer_reset")]
			public void reset ();
			[CCode (cname = "gst_byte_writer_reset_and_get_buffer")]
			public Gst.Buffer reset_and_get_buffer ();
			[CCode (array_length = false, cname = "gst_byte_writer_reset_and_get_data")]
			public uint8[] reset_and_get_data ();
			public ByteWriter.with_data ([CCode (array_length_type = "guint")] uint8[] data, uint size, bool initialized);
			public ByteWriter.with_size (uint size, bool fixed);
		}
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstCollectPads", lower_case_cprefix = "gst_collect_pads_", type_id = "gst_collect_pads_get_type ()")]
		[GIR (name = "CollectPads")]
		public class CollectPads : Gst.Object {
			public weak GLib.SList<Gst.Base.CollectData?> data;
			[CCode (has_construct_function = false)]
			public CollectPads ();
			public unowned Gst.Base.CollectData? add_pad (Gst.Pad pad, uint size, [CCode (scope = "async")] Gst.Base.CollectDataDestroyNotify destroy_notify, bool @lock);
			public uint available ();
			public Gst.FlowReturn clip_running_time (Gst.Base.CollectData cdata, Gst.Buffer buf, out Gst.Buffer outbuf, void* user_data);
			public bool event_default (Gst.Base.CollectData data, Gst.Event event, bool discard);
			public uint flush (Gst.Base.CollectData data, uint size);
			public Gst.Buffer? peek (Gst.Base.CollectData data);
			public Gst.Buffer? pop (Gst.Base.CollectData data);
			public bool query_default (Gst.Base.CollectData data, Gst.Query query, bool discard);
			public Gst.Buffer? read_buffer (Gst.Base.CollectData data, uint size);
			public bool remove_pad (Gst.Pad pad);
			public void set_buffer_function (Gst.Base.CollectPadsBufferFunction func);
			public void set_clip_function (Gst.Base.CollectPadsClipFunction clipfunc);
			public void set_compare_function (Gst.Base.CollectPadsCompareFunction func);
			public void set_event_function (Gst.Base.CollectPadsEventFunction func);
			[Version (since = "1.4")]
			public void set_flush_function (Gst.Base.CollectPadsFlushFunction func);
			public void set_flushing (bool flushing);
			public void set_function (Gst.Base.CollectPadsFunction func);
			public void set_query_function (Gst.Base.CollectPadsQueryFunction func);
			public void set_waiting (Gst.Base.CollectData data, bool waiting);
			[Version (since = "1.4")]
			public bool src_event_default (Gst.Pad pad, Gst.Event event);
			public void start ();
			public void stop ();
			public Gst.Buffer? take_buffer (Gst.Base.CollectData data, uint size);
		}
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstDataQueue", lower_case_cprefix = "gst_data_queue_", type_id = "gst_data_queue_get_type ()")]
		[GIR (name = "DataQueue")]
		public class DataQueue : GLib.Object {
			[CCode (has_construct_function = false)]
			protected DataQueue ();
			[NoWrapper]
			public virtual void empty ();
			[NoWrapper]
			public virtual void full ();
			[NoAccessorMethod]
			public uint current_level_bytes { get; }
			[NoAccessorMethod]
			public uint64 current_level_time { get; }
			[NoAccessorMethod]
			public uint current_level_visible { get; }
		}
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstFlowCombiner", copy_function = "g_boxed_copy", free_function = "g_boxed_free", lower_case_cprefix = "gst_flow_combiner_", type_id = "gst_flow_combiner_get_type ()")]
		[Compact]
		[GIR (name = "FlowCombiner")]
		[Version (since = "1.4")]
		public class FlowCombiner {
			[CCode (has_construct_function = false)]
			public FlowCombiner ();
			public void add_pad (Gst.Pad pad);
			[Version (since = "1.6")]
			public void clear ();
			public void free ();
			[Version (since = "1.12.1")]
			public unowned Gst.Base.FlowCombiner @ref ();
			public void remove_pad (Gst.Pad pad);
			[Version (since = "1.6")]
			public void reset ();
			[Version (since = "1.12.1")]
			public void unref ();
			public Gst.FlowReturn update_flow (Gst.FlowReturn fret);
			[Version (since = "1.6")]
			public Gst.FlowReturn update_pad_flow (Gst.Pad pad, Gst.FlowReturn fret);
		}
		[CCode (cheader_filename = "gst/base/base.h", type_id = "gst_base_parse_get_type ()")]
		[GIR (name = "BaseParse")]
		public abstract class Parse : Gst.Element {
			public uint flags;
			public weak Gst.Segment segment;
			public weak Gst.Pad sinkpad;
			public weak Gst.Pad srcpad;
			[CCode (has_construct_function = false)]
			protected Parse ();
			public bool add_index_entry (uint64 offset, Gst.ClockTime ts, bool key, bool force);
			[NoWrapper]
			public virtual bool convert (Gst.Format src_format, int64 src_value, Gst.Format dest_format, out int64 dest_value);
			public bool convert_default (Gst.Format src_format, int64 src_value, Gst.Format dest_format, out int64 dest_value);
			[NoWrapper]
			public virtual Gst.FlowReturn detect (Gst.Buffer buffer);
			[Version (since = "1.12")]
			public void drain ();
			public Gst.FlowReturn finish_frame (Gst.Base.ParseFrame frame, int size);
			[NoWrapper]
			public virtual Gst.Caps get_sink_caps (Gst.Caps filter);
			[NoWrapper]
			public virtual Gst.FlowReturn handle_frame (Gst.Base.ParseFrame frame, out int skipsize);
			[Version (since = "1.6")]
			public void merge_tags (Gst.TagList? tags, Gst.TagMergeMode mode);
			[NoWrapper]
			public virtual Gst.FlowReturn pre_push_frame (Gst.Base.ParseFrame frame);
			public Gst.FlowReturn push_frame (Gst.Base.ParseFrame frame);
			public void set_average_bitrate (uint bitrate);
			public void set_duration (Gst.Format fmt, int64 duration, int interval);
			public void set_frame_rate (uint fps_num, uint fps_den, uint lead_in, uint lead_out);
			public void set_has_timing_info (bool has_timing);
			public void set_infer_ts (bool infer_ts);
			public void set_latency (Gst.ClockTime min_latency, Gst.ClockTime max_latency);
			public void set_min_frame_size (uint min_size);
			public void set_passthrough (bool passthrough);
			public void set_pts_interpolation (bool pts_interpolate);
			[NoWrapper]
			public virtual bool set_sink_caps (Gst.Caps caps);
			public void set_syncable (bool syncable);
			[Version (since = "1.2")]
			public void set_ts_at_offset (size_t offset);
			[NoWrapper]
			public virtual bool sink_event (Gst.Event event);
			[NoWrapper]
			public virtual bool sink_query (Gst.Query query);
			[NoWrapper]
			public virtual bool src_event (Gst.Event event);
			[NoWrapper]
			public virtual bool src_query (Gst.Query query);
			[NoWrapper]
			public virtual bool start ();
			[NoWrapper]
			public virtual bool stop ();
			[NoAccessorMethod]
			public bool disable_passthrough { get; set; }
		}
		[CCode (cheader_filename = "gst/base/base.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gst_base_parse_frame_get_type ()")]
		[Compact]
		[GIR (name = "BaseParseFrame")]
		public class ParseFrame {
			public weak Gst.Buffer buffer;
			public uint flags;
			public uint64 offset;
			public weak Gst.Buffer out_buffer;
			public int overhead;
			[CCode (has_construct_function = false)]
			public ParseFrame (Gst.Buffer buffer, Gst.Base.ParseFrameFlags flags, int overhead);
			[Version (since = "1.12.1")]
			public Gst.Base.ParseFrame copy ();
			public void free ();
			public void init ();
		}
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstPushSrc", lower_case_cprefix = "gst_push_src_", type_id = "gst_push_src_get_type ()")]
		[GIR (name = "PushSrc")]
		public class PushSrc : Gst.Base.Src {
			[CCode (has_construct_function = false)]
			protected PushSrc ();
			[NoWrapper]
			public virtual Gst.FlowReturn alloc (out Gst.Buffer buf);
			[NoWrapper]
			public virtual Gst.FlowReturn create (out Gst.Buffer buf);
			[NoWrapper]
			public virtual Gst.FlowReturn fill (Gst.Buffer buf);
		}
		[CCode (cheader_filename = "gst/base/base.h", type_id = "gst_base_sink_get_type ()")]
		[GIR (name = "BaseSink")]
		public abstract class Sink : Gst.Element {
			public bool can_activate_pull;
			public bool can_activate_push;
			public bool eos;
			public bool have_newsegment;
			public bool have_preroll;
			public bool need_preroll;
			public uint64 offset;
			public Gst.PadMode pad_mode;
			public bool playing_async;
			public GLib.Cond preroll_cond;
			public GLib.Mutex preroll_lock;
			public weak Gst.Segment segment;
			public weak Gst.Pad sinkpad;
			[CCode (has_construct_function = false)]
			protected Sink ();
			[NoWrapper]
			public virtual bool activate_pull (bool active);
			public Gst.FlowReturn do_preroll (Gst.MiniObject obj);
			[NoWrapper]
			public virtual bool event (Gst.Event event);
			[NoWrapper]
			public virtual Gst.Caps fixate (Gst.Caps caps);
			public uint get_blocksize ();
			[NoWrapper]
			public virtual Gst.Caps get_caps (Gst.Caps filter);
			[Version (since = "1.12")]
			public bool get_drop_out_of_segment ();
			public Gst.Sample? get_last_sample ();
			public Gst.ClockTime get_latency ();
			[Version (since = "1.2")]
			public uint64 get_max_bitrate ();
			public int64 get_max_lateness ();
			[Version (since = "1.16")]
			public Gst.ClockTime get_processing_deadline ();
			public Gst.ClockTime get_render_delay ();
			[Version (since = "1.18")]
			public Gst.Structure get_stats ();
			public bool get_sync ();
			public uint64 get_throttle_time ();
			[NoWrapper]
			public virtual void get_times (Gst.Buffer buffer, out Gst.ClockTime start, out Gst.ClockTime end);
			public Gst.ClockTimeDiff get_ts_offset ();
			public bool is_async_enabled ();
			public bool is_last_sample_enabled ();
			public bool is_qos_enabled ();
			[NoWrapper]
			public virtual Gst.FlowReturn prepare (Gst.Buffer buffer);
			[NoWrapper]
			public virtual Gst.FlowReturn prepare_list (Gst.BufferList buffer_list);
			[NoWrapper]
			public virtual Gst.FlowReturn preroll (Gst.Buffer buffer);
			[NoWrapper]
			public virtual bool propose_allocation (Gst.Query query);
			[NoWrapper]
			public virtual bool query (Gst.Query query);
			public bool query_latency (out bool live, out bool upstream_live, out Gst.ClockTime min_latency, out Gst.ClockTime max_latency);
			[NoWrapper]
			public virtual Gst.FlowReturn render (Gst.Buffer buffer);
			[NoWrapper]
			public virtual Gst.FlowReturn render_list (Gst.BufferList buffer_list);
			public void set_async_enabled (bool enabled);
			public void set_blocksize (uint blocksize);
			[NoWrapper]
			public virtual bool set_caps (Gst.Caps caps);
			[Version (since = "1.12")]
			public void set_drop_out_of_segment (bool drop_out_of_segment);
			public void set_last_sample_enabled (bool enabled);
			[Version (since = "1.2")]
			public void set_max_bitrate (uint64 max_bitrate);
			public void set_max_lateness (int64 max_lateness);
			[Version (since = "1.16")]
			public void set_processing_deadline (Gst.ClockTime processing_deadline);
			public void set_qos_enabled (bool enabled);
			public void set_render_delay (Gst.ClockTime delay);
			public void set_sync (bool sync);
			public void set_throttle_time (uint64 throttle);
			public void set_ts_offset (Gst.ClockTimeDiff offset);
			[NoWrapper]
			public virtual bool start ();
			[NoWrapper]
			public virtual bool stop ();
			[NoWrapper]
			public virtual bool @unlock ();
			[NoWrapper]
			public virtual bool unlock_stop ();
			public Gst.FlowReturn wait (Gst.ClockTime time, out Gst.ClockTimeDiff jitter);
			public Gst.ClockReturn wait_clock (Gst.ClockTime time, out Gst.ClockTimeDiff jitter);
			[NoWrapper]
			public virtual Gst.FlowReturn wait_event (Gst.Event event);
			public Gst.FlowReturn wait_preroll ();
			[NoAccessorMethod]
			public bool @async { get; set; }
			public uint blocksize { get; set; }
			[NoAccessorMethod]
			public bool enable_last_sample { get; set; }
			public Gst.Sample last_sample { owned get; }
			[Version (since = "1.2")]
			public uint64 max_bitrate { get; set; }
			public int64 max_lateness { get; set; }
			[Version (since = "1.16")]
			public uint64 processing_deadline { get; set; }
			[NoAccessorMethod]
			public bool qos { get; set; }
			public uint64 render_delay { get; set; }
			[Version (since = "1.18")]
			public Gst.Structure stats { owned get; }
			public bool sync { get; set; }
			public uint64 throttle_time { get; set; }
			public int64 ts_offset { get; set; }
		}
		[CCode (cheader_filename = "gst/base/base.h", type_id = "gst_base_src_get_type ()")]
		[GIR (name = "BaseSrc")]
		public abstract class Src : Gst.Element {
			public bool can_activate_push;
			public Gst.ClockID clock_id;
			public GLib.Cond live_cond;
			public GLib.Mutex live_lock;
			public bool live_running;
			public bool need_newsegment;
			public int num_buffers_left;
			public weak Gst.Event pending_seek;
			public bool random_access;
			public bool running;
			public weak Gst.Segment segment;
			public weak Gst.Pad srcpad;
			[CCode (has_construct_function = false)]
			protected Src ();
			[NoWrapper]
			public virtual Gst.FlowReturn alloc (uint64 offset, uint size, out Gst.Buffer buf);
			[NoWrapper]
			public virtual Gst.FlowReturn create (uint64 offset, uint size, ref Gst.Buffer buf);
			[NoWrapper]
			public virtual bool decide_allocation (Gst.Query query);
			[NoWrapper]
			public virtual bool do_seek (Gst.Segment segment);
			[NoWrapper]
			public virtual bool event (Gst.Event event);
			[NoWrapper]
			public virtual Gst.FlowReturn fill (uint64 offset, uint size, Gst.Buffer buf);
			[NoWrapper]
			public virtual Gst.Caps fixate (Gst.Caps caps);
			public void get_allocator (out Gst.Allocator? allocator, out unowned Gst.AllocationParams @params);
			public uint get_blocksize ();
			public Gst.BufferPool? get_buffer_pool ();
			[NoWrapper]
			public virtual Gst.Caps get_caps (Gst.Caps? filter);
			public bool get_do_timestamp ();
			[NoWrapper]
			public virtual bool get_size (out uint64 size);
			[NoWrapper]
			public virtual void get_times (Gst.Buffer buffer, out Gst.ClockTime start, out Gst.ClockTime end);
			public bool is_async ();
			[NoWrapper]
			public virtual bool is_seekable ();
			[Version (since = "1.18")]
			public virtual bool negotiate ();
			[Version (deprecated = true, deprecated_since = "1.18")]
			public bool new_seamless_segment (int64 start, int64 stop, int64 time);
			[Version (since = "1.18")]
			public bool new_segment (Gst.Segment segment);
			[NoWrapper]
			public virtual bool prepare_seek_segment (Gst.Event seek, Gst.Segment segment);
			[NoWrapper]
			public virtual bool query (Gst.Query query);
			public bool query_latency (out bool live, out Gst.ClockTime min_latency, out Gst.ClockTime max_latency);
			public void set_async (bool @async);
			[Version (since = "1.4")]
			public void set_automatic_eos (bool automatic_eos);
			public void set_blocksize (uint blocksize);
			public virtual bool set_caps (Gst.Caps caps);
			public void set_do_timestamp (bool timestamp);
			public void set_dynamic_size (bool @dynamic);
			public void set_format (Gst.Format format);
			public void set_live (bool live);
			[NoWrapper]
			public virtual bool start ();
			public void start_complete (Gst.FlowReturn ret);
			public Gst.FlowReturn start_wait ();
			[NoWrapper]
			public virtual bool stop ();
			[Version (since = "1.14")]
			public void submit_buffer_list (owned Gst.BufferList buffer_list);
			[NoWrapper]
			public virtual bool @unlock ();
			[NoWrapper]
			public virtual bool unlock_stop ();
			public Gst.FlowReturn wait_playing ();
			public uint blocksize { get; set; }
			public bool do_timestamp { get; set; }
			[NoAccessorMethod]
			public int num_buffers { get; set; }
			[NoAccessorMethod]
			public bool typefind { get; set; }
		}
		[CCode (cheader_filename = "gst/base/base.h", type_id = "gst_base_transform_get_type ()")]
		[GIR (name = "BaseTransform")]
		public abstract class Transform : Gst.Element {
			public bool have_segment;
			public weak Gst.Buffer queued_buf;
			public weak Gst.Segment segment;
			public weak Gst.Pad sinkpad;
			public weak Gst.Pad srcpad;
			[CCode (has_construct_function = false)]
			protected Transform ();
			[NoWrapper]
			public virtual bool accept_caps (Gst.PadDirection direction, Gst.Caps caps);
			[NoWrapper]
			public virtual void before_transform (Gst.Buffer buffer);
			[NoWrapper]
			public virtual bool copy_metadata (Gst.Buffer input, Gst.Buffer outbuf);
			[NoWrapper]
			public virtual bool decide_allocation (Gst.Query query);
			[NoWrapper]
			public virtual bool filter_meta (Gst.Query query, GLib.Type api, Gst.Structure @params);
			[NoWrapper]
			public virtual Gst.Caps fixate_caps (Gst.PadDirection direction, Gst.Caps caps, owned Gst.Caps othercaps);
			[NoWrapper]
			public virtual Gst.FlowReturn generate_output (out Gst.Buffer outbuf);
			public void get_allocator (out Gst.Allocator? allocator, out unowned Gst.AllocationParams @params);
			public Gst.BufferPool? get_buffer_pool ();
			[NoWrapper]
			public virtual bool get_unit_size (Gst.Caps caps, out size_t size);
			public bool is_in_place ();
			public bool is_passthrough ();
			public bool is_qos_enabled ();
			[NoWrapper]
			public virtual Gst.FlowReturn prepare_output_buffer (Gst.Buffer input, out Gst.Buffer outbuf);
			[NoWrapper]
			public virtual bool propose_allocation (Gst.Query decide_query, Gst.Query query);
			[NoWrapper]
			public virtual bool query (Gst.PadDirection direction, Gst.Query query);
			[Version (since = "1.18")]
			public bool reconfigure ();
			public void reconfigure_sink ();
			public void reconfigure_src ();
			[NoWrapper]
			public virtual bool set_caps (Gst.Caps incaps, Gst.Caps outcaps);
			public void set_gap_aware (bool gap_aware);
			public void set_in_place (bool in_place);
			public void set_passthrough (bool passthrough);
			[Version (since = "1.0.1")]
			public void set_prefer_passthrough (bool prefer_passthrough);
			public void set_qos_enabled (bool enabled);
			[NoWrapper]
			public virtual bool sink_event (owned Gst.Event event);
			[NoWrapper]
			public virtual bool src_event (owned Gst.Event event);
			[NoWrapper]
			public virtual bool start ();
			[NoWrapper]
			public virtual bool stop ();
			[NoWrapper]
			public virtual Gst.FlowReturn submit_input_buffer (bool is_discont, Gst.Buffer input);
			[NoWrapper]
			public virtual Gst.FlowReturn transform (Gst.Buffer inbuf, Gst.Buffer outbuf);
			[NoWrapper]
			public virtual Gst.Caps transform_caps (Gst.PadDirection direction, Gst.Caps caps, Gst.Caps filter);
			[NoWrapper]
			public virtual Gst.FlowReturn transform_ip (Gst.Buffer buf);
			[NoWrapper]
			public virtual bool transform_meta (Gst.Buffer outbuf, Gst.Meta meta, Gst.Buffer inbuf);
			[NoWrapper]
			public virtual bool transform_size (Gst.PadDirection direction, Gst.Caps caps, size_t size, Gst.Caps othercaps, out size_t othersize);
			public void update_qos (double proportion, Gst.ClockTimeDiff diff, Gst.ClockTime timestamp);
			[Version (since = "1.6")]
			public bool update_src_caps (Gst.Caps updated_caps);
			[NoAccessorMethod]
			public bool qos { get; set; }
		}
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstBitWriter", has_type_id = false)]
		[GIR (name = "BitWriter")]
		[Version (since = "1.16")]
		public struct BitWriter {
			public uint8 data;
			public uint bit_size;
			[CCode (cname = "gst_bit_writer_align_bytes")]
			public bool align_bytes (uint8 trailing_bit);
			[CCode (cname = "gst_bit_writer_free")]
			[DestroysInstance]
			public void free ();
			[CCode (cname = "gst_bit_writer_free_and_get_buffer")]
			[DestroysInstance]
			public Gst.Buffer free_and_get_buffer ();
			[CCode (array_length = false, cname = "gst_bit_writer_free_and_get_data")]
			[DestroysInstance]
			public uint8[] free_and_get_data ();
			[CCode (cname = "gst_bit_writer_get_data")]
			public uint8 get_data ();
			[CCode (cname = "gst_bit_writer_get_remaining")]
			public uint get_remaining ();
			[CCode (cname = "gst_bit_writer_get_size")]
			public uint get_size ();
			[CCode (cname = "gst_bit_writer_put_bits_uint16")]
			public bool put_bits_uint16 (uint16 value, uint nbits);
			[CCode (cname = "gst_bit_writer_put_bits_uint32")]
			public bool put_bits_uint32 (uint32 value, uint nbits);
			[CCode (cname = "gst_bit_writer_put_bits_uint64")]
			public bool put_bits_uint64 (uint64 value, uint nbits);
			[CCode (cname = "gst_bit_writer_put_bits_uint8")]
			public bool put_bits_uint8 (uint8 value, uint nbits);
			[CCode (cname = "gst_bit_writer_put_bytes")]
			public bool put_bytes ([CCode (array_length_cname = "nbytes", array_length_pos = 1.1, array_length_type = "guint", type = "const guint8*")] uint8[] data);
			[CCode (cname = "gst_bit_writer_reset")]
			public void reset ();
			[CCode (cname = "gst_bit_writer_reset_and_get_buffer")]
			public Gst.Buffer reset_and_get_buffer ();
			[CCode (array_length = false, cname = "gst_bit_writer_reset_and_get_data")]
			public uint8[] reset_and_get_data ();
			[CCode (cname = "gst_bit_writer_set_pos")]
			public bool set_pos (uint pos);
		}
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstCollectData", has_type_id = false)]
		[GIR (name = "CollectData")]
		public struct CollectData {
			public weak Gst.Base.CollectPads collect;
			public weak Gst.Pad pad;
			public weak Gst.Buffer buffer;
			public uint pos;
			public weak Gst.Segment segment;
			[CCode (cname = "ABI.abi.dts")]
			public int64 ABI_abi_dts;
		}
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstAggregatorStartTimeSelection", cprefix = "GST_AGGREGATOR_START_TIME_SELECTION_", type_id = "gst_aggregator_start_time_selection_get_type ()")]
		[GIR (name = "AggregatorStartTimeSelection")]
		[Version (since = "1.18")]
		public enum AggregatorStartTimeSelection {
			ZERO,
			FIRST,
			SET
		}
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstCollectPadsStateFlags", cprefix = "GST_COLLECT_PADS_STATE_", has_type_id = false)]
		[Flags]
		[GIR (name = "CollectPadsStateFlags")]
		public enum CollectPadsStateFlags {
			EOS,
			FLUSHING,
			NEW_SEGMENT,
			WAITING,
			LOCKED
		}
		[CCode (cheader_filename = "gst/base/base.h", cprefix = "GST_BASE_PARSE_FRAME_FLAG_", has_type_id = false)]
		[Flags]
		[GIR (name = "BaseParseFrameFlags")]
		public enum ParseFrameFlags {
			NONE,
			NEW_FRAME,
			NO_FRAME,
			CLIP,
			DROP,
			QUEUE
		}
		[CCode (cheader_filename = "gst/base/base.h", cprefix = "GST_BASE_SRC_FLAG_", has_type_id = false)]
		[Flags]
		[GIR (name = "BaseSrcFlags")]
		public enum SrcFlags {
			STARTING,
			STARTED,
			LAST
		}
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstCollectDataDestroyNotify", has_target = false)]
		public delegate void CollectDataDestroyNotify (Gst.Base.CollectData data);
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstCollectPadsBufferFunction", instance_pos = 3.9)]
		public delegate Gst.FlowReturn CollectPadsBufferFunction (Gst.Base.CollectPads pads, Gst.Base.CollectData data, owned Gst.Buffer buffer);
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstCollectPadsClipFunction", instance_pos = 4.9)]
		public delegate Gst.FlowReturn CollectPadsClipFunction (Gst.Base.CollectPads pads, Gst.Base.CollectData data, owned Gst.Buffer inbuffer, out Gst.Buffer outbuffer);
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstCollectPadsCompareFunction", instance_pos = 5.9)]
		public delegate int CollectPadsCompareFunction (Gst.Base.CollectPads pads, Gst.Base.CollectData data1, Gst.ClockTime timestamp1, Gst.Base.CollectData data2, Gst.ClockTime timestamp2);
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstCollectPadsEventFunction", instance_pos = 3.9)]
		public delegate bool CollectPadsEventFunction (Gst.Base.CollectPads pads, Gst.Base.CollectData pad, Gst.Event event);
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstCollectPadsFlushFunction", instance_pos = 1.9)]
		[Version (since = "1.4")]
		public delegate void CollectPadsFlushFunction (Gst.Base.CollectPads pads);
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstCollectPadsFunction", instance_pos = 1.9)]
		public delegate Gst.FlowReturn CollectPadsFunction (Gst.Base.CollectPads pads);
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstCollectPadsQueryFunction", instance_pos = 3.9)]
		public delegate bool CollectPadsQueryFunction (Gst.Base.CollectPads pads, Gst.Base.CollectData pad, Gst.Query query);
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstDataQueueEmptyCallback", has_target = false)]
		public delegate void DataQueueEmptyCallback (Gst.Base.DataQueue queue, void* checkdata);
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstDataQueueFullCallback", has_target = false)]
		public delegate void DataQueueFullCallback (Gst.Base.DataQueue queue, void* checkdata);
		[CCode (cheader_filename = "gst/base/base.h", cname = "GstTypeFindHelperGetRangeFunction", has_target = false)]
		public delegate Gst.FlowReturn TypeFindHelperGetRangeFunction (Gst.Object obj, Gst.Object? parent, uint64 offset, uint length, out Gst.Buffer buffer);
		[CCode (cheader_filename = "gst/base/base.h", cname = "GST_BASE_PARSE_FLAG_DRAINING")]
		public const int PARSE_FLAG_DRAINING;
		[CCode (cheader_filename = "gst/base/base.h", cname = "GST_BASE_PARSE_FLAG_LOST_SYNC")]
		public const int PARSE_FLAG_LOST_SYNC;
		[CCode (cheader_filename = "gst/base/base.h", cname = "GST_BASE_TRANSFORM_SINK_NAME")]
		public const string TRANSFORM_SINK_NAME;
		[CCode (cheader_filename = "gst/base/base.h", cname = "GST_BASE_TRANSFORM_SRC_NAME")]
		public const string TRANSFORM_SRC_NAME;
		[CCode (cheader_filename = "gst/base/base.h", cname = "gst_type_find_helper")]
		public static Gst.Caps? type_find_helper (Gst.Pad src, uint64 size);
		[CCode (cheader_filename = "gst/base/base.h", cname = "gst_type_find_helper_for_buffer")]
		public static Gst.Caps? type_find_helper_for_buffer (Gst.Object? obj, Gst.Buffer buf, out Gst.TypeFindProbability prob);
		[CCode (cheader_filename = "gst/base/base.h", cname = "gst_type_find_helper_for_buffer_with_extension")]
		[Version (since = "1.16")]
		public static Gst.Caps? type_find_helper_for_buffer_with_extension (Gst.Object? obj, Gst.Buffer buf, string? extension, out Gst.TypeFindProbability prob);
		[CCode (cheader_filename = "gst/base/base.h", cname = "gst_type_find_helper_for_data")]
		public static Gst.Caps? type_find_helper_for_data (Gst.Object? obj, [CCode (array_length_cname = "size", array_length_pos = 2.5, array_length_type = "gsize")] uint8[] data, out Gst.TypeFindProbability prob);
		[CCode (cheader_filename = "gst/base/base.h", cname = "gst_type_find_helper_for_data_with_extension")]
		[Version (since = "1.16")]
		public static Gst.Caps? type_find_helper_for_data_with_extension (Gst.Object? obj, [CCode (array_length_cname = "size", array_length_pos = 2.5, array_length_type = "gsize")] uint8[] data, string? extension, out Gst.TypeFindProbability prob);
		[CCode (cheader_filename = "gst/base/base.h", cname = "gst_type_find_helper_for_extension")]
		public static Gst.Caps? type_find_helper_for_extension (Gst.Object? obj, string extension);
		[CCode (cheader_filename = "gst/base/base.h", cname = "gst_type_find_helper_get_range")]
		public static Gst.Caps? type_find_helper_get_range (Gst.Object obj, Gst.Object? parent, Gst.Base.TypeFindHelperGetRangeFunction func, uint64 size, string? extension, out Gst.TypeFindProbability prob);
		[CCode (cheader_filename = "gst/base/base.h", cname = "gst_type_find_helper_get_range_full")]
		[Version (since = "1.14.3")]
		public static Gst.FlowReturn type_find_helper_get_range_full (Gst.Object obj, Gst.Object? parent, Gst.Base.TypeFindHelperGetRangeFunction func, uint64 size, string? extension, out Gst.Caps caps, out Gst.TypeFindProbability prob);
	}
}
