// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gio_sys;
use glib;
use glib::object::IsA;
use glib::translate::*;
use glib::GString;
use glib::StaticType;
use glib::Value;
use gobject_sys;
use std;
use std::fmt;
use std::ptr;
use SocketConnectable;
use TlsCertificateFlags;

glib_wrapper! {
    pub struct TlsCertificate(Object<gio_sys::GTlsCertificate, gio_sys::GTlsCertificateClass, TlsCertificateClass>);

    match fn {
        get_type => || gio_sys::g_tls_certificate_get_type(),
    }
}

impl TlsCertificate {
    pub fn from_file<P: AsRef<std::path::Path>>(file: P) -> Result<TlsCertificate, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = gio_sys::g_tls_certificate_new_from_file(
                file.as_ref().to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    pub fn from_files<P: AsRef<std::path::Path>, Q: AsRef<std::path::Path>>(
        cert_file: P,
        key_file: Q,
    ) -> Result<TlsCertificate, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = gio_sys::g_tls_certificate_new_from_files(
                cert_file.as_ref().to_glib_none().0,
                key_file.as_ref().to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    pub fn from_pem(data: &str) -> Result<TlsCertificate, glib::Error> {
        let length = data.len() as isize;
        unsafe {
            let mut error = ptr::null_mut();
            let ret =
                gio_sys::g_tls_certificate_new_from_pem(data.to_glib_none().0, length, &mut error);
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    pub fn list_new_from_file<P: AsRef<std::path::Path>>(
        file: P,
    ) -> Result<Vec<TlsCertificate>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = gio_sys::g_tls_certificate_list_new_from_file(
                file.as_ref().to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(FromGlibPtrContainer::from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}

pub const NONE_TLS_CERTIFICATE: Option<&TlsCertificate> = None;

pub trait TlsCertificateExt: 'static {
    fn get_issuer(&self) -> Option<TlsCertificate>;

    fn is_same<P: IsA<TlsCertificate>>(&self, cert_two: &P) -> bool;

    fn verify<P: IsA<SocketConnectable>, Q: IsA<TlsCertificate>>(
        &self,
        identity: Option<&P>,
        trusted_ca: Option<&Q>,
    ) -> TlsCertificateFlags;

    //fn get_property_certificate(&self) -> /*Ignored*/Option<glib::ByteArray>;

    fn get_property_certificate_pem(&self) -> Option<GString>;
}

impl<O: IsA<TlsCertificate>> TlsCertificateExt for O {
    fn get_issuer(&self) -> Option<TlsCertificate> {
        unsafe {
            from_glib_none(gio_sys::g_tls_certificate_get_issuer(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_same<P: IsA<TlsCertificate>>(&self, cert_two: &P) -> bool {
        unsafe {
            from_glib(gio_sys::g_tls_certificate_is_same(
                self.as_ref().to_glib_none().0,
                cert_two.as_ref().to_glib_none().0,
            ))
        }
    }

    fn verify<P: IsA<SocketConnectable>, Q: IsA<TlsCertificate>>(
        &self,
        identity: Option<&P>,
        trusted_ca: Option<&Q>,
    ) -> TlsCertificateFlags {
        unsafe {
            from_glib(gio_sys::g_tls_certificate_verify(
                self.as_ref().to_glib_none().0,
                identity.map(|p| p.as_ref()).to_glib_none().0,
                trusted_ca.map(|p| p.as_ref()).to_glib_none().0,
            ))
        }
    }

    //fn get_property_certificate(&self) -> /*Ignored*/Option<glib::ByteArray> {
    //    unsafe {
    //        let mut value = Value::from_type(</*Unknown type*/ as StaticType>::static_type());
    //        gobject_sys::g_object_get_property(self.to_glib_none().0 as *mut gobject_sys::GObject, b"certificate\0".as_ptr() as *const _, value.to_glib_none_mut().0);
    //        value.get().expect("Return Value for property `certificate` getter")
    //    }
    //}

    fn get_property_certificate_pem(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"certificate-pem\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `certificate-pem` getter")
        }
    }
}

impl fmt::Display for TlsCertificate {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "TlsCertificate")
    }
}
