/* gtkdoccommentparser.c generated by valac, the Vala compiler
 * generated from gtkdoccommentparser.vala, do not modify */

/* gtkcommentparser.vala
 *
 * Copyright (C) 2011-2014  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include "valadoc.h"
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

enum  {
	VALADOC_GTKDOC_PARSER_0_PROPERTY,
	VALADOC_GTKDOC_PARSER_NUM_PROPERTIES
};
static GParamSpec* valadoc_gtkdoc_parser_properties[VALADOC_GTKDOC_PARSER_NUM_PROPERTIES];
#define _valadoc_gtkdoc_scanner_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_gtkdoc_scanner_unref (var), NULL)))
#define _valadoc_gtkdoc_token_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_gtkdoc_token_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _valadoc_api_source_comment_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_source_comment_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _valadoc_importer_internal_id_registrar_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_importer_internal_id_registrar_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocGtkdocParserPrivate {
	ValadocGtkdocScanner* scanner;
	ValadocGtkdocToken* current;
	ValaList* stack;
	ValaList* footnotes;
	ValadocContentContentFactory* factory;
	ValadocErrorReporter* reporter;
	ValadocSettings* settings;
	ValadocApiTree* tree;
	ValadocApiNode* element;
	gboolean show_warnings;
	ValadocApiSourceComment* comment;
	const gchar* instance_param_name;
	gchar** comment_lines;
	gint comment_lines_length1;
	gint _comment_lines_size_;
	GRegex* is_numeric_regex;
	GRegex* normalize_regex;
	GRegex* regex_source_lang;
	ValadocImporterInternalIdRegistrar* id_registrar;
	ValadocGirMetaData* current_metadata;
};

static gint ValadocGtkdocParser_private_offset;
static gpointer valadoc_gtkdoc_parser_parent_class = NULL;
static ValadocResourceLocatorIface * valadoc_gtkdoc_parser_valadoc_resource_locator_parent_iface = NULL;

static inline gchar* valadoc_gtkdoc_parser_fix_resource_path (ValadocGtkdocParser* self,
                                                const gchar* path);
static void valadoc_gtkdoc_parser_reset (ValadocGtkdocParser* self,
                                  ValadocApiSourceComment* comment);
static gchar* valadoc_gtkdoc_parser_normalize (ValadocGtkdocParser* self,
                                        const gchar* text);
static gboolean valadoc_gtkdoc_parser_is_numeric (ValadocGtkdocParser* self,
                                           const gchar* str);
static void valadoc_gtkdoc_parser_report_unexpected_token (ValadocGtkdocParser* self,
                                                    ValadocGtkdocToken* got,
                                                    const gchar* expected);
static void valadoc_gtkdoc_parser_report_warning (ValadocGtkdocParser* self,
                                           ValadocGtkdocToken* got,
                                           const gchar* message);
static ValadocContentNote* _valadoc_gtkdoc_parser_parse_note (ValadocGtkdocParser* self,
                                                       ValadocApiSourceComment* comment);
static ValadocContentComment* valadoc_gtkdoc_parser_parse_root_content (ValadocGtkdocParser* self,
                                                                 ValadocApiSourceComment* gir_comment);
static void valadoc_gtkdoc_parser_add_note (ValadocGtkdocParser* self,
                                     ValadocContentComment** comment,
                                     ValadocContentNote* note);
static void valadoc_gtkdoc_parser_add_taglet (ValadocGtkdocParser* self,
                                       ValadocContentComment** comment,
                                       ValadocContentTaglet* taglet);
 G_GNUC_INTERNAL void valadoc_importer_helper_extract_short_desc (ValadocContentComment* comment,
                                                 ValadocContentContentFactory* factory);
static ValadocContentTaglet* valadoc_gtkdoc_parser_parse_block_taglet (ValadocGtkdocParser* self,
                                                                ValadocApiSourceComment* gir_comment,
                                                                const gchar* taglet_name);
 G_GNUC_INTERNAL void valadoc_taglets_param_set_is_c_self_param (ValadocTagletsParam* self,
                                                gboolean value);
 G_GNUC_INTERNAL void valadoc_taglets_param_set_parameter_name (ValadocTagletsParam* self,
                                               const gchar* value);
static ValadocGtkdocToken* valadoc_gtkdoc_parser_next (ValadocGtkdocParser* self);
static void valadoc_gtkdoc_parser_parse_docbook_spaces (ValadocGtkdocParser* self,
                                                 gboolean accept_paragraphs);
static ValadocContentRun* valadoc_gtkdoc_parser_parse_inline_content (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_block_content (ValadocGtkdocParser* self);
static gboolean valadoc_gtkdoc_parser_ignore_current_xml_close (ValadocGtkdocParser* self);
static gboolean valadoc_gtkdoc_parser_check_xml_open_tag (ValadocGtkdocParser* self,
                                                   const gchar* tagname);
static gboolean valadoc_gtkdoc_parser_check_xml_close_tag (ValadocGtkdocParser* self,
                                                    const gchar* tagname);
static ValadocContentInline* valadoc_gtkdoc_parser_parse_docbook_link_tempalte (ValadocGtkdocParser* self,
                                                                         const gchar* tagname,
                                                                         gboolean is_internal);
 G_GNUC_INTERNAL void valadoc_content_link_set_id_registrar (ValadocContentLink* self,
                                            ValadocImporterInternalIdRegistrar* value);
static ValadocContentInlineTaglet* valadoc_gtkdoc_parser_parse_symbol_link (ValadocGtkdocParser* self,
                                                                     const gchar* tagname);
static ValadocContentInline* valadoc_gtkdoc_parser_create_type_link (ValadocGtkdocParser* self,
                                                              const gchar* name,
                                                              gboolean c_accept_plural);
static void valadoc_gtkdoc_parser_parse_anchor (ValadocGtkdocParser* self);
static ValadocContentLink* valadoc_gtkdoc_parser_parse_xref (ValadocGtkdocParser* self);
static ValadocContentRun* valadoc_gtkdoc_parser_parse_highlighted_template (ValadocGtkdocParser* self,
                                                                     const gchar* tag_name,
                                                                     ValadocContentRunStyle style);
static ValadocContentListItem* valadoc_gtkdoc_parser_parse_docbook_listitem (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_mixed_content (ValadocGtkdocParser* self);
static ValadocContentBlockContent* valadoc_gtkdoc_parser_parse_docbook_information_box_template (ValadocGtkdocParser* self,
                                                                                          const gchar* tagname,
                                                                                          ValadocContentBlockContent* container);
static ValadocContentNote* valadoc_gtkdoc_parser_parse_docbook_important (ValadocGtkdocParser* self);
static ValadocContentNote* valadoc_gtkdoc_parser_parse_docbook_note (ValadocGtkdocParser* self);
static ValadocContentWarning* valadoc_gtkdoc_parser_parse_docbook_warning (ValadocGtkdocParser* self);
static inline ValaCollection* valadoc_gtkdoc_parser_parse_docbook_orderedlist (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_itemizedlist (ValadocGtkdocParser* self,
                                                                  const gchar* tag_name,
                                                                  ValadocContentListBullet bullet_type);
static inline void valadoc_gtkdoc_parser_append_block_content_not_null (ValadocGtkdocParser* self,
                                                          ValaCollection* run,
                                                          ValadocContentBlock* element);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_title (ValadocGtkdocParser* self);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_gtkdoc_paragraph (ValadocGtkdocParser* self);
static inline ValaCollection* valadoc_gtkdoc_parser_parse_docbook_simpara (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_para (ValadocGtkdocParser* self,
                                                          const gchar* tag_name);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_gtkdoc_source (ValadocGtkdocParser* self);
static ValadocContentSourceCodeLanguage* _valadoc_content_source_code_language_dup (ValadocContentSourceCodeLanguage* self);
 G_GNUC_INTERNAL gboolean valadoc_highlighter_xml_scanner_is_xml (const gchar* source);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_graphic (ValadocGtkdocParser* self);
static ValadocContentEmbedded* valadoc_gtkdoc_parser_parse_docbook_inlinegraphic (ValadocGtkdocParser* self,
                                                                           const gchar* tag_name);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_programlisting (ValadocGtkdocParser* self);
static inline ValaCollection* valadoc_gtkdoc_parser_parse_docbook_informalexample (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_example (ValadocGtkdocParser* self,
                                                             const gchar* tag_name);
static ValaList* valadoc_gtkdoc_parser_parse_docbook_refsect2 (ValadocGtkdocParser* self,
                                                        gint nr);
static inline void valadoc_gtkdoc_parser_append_block_content_not_null_all (ValadocGtkdocParser* self,
                                                              ValaCollection* run,
                                                              ValaCollection* elements);
static ValaList* valadoc_gtkdoc_parser_parse_docbook_figure (ValadocGtkdocParser* self);
static ValadocContentRun* valadoc_gtkdoc_parser_parse_docbook_footnote (ValadocGtkdocParser* self);
static ValadocContentTableRow* valadoc_gtkdoc_parser_parse_docbook_thead (ValadocGtkdocParser* self);
static ValadocContentTableRow* valadoc_gtkdoc_parser_parse_docbook_row (ValadocGtkdocParser* self,
                                                                 ValadocContentRunStyle default_style);
static ValadocContentTableCell* valadoc_gtkdoc_parser_parse_docbook_entry (ValadocGtkdocParser* self,
                                                                    ValadocContentRunStyle default_style);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_tbody (ValadocGtkdocParser* self);
static ValadocContentTable* valadoc_gtkdoc_parser_parse_docbook_tgroup (ValadocGtkdocParser* self);
static ValadocContentTable* valadoc_gtkdoc_parser_parse_docbook_informaltable (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_section (ValadocGtkdocParser* self);
static ValadocContentListItem* valadoc_gtkdoc_parser_parse_docbook_member (ValadocGtkdocParser* self);
static ValadocContentList* valadoc_gtkdoc_parser_parse_docbook_simplelist (ValadocGtkdocParser* self);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_term (ValadocGtkdocParser* self);
static ValadocContentListItem* valadoc_gtkdoc_parser_parse_docbook_varlistentry (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_variablelist (ValadocGtkdocParser* self);
static ValadocContentRun* valadoc_gtkdoc_parser_parse_xml_tag (ValadocGtkdocParser* self);
static void valadoc_gtkdoc_parser_append_inline_content_string (ValadocGtkdocParser* self,
                                                         ValadocContentRun* run,
                                                         const gchar* current);
 G_GNUC_INTERNAL void valadoc_taglets_link_set_c_accept_plural (ValadocTagletsLink* self,
                                               gboolean value);
 G_GNUC_INTERNAL void valadoc_taglets_link_set_symbol_name (ValadocTagletsLink* self,
                                           const gchar* value);
static inline void valadoc_gtkdoc_parser_append_inline_content_not_null (ValadocGtkdocParser* self,
                                                           ValadocContentRun* run,
                                                           ValadocContentInline* element);
 G_GNUC_INTERNAL gchar* valadoc_importer_helper_resolve_parameter_ctype (ValadocApiTree* tree,
                                                        ValadocApiNode* element,
                                                        const gchar* parameter_name,
                                                        gchar** param_name,
                                                        gchar** param_array_name,
                                                        gboolean* is_return_type_len);
static gchar* valadoc_gtkdoc_parser_real_resolve (ValadocResourceLocator* base,
                                           const gchar* path);
static void valadoc_gtkdoc_parser_finalize (GObject * obj);
static GType valadoc_gtkdoc_parser_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
valadoc_gtkdoc_parser_get_instance_private (ValadocGtkdocParser* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocGtkdocParser_private_offset);
}

static inline gchar*
valadoc_gtkdoc_parser_fix_resource_path (ValadocGtkdocParser* self,
                                         const gchar* path)
{
	ValadocGirMetaData* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->current_metadata;
	_tmp1_ = valadoc_gir_meta_data_get_resource_path (_tmp0_, path);
	result = _tmp1_;
	return result;
}

static gpointer
_valadoc_api_source_comment_ref0 (gpointer self)
{
	return self ? valadoc_api_source_comment_ref (self) : NULL;
}

static void
valadoc_gtkdoc_parser_reset (ValadocGtkdocParser* self,
                             ValadocApiSourceComment* comment)
{
	ValadocGtkdocScanner* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocApiSourceFile* _tmp3_;
	ValadocApiSourceFile* _tmp4_;
	ValadocApiPackage* _tmp5_;
	ValadocApiPackage* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	ValaList* _tmp9_;
	ValadocApiSourceComment* _tmp10_;
	ValaList* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = valadoc_api_source_comment_get_content (comment);
	_tmp2_ = _tmp1_;
	valadoc_gtkdoc_scanner_reset (_tmp0_, _tmp2_);
	_tmp3_ = valadoc_api_source_comment_get_file (comment);
	_tmp4_ = _tmp3_;
	_tmp5_ = valadoc_api_source_file_get_package (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = valadoc_api_package_get_is_package (_tmp6_);
	_tmp8_ = _tmp7_;
	self->priv->show_warnings = !_tmp8_;
	self->priv->comment_lines = (_vala_array_free (self->priv->comment_lines, self->priv->comment_lines_length1, (GDestroyNotify) g_free), NULL);
	self->priv->comment_lines = NULL;
	self->priv->comment_lines_length1 = 0;
	self->priv->_comment_lines_size_ = self->priv->comment_lines_length1;
	_tmp9_ = self->priv->footnotes;
	vala_collection_clear ((ValaCollection*) _tmp9_);
	_tmp10_ = _valadoc_api_source_comment_ref0 (comment);
	_valadoc_api_source_comment_unref0 (self->priv->comment);
	self->priv->comment = _tmp10_;
	_valadoc_gtkdoc_token_unref0 (self->priv->current);
	self->priv->current = NULL;
	_tmp11_ = self->priv->stack;
	vala_collection_clear ((ValaCollection*) _tmp11_);
}

static gchar*
valadoc_gtkdoc_parser_normalize (ValadocGtkdocParser* self,
                                 const gchar* text)
{
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		GRegex* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->normalize_regex;
		_tmp2_ = g_regex_replace (_tmp1_, text, (gssize) -1, 0, " ", 0, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp3_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
valadoc_gtkdoc_parser_is_numeric (ValadocGtkdocParser* self,
                                  const gchar* str)
{
	GRegex* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = self->priv->is_numeric_regex;
	result = g_regex_match (_tmp0_, str, 0, NULL);
	return result;
}

static void
valadoc_gtkdoc_parser_report_unexpected_token (ValadocGtkdocParser* self,
                                               ValadocGtkdocToken* got,
                                               const gchar* expected)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (got != NULL);
	g_return_if_fail (expected != NULL);
	_tmp0_ = valadoc_gtkdoc_token_to_string (got);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("Unexpected Token: %s (Expected: %s)", _tmp1_, expected);
	_tmp3_ = _tmp2_;
	valadoc_gtkdoc_parser_report_warning (self, got, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}

static void
valadoc_gtkdoc_parser_report_warning (ValadocGtkdocParser* self,
                                      ValadocGtkdocToken* got,
                                      const gchar* message)
{
	gint _tmp0_ = 0;
	gint startpos = 0;
	gint _tmp4_ = 0;
	gint endpos = 0;
	gchar** _tmp8_;
	gint _tmp8__length1;
	ValadocErrorReporter* _tmp14_;
	ValadocApiSourceComment* _tmp15_;
	ValadocApiSourceFile* _tmp16_;
	ValadocApiSourceFile* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValadocApiSourceComment* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (got != NULL);
	g_return_if_fail (message != NULL);
	if (!self->priv->show_warnings) {
		return;
	}
	if (got->line == 0) {
		ValadocApiSourceComment* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->comment;
		_tmp2_ = valadoc_api_source_comment_get_first_column (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ + got->first_column;
	} else {
		_tmp0_ = got->first_column;
	}
	startpos = _tmp0_;
	if (got->line == 0) {
		ValadocApiSourceComment* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = self->priv->comment;
		_tmp6_ = valadoc_api_source_comment_get_first_column (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp4_ = _tmp7_ + got->last_column;
	} else {
		_tmp4_ = got->last_column;
	}
	endpos = _tmp4_;
	_tmp8_ = self->priv->comment_lines;
	_tmp8__length1 = self->priv->comment_lines_length1;
	if (_tmp8_ == NULL) {
		ValadocApiSourceComment* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar** _tmp12_;
		gchar** _tmp13_;
		_tmp9_ = self->priv->comment;
		_tmp10_ = valadoc_api_source_comment_get_content (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, "\n", 0);
		self->priv->comment_lines = (_vala_array_free (self->priv->comment_lines, self->priv->comment_lines_length1, (GDestroyNotify) g_free), NULL);
		self->priv->comment_lines = _tmp13_;
		self->priv->comment_lines_length1 = _vala_array_length (_tmp12_);
		self->priv->_comment_lines_size_ = self->priv->comment_lines_length1;
	}
	_tmp14_ = self->priv->reporter;
	_tmp15_ = self->priv->comment;
	_tmp16_ = valadoc_api_source_comment_get_file (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = valadoc_api_source_file_get_name (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = self->priv->comment;
	_tmp21_ = valadoc_api_source_comment_get_first_line (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = self->priv->comment_lines;
	_tmp23__length1 = self->priv->comment_lines_length1;
	_tmp24_ = _tmp23_[got->line];
	valadoc_error_reporter_warning (_tmp14_, _tmp19_, (glong) (_tmp22_ + got->line), (glong) (startpos + 1), (glong) (endpos + 1), _tmp24_, "%s", message);
	_g_free0 (_tmp19_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_valadoc_api_tree_ref0 (gpointer self)
{
	return self ? valadoc_api_tree_ref (self) : NULL;
}

ValadocGtkdocParser*
valadoc_gtkdoc_parser_construct (GType object_type,
                                 ValadocSettings* settings,
                                 ValadocErrorReporter* reporter,
                                 ValadocApiTree* tree,
                                 ValadocModuleLoader* modules)
{
	ValadocGtkdocParser * self = NULL;
	ValadocContentContentFactory* _tmp0_;
	ValadocErrorReporter* _tmp1_;
	ValadocSettings* _tmp2_;
	ValadocApiTree* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	g_return_val_if_fail (tree != NULL, NULL);
	g_return_val_if_fail (modules != NULL, NULL);
	self = (ValadocGtkdocParser*) g_object_new (object_type, NULL);
	_tmp0_ = valadoc_content_content_factory_new (settings, (ValadocResourceLocator*) self, modules);
	_g_object_unref0 (self->priv->factory);
	self->priv->factory = _tmp0_;
	_tmp1_ = _g_object_ref0 (reporter);
	_g_object_unref0 (self->priv->reporter);
	self->priv->reporter = _tmp1_;
	_tmp2_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	_tmp3_ = _valadoc_api_tree_ref0 (tree);
	_valadoc_api_tree_unref0 (self->priv->tree);
	self->priv->tree = _tmp3_;
	{
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		GRegex* _tmp7_ = NULL;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_ = NULL;
		GRegex* _tmp11_;
		GRegex* _tmp12_;
		_tmp5_ = g_regex_new ("^[+-]?([0-9]*\\.?[0-9]+|[0-9]+\\.?[0-9]*)([eE][+-]?[0-9]+)?$", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp6_ = _tmp4_;
		_tmp4_ = NULL;
		_g_regex_unref0 (self->priv->is_numeric_regex);
		self->priv->is_numeric_regex = _tmp6_;
		_tmp8_ = g_regex_new ("( |\n|\t)+", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp4_);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_g_regex_unref0 (self->priv->normalize_regex);
		self->priv->normalize_regex = _tmp9_;
		_tmp11_ = g_regex_new ("^<!--[ \t]+language=\"([A-Za-z]*)\"[ \t]+-->", 0, 0, &_inner_error0_);
		_tmp10_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp12_ = _tmp10_;
		_tmp10_ = NULL;
		_g_regex_unref0 (self->priv->regex_source_lang);
		self->priv->regex_source_lang = _tmp12_;
		_g_regex_unref0 (_tmp10_);
		_g_regex_unref0 (_tmp7_);
		_g_regex_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

ValadocGtkdocParser*
valadoc_gtkdoc_parser_new (ValadocSettings* settings,
                           ValadocErrorReporter* reporter,
                           ValadocApiTree* tree,
                           ValadocModuleLoader* modules)
{
	return valadoc_gtkdoc_parser_construct (VALADOC_GTKDOC_TYPE_PARSER, settings, reporter, tree, modules);
}

static ValadocContentNote*
_valadoc_gtkdoc_parser_parse_note (ValadocGtkdocParser* self,
                                   ValadocApiSourceComment* comment)
{
	ValadocContentComment* cmnt = NULL;
	ValadocContentComment* _tmp0_;
	ValadocContentComment* _tmp1_;
	ValadocContentNote* note = NULL;
	ValadocContentContentFactory* _tmp2_;
	ValadocContentNote* _tmp3_;
	ValadocContentNote* _tmp4_;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	ValadocContentComment* _tmp7_;
	ValaList* _tmp8_;
	ValaList* _tmp9_;
	ValadocContentNote* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (comment != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_parse_root_content (self, comment);
	cmnt = _tmp0_;
	_tmp1_ = cmnt;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (cmnt);
		return result;
	}
	_tmp2_ = self->priv->factory;
	_tmp3_ = valadoc_content_content_factory_create_note (_tmp2_);
	note = _tmp3_;
	_tmp4_ = note;
	_tmp5_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = cmnt;
	_tmp8_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp7_);
	_tmp9_ = _tmp8_;
	vala_collection_add_all ((ValaCollection*) _tmp6_, (ValaCollection*) _tmp9_);
	result = note;
	_g_object_unref0 (cmnt);
	return result;
}

static void
valadoc_gtkdoc_parser_add_note (ValadocGtkdocParser* self,
                                ValadocContentComment** comment,
                                ValadocContentNote* note)
{
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	ValaList* _tmp11_;
	ValaList* _tmp12_;
	g_return_if_fail (self != NULL);
	if (note == NULL) {
		return;
	}
	if ((*comment) == NULL) {
		ValadocContentContentFactory* _tmp0_;
		ValadocContentComment* _tmp1_;
		_tmp0_ = self->priv->factory;
		_tmp1_ = valadoc_content_content_factory_create_comment (_tmp0_);
		_g_object_unref0 (*comment);
		*comment = _tmp1_;
	}
	_tmp2_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) (*comment));
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		ValadocContentContentFactory* _tmp8_;
		ValadocContentParagraph* _tmp9_;
		ValadocContentParagraph* _tmp10_;
		_tmp6_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) (*comment));
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->factory;
		_tmp9_ = valadoc_content_content_factory_create_paragraph (_tmp8_);
		_tmp10_ = _tmp9_;
		vala_collection_add ((ValaCollection*) _tmp7_, (ValadocContentBlock*) _tmp10_);
		_g_object_unref0 (_tmp10_);
	}
	_tmp11_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) (*comment));
	_tmp12_ = _tmp11_;
	vala_list_insert (_tmp12_, 1, (ValadocContentBlock*) note);
}

static void
valadoc_gtkdoc_parser_add_taglet (ValadocGtkdocParser* self,
                                  ValadocContentComment** comment,
                                  ValadocContentTaglet* taglet)
{
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	if (taglet == NULL) {
		return;
	}
	if ((*comment) == NULL) {
		ValadocContentContentFactory* _tmp0_;
		ValadocContentComment* _tmp1_;
		_tmp0_ = self->priv->factory;
		_tmp1_ = valadoc_content_content_factory_create_comment (_tmp0_);
		_g_object_unref0 (*comment);
		*comment = _tmp1_;
	}
	_tmp2_ = valadoc_content_comment_get_taglets (*comment);
	_tmp3_ = _tmp2_;
	vala_collection_add ((ValaCollection*) _tmp3_, taglet);
}

static gpointer
_valadoc_importer_internal_id_registrar_ref0 (gpointer self)
{
	return self ? valadoc_importer_internal_id_registrar_ref (self) : NULL;
}

ValadocContentComment*
valadoc_gtkdoc_parser_parse (ValadocGtkdocParser* self,
                             ValadocApiNode* element,
                             ValadocApiGirSourceComment* gir_comment,
                             ValadocGirMetaData* gir_metadata,
                             ValadocImporterInternalIdRegistrar* id_registrar)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ValadocGirMetaData* _tmp2_;
	ValadocImporterInternalIdRegistrar* _tmp3_;
	ValadocApiNode* _tmp4_;
	ValadocContentComment* cmnt = NULL;
	ValadocContentComment* _tmp5_;
	ValadocContentComment* _tmp6_;
	ValadocApiSourceComment* _tmp9_;
	ValadocApiSourceComment* _tmp10_;
	ValadocApiSourceComment* _tmp15_;
	ValadocApiSourceComment* _tmp16_;
	ValadocApiSourceComment* _tmp21_;
	ValadocApiSourceComment* _tmp22_;
	ValadocApiSourceComment* _tmp27_;
	ValadocApiSourceComment* _tmp28_;
	ValaMapIterator* iter = NULL;
	ValaMapIterator* _tmp33_;
	gboolean first = FALSE;
	ValadocContentComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (gir_comment != NULL, NULL);
	g_return_val_if_fail (gir_metadata != NULL, NULL);
	g_return_val_if_fail (id_registrar != NULL, NULL);
	_tmp0_ = valadoc_api_gir_source_comment_get_instance_param_name (gir_comment);
	_tmp1_ = _tmp0_;
	self->priv->instance_param_name = _tmp1_;
	_tmp2_ = _g_object_ref0 (gir_metadata);
	_g_object_unref0 (self->priv->current_metadata);
	self->priv->current_metadata = _tmp2_;
	_tmp3_ = _valadoc_importer_internal_id_registrar_ref0 (id_registrar);
	_valadoc_importer_internal_id_registrar_unref0 (self->priv->id_registrar);
	self->priv->id_registrar = _tmp3_;
	_tmp4_ = _g_object_ref0 (element);
	_g_object_unref0 (self->priv->element);
	self->priv->element = _tmp4_;
	_tmp5_ = valadoc_gtkdoc_parser_parse_root_content (self, (ValadocApiSourceComment*) gir_comment);
	cmnt = _tmp5_;
	_tmp6_ = cmnt;
	if (_tmp6_ != NULL) {
		ValadocContentComment* _tmp7_;
		ValadocContentContentFactory* _tmp8_;
		_tmp7_ = cmnt;
		_tmp8_ = self->priv->factory;
		valadoc_importer_helper_extract_short_desc (_tmp7_, _tmp8_);
	}
	_tmp9_ = valadoc_api_gir_source_comment_get_deprecated_comment (gir_comment);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValadocContentNote* note = NULL;
		ValadocApiSourceComment* _tmp11_;
		ValadocApiSourceComment* _tmp12_;
		ValadocContentNote* _tmp13_;
		ValadocContentNote* _tmp14_;
		_tmp11_ = valadoc_api_gir_source_comment_get_deprecated_comment (gir_comment);
		_tmp12_ = _tmp11_;
		_tmp13_ = _valadoc_gtkdoc_parser_parse_note (self, _tmp12_);
		note = _tmp13_;
		_tmp14_ = note;
		valadoc_gtkdoc_parser_add_note (self, &cmnt, _tmp14_);
		_g_object_unref0 (note);
	}
	_tmp15_ = valadoc_api_gir_source_comment_get_version_comment (gir_comment);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValadocContentNote* note = NULL;
		ValadocApiSourceComment* _tmp17_;
		ValadocApiSourceComment* _tmp18_;
		ValadocContentNote* _tmp19_;
		ValadocContentNote* _tmp20_;
		_tmp17_ = valadoc_api_gir_source_comment_get_version_comment (gir_comment);
		_tmp18_ = _tmp17_;
		_tmp19_ = _valadoc_gtkdoc_parser_parse_note (self, _tmp18_);
		note = _tmp19_;
		_tmp20_ = note;
		valadoc_gtkdoc_parser_add_note (self, &cmnt, _tmp20_);
		_g_object_unref0 (note);
	}
	_tmp21_ = valadoc_api_gir_source_comment_get_stability_comment (gir_comment);
	_tmp22_ = _tmp21_;
	if (_tmp22_ != NULL) {
		ValadocContentNote* note = NULL;
		ValadocApiSourceComment* _tmp23_;
		ValadocApiSourceComment* _tmp24_;
		ValadocContentNote* _tmp25_;
		ValadocContentNote* _tmp26_;
		_tmp23_ = valadoc_api_gir_source_comment_get_stability_comment (gir_comment);
		_tmp24_ = _tmp23_;
		_tmp25_ = _valadoc_gtkdoc_parser_parse_note (self, _tmp24_);
		note = _tmp25_;
		_tmp26_ = note;
		valadoc_gtkdoc_parser_add_note (self, &cmnt, _tmp26_);
		_g_object_unref0 (note);
	}
	_tmp27_ = valadoc_api_gir_source_comment_get_return_comment (gir_comment);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != NULL) {
		ValadocContentTaglet* taglet = NULL;
		ValadocApiSourceComment* _tmp29_;
		ValadocApiSourceComment* _tmp30_;
		ValadocContentTaglet* _tmp31_;
		ValadocContentTaglet* _tmp32_;
		_tmp29_ = valadoc_api_gir_source_comment_get_return_comment (gir_comment);
		_tmp30_ = _tmp29_;
		_tmp31_ = valadoc_gtkdoc_parser_parse_block_taglet (self, _tmp30_, "return");
		taglet = _tmp31_;
		_tmp32_ = taglet;
		valadoc_gtkdoc_parser_add_taglet (self, &cmnt, _tmp32_);
		_g_object_unref0 (taglet);
	}
	_tmp33_ = valadoc_api_gir_source_comment_parameter_iterator (gir_comment);
	iter = _tmp33_;
	{
		gboolean has_next = FALSE;
		ValaMapIterator* _tmp34_;
		_tmp34_ = iter;
		has_next = vala_map_iterator_next (_tmp34_);
		{
			gboolean _tmp35_ = FALSE;
			_tmp35_ = TRUE;
			while (TRUE) {
				ValadocTagletsParam* taglet = NULL;
				ValaMapIterator* _tmp37_;
				gpointer _tmp38_;
				ValadocApiSourceComment* _tmp39_;
				ValadocContentTaglet* _tmp40_;
				ValadocTagletsParam* _tmp41_;
				ValadocTagletsParam* _tmp42_;
				gchar* param_name = NULL;
				ValaMapIterator* _tmp43_;
				gpointer _tmp44_;
				ValadocTagletsParam* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				ValadocTagletsParam* _tmp49_;
				const gchar* _tmp50_;
				ValadocTagletsParam* _tmp51_;
				if (!_tmp35_) {
					ValaMapIterator* _tmp36_;
					_tmp36_ = iter;
					has_next = vala_map_iterator_next (_tmp36_);
				}
				_tmp35_ = FALSE;
				if (!has_next) {
					break;
				}
				_tmp37_ = iter;
				_tmp38_ = vala_map_iterator_get_value (_tmp37_);
				_tmp39_ = (ValadocApiSourceComment*) _tmp38_;
				_tmp40_ = valadoc_gtkdoc_parser_parse_block_taglet (self, _tmp39_, "param");
				_tmp41_ = VALADOC_TAGLETS_IS_PARAM (_tmp40_) ? ((ValadocTagletsParam*) _tmp40_) : NULL;
				if (_tmp41_ == NULL) {
					_g_object_unref0 (_tmp40_);
				}
				_tmp42_ = _tmp41_;
				_valadoc_api_source_comment_unref0 (_tmp39_);
				taglet = _tmp42_;
				_tmp43_ = iter;
				_tmp44_ = vala_map_iterator_get_key (_tmp43_);
				param_name = (gchar*) _tmp44_;
				_tmp45_ = taglet;
				_tmp46_ = param_name;
				_tmp47_ = valadoc_api_gir_source_comment_get_instance_param_name (gir_comment);
				_tmp48_ = _tmp47_;
				valadoc_taglets_param_set_is_c_self_param (_tmp45_, g_strcmp0 (_tmp46_, _tmp48_) == 0);
				_tmp49_ = taglet;
				_tmp50_ = param_name;
				valadoc_taglets_param_set_parameter_name (_tmp49_, _tmp50_);
				_tmp51_ = taglet;
				valadoc_gtkdoc_parser_add_taglet (self, &cmnt, (ValadocContentTaglet*) _tmp51_);
				_g_free0 (param_name);
				_g_object_unref0 (taglet);
			}
		}
	}
	first = TRUE;
	{
		ValaList* _note_list = NULL;
		ValaList* _tmp52_;
		gint _note_size = 0;
		ValaList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _note_index = 0;
		_tmp52_ = self->priv->footnotes;
		_note_list = _tmp52_;
		_tmp53_ = _note_list;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_note_size = _tmp55_;
		_note_index = -1;
		while (TRUE) {
			gint _tmp56_;
			gint _tmp57_;
			ValaList* note = NULL;
			ValaList* _tmp58_;
			gpointer _tmp59_;
			gboolean _tmp60_ = FALSE;
			ValadocContentComment* _tmp81_;
			ValaList* _tmp82_;
			ValaList* _tmp83_;
			ValaList* _tmp84_;
			_note_index = _note_index + 1;
			_tmp56_ = _note_index;
			_tmp57_ = _note_size;
			if (!(_tmp56_ < _tmp57_)) {
				break;
			}
			_tmp58_ = _note_list;
			_tmp59_ = vala_list_get (_tmp58_, _note_index);
			note = (ValaList*) _tmp59_;
			if (first == TRUE) {
				ValaList* _tmp61_;
				gint _tmp62_;
				gint _tmp63_;
				_tmp61_ = note;
				_tmp62_ = vala_collection_get_size ((ValaCollection*) _tmp61_);
				_tmp63_ = _tmp62_;
				_tmp60_ = _tmp63_ > 0;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValadocContentParagraph* p = NULL;
				ValaList* _tmp64_;
				gpointer _tmp65_;
				ValadocContentBlock* _tmp66_;
				ValadocContentParagraph* _tmp67_;
				ValadocContentParagraph* _tmp68_;
				ValadocContentParagraph* _tmp75_;
				ValaList* _tmp76_;
				ValaList* _tmp77_;
				ValadocContentContentFactory* _tmp78_;
				ValadocContentText* _tmp79_;
				ValadocContentText* _tmp80_;
				_tmp64_ = note;
				_tmp65_ = vala_list_first (_tmp64_);
				_tmp66_ = (ValadocContentBlock*) _tmp65_;
				_tmp67_ = VALADOC_CONTENT_IS_PARAGRAPH (_tmp66_) ? ((ValadocContentParagraph*) _tmp66_) : NULL;
				if (_tmp67_ == NULL) {
					_g_object_unref0 (_tmp66_);
				}
				p = _tmp67_;
				_tmp68_ = p;
				if (_tmp68_ == NULL) {
					ValadocContentContentFactory* _tmp69_;
					ValadocContentParagraph* _tmp70_;
					ValadocContentComment* _tmp71_;
					ValaList* _tmp72_;
					ValaList* _tmp73_;
					ValadocContentParagraph* _tmp74_;
					_tmp69_ = self->priv->factory;
					_tmp70_ = valadoc_content_content_factory_create_paragraph (_tmp69_);
					_g_object_unref0 (p);
					p = _tmp70_;
					_tmp71_ = cmnt;
					_tmp72_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp71_);
					_tmp73_ = _tmp72_;
					_tmp74_ = p;
					vala_collection_add ((ValaCollection*) _tmp73_, (ValadocContentBlock*) _tmp74_);
				}
				_tmp75_ = p;
				_tmp76_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = self->priv->factory;
				_tmp79_ = valadoc_content_content_factory_create_text (_tmp78_, "\n");
				_tmp80_ = _tmp79_;
				vala_list_insert (_tmp77_, 0, (ValadocContentInline*) _tmp80_);
				_g_object_unref0 (_tmp80_);
				_g_object_unref0 (p);
			}
			_tmp81_ = cmnt;
			_tmp82_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp81_);
			_tmp83_ = _tmp82_;
			_tmp84_ = note;
			vala_collection_add_all ((ValaCollection*) _tmp83_, (ValaCollection*) _tmp84_);
			first = FALSE;
			_vala_iterable_unref0 (note);
		}
	}
	result = cmnt;
	_vala_map_iterator_unref0 (iter);
	return result;
}

static ValadocContentTaglet*
valadoc_gtkdoc_parser_parse_block_taglet (ValadocGtkdocParser* self,
                                          ValadocApiSourceComment* gir_comment,
                                          const gchar* taglet_name)
{
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocToken* _tmp1_;
	ValadocContentRun* ic = NULL;
	ValadocContentRun* _tmp2_;
	ValadocContentBlockContent* taglet = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentTaglet* _tmp4_;
	ValadocContentBlockContent* _tmp5_;
	ValadocContentBlockContent* _tmp6_;
	ValadocContentParagraph* paragraph = NULL;
	ValadocContentContentFactory* _tmp7_;
	ValadocContentParagraph* _tmp8_;
	ValadocGtkdocToken* _tmp9_;
	ValadocContentBlockContent* _tmp15_;
	ValaList* _tmp16_;
	ValaList* _tmp17_;
	ValadocContentParagraph* _tmp18_;
	ValadocContentBlockContent* _tmp19_;
	ValadocContentTaglet* _tmp20_;
	ValadocContentTaglet* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir_comment != NULL, NULL);
	g_return_val_if_fail (taglet_name != NULL, NULL);
	valadoc_gtkdoc_parser_reset (self, gir_comment);
	_valadoc_gtkdoc_token_unref0 (self->priv->current);
	self->priv->current = NULL;
	_tmp0_ = valadoc_gtkdoc_parser_next (self);
	_tmp1_ = _tmp0_;
	_valadoc_gtkdoc_token_unref0 (_tmp1_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
	_tmp2_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	ic = _tmp2_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_taglet (_tmp3_, taglet_name);
	_tmp5_ = VALADOC_CONTENT_IS_BLOCK_CONTENT (_tmp4_) ? ((ValadocContentBlockContent*) _tmp4_) : NULL;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (_tmp4_);
	}
	taglet = _tmp5_;
	_tmp6_ = taglet;
	_vala_assert (_tmp6_ != NULL, "taglet != null");
	_tmp7_ = self->priv->factory;
	_tmp8_ = valadoc_content_content_factory_create_paragraph (_tmp7_);
	paragraph = _tmp8_;
	_tmp9_ = self->priv->current;
	if (_tmp9_->type == VALADOC_GTKDOC_TOKEN_TYPE_EOF) {
		ValadocContentParagraph* _tmp10_;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		ValadocContentRun* _tmp13_;
		_tmp10_ = paragraph;
		_tmp11_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = ic;
		vala_collection_add ((ValaCollection*) _tmp12_, (ValadocContentInline*) _tmp13_);
	} else {
		ValadocGtkdocToken* _tmp14_;
		_tmp14_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp14_, "<EOF>");
	}
	_tmp15_ = taglet;
	_tmp16_ = valadoc_content_block_content_get_content (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = paragraph;
	vala_collection_add ((ValaCollection*) _tmp17_, (ValadocContentBlock*) _tmp18_);
	_tmp19_ = taglet;
	_tmp20_ = _g_object_ref0 (VALADOC_CONTENT_IS_TAGLET (_tmp19_) ? ((ValadocContentTaglet*) _tmp19_) : NULL);
	result = _tmp20_;
	_g_object_unref0 (paragraph);
	_g_object_unref0 (taglet);
	_g_object_unref0 (ic);
	return result;
}

static gpointer
_valadoc_gtkdoc_token_ref0 (gpointer self)
{
	return self ? valadoc_gtkdoc_token_ref (self) : NULL;
}

static ValadocContentComment*
valadoc_gtkdoc_parser_parse_root_content (ValadocGtkdocParser* self,
                                          ValadocApiSourceComment* gir_comment)
{
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* tmp = NULL;
	ValadocContentComment* comment = NULL;
	ValadocContentContentFactory* _tmp2_;
	ValadocContentComment* _tmp3_;
	ValadocGtkdocToken* _tmp38_;
	ValadocContentComment* _tmp40_;
	ValadocContentContentFactory* _tmp41_;
	ValadocContentComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir_comment != NULL, NULL);
	valadoc_gtkdoc_parser_reset (self, gir_comment);
	_valadoc_gtkdoc_token_unref0 (self->priv->current);
	self->priv->current = NULL;
	_tmp0_ = valadoc_gtkdoc_parser_next (self);
	_tmp1_ = _tmp0_;
	_valadoc_gtkdoc_token_unref0 (_tmp1_);
	tmp = NULL;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
	_tmp2_ = self->priv->factory;
	_tmp3_ = valadoc_content_content_factory_create_comment (_tmp2_);
	comment = _tmp3_;
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		ValadocGtkdocToken* _tmp5_;
		ValadocGtkdocToken* _tmp8_;
		ValadocGtkdocToken* _tmp9_;
		ValadocContentRun* ic = NULL;
		ValadocContentRun* _tmp10_;
		gboolean _tmp11_ = FALSE;
		ValadocContentRun* _tmp12_;
		ValaCollection* bc = NULL;
		ValaCollection* _tmp28_;
		gboolean _tmp29_ = FALSE;
		ValaCollection* _tmp30_;
		_tmp5_ = self->priv->current;
		if (_tmp5_->type != VALADOC_GTKDOC_TOKEN_TYPE_EOF) {
			ValadocGtkdocToken* _tmp6_;
			ValadocGtkdocToken* _tmp7_;
			_tmp6_ = tmp;
			_tmp7_ = self->priv->current;
			_tmp4_ = _tmp6_ != _tmp7_;
		} else {
			_tmp4_ = FALSE;
		}
		if (!_tmp4_) {
			break;
		}
		_tmp8_ = self->priv->current;
		_tmp9_ = _valadoc_gtkdoc_token_ref0 (_tmp8_);
		_valadoc_gtkdoc_token_unref0 (tmp);
		tmp = _tmp9_;
		_tmp10_ = valadoc_gtkdoc_parser_parse_inline_content (self);
		ic = _tmp10_;
		_tmp12_ = ic;
		if (_tmp12_ != NULL) {
			ValadocContentRun* _tmp13_;
			ValaList* _tmp14_;
			ValaList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			_tmp13_ = ic;
			_tmp14_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp11_ = _tmp17_ > 0;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValadocContentParagraph* p = NULL;
			ValadocContentContentFactory* _tmp18_;
			ValadocContentParagraph* _tmp19_;
			ValadocContentParagraph* _tmp20_;
			ValaList* _tmp21_;
			ValaList* _tmp22_;
			ValadocContentRun* _tmp23_;
			ValadocContentComment* _tmp24_;
			ValaList* _tmp25_;
			ValaList* _tmp26_;
			ValadocContentParagraph* _tmp27_;
			_tmp18_ = self->priv->factory;
			_tmp19_ = valadoc_content_content_factory_create_paragraph (_tmp18_);
			p = _tmp19_;
			_tmp20_ = p;
			_tmp21_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = ic;
			vala_collection_add ((ValaCollection*) _tmp22_, (ValadocContentInline*) _tmp23_);
			_tmp24_ = comment;
			_tmp25_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = p;
			vala_collection_add ((ValaCollection*) _tmp26_, (ValadocContentBlock*) _tmp27_);
			_g_object_unref0 (p);
		}
		_tmp28_ = valadoc_gtkdoc_parser_parse_block_content (self);
		bc = _tmp28_;
		_tmp30_ = bc;
		if (_tmp30_ != NULL) {
			ValaCollection* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			_tmp31_ = bc;
			_tmp32_ = vala_collection_get_size (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp29_ = _tmp33_ > 0;
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			ValadocContentComment* _tmp34_;
			ValaList* _tmp35_;
			ValaList* _tmp36_;
			ValaCollection* _tmp37_;
			_tmp34_ = comment;
			_tmp35_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = bc;
			vala_collection_add_all ((ValaCollection*) _tmp36_, _tmp37_);
		}
		_vala_iterable_unref0 (bc);
		_g_object_unref0 (ic);
	}
	_tmp38_ = self->priv->current;
	if (_tmp38_->type != VALADOC_GTKDOC_TOKEN_TYPE_EOF) {
		ValadocGtkdocToken* _tmp39_;
		_tmp39_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp39_, "<INLINE|BLOCK>");
		result = NULL;
		_g_object_unref0 (comment);
		_valadoc_gtkdoc_token_unref0 (tmp);
		return result;
	}
	_tmp40_ = comment;
	_tmp41_ = self->priv->factory;
	valadoc_importer_helper_extract_short_desc (_tmp40_, _tmp41_);
	result = comment;
	_valadoc_gtkdoc_token_unref0 (tmp);
	return result;
}

static ValadocGtkdocToken*
valadoc_gtkdoc_parser_next (ValadocGtkdocParser* self)
{
	ValadocGtkdocScanner* _tmp0_;
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = valadoc_gtkdoc_scanner_next (_tmp0_);
	_valadoc_gtkdoc_token_unref0 (self->priv->current);
	self->priv->current = _tmp1_;
	_tmp2_ = self->priv->current;
	_tmp3_ = _valadoc_gtkdoc_token_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gboolean
valadoc_gtkdoc_parser_ignore_current_xml_close (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp0_;
	gchar* name = NULL;
	ValadocGtkdocToken* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	ValaList* _tmp4_;
	const gchar* _tmp5_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	if (_tmp0_->type != VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->current;
	_tmp2_ = _tmp1_->content;
	_tmp3_ = g_strdup (_tmp2_);
	name = _tmp3_;
	_tmp4_ = self->priv->stack;
	_tmp5_ = name;
	if (vala_collection_contains ((ValaCollection*) _tmp4_, _tmp5_) == FALSE) {
		result = TRUE;
		_g_free0 (name);
		return result;
	}
	result = FALSE;
	_g_free0 (name);
	return result;
}

static gboolean
valadoc_gtkdoc_parser_check_xml_open_tag (ValadocGtkdocParser* self,
                                          const gchar* tagname)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValadocGtkdocToken* _tmp2_;
	ValaList* _tmp6_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tagname != NULL, FALSE);
	_tmp2_ = self->priv->current;
	if (_tmp2_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_->content;
		_tmp1_ = g_strcmp0 (_tmp4_, tagname) != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp5_;
		_tmp5_ = self->priv->current;
		_tmp0_ = _tmp5_->type != VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->stack;
	vala_list_insert (_tmp6_, 0, tagname);
	result = TRUE;
	return result;
}

static gboolean
valadoc_gtkdoc_parser_check_xml_close_tag (ValadocGtkdocParser* self,
                                           const gchar* tagname)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValadocGtkdocToken* _tmp2_;
	ValaList* _tmp6_;
	gpointer _tmp7_;
	gchar* _tmp8_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tagname != NULL, FALSE);
	_tmp2_ = self->priv->current;
	if (_tmp2_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
		ValadocGtkdocToken* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_->content;
		_tmp1_ = g_strcmp0 (_tmp4_, tagname) != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp5_;
		_tmp5_ = self->priv->current;
		_tmp0_ = _tmp5_->type != VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->stack;
	_tmp7_ = vala_list_remove_at (_tmp6_, 0);
	_tmp8_ = (gchar*) _tmp7_;
	_vala_assert (g_strcmp0 (_tmp8_, tagname) == 0, "stack.remove_at (0) == tagname");
	_g_free0 (_tmp8_);
	result = TRUE;
	return result;
}

static void
valadoc_gtkdoc_parser_parse_docbook_spaces (ValadocGtkdocParser* self,
                                            gboolean accept_paragraphs)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		if (_tmp0_->type == VALADOC_GTKDOC_TOKEN_TYPE_SPACE) {
			ValadocGtkdocToken* _tmp1_;
			ValadocGtkdocToken* _tmp2_;
			_tmp1_ = valadoc_gtkdoc_parser_next (self);
			_tmp2_ = _tmp1_;
			_valadoc_gtkdoc_token_unref0 (_tmp2_);
		} else {
			ValadocGtkdocToken* _tmp3_;
			_tmp3_ = self->priv->current;
			if (_tmp3_->type == VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE) {
				ValadocGtkdocToken* _tmp4_;
				ValadocGtkdocToken* _tmp5_;
				_tmp4_ = valadoc_gtkdoc_parser_next (self);
				_tmp5_ = _tmp4_;
				_valadoc_gtkdoc_token_unref0 (_tmp5_);
			} else {
				gboolean _tmp6_ = FALSE;
				if (accept_paragraphs) {
					ValadocGtkdocToken* _tmp7_;
					_tmp7_ = self->priv->current;
					_tmp6_ = _tmp7_->type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					ValadocGtkdocToken* _tmp8_;
					ValadocGtkdocToken* _tmp9_;
					_tmp8_ = valadoc_gtkdoc_parser_next (self);
					_tmp9_ = _tmp8_;
					_valadoc_gtkdoc_token_unref0 (_tmp9_);
				} else {
					break;
				}
			}
		}
	}
}

static ValadocContentInline*
valadoc_gtkdoc_parser_parse_docbook_link_tempalte (ValadocGtkdocParser* self,
                                                   const gchar* tagname,
                                                   gboolean is_internal)
{
	GString* builder = NULL;
	GString* _tmp3_;
	gchar* url = NULL;
	ValadocGtkdocToken* _tmp10_;
	ValadocGtkdocToken* _tmp11_;
	ValadocContentLink* link = NULL;
	ValadocContentContentFactory* _tmp26_;
	ValadocContentLink* _tmp27_;
	ValadocContentLink* _tmp30_;
	const gchar* _tmp31_;
	GString* _tmp32_;
	ValadocGtkdocToken* _tmp53_;
	ValadocGtkdocToken* _tmp54_;
	ValadocContentInline* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tagname != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tagname)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tagname);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = g_string_new ("");
	builder = _tmp3_;
	if (is_internal) {
		ValadocGtkdocToken* _tmp4_;
		ValaHashMap* _tmp5_;
		gpointer _tmp6_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_->attributes;
		_tmp6_ = vala_map_get ((ValaMap*) _tmp5_, "linkend");
		_g_free0 (url);
		url = (gchar*) _tmp6_;
	} else {
		ValadocGtkdocToken* _tmp7_;
		ValaHashMap* _tmp8_;
		gpointer _tmp9_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->attributes;
		_tmp9_ = vala_map_get ((ValaMap*) _tmp8_, "url");
		_g_free0 (url);
		url = (gchar*) _tmp9_;
	}
	_tmp10_ = valadoc_gtkdoc_parser_next (self);
	_tmp11_ = _tmp10_;
	_valadoc_gtkdoc_token_unref0 (_tmp11_);
	while (TRUE) {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		ValadocGtkdocToken* _tmp14_;
		ValadocGtkdocToken* _tmp18_;
		ValadocGtkdocToken* _tmp24_;
		ValadocGtkdocToken* _tmp25_;
		_tmp14_ = self->priv->current;
		if (_tmp14_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
			ValadocGtkdocToken* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = self->priv->current;
			_tmp16_ = _tmp15_->content;
			_tmp13_ = g_strcmp0 (_tmp16_, tagname) == 0;
		} else {
			_tmp13_ = FALSE;
		}
		if (!_tmp13_) {
			ValadocGtkdocToken* _tmp17_;
			_tmp17_ = self->priv->current;
			_tmp12_ = _tmp17_->type != VALADOC_GTKDOC_TOKEN_TYPE_EOF;
		} else {
			_tmp12_ = FALSE;
		}
		if (!_tmp12_) {
			break;
		}
		_tmp18_ = self->priv->current;
		if (_tmp18_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		} else {
			ValadocGtkdocToken* _tmp19_;
			_tmp19_ = self->priv->current;
			if (_tmp19_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
			} else {
				ValadocGtkdocToken* _tmp20_;
				_tmp20_ = self->priv->current;
				if (_tmp20_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT) {
				} else {
					GString* _tmp21_;
					ValadocGtkdocToken* _tmp22_;
					const gchar* _tmp23_;
					_tmp21_ = builder;
					_tmp22_ = self->priv->current;
					_tmp23_ = _tmp22_->content;
					g_string_append (_tmp21_, _tmp23_);
				}
			}
		}
		_tmp24_ = valadoc_gtkdoc_parser_next (self);
		_tmp25_ = _tmp24_;
		_valadoc_gtkdoc_token_unref0 (_tmp25_);
	}
	_tmp26_ = self->priv->factory;
	_tmp27_ = valadoc_content_content_factory_create_link (_tmp26_);
	link = _tmp27_;
	if (is_internal) {
		ValadocContentLink* _tmp28_;
		ValadocImporterInternalIdRegistrar* _tmp29_;
		_tmp28_ = link;
		_tmp29_ = self->priv->id_registrar;
		valadoc_content_link_set_id_registrar (_tmp28_, _tmp29_);
	}
	_tmp30_ = link;
	_tmp31_ = url;
	valadoc_content_link_set_url (_tmp30_, _tmp31_);
	_tmp32_ = builder;
	if (_tmp32_->len == ((gssize) 0)) {
		ValadocContentLink* _tmp33_;
		ValaList* _tmp34_;
		ValaList* _tmp35_;
		ValadocContentContentFactory* _tmp36_;
		const gchar* _tmp37_;
		ValadocContentText* _tmp38_;
		ValadocContentText* _tmp39_;
		_tmp33_ = link;
		_tmp34_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = self->priv->factory;
		_tmp37_ = url;
		_tmp38_ = valadoc_content_content_factory_create_text (_tmp36_, _tmp37_);
		_tmp39_ = _tmp38_;
		vala_collection_add ((ValaCollection*) _tmp35_, (ValadocContentInline*) _tmp39_);
		_g_object_unref0 (_tmp39_);
	} else {
		ValadocContentLink* _tmp40_;
		ValaList* _tmp41_;
		ValaList* _tmp42_;
		ValadocContentContentFactory* _tmp43_;
		GString* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		ValadocContentText* _tmp48_;
		ValadocContentText* _tmp49_;
		_tmp40_ = link;
		_tmp41_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = self->priv->factory;
		_tmp44_ = builder;
		_tmp45_ = _tmp44_->str;
		_tmp46_ = valadoc_gtkdoc_parser_normalize (self, _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = valadoc_content_content_factory_create_text (_tmp43_, _tmp47_);
		_tmp49_ = _tmp48_;
		vala_collection_add ((ValaCollection*) _tmp42_, (ValadocContentInline*) _tmp49_);
		_g_object_unref0 (_tmp49_);
		_g_free0 (_tmp47_);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tagname)) {
		ValadocGtkdocToken* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp50_ = self->priv->current;
		_tmp51_ = g_strdup_printf ("</%s>", tagname);
		_tmp52_ = _tmp51_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp50_, _tmp52_);
		_g_free0 (_tmp52_);
		result = (ValadocContentInline*) link;
		_g_free0 (url);
		_g_string_free0 (builder);
		return result;
	}
	_tmp53_ = valadoc_gtkdoc_parser_next (self);
	_tmp54_ = _tmp53_;
	_valadoc_gtkdoc_token_unref0 (_tmp54_);
	result = (ValadocContentInline*) link;
	_g_free0 (url);
	_g_string_free0 (builder);
	return result;
}

static ValadocContentInlineTaglet*
valadoc_gtkdoc_parser_parse_symbol_link (ValadocGtkdocParser* self,
                                         const gchar* tagname)
{
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	gboolean _tmp5_;
	ValadocContentInlineTaglet* taglet = NULL;
	gboolean _tmp8_ = FALSE;
	ValadocGtkdocToken* _tmp9_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	ValadocGtkdocToken* _tmp24_;
	ValadocGtkdocToken* _tmp35_;
	ValadocGtkdocToken* _tmp36_;
	gboolean _tmp37_;
	ValadocGtkdocToken* _tmp43_;
	ValadocGtkdocToken* _tmp44_;
	ValadocContentInlineTaglet* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tagname != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tagname)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tagname);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_parser_next (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->type == VALADOC_GTKDOC_TOKEN_TYPE_SPACE;
	_valadoc_gtkdoc_token_unref0 (_tmp4_);
	if (_tmp5_) {
		ValadocGtkdocToken* _tmp6_;
		ValadocGtkdocToken* _tmp7_;
		_tmp6_ = valadoc_gtkdoc_parser_next (self);
		_tmp7_ = _tmp6_;
		_valadoc_gtkdoc_token_unref0 (_tmp7_);
	}
	taglet = NULL;
	_tmp9_ = self->priv->current;
	if (_tmp9_->type == VALADOC_GTKDOC_TOKEN_TYPE_WORD) {
		ValadocGtkdocToken* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = self->priv->current;
		_tmp11_ = _tmp10_->content;
		_tmp8_ = g_strcmp0 (_tmp11_, "struct") == 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValadocGtkdocToken* _tmp12_;
		ValadocGtkdocToken* _tmp13_;
		ValadocGtkdocToken* _tmp14_;
		ValadocGtkdocToken* _tmp15_;
		gboolean _tmp16_;
		_tmp12_ = valadoc_gtkdoc_parser_next (self);
		_tmp13_ = _tmp12_;
		_valadoc_gtkdoc_token_unref0 (_tmp13_);
		_tmp14_ = valadoc_gtkdoc_parser_next (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_->type == VALADOC_GTKDOC_TOKEN_TYPE_SPACE;
		_valadoc_gtkdoc_token_unref0 (_tmp15_);
		if (_tmp16_) {
			ValadocGtkdocToken* _tmp17_;
			ValadocGtkdocToken* _tmp18_;
			_tmp17_ = valadoc_gtkdoc_parser_next (self);
			_tmp18_ = _tmp17_;
			_valadoc_gtkdoc_token_unref0 (_tmp18_);
		}
	}
	_tmp24_ = self->priv->current;
	if (_tmp24_->type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION) {
		_tmp23_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp25_;
		_tmp25_ = self->priv->current;
		_tmp23_ = _tmp25_->type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST;
	}
	if (_tmp23_) {
		_tmp22_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp26_;
		_tmp26_ = self->priv->current;
		_tmp22_ = _tmp26_->type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE;
	}
	if (_tmp22_) {
		_tmp21_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp27_;
		_tmp27_ = self->priv->current;
		_tmp21_ = _tmp27_->type == VALADOC_GTKDOC_TOKEN_TYPE_WORD;
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp28_;
		_tmp28_ = self->priv->current;
		_tmp20_ = _tmp28_->type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY;
	}
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp29_;
		_tmp29_ = self->priv->current;
		_tmp19_ = _tmp29_->type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL;
	}
	if (_tmp19_) {
		ValadocGtkdocToken* _tmp30_;
		const gchar* _tmp31_;
		ValadocContentInline* _tmp32_;
		ValadocContentInlineTaglet* _tmp33_;
		ValadocContentInlineTaglet* _tmp34_;
		_tmp30_ = self->priv->current;
		_tmp31_ = _tmp30_->content;
		_tmp32_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp31_, FALSE);
		_tmp33_ = VALADOC_CONTENT_IS_INLINE_TAGLET (_tmp32_) ? ((ValadocContentInlineTaglet*) _tmp32_) : NULL;
		if (_tmp33_ == NULL) {
			_g_object_unref0 (_tmp32_);
		}
		_g_object_unref0 (taglet);
		taglet = _tmp33_;
		_tmp34_ = taglet;
		_vala_assert (_tmp34_ != NULL, "taglet != null");
	}
	_tmp35_ = valadoc_gtkdoc_parser_next (self);
	_tmp36_ = _tmp35_;
	_tmp37_ = _tmp36_->type == VALADOC_GTKDOC_TOKEN_TYPE_SPACE;
	_valadoc_gtkdoc_token_unref0 (_tmp36_);
	if (_tmp37_) {
		ValadocGtkdocToken* _tmp38_;
		ValadocGtkdocToken* _tmp39_;
		_tmp38_ = valadoc_gtkdoc_parser_next (self);
		_tmp39_ = _tmp38_;
		_valadoc_gtkdoc_token_unref0 (_tmp39_);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tagname)) {
		ValadocGtkdocToken* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp40_ = self->priv->current;
		_tmp41_ = g_strdup_printf ("</%s>", tagname);
		_tmp42_ = _tmp41_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp40_, _tmp42_);
		_g_free0 (_tmp42_);
		result = taglet;
		return result;
	}
	_tmp43_ = valadoc_gtkdoc_parser_next (self);
	_tmp44_ = _tmp43_;
	_valadoc_gtkdoc_token_unref0 (_tmp44_);
	result = taglet;
	return result;
}

static void
valadoc_gtkdoc_parser_parse_anchor (ValadocGtkdocParser* self)
{
	gchar* id = NULL;
	ValadocGtkdocToken* _tmp1_;
	ValaHashMap* _tmp2_;
	gpointer _tmp3_;
	const gchar* _tmp4_;
	ValadocGtkdocToken* _tmp8_;
	ValadocGtkdocToken* _tmp9_;
	ValadocGtkdocToken* _tmp11_;
	ValadocGtkdocToken* _tmp12_;
	g_return_if_fail (self != NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "anchor")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<anchor>");
		return;
	}
	_tmp1_ = self->priv->current;
	_tmp2_ = _tmp1_->attributes;
	_tmp3_ = vala_map_get ((ValaMap*) _tmp2_, "id");
	id = (gchar*) _tmp3_;
	_tmp4_ = id;
	if (_tmp4_ != NULL) {
		ValadocImporterInternalIdRegistrar* _tmp5_;
		const gchar* _tmp6_;
		ValadocApiNode* _tmp7_;
		_tmp5_ = self->priv->id_registrar;
		_tmp6_ = id;
		_tmp7_ = self->priv->element;
		valadoc_importer_internal_id_registrar_register_symbol (_tmp5_, _tmp6_, _tmp7_);
	}
	_tmp8_ = valadoc_gtkdoc_parser_next (self);
	_tmp9_ = _tmp8_;
	_valadoc_gtkdoc_token_unref0 (_tmp9_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "anchor")) {
		ValadocGtkdocToken* _tmp10_;
		_tmp10_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp10_, "</anchor>");
		_g_free0 (id);
		return;
	}
	_tmp11_ = valadoc_gtkdoc_parser_next (self);
	_tmp12_ = _tmp11_;
	_valadoc_gtkdoc_token_unref0 (_tmp12_);
	_g_free0 (id);
}

static ValadocContentLink*
valadoc_gtkdoc_parser_parse_xref (ValadocGtkdocParser* self)
{
	gchar* linkend = NULL;
	ValadocGtkdocToken* _tmp1_;
	ValaHashMap* _tmp2_;
	gpointer _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	ValadocContentLink* link = NULL;
	ValadocContentContentFactory* _tmp6_;
	ValadocContentLink* _tmp7_;
	ValadocContentLink* _tmp8_;
	ValaList* _tmp9_;
	ValaList* _tmp10_;
	ValadocContentContentFactory* _tmp11_;
	const gchar* _tmp12_;
	ValadocContentText* _tmp13_;
	ValadocContentText* _tmp14_;
	ValadocContentLink* _tmp15_;
	ValadocImporterInternalIdRegistrar* _tmp16_;
	ValadocContentLink* _tmp17_;
	const gchar* _tmp18_;
	ValadocGtkdocToken* _tmp20_;
	ValadocGtkdocToken* _tmp21_;
	ValadocContentLink* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "xref")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<xref>");
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->current;
	_tmp2_ = _tmp1_->attributes;
	_tmp3_ = vala_map_get ((ValaMap*) _tmp2_, "linkend");
	linkend = (gchar*) _tmp3_;
	_tmp4_ = valadoc_gtkdoc_parser_next (self);
	_tmp5_ = _tmp4_;
	_valadoc_gtkdoc_token_unref0 (_tmp5_);
	_tmp6_ = self->priv->factory;
	_tmp7_ = valadoc_content_content_factory_create_link (_tmp6_);
	link = _tmp7_;
	_tmp8_ = link;
	_tmp9_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->factory;
	_tmp12_ = linkend;
	_tmp13_ = valadoc_content_content_factory_create_text (_tmp11_, _tmp12_);
	_tmp14_ = _tmp13_;
	vala_collection_add ((ValaCollection*) _tmp10_, (ValadocContentInline*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = link;
	_tmp16_ = self->priv->id_registrar;
	valadoc_content_link_set_id_registrar (_tmp15_, _tmp16_);
	_tmp17_ = link;
	_tmp18_ = linkend;
	valadoc_content_link_set_url (_tmp17_, _tmp18_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "xref")) {
		ValadocGtkdocToken* _tmp19_;
		_tmp19_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp19_, "</xref>");
		result = link;
		_g_free0 (linkend);
		return result;
	}
	_tmp20_ = valadoc_gtkdoc_parser_next (self);
	_tmp21_ = _tmp20_;
	_valadoc_gtkdoc_token_unref0 (_tmp21_);
	result = link;
	_g_free0 (linkend);
	return result;
}

static ValadocContentRun*
valadoc_gtkdoc_parser_parse_highlighted_template (ValadocGtkdocParser* self,
                                                  const gchar* tag_name,
                                                  ValadocContentRunStyle style)
{
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocContentRun* run = NULL;
	ValadocContentRun* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValadocContentRun* _tmp7_;
	ValadocContentRunStyle _tmp8_;
	ValadocContentRunStyle _tmp9_;
	ValadocGtkdocToken* _tmp25_;
	ValadocGtkdocToken* _tmp26_;
	ValadocContentRun* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tag_name);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_parser_next (self);
	_tmp4_ = _tmp3_;
	_valadoc_gtkdoc_token_unref0 (_tmp4_);
	_tmp5_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	run = _tmp5_;
	_tmp7_ = run;
	_tmp8_ = valadoc_content_run_get_style (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != VALADOC_CONTENT_RUN_STYLE_NONE) {
		ValadocContentRun* _tmp10_;
		ValadocContentRunStyle _tmp11_;
		ValadocContentRunStyle _tmp12_;
		_tmp10_ = run;
		_tmp11_ = valadoc_content_run_get_style (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp6_ = _tmp12_ != style;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValadocContentRun* tmp = NULL;
		ValadocContentContentFactory* _tmp13_;
		ValadocContentRun* _tmp14_;
		ValadocContentRun* _tmp15_;
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		ValadocContentRun* _tmp18_;
		ValadocContentRun* _tmp19_;
		ValadocContentRun* _tmp20_;
		_tmp13_ = self->priv->factory;
		_tmp14_ = valadoc_content_content_factory_create_run (_tmp13_, style);
		tmp = _tmp14_;
		_tmp15_ = tmp;
		_tmp16_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = run;
		vala_collection_add ((ValaCollection*) _tmp17_, (ValadocContentInline*) _tmp18_);
		_tmp19_ = tmp;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		_g_object_unref0 (run);
		run = _tmp20_;
		_g_object_unref0 (tmp);
	} else {
		ValadocContentRun* _tmp21_;
		_tmp21_ = run;
		valadoc_content_run_set_style (_tmp21_, style);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp22_ = self->priv->current;
		_tmp23_ = g_strdup_printf ("</%s>", tag_name);
		_tmp24_ = _tmp23_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp22_, _tmp24_);
		_g_free0 (_tmp24_);
		result = run;
		return result;
	}
	_tmp25_ = valadoc_gtkdoc_parser_next (self);
	_tmp26_ = _tmp25_;
	_valadoc_gtkdoc_token_unref0 (_tmp26_);
	result = run;
	return result;
}

static ValadocContentListItem*
valadoc_gtkdoc_parser_parse_docbook_listitem (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentListItem* item = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentListItem* _tmp4_;
	ValadocContentListItem* _tmp5_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	ValaCollection* _tmp8_;
	ValaCollection* _tmp9_;
	ValadocGtkdocToken* _tmp11_;
	ValadocGtkdocToken* _tmp12_;
	ValadocContentListItem* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "listitem")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<listitem>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_list_item (_tmp3_);
	item = _tmp4_;
	_tmp5_ = item;
	_tmp6_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	_tmp9_ = _tmp8_;
	vala_collection_add_all ((ValaCollection*) _tmp7_, _tmp9_);
	_vala_iterable_unref0 (_tmp9_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "listitem")) {
		ValadocGtkdocToken* _tmp10_;
		_tmp10_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp10_, "</listitem>");
		result = item;
		return result;
	}
	_tmp11_ = valadoc_gtkdoc_parser_next (self);
	_tmp12_ = _tmp11_;
	_valadoc_gtkdoc_token_unref0 (_tmp12_);
	result = item;
	return result;
}

static ValadocContentBlockContent*
valadoc_gtkdoc_parser_parse_docbook_information_box_template (ValadocGtkdocParser* self,
                                                              const gchar* tagname,
                                                              ValadocContentBlockContent* container)
{
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocToken* tmp = NULL;
	ValadocGtkdocToken* _tmp40_;
	ValadocGtkdocToken* _tmp41_;
	ValadocContentBlockContent* _tmp42_;
	ValadocContentBlockContent* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tagname != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tagname)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tagname);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_parser_next (self);
	_tmp4_ = _tmp3_;
	_valadoc_gtkdoc_token_unref0 (_tmp4_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	tmp = NULL;
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		ValadocGtkdocToken* _tmp6_;
		ValadocGtkdocToken* _tmp8_;
		ValadocGtkdocToken* _tmp9_;
		ValadocContentRun* ic = NULL;
		ValadocContentRun* _tmp10_;
		gboolean _tmp11_ = FALSE;
		ValadocContentRun* _tmp12_;
		ValaCollection* bc = NULL;
		ValaCollection* _tmp27_;
		gboolean _tmp28_ = FALSE;
		ValaCollection* _tmp29_;
		_tmp6_ = self->priv->current;
		if (_tmp6_->type != VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
			ValadocGtkdocToken* _tmp7_;
			_tmp7_ = self->priv->current;
			_tmp5_ = _tmp7_->type != VALADOC_GTKDOC_TOKEN_TYPE_EOF;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_tmp8_ = self->priv->current;
		_tmp9_ = _valadoc_gtkdoc_token_ref0 (_tmp8_);
		_valadoc_gtkdoc_token_unref0 (tmp);
		tmp = _tmp9_;
		_tmp10_ = valadoc_gtkdoc_parser_parse_inline_content (self);
		ic = _tmp10_;
		_tmp12_ = ic;
		if (_tmp12_ != NULL) {
			ValadocContentRun* _tmp13_;
			ValaList* _tmp14_;
			ValaList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			_tmp13_ = ic;
			_tmp14_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp11_ = _tmp17_ > 0;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValadocContentParagraph* p = NULL;
			ValadocContentContentFactory* _tmp18_;
			ValadocContentParagraph* _tmp19_;
			ValadocContentParagraph* _tmp20_;
			ValaList* _tmp21_;
			ValaList* _tmp22_;
			ValadocContentRun* _tmp23_;
			ValaList* _tmp24_;
			ValaList* _tmp25_;
			ValadocContentParagraph* _tmp26_;
			_tmp18_ = self->priv->factory;
			_tmp19_ = valadoc_content_content_factory_create_paragraph (_tmp18_);
			p = _tmp19_;
			_tmp20_ = p;
			_tmp21_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = ic;
			vala_collection_add ((ValaCollection*) _tmp22_, (ValadocContentInline*) _tmp23_);
			_tmp24_ = valadoc_content_block_content_get_content (container);
			_tmp25_ = _tmp24_;
			_tmp26_ = p;
			vala_collection_add ((ValaCollection*) _tmp25_, (ValadocContentBlock*) _tmp26_);
			_g_object_unref0 (p);
		}
		_tmp27_ = valadoc_gtkdoc_parser_parse_block_content (self);
		bc = _tmp27_;
		_tmp29_ = bc;
		if (_tmp29_ != NULL) {
			ValaCollection* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			_tmp30_ = bc;
			_tmp31_ = vala_collection_get_size (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp28_ = _tmp32_ > 0;
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaList* _tmp33_;
			ValaList* _tmp34_;
			ValaCollection* _tmp35_;
			_tmp33_ = valadoc_content_block_content_get_content (container);
			_tmp34_ = _tmp33_;
			_tmp35_ = bc;
			vala_collection_add_all ((ValaCollection*) _tmp34_, _tmp35_);
		}
		_vala_iterable_unref0 (bc);
		_g_object_unref0 (ic);
	}
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tagname)) {
		ValadocGtkdocToken* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		ValadocContentBlockContent* _tmp39_;
		_tmp36_ = self->priv->current;
		_tmp37_ = g_strdup_printf ("</%s>", tagname);
		_tmp38_ = _tmp37_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp36_, _tmp38_);
		_g_free0 (_tmp38_);
		_tmp39_ = _g_object_ref0 (container);
		result = _tmp39_;
		_valadoc_gtkdoc_token_unref0 (tmp);
		return result;
	}
	_tmp40_ = valadoc_gtkdoc_parser_next (self);
	_tmp41_ = _tmp40_;
	_valadoc_gtkdoc_token_unref0 (_tmp41_);
	_tmp42_ = _g_object_ref0 (container);
	result = _tmp42_;
	_valadoc_gtkdoc_token_unref0 (tmp);
	return result;
}

static ValadocContentNote*
valadoc_gtkdoc_parser_parse_docbook_important (ValadocGtkdocParser* self)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentNote* _tmp1_;
	ValadocContentNote* _tmp2_;
	ValadocContentBlockContent* _tmp3_;
	ValadocContentNote* _tmp4_;
	ValadocContentNote* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->factory;
	_tmp1_ = valadoc_content_content_factory_create_note (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_gtkdoc_parser_parse_docbook_information_box_template (self, "important", (ValadocContentBlockContent*) _tmp2_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALADOC_CONTENT_TYPE_NOTE, ValadocContentNote);
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static ValadocContentNote*
valadoc_gtkdoc_parser_parse_docbook_note (ValadocGtkdocParser* self)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentNote* _tmp1_;
	ValadocContentNote* _tmp2_;
	ValadocContentBlockContent* _tmp3_;
	ValadocContentNote* _tmp4_;
	ValadocContentNote* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->factory;
	_tmp1_ = valadoc_content_content_factory_create_note (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_gtkdoc_parser_parse_docbook_information_box_template (self, "note", (ValadocContentBlockContent*) _tmp2_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALADOC_CONTENT_TYPE_NOTE, ValadocContentNote);
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static ValadocContentWarning*
valadoc_gtkdoc_parser_parse_docbook_warning (ValadocGtkdocParser* self)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentWarning* _tmp1_;
	ValadocContentWarning* _tmp2_;
	ValadocContentBlockContent* _tmp3_;
	ValadocContentWarning* _tmp4_;
	ValadocContentWarning* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->factory;
	_tmp1_ = valadoc_content_content_factory_create_warning (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_gtkdoc_parser_parse_docbook_information_box_template (self, "warning", (ValadocContentBlockContent*) _tmp2_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALADOC_CONTENT_TYPE_WARNING, ValadocContentWarning);
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static inline ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_orderedlist (ValadocGtkdocParser* self)
{
	ValaCollection* _tmp0_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_parse_docbook_itemizedlist (self, "orderedlist", VALADOC_CONTENT_LIST_BULLET_ORDERED);
	result = _tmp0_;
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_itemizedlist (ValadocGtkdocParser* self,
                                                  const gchar* tag_name,
                                                  ValadocContentListBullet bullet_type)
{
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValaCollection* content = NULL;
	GEqualFunc _tmp5_;
	ValaArrayList* _tmp6_;
	gboolean _tmp7_ = FALSE;
	ValadocGtkdocToken* _tmp8_;
	ValadocContentList* list = NULL;
	ValadocContentContentFactory* _tmp14_;
	ValadocContentList* _tmp15_;
	ValadocContentList* _tmp16_;
	ValaCollection* _tmp17_;
	ValadocContentList* _tmp18_;
	ValadocGtkdocToken* _tmp30_;
	ValadocGtkdocToken* _tmp31_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tag_name);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_parser_next (self);
	_tmp4_ = _tmp3_;
	_valadoc_gtkdoc_token_unref0 (_tmp4_);
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp5_);
	content = (ValaCollection*) _tmp6_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp8_ = self->priv->current;
	if (_tmp8_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_->content;
		_tmp7_ = g_strcmp0 (_tmp10_, "title") == 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaCollection* _tmp11_;
		ValadocContentParagraph* _tmp12_;
		ValadocContentParagraph* _tmp13_;
		_tmp11_ = content;
		_tmp12_ = valadoc_gtkdoc_parser_parse_docbook_title (self);
		_tmp13_ = _tmp12_;
		valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp11_, (ValadocContentBlock*) _tmp13_);
		_g_object_unref0 (_tmp13_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	}
	_tmp14_ = self->priv->factory;
	_tmp15_ = valadoc_content_content_factory_create_list (_tmp14_);
	list = _tmp15_;
	_tmp16_ = list;
	valadoc_content_list_set_bullet (_tmp16_, bullet_type);
	_tmp17_ = content;
	_tmp18_ = list;
	vala_collection_add (_tmp17_, (ValadocContentBlock*) _tmp18_);
	while (TRUE) {
		ValadocGtkdocToken* _tmp19_;
		ValadocGtkdocToken* _tmp20_;
		const gchar* _tmp21_;
		_tmp19_ = self->priv->current;
		if (!(_tmp19_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN)) {
			break;
		}
		_tmp20_ = self->priv->current;
		_tmp21_ = _tmp20_->content;
		if (g_strcmp0 (_tmp21_, "listitem") == 0) {
			ValadocContentList* _tmp22_;
			ValaList* _tmp23_;
			ValaList* _tmp24_;
			ValadocContentListItem* _tmp25_;
			ValadocContentListItem* _tmp26_;
			_tmp22_ = list;
			_tmp23_ = valadoc_content_list_get_items (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = valadoc_gtkdoc_parser_parse_docbook_listitem (self);
			_tmp26_ = _tmp25_;
			vala_collection_add ((ValaCollection*) _tmp24_, _tmp26_);
			_g_object_unref0 (_tmp26_);
		} else {
			break;
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp27_ = self->priv->current;
		_tmp28_ = g_strdup_printf ("</%s>", tag_name);
		_tmp29_ = _tmp28_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp27_, _tmp29_);
		_g_free0 (_tmp29_);
		result = content;
		_g_object_unref0 (list);
		return result;
	}
	_tmp30_ = valadoc_gtkdoc_parser_next (self);
	_tmp31_ = _tmp30_;
	_valadoc_gtkdoc_token_unref0 (_tmp31_);
	result = content;
	_g_object_unref0 (list);
	return result;
}

static ValadocContentParagraph*
valadoc_gtkdoc_parser_parse_gtkdoc_paragraph (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp4_;
	ValadocContentParagraph* _tmp5_;
	ValadocContentRun* run = NULL;
	ValadocContentRun* _tmp6_;
	ValadocContentParagraph* _tmp7_;
	ValaList* _tmp8_;
	ValaList* _tmp9_;
	ValadocContentRun* _tmp10_;
	ValadocContentParagraph* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current;
	if (_tmp0_->type != VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<GTKDOC-PARAGRAPH>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	_tmp4_ = self->priv->factory;
	_tmp5_ = valadoc_content_content_factory_create_paragraph (_tmp4_);
	p = _tmp5_;
	_tmp6_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	run = _tmp6_;
	_tmp7_ = p;
	_tmp8_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = run;
	vala_collection_add ((ValaCollection*) _tmp9_, (ValadocContentInline*) _tmp10_);
	result = p;
	_g_object_unref0 (run);
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_mixed_content (ValadocGtkdocParser* self)
{
	ValaCollection* content = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValadocGtkdocToken* tmp = NULL;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	content = (ValaCollection*) _tmp1_;
	tmp = NULL;
	while (TRUE) {
		ValadocGtkdocToken* _tmp2_;
		ValadocGtkdocToken* _tmp3_;
		ValadocGtkdocToken* _tmp4_;
		ValadocGtkdocToken* _tmp5_;
		ValadocContentRun* run = NULL;
		ValadocContentRun* _tmp6_;
		gboolean _tmp7_ = FALSE;
		ValadocContentRun* _tmp8_;
		ValaCollection* lst = NULL;
		ValaCollection* _tmp22_;
		gboolean _tmp23_ = FALSE;
		ValaCollection* _tmp24_;
		_tmp2_ = tmp;
		_tmp3_ = self->priv->current;
		if (!(_tmp2_ != _tmp3_)) {
			break;
		}
		_tmp4_ = self->priv->current;
		_tmp5_ = _valadoc_gtkdoc_token_ref0 (_tmp4_);
		_valadoc_gtkdoc_token_unref0 (tmp);
		tmp = _tmp5_;
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_tmp6_ = valadoc_gtkdoc_parser_parse_inline_content (self);
		run = _tmp6_;
		_tmp8_ = run;
		if (_tmp8_ != NULL) {
			ValadocContentRun* _tmp9_;
			ValaList* _tmp10_;
			ValaList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_tmp9_ = run;
			_tmp10_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp7_ = _tmp13_ > 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValadocContentParagraph* p = NULL;
			ValadocContentContentFactory* _tmp14_;
			ValadocContentParagraph* _tmp15_;
			ValadocContentParagraph* _tmp16_;
			ValaList* _tmp17_;
			ValaList* _tmp18_;
			ValadocContentRun* _tmp19_;
			ValaCollection* _tmp20_;
			ValadocContentParagraph* _tmp21_;
			_tmp14_ = self->priv->factory;
			_tmp15_ = valadoc_content_content_factory_create_paragraph (_tmp14_);
			p = _tmp15_;
			_tmp16_ = p;
			_tmp17_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = run;
			vala_collection_add ((ValaCollection*) _tmp18_, (ValadocContentInline*) _tmp19_);
			_tmp20_ = content;
			_tmp21_ = p;
			vala_collection_add (_tmp20_, (ValadocContentBlock*) _tmp21_);
			_g_object_unref0 (p);
			_g_object_unref0 (run);
			continue;
		}
		_tmp22_ = valadoc_gtkdoc_parser_parse_block_content (self);
		lst = _tmp22_;
		_tmp24_ = lst;
		if (_tmp24_ != NULL) {
			ValaCollection* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			_tmp25_ = lst;
			_tmp26_ = vala_collection_get_size (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp23_ = _tmp27_ > 0;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			ValaCollection* _tmp28_;
			ValaCollection* _tmp29_;
			_tmp28_ = content;
			_tmp29_ = lst;
			vala_collection_add_all (_tmp28_, _tmp29_);
			_vala_iterable_unref0 (lst);
			_g_object_unref0 (run);
			continue;
		}
		_vala_iterable_unref0 (lst);
		_g_object_unref0 (run);
	}
	result = content;
	_valadoc_gtkdoc_token_unref0 (tmp);
	return result;
}

static inline ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_simpara (ValadocGtkdocParser* self)
{
	ValaCollection* _tmp0_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_parse_docbook_para (self, "simpara");
	result = _tmp0_;
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_para (ValadocGtkdocParser* self,
                                          const gchar* tag_name)
{
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValaCollection* content = NULL;
	ValaCollection* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValadocGtkdocToken* _tmp11_;
	ValadocGtkdocToken* _tmp12_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tag_name);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_parser_next (self);
	_tmp4_ = _tmp3_;
	_valadoc_gtkdoc_token_unref0 (_tmp4_);
	_tmp5_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	content = _tmp5_;
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp7_;
		_tmp7_ = self->priv->current;
		_tmp6_ = _tmp7_->type != VALADOC_GTKDOC_TOKEN_TYPE_EOF;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValadocGtkdocToken* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = self->priv->current;
		_tmp9_ = g_strdup_printf ("</%s>", tag_name);
		_tmp10_ = _tmp9_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp8_, _tmp10_);
		_g_free0 (_tmp10_);
		result = content;
		return result;
	}
	_tmp11_ = valadoc_gtkdoc_parser_next (self);
	_tmp12_ = _tmp11_;
	_valadoc_gtkdoc_token_unref0 (_tmp12_);
	result = content;
	return result;
}

static ValadocContentSourceCodeLanguage*
_valadoc_content_source_code_language_dup (ValadocContentSourceCodeLanguage* self)
{
	ValadocContentSourceCodeLanguage* dup;
	dup = g_new0 (ValadocContentSourceCodeLanguage, 1);
	memcpy (dup, self, sizeof (ValadocContentSourceCodeLanguage));
	return dup;
}

static gpointer
__valadoc_content_source_code_language_dup0 (gpointer self)
{
	return self ? _valadoc_content_source_code_language_dup (self) : NULL;
}

static const gchar*
string_offset (const gchar* self,
               glong offset)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static ValadocContentParagraph*
valadoc_gtkdoc_parser_parse_gtkdoc_source (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp0_;
	GString* builder = NULL;
	GString* _tmp2_;
	ValadocGtkdocToken* source_token = NULL;
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocContentSourceCode* code = NULL;
	ValadocContentContentFactory* _tmp22_;
	ValadocContentSourceCode* _tmp23_;
	GMatchInfo* info = NULL;
	const gchar* source = NULL;
	GString* _tmp24_;
	const gchar* _tmp25_;
	GRegex* _tmp26_;
	const gchar* _tmp27_;
	GMatchInfo* _tmp28_ = NULL;
	gboolean _tmp29_;
	ValadocContentSourceCode* _tmp51_;
	const gchar* _tmp52_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp53_;
	ValadocContentParagraph* _tmp54_;
	ValadocContentParagraph* _tmp55_;
	ValaList* _tmp56_;
	ValaList* _tmp57_;
	ValadocContentSourceCode* _tmp58_;
	ValadocGtkdocToken* _tmp59_;
	ValadocGtkdocToken* _tmp61_;
	ValadocGtkdocToken* _tmp62_;
	ValadocContentParagraph* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current;
	if (_tmp0_->type != VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "|[");
		result = NULL;
		return result;
	}
	_tmp2_ = g_string_new ("");
	builder = _tmp2_;
	_tmp3_ = self->priv->current;
	_tmp4_ = _valadoc_gtkdoc_token_ref0 (_tmp3_);
	source_token = _tmp4_;
	{
		ValadocGtkdocToken* _tmp5_;
		ValadocGtkdocToken* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = valadoc_gtkdoc_parser_next (self);
		_tmp6_ = _tmp5_;
		_valadoc_gtkdoc_token_unref0 (_tmp6_);
		_tmp7_ = TRUE;
		while (TRUE) {
			gboolean _tmp10_ = FALSE;
			ValadocGtkdocToken* _tmp11_;
			ValadocGtkdocToken* _tmp13_;
			if (!_tmp7_) {
				ValadocGtkdocToken* _tmp8_;
				ValadocGtkdocToken* _tmp9_;
				_tmp8_ = valadoc_gtkdoc_parser_next (self);
				_tmp9_ = _tmp8_;
				_valadoc_gtkdoc_token_unref0 (_tmp9_);
			}
			_tmp7_ = FALSE;
			_tmp11_ = self->priv->current;
			if (_tmp11_->type != VALADOC_GTKDOC_TOKEN_TYPE_EOF) {
				ValadocGtkdocToken* _tmp12_;
				_tmp12_ = self->priv->current;
				_tmp10_ = _tmp12_->type != VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE;
			} else {
				_tmp10_ = FALSE;
			}
			if (!_tmp10_) {
				break;
			}
			_tmp13_ = self->priv->current;
			if (_tmp13_->type == VALADOC_GTKDOC_TOKEN_TYPE_WORD) {
				GString* _tmp14_;
				ValadocGtkdocToken* _tmp15_;
				const gchar* _tmp16_;
				_tmp14_ = builder;
				_tmp15_ = self->priv->current;
				_tmp16_ = _tmp15_->content;
				g_string_append (_tmp14_, _tmp16_);
			} else {
				ValadocGtkdocToken* _tmp17_;
				_tmp17_ = self->priv->current;
				if (_tmp17_->type != VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT) {
					GString* _tmp18_;
					ValadocGtkdocToken* _tmp19_;
					const gchar* _tmp20_;
					ValadocGtkdocToken* _tmp21_;
					_tmp18_ = builder;
					_tmp19_ = self->priv->current;
					_tmp20_ = _tmp19_->start;
					_tmp21_ = self->priv->current;
					g_string_append_len (_tmp18_, _tmp20_, (gssize) _tmp21_->length);
				}
			}
		}
	}
	_tmp22_ = self->priv->factory;
	_tmp23_ = valadoc_content_content_factory_create_source_code (_tmp22_);
	code = _tmp23_;
	_tmp24_ = builder;
	_tmp25_ = _tmp24_->str;
	source = _tmp25_;
	_tmp26_ = self->priv->regex_source_lang;
	_tmp27_ = source;
	_tmp29_ = g_regex_match (_tmp26_, _tmp27_, 0, &_tmp28_);
	_g_match_info_unref0 (info);
	info = _tmp28_;
	if (_tmp29_) {
		gchar* lang_name = NULL;
		GMatchInfo* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		ValadocContentSourceCodeLanguage* lang = NULL;
		const gchar* _tmp35_;
		ValadocContentSourceCodeLanguage _tmp36_;
		ValadocContentSourceCodeLanguage* _tmp37_;
		ValadocContentSourceCode* _tmp38_;
		ValadocContentSourceCodeLanguage* _tmp39_;
		ValadocContentSourceCodeLanguage* _tmp40_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		_tmp30_ = info;
		_tmp31_ = g_match_info_fetch (_tmp30_, 1);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_ascii_strdown (_tmp32_, (gssize) -1);
		_tmp34_ = _tmp33_;
		_g_free0 (_tmp32_);
		lang_name = _tmp34_;
		_tmp35_ = lang_name;
		_tmp36_ = valadoc_content_source_code_language_from_string (_tmp35_, FALSE);
		_tmp37_ = __valadoc_content_source_code_language_dup0 (&_tmp36_);
		lang = _tmp37_;
		_tmp38_ = code;
		_tmp39_ = lang;
		valadoc_content_source_code_set_language (_tmp38_, *_tmp39_);
		_tmp40_ = lang;
		if (_tmp40_ == NULL) {
			ValadocGtkdocToken* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp41_ = source_token;
			_tmp42_ = lang_name;
			_tmp43_ = g_strdup_printf ("Unknown language `%s' in source code block |[<!-- language=\"\"", _tmp42_);
			_tmp44_ = _tmp43_;
			valadoc_gtkdoc_parser_report_warning (self, _tmp41_, _tmp44_);
			_g_free0 (_tmp44_);
		}
		_tmp45_ = source;
		_tmp46_ = source;
		_tmp47_ = string_offset (_tmp45_, (glong) (string_index_of_char (_tmp46_, (gunichar) '>', 0) + 1));
		source = _tmp47_;
		_g_free0 (lang);
		_g_free0 (lang_name);
	} else {
		ValadocContentSourceCodeLanguage _tmp48_ = 0;
		const gchar* _tmp49_;
		ValadocContentSourceCode* _tmp50_;
		_tmp49_ = source;
		if (valadoc_highlighter_xml_scanner_is_xml (_tmp49_)) {
			_tmp48_ = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_XML;
		} else {
			_tmp48_ = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C;
		}
		_tmp50_ = code;
		valadoc_content_source_code_set_language (_tmp50_, _tmp48_);
	}
	_tmp51_ = code;
	_tmp52_ = source;
	valadoc_content_source_code_set_code (_tmp51_, _tmp52_);
	_tmp53_ = self->priv->factory;
	_tmp54_ = valadoc_content_content_factory_create_paragraph (_tmp53_);
	p = _tmp54_;
	_tmp55_ = p;
	_tmp56_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = code;
	vala_collection_add ((ValaCollection*) _tmp57_, (ValadocContentInline*) _tmp58_);
	_tmp59_ = self->priv->current;
	if (_tmp59_->type != VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE) {
		ValadocGtkdocToken* _tmp60_;
		_tmp60_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp60_, "|]");
		result = p;
		_g_match_info_unref0 (info);
		_g_object_unref0 (code);
		_valadoc_gtkdoc_token_unref0 (source_token);
		_g_string_free0 (builder);
		return result;
	}
	_tmp61_ = valadoc_gtkdoc_parser_next (self);
	_tmp62_ = _tmp61_;
	_valadoc_gtkdoc_token_unref0 (_tmp62_);
	result = p;
	_g_match_info_unref0 (info);
	_g_object_unref0 (code);
	_valadoc_gtkdoc_token_unref0 (source_token);
	_g_string_free0 (builder);
	return result;
}

static ValadocContentParagraph*
valadoc_gtkdoc_parser_parse_docbook_title (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentParagraph* _tmp4_;
	ValadocContentRun* content = NULL;
	ValadocContentRun* _tmp5_;
	ValadocContentRun* _tmp6_;
	ValaList* _tmp7_;
	ValaList* _tmp8_;
	ValadocContentContentFactory* _tmp9_;
	ValadocContentText* _tmp10_;
	ValadocContentText* _tmp11_;
	ValadocContentRun* _tmp12_;
	ValadocContentParagraph* _tmp13_;
	ValaList* _tmp14_;
	ValaList* _tmp15_;
	ValadocContentRun* _tmp16_;
	ValadocGtkdocToken* _tmp18_;
	ValadocGtkdocToken* _tmp19_;
	ValadocContentParagraph* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "title")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<title>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_paragraph (_tmp3_);
	p = _tmp4_;
	_tmp5_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	content = _tmp5_;
	_tmp6_ = content;
	_tmp7_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->factory;
	_tmp10_ = valadoc_content_content_factory_create_text (_tmp9_, ":");
	_tmp11_ = _tmp10_;
	vala_collection_add ((ValaCollection*) _tmp8_, (ValadocContentInline*) _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = content;
	valadoc_content_run_set_style (_tmp12_, VALADOC_CONTENT_RUN_STYLE_BOLD);
	_tmp13_ = p;
	_tmp14_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = content;
	vala_collection_add ((ValaCollection*) _tmp15_, (ValadocContentInline*) _tmp16_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "title")) {
		ValadocGtkdocToken* _tmp17_;
		_tmp17_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp17_, "</title>");
		result = p;
		_g_object_unref0 (content);
		return result;
	}
	_tmp18_ = valadoc_gtkdoc_parser_next (self);
	_tmp19_ = _tmp18_;
	_valadoc_gtkdoc_token_unref0 (_tmp19_);
	result = p;
	_g_object_unref0 (content);
	return result;
}

static ValadocContentParagraph*
valadoc_gtkdoc_parser_parse_docbook_graphic (ValadocGtkdocParser* self)
{
	ValadocContentEmbedded* tmp = NULL;
	ValadocContentEmbedded* _tmp0_;
	ValadocContentEmbedded* _tmp1_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp2_;
	ValadocContentParagraph* _tmp3_;
	ValadocContentParagraph* _tmp4_;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	ValadocContentEmbedded* _tmp7_;
	ValadocContentParagraph* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_parse_docbook_inlinegraphic (self, "graphic");
	tmp = _tmp0_;
	_tmp1_ = tmp;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (tmp);
		return result;
	}
	_tmp2_ = self->priv->factory;
	_tmp3_ = valadoc_content_content_factory_create_paragraph (_tmp2_);
	p = _tmp3_;
	_tmp4_ = p;
	_tmp5_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = tmp;
	vala_collection_add ((ValaCollection*) _tmp6_, (ValadocContentInline*) _tmp7_);
	result = p;
	_g_object_unref0 (tmp);
	return result;
}

static ValadocContentEmbedded*
valadoc_gtkdoc_parser_parse_docbook_inlinegraphic (ValadocGtkdocParser* self,
                                                   const gchar* tag_name)
{
	ValadocContentEmbedded* e = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentEmbedded* _tmp4_;
	ValadocContentEmbedded* _tmp5_;
	ValadocGtkdocToken* _tmp6_;
	ValaHashMap* _tmp7_;
	gpointer _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	ValadocGtkdocToken* _tmp12_;
	ValadocGtkdocToken* _tmp13_;
	ValadocGtkdocToken* _tmp17_;
	ValadocGtkdocToken* _tmp18_;
	ValadocContentEmbedded* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tag_name);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_embedded (_tmp3_);
	e = _tmp4_;
	_tmp5_ = e;
	_tmp6_ = self->priv->current;
	_tmp7_ = _tmp6_->attributes;
	_tmp8_ = vala_map_get ((ValaMap*) _tmp7_, "fileref");
	_tmp9_ = (gchar*) _tmp8_;
	_tmp10_ = valadoc_gtkdoc_parser_fix_resource_path (self, _tmp9_);
	_tmp11_ = _tmp10_;
	valadoc_content_embedded_set_url (_tmp5_, _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp12_ = valadoc_gtkdoc_parser_next (self);
	_tmp13_ = _tmp12_;
	_valadoc_gtkdoc_token_unref0 (_tmp13_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = self->priv->current;
		_tmp15_ = g_strdup_printf ("</%s>", tag_name);
		_tmp16_ = _tmp15_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp14_, _tmp16_);
		_g_free0 (_tmp16_);
		result = e;
		return result;
	}
	_tmp17_ = valadoc_gtkdoc_parser_next (self);
	_tmp18_ = _tmp17_;
	_valadoc_gtkdoc_token_unref0 (_tmp18_);
	result = e;
	return result;
}

static ValadocContentParagraph*
valadoc_gtkdoc_parser_parse_docbook_programlisting (ValadocGtkdocParser* self)
{
	GString* builder = NULL;
	GString* _tmp1_;
	ValadocContentSourceCode* src = NULL;
	ValadocContentContentFactory* _tmp22_;
	ValadocContentSourceCode* _tmp23_;
	ValadocContentSourceCode* _tmp24_;
	ValadocContentSourceCode* _tmp25_;
	GString* _tmp26_;
	const gchar* _tmp27_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp28_;
	ValadocContentParagraph* _tmp29_;
	ValadocContentParagraph* _tmp30_;
	ValaList* _tmp31_;
	ValaList* _tmp32_;
	ValadocContentSourceCode* _tmp33_;
	ValadocGtkdocToken* _tmp35_;
	ValadocGtkdocToken* _tmp36_;
	ValadocContentParagraph* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "programlisting")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<programlisting>");
		result = NULL;
		return result;
	}
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	{
		ValadocGtkdocToken* _tmp2_;
		ValadocGtkdocToken* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = valadoc_gtkdoc_parser_next (self);
		_tmp3_ = _tmp2_;
		_valadoc_gtkdoc_token_unref0 (_tmp3_);
		_tmp4_ = TRUE;
		while (TRUE) {
			gboolean _tmp7_ = FALSE;
			ValadocGtkdocToken* _tmp8_;
			ValadocGtkdocToken* _tmp13_;
			if (!_tmp4_) {
				ValadocGtkdocToken* _tmp5_;
				ValadocGtkdocToken* _tmp6_;
				_tmp5_ = valadoc_gtkdoc_parser_next (self);
				_tmp6_ = _tmp5_;
				_valadoc_gtkdoc_token_unref0 (_tmp6_);
			}
			_tmp4_ = FALSE;
			_tmp8_ = self->priv->current;
			if (_tmp8_->type != VALADOC_GTKDOC_TOKEN_TYPE_EOF) {
				gboolean _tmp9_ = FALSE;
				ValadocGtkdocToken* _tmp10_;
				_tmp10_ = self->priv->current;
				if (_tmp10_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
					ValadocGtkdocToken* _tmp11_;
					const gchar* _tmp12_;
					_tmp11_ = self->priv->current;
					_tmp12_ = _tmp11_->content;
					_tmp9_ = g_strcmp0 (_tmp12_, "programlisting") == 0;
				} else {
					_tmp9_ = FALSE;
				}
				_tmp7_ = !_tmp9_;
			} else {
				_tmp7_ = FALSE;
			}
			if (!_tmp7_) {
				break;
			}
			_tmp13_ = self->priv->current;
			if (_tmp13_->type == VALADOC_GTKDOC_TOKEN_TYPE_WORD) {
				GString* _tmp14_;
				ValadocGtkdocToken* _tmp15_;
				const gchar* _tmp16_;
				_tmp14_ = builder;
				_tmp15_ = self->priv->current;
				_tmp16_ = _tmp15_->content;
				g_string_append (_tmp14_, _tmp16_);
			} else {
				ValadocGtkdocToken* _tmp17_;
				_tmp17_ = self->priv->current;
				if (_tmp17_->type != VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT) {
					GString* _tmp18_;
					ValadocGtkdocToken* _tmp19_;
					const gchar* _tmp20_;
					ValadocGtkdocToken* _tmp21_;
					_tmp18_ = builder;
					_tmp19_ = self->priv->current;
					_tmp20_ = _tmp19_->start;
					_tmp21_ = self->priv->current;
					g_string_append_len (_tmp18_, _tmp20_, (gssize) _tmp21_->length);
				}
			}
		}
	}
	_tmp22_ = self->priv->factory;
	_tmp23_ = valadoc_content_content_factory_create_source_code (_tmp22_);
	src = _tmp23_;
	_tmp24_ = src;
	valadoc_content_source_code_set_language (_tmp24_, VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C);
	_tmp25_ = src;
	_tmp26_ = builder;
	_tmp27_ = _tmp26_->str;
	valadoc_content_source_code_set_code (_tmp25_, _tmp27_);
	_tmp28_ = self->priv->factory;
	_tmp29_ = valadoc_content_content_factory_create_paragraph (_tmp28_);
	p = _tmp29_;
	_tmp30_ = p;
	_tmp31_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = src;
	vala_collection_add ((ValaCollection*) _tmp32_, (ValadocContentInline*) _tmp33_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "programlisting")) {
		ValadocGtkdocToken* _tmp34_;
		_tmp34_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp34_, "</programlisting>");
		result = p;
		_g_object_unref0 (src);
		_g_string_free0 (builder);
		return result;
	}
	_tmp35_ = valadoc_gtkdoc_parser_next (self);
	_tmp36_ = _tmp35_;
	_valadoc_gtkdoc_token_unref0 (_tmp36_);
	result = p;
	_g_object_unref0 (src);
	_g_string_free0 (builder);
	return result;
}

static inline ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_informalexample (ValadocGtkdocParser* self)
{
	ValaCollection* _tmp0_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_parse_docbook_example (self, "informalexample");
	result = _tmp0_;
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_example (ValadocGtkdocParser* self,
                                             const gchar* tag_name)
{
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValaCollection* content = NULL;
	GEqualFunc _tmp5_;
	ValaArrayList* _tmp6_;
	ValaCollection* _tmp7_;
	ValaCollection* _tmp8_;
	ValaCollection* _tmp9_;
	ValadocGtkdocToken* _tmp13_;
	ValadocGtkdocToken* _tmp14_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tag_name);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_parser_next (self);
	_tmp4_ = _tmp3_;
	_valadoc_gtkdoc_token_unref0 (_tmp4_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp5_);
	content = (ValaCollection*) _tmp6_;
	_tmp7_ = content;
	_tmp8_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	_tmp9_ = _tmp8_;
	vala_collection_add_all (_tmp7_, _tmp9_);
	_vala_iterable_unref0 (_tmp9_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = self->priv->current;
		_tmp11_ = g_strdup_printf ("</%s>", tag_name);
		_tmp12_ = _tmp11_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp10_, _tmp12_);
		_g_free0 (_tmp12_);
		result = content;
		return result;
	}
	_tmp13_ = valadoc_gtkdoc_parser_next (self);
	_tmp14_ = _tmp13_;
	_valadoc_gtkdoc_token_unref0 (_tmp14_);
	result = content;
	return result;
}

static ValaList*
valadoc_gtkdoc_parser_parse_docbook_refsect2 (ValadocGtkdocParser* self,
                                              gint nr)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* id = NULL;
	ValadocGtkdocToken* _tmp6_;
	ValaHashMap* _tmp7_;
	gpointer _tmp8_;
	const gchar* _tmp9_;
	ValadocGtkdocToken* _tmp13_;
	ValadocGtkdocToken* _tmp14_;
	ValaList* content = NULL;
	GEqualFunc _tmp15_;
	ValaArrayList* _tmp16_;
	ValaList* _tmp17_;
	ValaCollection* _tmp18_;
	ValaCollection* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	ValadocGtkdocToken* _tmp26_;
	ValadocGtkdocToken* _tmp27_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("refsect%d", nr);
	_tmp1_ = _tmp0_;
	_tmp2_ = !valadoc_gtkdoc_parser_check_xml_open_tag (self, _tmp1_);
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		ValadocGtkdocToken* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->priv->current;
		_tmp4_ = g_strdup_printf ("<refsect%d>", nr);
		_tmp5_ = _tmp4_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp3_, _tmp5_);
		_g_free0 (_tmp5_);
		result = NULL;
		return result;
	}
	_tmp6_ = self->priv->current;
	_tmp7_ = _tmp6_->attributes;
	_tmp8_ = vala_map_get ((ValaMap*) _tmp7_, "id");
	id = (gchar*) _tmp8_;
	_tmp9_ = id;
	if (_tmp9_ != NULL) {
		ValadocImporterInternalIdRegistrar* _tmp10_;
		const gchar* _tmp11_;
		ValadocApiNode* _tmp12_;
		_tmp10_ = self->priv->id_registrar;
		_tmp11_ = id;
		_tmp12_ = self->priv->element;
		valadoc_importer_internal_id_registrar_register_symbol (_tmp10_, _tmp11_, _tmp12_);
	}
	_tmp13_ = valadoc_gtkdoc_parser_next (self);
	_tmp14_ = _tmp13_;
	_valadoc_gtkdoc_token_unref0 (_tmp14_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp15_ = g_direct_equal;
	_tmp16_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp15_);
	content = (ValaList*) _tmp16_;
	_tmp17_ = content;
	_tmp18_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	_tmp19_ = _tmp18_;
	valadoc_gtkdoc_parser_append_block_content_not_null_all (self, (ValaCollection*) _tmp17_, _tmp19_);
	_vala_iterable_unref0 (_tmp19_);
	_tmp20_ = g_strdup_printf ("refsect%d", nr);
	_tmp21_ = _tmp20_;
	_tmp22_ = !valadoc_gtkdoc_parser_check_xml_close_tag (self, _tmp21_);
	_g_free0 (_tmp21_);
	if (_tmp22_) {
		ValadocGtkdocToken* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp23_ = self->priv->current;
		_tmp24_ = g_strdup_printf ("</refsect%d>", nr);
		_tmp25_ = _tmp24_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp23_, _tmp25_);
		_g_free0 (_tmp25_);
		result = content;
		_g_free0 (id);
		return result;
	}
	_tmp26_ = valadoc_gtkdoc_parser_next (self);
	_tmp27_ = _tmp26_;
	_valadoc_gtkdoc_token_unref0 (_tmp27_);
	result = content;
	_g_free0 (id);
	return result;
}

static ValaList*
valadoc_gtkdoc_parser_parse_docbook_figure (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValaList* content = NULL;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValadocGtkdocToken* _tmp6_;
	ValadocGtkdocToken* _tmp42_;
	ValadocGtkdocToken* _tmp43_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "figure")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<figure>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_);
	content = (ValaList*) _tmp4_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp6_ = self->priv->current;
	if (_tmp6_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->content;
		_tmp5_ = g_strcmp0 (_tmp8_, "title") == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaList* _tmp9_;
		ValadocContentParagraph* _tmp10_;
		ValadocContentParagraph* _tmp11_;
		_tmp9_ = content;
		_tmp10_ = valadoc_gtkdoc_parser_parse_docbook_title (self);
		_tmp11_ = _tmp10_;
		valadoc_gtkdoc_parser_append_block_content_not_null (self, (ValaCollection*) _tmp9_, (ValadocContentBlock*) _tmp11_);
		_g_object_unref0 (_tmp11_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	}
	while (TRUE) {
		ValadocGtkdocToken* _tmp12_;
		ValadocGtkdocToken* _tmp13_;
		const gchar* _tmp14_;
		_tmp12_ = self->priv->current;
		if (!(_tmp12_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN)) {
			break;
		}
		_tmp13_ = self->priv->current;
		_tmp14_ = _tmp13_->content;
		if (g_strcmp0 (_tmp14_, "inlinegraphic") == 0) {
			ValadocContentParagraph* _tmp15_ = NULL;
			ValaList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValadocContentParagraph* p = NULL;
			ValadocContentParagraph* _tmp23_;
			ValadocContentParagraph* _tmp24_;
			_tmp16_ = content;
			_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ > 0) {
				ValaList* _tmp19_;
				gpointer _tmp20_;
				ValadocContentBlock* _tmp21_;
				ValadocContentParagraph* _tmp22_;
				_tmp19_ = content;
				_tmp20_ = vala_list_get (_tmp19_, 0);
				_tmp21_ = (ValadocContentBlock*) _tmp20_;
				_tmp22_ = VALADOC_CONTENT_IS_PARAGRAPH (_tmp21_) ? ((ValadocContentParagraph*) _tmp21_) : NULL;
				if (_tmp22_ == NULL) {
					_g_object_unref0 (_tmp21_);
				}
				_g_object_unref0 (_tmp15_);
				_tmp15_ = _tmp22_;
			} else {
				_g_object_unref0 (_tmp15_);
				_tmp15_ = NULL;
			}
			_tmp23_ = _g_object_ref0 (_tmp15_);
			p = _tmp23_;
			_tmp24_ = p;
			if (_tmp24_ == NULL) {
				ValadocContentContentFactory* _tmp25_;
				ValadocContentParagraph* _tmp26_;
				_tmp25_ = self->priv->factory;
				_tmp26_ = valadoc_content_content_factory_create_paragraph (_tmp25_);
				_g_object_unref0 (p);
				p = _tmp26_;
			}
			while (TRUE) {
				gboolean _tmp27_ = FALSE;
				ValadocGtkdocToken* _tmp28_;
				ValadocContentParagraph* _tmp31_;
				ValaList* _tmp32_;
				ValaList* _tmp33_;
				ValadocContentEmbedded* _tmp34_;
				ValadocContentEmbedded* _tmp35_;
				_tmp28_ = self->priv->current;
				if (_tmp28_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
					ValadocGtkdocToken* _tmp29_;
					const gchar* _tmp30_;
					_tmp29_ = self->priv->current;
					_tmp30_ = _tmp29_->content;
					_tmp27_ = g_strcmp0 (_tmp30_, "inlinegraphic") == 0;
				} else {
					_tmp27_ = FALSE;
				}
				if (!_tmp27_) {
					break;
				}
				_tmp31_ = p;
				_tmp32_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = valadoc_gtkdoc_parser_parse_docbook_inlinegraphic (self, "inlinegraphic");
				_tmp35_ = _tmp34_;
				vala_collection_add ((ValaCollection*) _tmp33_, (ValadocContentInline*) _tmp35_);
				_g_object_unref0 (_tmp35_);
				valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
			}
			_g_object_unref0 (p);
			_g_object_unref0 (_tmp15_);
		} else {
			ValadocGtkdocToken* _tmp36_;
			const gchar* _tmp37_;
			_tmp36_ = self->priv->current;
			_tmp37_ = _tmp36_->content;
			if (g_strcmp0 (_tmp37_, "graphic") == 0) {
				ValaList* _tmp38_;
				ValadocContentParagraph* _tmp39_;
				ValadocContentParagraph* _tmp40_;
				_tmp38_ = content;
				_tmp39_ = valadoc_gtkdoc_parser_parse_docbook_graphic (self);
				_tmp40_ = _tmp39_;
				valadoc_gtkdoc_parser_append_block_content_not_null (self, (ValaCollection*) _tmp38_, (ValadocContentBlock*) _tmp40_);
				_g_object_unref0 (_tmp40_);
			} else {
				break;
			}
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "figure")) {
		ValadocGtkdocToken* _tmp41_;
		_tmp41_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp41_, "</figure>");
		result = content;
		return result;
	}
	_tmp42_ = valadoc_gtkdoc_parser_next (self);
	_tmp43_ = _tmp42_;
	_valadoc_gtkdoc_token_unref0 (_tmp43_);
	result = content;
	return result;
}

static ValadocContentRun*
valadoc_gtkdoc_parser_parse_docbook_footnote (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	gint counter = 0;
	ValaList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	ValadocContentRun* nr = NULL;
	ValadocContentContentFactory* _tmp6_;
	ValadocContentRun* _tmp7_;
	ValadocContentRun* _tmp8_;
	ValaList* _tmp9_;
	ValaList* _tmp10_;
	ValadocContentContentFactory* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValadocContentText* _tmp14_;
	ValadocContentText* _tmp15_;
	ValaList* content = NULL;
	GEqualFunc _tmp16_;
	ValaArrayList* _tmp17_;
	ValaList* _tmp18_;
	ValaList* _tmp19_;
	ValaList* _tmp20_;
	ValaCollection* _tmp21_;
	ValaCollection* _tmp22_;
	ValadocContentParagraph* _tmp23_ = NULL;
	ValaList* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	ValadocContentParagraph* first = NULL;
	ValadocContentParagraph* _tmp31_;
	ValadocContentParagraph* _tmp32_;
	ValadocContentRun* entry = NULL;
	ValadocContentContentFactory* _tmp37_;
	ValadocContentRun* _tmp38_;
	ValadocContentRun* _tmp39_;
	ValaList* _tmp40_;
	ValaList* _tmp41_;
	ValadocContentContentFactory* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	ValadocContentText* _tmp47_;
	ValadocContentText* _tmp48_;
	ValadocContentParagraph* _tmp49_;
	ValaList* _tmp50_;
	ValaList* _tmp51_;
	ValadocContentRun* _tmp52_;
	ValadocGtkdocToken* _tmp54_;
	ValadocGtkdocToken* _tmp55_;
	ValadocContentRun* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "footnote")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<footnote>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	_tmp3_ = self->priv->footnotes;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	counter = _tmp5_ + 1;
	_tmp6_ = self->priv->factory;
	_tmp7_ = valadoc_content_content_factory_create_run (_tmp6_, VALADOC_CONTENT_RUN_STYLE_ITALIC);
	nr = _tmp7_;
	_tmp8_ = nr;
	_tmp9_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->factory;
	_tmp12_ = g_strdup_printf ("[%d] ", counter);
	_tmp13_ = _tmp12_;
	_tmp14_ = valadoc_content_content_factory_create_text (_tmp11_, _tmp13_);
	_tmp15_ = _tmp14_;
	vala_collection_add ((ValaCollection*) _tmp10_, (ValadocContentInline*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp16_ = g_direct_equal;
	_tmp17_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp16_);
	content = (ValaList*) _tmp17_;
	_tmp18_ = self->priv->footnotes;
	_tmp19_ = content;
	vala_collection_add ((ValaCollection*) _tmp18_, _tmp19_);
	_tmp20_ = content;
	_tmp21_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	_tmp22_ = _tmp21_;
	vala_collection_add_all ((ValaCollection*) _tmp20_, _tmp22_);
	_vala_iterable_unref0 (_tmp22_);
	_tmp24_ = content;
	_tmp25_ = vala_collection_get_is_empty ((ValaCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_) {
		_g_object_unref0 (_tmp23_);
		_tmp23_ = NULL;
	} else {
		ValaList* _tmp27_;
		gpointer _tmp28_;
		ValadocContentBlock* _tmp29_;
		ValadocContentParagraph* _tmp30_;
		_tmp27_ = content;
		_tmp28_ = vala_list_first (_tmp27_);
		_tmp29_ = (ValadocContentBlock*) _tmp28_;
		_tmp30_ = VALADOC_CONTENT_IS_PARAGRAPH (_tmp29_) ? ((ValadocContentParagraph*) _tmp29_) : NULL;
		if (_tmp30_ == NULL) {
			_g_object_unref0 (_tmp29_);
		}
		_g_object_unref0 (_tmp23_);
		_tmp23_ = _tmp30_;
	}
	_tmp31_ = _g_object_ref0 (_tmp23_);
	first = _tmp31_;
	_tmp32_ = first;
	if (_tmp32_ == NULL) {
		ValadocContentContentFactory* _tmp33_;
		ValadocContentParagraph* _tmp34_;
		ValaList* _tmp35_;
		ValadocContentParagraph* _tmp36_;
		_tmp33_ = self->priv->factory;
		_tmp34_ = valadoc_content_content_factory_create_paragraph (_tmp33_);
		_g_object_unref0 (first);
		first = _tmp34_;
		_tmp35_ = content;
		_tmp36_ = first;
		vala_list_insert (_tmp35_, 0, (ValadocContentBlock*) _tmp36_);
	}
	_tmp37_ = self->priv->factory;
	_tmp38_ = valadoc_content_content_factory_create_run (_tmp37_, VALADOC_CONTENT_RUN_STYLE_ITALIC);
	entry = _tmp38_;
	_tmp39_ = entry;
	_tmp40_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = self->priv->factory;
	_tmp43_ = g_strdup_printf ("%i", counter);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_strconcat (_tmp44_, ": ", NULL);
	_tmp46_ = _tmp45_;
	_tmp47_ = valadoc_content_content_factory_create_text (_tmp42_, _tmp46_);
	_tmp48_ = _tmp47_;
	vala_collection_add ((ValaCollection*) _tmp41_, (ValadocContentInline*) _tmp48_);
	_g_object_unref0 (_tmp48_);
	_g_free0 (_tmp46_);
	_g_free0 (_tmp44_);
	_tmp49_ = first;
	_tmp50_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = entry;
	vala_list_insert (_tmp51_, 0, (ValadocContentInline*) _tmp52_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "footnote")) {
		ValadocGtkdocToken* _tmp53_;
		_tmp53_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp53_, "</footnote>");
		result = nr;
		_g_object_unref0 (entry);
		_g_object_unref0 (first);
		_g_object_unref0 (_tmp23_);
		_vala_iterable_unref0 (content);
		return result;
	}
	_tmp54_ = valadoc_gtkdoc_parser_next (self);
	_tmp55_ = _tmp54_;
	_valadoc_gtkdoc_token_unref0 (_tmp55_);
	result = nr;
	_g_object_unref0 (entry);
	_g_object_unref0 (first);
	_g_object_unref0 (_tmp23_);
	_vala_iterable_unref0 (content);
	return result;
}

static inline void
valadoc_gtkdoc_parser_append_block_content_not_null_all (ValadocGtkdocParser* self,
                                                         ValaCollection* run,
                                                         ValaCollection* elements)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (run != NULL);
	if (elements != NULL) {
		vala_collection_add_all (run, elements);
	}
}

static inline void
valadoc_gtkdoc_parser_append_block_content_not_null (ValadocGtkdocParser* self,
                                                     ValaCollection* run,
                                                     ValadocContentBlock* element)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (run != NULL);
	if (element != NULL) {
		vala_collection_add (run, element);
	}
}

static ValadocContentTableRow*
valadoc_gtkdoc_parser_parse_docbook_thead (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentTableRow* row = NULL;
	ValadocContentTableRow* _tmp3_;
	ValadocGtkdocToken* _tmp5_;
	ValadocGtkdocToken* _tmp6_;
	ValadocContentTableRow* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "thead")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<thead>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp3_ = valadoc_gtkdoc_parser_parse_docbook_row (self, VALADOC_CONTENT_RUN_STYLE_BOLD);
	row = _tmp3_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "thead")) {
		ValadocGtkdocToken* _tmp4_;
		_tmp4_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp4_, "</thead>");
		result = row;
		return result;
	}
	_tmp5_ = valadoc_gtkdoc_parser_next (self);
	_tmp6_ = _tmp5_;
	_valadoc_gtkdoc_token_unref0 (_tmp6_);
	result = row;
	return result;
}

static ValadocContentTableCell*
valadoc_gtkdoc_parser_parse_docbook_entry (ValadocGtkdocParser* self,
                                           ValadocContentRunStyle default_style)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentTableCell* cell = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentTableCell* _tmp4_;
	ValadocContentRun* run = NULL;
	ValadocContentContentFactory* _tmp5_;
	ValadocContentRun* _tmp6_;
	ValadocContentRun* _tmp7_;
	ValaList* _tmp8_;
	ValaList* _tmp9_;
	ValadocContentRun* _tmp10_;
	ValadocContentRun* _tmp11_;
	ValadocContentTableCell* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	ValadocContentRun* _tmp15_;
	ValadocGtkdocToken* _tmp17_;
	ValadocGtkdocToken* _tmp18_;
	ValadocContentTableCell* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "entry")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<entry>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_table_cell (_tmp3_);
	cell = _tmp4_;
	_tmp5_ = self->priv->factory;
	_tmp6_ = valadoc_content_content_factory_create_run (_tmp5_, default_style);
	run = _tmp6_;
	_tmp7_ = run;
	_tmp8_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	_tmp11_ = _tmp10_;
	vala_collection_add ((ValaCollection*) _tmp9_, (ValadocContentInline*) _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = cell;
	_tmp13_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = run;
	vala_collection_add ((ValaCollection*) _tmp14_, (ValadocContentInline*) _tmp15_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "entry")) {
		ValadocGtkdocToken* _tmp16_;
		_tmp16_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp16_, "</entry>");
		result = cell;
		_g_object_unref0 (run);
		return result;
	}
	_tmp17_ = valadoc_gtkdoc_parser_next (self);
	_tmp18_ = _tmp17_;
	_valadoc_gtkdoc_token_unref0 (_tmp18_);
	result = cell;
	_g_object_unref0 (run);
	return result;
}

static ValadocContentTableRow*
valadoc_gtkdoc_parser_parse_docbook_row (ValadocGtkdocParser* self,
                                         ValadocContentRunStyle default_style)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentTableRow* row = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentTableRow* _tmp4_;
	ValadocGtkdocToken* _tmp16_;
	ValadocGtkdocToken* _tmp17_;
	ValadocContentTableRow* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "row")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<row>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_table_row (_tmp3_);
	row = _tmp4_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		ValadocGtkdocToken* _tmp6_;
		ValadocContentTableCell* table_cell = NULL;
		ValadocContentTableCell* _tmp9_;
		ValadocContentTableCell* _tmp10_;
		ValadocContentTableRow* _tmp11_;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		ValadocContentTableCell* _tmp14_;
		_tmp6_ = self->priv->current;
		if (_tmp6_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->current;
			_tmp8_ = _tmp7_->content;
			_tmp5_ = g_strcmp0 (_tmp8_, "entry") == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_tmp9_ = valadoc_gtkdoc_parser_parse_docbook_entry (self, default_style);
		table_cell = _tmp9_;
		_tmp10_ = table_cell;
		if (_tmp10_ == NULL) {
			_g_object_unref0 (table_cell);
			break;
		}
		_tmp11_ = row;
		_tmp12_ = valadoc_content_table_row_get_cells (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = table_cell;
		vala_collection_add ((ValaCollection*) _tmp13_, _tmp14_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_g_object_unref0 (table_cell);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "row")) {
		ValadocGtkdocToken* _tmp15_;
		_tmp15_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp15_, "</row>");
		result = row;
		return result;
	}
	_tmp16_ = valadoc_gtkdoc_parser_next (self);
	_tmp17_ = _tmp16_;
	_valadoc_gtkdoc_token_unref0 (_tmp17_);
	result = row;
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_tbody (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValaCollection* rows = NULL;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	ValadocGtkdocToken* _tmp14_;
	ValadocGtkdocToken* _tmp15_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "tbody")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<tbody>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALADOC_CONTENT_TYPE_TABLE_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_);
	rows = (ValaCollection*) _tmp4_;
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		ValadocGtkdocToken* _tmp6_;
		ValadocContentTableRow* row = NULL;
		ValadocContentTableRow* _tmp9_;
		ValadocContentTableRow* _tmp10_;
		ValaCollection* _tmp11_;
		ValadocContentTableRow* _tmp12_;
		_tmp6_ = self->priv->current;
		if (_tmp6_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->current;
			_tmp8_ = _tmp7_->content;
			_tmp5_ = g_strcmp0 (_tmp8_, "row") == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_tmp9_ = valadoc_gtkdoc_parser_parse_docbook_row (self, VALADOC_CONTENT_RUN_STYLE_NONE);
		row = _tmp9_;
		_tmp10_ = row;
		if (_tmp10_ == NULL) {
			_g_object_unref0 (row);
			break;
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_tmp11_ = rows;
		_tmp12_ = row;
		vala_collection_add (_tmp11_, _tmp12_);
		_g_object_unref0 (row);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "tbody")) {
		ValadocGtkdocToken* _tmp13_;
		_tmp13_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp13_, "</tbody>");
		result = rows;
		return result;
	}
	_tmp14_ = valadoc_gtkdoc_parser_next (self);
	_tmp15_ = _tmp14_;
	_valadoc_gtkdoc_token_unref0 (_tmp15_);
	result = rows;
	return result;
}

static ValadocContentTable*
valadoc_gtkdoc_parser_parse_docbook_tgroup (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentTable* table = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentTable* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValadocGtkdocToken* _tmp6_;
	gboolean _tmp15_ = FALSE;
	ValadocGtkdocToken* _tmp16_;
	ValadocGtkdocToken* _tmp26_;
	ValadocGtkdocToken* _tmp27_;
	ValadocContentTable* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "tgroup")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<tgroup>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_table (_tmp3_);
	table = _tmp4_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp6_ = self->priv->current;
	if (_tmp6_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->content;
		_tmp5_ = g_strcmp0 (_tmp8_, "thead") == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValadocContentTableRow* row = NULL;
		ValadocContentTableRow* _tmp9_;
		ValadocContentTableRow* _tmp10_;
		_tmp9_ = valadoc_gtkdoc_parser_parse_docbook_thead (self);
		row = _tmp9_;
		_tmp10_ = row;
		if (_tmp10_ != NULL) {
			ValadocContentTable* _tmp11_;
			ValaList* _tmp12_;
			ValaList* _tmp13_;
			ValadocContentTableRow* _tmp14_;
			valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
			_tmp11_ = table;
			_tmp12_ = valadoc_content_table_get_rows (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = row;
			vala_collection_add ((ValaCollection*) _tmp13_, _tmp14_);
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_g_object_unref0 (row);
	}
	_tmp16_ = self->priv->current;
	if (_tmp16_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = self->priv->current;
		_tmp18_ = _tmp17_->content;
		_tmp15_ = g_strcmp0 (_tmp18_, "tbody") == 0;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		ValaCollection* rows = NULL;
		ValaCollection* _tmp19_;
		ValaCollection* _tmp20_;
		_tmp19_ = valadoc_gtkdoc_parser_parse_docbook_tbody (self);
		rows = _tmp19_;
		_tmp20_ = rows;
		if (_tmp20_ != NULL) {
			ValadocContentTable* _tmp21_;
			ValaList* _tmp22_;
			ValaList* _tmp23_;
			ValaCollection* _tmp24_;
			_tmp21_ = table;
			_tmp22_ = valadoc_content_table_get_rows (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = rows;
			vala_collection_add_all ((ValaCollection*) _tmp23_, _tmp24_);
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_vala_iterable_unref0 (rows);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "tgroup")) {
		ValadocGtkdocToken* _tmp25_;
		_tmp25_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp25_, "</tgroup>");
		result = table;
		return result;
	}
	_tmp26_ = valadoc_gtkdoc_parser_next (self);
	_tmp27_ = _tmp26_;
	_valadoc_gtkdoc_token_unref0 (_tmp27_);
	result = table;
	return result;
}

static ValadocContentTable*
valadoc_gtkdoc_parser_parse_docbook_informaltable (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentTable* table = NULL;
	ValadocContentTable* _tmp3_;
	ValadocGtkdocToken* _tmp5_;
	ValadocGtkdocToken* _tmp6_;
	ValadocContentTable* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "informaltable")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<informaltable>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp3_ = valadoc_gtkdoc_parser_parse_docbook_tgroup (self);
	table = _tmp3_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "informaltable")) {
		ValadocGtkdocToken* _tmp4_;
		_tmp4_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp4_, "</informaltable>");
		result = table;
		return result;
	}
	_tmp5_ = valadoc_gtkdoc_parser_next (self);
	_tmp6_ = _tmp5_;
	_valadoc_gtkdoc_token_unref0 (_tmp6_);
	result = table;
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_section (ValadocGtkdocParser* self)
{
	gchar* id = NULL;
	ValadocGtkdocToken* _tmp1_;
	ValaHashMap* _tmp2_;
	gpointer _tmp3_;
	const gchar* _tmp4_;
	ValadocGtkdocToken* _tmp8_;
	ValadocGtkdocToken* _tmp9_;
	ValaCollection* content = NULL;
	ValaCollection* _tmp10_;
	ValadocGtkdocToken* _tmp12_;
	ValadocGtkdocToken* _tmp13_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "section")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<section>");
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->current;
	_tmp2_ = _tmp1_->attributes;
	_tmp3_ = vala_map_get ((ValaMap*) _tmp2_, "id");
	id = (gchar*) _tmp3_;
	_tmp4_ = id;
	if (_tmp4_ != NULL) {
		ValadocImporterInternalIdRegistrar* _tmp5_;
		const gchar* _tmp6_;
		ValadocApiNode* _tmp7_;
		_tmp5_ = self->priv->id_registrar;
		_tmp6_ = id;
		_tmp7_ = self->priv->element;
		valadoc_importer_internal_id_registrar_register_symbol (_tmp5_, _tmp6_, _tmp7_);
	}
	_tmp8_ = valadoc_gtkdoc_parser_next (self);
	_tmp9_ = _tmp8_;
	_valadoc_gtkdoc_token_unref0 (_tmp9_);
	_tmp10_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	content = _tmp10_;
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "section")) {
		ValadocGtkdocToken* _tmp11_;
		_tmp11_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp11_, "</section>");
		result = content;
		_g_free0 (id);
		return result;
	}
	_tmp12_ = valadoc_gtkdoc_parser_next (self);
	_tmp13_ = _tmp12_;
	_valadoc_gtkdoc_token_unref0 (_tmp13_);
	result = content;
	_g_free0 (id);
	return result;
}

static ValadocContentListItem*
valadoc_gtkdoc_parser_parse_docbook_member (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentListItem* item = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentListItem* _tmp4_;
	ValadocContentParagraph* para = NULL;
	ValadocContentContentFactory* _tmp5_;
	ValadocContentParagraph* _tmp6_;
	ValadocContentListItem* _tmp7_;
	ValaList* _tmp8_;
	ValaList* _tmp9_;
	ValadocContentParagraph* _tmp10_;
	ValadocContentParagraph* _tmp11_;
	ValaList* _tmp12_;
	ValaList* _tmp13_;
	ValadocContentRun* _tmp14_;
	ValadocContentRun* _tmp15_;
	ValadocGtkdocToken* _tmp17_;
	ValadocGtkdocToken* _tmp18_;
	ValadocContentListItem* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "member")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<member>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_list_item (_tmp3_);
	item = _tmp4_;
	_tmp5_ = self->priv->factory;
	_tmp6_ = valadoc_content_content_factory_create_paragraph (_tmp5_);
	para = _tmp6_;
	_tmp7_ = item;
	_tmp8_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = para;
	vala_collection_add ((ValaCollection*) _tmp9_, (ValadocContentBlock*) _tmp10_);
	_tmp11_ = para;
	_tmp12_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	_tmp15_ = _tmp14_;
	vala_collection_add ((ValaCollection*) _tmp13_, (ValadocContentInline*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "member")) {
		ValadocGtkdocToken* _tmp16_;
		_tmp16_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp16_, "</member>");
		result = item;
		_g_object_unref0 (para);
		return result;
	}
	_tmp17_ = valadoc_gtkdoc_parser_next (self);
	_tmp18_ = _tmp17_;
	_valadoc_gtkdoc_token_unref0 (_tmp18_);
	result = item;
	_g_object_unref0 (para);
	return result;
}

static ValadocContentList*
valadoc_gtkdoc_parser_parse_docbook_simplelist (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentList* list = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentList* _tmp4_;
	ValadocGtkdocToken* _tmp16_;
	ValadocGtkdocToken* _tmp17_;
	ValadocContentList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "simplelist")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<simplelist>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_list (_tmp3_);
	list = _tmp4_;
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		ValadocGtkdocToken* _tmp6_;
		ValadocContentListItem* item = NULL;
		ValadocContentListItem* _tmp9_;
		ValadocContentListItem* _tmp10_;
		ValadocContentList* _tmp11_;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		ValadocContentListItem* _tmp14_;
		_tmp6_ = self->priv->current;
		if (_tmp6_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->current;
			_tmp8_ = _tmp7_->content;
			_tmp5_ = g_strcmp0 (_tmp8_, "member") == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_tmp9_ = valadoc_gtkdoc_parser_parse_docbook_member (self);
		item = _tmp9_;
		_tmp10_ = item;
		if (_tmp10_ == NULL) {
			_g_object_unref0 (item);
			break;
		}
		_tmp11_ = list;
		_tmp12_ = valadoc_content_list_get_items (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = item;
		vala_collection_add ((ValaCollection*) _tmp13_, _tmp14_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_g_object_unref0 (item);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "simplelist")) {
		ValadocGtkdocToken* _tmp15_;
		_tmp15_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp15_, "</simplelist>");
		result = list;
		return result;
	}
	_tmp16_ = valadoc_gtkdoc_parser_next (self);
	_tmp17_ = _tmp16_;
	_valadoc_gtkdoc_token_unref0 (_tmp17_);
	result = list;
	return result;
}

static ValadocContentParagraph*
valadoc_gtkdoc_parser_parse_docbook_term (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentParagraph* _tmp4_;
	ValadocContentRun* run = NULL;
	ValadocContentRun* _tmp5_;
	ValadocContentRun* _tmp6_;
	ValadocContentParagraph* _tmp7_;
	ValaList* _tmp8_;
	ValaList* _tmp9_;
	ValadocContentRun* _tmp10_;
	ValadocGtkdocToken* _tmp12_;
	ValadocGtkdocToken* _tmp13_;
	ValadocContentParagraph* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "term")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<term>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_paragraph (_tmp3_);
	p = _tmp4_;
	_tmp5_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	run = _tmp5_;
	_tmp6_ = run;
	valadoc_content_run_set_style (_tmp6_, VALADOC_CONTENT_RUN_STYLE_ITALIC);
	_tmp7_ = p;
	_tmp8_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = run;
	vala_collection_add ((ValaCollection*) _tmp9_, (ValadocContentInline*) _tmp10_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "term")) {
		ValadocGtkdocToken* _tmp11_;
		_tmp11_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp11_, "</term>");
		result = p;
		_g_object_unref0 (run);
		return result;
	}
	_tmp12_ = valadoc_gtkdoc_parser_next (self);
	_tmp13_ = _tmp12_;
	_valadoc_gtkdoc_token_unref0 (_tmp13_);
	result = p;
	_g_object_unref0 (run);
	return result;
}

static ValadocContentListItem*
valadoc_gtkdoc_parser_parse_docbook_varlistentry (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValadocGtkdocToken* _tmp4_;
	ValadocContentParagraph* term = NULL;
	ValadocContentParagraph* _tmp7_;
	ValadocContentParagraph* _tmp8_;
	ValadocContentListItem* desc = NULL;
	ValadocContentListItem* _tmp9_;
	ValadocContentListItem* _tmp10_;
	ValadocContentListItem* listitem = NULL;
	ValadocContentContentFactory* _tmp11_;
	ValadocContentListItem* _tmp12_;
	ValadocContentList* list = NULL;
	ValadocContentContentFactory* _tmp13_;
	ValadocContentList* _tmp14_;
	ValadocContentListItem* _tmp15_;
	ValaList* _tmp16_;
	ValaList* _tmp17_;
	ValadocContentParagraph* _tmp18_;
	ValadocContentListItem* _tmp19_;
	ValaList* _tmp20_;
	ValaList* _tmp21_;
	ValadocContentList* _tmp22_;
	ValadocContentList* _tmp23_;
	ValaList* _tmp24_;
	ValaList* _tmp25_;
	ValadocContentListItem* _tmp26_;
	ValadocGtkdocToken* _tmp28_;
	ValadocGtkdocToken* _tmp29_;
	ValadocContentListItem* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "varlistentry")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<varlistentry>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp4_ = self->priv->current;
	if (_tmp4_->type != VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		_tmp3_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->content;
		_tmp3_ = g_strcmp0 (_tmp6_, "term") != 0;
	}
	if (_tmp3_) {
		result = NULL;
		return result;
	}
	_tmp7_ = valadoc_gtkdoc_parser_parse_docbook_term (self);
	term = _tmp7_;
	_tmp8_ = term;
	if (_tmp8_ == NULL) {
		result = NULL;
		_g_object_unref0 (term);
		return result;
	}
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp9_ = valadoc_gtkdoc_parser_parse_docbook_listitem (self);
	desc = _tmp9_;
	_tmp10_ = desc;
	if (_tmp10_ == NULL) {
		result = NULL;
		_g_object_unref0 (desc);
		_g_object_unref0 (term);
		return result;
	}
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp11_ = self->priv->factory;
	_tmp12_ = valadoc_content_content_factory_create_list_item (_tmp11_);
	listitem = _tmp12_;
	_tmp13_ = self->priv->factory;
	_tmp14_ = valadoc_content_content_factory_create_list (_tmp13_);
	list = _tmp14_;
	_tmp15_ = listitem;
	_tmp16_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = term;
	vala_collection_add ((ValaCollection*) _tmp17_, (ValadocContentBlock*) _tmp18_);
	_tmp19_ = listitem;
	_tmp20_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = list;
	vala_collection_add ((ValaCollection*) _tmp21_, (ValadocContentBlock*) _tmp22_);
	_tmp23_ = list;
	_tmp24_ = valadoc_content_list_get_items (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = desc;
	vala_collection_add ((ValaCollection*) _tmp25_, _tmp26_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "varlistentry")) {
		ValadocGtkdocToken* _tmp27_;
		_tmp27_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp27_, "</varlistentry>");
		result = listitem;
		_g_object_unref0 (list);
		_g_object_unref0 (desc);
		_g_object_unref0 (term);
		return result;
	}
	_tmp28_ = valadoc_gtkdoc_parser_next (self);
	_tmp29_ = _tmp28_;
	_valadoc_gtkdoc_token_unref0 (_tmp29_);
	result = listitem;
	_g_object_unref0 (list);
	_g_object_unref0 (desc);
	_g_object_unref0 (term);
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_variablelist (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValaCollection* content = NULL;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValadocGtkdocToken* _tmp6_;
	ValadocContentList* list = NULL;
	ValadocContentContentFactory* _tmp12_;
	ValadocContentList* _tmp13_;
	ValaCollection* _tmp14_;
	ValadocContentList* _tmp15_;
	ValadocGtkdocToken* _tmp27_;
	ValadocGtkdocToken* _tmp28_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "variablelist")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<variablelist>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_);
	content = (ValaCollection*) _tmp4_;
	_tmp6_ = self->priv->current;
	if (_tmp6_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->content;
		_tmp5_ = g_strcmp0 (_tmp8_, "title") == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCollection* _tmp9_;
		ValadocContentParagraph* _tmp10_;
		ValadocContentParagraph* _tmp11_;
		_tmp9_ = content;
		_tmp10_ = valadoc_gtkdoc_parser_parse_docbook_title (self);
		_tmp11_ = _tmp10_;
		valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp9_, (ValadocContentBlock*) _tmp11_);
		_g_object_unref0 (_tmp11_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	}
	_tmp12_ = self->priv->factory;
	_tmp13_ = valadoc_content_content_factory_create_list (_tmp12_);
	list = _tmp13_;
	_tmp14_ = content;
	_tmp15_ = list;
	vala_collection_add (_tmp14_, (ValadocContentBlock*) _tmp15_);
	while (TRUE) {
		gboolean _tmp16_ = FALSE;
		ValadocGtkdocToken* _tmp17_;
		ValadocContentListItem* item = NULL;
		ValadocContentListItem* _tmp20_;
		ValadocContentListItem* _tmp21_;
		ValadocContentList* _tmp22_;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		ValadocContentListItem* _tmp25_;
		_tmp17_ = self->priv->current;
		if (_tmp17_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp18_;
			const gchar* _tmp19_;
			_tmp18_ = self->priv->current;
			_tmp19_ = _tmp18_->content;
			_tmp16_ = g_strcmp0 (_tmp19_, "varlistentry") == 0;
		} else {
			_tmp16_ = FALSE;
		}
		if (!_tmp16_) {
			break;
		}
		_tmp20_ = valadoc_gtkdoc_parser_parse_docbook_varlistentry (self);
		item = _tmp20_;
		_tmp21_ = item;
		if (_tmp21_ == NULL) {
			_g_object_unref0 (item);
			break;
		}
		_tmp22_ = list;
		_tmp23_ = valadoc_content_list_get_items (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = item;
		vala_collection_add ((ValaCollection*) _tmp24_, _tmp25_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_g_object_unref0 (item);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "variablelist")) {
		ValadocGtkdocToken* _tmp26_;
		_tmp26_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp26_, "</variablelist>");
		result = content;
		_g_object_unref0 (list);
		return result;
	}
	_tmp27_ = valadoc_gtkdoc_parser_next (self);
	_tmp28_ = _tmp27_;
	_valadoc_gtkdoc_token_unref0 (_tmp28_);
	result = content;
	_g_object_unref0 (list);
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_block_content (ValadocGtkdocParser* self)
{
	ValaCollection* content = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	content = (ValaCollection*) _tmp1_;
	while (TRUE) {
		ValadocGtkdocToken* _tmp2_;
		gboolean _tmp3_ = FALSE;
		ValadocGtkdocToken* _tmp4_;
		_tmp2_ = self->priv->current;
		if (!(_tmp2_->type != VALADOC_GTKDOC_TOKEN_TYPE_EOF)) {
			break;
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
		_tmp4_ = self->priv->current;
		if (_tmp4_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_->content;
			_tmp3_ = g_strcmp0 (_tmp6_, "itemizedlist") == 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			ValaCollection* _tmp7_;
			ValaCollection* _tmp8_;
			ValaCollection* _tmp9_;
			_tmp7_ = content;
			_tmp8_ = valadoc_gtkdoc_parser_parse_docbook_itemizedlist (self, "itemizedlist", VALADOC_CONTENT_LIST_BULLET_UNORDERED);
			_tmp9_ = _tmp8_;
			valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp7_, _tmp9_);
			_vala_iterable_unref0 (_tmp9_);
		} else {
			gboolean _tmp10_ = FALSE;
			ValadocGtkdocToken* _tmp11_;
			_tmp11_ = self->priv->current;
			if (_tmp11_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
				ValadocGtkdocToken* _tmp12_;
				const gchar* _tmp13_;
				_tmp12_ = self->priv->current;
				_tmp13_ = _tmp12_->content;
				_tmp10_ = g_strcmp0 (_tmp13_, "orderedlist") == 0;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				ValaCollection* _tmp14_;
				ValaCollection* _tmp15_;
				ValaCollection* _tmp16_;
				_tmp14_ = content;
				_tmp15_ = valadoc_gtkdoc_parser_parse_docbook_orderedlist (self);
				_tmp16_ = _tmp15_;
				valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp14_, _tmp16_);
				_vala_iterable_unref0 (_tmp16_);
			} else {
				gboolean _tmp17_ = FALSE;
				ValadocGtkdocToken* _tmp18_;
				_tmp18_ = self->priv->current;
				if (_tmp18_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
					ValadocGtkdocToken* _tmp19_;
					const gchar* _tmp20_;
					_tmp19_ = self->priv->current;
					_tmp20_ = _tmp19_->content;
					_tmp17_ = g_strcmp0 (_tmp20_, "variablelist") == 0;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					ValaCollection* _tmp21_;
					ValaCollection* _tmp22_;
					ValaCollection* _tmp23_;
					_tmp21_ = content;
					_tmp22_ = valadoc_gtkdoc_parser_parse_docbook_variablelist (self);
					_tmp23_ = _tmp22_;
					valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp21_, _tmp23_);
					_vala_iterable_unref0 (_tmp23_);
				} else {
					gboolean _tmp24_ = FALSE;
					ValadocGtkdocToken* _tmp25_;
					_tmp25_ = self->priv->current;
					if (_tmp25_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
						ValadocGtkdocToken* _tmp26_;
						const gchar* _tmp27_;
						_tmp26_ = self->priv->current;
						_tmp27_ = _tmp26_->content;
						_tmp24_ = g_strcmp0 (_tmp27_, "simplelist") == 0;
					} else {
						_tmp24_ = FALSE;
					}
					if (_tmp24_) {
						ValaCollection* _tmp28_;
						ValadocContentList* _tmp29_;
						ValadocContentList* _tmp30_;
						_tmp28_ = content;
						_tmp29_ = valadoc_gtkdoc_parser_parse_docbook_simplelist (self);
						_tmp30_ = _tmp29_;
						valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp28_, (ValadocContentBlock*) _tmp30_);
						_g_object_unref0 (_tmp30_);
					} else {
						gboolean _tmp31_ = FALSE;
						ValadocGtkdocToken* _tmp32_;
						_tmp32_ = self->priv->current;
						if (_tmp32_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
							ValadocGtkdocToken* _tmp33_;
							const gchar* _tmp34_;
							_tmp33_ = self->priv->current;
							_tmp34_ = _tmp33_->content;
							_tmp31_ = g_strcmp0 (_tmp34_, "informaltable") == 0;
						} else {
							_tmp31_ = FALSE;
						}
						if (_tmp31_) {
							ValaCollection* _tmp35_;
							ValadocContentTable* _tmp36_;
							ValadocContentTable* _tmp37_;
							_tmp35_ = content;
							_tmp36_ = valadoc_gtkdoc_parser_parse_docbook_informaltable (self);
							_tmp37_ = _tmp36_;
							valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp35_, (ValadocContentBlock*) _tmp37_);
							_g_object_unref0 (_tmp37_);
						} else {
							gboolean _tmp38_ = FALSE;
							ValadocGtkdocToken* _tmp39_;
							_tmp39_ = self->priv->current;
							if (_tmp39_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
								ValadocGtkdocToken* _tmp40_;
								const gchar* _tmp41_;
								_tmp40_ = self->priv->current;
								_tmp41_ = _tmp40_->content;
								_tmp38_ = g_strcmp0 (_tmp41_, "programlisting") == 0;
							} else {
								_tmp38_ = FALSE;
							}
							if (_tmp38_) {
								ValaCollection* _tmp42_;
								ValadocContentParagraph* _tmp43_;
								ValadocContentParagraph* _tmp44_;
								_tmp42_ = content;
								_tmp43_ = valadoc_gtkdoc_parser_parse_docbook_programlisting (self);
								_tmp44_ = _tmp43_;
								valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp42_, (ValadocContentBlock*) _tmp44_);
								_g_object_unref0 (_tmp44_);
							} else {
								gboolean _tmp45_ = FALSE;
								ValadocGtkdocToken* _tmp46_;
								_tmp46_ = self->priv->current;
								if (_tmp46_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
									ValadocGtkdocToken* _tmp47_;
									const gchar* _tmp48_;
									_tmp47_ = self->priv->current;
									_tmp48_ = _tmp47_->content;
									_tmp45_ = g_strcmp0 (_tmp48_, "para") == 0;
								} else {
									_tmp45_ = FALSE;
								}
								if (_tmp45_) {
									ValaCollection* _tmp49_;
									ValaCollection* _tmp50_;
									ValaCollection* _tmp51_;
									_tmp49_ = content;
									_tmp50_ = valadoc_gtkdoc_parser_parse_docbook_para (self, "para");
									_tmp51_ = _tmp50_;
									valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp49_, _tmp51_);
									_vala_iterable_unref0 (_tmp51_);
								} else {
									gboolean _tmp52_ = FALSE;
									ValadocGtkdocToken* _tmp53_;
									_tmp53_ = self->priv->current;
									if (_tmp53_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
										ValadocGtkdocToken* _tmp54_;
										const gchar* _tmp55_;
										_tmp54_ = self->priv->current;
										_tmp55_ = _tmp54_->content;
										_tmp52_ = g_strcmp0 (_tmp55_, "simpara") == 0;
									} else {
										_tmp52_ = FALSE;
									}
									if (_tmp52_) {
										ValaCollection* _tmp56_;
										ValaCollection* _tmp57_;
										ValaCollection* _tmp58_;
										_tmp56_ = content;
										_tmp57_ = valadoc_gtkdoc_parser_parse_docbook_simpara (self);
										_tmp58_ = _tmp57_;
										valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp56_, _tmp58_);
										_vala_iterable_unref0 (_tmp58_);
									} else {
										gboolean _tmp59_ = FALSE;
										ValadocGtkdocToken* _tmp60_;
										_tmp60_ = self->priv->current;
										if (_tmp60_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
											ValadocGtkdocToken* _tmp61_;
											const gchar* _tmp62_;
											_tmp61_ = self->priv->current;
											_tmp62_ = _tmp61_->content;
											_tmp59_ = g_strcmp0 (_tmp62_, "informalexample") == 0;
										} else {
											_tmp59_ = FALSE;
										}
										if (_tmp59_) {
											ValaCollection* _tmp63_;
											ValaCollection* _tmp64_;
											ValaCollection* _tmp65_;
											_tmp63_ = content;
											_tmp64_ = valadoc_gtkdoc_parser_parse_docbook_informalexample (self);
											_tmp65_ = _tmp64_;
											valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp63_, _tmp65_);
											_vala_iterable_unref0 (_tmp65_);
										} else {
											gboolean _tmp66_ = FALSE;
											ValadocGtkdocToken* _tmp67_;
											_tmp67_ = self->priv->current;
											if (_tmp67_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
												ValadocGtkdocToken* _tmp68_;
												const gchar* _tmp69_;
												_tmp68_ = self->priv->current;
												_tmp69_ = _tmp68_->content;
												_tmp66_ = g_strcmp0 (_tmp69_, "example") == 0;
											} else {
												_tmp66_ = FALSE;
											}
											if (_tmp66_) {
												ValaCollection* _tmp70_;
												ValaCollection* _tmp71_;
												ValaCollection* _tmp72_;
												_tmp70_ = content;
												_tmp71_ = valadoc_gtkdoc_parser_parse_docbook_example (self, "example");
												_tmp72_ = _tmp71_;
												valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp70_, _tmp72_);
												_vala_iterable_unref0 (_tmp72_);
											} else {
												gboolean _tmp73_ = FALSE;
												ValadocGtkdocToken* _tmp74_;
												_tmp74_ = self->priv->current;
												if (_tmp74_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
													ValadocGtkdocToken* _tmp75_;
													const gchar* _tmp76_;
													_tmp75_ = self->priv->current;
													_tmp76_ = _tmp75_->content;
													_tmp73_ = g_strcmp0 (_tmp76_, "warning") == 0;
												} else {
													_tmp73_ = FALSE;
												}
												if (_tmp73_) {
													ValaCollection* _tmp77_;
													ValadocContentWarning* _tmp78_;
													ValadocContentWarning* _tmp79_;
													_tmp77_ = content;
													_tmp78_ = valadoc_gtkdoc_parser_parse_docbook_warning (self);
													_tmp79_ = _tmp78_;
													valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp77_, (ValadocContentBlock*) _tmp79_);
													_g_object_unref0 (_tmp79_);
												} else {
													gboolean _tmp80_ = FALSE;
													ValadocGtkdocToken* _tmp81_;
													_tmp81_ = self->priv->current;
													if (_tmp81_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
														ValadocGtkdocToken* _tmp82_;
														const gchar* _tmp83_;
														_tmp82_ = self->priv->current;
														_tmp83_ = _tmp82_->content;
														_tmp80_ = g_strcmp0 (_tmp83_, "note") == 0;
													} else {
														_tmp80_ = FALSE;
													}
													if (_tmp80_) {
														ValaCollection* _tmp84_;
														ValadocContentNote* _tmp85_;
														ValadocContentNote* _tmp86_;
														_tmp84_ = content;
														_tmp85_ = valadoc_gtkdoc_parser_parse_docbook_note (self);
														_tmp86_ = _tmp85_;
														valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp84_, (ValadocContentBlock*) _tmp86_);
														_g_object_unref0 (_tmp86_);
													} else {
														gboolean _tmp87_ = FALSE;
														ValadocGtkdocToken* _tmp88_;
														_tmp88_ = self->priv->current;
														if (_tmp88_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
															ValadocGtkdocToken* _tmp89_;
															const gchar* _tmp90_;
															_tmp89_ = self->priv->current;
															_tmp90_ = _tmp89_->content;
															_tmp87_ = g_strcmp0 (_tmp90_, "important") == 0;
														} else {
															_tmp87_ = FALSE;
														}
														if (_tmp87_) {
															ValaCollection* _tmp91_;
															ValadocContentNote* _tmp92_;
															ValadocContentNote* _tmp93_;
															_tmp91_ = content;
															_tmp92_ = valadoc_gtkdoc_parser_parse_docbook_important (self);
															_tmp93_ = _tmp92_;
															valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp91_, (ValadocContentBlock*) _tmp93_);
															_g_object_unref0 (_tmp93_);
														} else {
															gboolean _tmp94_ = FALSE;
															ValadocGtkdocToken* _tmp95_;
															_tmp95_ = self->priv->current;
															if (_tmp95_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																ValadocGtkdocToken* _tmp96_;
																const gchar* _tmp97_;
																_tmp96_ = self->priv->current;
																_tmp97_ = _tmp96_->content;
																_tmp94_ = g_strcmp0 (_tmp97_, "refsect3") == 0;
															} else {
																_tmp94_ = FALSE;
															}
															if (_tmp94_) {
																ValaCollection* _tmp98_;
																ValaList* _tmp99_;
																ValaList* _tmp100_;
																_tmp98_ = content;
																_tmp99_ = valadoc_gtkdoc_parser_parse_docbook_refsect2 (self, 3);
																_tmp100_ = _tmp99_;
																valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp98_, (ValaCollection*) _tmp100_);
																_vala_iterable_unref0 (_tmp100_);
															} else {
																gboolean _tmp101_ = FALSE;
																ValadocGtkdocToken* _tmp102_;
																_tmp102_ = self->priv->current;
																if (_tmp102_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																	ValadocGtkdocToken* _tmp103_;
																	const gchar* _tmp104_;
																	_tmp103_ = self->priv->current;
																	_tmp104_ = _tmp103_->content;
																	_tmp101_ = g_strcmp0 (_tmp104_, "refsect2") == 0;
																} else {
																	_tmp101_ = FALSE;
																}
																if (_tmp101_) {
																	ValaCollection* _tmp105_;
																	ValaList* _tmp106_;
																	ValaList* _tmp107_;
																	_tmp105_ = content;
																	_tmp106_ = valadoc_gtkdoc_parser_parse_docbook_refsect2 (self, 2);
																	_tmp107_ = _tmp106_;
																	valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp105_, (ValaCollection*) _tmp107_);
																	_vala_iterable_unref0 (_tmp107_);
																} else {
																	gboolean _tmp108_ = FALSE;
																	ValadocGtkdocToken* _tmp109_;
																	_tmp109_ = self->priv->current;
																	if (_tmp109_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																		ValadocGtkdocToken* _tmp110_;
																		const gchar* _tmp111_;
																		_tmp110_ = self->priv->current;
																		_tmp111_ = _tmp110_->content;
																		_tmp108_ = g_strcmp0 (_tmp111_, "figure") == 0;
																	} else {
																		_tmp108_ = FALSE;
																	}
																	if (_tmp108_) {
																		ValaCollection* _tmp112_;
																		ValaList* _tmp113_;
																		ValaList* _tmp114_;
																		_tmp112_ = content;
																		_tmp113_ = valadoc_gtkdoc_parser_parse_docbook_figure (self);
																		_tmp114_ = _tmp113_;
																		valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp112_, (ValaCollection*) _tmp114_);
																		_vala_iterable_unref0 (_tmp114_);
																	} else {
																		gboolean _tmp115_ = FALSE;
																		ValadocGtkdocToken* _tmp116_;
																		_tmp116_ = self->priv->current;
																		if (_tmp116_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																			ValadocGtkdocToken* _tmp117_;
																			const gchar* _tmp118_;
																			_tmp117_ = self->priv->current;
																			_tmp118_ = _tmp117_->content;
																			_tmp115_ = g_strcmp0 (_tmp118_, "title") == 0;
																		} else {
																			_tmp115_ = FALSE;
																		}
																		if (_tmp115_) {
																			ValaCollection* _tmp119_;
																			ValadocContentParagraph* _tmp120_;
																			ValadocContentParagraph* _tmp121_;
																			_tmp119_ = content;
																			_tmp120_ = valadoc_gtkdoc_parser_parse_docbook_title (self);
																			_tmp121_ = _tmp120_;
																			valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp119_, (ValadocContentBlock*) _tmp121_);
																			_g_object_unref0 (_tmp121_);
																		} else {
																			gboolean _tmp122_ = FALSE;
																			ValadocGtkdocToken* _tmp123_;
																			_tmp123_ = self->priv->current;
																			if (_tmp123_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																				ValadocGtkdocToken* _tmp124_;
																				const gchar* _tmp125_;
																				_tmp124_ = self->priv->current;
																				_tmp125_ = _tmp124_->content;
																				_tmp122_ = g_strcmp0 (_tmp125_, "section") == 0;
																			} else {
																				_tmp122_ = FALSE;
																			}
																			if (_tmp122_) {
																				ValaCollection* _tmp126_;
																				ValaCollection* _tmp127_;
																				ValaCollection* _tmp128_;
																				_tmp126_ = content;
																				_tmp127_ = valadoc_gtkdoc_parser_parse_docbook_section (self);
																				_tmp128_ = _tmp127_;
																				valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp126_, _tmp128_);
																				_vala_iterable_unref0 (_tmp128_);
																			} else {
																				ValadocGtkdocToken* _tmp129_;
																				_tmp129_ = self->priv->current;
																				if (_tmp129_->type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH) {
																					ValaCollection* _tmp130_;
																					ValadocContentParagraph* _tmp131_;
																					ValadocContentParagraph* _tmp132_;
																					_tmp130_ = content;
																					_tmp131_ = valadoc_gtkdoc_parser_parse_gtkdoc_paragraph (self);
																					_tmp132_ = _tmp131_;
																					valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp130_, (ValadocContentBlock*) _tmp132_);
																					_g_object_unref0 (_tmp132_);
																				} else {
																					ValadocGtkdocToken* _tmp133_;
																					_tmp133_ = self->priv->current;
																					if (_tmp133_->type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN) {
																						ValaCollection* _tmp134_;
																						ValadocContentParagraph* _tmp135_;
																						ValadocContentParagraph* _tmp136_;
																						_tmp134_ = content;
																						_tmp135_ = valadoc_gtkdoc_parser_parse_gtkdoc_source (self);
																						_tmp136_ = _tmp135_;
																						valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp134_, (ValadocContentBlock*) _tmp136_);
																						_g_object_unref0 (_tmp136_);
																					} else {
																						break;
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = content;
	return result;
}

static ValadocContentRun*
valadoc_gtkdoc_parser_parse_xml_tag (ValadocGtkdocParser* self)
{
	gchar* _class = NULL;
	ValadocGtkdocToken* _tmp1_;
	ValaHashMap* _tmp2_;
	gpointer _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	ValadocGtkdocToken* _tmp6_;
	ValadocContentRun* run = NULL;
	ValadocContentContentFactory* _tmp8_;
	ValadocContentRun* _tmp9_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	ValadocGtkdocToken* _tmp47_;
	ValadocGtkdocToken* _tmp48_;
	ValadocContentRun* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "tag")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<tag>");
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->current;
	_tmp2_ = _tmp1_->attributes;
	_tmp3_ = vala_map_get ((ValaMap*) _tmp2_, "class");
	_class = (gchar*) _tmp3_;
	_tmp4_ = valadoc_gtkdoc_parser_next (self);
	_tmp5_ = _tmp4_;
	_valadoc_gtkdoc_token_unref0 (_tmp5_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
	_tmp6_ = self->priv->current;
	if (_tmp6_->type != VALADOC_GTKDOC_TOKEN_TYPE_WORD) {
		ValadocGtkdocToken* _tmp7_;
		_tmp7_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp7_, "<WORD>");
		result = NULL;
		_g_free0 (_class);
		return result;
	}
	_tmp8_ = self->priv->factory;
	_tmp9_ = valadoc_content_content_factory_create_run (_tmp8_, VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
	run = _tmp9_;
	_tmp11_ = _class;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = _class;
		_tmp10_ = g_strcmp0 (_tmp12_, "starttag") == 0;
	}
	if (_tmp10_) {
		ValadocContentRun* _tmp13_;
		ValaList* _tmp14_;
		ValaList* _tmp15_;
		ValadocContentContentFactory* _tmp16_;
		ValadocGtkdocToken* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		ValadocContentText* _tmp23_;
		ValadocContentText* _tmp24_;
		ValadocGtkdocToken* _tmp25_;
		ValadocGtkdocToken* _tmp26_;
		_tmp13_ = run;
		_tmp14_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = self->priv->factory;
		_tmp17_ = self->priv->current;
		_tmp18_ = _tmp17_->content;
		_tmp19_ = g_strconcat ("<", _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp20_, ">", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = valadoc_content_content_factory_create_text (_tmp16_, _tmp22_);
		_tmp24_ = _tmp23_;
		vala_collection_add ((ValaCollection*) _tmp15_, (ValadocContentInline*) _tmp24_);
		_g_object_unref0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_tmp25_ = valadoc_gtkdoc_parser_next (self);
		_tmp26_ = _tmp25_;
		_valadoc_gtkdoc_token_unref0 (_tmp26_);
	} else {
		const gchar* _tmp27_;
		_tmp27_ = _class;
		if (g_strcmp0 (_tmp27_, "endtag") == 0) {
			ValadocContentRun* _tmp28_;
			ValaList* _tmp29_;
			ValaList* _tmp30_;
			ValadocContentContentFactory* _tmp31_;
			ValadocGtkdocToken* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			ValadocContentText* _tmp38_;
			ValadocContentText* _tmp39_;
			ValadocGtkdocToken* _tmp40_;
			ValadocGtkdocToken* _tmp41_;
			_tmp28_ = run;
			_tmp29_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = self->priv->factory;
			_tmp32_ = self->priv->current;
			_tmp33_ = _tmp32_->content;
			_tmp34_ = g_strconcat ("</", _tmp33_, NULL);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strconcat (_tmp35_, ">", NULL);
			_tmp37_ = _tmp36_;
			_tmp38_ = valadoc_content_content_factory_create_text (_tmp31_, _tmp37_);
			_tmp39_ = _tmp38_;
			vala_collection_add ((ValaCollection*) _tmp30_, (ValadocContentInline*) _tmp39_);
			_g_object_unref0 (_tmp39_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp35_);
			_tmp40_ = valadoc_gtkdoc_parser_next (self);
			_tmp41_ = _tmp40_;
			_valadoc_gtkdoc_token_unref0 (_tmp41_);
		} else {
			ValadocGtkdocToken* _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			_tmp42_ = self->priv->current;
			_tmp43_ = _class;
			_tmp44_ = g_strdup_printf ("<tag class=\"%s\">", _tmp43_);
			_tmp45_ = _tmp44_;
			valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp42_, _tmp45_);
			_g_free0 (_tmp45_);
			result = run;
			_g_free0 (_class);
			return result;
		}
	}
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "tag")) {
		ValadocGtkdocToken* _tmp46_;
		_tmp46_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp46_, "</tag>");
		result = run;
		_g_free0 (_class);
		return result;
	}
	_tmp47_ = valadoc_gtkdoc_parser_next (self);
	_tmp48_ = _tmp47_;
	_valadoc_gtkdoc_token_unref0 (_tmp48_);
	result = run;
	_g_free0 (_class);
	return result;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static void
valadoc_gtkdoc_parser_append_inline_content_string (ValadocGtkdocParser* self,
                                                    ValadocContentRun* run,
                                                    const gchar* current)
{
	ValadocContentText* last_as_text = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValadocContentText* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (run != NULL);
	g_return_if_fail (current != NULL);
	last_as_text = NULL;
	_tmp0_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) run);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gpointer _tmp6_;
		ValadocContentInline* _tmp7_;
		ValadocContentText* _tmp8_;
		_tmp4_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) run);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_list_last (_tmp5_);
		_tmp7_ = (ValadocContentInline*) _tmp6_;
		_tmp8_ = VALADOC_CONTENT_IS_TEXT (_tmp7_) ? ((ValadocContentText*) _tmp7_) : NULL;
		if (_tmp8_ == NULL) {
			_g_object_unref0 (_tmp7_);
		}
		_g_object_unref0 (last_as_text);
		last_as_text = _tmp8_;
	}
	_tmp9_ = last_as_text;
	if (_tmp9_ == NULL) {
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		ValadocContentContentFactory* _tmp12_;
		ValadocContentText* _tmp13_;
		ValadocContentText* _tmp14_;
		_tmp10_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) run);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->priv->factory;
		_tmp13_ = valadoc_content_content_factory_create_text (_tmp12_, current);
		_tmp14_ = _tmp13_;
		vala_collection_add ((ValaCollection*) _tmp11_, (ValadocContentInline*) _tmp14_);
		_g_object_unref0 (_tmp14_);
	} else {
		gboolean _tmp15_ = FALSE;
		if (g_str_has_prefix (current, " ")) {
			ValadocContentText* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp16_ = last_as_text;
			_tmp17_ = valadoc_content_text_get_content (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp15_ = g_str_has_suffix (_tmp18_, " ");
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			ValadocContentText* _tmp19_;
			ValadocContentText* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp19_ = last_as_text;
			_tmp20_ = last_as_text;
			_tmp21_ = valadoc_content_text_get_content (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = string_chug (current);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat (_tmp22_, _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			valadoc_content_text_set_content (_tmp20_, _tmp26_);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp24_);
		} else {
			ValadocContentText* _tmp27_;
			ValadocContentText* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp27_ = last_as_text;
			_tmp28_ = last_as_text;
			_tmp29_ = valadoc_content_text_get_content (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strconcat (_tmp30_, current, NULL);
			_tmp32_ = _tmp31_;
			valadoc_content_text_set_content (_tmp28_, _tmp32_);
			_g_free0 (_tmp32_);
		}
	}
	_g_object_unref0 (last_as_text);
}

static ValadocContentInline*
valadoc_gtkdoc_parser_create_type_link (ValadocGtkdocParser* self,
                                        const gchar* name,
                                        gboolean c_accept_plural)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ValadocContentInline* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (g_strcmp0 (name, "TRUE") == 0) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (name, "FALSE") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (name, "NULL") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = valadoc_gtkdoc_parser_is_numeric (self, name);
	}
	if (_tmp0_) {
		ValadocContentRun* monospaced = NULL;
		ValadocContentContentFactory* _tmp3_;
		ValadocContentRun* _tmp4_;
		ValadocContentRun* _tmp5_;
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		ValadocContentContentFactory* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		ValadocContentText* _tmp11_;
		ValadocContentText* _tmp12_;
		_tmp3_ = self->priv->factory;
		_tmp4_ = valadoc_content_content_factory_create_run (_tmp3_, VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
		monospaced = _tmp4_;
		_tmp5_ = monospaced;
		_tmp6_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->factory;
		_tmp9_ = g_ascii_strdown (name, (gssize) -1);
		_tmp10_ = _tmp9_;
		_tmp11_ = valadoc_content_content_factory_create_text (_tmp8_, _tmp10_);
		_tmp12_ = _tmp11_;
		vala_collection_add ((ValaCollection*) _tmp7_, (ValadocContentInline*) _tmp12_);
		_g_object_unref0 (_tmp12_);
		_g_free0 (_tmp10_);
		result = (ValadocContentInline*) monospaced;
		return result;
	} else {
		ValadocTagletsLink* taglet = NULL;
		ValadocContentContentFactory* _tmp13_;
		ValadocContentTaglet* _tmp14_;
		ValadocTagletsLink* _tmp15_;
		ValadocTagletsLink* _tmp16_;
		ValadocTagletsLink* _tmp17_;
		ValadocTagletsLink* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp13_ = self->priv->factory;
		_tmp14_ = valadoc_content_content_factory_create_taglet (_tmp13_, "link");
		_tmp15_ = VALADOC_TAGLETS_IS_LINK (_tmp14_) ? ((ValadocTagletsLink*) _tmp14_) : NULL;
		if (_tmp15_ == NULL) {
			_g_object_unref0 (_tmp14_);
		}
		taglet = _tmp15_;
		_tmp16_ = taglet;
		_vala_assert (_tmp16_ != NULL, "taglet != null");
		_tmp17_ = taglet;
		valadoc_taglets_link_set_c_accept_plural (_tmp17_, c_accept_plural);
		_tmp18_ = taglet;
		_tmp19_ = g_strconcat ("c::", name, NULL);
		_tmp20_ = _tmp19_;
		valadoc_taglets_link_set_symbol_name (_tmp18_, _tmp20_);
		_g_free0 (_tmp20_);
		result = (ValadocContentInline*) taglet;
		return result;
	}
}

static inline void
valadoc_gtkdoc_parser_append_inline_content_not_null (ValadocGtkdocParser* self,
                                                      ValadocContentRun* run,
                                                      ValadocContentInline* element)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (run != NULL);
	g_return_if_fail (element != NULL);
	if (element != NULL) {
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		_tmp0_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) run);
		_tmp1_ = _tmp0_;
		vala_collection_add ((ValaCollection*) _tmp1_, element);
	}
}

static ValadocContentRun*
valadoc_gtkdoc_parser_parse_inline_content (ValadocGtkdocParser* self)
{
	ValadocContentRun* run = NULL;
	ValadocContentContentFactory* _tmp0_;
	ValadocContentRun* _tmp1_;
	ValadocContentRun* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->factory;
	_tmp1_ = valadoc_content_content_factory_create_run (_tmp0_, VALADOC_CONTENT_RUN_STYLE_NONE);
	run = _tmp1_;
	while (TRUE) {
		ValadocGtkdocToken* _tmp2_;
		gboolean _tmp3_ = FALSE;
		ValadocGtkdocToken* _tmp4_;
		_tmp2_ = self->priv->current;
		if (!(_tmp2_->type != VALADOC_GTKDOC_TOKEN_TYPE_EOF)) {
			break;
		}
		_tmp4_ = self->priv->current;
		if (_tmp4_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_->content;
			_tmp3_ = g_strcmp0 (_tmp6_, "firstterm") == 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			ValadocContentRun* _tmp7_;
			ValadocContentRun* _tmp8_;
			ValadocContentRun* _tmp9_;
			_tmp7_ = run;
			_tmp8_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "firstterm", VALADOC_CONTENT_RUN_STYLE_ITALIC);
			_tmp9_ = _tmp8_;
			valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp7_, (ValadocContentInline*) _tmp9_);
			_g_object_unref0 (_tmp9_);
		} else {
			gboolean _tmp10_ = FALSE;
			ValadocGtkdocToken* _tmp11_;
			_tmp11_ = self->priv->current;
			if (_tmp11_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
				ValadocGtkdocToken* _tmp12_;
				const gchar* _tmp13_;
				_tmp12_ = self->priv->current;
				_tmp13_ = _tmp12_->content;
				_tmp10_ = g_strcmp0 (_tmp13_, "abbrev") == 0;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				ValadocContentRun* _tmp14_;
				ValadocContentRun* _tmp15_;
				ValadocContentRun* _tmp16_;
				_tmp14_ = run;
				_tmp15_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "abbrev", VALADOC_CONTENT_RUN_STYLE_ITALIC);
				_tmp16_ = _tmp15_;
				valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp14_, (ValadocContentInline*) _tmp16_);
				_g_object_unref0 (_tmp16_);
			} else {
				gboolean _tmp17_ = FALSE;
				ValadocGtkdocToken* _tmp18_;
				_tmp18_ = self->priv->current;
				if (_tmp18_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
					ValadocGtkdocToken* _tmp19_;
					const gchar* _tmp20_;
					_tmp19_ = self->priv->current;
					_tmp20_ = _tmp19_->content;
					_tmp17_ = g_strcmp0 (_tmp20_, "term") == 0;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					ValadocContentRun* _tmp21_;
					ValadocContentRun* _tmp22_;
					ValadocContentRun* _tmp23_;
					_tmp21_ = run;
					_tmp22_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "term", VALADOC_CONTENT_RUN_STYLE_ITALIC);
					_tmp23_ = _tmp22_;
					valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp21_, (ValadocContentInline*) _tmp23_);
					_g_object_unref0 (_tmp23_);
				} else {
					gboolean _tmp24_ = FALSE;
					ValadocGtkdocToken* _tmp25_;
					_tmp25_ = self->priv->current;
					if (_tmp25_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
						ValadocGtkdocToken* _tmp26_;
						const gchar* _tmp27_;
						_tmp26_ = self->priv->current;
						_tmp27_ = _tmp26_->content;
						_tmp24_ = g_strcmp0 (_tmp27_, "literal") == 0;
					} else {
						_tmp24_ = FALSE;
					}
					if (_tmp24_) {
						ValadocContentRun* _tmp28_;
						ValadocContentRun* _tmp29_;
						ValadocContentRun* _tmp30_;
						_tmp28_ = run;
						_tmp29_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "literal", VALADOC_CONTENT_RUN_STYLE_ITALIC);
						_tmp30_ = _tmp29_;
						valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp28_, (ValadocContentInline*) _tmp30_);
						_g_object_unref0 (_tmp30_);
					} else {
						gboolean _tmp31_ = FALSE;
						ValadocGtkdocToken* _tmp32_;
						_tmp32_ = self->priv->current;
						if (_tmp32_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
							ValadocGtkdocToken* _tmp33_;
							const gchar* _tmp34_;
							_tmp33_ = self->priv->current;
							_tmp34_ = _tmp33_->content;
							_tmp31_ = g_strcmp0 (_tmp34_, "literallayout") == 0;
						} else {
							_tmp31_ = FALSE;
						}
						if (_tmp31_) {
							ValadocContentRun* _tmp35_;
							ValadocContentRun* _tmp36_;
							ValadocContentRun* _tmp37_;
							_tmp35_ = run;
							_tmp36_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "literallayout", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
							_tmp37_ = _tmp36_;
							valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp35_, (ValadocContentInline*) _tmp37_);
							_g_object_unref0 (_tmp37_);
						} else {
							gboolean _tmp38_ = FALSE;
							ValadocGtkdocToken* _tmp39_;
							_tmp39_ = self->priv->current;
							if (_tmp39_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
								ValadocGtkdocToken* _tmp40_;
								const gchar* _tmp41_;
								_tmp40_ = self->priv->current;
								_tmp41_ = _tmp40_->content;
								_tmp38_ = g_strcmp0 (_tmp41_, "application") == 0;
							} else {
								_tmp38_ = FALSE;
							}
							if (_tmp38_) {
								ValadocContentRun* _tmp42_;
								ValadocContentRun* _tmp43_;
								ValadocContentRun* _tmp44_;
								_tmp42_ = run;
								_tmp43_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "application", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
								_tmp44_ = _tmp43_;
								valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp42_, (ValadocContentInline*) _tmp44_);
								_g_object_unref0 (_tmp44_);
							} else {
								gboolean _tmp45_ = FALSE;
								ValadocGtkdocToken* _tmp46_;
								_tmp46_ = self->priv->current;
								if (_tmp46_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
									ValadocGtkdocToken* _tmp47_;
									const gchar* _tmp48_;
									_tmp47_ = self->priv->current;
									_tmp48_ = _tmp47_->content;
									_tmp45_ = g_strcmp0 (_tmp48_, "varname") == 0;
								} else {
									_tmp45_ = FALSE;
								}
								if (_tmp45_) {
									ValadocContentRun* _tmp49_;
									ValadocContentRun* _tmp50_;
									ValadocContentRun* _tmp51_;
									_tmp49_ = run;
									_tmp50_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "varname", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
									_tmp51_ = _tmp50_;
									valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp49_, (ValadocContentInline*) _tmp51_);
									_g_object_unref0 (_tmp51_);
								} else {
									gboolean _tmp52_ = FALSE;
									ValadocGtkdocToken* _tmp53_;
									_tmp53_ = self->priv->current;
									if (_tmp53_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
										ValadocGtkdocToken* _tmp54_;
										const gchar* _tmp55_;
										_tmp54_ = self->priv->current;
										_tmp55_ = _tmp54_->content;
										_tmp52_ = g_strcmp0 (_tmp55_, "computeroutput") == 0;
									} else {
										_tmp52_ = FALSE;
									}
									if (_tmp52_) {
										ValadocContentRun* _tmp56_;
										ValadocContentRun* _tmp57_;
										ValadocContentRun* _tmp58_;
										_tmp56_ = run;
										_tmp57_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "computeroutput", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
										_tmp58_ = _tmp57_;
										valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp56_, (ValadocContentInline*) _tmp58_);
										_g_object_unref0 (_tmp58_);
									} else {
										gboolean _tmp59_ = FALSE;
										ValadocGtkdocToken* _tmp60_;
										_tmp60_ = self->priv->current;
										if (_tmp60_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
											ValadocGtkdocToken* _tmp61_;
											const gchar* _tmp62_;
											_tmp61_ = self->priv->current;
											_tmp62_ = _tmp61_->content;
											_tmp59_ = g_strcmp0 (_tmp62_, "emphasis") == 0;
										} else {
											_tmp59_ = FALSE;
										}
										if (_tmp59_) {
											ValadocContentRun* _tmp63_;
											ValadocContentRun* _tmp64_;
											ValadocContentRun* _tmp65_;
											_tmp63_ = run;
											_tmp64_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "emphasis", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
											_tmp65_ = _tmp64_;
											valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp63_, (ValadocContentInline*) _tmp65_);
											_g_object_unref0 (_tmp65_);
										} else {
											gboolean _tmp66_ = FALSE;
											ValadocGtkdocToken* _tmp67_;
											_tmp67_ = self->priv->current;
											if (_tmp67_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
												ValadocGtkdocToken* _tmp68_;
												const gchar* _tmp69_;
												_tmp68_ = self->priv->current;
												_tmp69_ = _tmp68_->content;
												_tmp66_ = g_strcmp0 (_tmp69_, "pre") == 0;
											} else {
												_tmp66_ = FALSE;
											}
											if (_tmp66_) {
												ValadocContentRun* _tmp70_;
												ValadocContentRun* _tmp71_;
												ValadocContentRun* _tmp72_;
												_tmp70_ = run;
												_tmp71_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "pre", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
												_tmp72_ = _tmp71_;
												valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp70_, (ValadocContentInline*) _tmp72_);
												_g_object_unref0 (_tmp72_);
											} else {
												gboolean _tmp73_ = FALSE;
												ValadocGtkdocToken* _tmp74_;
												_tmp74_ = self->priv->current;
												if (_tmp74_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
													ValadocGtkdocToken* _tmp75_;
													const gchar* _tmp76_;
													_tmp75_ = self->priv->current;
													_tmp76_ = _tmp75_->content;
													_tmp73_ = g_strcmp0 (_tmp76_, "code") == 0;
												} else {
													_tmp73_ = FALSE;
												}
												if (_tmp73_) {
													ValadocContentRun* _tmp77_;
													ValadocContentRun* _tmp78_;
													ValadocContentRun* _tmp79_;
													_tmp77_ = run;
													_tmp78_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "code", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
													_tmp79_ = _tmp78_;
													valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp77_, (ValadocContentInline*) _tmp79_);
													_g_object_unref0 (_tmp79_);
												} else {
													gboolean _tmp80_ = FALSE;
													ValadocGtkdocToken* _tmp81_;
													_tmp81_ = self->priv->current;
													if (_tmp81_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
														ValadocGtkdocToken* _tmp82_;
														const gchar* _tmp83_;
														_tmp82_ = self->priv->current;
														_tmp83_ = _tmp82_->content;
														_tmp80_ = g_strcmp0 (_tmp83_, "guimenuitem") == 0;
													} else {
														_tmp80_ = FALSE;
													}
													if (_tmp80_) {
														ValadocContentRun* _tmp84_;
														ValadocContentRun* _tmp85_;
														ValadocContentRun* _tmp86_;
														_tmp84_ = run;
														_tmp85_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "guimenuitem", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
														_tmp86_ = _tmp85_;
														valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp84_, (ValadocContentInline*) _tmp86_);
														_g_object_unref0 (_tmp86_);
													} else {
														gboolean _tmp87_ = FALSE;
														ValadocGtkdocToken* _tmp88_;
														_tmp88_ = self->priv->current;
														if (_tmp88_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
															ValadocGtkdocToken* _tmp89_;
															const gchar* _tmp90_;
															_tmp89_ = self->priv->current;
															_tmp90_ = _tmp89_->content;
															_tmp87_ = g_strcmp0 (_tmp90_, "command") == 0;
														} else {
															_tmp87_ = FALSE;
														}
														if (_tmp87_) {
															ValadocContentRun* _tmp91_;
															ValadocContentRun* _tmp92_;
															ValadocContentRun* _tmp93_;
															_tmp91_ = run;
															_tmp92_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "command", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
															_tmp93_ = _tmp92_;
															valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp91_, (ValadocContentInline*) _tmp93_);
															_g_object_unref0 (_tmp93_);
														} else {
															gboolean _tmp94_ = FALSE;
															ValadocGtkdocToken* _tmp95_;
															_tmp95_ = self->priv->current;
															if (_tmp95_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																ValadocGtkdocToken* _tmp96_;
																const gchar* _tmp97_;
																_tmp96_ = self->priv->current;
																_tmp97_ = _tmp96_->content;
																_tmp94_ = g_strcmp0 (_tmp97_, "option") == 0;
															} else {
																_tmp94_ = FALSE;
															}
															if (_tmp94_) {
																ValadocContentRun* _tmp98_;
																ValadocContentRun* _tmp99_;
																ValadocContentRun* _tmp100_;
																_tmp98_ = run;
																_tmp99_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "option", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																_tmp100_ = _tmp99_;
																valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp98_, (ValadocContentInline*) _tmp100_);
																_g_object_unref0 (_tmp100_);
															} else {
																gboolean _tmp101_ = FALSE;
																ValadocGtkdocToken* _tmp102_;
																_tmp102_ = self->priv->current;
																if (_tmp102_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																	ValadocGtkdocToken* _tmp103_;
																	const gchar* _tmp104_;
																	_tmp103_ = self->priv->current;
																	_tmp104_ = _tmp103_->content;
																	_tmp101_ = g_strcmp0 (_tmp104_, "keycap") == 0;
																} else {
																	_tmp101_ = FALSE;
																}
																if (_tmp101_) {
																	ValadocContentRun* _tmp105_;
																	ValadocContentRun* _tmp106_;
																	ValadocContentRun* _tmp107_;
																	_tmp105_ = run;
																	_tmp106_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "keycap", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																	_tmp107_ = _tmp106_;
																	valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp105_, (ValadocContentInline*) _tmp107_);
																	_g_object_unref0 (_tmp107_);
																} else {
																	gboolean _tmp108_ = FALSE;
																	ValadocGtkdocToken* _tmp109_;
																	_tmp109_ = self->priv->current;
																	if (_tmp109_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																		ValadocGtkdocToken* _tmp110_;
																		const gchar* _tmp111_;
																		_tmp110_ = self->priv->current;
																		_tmp111_ = _tmp110_->content;
																		_tmp108_ = g_strcmp0 (_tmp111_, "keycombo") == 0;
																	} else {
																		_tmp108_ = FALSE;
																	}
																	if (_tmp108_) {
																		ValadocContentRun* _tmp112_;
																		ValadocContentRun* _tmp113_;
																		ValadocContentRun* _tmp114_;
																		_tmp112_ = run;
																		_tmp113_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "keycombo", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																		_tmp114_ = _tmp113_;
																		valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp112_, (ValadocContentInline*) _tmp114_);
																		_g_object_unref0 (_tmp114_);
																	} else {
																		gboolean _tmp115_ = FALSE;
																		ValadocGtkdocToken* _tmp116_;
																		_tmp116_ = self->priv->current;
																		if (_tmp116_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																			ValadocGtkdocToken* _tmp117_;
																			const gchar* _tmp118_;
																			_tmp117_ = self->priv->current;
																			_tmp118_ = _tmp117_->content;
																			_tmp115_ = g_strcmp0 (_tmp118_, "envar") == 0;
																		} else {
																			_tmp115_ = FALSE;
																		}
																		if (_tmp115_) {
																			ValadocContentRun* _tmp119_;
																			ValadocContentRun* _tmp120_;
																			ValadocContentRun* _tmp121_;
																			_tmp119_ = run;
																			_tmp120_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "envar", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																			_tmp121_ = _tmp120_;
																			valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp119_, (ValadocContentInline*) _tmp121_);
																			_g_object_unref0 (_tmp121_);
																		} else {
																			gboolean _tmp122_ = FALSE;
																			ValadocGtkdocToken* _tmp123_;
																			_tmp123_ = self->priv->current;
																			if (_tmp123_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																				ValadocGtkdocToken* _tmp124_;
																				const gchar* _tmp125_;
																				_tmp124_ = self->priv->current;
																				_tmp125_ = _tmp124_->content;
																				_tmp122_ = g_strcmp0 (_tmp125_, "filename") == 0;
																			} else {
																				_tmp122_ = FALSE;
																			}
																			if (_tmp122_) {
																				ValadocContentRun* _tmp126_;
																				ValadocContentRun* _tmp127_;
																				ValadocContentRun* _tmp128_;
																				_tmp126_ = run;
																				_tmp127_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "filename", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																				_tmp128_ = _tmp127_;
																				valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp126_, (ValadocContentInline*) _tmp128_);
																				_g_object_unref0 (_tmp128_);
																			} else {
																				gboolean _tmp129_ = FALSE;
																				ValadocGtkdocToken* _tmp130_;
																				_tmp130_ = self->priv->current;
																				if (_tmp130_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																					ValadocGtkdocToken* _tmp131_;
																					const gchar* _tmp132_;
																					_tmp131_ = self->priv->current;
																					_tmp132_ = _tmp131_->content;
																					_tmp129_ = g_strcmp0 (_tmp132_, "parameter") == 0;
																				} else {
																					_tmp129_ = FALSE;
																				}
																				if (_tmp129_) {
																					ValadocContentRun* _tmp133_;
																					ValadocContentRun* _tmp134_;
																					ValadocContentRun* _tmp135_;
																					_tmp133_ = run;
																					_tmp134_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "parameter", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																					_tmp135_ = _tmp134_;
																					valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp133_, (ValadocContentInline*) _tmp135_);
																					_g_object_unref0 (_tmp135_);
																				} else {
																					gboolean _tmp136_ = FALSE;
																					ValadocGtkdocToken* _tmp137_;
																					_tmp137_ = self->priv->current;
																					if (_tmp137_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																						ValadocGtkdocToken* _tmp138_;
																						const gchar* _tmp139_;
																						_tmp138_ = self->priv->current;
																						_tmp139_ = _tmp138_->content;
																						_tmp136_ = g_strcmp0 (_tmp139_, "replaceable") == 0;
																					} else {
																						_tmp136_ = FALSE;
																					}
																					if (_tmp136_) {
																						ValadocContentRun* _tmp140_;
																						ValadocContentRun* _tmp141_;
																						ValadocContentRun* _tmp142_;
																						_tmp140_ = run;
																						_tmp141_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "replaceable", VALADOC_CONTENT_RUN_STYLE_ITALIC);
																						_tmp142_ = _tmp141_;
																						valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp140_, (ValadocContentInline*) _tmp142_);
																						_g_object_unref0 (_tmp142_);
																					} else {
																						gboolean _tmp143_ = FALSE;
																						ValadocGtkdocToken* _tmp144_;
																						_tmp144_ = self->priv->current;
																						if (_tmp144_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																							ValadocGtkdocToken* _tmp145_;
																							const gchar* _tmp146_;
																							_tmp145_ = self->priv->current;
																							_tmp146_ = _tmp145_->content;
																							_tmp143_ = g_strcmp0 (_tmp146_, "quote") == 0;
																						} else {
																							_tmp143_ = FALSE;
																						}
																						if (_tmp143_) {
																							ValadocContentRun* _tmp147_;
																							ValaList* _tmp148_;
																							ValaList* _tmp149_;
																							ValadocContentContentFactory* _tmp150_;
																							ValadocContentText* _tmp151_;
																							ValadocContentText* _tmp152_;
																							ValadocContentRun* _tmp153_;
																							ValadocContentRun* _tmp154_;
																							ValadocContentRun* _tmp155_;
																							ValadocContentRun* _tmp156_;
																							ValaList* _tmp157_;
																							ValaList* _tmp158_;
																							ValadocContentContentFactory* _tmp159_;
																							ValadocContentText* _tmp160_;
																							ValadocContentText* _tmp161_;
																							_tmp147_ = run;
																							_tmp148_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp147_);
																							_tmp149_ = _tmp148_;
																							_tmp150_ = self->priv->factory;
																							_tmp151_ = valadoc_content_content_factory_create_text (_tmp150_, "“");
																							_tmp152_ = _tmp151_;
																							vala_collection_add ((ValaCollection*) _tmp149_, (ValadocContentInline*) _tmp152_);
																							_g_object_unref0 (_tmp152_);
																							_tmp153_ = run;
																							_tmp154_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "quote", VALADOC_CONTENT_RUN_STYLE_NONE);
																							_tmp155_ = _tmp154_;
																							valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp153_, (ValadocContentInline*) _tmp155_);
																							_g_object_unref0 (_tmp155_);
																							_tmp156_ = run;
																							_tmp157_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp156_);
																							_tmp158_ = _tmp157_;
																							_tmp159_ = self->priv->factory;
																							_tmp160_ = valadoc_content_content_factory_create_text (_tmp159_, "”");
																							_tmp161_ = _tmp160_;
																							vala_collection_add ((ValaCollection*) _tmp158_, (ValadocContentInline*) _tmp161_);
																							_g_object_unref0 (_tmp161_);
																						} else {
																							gboolean _tmp162_ = FALSE;
																							ValadocGtkdocToken* _tmp163_;
																							_tmp163_ = self->priv->current;
																							if (_tmp163_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																								ValadocGtkdocToken* _tmp164_;
																								const gchar* _tmp165_;
																								_tmp164_ = self->priv->current;
																								_tmp165_ = _tmp164_->content;
																								_tmp162_ = g_strcmp0 (_tmp165_, "footnote") == 0;
																							} else {
																								_tmp162_ = FALSE;
																							}
																							if (_tmp162_) {
																								ValadocContentRun* _tmp166_;
																								ValadocContentRun* _tmp167_;
																								ValadocContentRun* _tmp168_;
																								_tmp166_ = run;
																								_tmp167_ = valadoc_gtkdoc_parser_parse_docbook_footnote (self);
																								_tmp168_ = _tmp167_;
																								valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp166_, (ValadocContentInline*) _tmp168_);
																								_g_object_unref0 (_tmp168_);
																							} else {
																								gboolean _tmp169_ = FALSE;
																								ValadocGtkdocToken* _tmp170_;
																								_tmp170_ = self->priv->current;
																								if (_tmp170_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																									ValadocGtkdocToken* _tmp171_;
																									const gchar* _tmp172_;
																									_tmp171_ = self->priv->current;
																									_tmp172_ = _tmp171_->content;
																									_tmp169_ = g_strcmp0 (_tmp172_, "type") == 0;
																								} else {
																									_tmp169_ = FALSE;
																								}
																								if (_tmp169_) {
																									ValadocContentRun* _tmp173_;
																									ValadocContentInlineTaglet* _tmp174_;
																									ValadocContentInlineTaglet* _tmp175_;
																									_tmp173_ = run;
																									_tmp174_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "type");
																									_tmp175_ = _tmp174_;
																									valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp173_, (ValadocContentInline*) _tmp175_);
																									_g_object_unref0 (_tmp175_);
																								} else {
																									gboolean _tmp176_ = FALSE;
																									ValadocGtkdocToken* _tmp177_;
																									_tmp177_ = self->priv->current;
																									if (_tmp177_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																										ValadocGtkdocToken* _tmp178_;
																										const gchar* _tmp179_;
																										_tmp178_ = self->priv->current;
																										_tmp179_ = _tmp178_->content;
																										_tmp176_ = g_strcmp0 (_tmp179_, "function") == 0;
																									} else {
																										_tmp176_ = FALSE;
																									}
																									if (_tmp176_) {
																										ValadocContentRun* _tmp180_;
																										ValadocContentInlineTaglet* _tmp181_;
																										ValadocContentInlineTaglet* _tmp182_;
																										_tmp180_ = run;
																										_tmp181_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "function");
																										_tmp182_ = _tmp181_;
																										valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp180_, (ValadocContentInline*) _tmp182_);
																										_g_object_unref0 (_tmp182_);
																									} else {
																										gboolean _tmp183_ = FALSE;
																										ValadocGtkdocToken* _tmp184_;
																										_tmp184_ = self->priv->current;
																										if (_tmp184_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																											ValadocGtkdocToken* _tmp185_;
																											const gchar* _tmp186_;
																											_tmp185_ = self->priv->current;
																											_tmp186_ = _tmp185_->content;
																											_tmp183_ = g_strcmp0 (_tmp186_, "classname") == 0;
																										} else {
																											_tmp183_ = FALSE;
																										}
																										if (_tmp183_) {
																											ValadocContentRun* _tmp187_;
																											ValadocContentInlineTaglet* _tmp188_;
																											ValadocContentInlineTaglet* _tmp189_;
																											_tmp187_ = run;
																											_tmp188_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "classname");
																											_tmp189_ = _tmp188_;
																											valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp187_, (ValadocContentInline*) _tmp189_);
																											_g_object_unref0 (_tmp189_);
																										} else {
																											gboolean _tmp190_ = FALSE;
																											ValadocGtkdocToken* _tmp191_;
																											_tmp191_ = self->priv->current;
																											if (_tmp191_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																												ValadocGtkdocToken* _tmp192_;
																												const gchar* _tmp193_;
																												_tmp192_ = self->priv->current;
																												_tmp193_ = _tmp192_->content;
																												_tmp190_ = g_strcmp0 (_tmp193_, "structname") == 0;
																											} else {
																												_tmp190_ = FALSE;
																											}
																											if (_tmp190_) {
																												ValadocContentRun* _tmp194_;
																												ValadocContentInlineTaglet* _tmp195_;
																												ValadocContentInlineTaglet* _tmp196_;
																												_tmp194_ = run;
																												_tmp195_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "structname");
																												_tmp196_ = _tmp195_;
																												valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp194_, (ValadocContentInline*) _tmp196_);
																												_g_object_unref0 (_tmp196_);
																											} else {
																												gboolean _tmp197_ = FALSE;
																												ValadocGtkdocToken* _tmp198_;
																												_tmp198_ = self->priv->current;
																												if (_tmp198_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																													ValadocGtkdocToken* _tmp199_;
																													const gchar* _tmp200_;
																													_tmp199_ = self->priv->current;
																													_tmp200_ = _tmp199_->content;
																													_tmp197_ = g_strcmp0 (_tmp200_, "structfield") == 0;
																												} else {
																													_tmp197_ = FALSE;
																												}
																												if (_tmp197_) {
																													ValadocContentRun* _tmp201_;
																													ValadocContentInlineTaglet* _tmp202_;
																													ValadocContentInlineTaglet* _tmp203_;
																													_tmp201_ = run;
																													_tmp202_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "structfield");
																													_tmp203_ = _tmp202_;
																													valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp201_, (ValadocContentInline*) _tmp203_);
																													_g_object_unref0 (_tmp203_);
																												} else {
																													gboolean _tmp204_ = FALSE;
																													ValadocGtkdocToken* _tmp205_;
																													_tmp205_ = self->priv->current;
																													if (_tmp205_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																														ValadocGtkdocToken* _tmp206_;
																														const gchar* _tmp207_;
																														_tmp206_ = self->priv->current;
																														_tmp207_ = _tmp206_->content;
																														_tmp204_ = g_strcmp0 (_tmp207_, "errorcode") == 0;
																													} else {
																														_tmp204_ = FALSE;
																													}
																													if (_tmp204_) {
																														ValadocContentRun* _tmp208_;
																														ValadocContentInlineTaglet* _tmp209_;
																														ValadocContentInlineTaglet* _tmp210_;
																														_tmp208_ = run;
																														_tmp209_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "errorcode");
																														_tmp210_ = _tmp209_;
																														valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp208_, (ValadocContentInline*) _tmp210_);
																														_g_object_unref0 (_tmp210_);
																													} else {
																														gboolean _tmp211_ = FALSE;
																														ValadocGtkdocToken* _tmp212_;
																														_tmp212_ = self->priv->current;
																														if (_tmp212_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																															ValadocGtkdocToken* _tmp213_;
																															const gchar* _tmp214_;
																															_tmp213_ = self->priv->current;
																															_tmp214_ = _tmp213_->content;
																															_tmp211_ = g_strcmp0 (_tmp214_, "constant") == 0;
																														} else {
																															_tmp211_ = FALSE;
																														}
																														if (_tmp211_) {
																															ValadocContentRun* _tmp215_;
																															ValadocContentInlineTaglet* _tmp216_;
																															ValadocContentInlineTaglet* _tmp217_;
																															_tmp215_ = run;
																															_tmp216_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "constant");
																															_tmp217_ = _tmp216_;
																															valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp215_, (ValadocContentInline*) _tmp217_);
																															_g_object_unref0 (_tmp217_);
																														} else {
																															gboolean _tmp218_ = FALSE;
																															ValadocGtkdocToken* _tmp219_;
																															_tmp219_ = self->priv->current;
																															if (_tmp219_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																ValadocGtkdocToken* _tmp220_;
																																const gchar* _tmp221_;
																																_tmp220_ = self->priv->current;
																																_tmp221_ = _tmp220_->content;
																																_tmp218_ = g_strcmp0 (_tmp221_, "inlinegraphic") == 0;
																															} else {
																																_tmp218_ = FALSE;
																															}
																															if (_tmp218_) {
																																ValadocContentRun* _tmp222_;
																																ValadocContentEmbedded* _tmp223_;
																																ValadocContentEmbedded* _tmp224_;
																																_tmp222_ = run;
																																_tmp223_ = valadoc_gtkdoc_parser_parse_docbook_inlinegraphic (self, "inlinegraphic");
																																_tmp224_ = _tmp223_;
																																valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp222_, (ValadocContentInline*) _tmp224_);
																																_g_object_unref0 (_tmp224_);
																															} else {
																																gboolean _tmp225_ = FALSE;
																																ValadocGtkdocToken* _tmp226_;
																																_tmp226_ = self->priv->current;
																																if (_tmp226_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																	ValadocGtkdocToken* _tmp227_;
																																	const gchar* _tmp228_;
																																	_tmp227_ = self->priv->current;
																																	_tmp228_ = _tmp227_->content;
																																	_tmp225_ = g_strcmp0 (_tmp228_, "anchor") == 0;
																																} else {
																																	_tmp225_ = FALSE;
																																}
																																if (_tmp225_) {
																																	valadoc_gtkdoc_parser_parse_anchor (self);
																																} else {
																																	gboolean _tmp229_ = FALSE;
																																	ValadocGtkdocToken* _tmp230_;
																																	_tmp230_ = self->priv->current;
																																	if (_tmp230_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																		ValadocGtkdocToken* _tmp231_;
																																		const gchar* _tmp232_;
																																		_tmp231_ = self->priv->current;
																																		_tmp232_ = _tmp231_->content;
																																		_tmp229_ = g_strcmp0 (_tmp232_, "link") == 0;
																																	} else {
																																		_tmp229_ = FALSE;
																																	}
																																	if (_tmp229_) {
																																		ValadocContentRun* _tmp233_;
																																		ValadocContentInline* _tmp234_;
																																		ValadocContentInline* _tmp235_;
																																		_tmp233_ = run;
																																		_tmp234_ = valadoc_gtkdoc_parser_parse_docbook_link_tempalte (self, "link", TRUE);
																																		_tmp235_ = _tmp234_;
																																		valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp233_, _tmp235_);
																																		_g_object_unref0 (_tmp235_);
																																	} else {
																																		gboolean _tmp236_ = FALSE;
																																		ValadocGtkdocToken* _tmp237_;
																																		_tmp237_ = self->priv->current;
																																		if (_tmp237_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																			ValadocGtkdocToken* _tmp238_;
																																			const gchar* _tmp239_;
																																			_tmp238_ = self->priv->current;
																																			_tmp239_ = _tmp238_->content;
																																			_tmp236_ = g_strcmp0 (_tmp239_, "ulink") == 0;
																																		} else {
																																			_tmp236_ = FALSE;
																																		}
																																		if (_tmp236_) {
																																			ValadocContentRun* _tmp240_;
																																			ValadocContentInline* _tmp241_;
																																			ValadocContentInline* _tmp242_;
																																			_tmp240_ = run;
																																			_tmp241_ = valadoc_gtkdoc_parser_parse_docbook_link_tempalte (self, "ulink", FALSE);
																																			_tmp242_ = _tmp241_;
																																			valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp240_, _tmp242_);
																																			_g_object_unref0 (_tmp242_);
																																		} else {
																																			gboolean _tmp243_ = FALSE;
																																			ValadocGtkdocToken* _tmp244_;
																																			_tmp244_ = self->priv->current;
																																			if (_tmp244_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																				ValadocGtkdocToken* _tmp245_;
																																				const gchar* _tmp246_;
																																				_tmp245_ = self->priv->current;
																																				_tmp246_ = _tmp245_->content;
																																				_tmp243_ = g_strcmp0 (_tmp246_, "xref") == 0;
																																			} else {
																																				_tmp243_ = FALSE;
																																			}
																																			if (_tmp243_) {
																																				ValadocContentRun* _tmp247_;
																																				ValadocContentLink* _tmp248_;
																																				ValadocContentLink* _tmp249_;
																																				_tmp247_ = run;
																																				_tmp248_ = valadoc_gtkdoc_parser_parse_xref (self);
																																				_tmp249_ = _tmp248_;
																																				valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp247_, (ValadocContentInline*) _tmp249_);
																																				_g_object_unref0 (_tmp249_);
																																			} else {
																																				gboolean _tmp250_ = FALSE;
																																				ValadocGtkdocToken* _tmp251_;
																																				_tmp251_ = self->priv->current;
																																				if (_tmp251_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																					ValadocGtkdocToken* _tmp252_;
																																					const gchar* _tmp253_;
																																					_tmp252_ = self->priv->current;
																																					_tmp253_ = _tmp252_->content;
																																					_tmp250_ = g_strcmp0 (_tmp253_, "tag") == 0;
																																				} else {
																																					_tmp250_ = FALSE;
																																				}
																																				if (_tmp250_) {
																																					ValadocContentRun* _tmp254_;
																																					ValadocContentRun* _tmp255_;
																																					ValadocContentRun* _tmp256_;
																																					_tmp254_ = run;
																																					_tmp255_ = valadoc_gtkdoc_parser_parse_xml_tag (self);
																																					_tmp256_ = _tmp255_;
																																					valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp254_, (ValadocContentInline*) _tmp256_);
																																					_g_object_unref0 (_tmp256_);
																																				} else {
																																					ValadocGtkdocToken* _tmp257_;
																																					_tmp257_ = self->priv->current;
																																					if (_tmp257_->type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION) {
																																						ValadocContentRun* _tmp258_;
																																						ValaList* _tmp259_;
																																						ValaList* _tmp260_;
																																						ValadocGtkdocToken* _tmp261_;
																																						const gchar* _tmp262_;
																																						ValadocContentInline* _tmp263_;
																																						ValadocContentInline* _tmp264_;
																																						ValadocGtkdocToken* _tmp265_;
																																						ValadocGtkdocToken* _tmp266_;
																																						_tmp258_ = run;
																																						_tmp259_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp258_);
																																						_tmp260_ = _tmp259_;
																																						_tmp261_ = self->priv->current;
																																						_tmp262_ = _tmp261_->content;
																																						_tmp263_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp262_, FALSE);
																																						_tmp264_ = _tmp263_;
																																						vala_collection_add ((ValaCollection*) _tmp260_, _tmp264_);
																																						_g_object_unref0 (_tmp264_);
																																						_tmp265_ = valadoc_gtkdoc_parser_next (self);
																																						_tmp266_ = _tmp265_;
																																						_valadoc_gtkdoc_token_unref0 (_tmp266_);
																																					} else {
																																						ValadocGtkdocToken* _tmp267_;
																																						_tmp267_ = self->priv->current;
																																						if (_tmp267_->type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM) {
																																							ValadocGtkdocToken* _tmp268_;
																																							const gchar* _tmp269_;
																																							const gchar* _tmp270_;
																																							ValadocGtkdocToken* _tmp348_;
																																							ValadocGtkdocToken* _tmp349_;
																																							_tmp268_ = self->priv->current;
																																							_tmp269_ = _tmp268_->content;
																																							_tmp270_ = self->priv->instance_param_name;
																																							if (g_strcmp0 (_tmp269_, _tmp270_) == 0) {
																																								ValadocContentRun* keyword_run = NULL;
																																								ValadocContentContentFactory* _tmp271_;
																																								ValadocContentRun* _tmp272_;
																																								ValadocContentText* text = NULL;
																																								ValadocContentContentFactory* _tmp273_;
																																								ValadocContentText* _tmp274_;
																																								ValadocContentRun* _tmp275_;
																																								ValaList* _tmp276_;
																																								ValaList* _tmp277_;
																																								ValadocContentText* _tmp278_;
																																								ValadocContentRun* _tmp279_;
																																								ValaList* _tmp280_;
																																								ValaList* _tmp281_;
																																								ValadocContentRun* _tmp282_;
																																								_tmp271_ = self->priv->factory;
																																								_tmp272_ = valadoc_content_content_factory_create_run (_tmp271_, VALADOC_CONTENT_RUN_STYLE_LANG_KEYWORD);
																																								keyword_run = _tmp272_;
																																								_tmp273_ = self->priv->factory;
																																								_tmp274_ = valadoc_content_content_factory_create_text (_tmp273_, "this");
																																								text = _tmp274_;
																																								_tmp275_ = keyword_run;
																																								_tmp276_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp275_);
																																								_tmp277_ = _tmp276_;
																																								_tmp278_ = text;
																																								vala_collection_add ((ValaCollection*) _tmp277_, (ValadocContentInline*) _tmp278_);
																																								_tmp279_ = run;
																																								_tmp280_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp279_);
																																								_tmp281_ = _tmp280_;
																																								_tmp282_ = keyword_run;
																																								vala_collection_add ((ValaCollection*) _tmp281_, (ValadocContentInline*) _tmp282_);
																																								_g_object_unref0 (text);
																																								_g_object_unref0 (keyword_run);
																																							} else {
																																								gchar* param_array_name = NULL;
																																								gboolean is_return_type_len = FALSE;
																																								gchar* param_name = NULL;
																																								gchar* cname = NULL;
																																								ValadocApiTree* _tmp283_;
																																								ValadocApiNode* _tmp284_;
																																								ValadocGtkdocToken* _tmp285_;
																																								const gchar* _tmp286_;
																																								gchar* _tmp287_ = NULL;
																																								gchar* _tmp288_ = NULL;
																																								gboolean _tmp289_ = FALSE;
																																								gchar* _tmp290_;
																																								ValadocContentRun* current_run = NULL;
																																								ValadocContentContentFactory* _tmp291_;
																																								ValadocContentRun* _tmp292_;
																																								ValadocContentRun* _tmp293_;
																																								ValaList* _tmp294_;
																																								ValaList* _tmp295_;
																																								ValadocContentRun* _tmp296_;
																																								const gchar* _tmp332_;
																																								_tmp283_ = self->priv->tree;
																																								_tmp284_ = self->priv->element;
																																								_tmp285_ = self->priv->current;
																																								_tmp286_ = _tmp285_->content;
																																								_tmp290_ = valadoc_importer_helper_resolve_parameter_ctype (_tmp283_, _tmp284_, _tmp286_, &_tmp287_, &_tmp288_, &_tmp289_);
																																								_g_free0 (param_name);
																																								param_name = _tmp287_;
																																								_g_free0 (param_array_name);
																																								param_array_name = _tmp288_;
																																								is_return_type_len = _tmp289_;
																																								cname = _tmp290_;
																																								_tmp291_ = self->priv->factory;
																																								_tmp292_ = valadoc_content_content_factory_create_run (_tmp291_, VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																																								current_run = _tmp292_;
																																								_tmp293_ = run;
																																								_tmp294_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp293_);
																																								_tmp295_ = _tmp294_;
																																								_tmp296_ = current_run;
																																								vala_collection_add ((ValaCollection*) _tmp295_, (ValadocContentInline*) _tmp296_);
																																								if (is_return_type_len) {
																																									ValadocContentRun* keyword_run = NULL;
																																									ValadocContentContentFactory* _tmp297_;
																																									ValadocContentRun* _tmp298_;
																																									ValadocContentRun* _tmp299_;
																																									ValaList* _tmp300_;
																																									ValaList* _tmp301_;
																																									ValadocContentContentFactory* _tmp302_;
																																									ValadocContentText* _tmp303_;
																																									ValadocContentText* _tmp304_;
																																									ValadocContentRun* _tmp305_;
																																									ValaList* _tmp306_;
																																									ValaList* _tmp307_;
																																									ValadocContentRun* _tmp308_;
																																									ValadocContentRun* _tmp309_;
																																									ValaList* _tmp310_;
																																									ValaList* _tmp311_;
																																									ValadocContentContentFactory* _tmp312_;
																																									ValadocContentText* _tmp313_;
																																									ValadocContentText* _tmp314_;
																																									_tmp297_ = self->priv->factory;
																																									_tmp298_ = valadoc_content_content_factory_create_run (_tmp297_, VALADOC_CONTENT_RUN_STYLE_LANG_KEYWORD);
																																									keyword_run = _tmp298_;
																																									_tmp299_ = keyword_run;
																																									_tmp300_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp299_);
																																									_tmp301_ = _tmp300_;
																																									_tmp302_ = self->priv->factory;
																																									_tmp303_ = valadoc_content_content_factory_create_text (_tmp302_, "return");
																																									_tmp304_ = _tmp303_;
																																									vala_collection_add ((ValaCollection*) _tmp301_, (ValadocContentInline*) _tmp304_);
																																									_g_object_unref0 (_tmp304_);
																																									_tmp305_ = current_run;
																																									_tmp306_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp305_);
																																									_tmp307_ = _tmp306_;
																																									_tmp308_ = keyword_run;
																																									vala_collection_add ((ValaCollection*) _tmp307_, (ValadocContentInline*) _tmp308_);
																																									_tmp309_ = current_run;
																																									_tmp310_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp309_);
																																									_tmp311_ = _tmp310_;
																																									_tmp312_ = self->priv->factory;
																																									_tmp313_ = valadoc_content_content_factory_create_text (_tmp312_, ".length");
																																									_tmp314_ = _tmp313_;
																																									vala_collection_add ((ValaCollection*) _tmp311_, (ValadocContentInline*) _tmp314_);
																																									_g_object_unref0 (_tmp314_);
																																									_g_object_unref0 (keyword_run);
																																								} else {
																																									const gchar* _tmp315_;
																																									_tmp315_ = param_array_name;
																																									if (_tmp315_ != NULL) {
																																										ValadocContentRun* _tmp316_;
																																										ValaList* _tmp317_;
																																										ValaList* _tmp318_;
																																										ValadocContentContentFactory* _tmp319_;
																																										const gchar* _tmp320_;
																																										gchar* _tmp321_;
																																										gchar* _tmp322_;
																																										ValadocContentText* _tmp323_;
																																										ValadocContentText* _tmp324_;
																																										_tmp316_ = current_run;
																																										_tmp317_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp316_);
																																										_tmp318_ = _tmp317_;
																																										_tmp319_ = self->priv->factory;
																																										_tmp320_ = param_array_name;
																																										_tmp321_ = g_strconcat (_tmp320_, ".length", NULL);
																																										_tmp322_ = _tmp321_;
																																										_tmp323_ = valadoc_content_content_factory_create_text (_tmp319_, _tmp322_);
																																										_tmp324_ = _tmp323_;
																																										vala_collection_add ((ValaCollection*) _tmp318_, (ValadocContentInline*) _tmp324_);
																																										_g_object_unref0 (_tmp324_);
																																										_g_free0 (_tmp322_);
																																									} else {
																																										ValadocContentRun* _tmp325_;
																																										ValaList* _tmp326_;
																																										ValaList* _tmp327_;
																																										ValadocContentContentFactory* _tmp328_;
																																										const gchar* _tmp329_;
																																										ValadocContentText* _tmp330_;
																																										ValadocContentText* _tmp331_;
																																										_tmp325_ = current_run;
																																										_tmp326_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp325_);
																																										_tmp327_ = _tmp326_;
																																										_tmp328_ = self->priv->factory;
																																										_tmp329_ = param_name;
																																										_tmp330_ = valadoc_content_content_factory_create_text (_tmp328_, _tmp329_);
																																										_tmp331_ = _tmp330_;
																																										vala_collection_add ((ValaCollection*) _tmp327_, (ValadocContentInline*) _tmp331_);
																																										_g_object_unref0 (_tmp331_);
																																									}
																																								}
																																								_tmp332_ = cname;
																																								if (_tmp332_ != NULL) {
																																									ValadocContentRun* _tmp333_;
																																									ValaList* _tmp334_;
																																									ValaList* _tmp335_;
																																									ValadocContentContentFactory* _tmp336_;
																																									ValadocContentText* _tmp337_;
																																									ValadocContentText* _tmp338_;
																																									ValadocTagletsLink* link = NULL;
																																									ValadocContentContentFactory* _tmp339_;
																																									ValadocContentTaglet* _tmp340_;
																																									ValadocTagletsLink* _tmp341_;
																																									ValadocTagletsLink* _tmp342_;
																																									const gchar* _tmp343_;
																																									ValadocContentRun* _tmp344_;
																																									ValaList* _tmp345_;
																																									ValaList* _tmp346_;
																																									ValadocTagletsLink* _tmp347_;
																																									_tmp333_ = run;
																																									_tmp334_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp333_);
																																									_tmp335_ = _tmp334_;
																																									_tmp336_ = self->priv->factory;
																																									_tmp337_ = valadoc_content_content_factory_create_text (_tmp336_, ".");
																																									_tmp338_ = _tmp337_;
																																									vala_collection_add ((ValaCollection*) _tmp335_, (ValadocContentInline*) _tmp338_);
																																									_g_object_unref0 (_tmp338_);
																																									_tmp339_ = self->priv->factory;
																																									_tmp340_ = valadoc_content_content_factory_create_taglet (_tmp339_, "link");
																																									_tmp341_ = VALADOC_TAGLETS_IS_LINK (_tmp340_) ? ((ValadocTagletsLink*) _tmp340_) : NULL;
																																									if (_tmp341_ == NULL) {
																																										_g_object_unref0 (_tmp340_);
																																									}
																																									link = _tmp341_;
																																									_tmp342_ = link;
																																									_tmp343_ = cname;
																																									valadoc_taglets_link_set_symbol_name (_tmp342_, _tmp343_);
																																									_tmp344_ = run;
																																									_tmp345_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp344_);
																																									_tmp346_ = _tmp345_;
																																									_tmp347_ = link;
																																									vala_collection_add ((ValaCollection*) _tmp346_, (ValadocContentInline*) _tmp347_);
																																									_g_object_unref0 (link);
																																								}
																																								_g_object_unref0 (current_run);
																																								_g_free0 (cname);
																																								_g_free0 (param_name);
																																								_g_free0 (param_array_name);
																																							}
																																							_tmp348_ = valadoc_gtkdoc_parser_next (self);
																																							_tmp349_ = _tmp348_;
																																							_valadoc_gtkdoc_token_unref0 (_tmp349_);
																																						} else {
																																							ValadocGtkdocToken* _tmp350_;
																																							_tmp350_ = self->priv->current;
																																							if (_tmp350_->type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL) {
																																								ValadocContentRun* _tmp351_;
																																								ValaList* _tmp352_;
																																								ValaList* _tmp353_;
																																								ValadocGtkdocToken* _tmp354_;
																																								const gchar* _tmp355_;
																																								gchar* _tmp356_;
																																								gchar* _tmp357_;
																																								ValadocContentInline* _tmp358_;
																																								ValadocContentInline* _tmp359_;
																																								ValadocGtkdocToken* _tmp360_;
																																								ValadocGtkdocToken* _tmp361_;
																																								_tmp351_ = run;
																																								_tmp352_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp351_);
																																								_tmp353_ = _tmp352_;
																																								_tmp354_ = self->priv->current;
																																								_tmp355_ = _tmp354_->content;
																																								_tmp356_ = g_strconcat ("::", _tmp355_, NULL);
																																								_tmp357_ = _tmp356_;
																																								_tmp358_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp357_, TRUE);
																																								_tmp359_ = _tmp358_;
																																								vala_collection_add ((ValaCollection*) _tmp353_, _tmp359_);
																																								_g_object_unref0 (_tmp359_);
																																								_g_free0 (_tmp357_);
																																								_tmp360_ = valadoc_gtkdoc_parser_next (self);
																																								_tmp361_ = _tmp360_;
																																								_valadoc_gtkdoc_token_unref0 (_tmp361_);
																																							} else {
																																								ValadocGtkdocToken* _tmp362_;
																																								_tmp362_ = self->priv->current;
																																								if (_tmp362_->type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY) {
																																									ValadocContentRun* _tmp363_;
																																									ValaList* _tmp364_;
																																									ValaList* _tmp365_;
																																									ValadocGtkdocToken* _tmp366_;
																																									const gchar* _tmp367_;
																																									gchar* _tmp368_;
																																									gchar* _tmp369_;
																																									ValadocContentInline* _tmp370_;
																																									ValadocContentInline* _tmp371_;
																																									ValadocGtkdocToken* _tmp372_;
																																									ValadocGtkdocToken* _tmp373_;
																																									_tmp363_ = run;
																																									_tmp364_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp363_);
																																									_tmp365_ = _tmp364_;
																																									_tmp366_ = self->priv->current;
																																									_tmp367_ = _tmp366_->content;
																																									_tmp368_ = g_strconcat (":", _tmp367_, NULL);
																																									_tmp369_ = _tmp368_;
																																									_tmp370_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp369_, TRUE);
																																									_tmp371_ = _tmp370_;
																																									vala_collection_add ((ValaCollection*) _tmp365_, _tmp371_);
																																									_g_object_unref0 (_tmp371_);
																																									_g_free0 (_tmp369_);
																																									_tmp372_ = valadoc_gtkdoc_parser_next (self);
																																									_tmp373_ = _tmp372_;
																																									_valadoc_gtkdoc_token_unref0 (_tmp373_);
																																								} else {
																																									ValadocGtkdocToken* _tmp374_;
																																									_tmp374_ = self->priv->current;
																																									if (_tmp374_->type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST) {
																																										ValadocContentRun* _tmp375_;
																																										ValaList* _tmp376_;
																																										ValaList* _tmp377_;
																																										ValadocGtkdocToken* _tmp378_;
																																										const gchar* _tmp379_;
																																										ValadocContentInline* _tmp380_;
																																										ValadocContentInline* _tmp381_;
																																										ValadocGtkdocToken* _tmp382_;
																																										ValadocGtkdocToken* _tmp383_;
																																										_tmp375_ = run;
																																										_tmp376_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp375_);
																																										_tmp377_ = _tmp376_;
																																										_tmp378_ = self->priv->current;
																																										_tmp379_ = _tmp378_->content;
																																										_tmp380_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp379_, TRUE);
																																										_tmp381_ = _tmp380_;
																																										vala_collection_add ((ValaCollection*) _tmp377_, _tmp381_);
																																										_g_object_unref0 (_tmp381_);
																																										_tmp382_ = valadoc_gtkdoc_parser_next (self);
																																										_tmp383_ = _tmp382_;
																																										_valadoc_gtkdoc_token_unref0 (_tmp383_);
																																									} else {
																																										ValadocGtkdocToken* _tmp384_;
																																										_tmp384_ = self->priv->current;
																																										if (_tmp384_->type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE) {
																																											ValadocContentRun* _tmp385_;
																																											ValaList* _tmp386_;
																																											ValaList* _tmp387_;
																																											ValadocGtkdocToken* _tmp388_;
																																											const gchar* _tmp389_;
																																											ValadocContentInline* _tmp390_;
																																											ValadocContentInline* _tmp391_;
																																											ValadocGtkdocToken* _tmp392_;
																																											ValadocGtkdocToken* _tmp393_;
																																											_tmp385_ = run;
																																											_tmp386_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp385_);
																																											_tmp387_ = _tmp386_;
																																											_tmp388_ = self->priv->current;
																																											_tmp389_ = _tmp388_->content;
																																											_tmp390_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp389_, TRUE);
																																											_tmp391_ = _tmp390_;
																																											vala_collection_add ((ValaCollection*) _tmp387_, _tmp391_);
																																											_g_object_unref0 (_tmp391_);
																																											_tmp392_ = valadoc_gtkdoc_parser_next (self);
																																											_tmp393_ = _tmp392_;
																																											_valadoc_gtkdoc_token_unref0 (_tmp393_);
																																										} else {
																																											gboolean _tmp394_ = FALSE;
																																											ValadocGtkdocToken* _tmp395_;
																																											_tmp395_ = self->priv->current;
																																											if (_tmp395_->type == VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE) {
																																												_tmp394_ = TRUE;
																																											} else {
																																												ValadocGtkdocToken* _tmp396_;
																																												_tmp396_ = self->priv->current;
																																												_tmp394_ = _tmp396_->type == VALADOC_GTKDOC_TOKEN_TYPE_SPACE;
																																											}
																																											if (_tmp394_) {
																																												ValadocContentRun* _tmp397_;
																																												ValadocGtkdocToken* _tmp398_;
																																												ValadocGtkdocToken* _tmp399_;
																																												_tmp397_ = run;
																																												valadoc_gtkdoc_parser_append_inline_content_string (self, _tmp397_, " ");
																																												_tmp398_ = valadoc_gtkdoc_parser_next (self);
																																												_tmp399_ = _tmp398_;
																																												_valadoc_gtkdoc_token_unref0 (_tmp399_);
																																											} else {
																																												ValadocGtkdocToken* _tmp400_;
																																												_tmp400_ = self->priv->current;
																																												if (_tmp400_->type == VALADOC_GTKDOC_TOKEN_TYPE_WORD) {
																																													ValadocContentRun* _tmp401_;
																																													ValadocGtkdocToken* _tmp402_;
																																													const gchar* _tmp403_;
																																													ValadocGtkdocToken* _tmp404_;
																																													ValadocGtkdocToken* _tmp405_;
																																													_tmp401_ = run;
																																													_tmp402_ = self->priv->current;
																																													_tmp403_ = _tmp402_->content;
																																													valadoc_gtkdoc_parser_append_inline_content_string (self, _tmp401_, _tmp403_);
																																													_tmp404_ = valadoc_gtkdoc_parser_next (self);
																																													_tmp405_ = _tmp404_;
																																													_valadoc_gtkdoc_token_unref0 (_tmp405_);
																																												} else {
																																													gboolean _tmp406_ = FALSE;
																																													ValadocGtkdocToken* _tmp407_;
																																													_tmp407_ = self->priv->current;
																																													if (_tmp407_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
																																														_tmp406_ = valadoc_gtkdoc_parser_ignore_current_xml_close (self);
																																													} else {
																																														_tmp406_ = FALSE;
																																													}
																																													if (_tmp406_) {
																																														ValadocGtkdocToken* _tmp408_;
																																														ValadocGtkdocToken* _tmp409_;
																																														_tmp408_ = valadoc_gtkdoc_parser_next (self);
																																														_tmp409_ = _tmp408_;
																																														_valadoc_gtkdoc_token_unref0 (_tmp409_);
																																													} else {
																																														ValadocGtkdocToken* _tmp410_;
																																														_tmp410_ = self->priv->current;
																																														if (_tmp410_->type == VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT) {
																																															ValadocGtkdocToken* _tmp411_;
																																															ValadocGtkdocToken* _tmp412_;
																																															_tmp411_ = valadoc_gtkdoc_parser_next (self);
																																															_tmp412_ = _tmp411_;
																																															_valadoc_gtkdoc_token_unref0 (_tmp412_);
																																														} else {
																																															break;
																																														}
																																													}
																																												}
																																											}
																																										}
																																									}
																																								}
																																							}
																																						}
																																					}
																																				}
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = run;
	return result;
}

static gchar*
valadoc_gtkdoc_parser_real_resolve (ValadocResourceLocator* base,
                                    const gchar* path)
{
	ValadocGtkdocParser * self;
	gchar* _tmp0_;
	gchar* result = NULL;
	self = (ValadocGtkdocParser*) base;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_strdup (path);
	result = _tmp0_;
	return result;
}

static void
valadoc_gtkdoc_parser_class_init (ValadocGtkdocParserClass * klass,
                                  gpointer klass_data)
{
	valadoc_gtkdoc_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocGtkdocParser_private_offset);
	G_OBJECT_CLASS (klass)->finalize = valadoc_gtkdoc_parser_finalize;
}

static void
valadoc_gtkdoc_parser_valadoc_resource_locator_interface_init (ValadocResourceLocatorIface * iface,
                                                               gpointer iface_data)
{
	valadoc_gtkdoc_parser_valadoc_resource_locator_parent_iface = g_type_interface_peek_parent (iface);
	iface->resolve = (gchar* (*) (ValadocResourceLocator*, const gchar*)) valadoc_gtkdoc_parser_real_resolve;
}

static void
valadoc_gtkdoc_parser_instance_init (ValadocGtkdocParser * self,
                                     gpointer klass)
{
	ValadocGtkdocScanner* _tmp0_;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	self->priv = valadoc_gtkdoc_parser_get_instance_private (self);
	_tmp0_ = valadoc_gtkdoc_scanner_new ();
	self->priv->scanner = _tmp0_;
	_tmp1_ = g_str_equal;
	_tmp2_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp1_);
	self->priv->stack = (ValaList*) _tmp2_;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_TYPE_ARRAY_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp3_);
	self->priv->footnotes = (ValaList*) _tmp4_;
	self->priv->is_numeric_regex = NULL;
	self->priv->normalize_regex = NULL;
	self->priv->regex_source_lang = NULL;
	self->priv->id_registrar = NULL;
	self->priv->current_metadata = NULL;
}

static void
valadoc_gtkdoc_parser_finalize (GObject * obj)
{
	ValadocGtkdocParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_GTKDOC_TYPE_PARSER, ValadocGtkdocParser);
	_valadoc_gtkdoc_scanner_unref0 (self->priv->scanner);
	_valadoc_gtkdoc_token_unref0 (self->priv->current);
	_vala_iterable_unref0 (self->priv->stack);
	_vala_iterable_unref0 (self->priv->footnotes);
	_g_object_unref0 (self->priv->factory);
	_g_object_unref0 (self->priv->reporter);
	_g_object_unref0 (self->priv->settings);
	_valadoc_api_tree_unref0 (self->priv->tree);
	_g_object_unref0 (self->priv->element);
	_valadoc_api_source_comment_unref0 (self->priv->comment);
	self->priv->comment_lines = (_vala_array_free (self->priv->comment_lines, self->priv->comment_lines_length1, (GDestroyNotify) g_free), NULL);
	_g_regex_unref0 (self->priv->is_numeric_regex);
	_g_regex_unref0 (self->priv->normalize_regex);
	_g_regex_unref0 (self->priv->regex_source_lang);
	_valadoc_importer_internal_id_registrar_unref0 (self->priv->id_registrar);
	_g_object_unref0 (self->priv->current_metadata);
	G_OBJECT_CLASS (valadoc_gtkdoc_parser_parent_class)->finalize (obj);
}

static GType
valadoc_gtkdoc_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValadocGtkdocParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_gtkdoc_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocGtkdocParser), 0, (GInstanceInitFunc) valadoc_gtkdoc_parser_instance_init, NULL };
	static const GInterfaceInfo valadoc_resource_locator_info = { (GInterfaceInitFunc) valadoc_gtkdoc_parser_valadoc_resource_locator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType valadoc_gtkdoc_parser_type_id;
	valadoc_gtkdoc_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocGtkdocParser", &g_define_type_info, 0);
	g_type_add_interface_static (valadoc_gtkdoc_parser_type_id, VALADOC_TYPE_RESOURCE_LOCATOR, &valadoc_resource_locator_info);
	ValadocGtkdocParser_private_offset = g_type_add_instance_private (valadoc_gtkdoc_parser_type_id, sizeof (ValadocGtkdocParserPrivate));
	return valadoc_gtkdoc_parser_type_id;
}

GType
valadoc_gtkdoc_parser_get_type (void)
{
	static volatile gsize valadoc_gtkdoc_parser_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_parser_type_id__volatile)) {
		GType valadoc_gtkdoc_parser_type_id;
		valadoc_gtkdoc_parser_type_id = valadoc_gtkdoc_parser_get_type_once ();
		g_once_init_leave (&valadoc_gtkdoc_parser_type_id__volatile, valadoc_gtkdoc_parser_type_id);
	}
	return valadoc_gtkdoc_parser_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

