/* valaarraycreationexpression.c generated by valac, the Vala compiler
 * generated from valaarraycreationexpression.vala, do not modify */

/* valaarraycreationexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaArrayCreationExpressionPrivate {
	gint _rank;
	ValaList* sizes;
	ValaDataType* _element_type;
	ValaDataType* _length_type;
	ValaInitializerList* _initializer_list;
};

static gint ValaArrayCreationExpression_private_offset;
static gpointer vala_array_creation_expression_parent_class = NULL;

static void vala_array_creation_expression_set_element_type (ValaArrayCreationExpression* self,
                                                      ValaDataType* value);
static void vala_array_creation_expression_set_rank (ValaArrayCreationExpression* self,
                                              gint value);
static void vala_array_creation_expression_set_initializer_list (ValaArrayCreationExpression* self,
                                                          ValaInitializerList* value);
static void vala_array_creation_expression_real_accept_children (ValaCodeNode* base,
                                                          ValaCodeVisitor* visitor);
static void vala_array_creation_expression_real_accept (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static gboolean vala_array_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_array_creation_expression_real_is_accessible (ValaExpression* base,
                                                            ValaSymbol* sym);
static gchar* vala_array_creation_expression_real_to_string (ValaCodeNode* base);
static void vala_array_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                             ValaExpression* old_node,
                                                             ValaExpression* new_node);
static void vala_array_creation_expression_real_replace_type (ValaCodeNode* base,
                                                       ValaDataType* old_type,
                                                       ValaDataType* new_type);
static gint vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self,
                                                                        ValaCodeContext* context,
                                                                        ValaInitializerList* il,
                                                                        gint rank,
                                                                        ValaList* sl);
static gboolean vala_array_creation_expression_real_check (ValaCodeNode* base,
                                                    ValaCodeContext* context);
static void vala_array_creation_expression_real_emit (ValaCodeNode* base,
                                               ValaCodeGenerator* codegen);
static void vala_array_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                             ValaCollection* collection);
static void vala_array_creation_expression_finalize (ValaCodeNode * obj);
static GType vala_array_creation_expression_get_type_once (void);

static inline gpointer
vala_array_creation_expression_get_instance_private (ValaArrayCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaArrayCreationExpression_private_offset);
}

ValaDataType*
vala_array_creation_expression_get_element_type (ValaArrayCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_element_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_array_creation_expression_set_element_type (ValaArrayCreationExpression* self,
                                                 ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_element_type);
	self->priv->_element_type = _tmp0_;
	_tmp1_ = self->priv->_element_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaDataType*
vala_array_creation_expression_get_length_type (ValaArrayCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_length_type;
	result = _tmp0_;
	return result;
}

void
vala_array_creation_expression_set_length_type (ValaArrayCreationExpression* self,
                                                ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_length_type);
	self->priv->_length_type = _tmp0_;
	_tmp1_ = self->priv->_length_type;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		_tmp2_ = self->priv->_length_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

gint
vala_array_creation_expression_get_rank (ValaArrayCreationExpression* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rank;
	return result;
}

static void
vala_array_creation_expression_set_rank (ValaArrayCreationExpression* self,
                                         gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_rank = value;
}

ValaInitializerList*
vala_array_creation_expression_get_initializer_list (ValaArrayCreationExpression* self)
{
	ValaInitializerList* result;
	ValaInitializerList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initializer_list;
	result = _tmp0_;
	return result;
}

static void
vala_array_creation_expression_set_initializer_list (ValaArrayCreationExpression* self,
                                                     ValaInitializerList* value)
{
	ValaInitializerList* _tmp0_;
	ValaInitializerList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_initializer_list);
	self->priv->_initializer_list = _tmp0_;
	_tmp1_ = self->priv->_initializer_list;
	if (_tmp1_ != NULL) {
		ValaInitializerList* _tmp2_;
		_tmp2_ = self->priv->_initializer_list;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

/**
 * Add a size expression.
 */
void
vala_array_creation_expression_append_size (ValaArrayCreationExpression* self,
                                            ValaExpression* size)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (size != NULL);
	_tmp0_ = self->priv->sizes;
	vala_collection_add ((ValaCollection*) _tmp0_, size);
	if (size != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) size, (ValaCodeNode*) self);
	}
}

/**
 * Get the sizes for all dimensions ascending from left to right.
 */
ValaList*
vala_array_creation_expression_get_sizes (ValaArrayCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sizes;
	result = _tmp0_;
	return result;
}

ValaArrayCreationExpression*
vala_array_creation_expression_construct (GType object_type,
                                          ValaDataType* element_type,
                                          gint rank,
                                          ValaInitializerList* initializer_list,
                                          ValaSourceReference* source_reference)
{
	ValaArrayCreationExpression* self = NULL;
	g_return_val_if_fail (element_type != NULL, NULL);
	self = (ValaArrayCreationExpression*) vala_expression_construct (object_type);
	vala_array_creation_expression_set_element_type (self, element_type);
	vala_array_creation_expression_set_rank (self, rank);
	vala_array_creation_expression_set_initializer_list (self, initializer_list);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaArrayCreationExpression*
vala_array_creation_expression_new (ValaDataType* element_type,
                                    gint rank,
                                    ValaInitializerList* initializer_list,
                                    ValaSourceReference* source_reference)
{
	return vala_array_creation_expression_construct (VALA_TYPE_ARRAY_CREATION_EXPRESSION, element_type, rank, initializer_list, source_reference);
}

static void
vala_array_creation_expression_real_accept_children (ValaCodeNode* base,
                                                     ValaCodeVisitor* visitor)
{
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaInitializerList* _tmp17_;
	ValaInitializerList* _tmp18_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_array_creation_expression_get_element_type (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_array_creation_expression_get_length_type (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp6_ = vala_array_creation_expression_get_length_type (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp8_;
		gint _e_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _e_index = 0;
		_tmp8_ = self->priv->sizes;
		_e_list = _tmp8_;
		_tmp9_ = _e_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_e_size = _tmp11_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaExpression* e = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaExpression* _tmp16_;
			_e_index = _e_index + 1;
			_tmp12_ = _e_index;
			_tmp13_ = _e_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _e_list;
			_tmp15_ = vala_list_get (_tmp14_, _e_index);
			e = (ValaExpression*) _tmp15_;
			_tmp16_ = e;
			vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
			_vala_code_node_unref0 (e);
		}
	}
	_tmp17_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != NULL) {
		ValaInitializerList* _tmp19_;
		ValaInitializerList* _tmp20_;
		_tmp19_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp20_ = _tmp19_;
		vala_code_node_accept ((ValaCodeNode*) _tmp20_, visitor);
	}
}

static void
vala_array_creation_expression_real_accept (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_array_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gboolean
vala_array_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaArrayCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_array_creation_expression_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym)
{
	ValaArrayCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	gboolean _tmp5_ = FALSE;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaInitializerList* _tmp19_;
	ValaInitializerList* _tmp20_;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_array_creation_expression_get_element_type (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		_tmp3_ = vala_array_creation_expression_get_element_type (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_data_type_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_array_creation_expression_get_length_type (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_array_creation_expression_get_length_type (self);
		_tmp9_ = _tmp8_;
		_tmp5_ = !vala_data_type_is_accessible (_tmp9_, sym);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp10_;
		gint _e_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _e_index = 0;
		_tmp10_ = self->priv->sizes;
		_e_list = _tmp10_;
		_tmp11_ = _e_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_e_size = _tmp13_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaExpression* e = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaExpression* _tmp18_;
			_e_index = _e_index + 1;
			_tmp14_ = _e_index;
			_tmp15_ = _e_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _e_list;
			_tmp17_ = vala_list_get (_tmp16_, _e_index);
			e = (ValaExpression*) _tmp17_;
			_tmp18_ = e;
			if (!vala_expression_is_accessible (_tmp18_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (e);
				return result;
			}
			_vala_code_node_unref0 (e);
		}
	}
	_tmp19_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp20_ = _tmp19_;
	if (_tmp20_ != NULL) {
		ValaInitializerList* _tmp21_;
		ValaInitializerList* _tmp22_;
		_tmp21_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp22_ = _tmp21_;
		result = vala_expression_is_accessible ((ValaExpression*) _tmp22_, sym);
		return result;
	}
	result = TRUE;
	return result;
}

static gchar*
vala_array_creation_expression_real_to_string (ValaCodeNode* base)
{
	ValaArrayCreationExpression * self;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean first = FALSE;
	GString* _tmp22_;
	ValaInitializerList* _tmp23_;
	ValaInitializerList* _tmp24_;
	GString* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* result = NULL;
	self = (ValaArrayCreationExpression*) base;
	_tmp0_ = g_string_new ("new ");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = vala_array_creation_expression_get_element_type (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_code_node_to_string ((ValaCodeNode*) _tmp3_);
	_tmp5_ = _tmp4_;
	g_string_append_printf (_tmp1_, "%s[", _tmp5_);
	_g_free0 (_tmp5_);
	first = TRUE;
	{
		ValaList* _size_list = NULL;
		ValaList* _tmp6_;
		gint _size_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _size_index = 0;
		_tmp6_ = self->priv->sizes;
		_size_list = _tmp6_;
		_tmp7_ = _size_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_size_size = _tmp9_;
		_size_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			ValaExpression* size = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			_size_index = _size_index + 1;
			_tmp10_ = _size_index;
			_tmp11_ = _size_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _size_list;
			_tmp13_ = vala_list_get (_tmp12_, _size_index);
			size = (ValaExpression*) _tmp13_;
			if (first) {
				GString* _tmp14_;
				ValaExpression* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp14_ = builder;
				_tmp15_ = size;
				_tmp16_ = vala_code_node_to_string ((ValaCodeNode*) _tmp15_);
				_tmp17_ = _tmp16_;
				g_string_append (_tmp14_, _tmp17_);
				_g_free0 (_tmp17_);
				first = FALSE;
			} else {
				GString* _tmp18_;
				ValaExpression* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp18_ = builder;
				_tmp19_ = size;
				_tmp20_ = vala_code_node_to_string ((ValaCodeNode*) _tmp19_);
				_tmp21_ = _tmp20_;
				g_string_append_printf (_tmp18_, ", %s", _tmp21_);
				_g_free0 (_tmp21_);
			}
			_vala_code_node_unref0 (size);
		}
	}
	_tmp22_ = builder;
	g_string_append_c (_tmp22_, ']');
	_tmp23_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp24_ = _tmp23_;
	if (_tmp24_ != NULL) {
		GString* _tmp25_;
		ValaInitializerList* _tmp26_;
		ValaInitializerList* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp25_ = builder;
		_tmp26_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_code_node_to_string ((ValaCodeNode*) _tmp27_);
		_tmp29_ = _tmp28_;
		g_string_append (_tmp25_, _tmp29_);
		_g_free0 (_tmp29_);
	}
	_tmp30_ = builder;
	_tmp31_ = _tmp30_->str;
	_tmp32_ = g_strdup (_tmp31_);
	result = _tmp32_;
	_g_string_free0 (builder);
	return result;
}

static void
vala_array_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                        ValaExpression* old_node,
                                                        ValaExpression* new_node)
{
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaExpression* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->sizes;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->sizes;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaExpression*) _tmp6_;
				_tmp8_ = _tmp7_ == old_node;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->sizes;
					vala_list_set (_tmp9_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_array_creation_expression_real_replace_type (ValaCodeNode* base,
                                                  ValaDataType* old_type,
                                                  ValaDataType* new_type)
{
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_array_creation_expression_set_element_type (self, new_type);
	}
	_tmp2_ = vala_array_creation_expression_get_length_type (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_array_creation_expression_set_length_type (self, new_type);
	}
}

static gint
vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self,
                                                                   ValaCodeContext* context,
                                                                   ValaInitializerList* il,
                                                                   gint rank,
                                                                   ValaList* sl)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint subsize = 0;
	gint _tmp38_;
	gint _tmp39_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (context != NULL, 0);
	g_return_val_if_fail (il != NULL, 0);
	g_return_val_if_fail (sl != NULL, 0);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) sl);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_rank;
	if (_tmp1_ == (_tmp2_ - rank)) {
		ValaIntegerLiteral* init = NULL;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaIntegerLiteral* _tmp9_;
		ValaIntegerLiteral* _tmp10_;
		ValaIntegerLiteral* _tmp11_;
		ValaIntegerLiteral* _tmp12_;
		_tmp3_ = vala_initializer_list_get_size (il);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%i", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_integer_literal_new (_tmp6_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp6_);
		init = _tmp10_;
		_tmp11_ = init;
		vala_code_node_check ((ValaCodeNode*) _tmp11_, context);
		_tmp12_ = init;
		vala_collection_add ((ValaCollection*) sl, (ValaLiteral*) _tmp12_);
		_vala_code_node_unref0 (init);
	}
	subsize = -1;
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp13_;
		gint _e_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _e_index = 0;
		_tmp13_ = vala_initializer_list_get_initializers (il);
		_e_list = _tmp13_;
		_tmp14_ = _e_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_e_size = _tmp16_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			ValaExpression* e = NULL;
			ValaList* _tmp19_;
			gpointer _tmp20_;
			gboolean _tmp21_ = FALSE;
			ValaExpression* _tmp22_;
			_e_index = _e_index + 1;
			_tmp17_ = _e_index;
			_tmp18_ = _e_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _e_list;
			_tmp20_ = vala_list_get (_tmp19_, _e_index);
			e = (ValaExpression*) _tmp20_;
			_tmp22_ = e;
			if (VALA_IS_INITIALIZER_LIST (_tmp22_)) {
				ValaExpression* _tmp23_;
				ValaDataType* _tmp24_;
				ValaDataType* _tmp25_;
				_tmp23_ = e;
				_tmp24_ = vala_expression_get_target_type (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp21_ = VALA_IS_ARRAY_TYPE (_tmp25_);
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				gint size = 0;
				ValaExpression* _tmp30_;
				gboolean _tmp31_ = FALSE;
				if (rank == 1) {
					ValaExpression* _tmp26_;
					ValaExpression* _tmp27_;
					ValaSourceReference* _tmp28_;
					ValaSourceReference* _tmp29_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp26_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp26_, TRUE);
					_tmp27_ = e;
					_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp27_);
					_tmp29_ = _tmp28_;
					vala_report_error (_tmp29_, "Expected array element, got array initializer list");
					result = -1;
					_vala_code_node_unref0 (e);
					return result;
				}
				_tmp30_ = e;
				size = vala_array_creation_expression_create_sizes_from_initializer_list (self, context, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList), rank - 1, sl);
				if (size == -1) {
					result = -1;
					_vala_code_node_unref0 (e);
					return result;
				}
				if (subsize >= 0) {
					_tmp31_ = subsize != size;
				} else {
					_tmp31_ = FALSE;
				}
				if (_tmp31_) {
					ValaSourceReference* _tmp32_;
					ValaSourceReference* _tmp33_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
					_tmp33_ = _tmp32_;
					vala_report_error (_tmp33_, "Expected initializer list of size %d, got size %d", subsize, size);
					result = -1;
					_vala_code_node_unref0 (e);
					return result;
				} else {
					subsize = size;
				}
			} else {
				if (rank != 1) {
					ValaExpression* _tmp34_;
					ValaExpression* _tmp35_;
					ValaSourceReference* _tmp36_;
					ValaSourceReference* _tmp37_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp34_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp34_, TRUE);
					_tmp35_ = e;
					_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp35_);
					_tmp37_ = _tmp36_;
					vala_report_error (_tmp37_, "Expected array initializer list, got array element");
					result = -1;
					_vala_code_node_unref0 (e);
					return result;
				}
			}
			_vala_code_node_unref0 (e);
		}
	}
	_tmp38_ = vala_initializer_list_get_size (il);
	_tmp39_ = _tmp38_;
	result = _tmp39_;
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_array_creation_expression_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context)
{
	ValaArrayCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaList* sizes = NULL;
	ValaList* _tmp4_;
	ValaList* _tmp5_;
	ValaInitializerList* initlist = NULL;
	ValaInitializerList* _tmp6_;
	ValaInitializerList* _tmp7_;
	ValaInitializerList* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaArrayList* calc_sizes = NULL;
	GEqualFunc _tmp37_;
	ValaArrayList* _tmp38_;
	ValaInitializerList* _tmp39_;
	ValaList* _tmp84_;
	gint _tmp85_;
	gint _tmp86_;
	gboolean _tmp120_;
	gboolean _tmp121_;
	gboolean _tmp122_ = FALSE;
	ValaInitializerList* _tmp123_;
	ValaInitializerList* _tmp124_;
	ValaDataType* _tmp129_;
	ValaDataType* _tmp130_;
	ValaDataType* _tmp133_;
	ValaDataType* _tmp134_;
	gint _tmp135_;
	ValaSourceReference* _tmp136_;
	ValaSourceReference* _tmp137_;
	ValaArrayType* _tmp138_;
	ValaArrayType* _tmp139_;
	ValaDataType* _tmp140_;
	ValaDataType* _tmp141_;
	ValaDataType* _tmp142_;
	ValaDataType* _tmp143_;
	ValaDataType* _tmp144_;
	ValaDataType* _tmp145_;
	ValaDataType* _tmp146_;
	ValaDataType* _tmp147_;
	ValaDataType* _tmp160_;
	ValaDataType* _tmp161_;
	ValaDataType* _tmp162_;
	ValaDataType* _tmp163_;
	gboolean _tmp164_;
	gboolean _tmp165_;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_array_creation_expression_get_sizes (self);
	_tmp5_ = _vala_iterable_ref0 (_tmp4_);
	sizes = _tmp5_;
	_tmp6_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (_tmp7_);
	initlist = _tmp8_;
	_tmp9_ = vala_array_creation_expression_get_element_type (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		_tmp11_ = vala_array_creation_expression_get_element_type (self);
		_tmp12_ = _tmp11_;
		vala_code_node_check ((ValaCodeNode*) _tmp12_, context);
	}
	_tmp13_ = vala_array_creation_expression_get_length_type (self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ == NULL) {
		ValaSemanticAnalyzer* _tmp15_;
		ValaSemanticAnalyzer* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaDataType* _tmp19_;
		_tmp15_ = vala_code_context_get_analyzer (context);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_->int_type;
		_tmp18_ = vala_data_type_copy (_tmp17_);
		_tmp19_ = _tmp18_;
		vala_array_creation_expression_set_length_type (self, _tmp19_);
		_vala_code_node_unref0 (_tmp19_);
	} else {
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		_tmp20_ = vala_array_creation_expression_get_length_type (self);
		_tmp21_ = _tmp20_;
		vala_code_node_check ((ValaCodeNode*) _tmp21_, context);
		_tmp22_ = vala_array_creation_expression_get_length_type (self);
		_tmp23_ = _tmp22_;
		if (!VALA_IS_INTEGER_TYPE (_tmp23_)) {
			ValaDataType* _tmp24_;
			ValaDataType* _tmp25_;
			ValaSourceReference* _tmp26_;
			ValaSourceReference* _tmp27_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp24_ = vala_array_creation_expression_get_length_type (self);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp25_);
			_tmp27_ = _tmp26_;
			vala_report_error (_tmp27_, "Expected integer type as length type of array");
		}
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp28_;
		gint _e_size = 0;
		ValaList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _e_index = 0;
		_tmp28_ = sizes;
		_e_list = _tmp28_;
		_tmp29_ = _e_list;
		_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_e_size = _tmp31_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			ValaExpression* e = NULL;
			ValaList* _tmp34_;
			gpointer _tmp35_;
			ValaExpression* _tmp36_;
			_e_index = _e_index + 1;
			_tmp32_ = _e_index;
			_tmp33_ = _e_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _e_list;
			_tmp35_ = vala_list_get (_tmp34_, _e_index);
			e = (ValaExpression*) _tmp35_;
			_tmp36_ = e;
			vala_code_node_check ((ValaCodeNode*) _tmp36_, context);
			_vala_code_node_unref0 (e);
		}
	}
	_tmp37_ = g_direct_equal;
	_tmp38_ = vala_array_list_new (VALA_TYPE_LITERAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp37_);
	calc_sizes = _tmp38_;
	_tmp39_ = initlist;
	if (_tmp39_ != NULL) {
		ValaInitializerList* _tmp40_;
		ValaDataType* _tmp41_;
		ValaDataType* _tmp42_;
		gint _tmp43_;
		ValaSourceReference* _tmp44_;
		ValaSourceReference* _tmp45_;
		ValaArrayType* _tmp46_;
		ValaArrayType* _tmp47_;
		ValaInitializerList* _tmp48_;
		ValaDataType* _tmp49_;
		ValaDataType* _tmp50_;
		ValaDataType* _tmp51_;
		ValaDataType* _tmp52_;
		ValaDataType* _tmp53_;
		ValaDataType* _tmp54_;
		ValaInitializerList* _tmp55_;
		gint ret = 0;
		ValaInitializerList* _tmp56_;
		gint _tmp57_;
		ValaArrayList* _tmp58_;
		ValaArrayList* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		_tmp40_ = initlist;
		_tmp41_ = vala_array_creation_expression_get_element_type (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = self->priv->_rank;
		_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_array_type_new (_tmp42_, _tmp43_, _tmp45_);
		_tmp47_ = _tmp46_;
		vala_expression_set_target_type ((ValaExpression*) _tmp40_, (ValaDataType*) _tmp47_);
		_vala_code_node_unref0 (_tmp47_);
		_tmp48_ = initlist;
		_tmp49_ = vala_expression_get_target_type ((ValaExpression*) _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = vala_array_creation_expression_get_length_type (self);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_data_type_copy (_tmp52_);
		_tmp54_ = _tmp53_;
		vala_array_type_set_length_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp54_);
		_vala_code_node_unref0 (_tmp54_);
		_tmp55_ = initlist;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp55_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
		_tmp56_ = initlist;
		_tmp57_ = self->priv->_rank;
		_tmp58_ = calc_sizes;
		ret = vala_array_creation_expression_create_sizes_from_initializer_list (self, context, _tmp56_, _tmp57_, (ValaList*) _tmp58_);
		if (ret == -1) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
		_tmp59_ = calc_sizes;
		_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = self->priv->_rank;
		if (_tmp61_ != _tmp62_) {
			ValaArrayType* actual_type = NULL;
			ValaDataType* _tmp63_;
			ValaDataType* _tmp64_;
			ValaArrayList* _tmp65_;
			gint _tmp66_;
			gint _tmp67_;
			ValaSourceReference* _tmp68_;
			ValaSourceReference* _tmp69_;
			ValaArrayType* _tmp70_;
			ValaArrayType* _tmp71_;
			ValaDataType* _tmp72_;
			ValaDataType* _tmp73_;
			ValaInitializerList* _tmp74_;
			ValaSourceReference* _tmp75_;
			ValaSourceReference* _tmp76_;
			ValaDataType* _tmp77_;
			ValaDataType* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			ValaArrayType* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp63_ = vala_array_creation_expression_get_element_type (self);
			_tmp64_ = _tmp63_;
			_tmp65_ = calc_sizes;
			_tmp66_ = vala_collection_get_size ((ValaCollection*) _tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp69_ = _tmp68_;
			_tmp70_ = vala_array_type_new (_tmp64_, _tmp67_, _tmp69_);
			actual_type = _tmp70_;
			_tmp71_ = actual_type;
			_tmp72_ = vala_array_creation_expression_get_length_type (self);
			_tmp73_ = _tmp72_;
			vala_array_type_set_length_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp73_);
			_tmp74_ = initlist;
			_tmp75_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp78_ = _tmp77_;
			_tmp79_ = vala_code_node_to_string ((ValaCodeNode*) _tmp78_);
			_tmp80_ = _tmp79_;
			_tmp81_ = actual_type;
			_tmp82_ = vala_code_node_to_string ((ValaCodeNode*) _tmp81_);
			_tmp83_ = _tmp82_;
			vala_report_error (_tmp76_, "Expected initializer for `%s' but got `%s'", _tmp80_, _tmp83_);
			_g_free0 (_tmp83_);
			_g_free0 (_tmp80_);
			_vala_code_node_unref0 (actual_type);
		}
	}
	_tmp84_ = sizes;
	_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
	_tmp86_ = _tmp85_;
	if (_tmp86_ > 0) {
		{
			ValaList* _e_list = NULL;
			ValaList* _tmp87_;
			gint _e_size = 0;
			ValaList* _tmp88_;
			gint _tmp89_;
			gint _tmp90_;
			gint _e_index = 0;
			_tmp87_ = sizes;
			_e_list = _tmp87_;
			_tmp88_ = _e_list;
			_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
			_tmp90_ = _tmp89_;
			_e_size = _tmp90_;
			_e_index = -1;
			while (TRUE) {
				gint _tmp91_;
				gint _tmp92_;
				ValaExpression* e = NULL;
				ValaList* _tmp93_;
				gpointer _tmp94_;
				ValaExpression* _tmp95_;
				ValaDataType* _tmp96_;
				ValaDataType* _tmp97_;
				_e_index = _e_index + 1;
				_tmp91_ = _e_index;
				_tmp92_ = _e_size;
				if (!(_tmp91_ < _tmp92_)) {
					break;
				}
				_tmp93_ = _e_list;
				_tmp94_ = vala_list_get (_tmp93_, _e_index);
				e = (ValaExpression*) _tmp94_;
				_tmp95_ = e;
				_tmp96_ = vala_expression_get_value_type (_tmp95_);
				_tmp97_ = _tmp96_;
				if (_tmp97_ == NULL) {
					result = FALSE;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (calc_sizes);
					_vala_code_node_unref0 (initlist);
					_vala_iterable_unref0 (sizes);
					return result;
				} else {
					gboolean _tmp98_ = FALSE;
					ValaExpression* _tmp99_;
					ValaDataType* _tmp100_;
					ValaDataType* _tmp101_;
					_tmp99_ = e;
					_tmp100_ = vala_expression_get_value_type (_tmp99_);
					_tmp101_ = _tmp100_;
					if (VALA_IS_INTEGER_TYPE (_tmp101_)) {
						_tmp98_ = TRUE;
					} else {
						ValaExpression* _tmp102_;
						ValaDataType* _tmp103_;
						ValaDataType* _tmp104_;
						_tmp102_ = e;
						_tmp103_ = vala_expression_get_value_type (_tmp102_);
						_tmp104_ = _tmp103_;
						_tmp98_ = VALA_IS_ENUM_VALUE_TYPE (_tmp104_);
					}
					if (!_tmp98_) {
						ValaExpression* _tmp105_;
						ValaSourceReference* _tmp106_;
						ValaSourceReference* _tmp107_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp105_ = e;
						_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp105_);
						_tmp107_ = _tmp106_;
						vala_report_error (_tmp107_, "Expression of integer type expected");
					}
				}
				_vala_code_node_unref0 (e);
			}
		}
	} else {
		ValaInitializerList* _tmp108_;
		_tmp108_ = initlist;
		if (_tmp108_ == NULL) {
			ValaSourceReference* _tmp109_;
			ValaSourceReference* _tmp110_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp110_ = _tmp109_;
			vala_report_error (_tmp110_, "internal error: initializer list expected");
		} else {
			{
				ValaArrayList* _size_list = NULL;
				ValaArrayList* _tmp111_;
				gint _size_size = 0;
				ValaArrayList* _tmp112_;
				gint _tmp113_;
				gint _tmp114_;
				gint _size_index = 0;
				_tmp111_ = calc_sizes;
				_size_list = _tmp111_;
				_tmp112_ = _size_list;
				_tmp113_ = vala_collection_get_size ((ValaCollection*) _tmp112_);
				_tmp114_ = _tmp113_;
				_size_size = _tmp114_;
				_size_index = -1;
				while (TRUE) {
					gint _tmp115_;
					gint _tmp116_;
					ValaExpression* size = NULL;
					ValaArrayList* _tmp117_;
					gpointer _tmp118_;
					ValaExpression* _tmp119_;
					_size_index = _size_index + 1;
					_tmp115_ = _size_index;
					_tmp116_ = _size_size;
					if (!(_tmp115_ < _tmp116_)) {
						break;
					}
					_tmp117_ = _size_list;
					_tmp118_ = vala_list_get ((ValaList*) _tmp117_, _size_index);
					size = (ValaExpression*) ((ValaLiteral*) _tmp118_);
					_tmp119_ = size;
					vala_array_creation_expression_append_size (self, _tmp119_);
					_vala_code_node_unref0 (size);
				}
			}
		}
	}
	_tmp120_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp121_ = _tmp120_;
	if (_tmp121_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp123_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp124_ = _tmp123_;
	if (_tmp124_ != NULL) {
		ValaInitializerList* _tmp125_;
		ValaInitializerList* _tmp126_;
		ValaDataType* _tmp127_;
		ValaDataType* _tmp128_;
		_tmp125_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp126_ = _tmp125_;
		_tmp127_ = vala_expression_get_value_type ((ValaExpression*) _tmp126_);
		_tmp128_ = _tmp127_;
		_tmp122_ = _tmp128_ == NULL;
	} else {
		_tmp122_ = FALSE;
	}
	if (_tmp122_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp129_ = vala_array_creation_expression_get_element_type (self);
	_tmp130_ = _tmp129_;
	if (_tmp130_ == NULL) {
		ValaSourceReference* _tmp131_;
		ValaSourceReference* _tmp132_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp132_ = _tmp131_;
		vala_report_error (_tmp132_, "Cannot determine the element type of the created array");
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp133_ = vala_array_creation_expression_get_element_type (self);
	_tmp134_ = _tmp133_;
	_tmp135_ = self->priv->_rank;
	_tmp136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp137_ = _tmp136_;
	_tmp138_ = vala_array_type_new (_tmp134_, _tmp135_, _tmp137_);
	_tmp139_ = _tmp138_;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp139_);
	_vala_code_node_unref0 (_tmp139_);
	_tmp140_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp141_ = _tmp140_;
	_tmp142_ = vala_array_creation_expression_get_length_type (self);
	_tmp143_ = _tmp142_;
	_tmp144_ = vala_data_type_copy (_tmp143_);
	_tmp145_ = _tmp144_;
	vala_array_type_set_length_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp141_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp145_);
	_vala_code_node_unref0 (_tmp145_);
	_tmp146_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
	_tmp147_ = _tmp146_;
	if (VALA_IS_ARRAY_TYPE (_tmp147_)) {
		ValaDataType* _tmp148_;
		ValaDataType* _tmp149_;
		ValaDataType* _tmp150_;
		ValaDataType* _tmp151_;
		gboolean _tmp152_;
		gboolean _tmp153_;
		ValaDataType* _tmp154_;
		ValaDataType* _tmp155_;
		ValaDataType* _tmp156_;
		ValaDataType* _tmp157_;
		gboolean _tmp158_;
		gboolean _tmp159_;
		_tmp148_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		_tmp153_ = _tmp152_;
		vala_array_type_set_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp149_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp153_);
		_tmp154_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp155_ = _tmp154_;
		_tmp156_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp157_ = _tmp156_;
		_tmp158_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp157_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		_tmp159_ = _tmp158_;
		vala_array_type_set_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp155_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp159_);
	}
	_tmp160_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp161_ = _tmp160_;
	vala_data_type_set_value_owned (_tmp161_, TRUE);
	_tmp162_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp163_ = _tmp162_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp163_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp164_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp165_ = _tmp164_;
	result = !_tmp165_;
	_vala_iterable_unref0 (calc_sizes);
	_vala_code_node_unref0 (initlist);
	_vala_iterable_unref0 (sizes);
	return result;
}

static void
vala_array_creation_expression_real_emit (ValaCodeNode* base,
                                          ValaCodeGenerator* codegen)
{
	ValaArrayCreationExpression * self;
	ValaInitializerList* _tmp9_;
	ValaInitializerList* _tmp10_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		gint _e_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_e_list = _tmp0_;
		_tmp1_ = _e_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_e_size = _tmp3_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* e = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_e_index = _e_index + 1;
			_tmp4_ = _e_index;
			_tmp5_ = _e_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _e_list;
			_tmp7_ = vala_list_get (_tmp6_, _e_index);
			e = (ValaExpression*) _tmp7_;
			_tmp8_ = e;
			vala_code_node_emit ((ValaCodeNode*) _tmp8_, codegen);
			_vala_code_node_unref0 (e);
		}
	}
	_tmp9_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaInitializerList* _tmp11_;
		ValaInitializerList* _tmp12_;
		_tmp11_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp12_ = _tmp11_;
		vala_code_node_emit ((ValaCodeNode*) _tmp12_, codegen);
	}
	vala_code_visitor_visit_array_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_array_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                        ValaCollection* collection)
{
	ValaArrayCreationExpression * self;
	ValaInitializerList* _tmp9_;
	ValaInitializerList* _tmp10_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		gint _e_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_e_list = _tmp0_;
		_tmp1_ = _e_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_e_size = _tmp3_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* e = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_e_index = _e_index + 1;
			_tmp4_ = _e_index;
			_tmp5_ = _e_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _e_list;
			_tmp7_ = vala_list_get (_tmp6_, _e_index);
			e = (ValaExpression*) _tmp7_;
			_tmp8_ = e;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (e);
		}
	}
	_tmp9_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaInitializerList* _tmp11_;
		ValaInitializerList* _tmp12_;
		_tmp11_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp12_ = _tmp11_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp12_, collection);
	}
}

static void
vala_array_creation_expression_class_init (ValaArrayCreationExpressionClass * klass,
                                           gpointer klass_data)
{
	vala_array_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_array_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaArrayCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_array_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_array_creation_expression_real_accept;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_array_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_array_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_array_creation_expression_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_array_creation_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_array_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_array_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_array_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_array_creation_expression_real_get_used_variables;
}

static void
vala_array_creation_expression_instance_init (ValaArrayCreationExpression * self,
                                              gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_array_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->sizes = (ValaList*) _tmp1_;
}

static void
vala_array_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaArrayCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression);
	_vala_iterable_unref0 (self->priv->sizes);
	_vala_code_node_unref0 (self->priv->_element_type);
	_vala_code_node_unref0 (self->priv->_length_type);
	_vala_code_node_unref0 (self->priv->_initializer_list);
	VALA_CODE_NODE_CLASS (vala_array_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an array creation expression.
 *
 * {{{ new int[] { 1, 2, 3 } }}}
 */
static GType
vala_array_creation_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaArrayCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayCreationExpression), 0, (GInstanceInitFunc) vala_array_creation_expression_instance_init, NULL };
	GType vala_array_creation_expression_type_id;
	vala_array_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaArrayCreationExpression", &g_define_type_info, 0);
	ValaArrayCreationExpression_private_offset = g_type_add_instance_private (vala_array_creation_expression_type_id, sizeof (ValaArrayCreationExpressionPrivate));
	return vala_array_creation_expression_type_id;
}

GType
vala_array_creation_expression_get_type (void)
{
	static volatile gsize vala_array_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_array_creation_expression_type_id__volatile)) {
		GType vala_array_creation_expression_type_id;
		vala_array_creation_expression_type_id = vala_array_creation_expression_get_type_once ();
		g_once_init_leave (&vala_array_creation_expression_type_id__volatile, vala_array_creation_expression_type_id);
	}
	return vala_array_creation_expression_type_id__volatile;
}

