/* valainterface.c generated by valac, the Vala compiler
 * generated from valainterface.vala, do not modify */

/* valainterface.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaInterfacePrivate {
	ValaList* prerequisites;
	ValaList* virtuals;
};

static gint ValaInterface_private_offset;
static gpointer vala_interface_parent_class = NULL;

static void vala_interface_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static void vala_interface_real_add_property (ValaSymbol* base,
                                       ValaProperty* prop);
static ValaList* vala_interface_real_get_virtuals (ValaInterface* self);
static void vala_interface_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_interface_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                            ValaTypeSymbol* t);
static void vala_interface_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_interface_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static void vala_interface_finalize (ValaCodeNode * obj);
static GType vala_interface_get_type_once (void);

static inline gpointer
vala_interface_get_instance_private (ValaInterface* self)
{
	return G_STRUCT_MEMBER_P (self, ValaInterface_private_offset);
}

/**
 * Creates a new interface.
 *
 * @param name              type name
 * @param source_reference  reference to source code
 * @return                  newly created interface
 */
ValaInterface*
vala_interface_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	ValaInterface* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaInterface*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaInterface*
vala_interface_new (const gchar* name,
                    ValaSourceReference* source_reference,
                    ValaComment* comment)
{
	return vala_interface_construct (VALA_TYPE_INTERFACE, name, source_reference, comment);
}

/**
 * Adds the specified interface or class to the list of prerequisites of
 * this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_add_prerequisite (ValaInterface* self,
                                 ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_interface_get_prerequisites (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prerequisites;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified method as a member to this interface.
 *
 * @param m a method
 */
static void
vala_interface_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaInterface * self;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp16_ = FALSE;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	self = (ValaInterface*) base;
	g_return_if_fail (m != NULL);
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp2_ = vala_method_get_binding (m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp4_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		vala_method_set_this_parameter (m, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp5_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_method_get_this_parameter (m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_method_get_this_parameter (m);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp17_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp18_ = _tmp17_;
	if (!VALA_IS_VOID_TYPE (_tmp18_)) {
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp19_ = vala_method_get_postconditions (m);
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp16_ = _tmp21_ > 0;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaLocalVariable* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		_tmp22_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_data_type_copy (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_local_variable_new (_tmp25_, "result", NULL, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp31_ = _tmp30_;
		vala_local_variable_set_is_result (_tmp31_, TRUE);
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

/**
 * Adds the specified property as a member to this interface.
 *
 * @param prop a property
 */
static void
vala_interface_real_add_property (ValaSymbol* base,
                                  ValaProperty* prop)
{
	ValaInterface * self;
	ValaField* _tmp0_;
	ValaField* _tmp1_;
	ValaMemberBinding _tmp4_;
	ValaMemberBinding _tmp5_;
	self = (ValaInterface*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_property_get_field (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "interface properties should be `abstract' or have `get' accessor and/o" \
"r `set' mutator");
		vala_code_node_set_error ((ValaCodeNode*) prop, TRUE);
		return;
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp4_ = vala_property_get_binding (prop);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaParameter* _tmp8_;
		ValaParameter* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaParameter* _tmp12_;
		ValaParameter* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		_tmp6_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_parameter_new ("this", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		vala_property_set_this_parameter (prop, _tmp9_);
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_node_unref0 (_tmp7_);
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_property_get_this_parameter (prop);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_property_get_this_parameter (prop);
		_tmp17_ = _tmp16_;
		vala_scope_add (_tmp11_, _tmp15_, (ValaSymbol*) _tmp17_);
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static ValaList*
vala_interface_real_get_virtuals (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	_tmp0_ = self->priv->virtuals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

ValaList*
vala_interface_get_virtuals (ValaInterface* self)
{
	ValaInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_INTERFACE_GET_CLASS (self);
	if (_klass_->get_virtuals) {
		return _klass_->get_virtuals (self);
	}
	return NULL;
}

static void
vala_interface_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_interface (visitor, self);
}

static void
vala_interface_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			_type_index = _type_index + 1;
			_tmp4_ = _type_index;
			_tmp5_ = _type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _type_list;
			_tmp7_ = vala_list_get (_tmp6_, _type_index);
			type = (ValaDataType*) _tmp7_;
			_tmp8_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (type);
		}
	}
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
}

static gboolean
vala_interface_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                   ValaTypeSymbol* t)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _prerequisite_list = NULL;
		ValaList* _tmp0_;
		gint _prerequisite_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prerequisite_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_prerequisite_list = _tmp0_;
		_tmp1_ = _prerequisite_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prerequisite_size = _tmp3_;
		_prerequisite_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* prerequisite = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_prerequisite_index = _prerequisite_index + 1;
			_tmp4_ = _prerequisite_index;
			_tmp5_ = _prerequisite_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _prerequisite_list;
			_tmp7_ = vala_list_get (_tmp6_, _prerequisite_index);
			prerequisite = (ValaDataType*) _tmp7_;
			_tmp9_ = prerequisite;
			_tmp10_ = vala_data_type_get_type_symbol (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaDataType* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				_tmp12_ = prerequisite;
				_tmp13_ = vala_data_type_get_type_symbol (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = vala_typesymbol_is_subtype_of (_tmp14_, t);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (prerequisite);
				return result;
			}
			_vala_code_node_unref0 (prerequisite);
		}
	}
	result = FALSE;
	return result;
}

static void
vala_interface_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->prerequisites;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->prerequisites;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->prerequisites;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_interface_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaInterface * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaClass* prereq_class = NULL;
	gboolean _tmp126_;
	gboolean _tmp127_;
	ValaMap* positions = NULL;
	GHashFunc _tmp257_;
	GEqualFunc _tmp258_;
	GEqualFunc _tmp259_;
	ValaHashMap* _tmp260_;
	gboolean ordered_seen = FALSE;
	gboolean unordered_seen = FALSE;
	ValaSemanticAnalyzer* _tmp325_;
	ValaSemanticAnalyzer* _tmp326_;
	ValaSourceFile* _tmp327_;
	ValaSemanticAnalyzer* _tmp328_;
	ValaSemanticAnalyzer* _tmp329_;
	ValaSymbol* _tmp330_;
	gboolean _tmp331_;
	gboolean _tmp332_;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	if (!VALA_CODE_NODE_CLASS (vala_interface_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), context)) {
		result = FALSE;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _prerequisite_reference_list = NULL;
		ValaList* _tmp24_;
		gint _prerequisite_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _prerequisite_reference_index = 0;
		_tmp24_ = vala_interface_get_prerequisites (self);
		_prerequisite_reference_list = _tmp24_;
		_tmp25_ = _prerequisite_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_prerequisite_reference_size = _tmp27_;
		_prerequisite_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaDataType* prerequisite_reference = NULL;
			ValaList* _tmp30_;
			gpointer _tmp31_;
			ValaSemanticAnalyzer* _tmp32_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaDataType* _tmp34_;
			_prerequisite_reference_index = _prerequisite_reference_index + 1;
			_tmp28_ = _prerequisite_reference_index;
			_tmp29_ = _prerequisite_reference_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _prerequisite_reference_list;
			_tmp31_ = vala_list_get (_tmp30_, _prerequisite_reference_index);
			prerequisite_reference = (ValaDataType*) _tmp31_;
			_tmp32_ = vala_code_context_get_analyzer (context);
			_tmp33_ = _tmp32_;
			_tmp34_ = prerequisite_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp33_, (ValaSymbol*) self, _tmp34_)) {
				ValaSourceReference* _tmp35_;
				ValaSourceReference* _tmp36_;
				ValaDataType* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp36_ = _tmp35_;
				_tmp37_ = prerequisite_reference;
				_tmp38_ = vala_code_node_to_string ((ValaCodeNode*) _tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp41_ = _tmp40_;
				vala_report_error (_tmp36_, "prerequisite `%s' is less accessible than interface `%s'", _tmp39_, _tmp41_);
				_g_free0 (_tmp41_);
				_g_free0 (_tmp39_);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (prerequisite_reference);
		}
	}
	prereq_class = NULL;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp42_;
		gint _prereq_size = 0;
		ValaList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _prereq_index = 0;
		_tmp42_ = vala_interface_get_prerequisites (self);
		_prereq_list = _tmp42_;
		_tmp43_ = _prereq_list;
		_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_prereq_size = _tmp45_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp46_;
			gint _tmp47_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp48_;
			gpointer _tmp49_;
			ValaDataType* _tmp50_;
			ValaDataType* _tmp58_;
			ValaTypeSymbol* _tmp59_;
			ValaTypeSymbol* _tmp60_;
			_prereq_index = _prereq_index + 1;
			_tmp46_ = _prereq_index;
			_tmp47_ = _prereq_size;
			if (!(_tmp46_ < _tmp47_)) {
				break;
			}
			_tmp48_ = _prereq_list;
			_tmp49_ = vala_list_get (_tmp48_, _prereq_index);
			prereq = (ValaDataType*) _tmp49_;
			_tmp50_ = prereq;
			if (!VALA_IS_OBJECT_TYPE (_tmp50_)) {
				ValaSourceReference* _tmp51_;
				ValaSourceReference* _tmp52_;
				ValaDataType* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp52_ = _tmp51_;
				_tmp53_ = prereq;
				_tmp54_ = vala_code_node_to_string ((ValaCodeNode*) _tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp57_ = _tmp56_;
				vala_report_error (_tmp52_, "Prerequisite `%s' of interface `%s' is not a class or interface", _tmp55_, _tmp57_);
				_g_free0 (_tmp57_);
				_g_free0 (_tmp55_);
				result = FALSE;
				_vala_code_node_unref0 (prereq);
				_vala_code_node_unref0 (prereq_class);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp58_ = prereq;
			_tmp59_ = vala_data_type_get_type_symbol (_tmp58_);
			_tmp60_ = _tmp59_;
			if (VALA_IS_CLASS (_tmp60_)) {
				ValaClass* _tmp61_;
				ValaDataType* _tmp74_;
				ValaTypeSymbol* _tmp75_;
				ValaTypeSymbol* _tmp76_;
				ValaClass* _tmp77_;
				_tmp61_ = prereq_class;
				if (_tmp61_ != NULL) {
					ValaSourceReference* _tmp62_;
					ValaSourceReference* _tmp63_;
					gchar* _tmp64_;
					gchar* _tmp65_;
					ValaDataType* _tmp66_;
					ValaTypeSymbol* _tmp67_;
					ValaTypeSymbol* _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					ValaClass* _tmp71_;
					gchar* _tmp72_;
					gchar* _tmp73_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp63_ = _tmp62_;
					_tmp64_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp65_ = _tmp64_;
					_tmp66_ = prereq;
					_tmp67_ = vala_data_type_get_type_symbol (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = prereq_class;
					_tmp72_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp71_);
					_tmp73_ = _tmp72_;
					vala_report_error (_tmp63_, "%s: Interfaces cannot have multiple instantiable prerequisites (`%s' a" \
"nd `%s')", _tmp65_, _tmp70_, _tmp73_);
					_g_free0 (_tmp73_);
					_g_free0 (_tmp70_);
					_g_free0 (_tmp65_);
					result = FALSE;
					_vala_code_node_unref0 (prereq);
					_vala_code_node_unref0 (prereq_class);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_tmp74_ = prereq;
				_tmp75_ = vala_data_type_get_type_symbol (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (prereq_class);
				prereq_class = _tmp77_;
			}
			_vala_code_node_unref0 (prereq);
		}
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp78_;
		gint _type_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _type_index = 0;
		_tmp78_ = self->priv->prerequisites;
		_type_list = _tmp78_;
		_tmp79_ = _type_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_type_size = _tmp81_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			ValaDataType* type = NULL;
			ValaList* _tmp84_;
			gpointer _tmp85_;
			ValaDataType* _tmp86_;
			ValaSemanticAnalyzer* _tmp87_;
			ValaSemanticAnalyzer* _tmp88_;
			ValaDataType* _tmp89_;
			_type_index = _type_index + 1;
			_tmp82_ = _type_index;
			_tmp83_ = _type_size;
			if (!(_tmp82_ < _tmp83_)) {
				break;
			}
			_tmp84_ = _type_list;
			_tmp85_ = vala_list_get (_tmp84_, _type_index);
			type = (ValaDataType*) _tmp85_;
			_tmp86_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp86_, context);
			_tmp87_ = vala_code_context_get_analyzer (context);
			_tmp88_ = _tmp87_;
			_tmp89_ = type;
			vala_semantic_analyzer_check_type (_tmp88_, _tmp89_);
			_vala_code_node_unref0 (type);
		}
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp90_;
		gint _p_size = 0;
		ValaList* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		gint _p_index = 0;
		_tmp90_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp90_;
		_tmp91_ = _p_list;
		_tmp92_ = vala_collection_get_size ((ValaCollection*) _tmp91_);
		_tmp93_ = _tmp92_;
		_p_size = _tmp93_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp94_;
			gint _tmp95_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp96_;
			gpointer _tmp97_;
			ValaTypeParameter* _tmp98_;
			_p_index = _p_index + 1;
			_tmp94_ = _p_index;
			_tmp95_ = _p_size;
			if (!(_tmp94_ < _tmp95_)) {
				break;
			}
			_tmp96_ = _p_list;
			_tmp97_ = vala_list_get (_tmp96_, _p_index);
			p = (ValaTypeParameter*) _tmp97_;
			_tmp98_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp98_, context);
			_vala_code_node_unref0 (p);
		}
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp99_;
		gint _en_size = 0;
		ValaList* _tmp100_;
		gint _tmp101_;
		gint _tmp102_;
		gint _en_index = 0;
		_tmp99_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp99_;
		_tmp100_ = _en_list;
		_tmp101_ = vala_collection_get_size ((ValaCollection*) _tmp100_);
		_tmp102_ = _tmp101_;
		_en_size = _tmp102_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp103_;
			gint _tmp104_;
			ValaEnum* en = NULL;
			ValaList* _tmp105_;
			gpointer _tmp106_;
			ValaEnum* _tmp107_;
			_en_index = _en_index + 1;
			_tmp103_ = _en_index;
			_tmp104_ = _en_size;
			if (!(_tmp103_ < _tmp104_)) {
				break;
			}
			_tmp105_ = _en_list;
			_tmp106_ = vala_list_get (_tmp105_, _en_index);
			en = (ValaEnum*) _tmp106_;
			_tmp107_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp107_, context);
			_vala_code_node_unref0 (en);
		}
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp108_;
		gint _f_size = 0;
		ValaList* _tmp109_;
		gint _tmp110_;
		gint _tmp111_;
		gint _f_index = 0;
		_tmp108_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp108_;
		_tmp109_ = _f_list;
		_tmp110_ = vala_collection_get_size ((ValaCollection*) _tmp109_);
		_tmp111_ = _tmp110_;
		_f_size = _tmp111_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp112_;
			gint _tmp113_;
			ValaField* f = NULL;
			ValaList* _tmp114_;
			gpointer _tmp115_;
			ValaField* _tmp116_;
			_f_index = _f_index + 1;
			_tmp112_ = _f_index;
			_tmp113_ = _f_size;
			if (!(_tmp112_ < _tmp113_)) {
				break;
			}
			_tmp114_ = _f_list;
			_tmp115_ = vala_list_get (_tmp114_, _f_index);
			f = (ValaField*) _tmp115_;
			_tmp116_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp116_, context);
			_vala_code_node_unref0 (f);
		}
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp117_;
		gint _c_size = 0;
		ValaList* _tmp118_;
		gint _tmp119_;
		gint _tmp120_;
		gint _c_index = 0;
		_tmp117_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp117_;
		_tmp118_ = _c_list;
		_tmp119_ = vala_collection_get_size ((ValaCollection*) _tmp118_);
		_tmp120_ = _tmp119_;
		_c_size = _tmp120_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp121_;
			gint _tmp122_;
			ValaConstant* c = NULL;
			ValaList* _tmp123_;
			gpointer _tmp124_;
			ValaConstant* _tmp125_;
			_c_index = _c_index + 1;
			_tmp121_ = _c_index;
			_tmp122_ = _c_size;
			if (!(_tmp121_ < _tmp122_)) {
				break;
			}
			_tmp123_ = _c_list;
			_tmp124_ = vala_list_get (_tmp123_, _c_index);
			c = (ValaConstant*) _tmp124_;
			_tmp125_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp125_, context);
			_vala_code_node_unref0 (c);
		}
	}
	_tmp126_ = vala_code_context_get_abi_stability (context);
	_tmp127_ = _tmp126_;
	if (_tmp127_) {
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp128_;
			gint _s_size = 0;
			ValaList* _tmp129_;
			gint _tmp130_;
			gint _tmp131_;
			gint _s_index = 0;
			_tmp128_ = vala_object_type_symbol_get_members ((ValaObjectTypeSymbol*) self);
			_s_list = _tmp128_;
			_tmp129_ = _s_list;
			_tmp130_ = vala_collection_get_size ((ValaCollection*) _tmp129_);
			_tmp131_ = _tmp130_;
			_s_size = _tmp131_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp132_;
				gint _tmp133_;
				ValaSymbol* s = NULL;
				ValaList* _tmp134_;
				gpointer _tmp135_;
				ValaSymbol* _tmp136_;
				_s_index = _s_index + 1;
				_tmp132_ = _s_index;
				_tmp133_ = _s_size;
				if (!(_tmp132_ < _tmp133_)) {
					break;
				}
				_tmp134_ = _s_list;
				_tmp135_ = vala_list_get (_tmp134_, _s_index);
				s = (ValaSymbol*) _tmp135_;
				_tmp136_ = s;
				if (VALA_IS_METHOD (_tmp136_)) {
					ValaMethod* m = NULL;
					ValaSymbol* _tmp137_;
					ValaMethod* _tmp138_;
					ValaMethod* _tmp139_;
					gboolean _tmp140_ = FALSE;
					ValaMethod* _tmp141_;
					gboolean _tmp142_;
					gboolean _tmp143_;
					_tmp137_ = s;
					_tmp138_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp137_, VALA_TYPE_METHOD, ValaMethod));
					m = _tmp138_;
					_tmp139_ = m;
					vala_code_node_check ((ValaCodeNode*) _tmp139_, context);
					_tmp141_ = m;
					_tmp142_ = vala_method_get_is_virtual (_tmp141_);
					_tmp143_ = _tmp142_;
					if (_tmp143_) {
						_tmp140_ = TRUE;
					} else {
						ValaMethod* _tmp144_;
						gboolean _tmp145_;
						gboolean _tmp146_;
						_tmp144_ = m;
						_tmp145_ = vala_method_get_is_abstract (_tmp144_);
						_tmp146_ = _tmp145_;
						_tmp140_ = _tmp146_;
					}
					if (_tmp140_) {
						ValaList* _tmp147_;
						ValaMethod* _tmp148_;
						_tmp147_ = self->priv->virtuals;
						_tmp148_ = m;
						vala_collection_add ((ValaCollection*) _tmp147_, (ValaSymbol*) _tmp148_);
					}
					_vala_code_node_unref0 (m);
				} else {
					ValaSymbol* _tmp149_;
					_tmp149_ = s;
					if (VALA_IS_SIGNAL (_tmp149_)) {
						ValaSignal* sig = NULL;
						ValaSymbol* _tmp150_;
						ValaSignal* _tmp151_;
						ValaSignal* _tmp152_;
						ValaSignal* _tmp153_;
						gboolean _tmp154_;
						gboolean _tmp155_;
						_tmp150_ = s;
						_tmp151_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp150_, VALA_TYPE_SIGNAL, ValaSignal));
						sig = _tmp151_;
						_tmp152_ = sig;
						vala_code_node_check ((ValaCodeNode*) _tmp152_, context);
						_tmp153_ = sig;
						_tmp154_ = vala_signal_get_is_virtual (_tmp153_);
						_tmp155_ = _tmp154_;
						if (_tmp155_) {
							ValaList* _tmp156_;
							ValaSignal* _tmp157_;
							_tmp156_ = self->priv->virtuals;
							_tmp157_ = sig;
							vala_collection_add ((ValaCollection*) _tmp156_, (ValaSymbol*) _tmp157_);
						}
						_vala_code_node_unref0 (sig);
					} else {
						ValaSymbol* _tmp158_;
						_tmp158_ = s;
						if (VALA_IS_PROPERTY (_tmp158_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp159_;
							ValaProperty* _tmp160_;
							ValaProperty* _tmp161_;
							gboolean _tmp162_ = FALSE;
							ValaProperty* _tmp163_;
							gboolean _tmp164_;
							gboolean _tmp165_;
							_tmp159_ = s;
							_tmp160_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp159_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp160_;
							_tmp161_ = prop;
							vala_code_node_check ((ValaCodeNode*) _tmp161_, context);
							_tmp163_ = prop;
							_tmp164_ = vala_property_get_is_virtual (_tmp163_);
							_tmp165_ = _tmp164_;
							if (_tmp165_) {
								_tmp162_ = TRUE;
							} else {
								ValaProperty* _tmp166_;
								gboolean _tmp167_;
								gboolean _tmp168_;
								_tmp166_ = prop;
								_tmp167_ = vala_property_get_is_abstract (_tmp166_);
								_tmp168_ = _tmp167_;
								_tmp162_ = _tmp168_;
							}
							if (_tmp162_) {
								ValaList* _tmp169_;
								ValaProperty* _tmp170_;
								_tmp169_ = self->priv->virtuals;
								_tmp170_ = prop;
								vala_collection_add ((ValaCollection*) _tmp169_, (ValaSymbol*) _tmp170_);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (s);
			}
		}
	} else {
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp171_;
			gint _m_size = 0;
			ValaList* _tmp172_;
			gint _tmp173_;
			gint _tmp174_;
			gint _m_index = 0;
			_tmp171_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
			_m_list = _tmp171_;
			_tmp172_ = _m_list;
			_tmp173_ = vala_collection_get_size ((ValaCollection*) _tmp172_);
			_tmp174_ = _tmp173_;
			_m_size = _tmp174_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp175_;
				gint _tmp176_;
				ValaMethod* m = NULL;
				ValaList* _tmp177_;
				gpointer _tmp178_;
				ValaMethod* _tmp179_;
				gboolean _tmp180_ = FALSE;
				ValaMethod* _tmp181_;
				gboolean _tmp182_;
				gboolean _tmp183_;
				_m_index = _m_index + 1;
				_tmp175_ = _m_index;
				_tmp176_ = _m_size;
				if (!(_tmp175_ < _tmp176_)) {
					break;
				}
				_tmp177_ = _m_list;
				_tmp178_ = vala_list_get (_tmp177_, _m_index);
				m = (ValaMethod*) _tmp178_;
				_tmp179_ = m;
				vala_code_node_check ((ValaCodeNode*) _tmp179_, context);
				_tmp181_ = m;
				_tmp182_ = vala_method_get_is_virtual (_tmp181_);
				_tmp183_ = _tmp182_;
				if (_tmp183_) {
					_tmp180_ = TRUE;
				} else {
					ValaMethod* _tmp184_;
					gboolean _tmp185_;
					gboolean _tmp186_;
					_tmp184_ = m;
					_tmp185_ = vala_method_get_is_abstract (_tmp184_);
					_tmp186_ = _tmp185_;
					_tmp180_ = _tmp186_;
				}
				if (_tmp180_) {
					ValaList* _tmp187_;
					ValaMethod* _tmp188_;
					_tmp187_ = self->priv->virtuals;
					_tmp188_ = m;
					vala_collection_add ((ValaCollection*) _tmp187_, (ValaSymbol*) _tmp188_);
				}
				_vala_code_node_unref0 (m);
			}
		}
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp189_;
			gint _sig_size = 0;
			ValaList* _tmp190_;
			gint _tmp191_;
			gint _tmp192_;
			gint _sig_index = 0;
			_tmp189_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
			_sig_list = _tmp189_;
			_tmp190_ = _sig_list;
			_tmp191_ = vala_collection_get_size ((ValaCollection*) _tmp190_);
			_tmp192_ = _tmp191_;
			_sig_size = _tmp192_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp193_;
				gint _tmp194_;
				ValaSignal* sig = NULL;
				ValaList* _tmp195_;
				gpointer _tmp196_;
				ValaSignal* _tmp197_;
				ValaSignal* _tmp198_;
				gboolean _tmp199_;
				gboolean _tmp200_;
				_sig_index = _sig_index + 1;
				_tmp193_ = _sig_index;
				_tmp194_ = _sig_size;
				if (!(_tmp193_ < _tmp194_)) {
					break;
				}
				_tmp195_ = _sig_list;
				_tmp196_ = vala_list_get (_tmp195_, _sig_index);
				sig = (ValaSignal*) _tmp196_;
				_tmp197_ = sig;
				vala_code_node_check ((ValaCodeNode*) _tmp197_, context);
				_tmp198_ = sig;
				_tmp199_ = vala_signal_get_is_virtual (_tmp198_);
				_tmp200_ = _tmp199_;
				if (_tmp200_) {
					ValaList* _tmp201_;
					ValaSignal* _tmp202_;
					_tmp201_ = self->priv->virtuals;
					_tmp202_ = sig;
					vala_collection_add ((ValaCollection*) _tmp201_, (ValaSymbol*) _tmp202_);
				}
				_vala_code_node_unref0 (sig);
			}
		}
		{
			ValaList* _prop_list = NULL;
			ValaList* _tmp203_;
			gint _prop_size = 0;
			ValaList* _tmp204_;
			gint _tmp205_;
			gint _tmp206_;
			gint _prop_index = 0;
			_tmp203_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
			_prop_list = _tmp203_;
			_tmp204_ = _prop_list;
			_tmp205_ = vala_collection_get_size ((ValaCollection*) _tmp204_);
			_tmp206_ = _tmp205_;
			_prop_size = _tmp206_;
			_prop_index = -1;
			while (TRUE) {
				gint _tmp207_;
				gint _tmp208_;
				ValaProperty* prop = NULL;
				ValaList* _tmp209_;
				gpointer _tmp210_;
				ValaProperty* _tmp211_;
				gboolean _tmp212_ = FALSE;
				ValaProperty* _tmp213_;
				gboolean _tmp214_;
				gboolean _tmp215_;
				_prop_index = _prop_index + 1;
				_tmp207_ = _prop_index;
				_tmp208_ = _prop_size;
				if (!(_tmp207_ < _tmp208_)) {
					break;
				}
				_tmp209_ = _prop_list;
				_tmp210_ = vala_list_get (_tmp209_, _prop_index);
				prop = (ValaProperty*) _tmp210_;
				_tmp211_ = prop;
				vala_code_node_check ((ValaCodeNode*) _tmp211_, context);
				_tmp213_ = prop;
				_tmp214_ = vala_property_get_is_virtual (_tmp213_);
				_tmp215_ = _tmp214_;
				if (_tmp215_) {
					_tmp212_ = TRUE;
				} else {
					ValaProperty* _tmp216_;
					gboolean _tmp217_;
					gboolean _tmp218_;
					_tmp216_ = prop;
					_tmp217_ = vala_property_get_is_abstract (_tmp216_);
					_tmp218_ = _tmp217_;
					_tmp212_ = _tmp218_;
				}
				if (_tmp212_) {
					ValaList* _tmp219_;
					ValaProperty* _tmp220_;
					_tmp219_ = self->priv->virtuals;
					_tmp220_ = prop;
					vala_collection_add ((ValaCollection*) _tmp219_, (ValaSymbol*) _tmp220_);
				}
				_vala_code_node_unref0 (prop);
			}
		}
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp221_;
		gint _cl_size = 0;
		ValaList* _tmp222_;
		gint _tmp223_;
		gint _tmp224_;
		gint _cl_index = 0;
		_tmp221_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp221_;
		_tmp222_ = _cl_list;
		_tmp223_ = vala_collection_get_size ((ValaCollection*) _tmp222_);
		_tmp224_ = _tmp223_;
		_cl_size = _tmp224_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp225_;
			gint _tmp226_;
			ValaClass* cl = NULL;
			ValaList* _tmp227_;
			gpointer _tmp228_;
			ValaClass* _tmp229_;
			_cl_index = _cl_index + 1;
			_tmp225_ = _cl_index;
			_tmp226_ = _cl_size;
			if (!(_tmp225_ < _tmp226_)) {
				break;
			}
			_tmp227_ = _cl_list;
			_tmp228_ = vala_list_get (_tmp227_, _cl_index);
			cl = (ValaClass*) _tmp228_;
			_tmp229_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp229_, context);
			_vala_code_node_unref0 (cl);
		}
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp230_;
		gint _iface_size = 0;
		ValaList* _tmp231_;
		gint _tmp232_;
		gint _tmp233_;
		gint _iface_index = 0;
		_tmp230_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_iface_list = _tmp230_;
		_tmp231_ = _iface_list;
		_tmp232_ = vala_collection_get_size ((ValaCollection*) _tmp231_);
		_tmp233_ = _tmp232_;
		_iface_size = _tmp233_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp234_;
			gint _tmp235_;
			ValaInterface* iface = NULL;
			ValaList* _tmp236_;
			gpointer _tmp237_;
			ValaInterface* _tmp238_;
			_iface_index = _iface_index + 1;
			_tmp234_ = _iface_index;
			_tmp235_ = _iface_size;
			if (!(_tmp234_ < _tmp235_)) {
				break;
			}
			_tmp236_ = _iface_list;
			_tmp237_ = vala_list_get (_tmp236_, _iface_index);
			iface = (ValaInterface*) _tmp237_;
			_tmp238_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp238_, context);
			_vala_code_node_unref0 (iface);
		}
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp239_;
		gint _st_size = 0;
		ValaList* _tmp240_;
		gint _tmp241_;
		gint _tmp242_;
		gint _st_index = 0;
		_tmp239_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp239_;
		_tmp240_ = _st_list;
		_tmp241_ = vala_collection_get_size ((ValaCollection*) _tmp240_);
		_tmp242_ = _tmp241_;
		_st_size = _tmp242_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp243_;
			gint _tmp244_;
			ValaStruct* st = NULL;
			ValaList* _tmp245_;
			gpointer _tmp246_;
			ValaStruct* _tmp247_;
			_st_index = _st_index + 1;
			_tmp243_ = _st_index;
			_tmp244_ = _st_size;
			if (!(_tmp243_ < _tmp244_)) {
				break;
			}
			_tmp245_ = _st_list;
			_tmp246_ = vala_list_get (_tmp245_, _st_index);
			st = (ValaStruct*) _tmp246_;
			_tmp247_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp247_, context);
			_vala_code_node_unref0 (st);
		}
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp248_;
		gint _d_size = 0;
		ValaList* _tmp249_;
		gint _tmp250_;
		gint _tmp251_;
		gint _d_index = 0;
		_tmp248_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp248_;
		_tmp249_ = _d_list;
		_tmp250_ = vala_collection_get_size ((ValaCollection*) _tmp249_);
		_tmp251_ = _tmp250_;
		_d_size = _tmp251_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp252_;
			gint _tmp253_;
			ValaDelegate* d = NULL;
			ValaList* _tmp254_;
			gpointer _tmp255_;
			ValaDelegate* _tmp256_;
			_d_index = _d_index + 1;
			_tmp252_ = _d_index;
			_tmp253_ = _d_size;
			if (!(_tmp252_ < _tmp253_)) {
				break;
			}
			_tmp254_ = _d_list;
			_tmp255_ = vala_list_get (_tmp254_, _d_index);
			d = (ValaDelegate*) _tmp255_;
			_tmp256_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp256_, context);
			_vala_code_node_unref0 (d);
		}
	}
	_tmp257_ = g_direct_hash;
	_tmp258_ = g_direct_equal;
	_tmp259_ = g_direct_equal;
	_tmp260_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp257_, _tmp258_, _tmp259_);
	positions = (ValaMap*) _tmp260_;
	ordered_seen = FALSE;
	unordered_seen = FALSE;
	{
		ValaList* _sym_list = NULL;
		ValaList* _tmp261_;
		gint _sym_size = 0;
		ValaList* _tmp262_;
		gint _tmp263_;
		gint _tmp264_;
		gint _sym_index = 0;
		_tmp261_ = self->priv->virtuals;
		_sym_list = _tmp261_;
		_tmp262_ = _sym_list;
		_tmp263_ = vala_collection_get_size ((ValaCollection*) _tmp262_);
		_tmp264_ = _tmp263_;
		_sym_size = _tmp264_;
		_sym_index = -1;
		while (TRUE) {
			gint _tmp265_;
			gint _tmp266_;
			ValaSymbol* sym = NULL;
			ValaList* _tmp267_;
			gpointer _tmp268_;
			gint ordering = 0;
			ValaSymbol* _tmp269_;
			gboolean ordered = FALSE;
			gboolean _tmp276_ = FALSE;
			gboolean _tmp277_ = FALSE;
			gboolean _tmp284_ = FALSE;
			gboolean _tmp285_ = FALSE;
			gboolean _tmp286_ = FALSE;
			gboolean _tmp293_ = FALSE;
			gboolean _tmp294_ = FALSE;
			_sym_index = _sym_index + 1;
			_tmp265_ = _sym_index;
			_tmp266_ = _sym_size;
			if (!(_tmp265_ < _tmp266_)) {
				break;
			}
			_tmp267_ = _sym_list;
			_tmp268_ = vala_list_get (_tmp267_, _sym_index);
			sym = (ValaSymbol*) _tmp268_;
			_tmp269_ = sym;
			ordering = vala_code_node_get_attribute_integer ((ValaCodeNode*) _tmp269_, "CCode", "ordering", -1);
			if (ordering < -1) {
				ValaSymbol* _tmp270_;
				ValaSourceReference* _tmp271_;
				ValaSourceReference* _tmp272_;
				ValaSymbol* _tmp273_;
				gchar* _tmp274_;
				gchar* _tmp275_;
				_tmp270_ = sym;
				_tmp271_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp270_);
				_tmp272_ = _tmp271_;
				_tmp273_ = sym;
				_tmp274_ = vala_symbol_get_full_name (_tmp273_);
				_tmp275_ = _tmp274_;
				vala_report_error (_tmp272_, "%s: Invalid ordering", _tmp275_);
				_g_free0 (_tmp275_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				ordered_seen = TRUE;
				unordered_seen = TRUE;
				_vala_code_node_unref0 (sym);
				continue;
			}
			ordered = ordering != -1;
			if (ordered) {
				_tmp277_ = unordered_seen;
			} else {
				_tmp277_ = FALSE;
			}
			if (_tmp277_) {
				_tmp276_ = !ordered_seen;
			} else {
				_tmp276_ = FALSE;
			}
			if (_tmp276_) {
				ValaSymbol* _tmp278_;
				ValaSourceReference* _tmp279_;
				ValaSourceReference* _tmp280_;
				ValaSymbol* _tmp281_;
				gchar* _tmp282_;
				gchar* _tmp283_;
				_tmp278_ = sym;
				_tmp279_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp278_);
				_tmp280_ = _tmp279_;
				_tmp281_ = sym;
				_tmp282_ = vala_symbol_get_full_name (_tmp281_);
				_tmp283_ = _tmp282_;
				vala_report_error (_tmp280_, "%s: Cannot mix ordered and unordered virtuals", _tmp283_);
				_g_free0 (_tmp283_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (ordered_seen) {
				_tmp284_ = TRUE;
			} else {
				_tmp284_ = ordered;
			}
			ordered_seen = _tmp284_;
			if (!ordered) {
				_tmp286_ = !unordered_seen;
			} else {
				_tmp286_ = FALSE;
			}
			if (_tmp286_) {
				_tmp285_ = ordered_seen;
			} else {
				_tmp285_ = FALSE;
			}
			if (_tmp285_) {
				ValaSymbol* _tmp287_;
				ValaSourceReference* _tmp288_;
				ValaSourceReference* _tmp289_;
				ValaSymbol* _tmp290_;
				gchar* _tmp291_;
				gchar* _tmp292_;
				_tmp287_ = sym;
				_tmp288_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp287_);
				_tmp289_ = _tmp288_;
				_tmp290_ = sym;
				_tmp291_ = vala_symbol_get_full_name (_tmp290_);
				_tmp292_ = _tmp291_;
				vala_report_error (_tmp289_, "%s: Cannot mix ordered and unordered virtuals", _tmp292_);
				_g_free0 (_tmp292_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (unordered_seen) {
				_tmp293_ = TRUE;
			} else {
				_tmp293_ = !ordered;
			}
			unordered_seen = _tmp293_;
			if (!ordered_seen) {
				_tmp294_ = TRUE;
			} else {
				_tmp294_ = !unordered_seen;
			}
			if (_tmp294_) {
				if (ordered) {
					ValaSymbol* prev = NULL;
					ValaMap* _tmp295_;
					gpointer _tmp296_;
					ValaSymbol* _tmp297_;
					ValaMap* _tmp307_;
					ValaSymbol* _tmp308_;
					_tmp295_ = positions;
					_tmp296_ = vala_map_get (_tmp295_, (gpointer) ((gintptr) ordering));
					prev = (ValaSymbol*) _tmp296_;
					_tmp297_ = prev;
					if (_tmp297_ != NULL) {
						ValaSymbol* _tmp298_;
						ValaSourceReference* _tmp299_;
						ValaSourceReference* _tmp300_;
						ValaSymbol* _tmp301_;
						gchar* _tmp302_;
						gchar* _tmp303_;
						ValaSymbol* _tmp304_;
						const gchar* _tmp305_;
						const gchar* _tmp306_;
						_tmp298_ = sym;
						_tmp299_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp298_);
						_tmp300_ = _tmp299_;
						_tmp301_ = sym;
						_tmp302_ = vala_symbol_get_full_name (_tmp301_);
						_tmp303_ = _tmp302_;
						_tmp304_ = prev;
						_tmp305_ = vala_symbol_get_name (_tmp304_);
						_tmp306_ = _tmp305_;
						vala_report_error (_tmp300_, "%s: Duplicate ordering (previous virtual with the same position is %s)", _tmp303_, _tmp306_);
						_g_free0 (_tmp303_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp307_ = positions;
					_tmp308_ = sym;
					vala_map_set (_tmp307_, (gpointer) ((gintptr) ordering), _tmp308_);
					_vala_code_node_unref0 (prev);
				}
			}
			_vala_code_node_unref0 (sym);
		}
	}
	if (ordered_seen) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp309_ = FALSE;
				_tmp309_ = TRUE;
				while (TRUE) {
					ValaList* _tmp311_;
					gint _tmp312_;
					gint _tmp313_;
					ValaSymbol* sym = NULL;
					ValaMap* _tmp314_;
					gpointer _tmp315_;
					ValaSymbol* _tmp316_;
					gboolean _tmp321_;
					gboolean _tmp322_;
					if (!_tmp309_) {
						gint _tmp310_;
						_tmp310_ = i;
						i = _tmp310_ + 1;
					}
					_tmp309_ = FALSE;
					_tmp311_ = self->priv->virtuals;
					_tmp312_ = vala_collection_get_size ((ValaCollection*) _tmp311_);
					_tmp313_ = _tmp312_;
					if (!(i < _tmp313_)) {
						break;
					}
					_tmp314_ = positions;
					_tmp315_ = vala_map_get (_tmp314_, (gpointer) ((gintptr) i));
					sym = (ValaSymbol*) _tmp315_;
					_tmp316_ = sym;
					if (_tmp316_ == NULL) {
						ValaSourceReference* _tmp317_;
						ValaSourceReference* _tmp318_;
						gchar* _tmp319_;
						gchar* _tmp320_;
						_tmp317_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp318_ = _tmp317_;
						_tmp319_ = vala_symbol_get_full_name ((ValaSymbol*) self);
						_tmp320_ = _tmp319_;
						vala_report_error (_tmp318_, "%s: Gap in ordering in position %d", _tmp320_, i);
						_g_free0 (_tmp320_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp321_ = vala_code_node_get_error ((ValaCodeNode*) self);
					_tmp322_ = _tmp321_;
					if (!_tmp322_) {
						ValaList* _tmp323_;
						ValaSymbol* _tmp324_;
						_tmp323_ = self->priv->virtuals;
						_tmp324_ = sym;
						vala_list_set (_tmp323_, i, _tmp324_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	_tmp325_ = vala_code_context_get_analyzer (context);
	_tmp326_ = _tmp325_;
	_tmp327_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp326_, _tmp327_);
	_tmp328_ = vala_code_context_get_analyzer (context);
	_tmp329_ = _tmp328_;
	_tmp330_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp329_, _tmp330_);
	_tmp331_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp332_ = _tmp331_;
	result = !_tmp332_;
	_vala_map_unref0 (positions);
	_vala_code_node_unref0 (prereq_class);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_interface_class_init (ValaInterfaceClass * klass,
                           gpointer klass_data)
{
	vala_interface_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_interface_finalize;
	g_type_class_adjust_private_offset (klass, &ValaInterface_private_offset);
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_interface_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_interface_real_add_property;
	((ValaInterfaceClass *) klass)->get_virtuals = (ValaList* (*) (ValaInterface*)) vala_interface_real_get_virtuals;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_interface_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_interface_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_interface_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_interface_real_check;
}

static void
vala_interface_instance_init (ValaInterface * self,
                              gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_interface_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->prerequisites = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->virtuals = (ValaList*) _tmp3_;
}

static void
vala_interface_finalize (ValaCodeNode * obj)
{
	ValaInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTERFACE, ValaInterface);
	_vala_iterable_unref0 (self->priv->prerequisites);
	_vala_iterable_unref0 (self->priv->virtuals);
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->finalize (obj);
}

/**
 * Represents an interface declaration in the source code.
 */
static GType
vala_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterface), 0, (GInstanceInitFunc) vala_interface_instance_init, NULL };
	GType vala_interface_type_id;
	vala_interface_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaInterface", &g_define_type_info, 0);
	ValaInterface_private_offset = g_type_add_instance_private (vala_interface_type_id, sizeof (ValaInterfacePrivate));
	return vala_interface_type_id;
}

GType
vala_interface_get_type (void)
{
	static volatile gsize vala_interface_type_id__volatile = 0;
	if (g_once_init_enter (&vala_interface_type_id__volatile)) {
		GType vala_interface_type_id;
		vala_interface_type_id = vala_interface_get_type_once ();
		g_once_init_leave (&vala_interface_type_id__volatile, vala_interface_type_id);
	}
	return vala_interface_type_id__volatile;
}

