// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Accessible, Buildable, ConstraintTarget, Widget};
use glib::{prelude::*, translate::*};
use std::{fmt, mem};

glib::wrapper! {
    #[doc(alias = "GtkNative")]
    pub struct Native(Interface<ffi::GtkNative, ffi::GtkNativeInterface>) @requires Widget, Accessible, Buildable, ConstraintTarget;

    match fn {
        type_ => || ffi::gtk_native_get_type(),
    }
}

impl Native {
    pub const NONE: Option<&'static Native> = None;

    #[doc(alias = "gtk_native_get_for_surface")]
    #[doc(alias = "get_for_surface")]
    pub fn for_surface(surface: &impl IsA<gdk::Surface>) -> Option<Native> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(ffi::gtk_native_get_for_surface(
                surface.as_ref().to_glib_none().0,
            ))
        }
    }
}

pub trait NativeExt: 'static {
    #[doc(alias = "gtk_native_get_renderer")]
    #[doc(alias = "get_renderer")]
    fn renderer(&self) -> gsk::Renderer;

    #[doc(alias = "gtk_native_get_surface")]
    #[doc(alias = "get_surface")]
    fn surface(&self) -> gdk::Surface;

    #[doc(alias = "gtk_native_get_surface_transform")]
    #[doc(alias = "get_surface_transform")]
    fn surface_transform(&self) -> (f64, f64);

    #[doc(alias = "gtk_native_realize")]
    fn realize(&self);

    #[doc(alias = "gtk_native_unrealize")]
    fn unrealize(&self);
}

impl<O: IsA<Native>> NativeExt for O {
    fn renderer(&self) -> gsk::Renderer {
        unsafe { from_glib_none(ffi::gtk_native_get_renderer(self.as_ref().to_glib_none().0)) }
    }

    fn surface(&self) -> gdk::Surface {
        unsafe { from_glib_none(ffi::gtk_native_get_surface(self.as_ref().to_glib_none().0)) }
    }

    fn surface_transform(&self) -> (f64, f64) {
        unsafe {
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            ffi::gtk_native_get_surface_transform(
                self.as_ref().to_glib_none().0,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
            );
            (x.assume_init(), y.assume_init())
        }
    }

    fn realize(&self) {
        unsafe {
            ffi::gtk_native_realize(self.as_ref().to_glib_none().0);
        }
    }

    fn unrealize(&self) {
        unsafe {
            ffi::gtk_native_unrealize(self.as_ref().to_glib_none().0);
        }
    }
}

impl fmt::Display for Native {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Native")
    }
}
