/* valacreationmethod.c generated by valac, the Vala compiler
 * generated from valacreationmethod.vala, do not modify */

/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 * Copyright (C) 2007-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <valagee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaCreationMethodPrivate {
	gchar* _class_name;
	gboolean _chain_up;
};

static gint ValaCreationMethod_private_offset;
static gpointer vala_creation_method_parent_class = NULL;

static void vala_creation_method_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor);
static gboolean vala_creation_method_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static void vala_creation_method_finalize (ValaCodeNode * obj);
static GType vala_creation_method_get_type_once (void);

static inline gpointer
vala_creation_method_get_instance_private (ValaCreationMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCreationMethod_private_offset);
}

const gchar*
vala_creation_method_get_class_name (ValaCreationMethod* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_name;
	result = _tmp0_;
	return result;
}

void
vala_creation_method_set_class_name (ValaCreationMethod* self,
                                     const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_class_name);
	self->priv->_class_name = _tmp0_;
}

gboolean
vala_creation_method_get_chain_up (ValaCreationMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_chain_up;
	return result;
}

void
vala_creation_method_set_chain_up (ValaCreationMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_chain_up = value;
}

/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod*
vala_creation_method_construct (GType object_type,
                                const gchar* class_name,
                                const gchar* name,
                                ValaSourceReference* source_reference,
                                ValaComment* comment)
{
	ValaCreationMethod* self = NULL;
	ValaVoidType* _tmp0_;
	ValaVoidType* _tmp1_;
	_tmp0_ = vala_void_type_new (NULL);
	_tmp1_ = _tmp0_;
	self = (ValaCreationMethod*) vala_method_construct (object_type, name, (ValaDataType*) _tmp1_, source_reference, comment);
	_vala_code_node_unref0 (_tmp1_);
	vala_creation_method_set_class_name (self, class_name);
	return self;
}

ValaCreationMethod*
vala_creation_method_new (const gchar* class_name,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	return vala_creation_method_construct (VALA_TYPE_CREATION_METHOD, class_name, name, source_reference, comment);
}

static void
vala_creation_method_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_creation_method (visitor, self);
}

static void
vala_creation_method_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	ValaList* _tmp9_;
	ValaBlock* _tmp37_;
	ValaBlock* _tmp38_;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaParameter* param = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaParameter* _tmp8_;
			_param_index = _param_index + 1;
			_tmp4_ = _param_index;
			_tmp5_ = _param_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _param_list;
			_tmp7_ = vala_list_get (_tmp6_, _param_index);
			param = (ValaParameter*) _tmp7_;
			_tmp8_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (param);
		}
	}
	_tmp9_ = ((ValaMethod*) self)->error_types;
	if (_tmp9_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp10_;
			gint _error_type_size = 0;
			ValaList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _error_type_index = 0;
			_tmp10_ = ((ValaMethod*) self)->error_types;
			_error_type_list = _tmp10_;
			_tmp11_ = _error_type_list;
			_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_error_type_size = _tmp13_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp14_;
				gint _tmp15_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp16_;
				gpointer _tmp17_;
				ValaDataType* _tmp18_;
				_error_type_index = _error_type_index + 1;
				_tmp14_ = _error_type_index;
				_tmp15_ = _error_type_size;
				if (!(_tmp14_ < _tmp15_)) {
					break;
				}
				_tmp16_ = _error_type_list;
				_tmp17_ = vala_list_get (_tmp16_, _error_type_index);
				error_type = (ValaDataType*) _tmp17_;
				_tmp18_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp18_, visitor);
				_vala_code_node_unref0 (error_type);
			}
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp19_;
		gint _precondition_size = 0;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _precondition_index = 0;
		_tmp19_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp19_;
		_tmp20_ = _precondition_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_precondition_size = _tmp22_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaExpression* _tmp27_;
			_precondition_index = _precondition_index + 1;
			_tmp23_ = _precondition_index;
			_tmp24_ = _precondition_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _precondition_list;
			_tmp26_ = vala_list_get (_tmp25_, _precondition_index);
			precondition = (ValaExpression*) _tmp26_;
			_tmp27_ = precondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp27_, visitor);
			_vala_code_node_unref0 (precondition);
		}
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp28_;
		gint _postcondition_size = 0;
		ValaList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _postcondition_index = 0;
		_tmp28_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp28_;
		_tmp29_ = _postcondition_list;
		_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_postcondition_size = _tmp31_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp34_;
			gpointer _tmp35_;
			ValaExpression* _tmp36_;
			_postcondition_index = _postcondition_index + 1;
			_tmp32_ = _postcondition_index;
			_tmp33_ = _postcondition_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _postcondition_list;
			_tmp35_ = vala_list_get (_tmp34_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp35_;
			_tmp36_ = postcondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp36_, visitor);
			_vala_code_node_unref0 (postcondition);
		}
	}
	_tmp37_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp38_ = _tmp37_;
	if (_tmp38_ != NULL) {
		ValaBlock* _tmp39_;
		ValaBlock* _tmp40_;
		_tmp39_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp40_ = _tmp39_;
		vala_code_node_accept ((ValaCodeNode*) _tmp40_, visitor);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_creation_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaCreationMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	ValaParameter* _tmp20_;
	ValaParameter* _tmp21_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_;
	gboolean _tmp27_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSemanticAnalyzer* _tmp33_;
	ValaSourceFile* _tmp34_;
	ValaSourceFile* _tmp35_;
	ValaSourceFile* _tmp36_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp37_;
	ValaSemanticAnalyzer* _tmp38_;
	ValaSymbol* _tmp39_;
	ValaSymbol* _tmp40_;
	ValaSymbol* _tmp41_;
	ValaSourceReference* _tmp42_;
	ValaSourceReference* _tmp43_;
	ValaSemanticAnalyzer* _tmp50_;
	ValaSemanticAnalyzer* _tmp51_;
	gint i = 0;
	ValaList* _tmp135_;
	ValaBlock* _tmp171_;
	ValaBlock* _tmp172_;
	ValaSemanticAnalyzer* _tmp307_;
	ValaSemanticAnalyzer* _tmp308_;
	ValaSourceFile* _tmp309_;
	ValaSemanticAnalyzer* _tmp310_;
	ValaSemanticAnalyzer* _tmp311_;
	ValaSymbol* _tmp312_;
	gboolean _tmp313_ = FALSE;
	ValaBlock* _tmp314_;
	ValaBlock* _tmp315_;
	gboolean _tmp354_;
	gboolean _tmp355_;
	gboolean result;
	self = (ValaCreationMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_class_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = self->priv->_class_name;
		_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp10_) != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_context_get_analyzer (context);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_semantic_analyzer_get_current_symbol (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_symbol_get_full_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->_class_name;
		vala_report_error (_tmp12_, "missing return type in method `%s.%s´", _tmp18_, _tmp19_);
		_g_free0 (_tmp18_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp20_ = vala_method_get_this_parameter ((ValaMethod*) self);
	_tmp21_ = _tmp20_;
	if (_tmp21_ != NULL) {
		ValaParameter* _tmp22_;
		ValaParameter* _tmp23_;
		_tmp22_ = vala_method_get_this_parameter ((ValaMethod*) self);
		_tmp23_ = _tmp22_;
		vala_code_node_check ((ValaCodeNode*) _tmp23_, context);
	}
	_tmp26_ = vala_method_get_coroutine ((ValaMethod*) self);
	_tmp27_ = _tmp26_;
	if (_tmp27_) {
		gboolean _tmp28_;
		gboolean _tmp29_;
		_tmp28_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp29_ = _tmp28_;
		_tmp25_ = !_tmp29_;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		_tmp24_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		ValaSourceReference* _tmp30_;
		ValaSourceReference* _tmp31_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp31_ = _tmp30_;
		vala_report_error (_tmp31_, "gio-2.0 package required for async constructors");
		result = FALSE;
		return result;
	}
	_tmp32_ = vala_code_context_get_analyzer (context);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_semantic_analyzer_get_current_source_file (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = _vala_source_file_ref0 (_tmp35_);
	old_source_file = _tmp36_;
	_tmp37_ = vala_code_context_get_analyzer (context);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_semantic_analyzer_get_current_symbol (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = _vala_code_node_ref0 (_tmp40_);
	old_symbol = _tmp41_;
	_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp43_ = _tmp42_;
	if (_tmp43_ != NULL) {
		ValaSemanticAnalyzer* _tmp44_;
		ValaSemanticAnalyzer* _tmp45_;
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaSourceFile* _tmp48_;
		ValaSourceFile* _tmp49_;
		_tmp44_ = vala_code_context_get_analyzer (context);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_source_reference_get_file (_tmp47_);
		_tmp49_ = _tmp48_;
		vala_semantic_analyzer_set_current_source_file (_tmp45_, _tmp49_);
	}
	_tmp50_ = vala_code_context_get_analyzer (context);
	_tmp51_ = _tmp50_;
	vala_semantic_analyzer_set_current_symbol (_tmp51_, (ValaSymbol*) self);
	i = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp52_;
		gint _param_size = 0;
		ValaList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _param_index = 0;
		_tmp52_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp52_;
		_tmp53_ = _param_list;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_param_size = _tmp55_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp56_;
			gint _tmp57_;
			ValaParameter* param = NULL;
			ValaList* _tmp58_;
			gpointer _tmp59_;
			ValaParameter* _tmp60_;
			gboolean _tmp61_ = FALSE;
			gboolean _tmp62_ = FALSE;
			gint _tmp71_;
			gboolean _tmp72_ = FALSE;
			ValaParameter* _tmp73_;
			gboolean _tmp74_;
			gboolean _tmp75_;
			_param_index = _param_index + 1;
			_tmp56_ = _param_index;
			_tmp57_ = _param_size;
			if (!(_tmp56_ < _tmp57_)) {
				break;
			}
			_tmp58_ = _param_list;
			_tmp59_ = vala_list_get (_tmp58_, _param_index);
			param = (ValaParameter*) _tmp59_;
			_tmp60_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp60_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (i == 0) {
				ValaParameter* _tmp63_;
				gboolean _tmp64_;
				gboolean _tmp65_;
				_tmp63_ = param;
				_tmp64_ = vala_parameter_get_ellipsis (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp62_ = _tmp65_;
			} else {
				_tmp62_ = FALSE;
			}
			if (_tmp62_) {
				ValaBlock* _tmp66_;
				ValaBlock* _tmp67_;
				_tmp66_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp67_ = _tmp66_;
				_tmp61_ = _tmp67_ != NULL;
			} else {
				_tmp61_ = FALSE;
			}
			if (_tmp61_) {
				ValaParameter* _tmp68_;
				ValaSourceReference* _tmp69_;
				ValaSourceReference* _tmp70_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp68_ = param;
				_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp68_);
				_tmp70_ = _tmp69_;
				vala_report_error (_tmp70_, "Named parameter required before `...'");
			}
			_tmp71_ = i;
			i = _tmp71_ + 1;
			_tmp73_ = param;
			_tmp74_ = vala_parameter_get_params_array (_tmp73_);
			_tmp75_ = _tmp74_;
			if (_tmp75_) {
				ValaBlock* _tmp76_;
				ValaBlock* _tmp77_;
				_tmp76_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp77_ = _tmp76_;
				_tmp72_ = _tmp77_ != NULL;
			} else {
				_tmp72_ = FALSE;
			}
			if (_tmp72_) {
				ValaLocalVariable* _tmp78_;
				ValaLocalVariable* _tmp79_;
				gboolean _tmp83_;
				gboolean _tmp84_;
				ValaArrayType* type = NULL;
				ValaParameter* _tmp88_;
				ValaDataType* _tmp89_;
				ValaDataType* _tmp90_;
				ValaDataType* _tmp91_;
				ValaArrayType* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaArrayType* _tmp95_;
				gboolean _tmp96_;
				gboolean _tmp97_;
				ValaArrayType* _tmp98_;
				gboolean _tmp99_ = FALSE;
				ValaArrayType* _tmp100_;
				ValaDataType* _tmp101_;
				ValaDataType* _tmp102_;
				ValaArrayType* _tmp111_;
				ValaExpression* _tmp112_;
				ValaExpression* _tmp113_;
				ValaArrayType* _tmp117_;
				ValaParameter* _tmp118_;
				const gchar* _tmp119_;
				const gchar* _tmp120_;
				ValaParameter* _tmp121_;
				ValaSourceReference* _tmp122_;
				ValaSourceReference* _tmp123_;
				ValaLocalVariable* _tmp124_;
				ValaLocalVariable* _tmp125_;
				ValaBlock* _tmp126_;
				ValaBlock* _tmp127_;
				ValaLocalVariable* _tmp128_;
				ValaLocalVariable* _tmp129_;
				ValaParameter* _tmp130_;
				ValaSourceReference* _tmp131_;
				ValaSourceReference* _tmp132_;
				ValaDeclarationStatement* _tmp133_;
				ValaDeclarationStatement* _tmp134_;
				_tmp78_ = vala_method_get_params_array_var ((ValaMethod*) self);
				_tmp79_ = _tmp78_;
				if (_tmp79_ != NULL) {
					ValaParameter* _tmp80_;
					ValaSourceReference* _tmp81_;
					ValaSourceReference* _tmp82_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp80_ = param;
					_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp80_);
					_tmp82_ = _tmp81_;
					vala_report_error (_tmp82_, "Only one params-array parameter is allowed");
					_vala_code_node_unref0 (param);
					continue;
				}
				_tmp83_ = vala_code_context_get_experimental (context);
				_tmp84_ = _tmp83_;
				if (!_tmp84_) {
					ValaParameter* _tmp85_;
					ValaSourceReference* _tmp86_;
					ValaSourceReference* _tmp87_;
					_tmp85_ = param;
					_tmp86_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp85_);
					_tmp87_ = _tmp86_;
					vala_report_warning (_tmp87_, "Support of params-arrays is experimental");
				}
				_tmp88_ = param;
				_tmp89_ = vala_variable_get_variable_type ((ValaVariable*) _tmp88_);
				_tmp90_ = _tmp89_;
				_tmp91_ = vala_data_type_copy (_tmp90_);
				type = G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp92_ = type;
				_tmp93_ = vala_array_type_get_element_type (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = type;
				_tmp96_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp95_);
				_tmp97_ = _tmp96_;
				vala_data_type_set_value_owned (_tmp94_, _tmp97_);
				_tmp98_ = type;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp98_, TRUE);
				_tmp100_ = type;
				_tmp101_ = vala_array_type_get_element_type (_tmp100_);
				_tmp102_ = _tmp101_;
				if (vala_data_type_is_real_struct_type (_tmp102_)) {
					ValaArrayType* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					gboolean _tmp106_;
					gboolean _tmp107_;
					_tmp103_ = type;
					_tmp104_ = vala_array_type_get_element_type (_tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_nullable (_tmp105_);
					_tmp107_ = _tmp106_;
					_tmp99_ = !_tmp107_;
				} else {
					_tmp99_ = FALSE;
				}
				if (_tmp99_) {
					ValaParameter* _tmp108_;
					ValaSourceReference* _tmp109_;
					ValaSourceReference* _tmp110_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp108_ = param;
					_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp108_);
					_tmp110_ = _tmp109_;
					vala_report_error (_tmp110_, "Only nullable struct elements are supported in params-array");
				}
				_tmp111_ = type;
				_tmp112_ = vala_array_type_get_length (_tmp111_);
				_tmp113_ = _tmp112_;
				if (_tmp113_ != NULL) {
					ValaParameter* _tmp114_;
					ValaSourceReference* _tmp115_;
					ValaSourceReference* _tmp116_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp114_ = param;
					_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp114_);
					_tmp116_ = _tmp115_;
					vala_report_error (_tmp116_, "Passing length to params-array is not supported yet");
				}
				_tmp117_ = type;
				_tmp118_ = param;
				_tmp119_ = vala_symbol_get_name ((ValaSymbol*) _tmp118_);
				_tmp120_ = _tmp119_;
				_tmp121_ = param;
				_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp121_);
				_tmp123_ = _tmp122_;
				_tmp124_ = vala_local_variable_new ((ValaDataType*) _tmp117_, _tmp120_, NULL, _tmp123_);
				_tmp125_ = _tmp124_;
				vala_method_set_params_array_var ((ValaMethod*) self, _tmp125_);
				_vala_code_node_unref0 (_tmp125_);
				_tmp126_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp127_ = _tmp126_;
				_tmp128_ = vala_method_get_params_array_var ((ValaMethod*) self);
				_tmp129_ = _tmp128_;
				_tmp130_ = param;
				_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp130_);
				_tmp132_ = _tmp131_;
				_tmp133_ = vala_declaration_statement_new ((ValaSymbol*) _tmp129_, _tmp132_);
				_tmp134_ = _tmp133_;
				vala_block_insert_statement (_tmp127_, 0, (ValaStatement*) _tmp134_);
				_vala_code_node_unref0 (_tmp134_);
				_vala_code_node_unref0 (type);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp135_ = ((ValaMethod*) self)->error_types;
	if (_tmp135_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp136_;
			gint _error_type_size = 0;
			ValaList* _tmp137_;
			gint _tmp138_;
			gint _tmp139_;
			gint _error_type_index = 0;
			_tmp136_ = ((ValaMethod*) self)->error_types;
			_error_type_list = _tmp136_;
			_tmp137_ = _error_type_list;
			_tmp138_ = vala_collection_get_size ((ValaCollection*) _tmp137_);
			_tmp139_ = _tmp138_;
			_error_type_size = _tmp139_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp140_;
				gint _tmp141_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp142_;
				gpointer _tmp143_;
				ValaDataType* _tmp144_;
				ValaDataType* _tmp145_;
				_error_type_index = _error_type_index + 1;
				_tmp140_ = _error_type_index;
				_tmp141_ = _error_type_size;
				if (!(_tmp140_ < _tmp141_)) {
					break;
				}
				_tmp142_ = _error_type_list;
				_tmp143_ = vala_list_get (_tmp142_, _error_type_index);
				error_type = (ValaDataType*) _tmp143_;
				_tmp144_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp144_, context);
				_tmp145_ = error_type;
				if (!vala_data_type_is_accessible (_tmp145_, (ValaSymbol*) self)) {
					ValaSourceReference* _tmp146_;
					ValaSourceReference* _tmp147_;
					ValaDataType* _tmp148_;
					gchar* _tmp149_;
					gchar* _tmp150_;
					gchar* _tmp151_;
					gchar* _tmp152_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp146_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp147_ = _tmp146_;
					_tmp148_ = error_type;
					_tmp149_ = vala_code_node_to_string ((ValaCodeNode*) _tmp148_);
					_tmp150_ = _tmp149_;
					_tmp151_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp152_ = _tmp151_;
					vala_report_error (_tmp147_, "error type `%s' is less accessible than creation method `%s'", _tmp150_, _tmp152_);
					_g_free0 (_tmp152_);
					_g_free0 (_tmp150_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp153_;
		gint _precondition_size = 0;
		ValaList* _tmp154_;
		gint _tmp155_;
		gint _tmp156_;
		gint _precondition_index = 0;
		_tmp153_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp153_;
		_tmp154_ = _precondition_list;
		_tmp155_ = vala_collection_get_size ((ValaCollection*) _tmp154_);
		_tmp156_ = _tmp155_;
		_precondition_size = _tmp156_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp157_;
			gint _tmp158_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp159_;
			gpointer _tmp160_;
			ValaExpression* _tmp161_;
			_precondition_index = _precondition_index + 1;
			_tmp157_ = _precondition_index;
			_tmp158_ = _precondition_size;
			if (!(_tmp157_ < _tmp158_)) {
				break;
			}
			_tmp159_ = _precondition_list;
			_tmp160_ = vala_list_get (_tmp159_, _precondition_index);
			precondition = (ValaExpression*) _tmp160_;
			_tmp161_ = precondition;
			vala_code_node_check ((ValaCodeNode*) _tmp161_, context);
			_vala_code_node_unref0 (precondition);
		}
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp162_;
		gint _postcondition_size = 0;
		ValaList* _tmp163_;
		gint _tmp164_;
		gint _tmp165_;
		gint _postcondition_index = 0;
		_tmp162_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp162_;
		_tmp163_ = _postcondition_list;
		_tmp164_ = vala_collection_get_size ((ValaCollection*) _tmp163_);
		_tmp165_ = _tmp164_;
		_postcondition_size = _tmp165_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp166_;
			gint _tmp167_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp168_;
			gpointer _tmp169_;
			ValaExpression* _tmp170_;
			_postcondition_index = _postcondition_index + 1;
			_tmp166_ = _postcondition_index;
			_tmp167_ = _postcondition_size;
			if (!(_tmp166_ < _tmp167_)) {
				break;
			}
			_tmp168_ = _postcondition_list;
			_tmp169_ = vala_list_get (_tmp168_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp169_;
			_tmp170_ = postcondition;
			vala_code_node_check ((ValaCodeNode*) _tmp170_, context);
			_vala_code_node_unref0 (postcondition);
		}
	}
	_tmp171_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp172_ = _tmp171_;
	if (_tmp172_ != NULL) {
		ValaBlock* _tmp173_;
		ValaBlock* _tmp174_;
		ValaClass* cl = NULL;
		ValaSymbol* _tmp175_;
		ValaSymbol* _tmp176_;
		gboolean _tmp177_ = FALSE;
		gboolean _tmp178_ = FALSE;
		gboolean _tmp179_;
		_tmp173_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp174_ = _tmp173_;
		vala_code_node_check ((ValaCodeNode*) _tmp174_, context);
		_tmp175_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp176_ = _tmp175_;
		cl = VALA_IS_CLASS (_tmp176_) ? ((ValaClass*) _tmp176_) : NULL;
		_tmp179_ = self->priv->_chain_up;
		if (!_tmp179_) {
			ValaClass* _tmp180_;
			_tmp180_ = cl;
			_tmp178_ = _tmp180_ != NULL;
		} else {
			_tmp178_ = FALSE;
		}
		if (_tmp178_) {
			ValaClass* _tmp181_;
			ValaClass* _tmp182_;
			ValaClass* _tmp183_;
			_tmp181_ = cl;
			_tmp182_ = vala_class_get_base_class (_tmp181_);
			_tmp183_ = _tmp182_;
			_tmp177_ = _tmp183_ != NULL;
		} else {
			_tmp177_ = FALSE;
		}
		if (_tmp177_) {
			gboolean _tmp184_ = FALSE;
			gboolean _tmp185_ = FALSE;
			ValaProfile _tmp186_;
			ValaProfile _tmp187_;
			_tmp186_ = vala_code_context_get_profile (context);
			_tmp187_ = _tmp186_;
			if (_tmp187_ == VALA_PROFILE_GOBJECT) {
				ValaClass* _tmp188_;
				ValaClass* _tmp189_;
				ValaClass* _tmp190_;
				ValaCreationMethod* _tmp191_;
				ValaCreationMethod* _tmp192_;
				_tmp188_ = cl;
				_tmp189_ = vala_class_get_base_class (_tmp188_);
				_tmp190_ = _tmp189_;
				_tmp191_ = vala_class_get_default_construction_method (_tmp190_);
				_tmp192_ = _tmp191_;
				_tmp185_ = _tmp192_ != NULL;
			} else {
				_tmp185_ = FALSE;
			}
			if (_tmp185_) {
				ValaClass* _tmp193_;
				ValaClass* _tmp194_;
				ValaClass* _tmp195_;
				ValaCreationMethod* _tmp196_;
				ValaCreationMethod* _tmp197_;
				gboolean _tmp198_;
				gboolean _tmp199_;
				_tmp193_ = cl;
				_tmp194_ = vala_class_get_base_class (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_class_get_default_construction_method (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp197_);
				_tmp199_ = _tmp198_;
				_tmp184_ = !_tmp199_;
			} else {
				_tmp184_ = FALSE;
			}
			if (_tmp184_) {
				ValaBlock* old_insert_block = NULL;
				ValaSemanticAnalyzer* _tmp200_;
				ValaSemanticAnalyzer* _tmp201_;
				ValaBlock* _tmp202_;
				ValaBlock* _tmp203_;
				ValaSemanticAnalyzer* _tmp204_;
				ValaSemanticAnalyzer* _tmp205_;
				ValaBlock* _tmp206_;
				ValaBlock* _tmp207_;
				ValaSemanticAnalyzer* _tmp208_;
				ValaSemanticAnalyzer* _tmp209_;
				ValaBlock* _tmp210_;
				ValaBlock* _tmp211_;
				ValaBlock* _tmp212_;
				ValaExpressionStatement* stmt = NULL;
				ValaSourceReference* _tmp213_;
				ValaSourceReference* _tmp214_;
				ValaMemberAccess* _tmp215_;
				ValaMemberAccess* _tmp216_;
				ValaSourceReference* _tmp217_;
				ValaSourceReference* _tmp218_;
				ValaMemberAccess* _tmp219_;
				ValaMemberAccess* _tmp220_;
				ValaSourceReference* _tmp221_;
				ValaSourceReference* _tmp222_;
				ValaMethodCall* _tmp223_;
				ValaMethodCall* _tmp224_;
				ValaSourceReference* _tmp225_;
				ValaSourceReference* _tmp226_;
				ValaExpressionStatement* _tmp227_;
				ValaExpressionStatement* _tmp228_;
				ValaBlock* _tmp229_;
				ValaBlock* _tmp230_;
				ValaExpressionStatement* _tmp231_;
				ValaExpressionStatement* _tmp232_;
				ValaSemanticAnalyzer* _tmp233_;
				ValaSemanticAnalyzer* _tmp234_;
				ValaSemanticAnalyzer* _tmp235_;
				ValaSemanticAnalyzer* _tmp236_;
				ValaBlock* _tmp237_;
				ValaBlock* _tmp238_;
				_tmp200_ = vala_code_context_get_analyzer (context);
				_tmp201_ = _tmp200_;
				_tmp202_ = _tmp201_->insert_block;
				_tmp203_ = _vala_code_node_ref0 (_tmp202_);
				old_insert_block = _tmp203_;
				_tmp204_ = vala_code_context_get_analyzer (context);
				_tmp205_ = _tmp204_;
				_tmp206_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp207_ = _tmp206_;
				vala_semantic_analyzer_set_current_symbol (_tmp205_, (ValaSymbol*) _tmp207_);
				_tmp208_ = vala_code_context_get_analyzer (context);
				_tmp209_ = _tmp208_;
				_tmp210_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp211_ = _tmp210_;
				_tmp212_ = _vala_code_node_ref0 (_tmp211_);
				_vala_code_node_unref0 (_tmp209_->insert_block);
				_tmp209_->insert_block = _tmp212_;
				_tmp213_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp214_ = _tmp213_;
				_tmp215_ = vala_member_access_new_simple ("GLib", _tmp214_);
				_tmp216_ = _tmp215_;
				_tmp217_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp218_ = _tmp217_;
				_tmp219_ = vala_member_access_new ((ValaExpression*) _tmp216_, "Object", _tmp218_);
				_tmp220_ = _tmp219_;
				_tmp221_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp222_ = _tmp221_;
				_tmp223_ = vala_method_call_new ((ValaExpression*) _tmp220_, _tmp222_);
				_tmp224_ = _tmp223_;
				_tmp225_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp226_ = _tmp225_;
				_tmp227_ = vala_expression_statement_new ((ValaExpression*) _tmp224_, _tmp226_);
				_tmp228_ = _tmp227_;
				_vala_code_node_unref0 (_tmp224_);
				_vala_code_node_unref0 (_tmp220_);
				_vala_code_node_unref0 (_tmp216_);
				stmt = _tmp228_;
				_tmp229_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp230_ = _tmp229_;
				_tmp231_ = stmt;
				vala_block_insert_statement (_tmp230_, 0, (ValaStatement*) _tmp231_);
				_tmp232_ = stmt;
				vala_code_node_check ((ValaCodeNode*) _tmp232_, context);
				_tmp233_ = vala_code_context_get_analyzer (context);
				_tmp234_ = _tmp233_;
				vala_semantic_analyzer_set_current_symbol (_tmp234_, (ValaSymbol*) self);
				_tmp235_ = vala_code_context_get_analyzer (context);
				_tmp236_ = _tmp235_;
				_tmp237_ = old_insert_block;
				_tmp238_ = _vala_code_node_ref0 (_tmp237_);
				_vala_code_node_unref0 (_tmp236_->insert_block);
				_tmp236_->insert_block = _tmp238_;
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (old_insert_block);
			} else {
				gboolean _tmp239_ = FALSE;
				ValaClass* _tmp240_;
				ValaClass* _tmp241_;
				ValaClass* _tmp242_;
				ValaCreationMethod* _tmp243_;
				ValaCreationMethod* _tmp244_;
				_tmp240_ = cl;
				_tmp241_ = vala_class_get_base_class (_tmp240_);
				_tmp242_ = _tmp241_;
				_tmp243_ = vala_class_get_default_construction_method (_tmp242_);
				_tmp244_ = _tmp243_;
				if (_tmp244_ == NULL) {
					_tmp239_ = TRUE;
				} else {
					ValaClass* _tmp245_;
					ValaClass* _tmp246_;
					ValaClass* _tmp247_;
					ValaCreationMethod* _tmp248_;
					ValaCreationMethod* _tmp249_;
					ValaSymbolAccessibility _tmp250_;
					ValaSymbolAccessibility _tmp251_;
					_tmp245_ = cl;
					_tmp246_ = vala_class_get_base_class (_tmp245_);
					_tmp247_ = _tmp246_;
					_tmp248_ = vala_class_get_default_construction_method (_tmp247_);
					_tmp249_ = _tmp248_;
					_tmp250_ = vala_symbol_get_access ((ValaSymbol*) _tmp249_);
					_tmp251_ = _tmp250_;
					_tmp239_ = _tmp251_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				}
				if (_tmp239_) {
					ValaSourceReference* _tmp252_;
					ValaSourceReference* _tmp253_;
					_tmp252_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp253_ = _tmp252_;
					vala_report_error (_tmp253_, "unable to chain up to private base constructor");
				} else {
					ValaClass* _tmp254_;
					ValaClass* _tmp255_;
					ValaClass* _tmp256_;
					ValaCreationMethod* _tmp257_;
					ValaCreationMethod* _tmp258_;
					_tmp254_ = cl;
					_tmp255_ = vala_class_get_base_class (_tmp254_);
					_tmp256_ = _tmp255_;
					_tmp257_ = vala_class_get_default_construction_method (_tmp256_);
					_tmp258_ = _tmp257_;
					if (vala_method_get_required_arguments ((ValaMethod*) _tmp258_) > 0) {
						ValaSourceReference* _tmp259_;
						ValaSourceReference* _tmp260_;
						_tmp259_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp260_ = _tmp259_;
						vala_report_error (_tmp260_, "unable to chain up to base constructor requiring arguments");
					} else {
						ValaBlock* old_insert_block = NULL;
						ValaSemanticAnalyzer* _tmp261_;
						ValaSemanticAnalyzer* _tmp262_;
						ValaBlock* _tmp263_;
						ValaBlock* _tmp264_;
						ValaSemanticAnalyzer* _tmp265_;
						ValaSemanticAnalyzer* _tmp266_;
						ValaBlock* _tmp267_;
						ValaBlock* _tmp268_;
						ValaSemanticAnalyzer* _tmp269_;
						ValaSemanticAnalyzer* _tmp270_;
						ValaBlock* _tmp271_;
						ValaBlock* _tmp272_;
						ValaBlock* _tmp273_;
						ValaMethodCall* base_call = NULL;
						ValaSourceReference* _tmp274_;
						ValaSourceReference* _tmp275_;
						ValaBaseAccess* _tmp276_;
						ValaBaseAccess* _tmp277_;
						ValaSourceReference* _tmp278_;
						ValaSourceReference* _tmp279_;
						ValaMethodCall* _tmp280_;
						ValaMethodCall* _tmp281_;
						gboolean _tmp282_ = FALSE;
						gboolean _tmp283_;
						gboolean _tmp284_;
						ValaExpressionStatement* stmt = NULL;
						ValaMethodCall* _tmp293_;
						ValaSourceReference* _tmp294_;
						ValaSourceReference* _tmp295_;
						ValaExpressionStatement* _tmp296_;
						ValaBlock* _tmp297_;
						ValaBlock* _tmp298_;
						ValaExpressionStatement* _tmp299_;
						ValaExpressionStatement* _tmp300_;
						ValaSemanticAnalyzer* _tmp301_;
						ValaSemanticAnalyzer* _tmp302_;
						ValaSemanticAnalyzer* _tmp303_;
						ValaSemanticAnalyzer* _tmp304_;
						ValaBlock* _tmp305_;
						ValaBlock* _tmp306_;
						_tmp261_ = vala_code_context_get_analyzer (context);
						_tmp262_ = _tmp261_;
						_tmp263_ = _tmp262_->insert_block;
						_tmp264_ = _vala_code_node_ref0 (_tmp263_);
						old_insert_block = _tmp264_;
						_tmp265_ = vala_code_context_get_analyzer (context);
						_tmp266_ = _tmp265_;
						_tmp267_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp268_ = _tmp267_;
						vala_semantic_analyzer_set_current_symbol (_tmp266_, (ValaSymbol*) _tmp268_);
						_tmp269_ = vala_code_context_get_analyzer (context);
						_tmp270_ = _tmp269_;
						_tmp271_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp272_ = _tmp271_;
						_tmp273_ = _vala_code_node_ref0 (_tmp272_);
						_vala_code_node_unref0 (_tmp270_->insert_block);
						_tmp270_->insert_block = _tmp273_;
						_tmp274_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp275_ = _tmp274_;
						_tmp276_ = vala_base_access_new (_tmp275_);
						_tmp277_ = _tmp276_;
						_tmp278_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp279_ = _tmp278_;
						_tmp280_ = vala_method_call_new ((ValaExpression*) _tmp277_, _tmp279_);
						_tmp281_ = _tmp280_;
						_vala_code_node_unref0 (_tmp277_);
						base_call = _tmp281_;
						_tmp283_ = vala_method_get_coroutine ((ValaMethod*) self);
						_tmp284_ = _tmp283_;
						if (_tmp284_) {
							ValaClass* _tmp285_;
							ValaClass* _tmp286_;
							ValaClass* _tmp287_;
							ValaCreationMethod* _tmp288_;
							ValaCreationMethod* _tmp289_;
							gboolean _tmp290_;
							gboolean _tmp291_;
							_tmp285_ = cl;
							_tmp286_ = vala_class_get_base_class (_tmp285_);
							_tmp287_ = _tmp286_;
							_tmp288_ = vala_class_get_default_construction_method (_tmp287_);
							_tmp289_ = _tmp288_;
							_tmp290_ = vala_method_get_coroutine ((ValaMethod*) _tmp289_);
							_tmp291_ = _tmp290_;
							_tmp282_ = _tmp291_;
						} else {
							_tmp282_ = FALSE;
						}
						if (_tmp282_) {
							ValaMethodCall* _tmp292_;
							_tmp292_ = base_call;
							vala_callable_expression_set_is_yield_expression ((ValaCallableExpression*) _tmp292_, TRUE);
						}
						_tmp293_ = base_call;
						_tmp294_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp295_ = _tmp294_;
						_tmp296_ = vala_expression_statement_new ((ValaExpression*) _tmp293_, _tmp295_);
						stmt = _tmp296_;
						_tmp297_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp298_ = _tmp297_;
						_tmp299_ = stmt;
						vala_block_insert_statement (_tmp298_, 0, (ValaStatement*) _tmp299_);
						_tmp300_ = stmt;
						vala_code_node_check ((ValaCodeNode*) _tmp300_, context);
						_tmp301_ = vala_code_context_get_analyzer (context);
						_tmp302_ = _tmp301_;
						vala_semantic_analyzer_set_current_symbol (_tmp302_, (ValaSymbol*) self);
						_tmp303_ = vala_code_context_get_analyzer (context);
						_tmp304_ = _tmp303_;
						_tmp305_ = old_insert_block;
						_tmp306_ = _vala_code_node_ref0 (_tmp305_);
						_vala_code_node_unref0 (_tmp304_->insert_block);
						_tmp304_->insert_block = _tmp306_;
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (base_call);
						_vala_code_node_unref0 (old_insert_block);
					}
				}
			}
		}
	}
	_tmp307_ = vala_code_context_get_analyzer (context);
	_tmp308_ = _tmp307_;
	_tmp309_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp308_, _tmp309_);
	_tmp310_ = vala_code_context_get_analyzer (context);
	_tmp311_ = _tmp310_;
	_tmp312_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp311_, _tmp312_);
	_tmp314_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp315_ = _tmp314_;
	if (_tmp315_ != NULL) {
		ValaBlock* _tmp316_;
		ValaBlock* _tmp317_;
		gboolean _tmp318_;
		gboolean _tmp319_;
		_tmp316_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp317_ = _tmp316_;
		_tmp318_ = vala_code_node_get_error ((ValaCodeNode*) _tmp317_);
		_tmp319_ = _tmp318_;
		_tmp313_ = !_tmp319_;
	} else {
		_tmp313_ = FALSE;
	}
	if (_tmp313_) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp320_;
		ValaArrayList* _tmp321_;
		ValaBlock* _tmp322_;
		ValaBlock* _tmp323_;
		ValaArrayList* _tmp324_;
		_tmp320_ = g_direct_equal;
		_tmp321_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp320_);
		body_errors = _tmp321_;
		_tmp322_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp323_ = _tmp322_;
		_tmp324_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp323_, (ValaCollection*) _tmp324_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp325_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp326_;
			gint _tmp327_;
			gint _tmp328_;
			gint _body_error_type_index = 0;
			_tmp325_ = body_errors;
			_body_error_type_list = _tmp325_;
			_tmp326_ = _body_error_type_list;
			_tmp327_ = vala_collection_get_size ((ValaCollection*) _tmp326_);
			_tmp328_ = _tmp327_;
			_body_error_type_size = _tmp328_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp329_;
				gint _tmp330_;
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp331_;
				gpointer _tmp332_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp333_;
				gboolean _tmp344_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				_tmp329_ = _body_error_type_index;
				_tmp330_ = _body_error_type_size;
				if (!(_tmp329_ < _tmp330_)) {
					break;
				}
				_tmp331_ = _body_error_type_list;
				_tmp332_ = vala_list_get ((ValaList*) _tmp331_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp332_;
				can_propagate_error = FALSE;
				_tmp333_ = ((ValaMethod*) self)->error_types;
				if (_tmp333_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp334_;
						gint _method_error_type_size = 0;
						ValaList* _tmp335_;
						gint _tmp336_;
						gint _tmp337_;
						gint _method_error_type_index = 0;
						_tmp334_ = ((ValaMethod*) self)->error_types;
						_method_error_type_list = _tmp334_;
						_tmp335_ = _method_error_type_list;
						_tmp336_ = vala_collection_get_size ((ValaCollection*) _tmp335_);
						_tmp337_ = _tmp336_;
						_method_error_type_size = _tmp337_;
						_method_error_type_index = -1;
						while (TRUE) {
							gint _tmp338_;
							gint _tmp339_;
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp340_;
							gpointer _tmp341_;
							ValaDataType* _tmp342_;
							ValaDataType* _tmp343_;
							_method_error_type_index = _method_error_type_index + 1;
							_tmp338_ = _method_error_type_index;
							_tmp339_ = _method_error_type_size;
							if (!(_tmp338_ < _tmp339_)) {
								break;
							}
							_tmp340_ = _method_error_type_list;
							_tmp341_ = vala_list_get (_tmp340_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp341_;
							_tmp342_ = body_error_type;
							_tmp343_ = method_error_type;
							if (vala_data_type_compatible (_tmp342_, _tmp343_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
					}
				}
				if (!can_propagate_error) {
					ValaDataType* _tmp345_;
					gboolean _tmp346_;
					gboolean _tmp347_;
					_tmp345_ = body_error_type;
					_tmp346_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp345_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp347_ = _tmp346_;
					_tmp344_ = !_tmp347_;
				} else {
					_tmp344_ = FALSE;
				}
				if (_tmp344_) {
					ValaDataType* _tmp348_;
					ValaSourceReference* _tmp349_;
					ValaSourceReference* _tmp350_;
					ValaDataType* _tmp351_;
					gchar* _tmp352_;
					gchar* _tmp353_;
					_tmp348_ = body_error_type;
					_tmp349_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp348_);
					_tmp350_ = _tmp349_;
					_tmp351_ = body_error_type;
					_tmp352_ = vala_code_node_to_string ((ValaCodeNode*) _tmp351_);
					_tmp353_ = _tmp352_;
					vala_report_warning (_tmp350_, "unhandled error `%s'", _tmp353_);
					_g_free0 (_tmp353_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
		}
		_vala_iterable_unref0 (body_errors);
	}
	_tmp354_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp355_ = _tmp354_;
	result = !_tmp355_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_creation_method_class_init (ValaCreationMethodClass * klass,
                                 gpointer klass_data)
{
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_creation_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCreationMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_creation_method_real_check;
}

static void
vala_creation_method_instance_init (ValaCreationMethod * self,
                                    gpointer klass)
{
	self->priv = vala_creation_method_get_instance_private (self);
}

static void
vala_creation_method_finalize (ValaCodeNode * obj)
{
	ValaCreationMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
	_g_free0 (self->priv->_class_name);
	VALA_CODE_NODE_CLASS (vala_creation_method_parent_class)->finalize (obj);
}

/**
 * Represents a type creation method.
 */
static GType
vala_creation_method_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init, NULL };
	GType vala_creation_method_type_id;
	vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
	ValaCreationMethod_private_offset = g_type_add_instance_private (vala_creation_method_type_id, sizeof (ValaCreationMethodPrivate));
	return vala_creation_method_type_id;
}

GType
vala_creation_method_get_type (void)
{
	static volatile gsize vala_creation_method_type_id__once = 0;
	if (g_once_init_enter (&vala_creation_method_type_id__once)) {
		GType vala_creation_method_type_id;
		vala_creation_method_type_id = vala_creation_method_get_type_once ();
		g_once_init_leave (&vala_creation_method_type_id__once, vala_creation_method_type_id);
	}
	return vala_creation_method_type_id__once;
}

