/*
 * Clutter.
 *
 * An OpenGL based 'interactive canvas' library.
 *
 * Authored By: Emmanuele Bassi <ebassi@linux.intel.com>
 *
 * Copyright (C) 2009  Intel Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CLUTTER_TIMELINE_PRIVATE_H
#define CLUTTER_TIMELINE_PRIVATE_H

void                    _clutter_timeline_advance                       (ClutterTimeline    *timeline,
                                                                         int64_t             tick_time);
int64_t                 _clutter_timeline_get_delta                     (ClutterTimeline    *timeline);
void                    _clutter_timeline_do_tick                       (ClutterTimeline    *timeline,
                                                                         int64_t             tick_time);

#endif /* CLUTTER_TIMELINE_PRIVATE_H */
