// Generated by gmmproc 2.78.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/scrollinfo.h>
#include <gtkmm/private/scrollinfo_p.h>


/* Copyright (C) 2023 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>

namespace
{
} // anonymous namespace


/* Why reinterpret_cast<ScrollInfo*>(gobject) is needed:
 *
 * A ScrollInfo instance is in fact always a GtkScrollInfo instance.
 * Unfortunately, GtkScrollInfo cannot be a member of ScrollInfo,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because ScrollInfo does not have any member data, and
 * it is impossible to derive from it.  This is ensured by using final on the
 * class and by using = delete on the default constructor.
 */

namespace Glib
{

Glib::RefPtr<Gtk::ScrollInfo> wrap(GtkScrollInfo* object, bool take_copy)
{
  if(take_copy && object)
    gtk_scroll_info_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::make_refptr_for_instance<Gtk::ScrollInfo>(reinterpret_cast<Gtk::ScrollInfo*>(object));
}

} // namespace Glib


namespace Gtk
{

void ScrollInfo::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gtk_scroll_info_ref(reinterpret_cast<GtkScrollInfo*>(const_cast<ScrollInfo*>(this)));
}

void ScrollInfo::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gtk_scroll_info_unref(reinterpret_cast<GtkScrollInfo*>(const_cast<ScrollInfo*>(this)));
}

GtkScrollInfo* ScrollInfo::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GtkScrollInfo*>(this);
}

const GtkScrollInfo* ScrollInfo::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GtkScrollInfo*>(this);
}

GtkScrollInfo* ScrollInfo::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  const auto gobject = reinterpret_cast<GtkScrollInfo*>(const_cast<ScrollInfo*>(this));
  gtk_scroll_info_ref(gobject);
  return gobject;
}


Glib::RefPtr<ScrollInfo> ScrollInfo::create()
{
  return Glib::wrap(gtk_scroll_info_new());
}

void ScrollInfo::set_enable_horizontal(bool horizontal)
{
  gtk_scroll_info_set_enable_horizontal(gobj(), static_cast<int>(horizontal));
}

bool ScrollInfo::get_enable_horizontal() const
{
  return gtk_scroll_info_get_enable_horizontal(const_cast<GtkScrollInfo*>(gobj()));
}

void ScrollInfo::set_enable_vertical(bool vertical)
{
  gtk_scroll_info_set_enable_vertical(gobj(), static_cast<int>(vertical));
}

bool ScrollInfo::get_enable_vertical() const
{
  return gtk_scroll_info_get_enable_vertical(const_cast<GtkScrollInfo*>(gobj()));
}


} // namespace Gtk


