
#include <iostream.h>
#include <stdlib.h>
#include <unistd.h>

#include "kdbm.h"

KDbm<char> db;
KDbm<int> db2;
KIntDbm<char> dbi;

void
create()
{
  db.create("foo.db");

  assert(db.isOpen);

  db.insert("linux", "http://www.kde.org");
  db.insert("kde", "it's cool");
  db.insert("iglio", "pietro");
  db.insert("aaaaa", "11111111");
  db.insert("bbbbb", "22222222");
  db.insert("ccccc", "33333333");
  db.insert("ddddd", "44444444");
  db.insert("eeeee", "55555555");

  db.close();
}

void
kint_create()
{
  dbi.create("fooint.db");

  assert(dbi.isOpen);

  dbi.insert(30, "http://www.kde.org");
  dbi.insert(50, "it's cool");
  dbi.insert(32423434, "pietro");
  dbi.insert(-33, "11111111");
  dbi.insert(2365, "22222222");
  dbi.insert(33333333, "33333333");
  dbi.insert(44444444, "44444444");
  dbi.insert(55555555, "55555555");

  dbi.close();
}


void
lookup()
{
  db.open("foo.db");
  char* a = db["aaaaa"];
  char* b = db["kde"];

  cout << a << endl;
  cout << b << endl;

  db.close();
}

void
kint_lookup()
{
  dbi.open("fooint.db");

  cout << dbi[55555555] << endl;
  cout << dbi[-33] << endl;

  dbi.close();
}

void
kint_lookup_nobuffer()
{
  dbi.open("fooint.db");
  dbi.disableBuffer();

  char* a = dbi[55555555];
  char* b = dbi[-33];

  cout << a << endl;
  cout << b << endl;

  assert(strcmp(a, b) != 0);

  free(a);
  free(b);

  dbi.close();
  dbi.enableBuffer();
}

void
buffered_lookup()
{
  db.open("foo.db");

  cout << db["aaaaa"] << endl;
  cout << db["kde"] << endl;

  db.close();
}

void
iter()
{
  db.open("foo.db");

  KDbmIterator it(db);

  cout << "Starting iteration:" << endl;
  int i = 0;

  for (char* key = it.getFirstKey(); !it.eof(); key = it.getNextKey())
    cout << i++ << ": db[" << key << "] = " << db[key] << endl;

  db.close();
}

void
kint_iter()
{
  dbi.open("fooint.db");

  KIntDbmIterator it(dbi);

  cout << "Starting iteration:" << endl;
  int i = 0;

  for (long key = it.getFirstKey(); !it.eof(); key = it.getNextKey())
    cout << i++ << ": dbi[" << key << "] = " << dbi[key] << endl;

  dbi.close();
}



void
remove()
{
  db.open("foo.db", KGDbm::readWrite);

  cout << "Removing aaaaa:" << db.remove("aaaaa") << endl;
  cout << "Removing linux:" << db.remove("linux") << endl;
  cout << "Removing notInDb:" << db.remove("notInDb") << endl;

  db.close();
}

void
generic()
{
  db2.create("generic.db");

  int val = 20;
  db2.insert("xx", val);
  db2.replace("xx", val);
  db2.close();
}

int
main()
{
  create();
  lookup();
  buffered_lookup();
  iter();
  remove();
  iter();

  kint_create();
  kint_lookup();
  kint_lookup_nobuffer();
  kint_iter();


  generic();

  cout << "Removing test database files..." << endl;

  unlink("foo.db");
  unlink("generic.db");
  unlink("fooint.db");

  cout << "Done." << endl;
}
