/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "klcheckbox.h"
#include "klcheckboxpriv.h"
#include "klhelper.h"
#include "klbutton.h"
#include "klgroup.h"

KLCheckBox::KLCheckBox(const char *text) : QCheckBox((QWidget *)0,0)
{
  setKLWidget(this); 
  setText(text);
  setWeight(1);
}

bool KLCheckBox::klAskMinMax(KLMinMaxSizes *minMaxSizes)
{
  if( !KLWidgetBase::klAskMinMax(minMaxSizes) )
    return false;
  QSize size = sizeHint();
  minMaxSizes->minX += size.height();
  minMaxSizes->minY += size.width();
  minMaxSizes->defX += size.height();
  minMaxSizes->defY += size.width();
  minMaxSizes->maxX += size.height();
  minMaxSizes->maxY += size.width() + KLMaxSize;
  return true;
}

void KLCheckBox::setText(const char *text)
{
  QCheckBox::setText(text);
  doRelayout(false);
}

IMPLEMENT_KLMETA_STANDALONE(KLCheckBox,KLWidgetBase,"CheckBox");

bool KLCheckBox::MyChildMeta::dumpObject(KLChild *_child, KLDumpDevice& dev) const
{
  QString helpStr;
  KLCheckBox *child = (KLCheckBox *)_child;
  dev.writeEntry("text",child->text());
  return true; 
}


void KLCheckBox::MyChildMeta::restoreObject(KLChild *_child, KLDumpDevice& dev) const
{
  QString helpStr;
  KLCheckBox *child = (KLCheckBox *)_child;
  child->setText(dev.readEntry("text",child->text()));
}


KLChild *KLCheckBox::MyChildMeta::createObjectEdit(KLChild *child,bool) const
{
  HASSERT(child->metaInherits("KLCheckBox"));
  KLCheckBox *checkbox = (KLCheckBox *)child;
  KLCheckBoxEditGroup *edit = new KLCheckBoxEditGroup();
  edit->checkbox = checkbox;
  KLGridGroup *gridgroup = (KLGridGroup *)KLChildMeta::createObjectEdit(child,false);
  *gridgroup << (*klLabel("Text") << ::setWeight << 1)
             << edit;
  QObject::connect(edit,SIGNAL(textChanged(const char*)),edit,SLOT(onText(const char *)));

  edit->setText(checkbox->text());

  return gridgroup;
}

void KLCheckBoxEditGroup::onText(const char *text)
{
  checkbox->setText(text); 
}

#include "klcheckbox.moc"
#include "klcheckboxpriv.moc"


