#ifndef _KAPP_H_
#define _KAPP_H_

#include <kapp.h>
#include "../qt/Baseobject.h"


class _Application : public KApplication, public BaseObject
{
  Q_OBJECT	

  public:
  
  _Application( int& argc, char** argv ) : KApplication(argc, argv) {
    connect(this, SIGNAL(kdisplayStyleChanged()), this, SLOT(sigKdisplayStyleChanged()));
    connect(this, SIGNAL(kdisplayFontChanged()), this, SLOT(sigKdisplayFontChanged()));
    connect(this, SIGNAL(kdisplayPaletteChanged()), this, SLOT(sigKdisplayPaletteChanged()));
    connect(this, SIGNAL(appearanceChanged()), this, SLOT(sigAppearanceChanged()));
    connect(this, SIGNAL(saveYourself()), this, SLOT(sigSaveYourself()));
  };
  _Application( int& argc, char** argv, const QString& rAppName ) : KApplication(argc, argv, rAppName) {
    connect(this, SIGNAL(kdisplayStyleChanged()), this, SLOT(sigKdisplayStyleChanged()));
    connect(this, SIGNAL(kdisplayFontChanged()), this, SLOT(sigKdisplayFontChanged()));
    connect(this, SIGNAL(kdisplayPaletteChanged()), this, SLOT(sigKdisplayPaletteChanged()));
    connect(this, SIGNAL(appearanceChanged()), this, SLOT(sigAppearanceChanged()));
    connect(this, SIGNAL(saveYourself()), this, SLOT(sigSaveYourself()));
  };
  virtual ~_Application() {};

  protected slots:

    void sigKdisplayPaletteChanged() {
      _emit("kdisplayPaletteChanged", 0);
    };
    void sigKdisplayStyleChanged() {
      _emit("kdisplayStyleChanged", 0);
    };
    void sigKdisplayFontChanged() {
      _emit("kdisplayFontChanged", 0);
    };
    void sigAppearanceChanged() {
      _emit("appearanceChanged", 0);
    };
    void sigSaveYourself() {
      _emit("saveYourself", 0);
    };
};

#endif
