#ifndef _KRESTRICTEDLINEEDIT_H_
#define _KRESTRICTEDLINEEDIT_H_

#include <Python.h>
#include <krestrictedline.h>
#include "Baseobject.h"

class _RestrictedLine : public KRestrictedLine, public BaseObject
{
  Q_OBJECT	

  public:

    _RestrictedLine(QWidget *parent=0, const char *name=0, const char *valid=0) : KRestrictedLine(parent,name,valid), BaseObject() {
      connect(this, SIGNAL(textChanged(const char *)), this, SLOT(sigTextChanged(const char *)));
      connect(this, SIGNAL(invalidChar(int)), this, SLOT(sigInvalidChar(int)));
      connect(this, SIGNAL(returnPressed()), this, SLOT(sigReturnPressed()));
    };
    ~_RestrictedLine() {};

  public slots:

    void sigReturnPressed() {
      _emit("pressed", 0);
    };
    
    void sigTextChanged(const char *text) {
      PyObject *arg = Py_BuildValue("(s)",text);
      _emit("textChanged", arg);
      Py_DECREF(arg);
    };

    void sigInvalidChar(int c) {
      PyObject *arg = Py_BuildValue("(i)",c);
      _emit("invalidChar", arg);
      Py_DECREF(arg);
    };
};    

#endif
