import libqtpythonc
from baseobject import *


class QBrushPtr(BaseObjectPtr) :

    def __init__(self,this,name=""):
        BaseObjectPtr.__init__(self,name)
        self.this = this
        self.thisown = 0

    def __del__(self):
        if self.thisown == 1 :
            libqtpythonc.delete_QBrush(self.this)

    def style(self):
        val = libqtpythonc.QBrush_style(self.this)
        return val

    def setStyle(self,arg0):
        val = libqtpythonc.QBrush_setStyle(self.this,arg0)
        return val

    def color(self):
        val = libqtpythonc.QBrush_color(self.this)
        val = QColorPtr(val)
        return val

    def setColor(self,arg0):
        val = libqtpythonc.QBrush_setColor(self.this,arg0.this)
        return val

    def pixmap(self):
        val = libqtpythonc.QBrush_pixmap(self.this)
        val = QPixmapPtr(val)
        return val

    def setPixmap(self,arg0):
        val = libqtpythonc.QBrush_setPixmap(self.this,arg0.this)
        return val

    def __repr__(self):
        return "<Brush instance at %s>" % self.this

class QBrush(QBrushPtr):
    def __init__(self,name="") :
        QBrushPtr.__init__(self,"NULL",name)
        self.this = libqtpythonc.new_QBrush()
        self.thisown = 1


def QBrushStyle(arg0,name="") :
    val = QBrushPtr(libqtpythonc.new_QBrushStyle(arg0),name)
    val.thisown = 1
    return val

def QBrushColorStyle(arg0,style=libqtpythonc.SolidPattern,name="") :
    val = QBrushPtr(libqtpythonc.new_QBrushColorStyle(arg0.this,style),name)
    val.thisown = 1
    return val

def QBrushColorPixmap(arg0,arg1,name="") :
    val = QBrushPtr(libqtpythonc.new_QBrushColorPixmap(arg0.this,arg1.this),name)
    val.thisown = 1
    return val

def QBrushCopy(arg0,name="") :
    val = QBrushPtr(libqtpythonc.new_QBrushCopy(arg0.this),name)
    val.thisown = 1
    return val


NoBrush = libqtpythonc.NoBrush
SolidPattern = libqtpythonc.SolidPattern
Dense1Pattern = libqtpythonc.Dense1Pattern
Dense2Pattern = libqtpythonc.Dense2Pattern
Dense3Pattern = libqtpythonc.Dense3Pattern
Dense4Pattern = libqtpythonc.Dense4Pattern
Dense5Pattern = libqtpythonc.Dense5Pattern
Dense6Pattern = libqtpythonc.Dense6Pattern
Dense7Pattern = libqtpythonc.Dense7Pattern
HorPattern = libqtpythonc.HorPattern
VerPattern = libqtpythonc.VerPattern
CrossPattern = libqtpythonc.CrossPattern
BDiagPattern = libqtpythonc.BDiagPattern
FDiagPattern = libqtpythonc.FDiagPattern
DiagCrossPattern = libqtpythonc.DiagCrossPattern
CustomPattern = libqtpythonc.CustomPattern
