import libqtpythonc
from baseobject import *

class PenPtr(BaseObjectPtr) :

    def __init__(self,this,name=""):
        BaseObjectPtr(self,name)
        self.this = this
        self.thisown = 0

    def __del__(self):
        if self.thisown == 1 :
            libqtpythonc.delete_QPen(self.this)

    def style(self):
        val = libqtpythonc.QPen_style(self.this)
        return val

    def setStyle(self,arg0):
        val = libqtpythonc.QPen_setStyle(self.this,arg0)
        return val

    def width(self):
        val = libqtpythonc.QPen_width(self.this)
        return val

    def setWidth(self,arg0):
        val = libqtpythonc.QPen_setWidth(self.this,arg0)
        return val

    def color(self):
        val = libqtpythonc.QPen_color(self.this)
        val = ColorPtr(val)
        return val

    def setColor(self,arg0):
        val = libqtpythonc.QPen_setColor(self.this,arg0.this)
        return val

    def __repr__(self):
        return "<Pen instance at %s>" % self.this

class Pen(PenPtr):
    def __init__(self,name="") :
        PenPtr.__init__(self,"NULL",name)
        self.this = libqtpythonc.new_QPen()
        self.thisown = 1



def PenStyle(arg0,name="") :
    val = PenPtr(libqtpythonc.new_QPenStyle(arg0),name)
    val.thisown = 1
    return val

def PenColor(arg0,color,width=0,style=libqtpythonc.SolidLine,name="") :
    val = PenPtr(libqtpythonc.new_QPenColor(arg0.this,color,style),name)
    val.thisown = 1
    return val

def PenCopy(arg0,name="") :
    val = PenPtr(libqtpythonc.new_QPenCopy(arg0.this),name)
    val.thisown = 1
    return val


NoPen = libqtpythonc.NoPen
SolidLine = libqtpythonc.SolidLine
DashLine = libqtpythonc.DashLine
DotLine = libqtpythonc.DotLine
DashDotLine = libqtpythonc.DashDotLine
DashDotDotLine = libqtpythonc.DashDotDotLine
