// $Id: kpropdlg.cpp,v 1.13 1998/09/23 13:02:53 vespa Exp $
// (C) 1998 by F. Zigterman and Christopher Beard

#include "kpropdlg.h"
//#include "kpropdlg.moc"
#include "kapp.h"

#define QT_14

KPropDlg::KPropDlg( int dlgtype, int buttons, const char *title, QWidget *parent, const char *name, bool modal )
	: QDialog( parent, name, modal )
{
	// Set window props
	setCaption( title );
	//resize( 512,256 );

	// Set some characteristics
	PageList = new QList<QWidget>;
	DlgType = dlgtype;
	Buttons = buttons;
	TreeWidth = 150;

	VLayout = new QVBoxLayout( 0 );
	HLayout = new QHBoxLayout( this, 2 );
	
	PageFrame = new QFrame( this );
	PageFrame->setFrameStyle( QFrame::Panel|QFrame::Raised);

	ButtonBox = new KButtonBox( this, KButtonBox::HORIZONTAL, 6,6 );
	ButtonBox->setFixedHeight( 40 );
	ButtonBox->addStretch(10);

	// Page title label
	Title = new QLabel( "Unnamed Dialog", this );
	Title->setFrameStyle( QFrame::Panel|QFrame::Raised );
	Title->setFixedHeight( 20 );
	Title->setText( title );
	
	// create TreeList ( must be done before adding VLayout )
	if( DlgType == TREE )
	{
		TreeList = new KTreeList( this );
		TreeList->setFixedWidth( TreeWidth );
		HLayout->addWidget( TreeList );
		connect(TreeList, SIGNAL(highlighted(int)),this,SLOT(showPage(int)));
	}
	HLayout->addLayout( VLayout );


	//set title
	VLayout->addWidget( Title );

	// create TabControl
	if( DlgType == TABS )
	{
		QVBoxLayout *templayout;
		
		TabControl = new KTabCtl( PageFrame );
		templayout = new QVBoxLayout( PageFrame );
		templayout->addWidget( TabControl );
	}

	// fill the vlayout with widgets
	VLayout->addWidget( PageFrame );
	VLayout->addWidget( ButtonBox );

//	printf("layout complete\n");
	
	if( Buttons&PREV ) {
		PrevButton = ButtonBox->addButton( i18n("Prev") );
		connect (PrevButton, SIGNAL(clicked()), SLOT(receivePrev()));
	} 
        else PrevButton = 0;

	if( Buttons&NEXT ) {
		NextButton = ButtonBox->addButton( i18n("Next") );
		connect (NextButton, SIGNAL(clicked()), SLOT(receiveNext()));
	} 
        else NextButton = 0;

        if( Buttons&APPLY ) {
		ApplyButton = ButtonBox->addButton( i18n("Apply") );
		connect (ApplyButton, SIGNAL(clicked()), SLOT(receiveApply()));
	}
	else ApplyButton = 0;

	if( Buttons&OK ) {
 		OKButton = ButtonBox->addButton( i18n("OK") );
		connect( OKButton, SIGNAL(clicked()), SLOT(receiveOK()));
        }
	else OKButton = 0;
	
	if( Buttons&CANCEL ) {
	 	CancelButton = ButtonBox->addButton( i18n("Cancel") );
		connect (CancelButton, SIGNAL(clicked()), SLOT(receiveCancel()));
        }
	else CancelButton = 0;
	
	// Start button geomerty management
	ButtonBox->layout();

//	printf("bbox complete\n");

	OKButton->setDefault(TRUE);
	DefaultButton = OKButton;

	// Set button height and correct for motif default button size
	resizeButtons();
	connectButtons();

//	printf("complete\n");
}

void KPropDlg::connectButtons( int buttons )
{

	// Signals and Slots
	if( buttons&OK )	connect(this, SIGNAL(OKClicked()), SLOT(acceptConfig()));
	if( buttons&CANCEL )	connect(this, SIGNAL(CancelClicked()), SLOT(cancelConfig()));
	if( buttons&APPLY )	connect(this, SIGNAL(ApplyClicked()), SLOT(applyConfig()));

	if( buttons&PREV)	connect( this, SIGNAL(PrevClicked() ), SLOT( slotPrev() ) );
	if( buttons&NEXT )	connect( this, SIGNAL(NextClicked() ), SLOT( slotNext() ) );
	
}

KPropDlg::~KPropDlg()
{
}

QFrame *KPropDlg::addPage( int parentindex, const char *title, int position )
{
	QVBoxLayout *templayout;
	QFrame *page; 
	if( DlgType == TABS )
		page = new QFrame( TabControl, title );
	else
		page = new QFrame( PageFrame, title );

	//	printf("addPage\n");
	if( DlgType == TABS )
	{
		TabControl->addTab( page, title );
//		PageList->append( page ); 
	}
	else
	{
		if( DlgType == TREE )
		{
			TreeList->insertItem( title, 0, parentindex );
		}
		templayout = new QVBoxLayout( PageFrame,2 );
		templayout->addWidget( page );
		page->lower();
	}
	PageList->append( page );
	return page;
}

void KPropDlg::showPage(QWidget *w)
{
	int stat=0;

	// bring the new page up front
	w->raise();
//	w->setFocus();

	// change the header for the dialog

	// highlight the item in the tree view, most important for
	// first instantiation

	int index = PageList->find(w);
	//	printf("index:%d\n",index);
	if( DlgType == TREE )
	{
		Title->setText(w->name());
		TreeList->setCurrentItem(index);
	}
	
	stat = pageListStatus();
	//	printf("stat %X, %d, %d\n",stat, (stat&LASTPAGE)==0, !(stat&FIRSTPAGE)==0 );

	if( Buttons&NEXT ) NextButton->setEnabled( (stat&LASTPAGE)==0  );
	if( Buttons&PREV ) PrevButton->setEnabled( (stat&FIRSTPAGE)==0 );

}

bool KPropDlg::showPage(int index)
{
	// find the page in our list
	QWidget *page = PageList->at( index );

//	printf("display page %d, %X\n", index, page);
	
	if( page == 0 ) 
	{	warning("error in page num");
		return FALSE;
	}

	// request that it be brought up front
	showPage(page);
	return TRUE;
}

bool KPropDlg::removePage( char *page, int index )
{
	warning("Removing pages is not yet implemented.");
	return FALSE;
}

void KPropDlg::setButtonsEnabled( int types )
{
	ActiveButtons = types;
	PrevButton->setEnabled(  types&PREV  != 0 );
	NextButton->setEnabled(  types&NEXT  != 0 );
	ApplyButton->setEnabled( types&APPLY != 0 );
	OKButton->setEnabled(    types&OK    != 0 );
	CancelButton->setEnabled(types&CANCEL!= 0 );
}

int  KPropDlg::buttonsEnabled()
{
	return ActiveButtons;
}

void KPropDlg::setButton( int type, const char *text )
{
}

void KPropDlg::setDefaultButton( int type )
{
	DefaultButton->setDefault( FALSE );
	switch( type )
	{
	case OK:
		DefaultButton = OKButton;
		break;
	case CANCEL:
		DefaultButton = CancelButton;
		break;
	case PREV:
		DefaultButton = PrevButton;
		break;
	case NEXT:
		DefaultButton = NextButton;
		break;
	case APPLY:
		DefaultButton = ApplyButton;
		break;
//	default:	
	}
	DefaultButton->setDefault( TRUE );
	resizeButtons();
}

void KPropDlg::resizeButtons()
{
	QFontMetrics fm( font() );
	int bsize = fm.height() + fm.ascent();

	if( Buttons&OK )
	{
		OKButton->setFixedHeight( bsize );
#ifndef QT_14
		if( OKButton->isDefault() ) 	OKButton->setFixedHeight( bsize+8 );
#endif
 	}
	if( Buttons&CANCEL )
	{
		CancelButton->setFixedHeight( bsize );
#ifndef QT_14
		if( CancelButton->isDefault() )	CancelButton->setFixedHeight( bsize+8 );
#endif
	}
	if( Buttons&APPLY )
	{
		ApplyButton->setFixedHeight( bsize );
#ifndef QT_14
		if( ApplyButton->isDefault() )	ApplyButton->setFixedHeight( bsize+8 );
#endif
	}
	if( Buttons&NEXT )
	{
		NextButton->setFixedHeight( bsize );
#ifndef QT_14
		if( NextButton->isDefault() )	NextButton->setFixedHeight( bsize+8 );
#endif
	}
	if( Buttons&PREV )
	{
		PrevButton->setFixedHeight( bsize );
#ifndef QT_14
		if( PrevButton->isDefault() )	PrevButton->setFixedHeight( bsize+8 );
#endif
	}
}	

void KPropDlg::receiveOK()
{
	emit OKClicked();
}

void KPropDlg::receiveCancel() {
	emit CancelClicked();
}

void KPropDlg::receiveNext() {
	emit NextClicked();
}

void KPropDlg::receivePrev() {
	emit PrevClicked();
}

void KPropDlg::receiveApply() {
	emit ApplyClicked();
}

void KPropDlg::slotNext()
{
	int stat = pageListStatus();
//	printf("statnext %X, %d, %d\n",stat, (stat&LASTPAGE)==0, !(stat&FIRSTPAGE)==0 );

	if( stat < NOCURRENT &&stat !=0 ) return;
	PageList->next();

	showPage( PageList->at() );
}

void KPropDlg::slotPrev()
{
	int stat = pageListStatus();
//	printf("statprev %X, %d, %d\n",stat, (stat&LASTPAGE)==0, !(stat&FIRSTPAGE)==0 );

	if( stat < NOCURRENT && stat !=0 ) return;
	PageList->prev();

	showPage( PageList->at() );
}


int KPropDlg::pageListStatus()
{
	int status = 0;
	if( ! PageList ) return NOLIST;
	if( ! PageList->count() ) return NOPAGES;
	if( ! PageList->current() ) return NOCURRENT;
	if( PageList->current() == PageList->getLast() ) status = LASTPAGE;
	if( PageList->current() == PageList->getFirst() ) status = FIRSTPAGE;
	return status;
}

void KPropDlg::acceptConfig()
{
	// Write configuration and exit dialog cleanly.

	emit setConfig();
	kapp->getConfig()->sync();
	emit configChanged();
	accept();
}

void KPropDlg::cancelConfig()
{
	// Don't write configuration and cancel dialog.
	reject();
}

void KPropDlg::applyConfig()
{
	// Write configuration and return to dialog.
	//printf("applyConfig\n");
	emit setConfig();
	emit configChanged();
}

void KPropDlg::connectConfig( QObject * propconf )
{
  //	printf("connecting.\n");
	connect( this, 
			SIGNAL( setConfig() ), 
			propconf, 
			SLOT( setConfig() ) 
			);
	connect( this, 
			SIGNAL( getConfig() ), 
			propconf, 
			SLOT( getConfig() ) 
			);
}
