#include <qlayout.h>
#include <qlabel.h>

#include "ktictactoe.moc"

KTicTacToe::KTicTacToe (QWidget *parent, const char *name) :
  QWidget (parent, name)
{
  int row, col;

  QGridLayout *layout = new QGridLayout (this, 4, 3);

  const int rowlabel0 = 0, rowlabel1 = 0, collabel0 = 0, collabel1 = 2,
    rowsquares0 = 1, rowsquares1 = 4, colsquares0 = 0, colsquares1 = 3;

  for (row=rowsquares0; row<rowsquares1; row++)
    for (col=colsquares0; col<colsquares1; col++)
      {
	KXOSquare *kxosquare = new KXOSquare (this);
	layout->addWidget (kxosquare, row, col);
	connect ( kxosquare,
		  SIGNAL (changeRequest (KXOSquare *, KXOSquare::State)),
		  SLOT (processClicks (KXOSquare *, KXOSquare::State)) );
      }

  QLabel *label = new QLabel ("Tic-Tac-Toe", this);
  label->setAlignment (Qt::AlignCenter);
  layout->addMultiCellWidget (label,
			      rowlabel0, rowlabel1,
			      collabel0, collabel1);
}


void
KTicTacToe::processClicks (KXOSquare *square, KXOSquare::State state)
{
  //In this simple example, just pass along the click to the appropriate
  // square.
  square->newState (state);
}



//mention: should delete squares!!


