#include <qpixmap.h>
#include <qpainter.h>
#include <qfileinfo.h>

#include <kimageio.h>

#include "kimageview.h"

KImageView::KImageView (const QString &_filename, 
			QWidget *parent, const char *name=0) :
  QWidget (parent, name)
{
  KImageIO::registerFormats();

  filename = _filename;

 qpixmap = new QPixmap;
  qpixmap->load (filename);

  QPainter qpainter (qpixmap);
  qpainter.setPen (QPen (Qt::green, 10));
  qpainter.drawRect (qpixmap->rect());

  QFileInfo qfileinfo (filename);
  qpixmap->save (qfileinfo.baseName() + ".png", "PNG");
}

void
KImageView::paintEvent (QPaintEvent *)
{
  QPainter qpainter (this);

  qpainter.drawPixmap (0, 0, *qpixmap);
}

