#include "cupsaccessparser.h"

#include <klocale.h>

CupsAccessParser::CupsAccessParser( QObject *parent )
	: CupsParser( "AccessParser", "/var/log/cups/access_log", parent )
{
	m_re.setPattern( "(\\S+) - (\\S+) \\[([^]]+)\\] \"([^\"]+)\" (\\d+) (\\d+)" );
}

CupsAccessParser::~CupsAccessParser()
{
}

QStringList CupsAccessParser::fields()
{
	return QStringList() << i18n( "Originating host" ) << i18n( "User name" ) 
		<< i18n( "HTTP request" ) << i18n( "Result code" ) << i18n( "Request size" );
}

CupsParser::Item* CupsAccessParser::lineToItem( const QString& line )
{
	Item *item = 0;
	if ( m_re.exactMatch( line ) )
	{
		item = new Item( 5 );
		item->fulldata = m_re.cap( 4 );
		int pos = item->fulldata.find( ' ' );
		item->fields[ 0 ] = m_re.cap( 1 );
		item->fields[ 1 ] = m_re.cap( 2 );
		item->fields[ 2 ] = item->fulldata.left( pos );
		item->fields[ 3 ] = m_re.cap( 5 ).toInt();
		item->fields[ 4 ] = m_re.cap( 6 ).toInt();
		item->parseDate( m_re.cap( 3 ) );
		switch ( m_re.cap( 5 ).at( 0 ).latin1() )
		{
			case '2':
				item->pixmap = "button_ok";
				break;
			case '4':
				item->pixmap = "stop";
				break;
			default:
				item->pixmap = "html";
				break;
		}
	}
	return item;
}

#include "cupsaccessparser.moc"
