/***************************************************************************
                          settings.cpp  -  description                              
                             -------------------                                         
    begin                : Sat May 20 2000                                           
    copyright            : (C) 2000 by Rajko Albrecht                         
    email                : Rajko.Albrecht@informatik.tu-chemnitz.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef rcsid
static const char rcsid[]="$Id: settings.cpp,v 2.7 2001/04/08 11:48:50 ral Exp $";
#endif

#include "settings.h"
#include <pwd.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string>
#include <errno.h>
#include <stdio.h>
#include "kmysqladmin/helpers/helpers.h"
#include <qfont.h>

#define _GLOBAL_SECTION "global"
#define _USER "last_user"
#define _HOST "last_host"
#define _PORT "last_port"
#define _PASS "last_password"

#define _FIX_FONT_NAME "fixed_font_name"
#define _FIX_FONT_SIZE "fixed_font_size"
#define _FIX_FONT_WEIGHT "fixed_font_weight"
#define _FIX_FONT_ITALIC "fixed_font_italic"
#define _FIX_FONT_CHAR_SET "fixed_font_charset"

#define _NPROP_FONT_NAME "nprop_font_name"
#define _NPROP_FONT_SIZE "nprop_font_size"
#define _NPROP_FONT_WEIGHT "nprop_font_weight"
#define _NPROP_FONT_ITALIC "nprop_font_italic"
#define _NPROP_FONT_CHAR_SET "nprop_font_charset"

#define _THREAD_POLLTIME "thread_polltime"
#define _STATUS_POLLTIME "status_polltime"

//CProfile LastInit;
//CProfile GlobalSettings;

CSettings GlobalSettings;

using namespace std;

void CSettings::set_fixed_font( const std::string name, const int size, const int weight, const bool italic, const int charset)
{
    FontSettings.SetValue(_FIX_FONT_NAME,name);
    FontSettings.SetValue(_FIX_FONT_SIZE,size);
    FontSettings.SetValue(_FIX_FONT_WEIGHT,weight);
    FontSettings.SetValue(_FIX_FONT_ITALIC,italic);
    FontSettings.SetValue(_FIX_FONT_CHAR_SET,charset);
    make_f_font_signal();
}

void CSettings::set_fixed_font(const QFont&fnt)
{
    std::string name;
    int size,weight,charset;
    bool italic;
    FontToParameter(fnt,name,size,weight,italic,charset);
    set_fixed_font(name,size,weight,italic,charset);
}

void CSettings::get_fixed_font(std::string&name, int&size, int&weight, bool&italic, int&charset)
{
    name = FontSettings.ReadValue(_FIX_FONT_NAME,"fixed");
    size = FontSettings.ReadValue(_FIX_FONT_SIZE,10);
    weight = FontSettings.ReadValue(_FIX_FONT_WEIGHT,50);
    italic = FontSettings.ReadValue(_FIX_FONT_ITALIC,false);
    charset = FontSettings.ReadValue(_FIX_FONT_CHAR_SET,0);
}

QFont CSettings::get_fixed_font()
{
    QFont fnt;
    std::string name;
    int size,weight,charset;
    bool it;
    name = FontSettings.ReadValue(_FIX_FONT_NAME,std::string("fixed"));
    size = FontSettings.ReadValue(_FIX_FONT_SIZE,10);
    weight = FontSettings.ReadValue(_FIX_FONT_WEIGHT,50);
    it = FontSettings.ReadValue(_FIX_FONT_ITALIC,false);
    charset = FontSettings.ReadValue(_FIX_FONT_CHAR_SET,0);
    ParameterToFont(fnt,name,size,weight,it,charset);
    return fnt;
}

void CSettings::set_nprop_font( std::string name, int size, int weight, bool italic, int charset)
{
    FontSettings.SetValue(_NPROP_FONT_NAME,name);
    FontSettings.SetValue(_NPROP_FONT_SIZE,size);
    FontSettings.SetValue(_NPROP_FONT_WEIGHT,weight);
    FontSettings.SetValue(_NPROP_FONT_ITALIC,italic);
    FontSettings.SetValue(_NPROP_FONT_CHAR_SET,charset);
    make_np_font_signal();
}

void CSettings::set_nprop_font(const QFont&fnt)
{
    std::string name;
    int size,weight,charset;
    bool italic;
    FontToParameter(fnt,name,size,weight,italic,charset);
    set_nprop_font(name,size,weight,italic,charset);
}

QFont CSettings::get_nonprop_font()
{
    QFont fnt;
    std::string name;
    int size,weight,charset;
    bool it;
    name = FontSettings.ReadValue(_NPROP_FONT_NAME,std::string("helvetica"));
    size = FontSettings.ReadValue(_NPROP_FONT_SIZE,10);
    weight = FontSettings.ReadValue(_NPROP_FONT_WEIGHT,50);
    it = FontSettings.ReadValue(_NPROP_FONT_ITALIC,false);
    charset = FontSettings.ReadValue(_NPROP_FONT_CHAR_SET,0);
    ParameterToFont(fnt,name,size,weight,it,charset);
    return fnt;
}

bool CSettings::init_files()
{
    uid_t user_id;
    struct passwd*zgr;
    std::string init_file;
    int ret;
    FILE*init_f;

    user_id = geteuid();
    zgr = getpwuid(user_id);
    init_file = zgr->pw_dir;
    init_file+="/.kmysqladmin";
    int mode = 127;

    ret = mkdir(init_file.c_str(),S_IRUSR|S_IWUSR|S_IXUSR );
    if (ret == -1) {
	if (errno == EEXIST) {
	    ret = 0;
	} else {
	    perror("Error creating DIR");
	}
    }

    if (ret == -1) {
	return false;
    }
    ret = chmod(init_file.c_str(),S_IRUSR|S_IWUSR|S_IXUSR);
    std::string settings_file = init_file;

    init_file+="/last_session";
    settings_file+="/Settings";

    mode = umask(mode);
    
    init_f = fopen(init_file.c_str(),"a+");

    if (!init_f) 
	perror("Error open file");
    else
	fclose(init_f);
    
    init_f = fopen(settings_file.c_str(),"a+");
    if (!init_f) 
	perror("Error open settings file");
    else
	fclose(init_f);

    umask(mode);

    chmod(init_file.c_str(),S_IRUSR|S_IWUSR);

    LastInit.FileName(init_file);
    GlobalSettings.FileName(settings_file);
    FontSettings.FileName(settings_file);

    LastInit.Path() = "GLOBALS";
    GlobalSettings.Path() = "GLOBALS";
    FontSettings.Path()="FONTS";

    return true;
}

CSettings::CSettings()
{
    init_files();
}

CSettings::~CSettings()
{
}

void CSettings::SaveLastLogin(const std::string user,const std::string host,
		   const std::string port,const std::string pass)
{
    LastInit.SetValue(_USER,user);
    LastInit.SetValue(_HOST,host);
    LastInit.SetValue(_PORT,port);
    LastInit.SetValue(_PASS,pass);
}

bool CSettings::RetrieveLastLogin(std::string&user,std::string&host,
				  std::string&port,std::string&pass)
{
    std::string def = "";
    user = LastInit.ReadValue(_USER,def);
    host = LastInit.ReadValue(_HOST,def);
    port = LastInit.ReadValue(_PORT,def);
    pass = LastInit.ReadValue(_PASS,def);
    return true;
}

void CSettings::ThreadPolltime(int aTimeout)
{
    GlobalSettings.SetValue(_THREAD_POLLTIME,aTimeout);
    make_thread_signal(aTimeout);
}

int CSettings::ThreadPolltime()const
{
    return GlobalSettings.ReadValue(_THREAD_POLLTIME,(int)60);
}

void CSettings::StatusPolltime(int aTimeout)
{
    GlobalSettings.SetValue(_STATUS_POLLTIME,aTimeout);
    make_status_signal(aTimeout);
}

int CSettings::StatusPolltime()const
{
    return GlobalSettings.ReadValue(_STATUS_POLLTIME,(int)60);
}
