/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qdialog.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlist.h>
#include <qlayout.h>

#include <stdio.h>

#define MAX_HIGHSCORES 5

class CListElement
{
 public:
	CListElement(int s, QString n) { _score = s; _name = n; }
	int _score;
	QString _name;
};

class CHighscoreDialog : public QDialog
{
	Q_OBJECT
 public:
	CHighscoreDialog(QWidget* parent,int ys);
	void initializeDialog();
	virtual ~CHighscoreDialog();

 protected:
// Shows a dialog which prompts the user for his name. Returns the name
	QString nameDialog();

// unused
	void getHighscoreFile(QString& name);
// reads the highscore list from a file, returns the position of the player
	char readList();
	bool writeList();

	int _yourScore; // value 0 means: called outside of a game

	QLabel* _yourResult;
	QListBox* _listBox;
	QPushButton* _ok;
        QVBoxLayout* _vbox;

	QList<CListElement>* _list;
};
