/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "main.h"

#include "kpuzzle.h"
#include "piece.h"

#include <kapp.h>
//#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include <qcache.h>
#include <qbitmap.h>


static const char *description =
    I18N_NOOP("A KDE-based jigsaw puzzle.");

static const char *version = "v0.2";

int main(int argc, char **argv)
{
        KAboutData about("kpuzzle", I18N_NOOP("KPuzzle"), version, description, KAboutData::License_GPL, "(C) 2000 Michael Wand");
        about.addAuthor( "Michael Wand", 0, "mwand@gmx.de" );
        KCmdLineArgs::init(argc, argv, &about);
        KApplication app;

        maskCache = new QCache<QBitmap>;

// register ourselves as a dcop client
//    app.dcopClient()->registerAs(app.name(), false);

#ifdef DEBUG
    debug("DEBUG is defined");
#endif

//    kill(getpid(),SIGSEGV);
    // see if we are starting with session management
        if (app.isRestored())
                RESTORE(KPuzzle)
                        else {
                                // no session.. just start up normally
                                KPuzzle *widget = new KPuzzle;
                                //        if (argc > 1)
                                //  widget->load(argv[1]);
                                widget->show();
                        }

        return app.exec();
}
