/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "main.h"

#include "prefs.h"

#include "kpuzzle.h"

#include <kapp.h>

CPrefsDialog::CPrefsDialog(QWidget* parent) : QDialog(parent,0,true)
{
        setCaption(i18n("Dialog title","Preferences"));

        _mask = new QCheckBox(i18n("Use piece &mask"),this);
//	_mask->setFixedWidth(150);

	_turn = new QCheckBox(i18n("&Turn pieces around"),this);
//	_turn->setFixedWidth(150);

        _right = new QCheckBox(i18n("Right &Key pans around image"),this);

        _main = new QCheckBox(i18n("&Allow \"Show full pixmap\" option"),this);

	_loading = new QButtonGroup(i18n("Load images"),this);
        _group = new QVBoxLayout(_loading,20);
	_ilOnUse = new QRadioButton(i18n("&On use"),_loading);
        _group->addWidget(_ilOnUse);
// 	_ilOnUse->move(20,20);
// 	_ilOnUse->setFixedWidth(100);
	_ilKeep = new QRadioButton(i18n("&Keep"),_loading);
        _group->addWidget(_ilKeep);
// 	_ilKeep->move(20,_ilOnUse->y() + _ilOnUse->height() + 10);
// 	_ilKeep->setFixedWidth(100);
	_ilPreload = new QRadioButton(i18n("&Preload"),_loading);
        _group->addWidget(_ilPreload);
// 	_ilPreload->move(20,_ilKeep->y() + _ilKeep->height() + 10);
// 	_ilPreload->setFixedWidth(100);

// 	_loading->setFixedWidth(200);
// 	_loading->setFixedSize(QSize(150,_ilPreload->y() + _ilPreload->height() + 20));

	_ok = new QPushButton(i18n("OK"),this);
	_ok->setDefault(true);
	connect(_ok,SIGNAL(clicked()),this,SLOT(accept()));
	_cancel = new QPushButton(i18n("Cancel"),this);
	connect(_cancel,SIGNAL(clicked()),this,SLOT(reject()));
        _help = new QPushButton(i18n("Help"),this);
        connect(_help,SIGNAL(clicked()),this,SLOT(slotHelp()));

	_buttons = new QHBoxLayout(20);

	_elements = new QVBoxLayout(this,20);
	_elements->addWidget(_mask);
	_elements->addWidget(_turn);
        _elements->addWidget(_right);
        _elements->addWidget(_main);
	_elements->addWidget(_loading);
	_elements->addLayout(_buttons);

	_buttons->addWidget(_ok);
	_buttons->addWidget(_cancel);
        _buttons->addWidget(_help);

	_elements->activate();

//	resize(260,320);
}

CPrefsDialog::~CPrefsDialog()
{
	delete _buttons;
	delete _elements;
	delete _ilOnUse;
	delete _ilKeep;
	delete _ilPreload;
	delete _loading;
	delete _mask;
        delete _main;
	delete _turn;
}

void CPrefsDialog::setValues()
{
	_mask->setChecked(_usePieceMask);
	_turn->setChecked(_turnPiecesAround);
        _right->setChecked(_rightKeyPansAround);
        _main->setChecked(_showMainPixmap);
	_ilOnUse->setChecked(_imageLoading == IL_ON_USE);
	_ilKeep->setChecked(_imageLoading == IL_KEEP);
	_ilPreload->setChecked(_imageLoading == IL_PRELOAD);
}

void CPrefsDialog::retrieveValues()
{
	_usePieceMask = _mask->isChecked();
	_turnPiecesAround = _turn->isChecked();
        _rightKeyPansAround = _right->isChecked();
        _showMainPixmap = _main->isChecked();
	_imageLoading = (_ilOnUse->isChecked() ? IL_ON_USE : (_ilKeep->isChecked() ? IL_KEEP : IL_PRELOAD));
}

void CPrefsDialog::slotHelp()
{
        kapp->invokeHTMLHelp(HF_DIALOG_PROPERTIES,HA_DIALOG_PROPERTIES);
        debug("CPrefsDialog: help invoked");
}
