/***************************************************************************
                          kexsource.cpp  -  description
                             -------------------
    begin                : Wed Mar 6 2002
    copyright            : (C) 2002 by Tero Favorin
    email                : tero@favorin.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlayout.h>

#include <kapp.h>
#include <kurllabel.h>
#include <klocale.h>
#include <kdialog.h>
#include <kglobalsettings.h>

#include "kexdatasource.h"
#include "kexsource.h"

KExSource::KExSource(QWidget *parent, const char *name ) : QWidget(parent,name) {
	QFont font=KGlobalSettings::generalFont();
	font.setPointSize(font.pointSize()-2);

	QGridLayout *layout =new QGridLayout(this,2,2);
	layout->setColStretch(1, 1);
	heading=new QLabel(i18n("Date source: "),this);
	heading->setFont(font);
	layout->addWidget(heading,0,0);

	source=new KURLLabel(this);
	source->setFont(font);
	layout->addWidget(source,0,1);
  connect(source, SIGNAL(leftClickedURL(const QString&)),this, SLOT(showURL(const QString&)));

	copyright=new QLabel(this);
	copyright->setFont(font);
	layout->addWidget(copyright,1,1);

}
KExSource::~KExSource(){
}
void KExSource::setSource(KExDataSource *data) {
 	source->setText(data->source());
	source->setURL(data->sourceURL());
	copyright->setText(data->copyright());
}
void KExSource::showURL(const QString& url) {
	kapp->invokeBrowser(url); 	
}
