/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#include <qtimer.h>
#include <qpixmap.h>
#include <kapp.h>
#if QT_VERSION >= 200
#include <kstddirs.h>
#include <kiconloader.h>
#endif
#include "gear.h"
#include "gear.moc"


Gear::Gear(QWidget *parent, const char *name)
    : QLabel(parent, name)
{
    timer = new QTimer(this);
    connect( timer, SIGNAL(timeout()), SLOT(nextPixmap()) );
    pixmaps.setAutoDelete(true);

#if QT_VERSION >= 200
    QStringList icons = KGlobal::iconLoader()->loadAnimated("kde", KIcon::MainToolbar, 32);
    QStringList::Iterator it;
    for (it = icons.begin(); it != icons.end(); ++it)
        pixmaps.append(new QPixmap(MainBarIcon(*it, 32)));
    while (pixmaps.count() < 9)
        pixmaps.append(new QPixmap(""));
#else    
    QString pattern = kapp->kde_datadir() + "/kfm/pics/kde%d.xpm";
    for (int i = 1; i <= 9; ++i)
        {
            QString fn;
            fn.sprintf(pattern, i);
            pixmaps.append(new QPixmap(fn));
        }
#endif
    //    if (pixmaps.count())
    setPixmap(*pixmaps.at(no = 0));
}

Gear::~Gear()
{
    delete timer;
}


void Gear::start()
{
    timer->start(50);
}


void Gear::stop()
{
    timer->stop();
}


void Gear::nextPixmap()
{
    no = (no == 8)? 0 : no+1;
    setPixmap(*pixmaps.at(no));
}
