/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#include <qlayout.h>
#include <qbuttongroup.h>
#include <kapp.h>
#include <kbuttonbox.h>
#include <klocale.h>
#include "misc.h"

#include "updatedlg.h"
#include "updatedlg.moc"


UpdateDialog::UpdateDialog(QWidget *parent, const char *name)
    : QDialog(parent, name, true)
{
    setCaption(i18n("CVS Update"));

    QBoxLayout *layout = new QVBoxLayout(this, 10);

    bytag_button = new QRadioButton(i18n("Update to &tag: "), this);
    bytag_button->setChecked(true);
    bytag_button->setMinimumSize(bytag_button->sizeHint());
    layout->addWidget(bytag_button);

    QBoxLayout *tagedit_layout = new QHBoxLayout();
    layout->addLayout(tagedit_layout);
    tag_edit = new QLineEdit(this);
    tag_edit->setFocus();
    QFontMetrics fm(fontMetrics());
    tag_edit->setMinimumSize(fm.width("0")*30, tag_edit->sizeHint().height());
    tagedit_layout->addSpacing(15);
    tagedit_layout->addWidget(tag_edit);
    
    bydate_button = new QRadioButton(i18n("Update to &date:\n"
                                          "(Possible format: 'yyyy-mm-dd')"), this);
    bydate_button->setMinimumSize(bydate_button->sizeHint());
    layout->addWidget(bydate_button);

    QBoxLayout *dateedit_layout = new QHBoxLayout();
    layout->addLayout(dateedit_layout);
    date_edit = new QLineEdit(this);
    date_edit->setEnabled(false);
    date_edit->setMinimumSize(tag_edit->sizeHint());
    dateedit_layout->addSpacing(15);
    dateedit_layout->addWidget(date_edit);

    group = new QButtonGroup();
    group->insert(bytag_button);
    group->insert(bydate_button);
    connect( bytag_button, SIGNAL(toggled(bool)),
             this, SLOT(toggled()) );

    QFrame *frame = new QFrame(this);
    frame->setFrameStyle(QFrame::HLine | QFrame::Sunken);
    frame->setMinimumHeight(frame->sizeHint().height());
    layout->addWidget(frame, 0);

    KButtonBox *buttonbox = new KButtonBox(this);
    buttonbox->addStretch();
    QPushButton *ok = buttonbox->addButton(i18n("OK"));
    QPushButton *cancel = buttonbox->addButton(i18n("Cancel"));
    ok->setDefault(true);
    connect( ok, SIGNAL(clicked()), this, SLOT(accept()) );
    connect( cancel, SIGNAL(clicked()), this, SLOT(reject()) );
    buttonbox->layout();
    layout->addWidget(buttonbox, 0);

    layout->activate();
    resize(sizeHint());
}


void UpdateDialog::toggled()
{
    bool bytag = bytag_button->isChecked();
    tag_edit->setEnabled(bytag);
    date_edit->setEnabled(!bytag);
    if (bytag)
        tag_edit->setFocus();
    else
        date_edit->setFocus();
}


UpdateDialog::~UpdateDialog()
{
    delete group;
}

// Local Variables:
// c-basic-offset: 4
// End:

    
