/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifndef _UPDATEVIEW_H_
#define _UPDATEVIEW_H_

#include <qlistview.h>


class UpdateDirItem;


class UpdateView : public QListView
{
    Q_OBJECT
    
public:

    enum Status { LocallyModified, LocallyAdded, LocallyRemoved,
		  NeedsUpdate, NeedsPatch, NeedsMerge,
		  UpToDate, Conflict, 
		  Updated, Patched, Removed,
                  NotInCVS, Unknown, Indefinite };
    enum Action { Add, Remove, Update, UpdateNoAct, Commit };
    
    UpdateView( QWidget *parent=0, const char *name=0 );

    static bool isDirItem(QListViewItem *item);
    bool hasSingleSelection();
    void getSingleSelection(QString *filename, QString *revision=0);
    QStrList multipleSelection();
    void openDirectory(QString dirname);
    void scanRecursive();
    void prepareJob(bool recursive, Action action);

public slots:
    void deselectAll();
    void unfoldTree();
    void finishJob(bool success);
    void processUpdateLine(QString line);

private:
    void updateItem(QString filename, Status status, bool isdir);
    void rememberSelection(bool recursive);
    void syncSelection();
    void markUpdated(bool laststage, bool success);
    QString dirname;
    Action act;
    QList<QListViewItem> relevantSelection;
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:
