/***************************************************************************
                          kleandisk.cpp  -  description
                             -------------------
    begin                : Sat Oct  9 16:19:54 CEST 1999
    copyright            : (C) 1999 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kleandisk.h"
#include <kapp.h>
#include <klocale.h>

//#include <kio/jobclasses.h>
#include <kio/global.h>

#include <kfileitem.h>
#include <iostream.h>

Kleandisk::Kleandisk () : KMainWindow() {
	sessionConfig = KGlobal::config();
	TabWidget = new QTabWidget(this);
	TabWidget -> move(0,0);
	TabWidget -> setGeometry(10,10,340,240);
	TabWidget -> show();

	//cleanup tab
	cleanUpTab = new QWidget();
	choice_1 = new ButtonAndText(
		cleanUpTab,
		i18n("User Defined Filegroups"),
		i18n("Scans harddisk for user defined file types.")
		);
	choice_1 -> button -> setText("UDG Viewer");
	choice_1 -> setGeometry(10,30,320,200);
	
	//restore tab
	restoreTab = new QWidget();
	choice_4 = new ButtonAndText(
		restoreTab,
		i18n("Restore Files"),
		i18n("Restores files that have been archived and/or backed up.")
		);
	choice_4 -> button -> setText("Restore");
	choice_4 -> setGeometry(10,30,320,200);

	TabWidget -> addTab(cleanUpTab, i18n("Clean up"));
	TabWidget -> addTab(restoreTab,i18n("Restore"));

	exitButton = new QPushButton(this);
	exitButton -> setText(i18n("Exit"));
	exitButton -> move(250,260);

	helpButton = new QPushButton(this);
	helpButton -> setText(i18n("Help"));
	helpButton -> move(140,260);


	this -> setFixedSize(360,300);
	
	groupManager = new GroupManager();
	groupManager -> startScheduling();
	
	connect(choice_1 -> button, SIGNAL(clicked()), SLOT(slotGroupViewer()));
	connect(choice_4 -> button, SIGNAL(clicked()), SLOT(slotRestoreItems()));
	connect(exitButton,SIGNAL(clicked()), SLOT(slotExit()));
	connect(helpButton,SIGNAL(clicked()), SLOT(slotHelp()));
/*
// some test code
	cout << "start\n";
//	namespace KIO;
	KIO::ListJob * job = KIO::listDir("/home/buursink");
	connect(job, SIGNAL(entries(KIO::Job *,const KIO::UDSEntryList& )),
		SLOT(slotData(KIO::Job *, const KIO::UDSEntryList&)));
*/
}

/*
void Kleandisk::slotData(KIO::Job * j, const KIO::UDSEntryList& l){
//	for (int i = 0; i < l.count(); i++)
//	cout << l.count()<< "\n";
	QString tmp= l[1][0];
//	first().m_str;
//  UDSEntry::Iterator it;
//	for( it = l.first().begin(); it != l.first().end(); ++it )
//		cout << (*it).m_str;
}
*/

Kleandisk::~Kleandisk(){
}

void Kleandisk::slotGroupViewer(){
	groupViewWindow = new GroupViewWindow(groupManager);
	groupViewWindow -> show();	
}

void Kleandisk::slotRestoreItems(){
	restoreWizard = new RestoreWizard();
	restoreWizard -> exec();
}

void Kleandisk::slotExit(){
	groupManager -> save();
	kapp -> exit(0);
}

void Kleandisk::slotHelp(){
	kapp -> invokeHTMLHelp("kleandisk/index.html","");
}

void Kleandisk::slotInstall(){
	installWizard = new InstallWizard();
	installWizard -> exec();
}

void Kleandisk::closeEvent(QCloseEvent * dummy){
	groupManager -> save();
}

void Kleandisk::slotShow(){
	show();
}
