/***************************************************************************
                          schedule.h  -  description
                             -------------------
    begin                : Sat Aug 12 2000
    copyright            : (C) 2000 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          schedule.h  -  description
                             -------------------
    begin                : Wed Mar 1 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCHEDULE_H
#define SCHEDULE_H

#include <qobject.h>
#include <qtimer.h>
#include <qlist.h>
#include <qdatetime.h>

/**
  *@author Arjan Buursink
  */

class Schedule : public QObject  {
	Q_OBJECT
public: 
	Schedule();
	~Schedule();
	void addDay(int);
	void addHour(int);
	void addMinute(int);
	void setDayList(QList<int>);
	void setHourList(QList<int>);
	void setMinuteList(QList<int>);
	void delDay(int);
	void delHour(int);
	void delMinute(int);
	void setDayCycle(int i){ daycl = i;};
	void setHourCycle(int i){ hourcl = i;};
	void setMinuteCycle(int i){ minutecl = i;};
	int dayCycle() { return daycl;};
	int hourCycle() { return hourcl;};
	int minuteCycle() { return minutecl;};
	void start();
	void stop();
	QList<int> dayList() { return daylst;};
	QList<int> hourList() { return hourlst;};
	QList<int> minuteList() { return minutelst;};
	void clearDayList() { daylst.clear(); };
	void clearHourList() { hourlst.clear(); };
	void clearMinuteList() { minutelst.clear(); };
	bool inDayList(int);
	bool inHourList(int);
	bool inMinuteList(int);
	QDateTime lastEvent();
	bool isIllegalSchedule();
private:
	QList<int> daylst;
	QList<int> hourlst;
	QList<int> minutelst;
	int daycl;
	int hourcl;
	int minutecl;
	QTimer * timer;
private slots:
	void slotEvent();
signals:
	void action();
};

#endif
