/***************************************************************************
                          schedulewidget.cpp  -  description
                             -------------------
    begin                : Mon Mar 6 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "schedulewidget.h"
#include <qtooltip.h>
#include <kapp.h>
#include <klocale.h>

ScheduleWidget::ScheduleWidget(FileGroupExt * g, QWidget *parent, const char *name) : QWidget(parent,name){
	initDialog();
	group = g;
	QLabel_1 -> setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	QLabel_2 -> setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	QLabel_3 -> setFrameStyle(QFrame::WinPanel | QFrame::Sunken);

	QButtonGroup_1 -> insert(QRadioButton_1);
	QButtonGroup_1 -> insert(QRadioButton_2);
	QButtonGroup_1 -> insert(QRadioButton_3);
	QButtonGroup_1 -> hide();
	QRadioButton_1 -> setChecked(true);

	QSpinBox_1 -> setRange(1,31);
	QSpinBox_2 -> setRange(0,23);
	QSpinBox_3 -> setRange(0,59);

	QComboBox_1 -> insertItem(i18n("Delete & Backup"));
	QComboBox_1 -> insertItem(i18n("Delete"));
	QComboBox_1 -> insertItem(i18n("Archive"));
//	QComboBox_1 -> insertItem(i18n("Move"));
	QComboBox_1 -> setCurrentItem(g -> getAction());

	QToolTip::add(QComboBox_1, i18n("Select an action to schedule"));

	QToolTip::add(QRadioButton_1, i18n("Days can be added to or removed from the list when this radio button is checked"));
	QToolTip::add(QRadioButton_2, i18n("Hours can be added to or removed from the list when this radio button is checked"));
	QToolTip::add(QRadioButton_3, i18n("Minutes can be added to or removed from the list when this radio button is checked"));

	QToolTip::add(QCheckBox_1, i18n("When this box is checked a cycle can be added to the list. E.g. every 2 days"));
	QToolTip::add(QCheckBox_2, i18n("When this box is checked a cycle can be added to the list. E.g. every 2 hours"));
	QToolTip::add(QCheckBox_3, i18n("When this box is checked a cycle can be added to the list. E.g. every 10 minutes"));

	QToolTip::add(QSpinBox_1, i18n("This number represents the day that can be added to or deleted from the list"));
	QToolTip::add(QSpinBox_2, i18n("This number represents the hour that can be added to or deleted from the list"));
	QToolTip::add(QSpinBox_3, i18n("This number represents the minute that can be added to or deleted from the list"));

	QToolTip::add(QPushButton_1, i18n("Push this button to add/delete a day, an hour or a minute to the list"));
	QToolTip::add(QPushButton_2, i18n("Push this button to clear the list"));

	schedule = new Schedule;
	connect(QPushButton_1,SIGNAL(clicked()),SLOT(slotAddClicked()));
	connect(QPushButton_2, SIGNAL(clicked()), SLOT(slotClearList()));

	connect(QRadioButton_1, SIGNAL(clicked()), SLOT(slotRadioButtonClicked()));
	connect(QRadioButton_2, SIGNAL(clicked()), SLOT(slotRadioButtonClicked()));
	connect(QRadioButton_3, SIGNAL(clicked()), SLOT(slotRadioButtonClicked()));

	connect(QCheckBox_1, SIGNAL(clicked()), SLOT(slotCheckBox_1()));
	connect(QCheckBox_2, SIGNAL(clicked()), SLOT(slotCheckBox_2()));
	connect(QCheckBox_3, SIGNAL(clicked()), SLOT(slotCheckBox_3()));

	connect(QSpinBox_1, SIGNAL(valueChanged(int)), SLOT(slotCheckBox_1()));
	connect(QSpinBox_2, SIGNAL(valueChanged(int)), SLOT(slotCheckBox_2()));
	connect(QSpinBox_3, SIGNAL(valueChanged(int)), SLOT(slotCheckBox_3()));

	connect(QCheckBox_4, SIGNAL(clicked()), SLOT(slotEnable()));

	QCheckBox_4 -> setChecked(group -> scheduleEnabled());
	slotEnable();
	setSchedule(group);
	scheduleToWidget();
}

ScheduleWidget::~ScheduleWidget(){
}

void ScheduleWidget::scheduleToGroup(){
	// it's important to set day cycles first!!!! Otherwise
	group -> schedule() -> setDayCycle (schedule -> dayCycle());
	group -> schedule() -> setHourCycle (schedule -> hourCycle());
	group -> schedule() -> setMinuteCycle (schedule -> minuteCycle());
	group -> schedule() -> setDayList (schedule -> dayList());
	group -> schedule() -> setHourList (schedule -> hourList());
	group -> schedule() -> setMinuteList (schedule -> minuteList());
	group -> setScheduleEnabled( QCheckBox_4 -> isChecked());
	group -> setAction((action)QComboBox_1 -> currentItem());
}

void ScheduleWidget::slotAddClicked(){
	if (QRadioButton_1 -> isChecked()){
		QString s(QSpinBox_1 -> text());
		int i = s.toInt();
		if (!QCheckBox_1 -> isChecked()){
			if (schedule -> inDayList(i))
				schedule -> delDay(i);
			else
				schedule -> addDay(i);
		}
		if (QCheckBox_1 -> isChecked()){
			if (schedule -> dayCycle() == i)
				schedule -> setDayCycle( 0);
			else
				schedule -> setDayCycle(i);
		}
	}
	if (QRadioButton_2 -> isChecked()){
		QString s(QSpinBox_2 -> text());
		int i = s.toInt();
		if (!QCheckBox_2 -> isChecked()){
			if (schedule -> inHourList(i))
				schedule -> delHour(i);
			else
				schedule -> addHour(i);
		}
		if (QCheckBox_2 -> isChecked()){
			if (schedule -> hourCycle() == i)
				schedule -> setHourCycle( 0);
			else
				schedule -> setHourCycle(i);
		}
	}
	if (QRadioButton_3 -> isChecked()){
		QString s(QSpinBox_3 -> text());
		int i = s.toInt();
		if (!QCheckBox_3 -> isChecked()){
			if (schedule -> inMinuteList(i))
				schedule -> delMinute(i);
			else
				schedule -> addMinute(i);
		}
		if (QCheckBox_3 -> isChecked()){
			if (schedule -> minuteCycle() == i)
				schedule -> setMinuteCycle( 0);
			else
				schedule -> setMinuteCycle(i);
		}
	}
	scheduleToWidget();
}

void ScheduleWidget::scheduleToWidget(){
	QString d,n;

	QLabel_1 -> setText("");
	QLabel_2 -> setText("");
	QLabel_3 -> setText("");

	if (schedule -> dayCycle() != 0){
		n.setNum(schedule -> dayCycle());
		d += "every " + n;
		if (schedule -> dayList().count() > 0)
			d += ", ";
	}
	for (unsigned int i = 0; i < schedule -> dayList().count(); i++){
		n.setNum(*schedule -> dayList().at(i));
		if ( i > 0)
			d += ", ";
		d += n;
	}
	QLabel_1 -> setText(d);
	QToolTip::add(QLabel_1, d);
	d = n = "";
	if (schedule -> hourCycle() != 0){
		n.setNum(schedule -> hourCycle());
		d += "every " + n;
		if (schedule -> hourList().count() > 0)
			d += ", ";
	}
	for (unsigned int i = 0; i < schedule -> hourList().count(); i++){
		n.setNum(*schedule -> hourList().at(i));
		if ( i > 0)
			d += ", ";
		d += n;
	}
	QLabel_2 -> setText(d);
	QToolTip::add(QLabel_2, d);
	d = n = "";
	if (schedule -> minuteCycle() != 0){
		n.setNum(schedule -> minuteCycle());
		d += "every " + n;
		if (schedule -> minuteList().count() > 0)
			d += ", ";
	}
	for (unsigned int i = 0; i < schedule -> minuteList().count(); i++){
		n.setNum(*schedule -> minuteList().at(i));
		if ( i > 0)
			d += ", ";
		d += n;
	}
	QLabel_3 -> setText(d);
	QToolTip::add(QLabel_3, d);
}

void ScheduleWidget::slotRadioButtonClicked(){
	QCheckBox_1 -> setChecked(false);
	QCheckBox_2 -> setChecked(false);
	QCheckBox_3 -> setChecked(false);
}

void ScheduleWidget::slotCheckBox_1(){
	QRadioButton_1 -> setChecked(true);
}

void ScheduleWidget::slotCheckBox_2(){
	QRadioButton_2 -> setChecked(true);
}

void ScheduleWidget::slotCheckBox_3(){
	QRadioButton_3 -> setChecked(true);
}

void ScheduleWidget::slotClearList(){
	if (QRadioButton_1 -> isChecked()){
		schedule -> clearDayList();
		schedule -> setDayCycle(0);
	}
	if (QRadioButton_2 -> isChecked()){
		schedule -> clearHourList();
		schedule -> setHourCycle(0);
	}
	if (QRadioButton_3 -> isChecked()){
		schedule -> clearMinuteList();
		schedule -> setMinuteCycle(0);
	}
	scheduleToWidget();
}

void ScheduleWidget::slotEnable(){
	bool b;
	if (QCheckBox_4 -> isChecked())
		b = true;
	else
		b = false;
	QComboBox_1 -> setEnabled(b);
	QRadioButton_1 -> setEnabled(b);
	QRadioButton_2 -> setEnabled(b);
	QRadioButton_3 -> setEnabled(b);

	QCheckBox_1 -> setEnabled(b);
	QCheckBox_2 -> setEnabled(b);
	QCheckBox_3 -> setEnabled(b);
	QSpinBox_1 -> setEnabled(b);
	QSpinBox_2 -> setEnabled(b);
	QSpinBox_3 -> setEnabled(b);
	QPushButton_1 -> setEnabled(b);
	QPushButton_2 -> setEnabled(b);
}

QString ScheduleWidget::error(){
	QString s;
	s = QString::null;
	if (QCheckBox_4 -> isChecked()){
		if (schedule -> dayList().count() == 0 & schedule -> dayCycle() == 0 )
			s = i18n("The day list is empty. Add one or more days");
		if (schedule -> hourList().count() == 0 & schedule -> hourCycle() == 0)
			s = i18n("The hour list is empty. Add one or more hours");
		if (schedule -> minuteList().count() == 0 & schedule -> minuteCycle() == 0)
			s = i18n("The minute list is empty. Add one or more minutes");
	}
	return s;
}

void ScheduleWidget::setSchedule(FileGroupExt * g){
	schedule -> setDayList(g -> schedule() -> dayList());
	schedule -> setHourList(g -> schedule() -> hourList());
	schedule -> setMinuteList(g -> schedule() -> minuteList());
	schedule -> setDayCycle( g -> schedule() -> dayCycle());
	schedule -> setHourCycle( g -> schedule() -> hourCycle());
	schedule -> setMinuteCycle( g -> schedule() -> minuteCycle());
}

