/***************************************************************************
                          udgeditfiles.cpp  -  description
                             -------------------
    begin                : Fri Mar 24 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "udgeditfiles.h"
#include <stdlib.h>
#include <kapp.h>
#include <kfiledialog.h>


UDGEditFiles::UDGEditFiles(UDG * g, QWidget *parent, const char *name) : QWidget(parent,name){
	initDialog();
 	QListView_1 -> addColumn(i18n("File"),120);
	QListView_1 -> addColumn(i18n("Folder"),250);
	QListView_1 -> setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	groupToEditor(g);
	emptyGroup = false;
	connect(QPushButton_1, SIGNAL(clicked()), SLOT(slotClear()));
	connect(QPushButton_2, SIGNAL(clicked()), SLOT(slotAdd()));
}

UDGEditFiles::~UDGEditFiles(){
}

void UDGEditFiles::groupToEditor(UDG * g){
	u = g;
	QListView_1 -> clear();
	for (unsigned int i = 0; i < u -> permanent -> count(); i++){
		QFileInfo f(u -> permanent -> at(i));
		new QListViewItem(QListView_1, f.fileName(), f.dirPath());
	}
}

void UDGEditFiles::editorToGroup(){
	if (emptyGroup)
		u -> empty();
	QListViewItem * item = QListView_1 -> firstChild();
	u -> permanent -> clear();
	while (item != 0L){
		QString s(item -> text(1));
		s += "/";
		s += item -> text(0);
		u -> permanent -> append(s);
		item = item -> nextSibling();
	}
}

void UDGEditFiles::slotAdd(){
	QString s(KFileDialog::getOpenFileName(getenv("HOME")));
	if (s != 0L){
		QFileInfo f(s);
		new QListViewItem(QListView_1, f.fileName(), f.dirPath());
		emptyGroup = true;
	}
}

void UDGEditFiles::slotClear(){
	emptyGroup = true;
	QListView_1 -> clear();
}