/***************************************************************************
                          restorewizard.cpp  -  description
                             -------------------
    begin                : Sun Feb 11 2001
    copyright            : (C) 2001 by Arjan Buursink
    email                : buursink@wanadoo.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcombobox.h>
#include <qdir.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qprogressbar.h>
#include <qstringlist.h>
#include <qradiobutton.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kmessagebox.h>

#include "abprocess.h"
#include "info.h"
#include "restorewizard.h"

RestoreWizard::RestoreWizard() : RestoreBase(0,0,true) {
	accepted = false;
	setNextEnabled(page,false);
	finishButton() -> setText(i18n("Restore"));
	setFinishEnabled(page_3, true);
	tar = new ABProcess("tar");
	connect(tar,SIGNAL(processExited(KProcess *)),SLOT(slotTarExited()));

	// read archive folders
  config = KGlobal::config();
  config -> setGroup("Archives");
 	config -> readListEntry("Folders",archiveDirs);
	archiveDirs.setAutoDelete(true);
	if (archiveDirs.count() == 0){
		archiveDirs.insert(0,defaultArchiveDir());
		addArchives(defaultArchiveDir());
	}
	ComboBox1 -> insertStrList(&archiveDirs);
  ComboBox1 -> setCurrentItem(0);
	QString s(config -> readEntry("Current Folder"));
	if (s != QString(""))
		addArchives(s);
}

RestoreWizard::~RestoreWizard(){
	delete tar;
}

void RestoreWizard::slotArchiveSelected(QListViewItem* i){
	setCursor(waitCursor);
	nextButton() -> setEnabled(false);
	enableItems(ListView1,false);
	tarExited = false;
	LineEdit1 -> setText(i -> text(5));
	ListView2 -> clear();
	arch = i -> text(4);
	tar -> clearArguments();
	*tar << "tar";
	*tar << "ztf";
	*tar << archive();
	tar -> init();
	tar -> start(KProcess::NotifyOnExit, KProcess::AllOutput);
	KSimpleConfig cfg(QString(i -> text(4)) + ".info");
	QStrList sl;
	cfg.readListEntry("Files",sl);
	QString t;
	for (uint i=0; i < sl.count(); i++){
			t += sl.at(i);
		if (i < sl.count() - 1)
			t += ", ";
	}
	if (sl.count() == 10)
		t += ",...";
	else
		t += ".";
	TextLabel2 -> setText(t);
}

void RestoreWizard::accept(){
	bool go = true;
	if (go && numSelected() == 0){
		go = false;
		KMessageBox::information(0,i18n("Please select one or more files"));
	}
	if (go && overWrite() > 0){
		QString txt(i18n("Are you sure you want to overwrite "));
		QString n;
		n.setNum(overWrite());
		txt += n;
		txt += i18n(" existing file(s)?");
		if (KMessageBox::questionYesNo(0,txt) == KMessageBox::No)
			go = false;
	}
	if (go){
		accepted = true;
		cancelButton() -> setText(i18n("Close"));
		int nf = ListView2 -> childCount();
		tar -> init();
		tar -> clearArguments();
		*tar << "tar";
		*tar << "zxvf";
		*tar << archive();
		*tar << "-C";
		*tar << LineEdit1 -> text();
		if (RadioButton2 -> isChecked()){
			nf = 0;
			QListViewItem * item = ListView2 -> firstChild();
			while (item != 0){
				if (item -> isSelected()){
					*tar << QString(item -> text(1)) + "/" + item -> text(0);
					nf++;
				}
				item = item -> itemBelow();
			}
		}
		progress = new ButtonLabelWidget3();
		progress -> show();
		progress -> ProgressBar1 -> setTotalSteps(nf);
		connect(tar, SIGNAL(receivedOutput(int,QString)), progress, SLOT(slotProgress(int,QString)));
		tar -> start(KProcess::NotifyOnExit,KProcess::AllOutput);
	}
}

void RestoreWizard::addArchives(const QString s){
	ComboBox1 -> setCurrentItem(archiveDirs.find(s));
  config -> setGroup("Archives");
	config -> writeEntry("Current Folder",s);
	ListView1 -> clear();
	QString s_1,s_2, s_3, s_4;
	QString fn,tp;
	QDir d(s);
	QStringList * l = new QStringList(d.entryList());
	KIconLoader icnl;
	for (unsigned int i = 0; i < l -> count(); i++){
		QFileInfo fi(s + *l -> at(i));
		if (fi.fileName().right(5) == ".info"){
			KSimpleConfig cfg(fi.absFilePath());
			if (cfg.readBoolEntry("Archive"))
				tp = i18n("Archive");
			else
				tp = i18n("Backup");
			fn = s + fi.fileName().left(fi.fileName().length() - 5);
			QFileInfo fi_2(fn);
			QString n;
			n.setNum(cfg.readNumEntry("Number of Files"));
			QListViewItem *item = new QListViewItem(
				ListView1," " + cfg.readEntry("Name"),
					n,
					tp,
					fi_2.lastModified().toString(),
					fn,
					cfg.readEntry("Archive Root"));
			QPixmap p(icnl.loadIcon(QString(cfg.readEntry("Icon")), KIcon::Small));
			item -> setPixmap(0,p);
		}
	}
	delete l;
}

void RestoreWizard::slotBrowseArchiveFolder(){
	QString s(KFileDialog::getExistingDirectory());
	if ( s != NULL){
		if (archiveDirs.find(s) == -1){
			archiveDirs.insert(0,s);
			ComboBox1 -> insertItem(s,0);
			while (archiveDirs.count() > 10)
				archiveDirs.removeLast();
		  KConfig * cfg = KGlobal::config();
		  cfg -> setGroup("Archives");
			cfg -> writeEntry("Folders",archiveDirs);
			cfg -> sync();
		}
		while (ComboBox1 -> count() > 10)
			ComboBox1 -> removeItem(ComboBox1 -> count()-1);
		addArchives(s);
	}
}

void RestoreWizard::slotBrowseRestoreFolder(){
	LineEdit1 -> setText(KFileDialog::getExistingDirectory());
	slotCheckExistence();
}

void RestoreWizard::slotCheckExistence(){
	QListViewItem * item = ListView2 -> firstChild();
  KIconLoader icnl;
	while (item != 0 ){
		if (fileExists(item))
			item -> setPixmap(0,QPixmap(icnl.loadIcon("remove",KIcon::Small)));
		else
			item -> setPixmap(0,QPixmap(icnl.loadIcon("ok",KIcon::Small)));
		item = item -> itemBelow();
	}
}

void RestoreWizard::slotChangeArchiveFolder(int i){
	QString s(ComboBox1 -> text(i));
	addArchives(s);
}

void RestoreWizard::slotDeleteArchive(){
	if (ListView1 -> currentItem() != 0){
		if (KMessageBox::questionYesNo(0,i18n("Are you sure you want to delete this Archive?")) == KMessageBox::Yes){
			QString c("rm -f'");
			c += ListView1 -> currentItem() -> text(4) + QString("'");
			c += " '" + QString(ListView1 -> currentItem() -> text(4)) + ".info'";
			system(c);
			delete ListView1 -> currentItem();
		}
	}
	else
		KMessageBox::information(0,i18n("Select an archive first"));
}

void RestoreWizard::enableItems(QListView * l, bool b){
	l -> setEnabled(b);
	QListViewItem *item = l -> firstChild();
	while (item != 0L){
		item -> setSelectable(b);
		item = item -> nextSibling();
	}
}

void RestoreWizard::slotTarExited(){
	//which TAR has been exited? Look to the variable accepted
	if (accepted){
		delete progress;
		PushButton6 -> setEnabled(true);
		setFinishEnabled(page_3, false);
		QList<ABProcess> * pl = new QList<ABProcess>;
		pl -> append(tar);
		QStrList *tl = new QStrList;
		tl -> append(i18n("Restore archive: "));
		tl ->	append(archive());
		tl -> append("");
		tl -> append(i18n("Restore to folder: "));
		tl -> append(LineEdit1 -> text());
		logView = new LogViewWidget(pl,tl);
		setBackEnabled(page_3,false);
		setNextEnabled(page_3,false);
		if (!pl -> at(0) -> error().isEmpty())
			TextLabel6 -> setText(i18n("Errors occured! See log for more information"));
		else
			TextLabel6 -> setText(i18n("The cleaning ended succesfully."));
		delete pl;
		delete tl;
	}
	else{
		setCursor(ArrowCursor);
		setNextEnabled(page,true);
		enableItems(ListView1, true);
		QFileInfo fi;
	  KIconLoader icnl;
		for (uint i = 0; i < tar -> output -> count(); i++){
			fi = QFileInfo(tar -> output -> at(i));
				new QListViewItem(ListView2, fi.fileName(),fi.dirPath());
		}
		slotCheckExistence();
		tarExited = true;
		RadioButton1 -> setChecked(true);
		slotYesClicked();
	}
}

void RestoreWizard::slotYesClicked(){
	PushButton4 -> setEnabled(false);
	PushButton5 -> setEnabled(false);
	slotDeSelectAll();
	enableItems(ListView2,false);
}

void RestoreWizard::slotNoClicked(){
	PushButton4 -> setEnabled(true);
	PushButton5 -> setEnabled(true);
	slotDeSelectAll();
	enableItems(ListView2, true);
}

bool RestoreWizard::fileExists(QListViewItem * i){
	QFileInfo fi(QString(LineEdit1 -> text()) + i -> text(1) + "/" + i -> text(0));
	bool b = fi.exists();
	return b;
}

void RestoreWizard::slotSelectAll(){
	QListViewItem *i = ListView2 -> firstChild();
	while (i != 0L){
		if (fileExists(i))
			ListView2 -> setSelected(i,false);
		else
			ListView2 -> setSelected(i,true);
		i = i -> itemBelow();
	}
}

void RestoreWizard::slotDeSelectAll(){
	QListViewItem *i = ListView2 -> firstChild();
	while (i != 0L){
		ListView2 -> setSelected(i,false);
		i = i -> itemBelow();
	}
}

unsigned int RestoreWizard::numSelected(){
	unsigned int s = 0;
	if (RadioButton1 -> isChecked())
		s = ListView2 -> childCount();
	else{
		QListViewItem * i = ListView2 -> firstChild();
		while (i != NULL){
			if (i -> isSelected())
				s++;
			i = i -> itemBelow();
		}
	}
	return s;
}

int RestoreWizard::overWrite(){
	int i = 0;
	QListViewItem * item = ListView2 -> firstChild();
	while (item != 0 ){
		if (fileExists(item) & (item -> isSelected()| RadioButton1 -> isChecked()) )
			i++;
		item = item -> itemBelow();
	}
	return i;
}

void RestoreWizard::slotViewLog(){
	logView -> show();
}
